/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import gnu.gcj.convert.BytesToCharsetAdaptor;
import gnu.gcj.convert.BytesToUnicode;
import java.io.BufferedInputStream;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;

public class InputStreamReader
extends Reader {
    BufferedInputStream in;
    char[] work;
    int wpos;
    int wcount;
    BytesToUnicode converter;

    public InputStreamReader(InputStream in) {
        this(in, BytesToUnicode.getDefaultDecoder());
    }

    public InputStreamReader(InputStream in, String encoding_name) throws UnsupportedEncodingException {
        this(in, BytesToUnicode.getDecoder(encoding_name));
    }

    public InputStreamReader(InputStream in, Charset charset) {
        this(in, new BytesToCharsetAdaptor(charset));
    }

    public InputStreamReader(InputStream in, CharsetDecoder decoder) {
        this(in, new BytesToCharsetAdaptor(decoder));
    }

    private InputStreamReader(InputStream in, BytesToUnicode decoder) {
        this.in = in instanceof BufferedInputStream ? (BufferedInputStream)in : new BufferedInputStream(in);
        this.lock = in;
        this.converter = decoder;
        this.converter.setInput(this.in.buf, 0, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.in != null) {
                this.in.close();
            }
            this.in = null;
            this.work = null;
            this.wcount = 0;
            this.wpos = 0;
        }
    }

    public String getEncoding() {
        return this.in != null ? this.converter.getName() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean ready() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            block5: {
                if (this.in == null) {
                    throw new IOException("Stream closed");
                }
                if (this.wpos >= this.wcount) break block5;
                return true;
            }
            return this.in.available() > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(char[] buf, int offset, int length) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            block7: {
                if (this.in == null) {
                    throw new IOException("Stream closed");
                }
                if (length != 0) break block7;
                return 0;
            }
            int wavail = this.wcount - this.wpos;
            if (wavail <= 0) {
                return this.refill(buf, offset, length);
            }
            if (length > wavail) {
                length = wavail;
            }
            System.arraycopy(this.work, this.wpos, buf, offset, length);
            this.wpos += length;
            return length;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int read() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.in == null) {
                throw new IOException("Stream closed");
            }
            int wavail = this.wcount - this.wpos;
            if (wavail <= 0) {
                int count;
                this.wcount = 0;
                this.wpos = 0;
                if (this.work == null) {
                    this.work = new char[100];
                }
                if ((count = this.refill(this.work, 0, this.work.length)) == -1) {
                    return -1;
                }
                this.wcount += count;
            }
            return this.work[this.wpos++];
        }
    }

    private int refill(char[] buf, int offset, int length) throws IOException {
        int count;
        while (true) {
            boolean r;
            boolean bl = r = this.in.pos < this.in.count || this.in.refill();
            if (!r) {
                return -1;
            }
            this.converter.setInput(this.in.buf, this.in.pos, this.in.count);
            count = this.converter.read(buf, offset, length);
            if (count == 0 && this.converter.inpos == this.in.pos) {
                this.in.mark(this.in.count);
                if (!this.in.refill()) {
                    throw new CharConversionException();
                }
                this.in.reset();
                continue;
            }
            this.in.skip(this.converter.inpos - this.in.pos);
            if (count > 0) break;
        }
        return count;
    }
}

