/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.validation.datatype;

import gnu.xml.validation.datatype.AtomicSimpleType;
import gnu.xml.validation.datatype.TypeLibrary;
import javax.xml.namespace.QName;
import org.relaxng.datatype.DatatypeException;
import org.relaxng.datatype.ValidationContext;

final class GYearMonthType
extends AtomicSimpleType {
    static final int[] CONSTRAINING_FACETS = new int[]{4, 5, 6, 7, 8, 10, 9};

    GYearMonthType() {
        super(new QName("http://www.w3.org/2001/XMLSchema", "gYearMonth"), TypeLibrary.ANY_SIMPLE_TYPE);
    }

    public int[] getConstrainingFacets() {
        return CONSTRAINING_FACETS;
    }

    public void checkValid(String value, ValidationContext context) throws DatatypeException {
        super.checkValid(value, context);
        int len = value.length();
        int state = 0;
        int start = 0;
        int i = 0;
        while (i < len) {
            char c = value.charAt(i);
            if (c == '-' && i == 0) {
                ++start;
            } else if (c < '0' || c > '9') {
                switch (state) {
                    case 0: {
                        if (c == '-') {
                            String year = value.substring(start, i);
                            if (year.length() < 4 || Integer.parseInt(year) == 0) {
                                throw new DatatypeException(i, "illegal GYear value");
                            }
                            state = 1;
                            start = i + 1;
                            break;
                        }
                    }
                    default: {
                        throw new DatatypeException(i, "illegal GYear value");
                    }
                }
            }
            ++i;
        }
        switch (state) {
            case 1: {
                if (len - start == 2) break;
                throw new DatatypeException("illegal GYear value");
            }
            default: {
                throw new DatatypeException("illegal GYear value");
            }
        }
    }

    public Object createValue(String literal, ValidationContext context) {
        try {
            int offset = 5;
            if (literal.charAt(0) == '-') {
                ++offset;
            }
            GYearMonth ret = new GYearMonth();
            ret.year = Integer.parseInt(literal.substring(0, offset));
            ret.month = Integer.parseInt(literal.substring(offset + 1));
            return ret;
        }
        catch (Exception exception) {
            return null;
        }
    }

    static class GYearMonth
    implements Comparable {
        int year;
        int month;

        GYearMonth() {
        }

        public int hashCode() {
            return this.year * 31 + this.month;
        }

        public boolean equals(Object other) {
            if (other instanceof GYearMonth) {
                GYearMonth gmy = (GYearMonth)other;
                return gmy.year == this.year && gmy.month == this.month;
            }
            return false;
        }

        public int compareTo(Object other) {
            if (other instanceof GYearMonth) {
                GYearMonth gmy = (GYearMonth)other;
                if (gmy.year == this.year) {
                    if (gmy.month == this.month) {
                        return 0;
                    }
                    return this.month < gmy.month ? -1 : 1;
                }
                return this.year < gmy.year ? -1 : 1;
            }
            return 0;
        }
    }
}

