/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.swing.text.html.parser.support.low;

import gnu.javax.swing.text.html.parser.support.low.Location;

public class Buffer {
    public static int INITIAL_SIZE = 2048;
    public boolean n_seen;
    public boolean r_seen;
    char[] chr = new char[INITIAL_SIZE];
    int[] line = new int[INITIAL_SIZE];
    int[] position = new int[INITIAL_SIZE];
    int current_line = 0;
    int length;

    public Buffer() {
    }

    public Buffer(String content) {
        int i = 0;
        while (i < content.length()) {
            this.append(content.charAt(i), i);
            ++i;
        }
    }

    public void getChars(int srcBegin, int srcEnd, char[] dst, int dstBegin) {
        System.arraycopy(this.chr, srcBegin, dst, dstBegin, srcEnd - srcBegin);
    }

    public String getEndOfLineSequence() {
        if (this.r_seen && this.n_seen) {
            return "\r\n";
        }
        if (this.r_seen) {
            return "\r";
        }
        return "\n";
    }

    public void setLength(int n) {
        this.length = n;
    }

    public Location getLocation(int from, int to) {
        Location l = new Location();
        l.beginLine = this.line[from];
        l.endLine = this.line[to - 1];
        l.startPosition = this.position[from];
        l.endPosition = this.position[to - 1] + 1;
        return l;
    }

    public void append(char c, int pos) {
        if (this.length >= this.chr.length) {
            this.expand();
        }
        this.chr[this.length] = c;
        this.position[this.length] = pos;
        if (c == '\n') {
            if (!this.r_seen) {
                // empty if block
            }
            this.n_seen = true;
        } else if (c == '\r') {
            ++this.current_line;
            this.r_seen = true;
        }
        this.line[this.length] = ++this.current_line;
        ++this.length;
    }

    public char charAt(int i) {
        return this.chr[i];
    }

    public void delete(int from, int to) {
        int len = to - from;
        if (len < 1) {
            throw new AssertionError((Object)("Deleting " + from + " till " + to));
        }
        int tail = this.length - to;
        System.arraycopy(this.chr, to, this.chr, from, tail);
        System.arraycopy(this.position, to, this.position, from, tail);
        System.arraycopy(this.line, to, this.line, from, tail);
        this.length -= len;
    }

    public void expand() {
        int nSize = 2 * this.chr.length;
        char[] nchr = new char[nSize];
        int[] nposition = new int[nSize];
        int[] nline = new int[nSize];
        System.arraycopy(this.chr, 0, nchr, 0, this.chr.length);
        System.arraycopy(this.position, 0, nposition, 0, this.position.length);
        System.arraycopy(this.line, 0, nline, 0, this.line.length);
        this.chr = nchr;
        this.position = nposition;
        this.line = nline;
    }

    public int length() {
        return this.length;
    }

    public void reset() {
        this.setLength(0);
        this.n_seen = false;
        this.r_seen = false;
    }

    public String toString() {
        return new String(this.chr, 0, this.length);
    }
}

