/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.imageio.bmp;

import gnu.javax.imageio.bmp.BMPException;
import java.awt.Dimension;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.imageio.IIOImage;
import javax.imageio.ImageWriteParam;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;

public class BMPInfoHeader {
    protected int biSize;
    protected int biWidth;
    protected int biHeight;
    protected short biPlanes;
    protected short biBitCount;
    protected int biCompression;
    protected int biSizeImage;
    protected int biXPelsPerMeter;
    protected int biYPelsPerMeter;
    protected int biClrUsed;
    protected int biClrImportant;
    public static final int SIZE = 40;
    public static final int BI_RGB = 0;
    public static final int BI_RLE8 = 1;
    public static final int BI_RLE4 = 2;
    public static final int BI_BITFIELDS = 3;

    public BMPInfoHeader(ImageInputStream in) throws IOException, BMPException {
        byte[] data = new byte[40];
        if (in.read(data) != 40) {
            throw new IOException("Couldn't read header.");
        }
        ByteBuffer buf = ByteBuffer.wrap(data);
        buf.order(ByteOrder.LITTLE_ENDIAN);
        int n = buf.getInt();
        if (n != 40) {
            throw new BMPException("Invalid BITMAPINFOHEADER size: " + n);
        }
        this.biWidth = buf.getInt();
        this.biHeight = buf.getInt();
        this.biPlanes = buf.getShort();
        this.setBitCount(buf.getShort());
        this.setCompression(buf.getInt());
        this.biSizeImage = buf.getInt();
        this.biXPelsPerMeter = buf.getInt();
        this.biYPelsPerMeter = buf.getInt();
        this.biClrUsed = buf.getInt();
        this.biClrImportant = buf.getInt();
    }

    public BMPInfoHeader(ImageOutputStream out, IIOImage im, ImageWriteParam param) throws IOException {
        RenderedImage img = im.getRenderedImage();
        ColorModel cMod = img.getColorModel();
        this.biSize = 40;
        this.biWidth = img.getWidth();
        this.biHeight = img.getHeight();
        this.biPlanes = 1;
        if (param != null && param.canWriteCompressed()) {
            String compType = param.getCompressionType();
            if (compType.equals("BI_RLE8")) {
                this.biCompression = 1;
                this.biBitCount = (short)8;
            } else if (compType.equals("BI_RLE4")) {
                this.biCompression = 2;
                this.biBitCount = (short)4;
            } else {
                this.biCompression = 0;
                this.biBitCount = (short)cMod.getPixelSize();
            }
        } else {
            this.biBitCount = (short)cMod.getPixelSize();
            this.biCompression = 0;
        }
        this.biXPelsPerMeter = 0;
        this.biYPelsPerMeter = 0;
        this.biClrUsed = 0;
        this.biClrImportant = 0;
        this.biSizeImage = this.biWidth * this.biHeight * 3 + (4 - this.biWidth * 3 % 4) * this.biHeight;
        out.write(this.intToDWord(this.biSize));
        out.write(this.intToDWord(this.biWidth));
        out.write(this.intToDWord(this.biHeight));
        out.write(this.intToWord(this.biPlanes));
        out.write(this.intToWord(this.biBitCount));
        out.write(this.intToDWord(this.biCompression));
        out.write(this.intToDWord(this.biSizeImage));
        out.write(this.intToDWord(this.biXPelsPerMeter));
        out.write(this.intToDWord(this.biYPelsPerMeter));
        out.write(this.intToDWord(this.biClrUsed));
        out.write(this.intToDWord(this.biClrImportant));
    }

    private byte[] intToWord(int val) {
        byte[] b = new byte[]{(byte)(val & 0xFF), (byte)(val >> 8 & 0xFF)};
        return b;
    }

    private byte[] intToDWord(int val) {
        byte[] b = new byte[]{(byte)(val & 0xFF), (byte)(val >> 8 & 0xFF), (byte)(val >> 16 & 0xFF), (byte)(val >> 24 & 0xFF)};
        return b;
    }

    public void setBitCount(short bitcount) throws BMPException {
        switch (bitcount) {
            case 1: 
            case 4: 
            case 8: 
            case 16: 
            case 24: 
            case 32: {
                this.biBitCount = bitcount;
                break;
            }
            default: {
                throw new BMPException("Invalid number of bits per pixel: " + bitcount);
            }
        }
    }

    public short getBitCount() {
        return this.biBitCount;
    }

    public void setCompression(int compression) throws BMPException {
        switch (compression) {
            case 1: {
                if (this.getBitCount() != 8) {
                    throw new BMPException("Invalid number of bits per pixel.");
                }
                this.biCompression = compression;
                break;
            }
            case 2: {
                if (this.getBitCount() != 4) {
                    throw new BMPException("Invalid number of bits per pixel.");
                }
                this.biCompression = compression;
                break;
            }
            case 0: 
            case 3: {
                this.biCompression = compression;
                break;
            }
            default: {
                throw new BMPException("Unknown bitmap compression type.");
            }
        }
    }

    public int getNumberOfPaletteEntries() {
        if (this.biClrUsed == 0) {
            switch (this.biBitCount) {
                case 1: {
                    return 2;
                }
                case 4: {
                    return 16;
                }
                case 8: {
                    return 256;
                }
            }
            return 0;
        }
        return this.biClrUsed;
    }

    public int getCompression() {
        return this.biCompression;
    }

    public Dimension getSize() {
        return new Dimension(this.biWidth, this.biHeight);
    }

    public int getWidth() {
        return this.biWidth;
    }

    public int getHeight() {
        return this.biHeight;
    }

    public void setSize(Dimension d) {
        this.biWidth = (int)d.getWidth();
        this.biHeight = (int)d.getHeight();
    }
}

