/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt;

import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferDouble;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;

public final class Buffers {
    public static DataBuffer createBuffer(int dataType, Object data, int size) {
        if (data == null) {
            return Buffers.createBuffer(dataType, size, 1);
        }
        return Buffers.createBufferFromData(dataType, data, size);
    }

    public static DataBuffer createBuffer(int dataType, int size) {
        return Buffers.createBuffer(dataType, size, 1);
    }

    public static DataBuffer createBuffer(int dataType, int size, int numBanks) {
        switch (dataType) {
            case 0: {
                return new DataBufferByte(size, numBanks);
            }
            case 2: {
                return new DataBufferShort(size, numBanks);
            }
            case 1: {
                return new DataBufferUShort(size, numBanks);
            }
            case 3: {
                return new DataBufferInt(size, numBanks);
            }
            case 4: {
                return new DataBufferFloat(size, numBanks);
            }
            case 5: {
                return new DataBufferDouble(size, numBanks);
            }
        }
        throw new UnsupportedOperationException();
    }

    public static DataBuffer createBufferFromData(int dataType, Object data, int size) {
        switch (dataType) {
            case 0: {
                return new DataBufferByte((byte[])data, size);
            }
            case 2: {
                return new DataBufferShort((short[])data, size);
            }
            case 1: {
                return new DataBufferUShort((short[])data, size);
            }
            case 3: {
                return new DataBufferInt((int[])data, size);
            }
            case 4: {
                return new DataBufferFloat((float[])data, size);
            }
            case 5: {
                return new DataBufferDouble((double[])data, size);
            }
        }
        throw new UnsupportedOperationException();
    }

    public static Object getData(DataBuffer buffer) {
        return Buffers.getData(buffer, 0, null, 0, buffer.getSize());
    }

    public static Object getData(DataBuffer src, int srcOffset, Object dest, int dstOffset, int length) {
        switch (src.getDataType()) {
            case 0: {
                if (dest == null) {
                    dest = new byte[length + dstOffset];
                }
                int i = 0;
                while (i < length) {
                    ((byte[])dest)[i + dstOffset] = (byte)src.getElem(i + srcOffset);
                    ++i;
                }
                break;
            }
            case 5: {
                if (dest == null) {
                    dest = new double[length + dstOffset];
                }
                int i = 0;
                while (i < length) {
                    ((double[])dest)[i + dstOffset] = src.getElemDouble(i + srcOffset);
                    ++i;
                }
                break;
            }
            case 4: {
                if (dest == null) {
                    dest = new float[length + dstOffset];
                }
                int i = 0;
                while (i < length) {
                    ((float[])dest)[i + dstOffset] = src.getElemFloat(i + srcOffset);
                    ++i;
                }
                break;
            }
            case 3: {
                if (dest == null) {
                    dest = new int[length + dstOffset];
                }
                int i = 0;
                while (i < length) {
                    ((int[])dest)[i + dstOffset] = src.getElem(i + srcOffset);
                    ++i;
                }
                break;
            }
            case 1: 
            case 2: {
                if (dest == null) {
                    dest = new short[length + dstOffset];
                }
                int i = 0;
                while (i < length) {
                    ((short[])dest)[i + dstOffset] = (short)src.getElem(i + srcOffset);
                    ++i;
                }
                break;
            }
            case 32: {
                throw new ClassCastException("Unknown data buffer type");
            }
        }
        return dest;
    }

    public static int smallestAppropriateTransferType(int bits) {
        if (bits <= 8) {
            return 0;
        }
        if (bits <= 16) {
            return 1;
        }
        if (bits <= 32) {
            return 3;
        }
        return 32;
    }
}

