/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.jdwp.event;

import gnu.classpath.jdwp.Jdwp;
import gnu.classpath.jdwp.VMVirtualMachine;
import gnu.classpath.jdwp.event.Event;
import gnu.classpath.jdwp.event.EventRequest;
import gnu.classpath.jdwp.exception.InvalidEventTypeException;
import gnu.classpath.jdwp.exception.JdwpException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;

public class EventManager {
    private static EventManager _instance = null;
    private Hashtable _requests = new Hashtable();

    public static EventManager getDefault() {
        if (_instance == null) {
            _instance = new EventManager();
        }
        return _instance;
    }

    private EventManager() {
        this._requests.put(new Byte(1), new Hashtable());
        this._requests.put(new Byte(2), new Hashtable());
        this._requests.put(new Byte(3), new Hashtable());
        this._requests.put(new Byte(4), new Hashtable());
        this._requests.put(new Byte(5), new Hashtable());
        this._requests.put(new Byte(6), new Hashtable());
        this._requests.put(new Byte(7), new Hashtable());
        this._requests.put(new Byte(8), new Hashtable());
        this._requests.put(new Byte(9), new Hashtable());
        this._requests.put(new Byte(10), new Hashtable());
        this._requests.put(new Byte(20), new Hashtable());
        this._requests.put(new Byte(21), new Hashtable());
        this._requests.put(new Byte(40), new Hashtable());
        this._requests.put(new Byte(41), new Hashtable());
        this._requests.put(new Byte(90), new Hashtable());
        this._requests.put(new Byte(99), new Hashtable());
        try {
            byte sp = Jdwp.suspendOnStartup() ? (byte)1 : 0;
            this.requestEvent(new EventRequest(0, 90, sp));
            this.requestEvent(new EventRequest(0, 99, 0));
        }
        catch (JdwpException jdwpException) {}
    }

    public EventRequest[] getEventRequests(Event event) {
        ArrayList<EventRequest> interestedEvents = new ArrayList<EventRequest>();
        Byte kind = new Byte(event.getEventKind());
        Hashtable requests = (Hashtable)this._requests.get(kind);
        if (requests == null) {
            throw new IllegalArgumentException("invalid event kind: " + kind);
        }
        for (EventRequest request : requests.values()) {
            if (!request.matches(event)) continue;
            interestedEvents.add(request);
        }
        EventRequest[] r = new EventRequest[interestedEvents.size()];
        interestedEvents.toArray(r);
        return r;
    }

    public void requestEvent(EventRequest request) throws JdwpException {
        Byte kind = new Byte(request.getEventKind());
        Hashtable requests = (Hashtable)this._requests.get(kind);
        if (requests == null) {
            throw new InvalidEventTypeException(request.getEventKind());
        }
        VMVirtualMachine.registerEvent(request);
        requests.put(new Integer(request.getId()), request);
    }

    public void deleteRequest(byte kind, int id) throws JdwpException {
        Hashtable requests = (Hashtable)this._requests.get(new Byte(kind));
        if (requests == null) {
            throw new IllegalArgumentException("invalid event kind: " + kind);
        }
        Integer iid = new Integer(id);
        EventRequest request = (EventRequest)requests.get(iid);
        if (request != null) {
            VMVirtualMachine.unregisterEvent(request);
            requests.remove(iid);
        }
    }

    public void clearRequests(byte kind) throws JdwpException {
        Hashtable requests = (Hashtable)this._requests.get(new Byte(kind));
        if (requests == null) {
            throw new IllegalArgumentException("invalid event kind: " + kind);
        }
        VMVirtualMachine.clearEvents(kind);
        requests.clear();
    }

    public EventRequest getRequest(byte kind, int id) {
        Hashtable requests = (Hashtable)this._requests.get(new Byte(kind));
        if (requests == null) {
            throw new IllegalArgumentException("invalid event kind: " + kind);
        }
        return (EventRequest)requests.get(new Integer(id));
    }

    public Collection getRequests(byte kind) {
        Hashtable requests = (Hashtable)this._requests.get(new Byte(kind));
        if (requests == null) {
            throw new IllegalArgumentException("invalid event kind: " + kind);
        }
        return requests.values();
    }
}

