/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JToolTip;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicToolTipUI;

public class MetalToolTipUI
extends BasicToolTipUI {
    public static final int padSpaceBetweenStrings = 12;
    private static MetalToolTipUI instance;
    private boolean isAcceleratorHidden;
    private String acceleratorString;
    private String acceleratorDelimiter;
    private Font acceleratorFont;
    private Color acceleratorForeground;
    private Border activeBorder = UIManager.getBorder("ToolTip.border");
    private Border inactiveBorder = UIManager.getBorder("ToolTip.borderInactive");

    public MetalToolTipUI() {
        this.isAcceleratorHidden = UIManager.getBoolean("ToolTip.hideAccelerator");
        this.acceleratorFont = UIManager.getFont("MenuItem.acceleratorFont");
        this.acceleratorForeground = UIManager.getColor("MenuItem.acceleratorForeground");
        this.acceleratorDelimiter = UIManager.getString("MenuItem.acceleratorDelimiter");
    }

    public static ComponentUI createUI(JComponent component) {
        if (instance == null) {
            instance = new MetalToolTipUI();
        }
        return instance;
    }

    public String getAcceleratorString() {
        return this.acceleratorString;
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        Border existingBorder = c.getBorder();
        if (existingBorder == null || existingBorder instanceof UIResource) {
            if (c.isEnabled()) {
                c.setBorder(this.activeBorder);
            } else {
                c.setBorder(this.inactiveBorder);
            }
        }
    }

    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        if (c.getBorder() instanceof UIResource) {
            c.setBorder(null);
        }
    }

    protected boolean isAcceleratorHidden() {
        return this.isAcceleratorHidden;
    }

    public Dimension getPreferredSize(JComponent c) {
        Dimension d = super.getPreferredSize(c);
        String acc = this.getAcceleratorString();
        if (acc != null && !acc.equals("")) {
            FontMetrics fm = c.getFontMetrics(c.getFont());
            d.width += fm.stringWidth(acc);
        }
        return d;
    }

    public void paint(Graphics g, JComponent c) {
        super.paint(g, c);
    }

    private String fetchAcceleratorString(JComponent c) {
        String result = null;
        if (c instanceof JToolTip) {
            JToolTip toolTip = (JToolTip)c;
            JComponent component = toolTip.getComponent();
            KeyStroke ks = null;
            int mne = 0;
            if (component instanceof JMenuItem) {
                JMenuItem item = (JMenuItem)component;
                ks = item.getAccelerator();
                if (ks == null) {
                    mne = item.getMnemonic();
                }
            } else if (component instanceof AbstractButton) {
                AbstractButton button = (AbstractButton)component;
                mne = button.getMnemonic();
            }
            if (mne > 0) {
                ks = KeyStroke.getKeyStroke(Character.toUpperCase((char)mne), 8, false);
            }
            if (ks != null) {
                result = this.acceleratorToString(ks);
            }
        }
        return result;
    }

    private String acceleratorToString(KeyStroke accelerator) {
        String modifiersText = "";
        int modifiers = accelerator.getModifiers();
        char keyChar = accelerator.getKeyChar();
        int keyCode = accelerator.getKeyCode();
        if (modifiers != 0) {
            modifiersText = String.valueOf(KeyEvent.getKeyModifiersText(modifiers)) + this.acceleratorDelimiter;
        }
        if (keyCode == 0) {
            return String.valueOf(modifiersText) + keyChar;
        }
        return String.valueOf(modifiersText) + KeyEvent.getKeyText(keyCode);
    }
}

