/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.border.Border;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.DesktopIconUI;

public class BasicDesktopIconUI
extends DesktopIconUI {
    private static final int iconSize = 16;
    private static final int iconWidth = 160;
    private static final int iconHeight = 35;
    protected JInternalFrame.JDesktopIcon desktopIcon;
    protected JInternalFrame frame;
    private transient MouseInputListener mouseHandler;
    transient BoundButton button;
    private transient PropertyChangeListener propertyHandler;
    static Icon defaultIcon = new InternalFrameDefaultMenuIcon();

    public static ComponentUI createUI(JComponent c) {
        return new BasicDesktopIconUI();
    }

    public void installUI(JComponent c) {
        if (c instanceof JInternalFrame.JDesktopIcon) {
            this.desktopIcon = (JInternalFrame.JDesktopIcon)c;
            this.desktopIcon.setLayout(new BorderLayout());
            this.frame = this.desktopIcon.getInternalFrame();
            this.installDefaults();
            this.installComponents();
            this.installListeners();
            this.desktopIcon.setOpaque(true);
        }
    }

    public void uninstallUI(JComponent c) {
        this.desktopIcon.setOpaque(false);
        this.uninstallListeners();
        this.uninstallComponents();
        this.uninstallDefaults();
        this.frame = null;
        this.desktopIcon.setLayout(null);
        this.desktopIcon = null;
    }

    protected void installComponents() {
        this.button = new BoundButton(this.frame.getTitle());
        this.button.setHorizontalAlignment(2);
        this.button.setHorizontalTextPosition(11);
        Icon use = this.frame.getFrameIcon();
        if (use == null) {
            use = defaultIcon;
        }
        this.button.setIcon(use);
        this.desktopIcon.add((Component)this.button, 0);
    }

    protected void uninstallComponents() {
        this.desktopIcon.remove(this.button);
        this.button = null;
    }

    protected void installListeners() {
        this.mouseHandler = this.createMouseInputListener();
        this.desktopIcon.addMouseMotionListener(this.mouseHandler);
        this.desktopIcon.addMouseListener(this.mouseHandler);
        this.propertyHandler = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                if (e.getPropertyName().equals("title")) {
                    BasicDesktopIconUI.this.button.setText(BasicDesktopIconUI.this.desktopIcon.getInternalFrame().getTitle());
                } else if (e.getPropertyName().equals("frameIcon")) {
                    Icon use = BasicDesktopIconUI.this.desktopIcon.getInternalFrame().getFrameIcon();
                    if (use == null) {
                        use = defaultIcon;
                    }
                    BasicDesktopIconUI.this.button.setIcon(use);
                }
                BasicDesktopIconUI.this.desktopIcon.revalidate();
                BasicDesktopIconUI.this.desktopIcon.repaint();
            }
        };
        this.frame.addPropertyChangeListener(this.propertyHandler);
        this.button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BasicDesktopIconUI.this.deiconize();
            }
        });
    }

    protected void uninstallListeners() {
        this.frame.removePropertyChangeListener(this.propertyHandler);
        this.propertyHandler = null;
        this.desktopIcon.removeMouseMotionListener(this.mouseHandler);
        this.desktopIcon.removeMouseListener(this.mouseHandler);
    }

    protected void installDefaults() {
        this.desktopIcon.setBorder(new DesktopIconBorder());
    }

    protected void uninstallDefaults() {
        this.desktopIcon.setBorder(null);
    }

    protected MouseInputListener createMouseInputListener() {
        return new MouseInputHandler();
    }

    public Dimension getPreferredSize(JComponent c) {
        return new Dimension(160, 35);
    }

    public Dimension getMinimumSize(JComponent c) {
        return this.getPreferredSize(c);
    }

    public Dimension getMaximumSize(JComponent c) {
        return this.getPreferredSize(c);
    }

    public Insets getInsets(JComponent c) {
        return c.getInsets();
    }

    public void deiconize() {
        try {
            this.frame.setIcon(false);
        }
        catch (PropertyVetoException propertyVetoException) {}
    }

    private class BoundButton
    extends JButton {
        public BoundButton(String title) {
            super(title);
        }

        public Dimension getPreferredSize() {
            Insets insets = BasicDesktopIconUI.this.desktopIcon.getInsets();
            return new Dimension(160 - insets.left - insets.right, 35 - insets.top - insets.bottom);
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }
    }

    private class DesktopIconBorder
    implements Border {
        int left = 10;
        int top;
        int right = this.top = 4;
        int bottom = this.top;

        private DesktopIconBorder() {
        }

        public Insets getBorderInsets(Component c) {
            return new Insets(this.top, this.left, this.bottom, this.right);
        }

        public boolean isBorderOpaque() {
            return true;
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            g.translate(x, y);
            Color saved = g.getColor();
            g.setColor(Color.LIGHT_GRAY);
            g.fillRect(0, 0, this.left, height);
            g.fillRect(0, 0, width, this.top);
            g.fillRect(0, height - this.bottom, width, this.bottom);
            g.fillRect(width - this.right, 0, this.right, height);
            g.setColor(Color.BLACK);
            g.drawRect(0, 0, width - 1, height - 1);
            int fHeight = height / 4;
            int hLeft = this.left / 2;
            g.setColor(Color.BLACK);
            g.fillRect(hLeft, fHeight, 2, 2);
            g.fillRect(hLeft, fHeight * 2, 2, 2);
            g.fillRect(hLeft, fHeight * 3, 2, 2);
            g.setColor(saved);
            g.translate(-x, -y);
        }
    }

    static class InternalFrameDefaultMenuIcon
    implements Icon {
        InternalFrameDefaultMenuIcon() {
        }

        public int getIconHeight() {
            return 16;
        }

        public int getIconWidth() {
            return 16;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.translate(x, y);
            Color saved = g.getColor();
            g.setColor(Color.BLUE);
            g.fillRect(0, 0, 16, 6);
            g.setColor(Color.WHITE);
            g.fillRect(0, 5, 16, 13);
            g.setColor(Color.GRAY);
            g.drawRect(0, 0, 16, 16);
            g.setColor(saved);
            g.translate(-x, -y);
        }
    }

    public class MouseInputHandler
    extends MouseInputAdapter {
        private transient int xOffset;
        private transient int yOffset;
        private transient JDesktopPane pane;

        public void mouseDragged(MouseEvent e) {
            Rectangle b = BasicDesktopIconUI.this.desktopIcon.getBounds();
            this.moveAndRepaint(BasicDesktopIconUI.this.desktopIcon, b.x + e.getX() - this.xOffset, b.y + e.getY() - this.yOffset, b.width, b.height);
        }

        public void mouseMoved(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
            this.xOffset = e.getX();
            this.yOffset = e.getY();
            this.pane = BasicDesktopIconUI.this.frame.getDesktopPane();
            if (this.pane != null) {
                this.pane.getDesktopManager().beginDraggingFrame(BasicDesktopIconUI.this.desktopIcon);
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (this.pane != null) {
                this.pane.getDesktopManager().endDraggingFrame(BasicDesktopIconUI.this.desktopIcon);
            }
            this.xOffset = 0;
            this.yOffset = 0;
        }

        public void moveAndRepaint(JComponent f, int newX, int newY, int newWidth, int newHeight) {
            if (this.pane != null) {
                this.pane.getDesktopManager().dragFrame(f, newX, newY);
            } else {
                BasicDesktopIconUI.this.desktopIcon.setBounds(newX, newY, newWidth, newHeight);
            }
        }
    }
}

