/*
 * Decompiled with CFR 0.152.
 */
package javax.net.ssl;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.security.KeyStore;
import java.security.Security;
import javax.net.SocketFactory;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;

public abstract class SSLSocketFactory
extends SocketFactory {
    private static SSLContext context;

    public static synchronized SocketFactory getDefault() {
        try {
            String s = Security.getProperty("ssl.SocketFactory.provider");
            ClassLoader cl = ClassLoader.getSystemClassLoader();
            if (s != null && cl != null) {
                return (SocketFactory)cl.loadClass(s).newInstance();
            }
        }
        catch (Exception exception) {}
        if (context == null) {
            KeyManager[] km = null;
            TrustManager[] tm = null;
            String kmAlg = KeyManagerFactory.getDefaultAlgorithm();
            String tmAlg = TrustManagerFactory.getDefaultAlgorithm();
            try {
                KeyManagerFactory kmf = KeyManagerFactory.getInstance(kmAlg);
                kmf.init(null, null);
                km = kmf.getKeyManagers();
            }
            catch (Exception exception) {}
            try {
                TrustManagerFactory tmf = TrustManagerFactory.getInstance(tmAlg);
                tmf.init((KeyStore)null);
                tm = tmf.getTrustManagers();
            }
            catch (Exception exception) {}
            try {
                context = SSLContext.getInstance("SSLv3");
                context.init(km, tm, null);
            }
            catch (Exception ex) {
                return new ErrorSocketFactory(new RuntimeException("error instantiating default socket factory: " + ex.toString(), ex));
            }
        }
        try {
            return context.getSocketFactory();
        }
        catch (Exception exception) {
            return new ErrorSocketFactory(new RuntimeException("no SSLSocketFactory implementation available"));
        }
    }

    public abstract Socket createSocket(Socket var1, String var2, int var3, boolean var4) throws IOException;

    public abstract String[] getDefaultCipherSuites();

    public abstract String[] getSupportedCipherSuites();

    private static final class ErrorSocketFactory
    extends SSLSocketFactory {
        private RuntimeException x;

        ErrorSocketFactory(RuntimeException x) {
            this.x = x;
        }

        public Socket createSocket() throws IOException {
            throw (IOException)new IOException().initCause(this.x);
        }

        public Socket createSocket(String host, int port) throws IOException {
            throw (IOException)new IOException().initCause(this.x);
        }

        public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException {
            throw (IOException)new IOException().initCause(this.x);
        }

        public Socket createSocket(InetAddress host, int port) throws IOException {
            throw (IOException)new IOException().initCause(this.x);
        }

        public Socket createSocket(InetAddress hast, int port, InetAddress localHost, int localPort) throws IOException {
            throw (IOException)new IOException().initCause(this.x);
        }

        public String[] getDefaultCipherSuites() {
            throw new RuntimeException(this.x);
        }

        public String[] getSupportedCipherSuites() {
            throw new RuntimeException(this.x);
        }

        public Socket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException {
            throw new RuntimeException(this.x);
        }
    }
}

