/*
 * Decompiled with CFR 0.152.
 */
package javax.naming.spi;

import java.io.Serializable;
import javax.naming.CompositeName;
import javax.naming.InvalidNameException;
import javax.naming.Name;

public class ResolveResult
implements Serializable {
    private static final long serialVersionUID = -4552108072002407559L;
    protected Object resolvedObj;
    protected Name remainingName;

    protected ResolveResult() {
    }

    public ResolveResult(Object resolved, String remaining) {
        if (resolved == null || remaining == null) {
            throw new IllegalArgumentException();
        }
        this.resolvedObj = resolved;
        this.remainingName = new CompositeName();
        try {
            this.remainingName.add(remaining);
        }
        catch (InvalidNameException invalidNameException) {}
    }

    public ResolveResult(Object resolved, Name remaining) {
        this.resolvedObj = resolved;
        this.remainingName = remaining;
    }

    public Name getRemainingName() {
        return this.remainingName;
    }

    public Object getResolvedObj() {
        return this.resolvedObj;
    }

    public void setRemainingName(Name name) {
        this.remainingName = (Name)name.clone();
    }

    public void appendRemainingName(Name name) {
        try {
            this.remainingName.addAll(name);
        }
        catch (InvalidNameException invalidNameException) {}
    }

    public void appendRemainingComponent(String name) {
        try {
            this.remainingName.add(name);
        }
        catch (InvalidNameException invalidNameException) {}
    }

    public void setResolvedObj(Object obj) {
        this.resolvedObj = obj;
    }
}

