/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import gnu.java.security.Engine;
import java.lang.reflect.InvocationTargetException;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyGeneratorSpi;
import javax.crypto.SecretKey;

public class KeyGenerator {
    private static final String SERVICE = "KeyGenerator";
    private KeyGeneratorSpi kgSpi;
    private Provider provider;
    private String algorithm;

    protected KeyGenerator(KeyGeneratorSpi kgSpi, Provider provider, String algorithm) {
        this.kgSpi = kgSpi;
        this.provider = provider;
        this.algorithm = algorithm;
    }

    public static final KeyGenerator getInstance(String algorithm) throws NoSuchAlgorithmException {
        Provider[] p = Security.getProviders();
        NoSuchAlgorithmException lastException = null;
        int i = 0;
        while (i < p.length) {
            try {
                return KeyGenerator.getInstance(algorithm, p[i]);
            }
            catch (NoSuchAlgorithmException x) {
                lastException = x;
                ++i;
            }
        }
        if (lastException != null) {
            throw lastException;
        }
        throw new NoSuchAlgorithmException(algorithm);
    }

    public static final KeyGenerator getInstance(String algorithm, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (provider == null) {
            throw new IllegalArgumentException("provider MUST NOT be null");
        }
        Provider p = Security.getProvider(provider);
        if (p == null) {
            throw new NoSuchProviderException(provider);
        }
        return KeyGenerator.getInstance(algorithm, p);
    }

    public static final KeyGenerator getInstance(String algorithm, Provider provider) throws NoSuchAlgorithmException {
        Throwable cause;
        StringBuilder sb = new StringBuilder("KeyGenerator algorithm [").append(algorithm).append("] from provider[").append(provider).append("] could not be created");
        try {
            Object spi = Engine.getInstance(SERVICE, algorithm, provider);
            KeyGenerator instance = new KeyGenerator((KeyGeneratorSpi)spi, provider, algorithm);
            instance.init(new SecureRandom());
            return instance;
        }
        catch (InvocationTargetException x) {
            cause = x.getCause();
            if (cause instanceof NoSuchAlgorithmException) {
                throw (NoSuchAlgorithmException)cause;
            }
            if (cause == null) {
                cause = x;
            }
        }
        catch (ClassCastException x) {
            cause = x;
        }
        NoSuchAlgorithmException x = new NoSuchAlgorithmException(sb.toString());
        x.initCause(cause);
        throw x;
    }

    public final SecretKey generateKey() {
        return this.kgSpi.engineGenerateKey();
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final void init(AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
        this.init(params, new SecureRandom());
    }

    public final void init(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        this.kgSpi.engineInit(params, random);
    }

    public final void init(int keySize) {
        this.init(keySize, new SecureRandom());
    }

    public final void init(int keySize, SecureRandom random) {
        this.kgSpi.engineInit(keySize, random);
    }

    public final void init(SecureRandom random) {
        this.kgSpi.engineInit(random);
    }
}

