/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkedHashMap<K, V>
extends HashMap<K, V> {
    private static final long serialVersionUID = 3801124242820219131L;
    transient LinkedHashEntry root;
    final boolean accessOrder;

    public LinkedHashMap() {
        this.accessOrder = false;
    }

    public LinkedHashMap(Map<? extends K, ? extends V> m) {
        super(m);
        this.accessOrder = false;
    }

    public LinkedHashMap(int initialCapacity) {
        super(initialCapacity);
        this.accessOrder = false;
    }

    public LinkedHashMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
        this.accessOrder = false;
    }

    public LinkedHashMap(int initialCapacity, float loadFactor, boolean accessOrder) {
        super(initialCapacity, loadFactor);
        this.accessOrder = accessOrder;
    }

    @Override
    public void clear() {
        super.clear();
        this.root = null;
    }

    @Override
    public boolean containsValue(Object value) {
        LinkedHashEntry e = this.root;
        while (e != null) {
            if (LinkedHashMap.equals(value, e.value)) {
                return true;
            }
            e = e.succ;
        }
        return false;
    }

    @Override
    public V get(Object key) {
        int idx = this.hash(key);
        HashMap.HashEntry e = this.buckets[idx];
        while (e != null) {
            if (LinkedHashMap.equals(key, e.key)) {
                e.access();
                return (V)e.value;
            }
            e = e.next;
        }
        return null;
    }

    protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
        return false;
    }

    @Override
    void addEntry(K key, V value, int idx, boolean callRemove) {
        LinkedHashEntry<K, V> e = new LinkedHashEntry<K, V>(key, value);
        e.next = this.buckets[idx];
        this.buckets[idx] = e;
        if (callRemove && this.removeEldestEntry(this.root)) {
            this.remove(this.root.key);
        }
    }

    @Override
    void putAllInternal(Map m) {
        this.root = null;
        super.putAllInternal(m);
    }

    @Override
    Iterator iterator(final int type) {
        return new Iterator(){
            LinkedHashEntry current;
            LinkedHashEntry last;
            int knownMod;
            {
                this.current = LinkedHashMap.this.root;
                this.knownMod = LinkedHashMap.this.modCount;
            }

            public boolean hasNext() {
                return this.current != null;
            }

            public Object next() {
                if (this.knownMod != LinkedHashMap.this.modCount) {
                    throw new ConcurrentModificationException();
                }
                if (this.current == null) {
                    throw new NoSuchElementException();
                }
                this.last = this.current;
                this.current = this.current.succ;
                return type == 1 ? this.last.value : (type == 0 ? this.last.key : this.last);
            }

            public void remove() {
                if (this.knownMod != LinkedHashMap.this.modCount) {
                    throw new ConcurrentModificationException();
                }
                if (this.last == null) {
                    throw new IllegalStateException();
                }
                LinkedHashMap.this.remove(this.last.key);
                this.last = null;
                ++this.knownMod;
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class LinkedHashEntry<K, V>
    extends HashMap.HashEntry<K, V> {
        LinkedHashEntry<K, V> pred;
        LinkedHashEntry<K, V> succ;

        LinkedHashEntry(K key, V value) {
            super(key, value);
            if (LinkedHashMap.this.root == null) {
                LinkedHashMap.this.root = this;
                this.pred = this;
            } else {
                this.pred = LinkedHashMap.this.root.pred;
                this.pred.succ = this;
                LinkedHashMap.this.root.pred = this;
            }
        }

        @Override
        void access() {
            if (LinkedHashMap.this.accessOrder && this.succ != null) {
                ++LinkedHashMap.this.modCount;
                if (this == LinkedHashMap.this.root) {
                    LinkedHashMap.this.root = this.succ;
                    this.pred.succ = this;
                    this.succ = null;
                } else {
                    this.pred.succ = this.succ;
                    this.succ.pred = this.pred;
                    this.succ = null;
                    this.pred = LinkedHashMap.this.root.pred;
                    this.pred.succ = this;
                    LinkedHashMap.this.root.pred = this;
                }
            }
        }

        @Override
        V cleanup() {
            if (this == LinkedHashMap.this.root) {
                LinkedHashMap.this.root = this.succ;
                if (this.succ != null) {
                    this.succ.pred = this.pred;
                }
            } else if (this.succ == null) {
                this.pred.succ = null;
                LinkedHashMap.this.root.pred = this.pred;
            } else {
                this.pred.succ = this.succ;
                this.succ.pred = this.pred;
            }
            return (V)this.value;
        }
    }
}

