/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.AbstractList;
import java.util.Collection;
import java.util.Iterator;
import java.util.ListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSequentialList<E>
extends AbstractList<E> {
    protected AbstractSequentialList() {
    }

    @Override
    public abstract ListIterator<E> listIterator(int var1);

    @Override
    public void add(int index, E o) {
        this.listIterator(index).add(o);
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        Iterator<E> ci = c.iterator();
        int size = c.size();
        ListIterator<E> i = this.listIterator(index);
        int pos = size;
        while (pos > 0) {
            i.add(ci.next());
            --pos;
        }
        return size > 0;
    }

    @Override
    public E get(int index) {
        if (index == this.size()) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size:" + this.size());
        }
        return this.listIterator(index).next();
    }

    @Override
    public Iterator<E> iterator() {
        return this.listIterator();
    }

    @Override
    public E remove(int index) {
        if (index == this.size()) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size:" + this.size());
        }
        ListIterator<E> i = this.listIterator(index);
        E removed = i.next();
        i.remove();
        return removed;
    }

    @Override
    public E set(int index, E o) {
        if (index == this.size()) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size:" + this.size());
        }
        ListIterator<E> i = this.listIterator(index);
        E old = i.next();
        i.set(o);
        return old;
    }
}

