/*
 * Decompiled with CFR 0.152.
 */
package java.awt.font;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.font.GraphicAttribute;
import java.awt.geom.Rectangle2D;

public final class ImageGraphicAttribute
extends GraphicAttribute {
    private Image image;
    private float originX;
    private float originY;

    public ImageGraphicAttribute(Image image, int alignment) {
        this(image, alignment, 0.0f, 0.0f);
    }

    public ImageGraphicAttribute(Image image, int alignment, float originX, float originY) {
        super(alignment);
        this.image = image;
        this.originX = originX;
        this.originY = originY;
    }

    public void draw(Graphics2D g, float x, float y) {
        g.drawImage(this.image, (int)(x - this.originX), (int)(y - this.originY), null);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ImageGraphicAttribute)) {
            return false;
        }
        return this.equals((ImageGraphicAttribute)obj);
    }

    public boolean equals(ImageGraphicAttribute rhs) {
        return this == rhs || this.getAscent() == rhs.getAscent() && this.getAdvance() == rhs.getAdvance() && this.getAlignment() == rhs.getAlignment() && this.getBounds().equals(rhs.getBounds()) && this.getDescent() == rhs.getDescent() && this.hashCode() == rhs.hashCode() && this.image.equals(rhs.image) && this.originX == rhs.originX && this.originY == rhs.originY;
    }

    public float getAdvance() {
        return Math.max(0.0f, (float)this.image.getWidth(null) - this.originX);
    }

    public float getAscent() {
        return Math.max(0.0f, this.originY);
    }

    public Rectangle2D getBounds() {
        return new Rectangle2D.Float(-this.originX, -this.originY, this.image.getWidth(null), this.image.getHeight(null));
    }

    public float getDescent() {
        return Math.max(0.0f, (float)this.image.getHeight(null) - this.originY);
    }

    public int hashCode() {
        return this.image.hashCode();
    }
}

