/*
 * Decompiled with CFR 0.152.
 */
package java.awt.dnd;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceListener;
import java.awt.event.InputEvent;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DragGestureEvent
extends EventObject {
    private static final long serialVersionUID = 9080172649166731306L;
    private DragSource dragSource;
    private Component component;
    private final Point origin;
    private final int action;
    private List<InputEvent> events;
    private DragGestureRecognizer dgr;

    public DragGestureEvent(DragGestureRecognizer dgr, int action, Point origin, List<? extends InputEvent> events) {
        super(dgr);
        if (origin == null || events == null || dgr == null) {
            throw new IllegalArgumentException();
        }
        this.origin = origin;
        this.action = action;
        this.events = events;
        this.dgr = dgr;
        this.component = dgr.getComponent();
        this.dragSource = dgr.getDragSource();
    }

    public DragGestureRecognizer getSourceAsDragGestureRecognizer() {
        return (DragGestureRecognizer)this.getSource();
    }

    public Component getComponent() {
        return this.component;
    }

    public DragSource getDragSource() {
        return this.dragSource;
    }

    public Point getDragOrigin() {
        return this.origin;
    }

    public Iterator<InputEvent> iterator() {
        return this.events.iterator();
    }

    public Object[] toArray() {
        return this.events.toArray();
    }

    public Object[] toArray(Object[] array) {
        return this.events.toArray(array);
    }

    public int getDragAction() {
        return this.action;
    }

    public InputEvent getTriggerEvent() {
        return this.dgr.getTriggerEvent();
    }

    public void startDrag(Cursor dragCursor, Transferable trans) {
        this.startDrag(dragCursor, null, null, trans, null);
    }

    public void startDrag(Cursor dragCursor, Transferable trans, DragSourceListener l) {
        this.startDrag(dragCursor, null, null, trans, l);
    }

    public void startDrag(Cursor dragCursor, Image dragImage, Point imageOffset, Transferable trans, DragSourceListener l) {
        this.dragSource.startDrag(this, dragCursor, dragImage, imageOffset, trans, l);
    }
}

