/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.dom.ls;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

public class ReaderInputStream
extends InputStream {
    private Reader reader;
    private String encoding;
    private byte[] extra;
    private int pos;
    private byte[] extra_marked;
    private int pos_marked;

    public ReaderInputStream(Reader reader) {
        this.reader = reader;
        this.encoding = "UTF-8";
    }

    void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public int read() throws IOException {
        if (this.extra != null) {
            byte result = this.extra[this.pos];
            ++this.pos;
            if (this.pos >= this.extra.length) {
                this.extra = null;
            }
            return result;
        }
        return this.reader.read();
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (len == 0) {
            return 0;
        }
        if (this.extra != null) {
            int available = this.extra.length - this.pos;
            int l = available < len ? available : len;
            System.arraycopy(this.extra, 0, b, off, l);
            this.pos += l;
            if (this.pos >= this.extra.length) {
                this.extra = null;
            }
            return l;
        }
        char[] c = new char[len];
        int l = this.reader.read(c, 0, len);
        if (l == -1) {
            return -1;
        }
        String s = new String(c, 0, l);
        byte[] d = s.getBytes(this.encoding);
        int available = d.length;
        int more = d.length - len;
        if (more > 0) {
            this.extra = new byte[more];
            this.pos = 0;
            System.arraycopy(d, len, this.extra, 0, more);
            available -= more;
        }
        System.arraycopy(d, 0, b, off, available);
        return available;
    }

    public void close() throws IOException {
        this.reader.close();
    }

    public boolean markSupported() {
        return this.reader.markSupported();
    }

    public void mark(int limit) {
        if (this.extra != null) {
            this.extra_marked = new byte[this.extra.length];
            System.arraycopy(this.extra, 0, this.extra_marked, 0, this.extra.length);
            this.pos_marked = this.pos;
        } else {
            this.extra_marked = null;
        }
        try {
            this.reader.mark(limit);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public void reset() throws IOException {
        this.extra = this.extra_marked;
        this.pos = this.pos_marked;
        this.extra_marked = null;
        this.reader.reset();
    }

    public long skip(long n) throws IOException {
        long done = 0L;
        if (this.extra != null) {
            int available = this.extra.length - this.pos;
            done = (long)available < n ? (long)available : n;
            this.pos = (int)((long)this.pos + done);
            if (this.pos >= this.extra.length) {
                this.extra = null;
            }
        }
        if ((n -= done) > 0L) {
            return this.reader.skip(n) + done;
        }
        return done;
    }

    public int available() throws IOException {
        if (this.extra != null) {
            return this.pos - this.extra.length;
        }
        return this.reader.ready() ? 1 : 0;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[" + this.reader + ", " + this.encoding + "]";
    }
}

