/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.javax.net.ssl.provider.Builder;
import gnu.javax.net.ssl.provider.ExchangeKeys;
import gnu.javax.net.ssl.provider.ProtocolVersion;
import gnu.javax.net.ssl.provider.Util;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;

public final class EncryptedPreMasterSecret
extends ExchangeKeys
implements Builder {
    private final ProtocolVersion version;

    public EncryptedPreMasterSecret(ByteBuffer buffer, ProtocolVersion version) {
        super(buffer);
        version.getClass();
        this.version = version;
    }

    public EncryptedPreMasterSecret(byte[] encryptedSecret, ProtocolVersion version) {
        this(ByteBuffer.allocate(version == ProtocolVersion.SSL_3 ? encryptedSecret.length : encryptedSecret.length + 2), version);
        ByteBuffer b = this.buffer.duplicate();
        if (version != ProtocolVersion.SSL_3) {
            b.putShort((short)encryptedSecret.length);
        }
        b.put(encryptedSecret);
    }

    public ByteBuffer buffer() {
        return (ByteBuffer)this.buffer.duplicate().rewind();
    }

    public byte[] encryptedSecret() {
        byte[] secret;
        if (this.version == ProtocolVersion.SSL_3) {
            this.buffer.position(0);
            secret = new byte[this.buffer.limit()];
            this.buffer.get(secret);
        } else {
            int len = this.buffer.getShort(0) & 0xFFFF;
            secret = new byte[len];
            this.buffer.position(2);
            this.buffer.get(secret);
        }
        return secret;
    }

    public void setEncryptedSecret(byte[] secret, int offset, int length) {
        if (this.version == ProtocolVersion.SSL_3) {
            this.buffer.position(0);
            this.buffer.put(secret, offset, length);
            this.buffer.rewind();
        } else {
            this.buffer.putShort(0, (short)length);
            this.buffer.position(2);
            this.buffer.put(secret, offset, length);
            this.buffer.rewind();
        }
    }

    public int length() {
        if (this.version == ProtocolVersion.SSL_3) {
            return this.buffer.capacity();
        }
        return (this.buffer.getShort(0) & 0xFFFF) + 2;
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(String prefix) {
        StringWriter str = new StringWriter();
        PrintWriter out = new PrintWriter(str);
        if (prefix != null) {
            out.print(prefix);
        }
        out.println("struct {");
        if (prefix != null) {
            out.print(prefix);
        }
        out.println("  pre_master_secret = ");
        out.print(Util.hexDump(this.encryptedSecret(), prefix != null ? String.valueOf(prefix) + "    " : "    "));
        if (prefix != null) {
            out.print(prefix);
        }
        out.print("} EncryptedPreMasterSecret;");
        return str.toString();
    }
}

