/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.pad;

import gnu.javax.crypto.pad.BasePad;
import gnu.javax.crypto.pad.WrongPaddingException;
import java.util.logging.Logger;

public final class TBC
extends BasePad {
    private static final Logger log = null;

    TBC() {
        super("tbc");
    }

    public void setup() {
        if (this.blockSize < 1 || this.blockSize > 256) {
            throw new IllegalArgumentException();
        }
    }

    public byte[] pad(byte[] in, int offset, int length) {
        int padLength = this.blockSize;
        if (length % this.blockSize != 0) {
            padLength = this.blockSize - length % this.blockSize;
        }
        byte[] result = new byte[padLength];
        int lastBit = in[offset + length - 1] & 1;
        if (lastBit == 0) {
            int i = 0;
            while (i < padLength) {
                result[i++] = 1;
            }
        }
        return result;
    }

    public int unpad(byte[] in, int offset, int length) throws WrongPaddingException {
        int limit = offset + length - 1;
        int lastBit = in[limit] & 0xFF;
        int result = 0;
        while (lastBit == (in[limit] & 0xFF)) {
            ++result;
            --limit;
        }
        if (result > length) {
            throw new WrongPaddingException();
        }
        return result;
    }
}

