/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer.headless;

import gnu.java.awt.java2d.RasterGraphics;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Locale;

public class HeadlessGraphicsEnvironment
extends GraphicsEnvironment {
    public Graphics2D createGraphics(BufferedImage image) {
        Graphics2D g2d;
        try {
            Class<?> cairoSurfaceCl = Class.forName("gnu.java.awt.peer.gtk.CairoSurface");
            WritableRaster raster = image.getRaster();
            if (cairoSurfaceCl.isInstance(raster)) {
                Method getGraphicsM = cairoSurfaceCl.getMethod("getGraphics", new Class[0]);
                g2d = (Graphics2D)getGraphicsM.invoke(raster, new Object[0]);
            } else {
                Class<?> bigCl = Class.forName("gnu.java.awt.peer.gtk.BufferedImageGraphics");
                Constructor<?> bigC = bigCl.getConstructor(BufferedImage.class);
                g2d = (Graphics2D)bigC.newInstance(image);
            }
        }
        catch (Exception exception) {
            g2d = new RasterGraphics(image.getRaster(), image.getColorModel());
        }
        return g2d;
    }

    public Font[] getAllFonts() {
        return null;
    }

    public String[] getAvailableFontFamilyNames() {
        return null;
    }

    public String[] getAvailableFontFamilyNames(Locale l) {
        return null;
    }

    public GraphicsDevice getDefaultScreenDevice() {
        throw new HeadlessException();
    }

    public GraphicsDevice[] getScreenDevices() {
        throw new HeadlessException();
    }
}

