/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.java2d;

public final class ScanlineCoverage {
    private Coverage head;
    private Coverage current;
    private Coverage currentPrev;
    private Coverage last;
    private Coverage lastPrev;
    private int minX;
    private int maxX;
    private int maxCoverage;
    private Iterator iterator = new Iterator();

    public void rewind() {
        this.current = this.head;
        this.currentPrev = null;
    }

    public void clear() {
        this.last = this.head;
        this.lastPrev = null;
        this.current = this.head;
        this.currentPrev = null;
        this.minX = Integer.MAX_VALUE;
        this.maxX = Integer.MIN_VALUE;
    }

    public void add(int x, int xc, int yc) {
        Coverage bucket = this.findOrInsert(x);
        bucket.covDelta += xc;
        bucket.pixelCoverage += yc;
        this.minX = Math.min(this.minX, x);
        this.maxX = Math.max(this.maxX, x);
    }

    public int getMaxCoverage() {
        return this.maxCoverage;
    }

    void setMaxCoverage(int maxCov) {
        this.maxCoverage = maxCov;
    }

    public int getMaxX() {
        return this.maxX;
    }

    public int getMinX() {
        return this.minX;
    }

    private Coverage findOrInsert(int x) {
        Coverage cov;
        if (this.head == null) {
            this.head = new Coverage();
            this.head.xPos = x;
            this.current = this.head;
            this.currentPrev = null;
            return this.head;
        }
        Coverage match = this.current;
        Coverage prev = this.currentPrev;
        while (match != this.last && match.xPos < x) {
            prev = match;
            match = match.next;
        }
        if (match == null) {
            match = new Coverage();
            match.xPos = x;
            if (prev != null) {
                prev.next = match;
            }
            this.current = match;
            this.currentPrev = prev;
            return match;
        }
        if (match == this.last) {
            this.last = match.next;
            this.lastPrev = match;
            match.xPos = x;
            match.covDelta = 0;
            match.pixelCoverage = 0;
            this.current = match;
            this.currentPrev = prev;
            return match;
        }
        if (x == match.xPos) {
            this.current = match;
            this.currentPrev = prev;
            return match;
        }
        assert (x <= match.xPos);
        assert (prev == null || x > prev.xPos);
        if (this.last != null) {
            cov = this.last;
            this.lastPrev.next = this.last = cov.next;
        } else {
            cov = new Coverage();
        }
        cov.xPos = x;
        cov.covDelta = 0;
        cov.pixelCoverage = 0;
        if (prev != null) {
            prev.next = cov;
            cov.next = match;
            this.current = cov;
            this.currentPrev = prev;
        } else {
            assert (match == this.head);
            this.head = cov;
            this.head.next = match;
            this.current = this.head;
            this.currentPrev = null;
        }
        return cov;
    }

    public Iterator iterate() {
        this.iterator.reset();
        return this.iterator;
    }

    public boolean isEmpty() {
        return this.head == null || this.head == this.last || this.head.next == null || this.head.next == this.last;
    }

    private static final class Coverage {
        int xPos;
        int covDelta;
        int pixelCoverage;
        Coverage next;

        private Coverage() {
        }

        public int getXPos() {
            return this.xPos;
        }

        public int getCoverageDelta() {
            return this.covDelta;
        }

        public String toString() {
            return "Coverage: xPos: " + this.xPos + ", covDelta: " + this.covDelta;
        }

        public String list() {
            String str = this.toString();
            if (this.next != null) {
                str = String.valueOf(str) + " --> " + this.next.list();
            }
            return str;
        }
    }

    public final class Iterator {
        private Range range = new Range();
        private Coverage currentItem;
        private int currentCoverage;
        private boolean handledPixelCoverage;

        Iterator() {
        }

        public Range next() {
            if (!this.handledPixelCoverage) {
                this.range.setXPos(this.currentItem.xPos);
                this.range.setLength(1);
                this.range.setCoverage(this.currentCoverage + this.currentItem.pixelCoverage);
                this.handledPixelCoverage = true;
            } else {
                this.currentCoverage += this.currentItem.covDelta;
                this.range.setCoverage(this.currentCoverage);
                this.range.setXPos(this.currentItem.xPos + 1);
                this.currentItem = this.currentItem.next;
                this.range.setLength(this.currentItem.xPos - this.range.xPos);
                this.handledPixelCoverage = false;
            }
            return this.range;
        }

        public boolean hasNext() {
            boolean hasNext = this.currentItem != null && !this.handledPixelCoverage ? true : this.currentItem != null && this.currentItem.next != null && this.currentItem.next != ScanlineCoverage.this.last;
            return hasNext;
        }

        void reset() {
            this.currentItem = ScanlineCoverage.this.head;
            this.currentCoverage = 0;
            this.handledPixelCoverage = false;
        }
    }

    public static final class Range {
        private int xPos;
        private int length;
        private int coverage;

        Range() {
        }

        void setXPos(int x) {
            this.xPos = x;
        }

        public int getXPos() {
            return this.xPos;
        }

        void setLength(int l) {
            this.length = l;
        }

        public int getLength() {
            return this.length;
        }

        public int getXPosEnd() {
            return this.xPos + this.length;
        }

        void setCoverage(int cov) {
            this.coverage = cov;
        }

        public int getCoverage() {
            return this.coverage;
        }

        public String toString() {
            return "Coverage range: xPos=" + this.xPos + ", length=" + this.length + ", coverage: " + this.coverage;
        }
    }
}

