/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.font.opentype;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;

public abstract class CharGlyphMap {
    private static final int PLATFORM_UNICODE = 0;
    private static final int PLATFORM_MACINTOSH = 1;
    private static final int PLATFORM_MICROSOFT = 3;

    public abstract int getGlyph(int var1);

    public static CharGlyphMap forTable(ByteBuffer buf) {
        boolean hasType0 = false;
        int start4 = -1;
        int platform4 = 0;
        int encoding4 = 0;
        int start12 = -1;
        int platform12 = 0;
        int encoding12 = 0;
        int tableStart = buf.position();
        int limit = buf.limit();
        char version = buf.getChar();
        if (version != '\u0000') {
            return null;
        }
        int numTables = buf.getChar();
        int i = 0;
        while (i < numTables) {
            buf.limit(limit).position(tableStart + 4 + i * 8);
            char platform = buf.getChar();
            char encoding = buf.getChar();
            int offset = tableStart + buf.getInt();
            buf.position(offset);
            char format = buf.getChar();
            switch (format) {
                case '\u0000': {
                    hasType0 = true;
                    break;
                }
                case '\u0004': {
                    buf.getChar();
                    char language = buf.getChar();
                    if (start4 != -1 || !Type4.isSupported(platform, language, encoding)) break;
                    start4 = offset;
                    platform4 = platform;
                    encoding4 = encoding;
                    break;
                }
                case '\f': {
                    if (start12 != -1 || !Type12.isSupported(platform, encoding)) break;
                    start12 = offset;
                    platform12 = platform;
                    encoding12 = encoding;
                }
            }
            ++i;
        }
        if (start12 >= 0) {
            try {
                buf.limit(limit).position(start12);
                return new Type12(buf, platform12, encoding12);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (start4 >= 0) {
            try {
                buf.limit(limit).position(start4);
                return Type4.readTable(buf, platform4, encoding4);
            }
            catch (Exception exception) {}
        }
        if (hasType0) {
            try {
                buf.limit(limit).position(tableStart);
                return new Type0(buf);
            }
            catch (Exception exception) {}
        }
        return new Dummy();
    }

    private static final class Dummy
    extends CharGlyphMap {
        private Dummy() {
        }

        public int getGlyph(int ucs4) {
            return 0;
        }
    }

    private static final class Type0
    extends CharGlyphMap {
        private char[] glyphToUCS2 = new char[256];
        private static final String UPPER_ARABIC = "~\u0000\u00c4\u00a0\u00c7\u00c9\u00d1\u00d6\u00dc\u00e1\u00e0\u00e2\u00e4\u06ba\u00ab\u00e7\u00e9\u00e8\u00ea\u00eb\u00ed\u2026\u00ee\u00ef\u00f1\u00f3\u00bb\u00f4\u00f6\u00f7\u00fa\u00f9\u00fb\u00fc !\"#$\u066a&'()*+\u060c-./\u0660\u0661\u0662\u0663\u0664\u0665\u0666\u0667\u0668\u0669:\u061b<=>\u061f\u274a\u0621\u0622\u0623\u0624\u0625\u0626\u0627\u0628\u0629\u062a\u062b\u062c\u062d\u062e\u062f\u0630\u0631\u0632\u0633\u0634\u0635\u0636\u0637\u0638\u0639\u063a[\\]^_\u0640\u0641\u0642\u0643\u0644\u0645\u0646\u0647\u0648\u0649\u064a\u064b\u064c\u064d\u064e\u064f\u0650\u0651\u0652\u067e\u0679\u0686\u06d5\u06a4\u06af\u0688\u0691{|}\u0698\u06d2";
        private static final String UPPER_EAST_EUROPEAN_ROMAN = "~\u0000\u00c4\u0100\u0101\u00c9\u0104\u00d6\u00dc\u00e1\u0105\u010c\u00e4\u010d\u0106\u0107\u00e9\u0179\u017a\u010e\u00ed\u010f\u0112\u0113\u0116\u00f3\u0117\u00f4\u00f6\u00f5\u00fa\u011a\u011b\u00fc\u2020\u00b0\u0118\u00a3\u00a7\u2022\u00b6\u00df\u00ae\u00a9\u2122\u0119\u00a8\u2260\u0123\u012e\u012f\u012a\u2264\u2265\u012b\u0136\u2202\u2211\u0142\u013b\u013c\u013d\u013e\u0139\u013a\u0145\u0146\u0143\u00ac\u221a\u0144\u0147\u2206\u00ab\u00bb\u2026\u00a0\u0148\u0150\u00d5\u0151\u014c\u2013\u2014\u201c\u201d\u2018\u2019\u00f7\u25ca\u014d\u0154\u0155\u0158\u2039\u203a\u0159\u0156\u0157\u0160\u201a\u201e\u0161\u015a\u015b\u00c1\u0164\u0165\u00cd\u017d\u017e\u016a\u00d3\u00d4\u016b\u016e\u00da\u016f\u0170\u0171\u0172\u0173\u00dd\u00fd\u0137\u017b\u0141\u017c\u0122\u02c7";
        private static final String UPPER_CROATIAN = "~\u0000\u00c4\u00c5\u00c7\u00c9\u00d1\u00d6\u00dc\u00e1\u00e0\u00e2\u00e4\u00e3\u00e5\u00e7\u00e9\u00e8\u00ea\u00eb\u00ed\u00ec\u00ee\u00ef\u00f1\u00f3\u00f2\u00f4\u00f6\u00f5\u00fa\u00f9\u00fb\u00fc\u2020\u00b0\u00a2\u00a3\u00a7\u2022\u00b6\u00df\u00ae\u0160\u2122\u00b4\u00a8\u2260\u017d\u00d8\u221e\u00b1\u2264\u2265\u2206\u00b5\u2202\u2211\u220f\u0161\u222b\u00aa\u00ba\u03a9\u017e\u00f8\u00bf\u00a1\u00ac\u221a\u0192\u2248\u0106\u00ab\u010c\u2026\u00a0\u00c0\u00c3\u00d5\u0152\u0153\u0110\u2014\u201c\u201d\u2018\u2019\u00f7\u25ca\uf8ff\u00a9\u2044\u20ac\u2039\u203a\u00c6\u00bb\u2013\u00b7\u201a\u201e\u2030\u00c2\u0107\u00c1\u010d\u00c8\u00cd\u00ce\u00cf\u00cc\u00d3\u00d4\u0111\u00d2\u00da\u00db\u00d9\u0131\u02c6\u02dc\u00af\u03c0\u00cb\u02da\u00b8\u00ca\u00e6\u02c7";
        private static final String UPPER_CYRILLIC = "~\u0000\u0410\u0411\u0412\u0413\u0414\u0415\u0416\u0417\u0418\u0419\u041a\u041b\u041c\u041d\u041e\u041f\u0420\u0421\u0422\u0423\u0424\u0425\u0426\u0427\u0428\u0429\u042a\u042b\u042c\u042d\u042e\u042f\u2020\u00b0\u0490\u00a3\u00a7\u2022\u00b6\u0406\u00ae\u00a9\u2122\u0402\u0452\u2260\u0403\u0453\u221e\u00b1\u2264\u2265\u0456\u00b5\u0491\u0408\u0404\u0454\u0407\u0457\u0409\u0459\u040a\u045a\u0458\u0405\u00ac\u221a\u0192\u2248\u2206\u00ab\u00bb\u2026\u00a0\u040b\u045b\u040c\u045c\u0455\u2013\u2014\u201c\u201d\u2018\u2019\u00f7\u201e\u040e\u045e\u040f\u045f\u2116\u0401\u0451\u044f\u0430\u0431\u0432\u0433\u0434\u0435\u0436\u0437\u0438\u0439\u043a\u043b\u043c\u043d\u043e\u043f\u0440\u0441\u0442\u0443\u0444\u0445\u0446\u0447\u0448\u0449\u044a\u044b\u044c\u044d\u044e\u20ac";
        private static final String UPPER_FARSI = "~\u0000\u00c4\u00a0\u00c7\u00c9\u00d1\u00d6\u00dc\u00e1\u00e0\u00e2\u00e4\u06ba\u00ab\u00e7\u00e9\u00e8\u00ea\u00eb\u00ed\u2026\u00ee\u00ef\u00f1\u00f3\u00bb\u00f4\u00f6\u00f7\u00fa\u00f9\u00fb\u00fc !\"#$\u066a&'()*+\u060c-./\u06f0\u06f1\u06f2\u06f3\u06f4\u06f5\u06f6\u06f7\u06f8\u06f9:\u061b<=>\u061f\u274a\u0621\u0622\u0623\u0624\u0625\u0626\u0627\u0628\u0629\u062a\u062b\u062c\u062d\u062e\u062f\u0630\u0631\u0632\u0633\u0634\u0635\u0636\u0637\u0638\u0639\u063a[\\]^_\u0640\u0641\u0642\u0643\u0644\u0645\u0646\u0647\u0648\u0649\u064a\u064b\u064c\u064d\u064e\u064f\u0650\u0651\u0652\u067e\u0679\u0686\u06d5\u06a4\u06af\u0688\u0691{|}\u0698\u06d2";
        private static final String UPPER_GREEK = "~\u0000\u00c4\u00b9\u00b2\u00c9\u00b3\u00d6\u00dc\u0385\u00e0\u00e2\u00e4\u0384\u00a8\u00e7\u00e9\u00e8\u00ea\u00eb\u00a3\u2122\u00ee\u00ef\u2022\u00bd\u2030\u00f4\u00f6\u00a6\u20ac\u00f9\u00fb\u00fc\u2020\u0393\u0394\u0398\u039b\u039e\u03a0\u00df\u00ae\u00a9\u03a3\u03aa\u00a7\u2260\u00b0\u00b7\u0391\u00b1\u2264\u2265\u00a5\u0392\u0395\u0396\u0397\u0399\u039a\u039c\u03a6\u03ab\u03a8\u03a9\u03ac\u039d\u00ac\u039f\u03a1\u2248\u03a4\u00ab\u00bb\u2026\u00a0\u03a5\u03a7\u0386\u0388\u0153\u2013\u2015\u201c\u201d\u2018\u2019\u00f7\u0389\u038a\u038c\u038e\u03ad\u03ae\u03af\u03cc\u038f\u03cd\u03b1\u03b2\u03c8\u03b4\u03b5\u03c6\u03b3\u03b7\u03b9\u03be\u03ba\u03bb\u03bc\u03bd\u03bf\u03c0\u03ce\u03c1\u03c3\u03c4\u03b8\u03c9\u03c2\u03c7\u03c5\u03b6\u03ca\u03cb\u0390\u03b0\u00ad";
        private static final String UPPER_HEBREW = "~\u0000\u00c4\u0000\u00c7\u00c9\u00d1\u00d6\u00dc\u00e1\u00e0\u00e2\u00e4\u00e3\u00e5\u00e7\u00e9\u00e8\u00ea\u00eb\u00ed\u00ec\u00ee\u00ef\u00f1\u00f3\u00f2\u00f4\u00f6\u00f5\u00fa\u00f9\u00fb\u00fc !\"#$%\u20aa')(*+,-./0123456789:;<=>?\u0000\u201e\uf89b\uf89c\uf89d\uf89e\u05bc\ufb4b\ufb35\u2026\u00a0\u05b8\u05b7\u05b5\u05b6\u05b4\u2013\u2014\u201c\u201d\u2018\u2019\ufb2a\ufb2b\u05bf\u05b0\u05b2\u05b1\u05bb\u05b9\u0000\u05b3\u05d0\u05d1\u05d2\u05d3\u05d4\u05d5\u05d6\u05d7\u05d8\u05d9\u05da\u05db\u05dc\u05dd\u05de\u05df\u05e0\u05e1\u05e2\u05e3\u05e4\u05e5\u05e6\u05e7\u05e8\u05e9\u05ea}]{[|";
        private static final String UPPER_ICELANDIC = "~\u0000\u00c4\u00c5\u00c7\u00c9\u00d1\u00d6\u00dc\u00e1\u00e0\u00e2\u00e4\u00e3\u00e5\u00e7\u00e9\u00e8\u00ea\u00eb\u00ed\u00ec\u00ee\u00ef\u00f1\u00f3\u00f2\u00f4\u00f6\u00f5\u00fa\u00f9\u00fb\u00fc\u00dd\u00b0\u00a2\u00a3\u00a7\u2022\u00b6\u00df\u00ae\u00a9\u2122\u00b4\u00a8\u2260\u00c6\u00d8\u221e\u00b1\u2264\u2265\u00a5\u00b5\u2202\u2211\u220f\u03c0\u222b\u00aa\u00ba\u03a9\u00e6\u00f8\u00bf\u00a1\u00ac\u221a\u0192\u2248\u2206\u00ab\u00bb\u2026\u00a0\u00c0\u00c3\u00d5\u0152\u0153\u2013\u2014\u201c\u201d\u2018\u2019\u00f7\u25ca\u00ff\u0178\u2044\u20ac\u00d0\u00f0\u00de\u00fe\u00fd\u00b7\u201a\u201e\u2030\u00c2\u00ca\u00c1\u00cb\u00c8\u00cd\u00ce\u00cf\u00cc\u00d3\u00d4\uf8ff\u00d2\u00da\u00db\u00d9\u0131\u02c6\u02dc\u00af\u02d8\u02d9\u02da\u00b8\u02dd\u02db\u02c7";
        private static final String UPPER_ROMAN = "~\u0000\u00c4\u00c5\u00c7\u00c9\u00d1\u00d6\u00dc\u00e1\u00e0\u00e2\u00e4\u00e3\u00e5\u00e7\u00e9\u00e8\u00ea\u00eb\u00ed\u00ec\u00ee\u00ef\u00f1\u00f3\u00f2\u00f4\u00f6\u00f5\u00fa\u00f9\u00fb\u00fc\u2020\u00b0\u00a2\u00a3\u00a7\u2022\u00b6\u00df\u00ae\u00a9\u2122\u00b4\u00a8\u2260\u00c6\u00d8\u221e\u00b1\u2264\u2265\u00a5\u00b5\u2202\u2211\u220f\u03c0\u222b\u00aa\u00ba\u03a9\u00e6\u00f8\u00bf\u00a1\u00ac\u221a\u0192\u2248\u2206\u00ab\u00bb\u2026\u00a0\u00c0\u00c3\u00d5\u0152\u0153\u2013\u2014\u201c\u201d\u2018\u2019\u00f7\u25ca\u00ff\u0178\u2044\u20ac\u2039\u203a\ufb01\ufb02\u2021\u00b7\u201a\u201e\u2030\u00c2\u00ca\u00c1\u00cb\u00c8\u00cd\u00ce\u00cf\u00cc\u00d3\u00d4\uf8ff\u00d2\u00da\u00db\u00d9\u0131\u02c6\u02dc\u00af\u02d8\u02d9\u02da\u00b8\u02dd\u02db\u02c7";
        private static final String UPPER_ROMANIAN = "~\u0000\u00c4\u00c5\u00c7\u00c9\u00d1\u00d6\u00dc\u00e1\u00e0\u00e2\u00e4\u00e3\u00e5\u00e7\u00e9\u00e8\u00ea\u00eb\u00ed\u00ec\u00ee\u00ef\u00f1\u00f3\u00f2\u00f4\u00f6\u00f5\u00fa\u00f9\u00fb\u00fc\u2020\u00b0\u00a2\u00a3\u00a7\u2022\u00b6\u00df\u00ae\u00a9\u2122\u00b4\u00a8\u2260\u0102\u0218\u221e\u00b1\u2264\u2265\u00a5\u00b5\u2202\u2211\u220f\u03c0\u222b\u00aa\u00ba\u03a9\u0103\u0219\u00bf\u00a1\u00ac\u221a\u0192\u2248\u2206\u00ab\u00bb\u2026\u00a0\u00c0\u00c3\u00d5\u0152\u0153\u2013\u2014\u201c\u201d\u2018\u2019\u00f7\u25ca\u00ff\u0178\u2044\u20ac\u2039\u203a\u021a\u021b\u2021\u00b7\u201a\u201e\u2030\u00c2\u00ca\u00c1\u00cb\u00c8\u00cd\u00ce\u00cf\u00cc\u00d3\u00d4\uf8ff\u00d2\u00da\u00db\u00d9\u0131\u02c6\u02dc\u00af\u02d8\u02d9\u02da\u00b8\u02dd\u02db\u02c7";
        private static final String UPPER_TURKISH = "~\u0000\u00c4\u00c5\u00c7\u00c9\u00d1\u00d6\u00dc\u00e1\u00e0\u00e2\u00e4\u00e3\u00e5\u00e7\u00e9\u00e8\u00ea\u00eb\u00ed\u00ec\u00ee\u00ef\u00f1\u00f3\u00f2\u00f4\u00f6\u00f5\u00fa\u00f9\u00fb\u00fc\u2020\u00b0\u00a2\u00a3\u00a7\u2022\u00b6\u00df\u00ae\u00a9\u2122\u00b4\u00a8\u2260\u00c6\u00d8\u221e\u00b1\u2264\u2265\u00a5\u00b5\u2202\u2211\u220f\u03c0\u222b\u00aa\u00ba\u03a9\u00e6\u00f8\u00bf\u00a1\u00ac\u221a\u0192\u2248\u2206\u00ab\u00bb\u2026\u00a0\u00c0\u00c3\u00d5\u0152\u0153\u2013\u2014\u201c\u201d\u2018\u2019\u00f7\u25ca\u00ff\u0178\u011e\u011f\u0130\u0131\u015e\u015f\u2021\u00b7\u201a\u201e\u2030\u00c2\u00ca\u00c1\u00cb\u00c8\u00cd\u00ce\u00cf\u00cc\u00d3\u00d4\uf8ff\u00d2\u00da\u00db\u00d9\uf8a0\u02c6\u02dc\u00af\u02d8\u02d9\u02da\u00b8\u02dd\u02db\u02c7";

        public Type0(ByteBuffer buf) {
            int tableStart = buf.position();
            int limit = buf.limit();
            if (buf.getChar() != '\u0000') {
                throw new IllegalStateException();
            }
            int numTables = buf.getChar();
            int i = 0;
            while (i < numTables) {
                buf.limit(limit).position(tableStart + 4 + i * 8);
                char platform = buf.getChar();
                char encoding = buf.getChar();
                int offset = tableStart + buf.getInt();
                buf.position(offset);
                char format = buf.getChar();
                char length = buf.getChar();
                buf.limit(offset + length);
                char language = buf.getChar();
                if (format == '\u0000') {
                    this.readSingleTable(buf, platform, language, encoding);
                }
                ++i;
            }
        }

        private void readSingleTable(ByteBuffer buf, int platform, int language, int encoding) {
            String upper = Type0.getUpper129(platform, encoding, language);
            if (upper == null) {
                return;
            }
            buf.position(buf.position() + 32);
            int i = 32;
            while (i < 126) {
                this.glyphToUCS2[buf.get() & 0xFF] = (char)i;
                ++i;
            }
            i = 127;
            while (i < 256) {
                this.glyphToUCS2[buf.get() & 0xFF] = upper.charAt(i - 127);
                ++i;
            }
            this.glyphToUCS2[0] = '\u0000';
        }

        public int getGlyph(int ucs4) {
            int i = 0;
            while (i < 256) {
                if (this.glyphToUCS2[i] == ucs4) {
                    return i;
                }
                ++i;
            }
            return 0;
        }

        private static String getUpper129(int platform, int script, int language) {
            if (platform != 1) {
                return null;
            }
            switch (script) {
                case 0: {
                    if (language == 16) {
                        return UPPER_ICELANDIC;
                    }
                    if (language == 18) {
                        return UPPER_TURKISH;
                    }
                    if (language == 19) {
                        return UPPER_CROATIAN;
                    }
                    if (language == 38) {
                        return UPPER_ROMANIAN;
                    }
                    if (language == 0) {
                        return UPPER_ROMAN;
                    }
                    return null;
                }
                case 4: {
                    if (language == 32) {
                        return UPPER_FARSI;
                    }
                    return UPPER_ARABIC;
                }
                case 5: {
                    return UPPER_HEBREW;
                }
                case 6: {
                    return UPPER_GREEK;
                }
                case 7: {
                    return UPPER_CYRILLIC;
                }
                case 29: {
                    return UPPER_EAST_EUROPEAN_ROMAN;
                }
            }
            return null;
        }
    }

    private static final class Type12
    extends CharGlyphMap {
        int numGroups;
        IntBuffer data;

        static boolean isSupported(int platform, int encoding) {
            switch (platform) {
                case 0: {
                    return encoding >= 0 && encoding <= 4;
                }
                case 3: {
                    return encoding == 1 || encoding == 10;
                }
            }
            return false;
        }

        Type12(ByteBuffer buf, int platform, int encoding) {
            int tableStart = buf.position();
            char format = buf.getChar();
            if (format != '\f' || !Type12.isSupported(platform, encoding)) {
                throw new IllegalStateException();
            }
            buf.getChar();
            buf.limit(tableStart + buf.getInt());
            buf.getInt();
            this.numGroups = buf.getInt();
            this.data = buf.asIntBuffer();
        }

        public int getGlyph(int ucs4) {
            int endCharCode;
            int startCharCode;
            int min = 0;
            int max = this.numGroups - 1;
            int mid = max >> 1;
            do {
                startCharCode = this.data.get(3 * mid);
                endCharCode = this.data.get(3 * mid + 1);
                if (startCharCode <= ucs4 && ucs4 <= endCharCode) {
                    return ucs4 - startCharCode + this.data.get(mid * 3 + 2);
                }
                if (endCharCode < ucs4) {
                    min = mid + 1;
                } else {
                    max = mid;
                }
                mid = min + max >> 1;
            } while (min < max);
            startCharCode = this.data.get(3 * mid);
            endCharCode = this.data.get(3 * mid + 1);
            if (startCharCode <= ucs4 && ucs4 <= endCharCode) {
                return ucs4 - startCharCode + this.data.get(mid * 3 + 2);
            }
            return 0;
        }
    }

    private static final class Type4
    extends CharGlyphMap {
        private CharBuffer lastChar;
        private CharBuffer firstChar;
        private ShortBuffer idDelta;
        private CharBuffer rangeID;
        private int numSegments;

        static boolean isSupported(int platform, int language, int encoding) {
            switch (platform) {
                case 0: {
                    return encoding >= 0 && encoding <= 4;
                }
                case 3: {
                    return encoding == 1 || encoding == 10;
                }
            }
            return false;
        }

        static Type4 readTable(ByteBuffer buf, int platform, int encoding) {
            int tableStart = buf.position();
            char format = buf.getChar();
            char length = buf.getChar();
            char language = buf.getChar();
            if (format != '\u0004' || !Type4.isSupported(platform, language, encoding)) {
                throw new IllegalArgumentException();
            }
            buf.limit(tableStart + length);
            char segCountX2 = buf.getChar();
            int segCount = segCountX2 / 2;
            buf.getChar();
            buf.getChar();
            buf.getChar();
            int pos = buf.position();
            CharBuffer endCode = buf.asCharBuffer();
            buf.position(pos += segCountX2 + 2);
            CharBuffer startCode = buf.asCharBuffer();
            buf.position(pos += segCountX2);
            ShortBuffer idDelta = buf.asShortBuffer();
            buf.position(pos += segCountX2);
            CharBuffer idRangeOffset_glyphID = buf.asCharBuffer();
            endCode.limit(segCount);
            startCode.limit(segCount);
            idDelta.limit(segCount);
            idRangeOffset_glyphID.limit((buf.limit() - pos) / 2);
            return new Type4(segCount, endCode, startCode, idDelta, idRangeOffset_glyphID);
        }

        private Type4(int numSegments, CharBuffer lastChar, CharBuffer firstChar, ShortBuffer idDelta, CharBuffer rangeID) {
            this.numSegments = numSegments;
            this.lastChar = lastChar;
            this.firstChar = firstChar;
            this.idDelta = idDelta;
            this.rangeID = rangeID;
        }

        public int getGlyph(int ucs4) {
            if (ucs4 > 65535) {
                return 0;
            }
            char c = (char)ucs4;
            int segment = this.find(c);
            char segStart = this.firstChar.get(segment);
            if (c < segStart || c > this.lastChar.get(segment)) {
                return 0;
            }
            char idRangeOffset = this.rangeID.get(segment);
            if (idRangeOffset == '\u0000') {
                return (char)(c + this.idDelta.get(segment));
            }
            char result = this.rangeID.get((idRangeOffset >> 1) + (c - segStart) + segment);
            if (result == '\u0000') {
                return 0;
            }
            return (char)(result + this.idDelta.get(segment));
        }

        private int find(char c) {
            int min = 0;
            int max = this.numSegments - 1;
            int mid = max >> 1;
            while (min < max) {
                char val = this.lastChar.get(mid);
                if (val == c) break;
                if (val < c) {
                    min = mid + 1;
                } else if (val > c) {
                    max = mid;
                }
                mid = min + max >> 1;
            }
            return mid;
        }
    }
}

