/*
 * Decompiled with CFR 0.152.
 */
package gnu.gcj.xlib;

import gnu.gcj.xlib.Display;
import gnu.gcj.xlib.GC;
import gnu.gcj.xlib.XID;
import gnu.gcj.xlib.XImage;
import java.awt.Rectangle;

public class Drawable
extends XID {
    private GC[] gcCache = new GC[10];
    private int gcCachedCount = 0;
    private static final String MSG_XGETSUBIMAGE_FAILED = "XGetSubImage() failed.";

    public Drawable(Display display, int xid) {
        super(display, xid);
    }

    public Rectangle copyIntoXImage(XImage dest, Rectangle bounds, int destX, int destY) {
        Rectangle newBounds = null;
        int tries = 5;
        while (!bounds.isEmpty()) {
            if (this.copyIntoXImageImpl(dest, bounds.x, bounds.y, bounds.width, bounds.height, destX, destY)) {
                return bounds;
            }
            newBounds = this.getBounds(newBounds);
            bounds = newBounds.intersection(bounds);
            if (--tries >= 0) continue;
            throw new RuntimeException("copyIntoXImage is buggy");
        }
        return bounds;
    }

    private native boolean copyIntoXImageImpl(XImage var1, int var2, int var3, int var4, int var5, int var6, int var7);

    public native Rectangle getBounds(Rectangle var1);

    public native int getDepth();

    protected void finalize() throws Throwable {
        int i = 0;
        while (i < this.gcCachedCount) {
            this.gcCache[i].disposeImpl();
            ++i;
        }
        this.gcCachedCount = 0;
        super.finalize();
    }

    void putGCInCache(GC gc) {
        if (this.gcCachedCount >= this.gcCache.length) {
            GC[] oldList = this.gcCache;
            this.gcCache = new GC[oldList.length * 2];
            System.arraycopy(oldList, 0, this.gcCache, 0, oldList.length);
        }
        this.gcCache[this.gcCachedCount++] = gc;
    }

    GC getGCFromCache() {
        return this.gcCachedCount > 0 ? this.gcCache[--this.gcCachedCount] : null;
    }
}

