/*
 * Decompiled with CFR 0.152.
 */
package gnu.CORBA.typecodes;

import gnu.CORBA.typecodes.PrimitiveTypeCode;
import java.math.BigDecimal;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.TypeCodePackage.BadKind;

public class FixedTypeCode
extends PrimitiveTypeCode {
    private static final long serialVersionUID = 1L;
    private short digits;
    private short scale;

    public FixedTypeCode() {
        super(TCKind.tk_fixed);
    }

    public FixedTypeCode(BigDecimal example) {
        super(TCKind.tk_fixed);
        if (example != null) {
            this.setScale(example.scale());
            this.setDigits(FixedTypeCode.countDigits(example));
        }
    }

    public void setDigits(int a_digits) {
        this.digits = (short)a_digits;
    }

    public void setScale(int a_scale) {
        this.scale = (short)a_scale;
    }

    public static int countDigits(BigDecimal number) {
        return number.unscaledValue().abs().toString().length();
    }

    public boolean equal(TypeCode other) {
        if (other == this) {
            return true;
        }
        try {
            TypeCode that = other;
            return this.kind() == that.kind() && this.digits == that.fixed_digits() && this.scale == that.fixed_scale();
        }
        catch (BadKind badKind) {
            return false;
        }
    }

    public short fixed_digits() {
        return this.digits;
    }

    public short fixed_scale() {
        return this.scale;
    }
}

