/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.gjdoc.expr;

import gnu.classpath.tools.gjdoc.expr.ConstantBoolean;
import gnu.classpath.tools.gjdoc.expr.ConstantByte;
import gnu.classpath.tools.gjdoc.expr.ConstantChar;
import gnu.classpath.tools.gjdoc.expr.ConstantDouble;
import gnu.classpath.tools.gjdoc.expr.ConstantExpression;
import gnu.classpath.tools.gjdoc.expr.ConstantFloat;
import gnu.classpath.tools.gjdoc.expr.ConstantInteger;
import gnu.classpath.tools.gjdoc.expr.ConstantLong;
import gnu.classpath.tools.gjdoc.expr.ConstantShort;
import gnu.classpath.tools.gjdoc.expr.ConstantString;
import gnu.classpath.tools.gjdoc.expr.Context;
import gnu.classpath.tools.gjdoc.expr.Expression;
import gnu.classpath.tools.gjdoc.expr.IllegalExpressionException;

class IdentifierExpression
implements Expression {
    private String identifier;

    public IdentifierExpression(String identifier) {
        this.identifier = identifier;
    }

    public ConstantExpression evaluate(Context context) throws IllegalExpressionException {
        Object value = context.getEvaluatorEnvironment().getValue(this.identifier, context.getVisitedFields());
        if (value instanceof Byte) {
            return new ConstantByte((Byte)value);
        }
        if (value instanceof Short) {
            return new ConstantShort((Short)value);
        }
        if (value instanceof Integer) {
            return new ConstantInteger((Integer)value);
        }
        if (value instanceof Long) {
            return new ConstantLong((Long)value);
        }
        if (value instanceof Float) {
            return new ConstantFloat(((Float)value).floatValue());
        }
        if (value instanceof Double) {
            return new ConstantDouble((Double)value);
        }
        if (value instanceof Boolean) {
            return new ConstantBoolean((Boolean)value);
        }
        if (value instanceof Character) {
            return new ConstantChar(((Character)value).charValue());
        }
        if (value instanceof String) {
            return new ConstantString((String)value);
        }
        if (value != null) {
            throw new IllegalExpressionException("Unsupported type " + value.getClass().getName() + " for identifier " + this.identifier);
        }
        throw new IllegalExpressionException("Cannot resolve identifier " + this.identifier);
    }
}

