/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.appletviewer;

import gnu.classpath.tools.appletviewer.AppletTag;
import gnu.javax.swing.text.html.parser.HTML_401F;
import gnu.xml.dom.DomNode;
import gnu.xml.dom.html2.DomHTMLAppletElement;
import gnu.xml.dom.html2.DomHTMLDocument;
import gnu.xml.dom.html2.DomHTMLEmbedElement;
import gnu.xml.dom.html2.DomHTMLObjectElement;
import gnu.xml.dom.html2.DomHTMLParamElement;
import gnu.xml.dom.html2.DomHTMLParser;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.Vector;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TagParser {
    DomHTMLDocument document;
    URL documentbase;
    static URL db;
    Vector tags = new Vector();

    TagParser() {
    }

    TagParser(String location) throws IOException {
        db = this.documentbase = TagParser.getLocationToURL(location);
        InputStreamReader in = new InputStreamReader(this.documentbase.openStream());
        this.document = (DomHTMLDocument)new DomHTMLParser(HTML_401F.getInstance()).parseDocument((Reader)in);
    }

    TagParser(Reader in, URL documentBase) throws IOException {
        db = this.documentbase = documentBase;
        this.document = (DomHTMLDocument)new DomHTMLParser(HTML_401F.getInstance()).parseDocument(in);
    }

    ArrayList parseAppletTags() {
        ArrayList<AppletTag> allTags = new ArrayList<AppletTag>();
        if (this.document == null) {
            return null;
        }
        this.recurseDocument(this.document.getChildNodes());
        int sz = this.tags.size();
        int j = 0;
        while (j < sz) {
            Object curr = this.tags.get(j);
            AppletTag a = null;
            if (curr instanceof DomHTMLEmbedElement) {
                a = new AppletTag((DomHTMLEmbedElement)curr);
            } else if (curr instanceof DomHTMLAppletElement) {
                a = new AppletTag((DomHTMLAppletElement)curr);
            } else if (curr instanceof DomHTMLObjectElement) {
                a = new AppletTag((DomHTMLObjectElement)curr);
            }
            a.documentbase = this.documentbase;
            allTags.add(a);
            ++j;
        }
        return allTags;
    }

    private void recurseDocument(NodeList list) {
        int length = list.getLength();
        int i = 0;
        while (i < length) {
            DomNode curr = (DomNode)list.item(i);
            if (curr instanceof DomHTMLEmbedElement || curr instanceof DomHTMLAppletElement || curr instanceof DomHTMLObjectElement) {
                this.tags.add(curr);
            }
            this.recurseDocument(curr.getChildNodes());
            ++i;
        }
    }

    static void parseParams(DomNode node, AppletTag t) {
        boolean ja = false;
        boolean jb = false;
        boolean jc = false;
        NodeList l = node.getChildNodes();
        int size = l.getLength();
        if (size != 0) {
            int i = 0;
            while (i < size) {
                Node c = l.item(i);
                if (c instanceof DomHTMLParamElement) {
                    DomHTMLParamElement curr = (DomHTMLParamElement)c;
                    String key = curr.getName();
                    String val = curr.getValue();
                    if (key.equals("java_code")) {
                        jc = true;
                        t.code = val;
                    } else if (key.equals("java_codebase")) {
                        jb = true;
                        t.codebase = val;
                    } else if (!jc && key.equals("code")) {
                        t.code = val;
                    } else if (!jc && key.equals("classid")) {
                        int x = val.indexOf(":");
                        if (x != -1) {
                            val = val.substring(x + 1);
                        }
                        t.code = val;
                    } else if (!jb && key.equals("codebase")) {
                        t.codebase = val;
                    } else if (key.equals("java_archive")) {
                        ja = true;
                        t.archives = TagParser.parseArchives(val, t);
                        val = t.archives.toString();
                    } else if (!ja && key.equals("archive")) {
                        t.archives = TagParser.parseArchives(val, t);
                        val = t.archives.toString();
                    }
                    val = TagParser.unescapeString(val);
                    t.parameters.put(key.toLowerCase(), val);
                }
                ++i;
            }
        }
    }

    private static String unescapeString(String value) {
        String unescVal = "";
        int i = 0;
        while (i < value.length()) {
            if (i == value.length() - 1) {
                unescVal = unescVal.concat(value.substring(i));
                break;
            }
            if (value.charAt(i) == '\\') {
                switch (value.charAt(i + 1)) {
                    case 'b': {
                        unescVal = unescVal.concat("\b");
                        break;
                    }
                    case 'f': {
                        unescVal = unescVal.concat("\f");
                        break;
                    }
                    case 'n': {
                        unescVal = unescVal.concat("\n");
                        break;
                    }
                    case 'r': {
                        unescVal = unescVal.concat("\r");
                        break;
                    }
                    case 't': {
                        unescVal = unescVal.concat("\t");
                        break;
                    }
                    case '\\': {
                        unescVal = unescVal.concat("\\");
                        break;
                    }
                    case '\"': {
                        unescVal = unescVal.concat("\"");
                        break;
                    }
                    default: {
                        unescVal = unescVal.concat("\\");
                        unescVal = unescVal.concat(value.substring(i + 1, i + 2));
                    }
                }
                ++i;
            } else {
                unescVal = unescVal.concat(value.substring(i, i + 1));
            }
            ++i;
        }
        return unescVal;
    }

    static ArrayList parseArchives(String arcs, AppletTag t) {
        try {
            ArrayList<URL> list = new ArrayList<URL>();
            StringTokenizer tagTokenizer = new StringTokenizer(arcs, ",");
            while (tagTokenizer.hasMoreTokens()) {
                list.add(t.prependCodeBase(tagTokenizer.nextToken().trim()));
            }
            return list;
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    static URL getLocationToURL(String location) throws IOException {
        URL tmpDocumentBase;
        block3: {
            tmpDocumentBase = null;
            try {
                tmpDocumentBase = new URL(location);
                String f = tmpDocumentBase.getFile();
                if (f.indexOf(".") == -1 && !f.endsWith(File.separator) && new File(tmpDocumentBase.getFile()).isDirectory()) {
                    tmpDocumentBase = new URL(location.concat(File.separator));
                }
            }
            catch (MalformedURLException malformedURLException) {
                String path = location.startsWith(File.separator) ? new File(location).getCanonicalPath() : new File(String.valueOf(System.getProperty("user.dir")) + File.separator + location).getCanonicalPath();
                tmpDocumentBase = new URL("file", "", path);
                if (!new File(tmpDocumentBase.getFile()).isDirectory()) break block3;
                tmpDocumentBase = new URL("file", "", String.valueOf(path) + File.separator);
            }
        }
        return tmpDocumentBase;
    }
}

