/* AvatarBannerWidget.c generated by valac 0.30.0, the Vala compiler
 * generated from AvatarBannerWidget.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <float.h>
#include <math.h>
#include <gio/gio.h>
#include <cairo.h>
#include <stdlib.h>
#include <string.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <glib/gi18n-lib.h>


#define TYPE_AVATAR_BANNER_WIDGET (avatar_banner_widget_get_type ())
#define AVATAR_BANNER_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_AVATAR_BANNER_WIDGET, AvatarBannerWidget))
#define AVATAR_BANNER_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_AVATAR_BANNER_WIDGET, AvatarBannerWidgetClass))
#define IS_AVATAR_BANNER_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_AVATAR_BANNER_WIDGET))
#define IS_AVATAR_BANNER_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_AVATAR_BANNER_WIDGET))
#define AVATAR_BANNER_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_AVATAR_BANNER_WIDGET, AvatarBannerWidgetClass))

typedef struct _AvatarBannerWidget AvatarBannerWidget;
typedef struct _AvatarBannerWidgetClass AvatarBannerWidgetClass;
typedef struct _AvatarBannerWidgetPrivate AvatarBannerWidgetPrivate;

#define TYPE_ACCOUNT (account_get_type ())
#define ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ACCOUNT, Account))
#define ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ACCOUNT, AccountClass))
#define IS_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ACCOUNT))
#define IS_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ACCOUNT))
#define ACCOUNT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ACCOUNT, AccountClass))

typedef struct _Account Account;
typedef struct _AccountClass AccountClass;

#define TYPE_PIXBUF_BUTTON (pixbuf_button_get_type ())
#define PIXBUF_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PIXBUF_BUTTON, PixbufButton))
#define PIXBUF_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PIXBUF_BUTTON, PixbufButtonClass))
#define IS_PIXBUF_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PIXBUF_BUTTON))
#define IS_PIXBUF_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PIXBUF_BUTTON))
#define PIXBUF_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PIXBUF_BUTTON, PixbufButtonClass))

typedef struct _PixbufButton PixbufButton;
typedef struct _PixbufButtonClass PixbufButtonClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _AvatarBannerWidgetLoadBannerData AvatarBannerWidgetLoadBannerData;
typedef struct _AvatarBannerWidgetFetchBannerData AvatarBannerWidgetFetchBannerData;

#define TYPE_IMAGE_CROP_DIALOG (image_crop_dialog_get_type ())
#define IMAGE_CROP_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IMAGE_CROP_DIALOG, ImageCropDialog))
#define IMAGE_CROP_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_IMAGE_CROP_DIALOG, ImageCropDialogClass))
#define IS_IMAGE_CROP_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IMAGE_CROP_DIALOG))
#define IS_IMAGE_CROP_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_IMAGE_CROP_DIALOG))
#define IMAGE_CROP_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_IMAGE_CROP_DIALOG, ImageCropDialogClass))

typedef struct _ImageCropDialog ImageCropDialog;
typedef struct _ImageCropDialogClass ImageCropDialogClass;
typedef struct _ImageCropDialogPrivate ImageCropDialogPrivate;

struct _AvatarBannerWidget {
	GtkContainer parent_instance;
	AvatarBannerWidgetPrivate * priv;
};

struct _AvatarBannerWidgetClass {
	GtkContainerClass parent_class;
};

struct _AvatarBannerWidgetPrivate {
	gint _avatar_size;
	Account* account;
	PixbufButton* set_banner_button;
	PixbufButton* set_avatar_button;
};

struct _AvatarBannerWidgetLoadBannerData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	AvatarBannerWidget* self;
	gchar* banner_name;
	Account* _tmp0_;
	gint64 _tmp1_;
	gint64 _tmp2_;
	gchar* _tmp3_;
	gchar* banner_path;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	GFileInputStream* stream;
	const gchar* _tmp9_;
	GFile* _tmp10_;
	GFile* _tmp11_;
	GFileInputStream* _tmp12_;
	GFileInputStream* _tmp13_;
	GdkPixbuf* _tmp14_;
	GFileInputStream* _tmp15_;
	GdkPixbuf* _tmp16_;
	PixbufButton* _tmp17_;
	GFileInputStream* _tmp18_;
	GError* e;
	GError* _tmp19_;
	const gchar* _tmp20_;
	GError* _tmp21_;
	const gchar* _tmp22_;
	GError * _inner_error_;
};

struct _AvatarBannerWidgetFetchBannerData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	AvatarBannerWidget* self;
	gchar* banner_path;
	Account* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	PixbufButton* _tmp3_;
	GdkPixbuf* _tmp4_;
	Account* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	GdkPixbuf* _tmp9_;
	const gchar* _tmp10_;
	GdkPixbuf* _tmp11_;
	PixbufButton* _tmp12_;
	GError* e;
	GError* _tmp13_;
	const gchar* _tmp14_;
	GError * _inner_error_;
};

struct _ImageCropDialog {
	GtkDialog parent_instance;
	ImageCropDialogPrivate * priv;
	gint min_width;
	gint min_height;
};

struct _ImageCropDialogClass {
	GtkDialogClass parent_class;
};


static gpointer avatar_banner_widget_parent_class = NULL;
extern GdkPixbuf* twitter_no_banner;

GType avatar_banner_widget_get_type (void) G_GNUC_CONST;
GType account_get_type (void) G_GNUC_CONST;
GType pixbuf_button_get_type (void) G_GNUC_CONST;
#define AVATAR_BANNER_WIDGET_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_AVATAR_BANNER_WIDGET, AvatarBannerWidgetPrivate))
enum  {
	AVATAR_BANNER_WIDGET_DUMMY_PROPERTY,
	AVATAR_BANNER_WIDGET_AVATAR_SIZE
};
#define AVATAR_BANNER_WIDGET_BANNER_RATIO 0.5
void avatar_banner_widget_set_account (AvatarBannerWidget* self, Account* account);
static void avatar_banner_widget_load_banner (AvatarBannerWidget* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void avatar_banner_widget_load_banner_finish (AvatarBannerWidget* self, GAsyncResult* _res_);
void pixbuf_button_set_bg (PixbufButton* self, cairo_surface_t* bg);
cairo_surface_t* account_get_avatar (Account* self);
static void avatar_banner_widget_load_banner_data_free (gpointer _data);
static gboolean avatar_banner_widget_load_banner_co (AvatarBannerWidgetLoadBannerData* _data_);
gchar* utils_get_banner_name (gint64 user_id);
gint64 account_get_id (Account* self);
gchar* dirs_cache (const gchar* path);
static void avatar_banner_widget_load_banner_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void pixbuf_button_set_pixbuf (PixbufButton* self, GdkPixbuf* pixbuf);
static void avatar_banner_widget_fetch_banner (AvatarBannerWidget* self, const gchar* banner_path, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void avatar_banner_widget_fetch_banner_finish (AvatarBannerWidget* self, GAsyncResult* _res_);
static gboolean avatar_banner_widget_real_draw (GtkWidget* base, cairo_t* ct);
static gint avatar_banner_widget_get_avatar_x (AvatarBannerWidget* self);
gint avatar_banner_widget_get_avatar_size (AvatarBannerWidget* self);
static gint avatar_banner_widget_get_avatar_y (AvatarBannerWidget* self);
static GtkSizeRequestMode avatar_banner_widget_real_get_request_mode (GtkWidget* base);
static void avatar_banner_widget_real_get_preferred_width (GtkWidget* base, gint* min, gint* nat);
static void avatar_banner_widget_real_get_preferred_height_for_width (GtkWidget* base, gint width, gint* min, gint* nat);
static void avatar_banner_widget_fetch_banner_data_free (gpointer _data);
static gboolean avatar_banner_widget_fetch_banner_co (AvatarBannerWidgetFetchBannerData* _data_);
const gchar* account_get_banner_url (Account* self);
void utils_download_file_async (const gchar* url, const gchar* path, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
void utils_download_file_finish (GAsyncResult* _res_);
static void avatar_banner_widget_fetch_banner_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void avatar_banner_widget_real_size_allocate (GtkWidget* base, GtkAllocation* allocation);
static void avatar_banner_widget_real_add (GtkContainer* base, GtkWidget* w);
static void avatar_banner_widget_real_remove (GtkContainer* base, GtkWidget* w);
static void avatar_banner_widget_real_forall_internal (GtkContainer* base, gboolean include_internals, GtkCallback cb, void* cb_target);
static void avatar_banner_widget_banner_clicked_cb (AvatarBannerWidget* self);
GType image_crop_dialog_get_type (void) G_GNUC_CONST;
ImageCropDialog* image_crop_dialog_new (gdouble aspect_ratio);
ImageCropDialog* image_crop_dialog_construct (GType object_type, gdouble aspect_ratio);
void image_crop_dialog_set_min_size (ImageCropDialog* self, gint min_width);
static void __lambda155_ (AvatarBannerWidget* self, GdkPixbuf* img);
static void ___lambda155__image_crop_dialog_image_cropped (ImageCropDialog* _sender, GdkPixbuf* _result_, gpointer self);
static void avatar_banner_widget_avatar_clicked_cb (AvatarBannerWidget* self);
static void __lambda156_ (AvatarBannerWidget* self, GdkPixbuf* img);
static void ___lambda156__image_crop_dialog_image_cropped (ImageCropDialog* _sender, GdkPixbuf* _result_, gpointer self);
AvatarBannerWidget* avatar_banner_widget_new (void);
AvatarBannerWidget* avatar_banner_widget_construct (GType object_type);
void avatar_banner_widget_set_avatar_size (AvatarBannerWidget* self, gint value);
static GObject * avatar_banner_widget_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
PixbufButton* pixbuf_button_new (gboolean show_menu, const gchar* menu_string);
PixbufButton* pixbuf_button_construct (GType object_type, gboolean show_menu, const gchar* menu_string);
static void _avatar_banner_widget_banner_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _avatar_banner_widget_avatar_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
GSettings* settings_get (void);
static void avatar_banner_widget_finalize (GObject* obj);
static void _vala_avatar_banner_widget_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_avatar_banner_widget_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


void avatar_banner_widget_set_account (AvatarBannerWidget* self, Account* account) {
	Account* _tmp0_ = NULL;
	PixbufButton* _tmp1_ = NULL;
	Account* _tmp2_ = NULL;
	cairo_surface_t* _tmp3_ = NULL;
	cairo_surface_t* _tmp4_ = NULL;
	g_return_if_fail (IS_AVATAR_BANNER_WIDGET (self));
	g_return_if_fail (IS_ACCOUNT (account));
	_tmp0_ = account;
	self->priv->account = _tmp0_;
	avatar_banner_widget_load_banner (self, NULL, NULL);
	gtk_widget_queue_draw (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	_tmp1_ = self->priv->set_avatar_button;
	_tmp2_ = account;
	_tmp3_ = account_get_avatar (_tmp2_);
	_tmp4_ = _tmp3_;
	pixbuf_button_set_bg (_tmp1_, (cairo_surface_t*) _tmp4_);
}


static void avatar_banner_widget_load_banner_data_free (gpointer _data) {
	AvatarBannerWidgetLoadBannerData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (AvatarBannerWidgetLoadBannerData, _data_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void avatar_banner_widget_load_banner (AvatarBannerWidget* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	AvatarBannerWidgetLoadBannerData* _data_;
	AvatarBannerWidget* _tmp0_ = NULL;
	_data_ = g_slice_new0 (AvatarBannerWidgetLoadBannerData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, avatar_banner_widget_load_banner);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, avatar_banner_widget_load_banner_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	avatar_banner_widget_load_banner_co (_data_);
}


static void avatar_banner_widget_load_banner_finish (AvatarBannerWidget* self, GAsyncResult* _res_) {
	AvatarBannerWidgetLoadBannerData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void avatar_banner_widget_load_banner_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	AvatarBannerWidgetLoadBannerData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	avatar_banner_widget_load_banner_co (_data_);
}


static gboolean avatar_banner_widget_load_banner_co (AvatarBannerWidgetLoadBannerData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->self->priv->account;
	_data_->_tmp1_ = 0LL;
	_data_->_tmp1_ = account_get_id (_data_->_tmp0_);
	_data_->_tmp2_ = 0LL;
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = utils_get_banner_name (_data_->_tmp2_);
	_data_->banner_name = _data_->_tmp3_;
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = _data_->banner_name;
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = g_strconcat ("assets/banners/", _data_->_tmp4_, NULL);
	_data_->_tmp6_ = NULL;
	_data_->_tmp6_ = _data_->_tmp5_;
	_data_->_tmp7_ = NULL;
	_data_->_tmp7_ = dirs_cache (_data_->_tmp6_);
	_data_->_tmp8_ = NULL;
	_data_->_tmp8_ = _data_->_tmp7_;
	_g_free0 (_data_->_tmp6_);
	_data_->banner_path = _data_->_tmp8_;
	{
		_data_->_tmp9_ = NULL;
		_data_->_tmp9_ = _data_->banner_path;
		_data_->_tmp10_ = NULL;
		_data_->_tmp10_ = g_file_new_for_path (_data_->_tmp9_);
		_data_->_tmp11_ = NULL;
		_data_->_tmp11_ = _data_->_tmp10_;
		_data_->_tmp12_ = NULL;
		_data_->_tmp12_ = g_file_read (_data_->_tmp11_, NULL, &_data_->_inner_error_);
		_data_->_tmp13_ = NULL;
		_data_->_tmp13_ = _data_->_tmp12_;
		_g_object_unref0 (_data_->_tmp11_);
		_data_->stream = _data_->_tmp13_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			goto __catch65_g_error;
		}
		_data_->_tmp15_ = NULL;
		_data_->_tmp15_ = _data_->stream;
		_data_->_state_ = 1;
		gdk_pixbuf_new_from_stream_async (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp15_, G_TYPE_INPUT_STREAM, GInputStream), NULL, avatar_banner_widget_load_banner_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp16_ = NULL;
		_data_->_tmp16_ = gdk_pixbuf_new_from_stream_finish (_data_->_res_, &_data_->_inner_error_);
		_data_->_tmp14_ = _data_->_tmp16_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			_g_object_unref0 (_data_->stream);
			goto __catch65_g_error;
		}
		_data_->_tmp17_ = NULL;
		_data_->_tmp17_ = _data_->self->priv->set_banner_button;
		pixbuf_button_set_pixbuf (_data_->_tmp17_, _data_->_tmp14_);
		_data_->_tmp18_ = NULL;
		_data_->_tmp18_ = _data_->stream;
		g_input_stream_close (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp18_, G_TYPE_INPUT_STREAM, GInputStream), NULL, &_data_->_inner_error_);
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			_g_object_unref0 (_data_->_tmp14_);
			_g_object_unref0 (_data_->stream);
			goto __catch65_g_error;
		}
		_g_object_unref0 (_data_->_tmp14_);
		_g_object_unref0 (_data_->stream);
	}
	goto __finally65;
	__catch65_g_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp19_ = NULL;
		_data_->_tmp19_ = _data_->e;
		if (g_error_matches (_data_->_tmp19_, G_IO_ERROR, G_IO_ERROR_NOT_FOUND)) {
			_data_->_tmp20_ = NULL;
			_data_->_tmp20_ = _data_->banner_path;
			_data_->_state_ = 2;
			avatar_banner_widget_fetch_banner (_data_->self, _data_->_tmp20_, avatar_banner_widget_load_banner_ready, _data_);
			return FALSE;
			_state_2:
			avatar_banner_widget_fetch_banner_finish (_data_->self, _data_->_res_);
		} else {
			_data_->_tmp21_ = NULL;
			_data_->_tmp21_ = _data_->e;
			_data_->_tmp22_ = NULL;
			_data_->_tmp22_ = _data_->_tmp21_->message;
			g_warning ("AvatarBannerWidget.vala:70: %s", _data_->_tmp22_);
		}
		_g_error_free0 (_data_->e);
	}
	__finally65:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		_g_free0 (_data_->banner_path);
		_g_free0 (_data_->banner_name);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	_g_free0 (_data_->banner_path);
	_g_free0 (_data_->banner_name);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static gboolean avatar_banner_widget_real_draw (GtkWidget* base, cairo_t* ct) {
	AvatarBannerWidget * self;
	gboolean result = FALSE;
	PixbufButton* _tmp0_ = NULL;
	cairo_t* _tmp1_ = NULL;
	PixbufButton* _tmp2_ = NULL;
	cairo_t* _tmp3_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_AVATAR_BANNER_WIDGET, AvatarBannerWidget);
	g_return_val_if_fail (ct != NULL, FALSE);
	_tmp0_ = self->priv->set_banner_button;
	_tmp1_ = ct;
	gtk_container_propagate_draw (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_widget_get_type (), GtkWidget), _tmp1_);
	_tmp2_ = self->priv->set_avatar_button;
	_tmp3_ = ct;
	gtk_container_propagate_draw (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_widget_get_type (), GtkWidget), _tmp3_);
	result = TRUE;
	return result;
}


static gint avatar_banner_widget_get_avatar_x (AvatarBannerWidget* self) {
	gint result = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	g_return_val_if_fail (IS_AVATAR_BANNER_WIDGET (self), 0);
	_tmp0_ = gtk_widget_get_allocated_width (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	_tmp1_ = self->priv->_avatar_size;
	result = (_tmp0_ / 2) - (_tmp1_ / 2);
	return result;
}


static gint avatar_banner_widget_get_avatar_y (AvatarBannerWidget* self) {
	gint result = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	g_return_val_if_fail (IS_AVATAR_BANNER_WIDGET (self), 0);
	_tmp0_ = gtk_widget_get_allocated_height (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	_tmp1_ = self->priv->_avatar_size;
	result = _tmp0_ - _tmp1_;
	return result;
}


static GtkSizeRequestMode avatar_banner_widget_real_get_request_mode (GtkWidget* base) {
	AvatarBannerWidget * self;
	GtkSizeRequestMode result = 0;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_AVATAR_BANNER_WIDGET, AvatarBannerWidget);
	result = GTK_SIZE_REQUEST_HEIGHT_FOR_WIDTH;
	return result;
}


static void avatar_banner_widget_real_get_preferred_width (GtkWidget* base, gint* min, gint* nat) {
	AvatarBannerWidget * self;
	gint _vala_min = 0;
	gint _vala_nat = 0;
	gint _tmp0_ = 0;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_AVATAR_BANNER_WIDGET, AvatarBannerWidget);
	_tmp0_ = self->priv->_avatar_size;
	_vala_min = _tmp0_ + 40;
	_vala_nat = _vala_min;
	if (min) {
		*min = _vala_min;
	}
	if (nat) {
		*nat = _vala_nat;
	}
}


static void avatar_banner_widget_real_get_preferred_height_for_width (GtkWidget* base, gint width, gint* min, gint* nat) {
	AvatarBannerWidget * self;
	gint _vala_min = 0;
	gint _vala_nat = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_AVATAR_BANNER_WIDGET, AvatarBannerWidget);
	_tmp0_ = width;
	_tmp1_ = self->priv->_avatar_size;
	_vala_nat = ((gint) (_tmp0_ * AVATAR_BANNER_WIDGET_BANNER_RATIO)) + (_tmp1_ / 3);
	_tmp2_ = width;
	_tmp3_ = self->priv->_avatar_size;
	_vala_min = ((gint) (_tmp2_ * AVATAR_BANNER_WIDGET_BANNER_RATIO)) + (_tmp3_ / 3);
	if (min) {
		*min = _vala_min;
	}
	if (nat) {
		*nat = _vala_nat;
	}
}


static void avatar_banner_widget_fetch_banner_data_free (gpointer _data) {
	AvatarBannerWidgetFetchBannerData* _data_;
	_data_ = _data;
	_g_free0 (_data_->banner_path);
	_g_object_unref0 (_data_->self);
	g_slice_free (AvatarBannerWidgetFetchBannerData, _data_);
}


static void avatar_banner_widget_fetch_banner (AvatarBannerWidget* self, const gchar* banner_path, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	AvatarBannerWidgetFetchBannerData* _data_;
	AvatarBannerWidget* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	_data_ = g_slice_new0 (AvatarBannerWidgetFetchBannerData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, avatar_banner_widget_fetch_banner);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, avatar_banner_widget_fetch_banner_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = banner_path;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 (_data_->banner_path);
	_data_->banner_path = _tmp2_;
	avatar_banner_widget_fetch_banner_co (_data_);
}


static void avatar_banner_widget_fetch_banner_finish (AvatarBannerWidget* self, GAsyncResult* _res_) {
	AvatarBannerWidgetFetchBannerData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void avatar_banner_widget_fetch_banner_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	AvatarBannerWidgetFetchBannerData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	avatar_banner_widget_fetch_banner_co (_data_);
}


static gboolean avatar_banner_widget_fetch_banner_co (AvatarBannerWidgetFetchBannerData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->self->priv->account;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = account_get_banner_url (_data_->_tmp0_);
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = _data_->_tmp1_;
	if (_data_->_tmp2_ == NULL) {
		_data_->_tmp3_ = NULL;
		_data_->_tmp3_ = _data_->self->priv->set_banner_button;
		_data_->_tmp4_ = NULL;
		_data_->_tmp4_ = twitter_no_banner;
		pixbuf_button_set_pixbuf (_data_->_tmp3_, _data_->_tmp4_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = _data_->self->priv->account;
	_data_->_tmp6_ = NULL;
	_data_->_tmp6_ = account_get_banner_url (_data_->_tmp5_);
	_data_->_tmp7_ = NULL;
	_data_->_tmp7_ = _data_->_tmp6_;
	_data_->_tmp8_ = NULL;
	_data_->_tmp8_ = _data_->banner_path;
	_data_->_state_ = 1;
	utils_download_file_async (_data_->_tmp7_, _data_->_tmp8_, NULL, avatar_banner_widget_fetch_banner_ready, _data_);
	return FALSE;
	_state_1:
	utils_download_file_finish (_data_->_res_);
	{
		_data_->_tmp10_ = NULL;
		_data_->_tmp10_ = _data_->banner_path;
		_data_->_tmp11_ = NULL;
		_data_->_tmp11_ = gdk_pixbuf_new_from_file (_data_->_tmp10_, &_data_->_inner_error_);
		_data_->_tmp9_ = _data_->_tmp11_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			goto __catch66_g_error;
		}
		_data_->_tmp12_ = NULL;
		_data_->_tmp12_ = _data_->self->priv->set_banner_button;
		pixbuf_button_set_pixbuf (_data_->_tmp12_, _data_->_tmp9_);
		_g_object_unref0 (_data_->_tmp9_);
	}
	goto __finally66;
	__catch66_g_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp13_ = NULL;
		_data_->_tmp13_ = _data_->e;
		_data_->_tmp14_ = NULL;
		_data_->_tmp14_ = _data_->_tmp13_->message;
		g_warning ("AvatarBannerWidget.vala:117: %s", _data_->_tmp14_);
		_g_error_free0 (_data_->e);
	}
	__finally66:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void avatar_banner_widget_real_size_allocate (GtkWidget* base, GtkAllocation* allocation) {
	AvatarBannerWidget * self;
	GtkAllocation _tmp0_ = {0};
	GtkRequisition child_requisition = {0};
	GtkAllocation child_allocation = {0};
	PixbufButton* _tmp1_ = NULL;
	GtkRequisition _tmp2_ = {0};
	GtkAllocation _tmp3_ = {0};
	gint _tmp4_ = 0;
	GtkAllocation _tmp5_ = {0};
	gint _tmp6_ = 0;
	GtkAllocation _tmp7_ = {0};
	gint _tmp8_ = 0;
	GtkAllocation _tmp9_ = {0};
	gint _tmp10_ = 0;
	PixbufButton* _tmp11_ = NULL;
	GtkAllocation _tmp12_ = {0};
	gint _tmp13_ = 0;
	GtkAllocation _tmp14_ = {0};
	gint _tmp15_ = 0;
	gint _tmp16_ = 0;
	GtkAllocation _tmp17_ = {0};
	gint _tmp18_ = 0;
	gint _tmp19_ = 0;
	gint _tmp20_ = 0;
	PixbufButton* _tmp21_ = NULL;
	GtkAllocation _tmp22_ = {0};
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_AVATAR_BANNER_WIDGET, AvatarBannerWidget);
	g_return_if_fail (allocation != NULL);
	_tmp0_ = *allocation;
	gtk_widget_set_allocation (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), &_tmp0_);
	memset (&child_allocation, 0, sizeof (GtkAllocation));
	_tmp1_ = self->priv->set_banner_button;
	gtk_widget_get_preferred_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_widget_get_type (), GtkWidget), &_tmp2_, NULL);
	child_requisition = _tmp2_;
	_tmp3_ = *allocation;
	_tmp4_ = _tmp3_.x;
	child_allocation.x = _tmp4_;
	_tmp5_ = *allocation;
	_tmp6_ = _tmp5_.y;
	child_allocation.y = _tmp6_;
	_tmp7_ = *allocation;
	_tmp8_ = _tmp7_.width;
	child_allocation.width = _tmp8_;
	_tmp9_ = *allocation;
	_tmp10_ = _tmp9_.width;
	child_allocation.height = (gint) (_tmp10_ * AVATAR_BANNER_WIDGET_BANNER_RATIO);
	_tmp11_ = self->priv->set_banner_button;
	_tmp12_ = child_allocation;
	gtk_widget_size_allocate (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, gtk_widget_get_type (), GtkWidget), &_tmp12_);
	_tmp13_ = avatar_banner_widget_get_avatar_x (self);
	_tmp14_ = *allocation;
	_tmp15_ = _tmp14_.x;
	child_allocation.x = _tmp13_ + _tmp15_;
	_tmp16_ = avatar_banner_widget_get_avatar_y (self);
	_tmp17_ = *allocation;
	_tmp18_ = _tmp17_.y;
	child_allocation.y = _tmp16_ + _tmp18_;
	_tmp19_ = self->priv->_avatar_size;
	child_allocation.width = _tmp19_;
	_tmp20_ = self->priv->_avatar_size;
	child_allocation.height = _tmp20_;
	_tmp21_ = self->priv->set_avatar_button;
	_tmp22_ = child_allocation;
	gtk_widget_size_allocate (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, gtk_widget_get_type (), GtkWidget), &_tmp22_);
}


static void avatar_banner_widget_real_add (GtkContainer* base, GtkWidget* w) {
	AvatarBannerWidget * self;
	GtkWidget* _tmp0_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_AVATAR_BANNER_WIDGET, AvatarBannerWidget);
	g_return_if_fail (GTK_IS_WIDGET (w));
	_tmp0_ = w;
	gtk_widget_set_parent (_tmp0_, (GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_container_get_type (), GtkContainer));
}


static void avatar_banner_widget_real_remove (GtkContainer* base, GtkWidget* w) {
	AvatarBannerWidget * self;
	GtkWidget* _tmp0_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_AVATAR_BANNER_WIDGET, AvatarBannerWidget);
	g_return_if_fail (GTK_IS_WIDGET (w));
	_tmp0_ = w;
	gtk_widget_unparent (_tmp0_);
}


static void avatar_banner_widget_real_forall_internal (GtkContainer* base, gboolean include_internals, GtkCallback cb, void* cb_target) {
	AvatarBannerWidget * self;
	GtkCallback _tmp0_ = NULL;
	void* _tmp0__target = NULL;
	PixbufButton* _tmp1_ = NULL;
	GtkCallback _tmp2_ = NULL;
	void* _tmp2__target = NULL;
	PixbufButton* _tmp3_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_AVATAR_BANNER_WIDGET, AvatarBannerWidget);
	_tmp0_ = cb;
	_tmp0__target = cb_target;
	_tmp1_ = self->priv->set_banner_button;
	_tmp0_ (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_widget_get_type (), GtkWidget), _tmp0__target);
	_tmp2_ = cb;
	_tmp2__target = cb_target;
	_tmp3_ = self->priv->set_avatar_button;
	_tmp2_ (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_widget_get_type (), GtkWidget), _tmp2__target);
}


static void __lambda155_ (AvatarBannerWidget* self, GdkPixbuf* img) {
	PixbufButton* _tmp0_ = NULL;
	GdkPixbuf* _tmp1_ = NULL;
	GdkPixbuf* _tmp2_ = NULL;
	g_return_if_fail (GDK_IS_PIXBUF (img));
	_tmp0_ = self->priv->set_banner_button;
	_tmp1_ = img;
	pixbuf_button_set_pixbuf (_tmp0_, _tmp1_);
	_tmp2_ = img;
	g_signal_emit_by_name (self, "banner-changed", _tmp2_);
}


static void ___lambda155__image_crop_dialog_image_cropped (ImageCropDialog* _sender, GdkPixbuf* _result_, gpointer self) {
	__lambda155_ ((AvatarBannerWidget*) self, _result_);
}


static void avatar_banner_widget_banner_clicked_cb (AvatarBannerWidget* self) {
	ImageCropDialog* dialog = NULL;
	ImageCropDialog* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GtkWidget* _tmp2_ = NULL;
	g_return_if_fail (IS_AVATAR_BANNER_WIDGET (self));
	_tmp0_ = image_crop_dialog_new (2.0);
	g_object_ref_sink (_tmp0_);
	dialog = _tmp0_;
	_tmp1_ = _ ("Select banner");
	gtk_window_set_title (G_TYPE_CHECK_INSTANCE_CAST (dialog, gtk_window_get_type (), GtkWindow), _tmp1_);
	image_crop_dialog_set_min_size (dialog, 200);
	gtk_window_set_modal (G_TYPE_CHECK_INSTANCE_CAST (dialog, gtk_window_get_type (), GtkWindow), TRUE);
	dialog->min_width = 200;
	dialog->min_height = 100;
	_tmp2_ = gtk_widget_get_toplevel (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	gtk_window_set_transient_for (G_TYPE_CHECK_INSTANCE_CAST (dialog, gtk_window_get_type (), GtkWindow), G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_window_get_type (), GtkWindow));
	g_signal_connect_object (dialog, "image-cropped", (GCallback) ___lambda155__image_crop_dialog_image_cropped, self, 0);
	gtk_widget_show_all (G_TYPE_CHECK_INSTANCE_CAST (dialog, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (dialog);
}


static void __lambda156_ (AvatarBannerWidget* self, GdkPixbuf* img) {
	PixbufButton* _tmp0_ = NULL;
	GdkPixbuf* _tmp1_ = NULL;
	GdkPixbuf* _tmp2_ = NULL;
	g_return_if_fail (GDK_IS_PIXBUF (img));
	_tmp0_ = self->priv->set_avatar_button;
	_tmp1_ = img;
	pixbuf_button_set_pixbuf (_tmp0_, _tmp1_);
	_tmp2_ = img;
	g_signal_emit_by_name (self, "avatar-changed", _tmp2_);
}


static void ___lambda156__image_crop_dialog_image_cropped (ImageCropDialog* _sender, GdkPixbuf* _result_, gpointer self) {
	__lambda156_ ((AvatarBannerWidget*) self, _result_);
}


static void avatar_banner_widget_avatar_clicked_cb (AvatarBannerWidget* self) {
	ImageCropDialog* dialog = NULL;
	ImageCropDialog* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GtkWidget* _tmp2_ = NULL;
	g_return_if_fail (IS_AVATAR_BANNER_WIDGET (self));
	_tmp0_ = image_crop_dialog_new (1.0);
	g_object_ref_sink (_tmp0_);
	dialog = _tmp0_;
	_tmp1_ = _ ("Select avatar");
	gtk_window_set_title (G_TYPE_CHECK_INSTANCE_CAST (dialog, gtk_window_get_type (), GtkWindow), _tmp1_);
	gtk_window_set_modal (G_TYPE_CHECK_INSTANCE_CAST (dialog, gtk_window_get_type (), GtkWindow), TRUE);
	_tmp2_ = gtk_widget_get_toplevel (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	gtk_window_set_transient_for (G_TYPE_CHECK_INSTANCE_CAST (dialog, gtk_window_get_type (), GtkWindow), G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_window_get_type (), GtkWindow));
	g_signal_connect_object (dialog, "image-cropped", (GCallback) ___lambda156__image_crop_dialog_image_cropped, self, 0);
	gtk_widget_show_all (G_TYPE_CHECK_INSTANCE_CAST (dialog, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (dialog);
}


AvatarBannerWidget* avatar_banner_widget_construct (GType object_type) {
	AvatarBannerWidget * self = NULL;
	self = (AvatarBannerWidget*) g_object_new (object_type, NULL);
	return self;
}


AvatarBannerWidget* avatar_banner_widget_new (void) {
	return avatar_banner_widget_construct (TYPE_AVATAR_BANNER_WIDGET);
}


gint avatar_banner_widget_get_avatar_size (AvatarBannerWidget* self) {
	gint result;
	gint _tmp0_ = 0;
	g_return_val_if_fail (IS_AVATAR_BANNER_WIDGET (self), 0);
	_tmp0_ = self->priv->_avatar_size;
	result = _tmp0_;
	return result;
}


void avatar_banner_widget_set_avatar_size (AvatarBannerWidget* self, gint value) {
	gint _tmp0_ = 0;
	g_return_if_fail (IS_AVATAR_BANNER_WIDGET (self));
	_tmp0_ = value;
	self->priv->_avatar_size = _tmp0_;
	g_object_notify ((GObject *) self, "avatar-size");
}


static void _avatar_banner_widget_banner_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	avatar_banner_widget_banner_clicked_cb ((AvatarBannerWidget*) self);
}


static void _avatar_banner_widget_avatar_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	avatar_banner_widget_avatar_clicked_cb ((AvatarBannerWidget*) self);
}


static GObject * avatar_banner_widget_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	AvatarBannerWidget * self;
	GtkStyleContext* _tmp0_ = NULL;
	PixbufButton* _tmp1_ = NULL;
	PixbufButton* _tmp2_ = NULL;
	PixbufButton* _tmp3_ = NULL;
	PixbufButton* _tmp4_ = NULL;
	PixbufButton* _tmp5_ = NULL;
	PixbufButton* _tmp6_ = NULL;
	PixbufButton* _tmp7_ = NULL;
	PixbufButton* _tmp8_ = NULL;
	GSettings* _tmp9_ = NULL;
	GSettings* _tmp10_ = NULL;
	PixbufButton* _tmp11_ = NULL;
	parent_class = G_OBJECT_CLASS (avatar_banner_widget_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_AVATAR_BANNER_WIDGET, AvatarBannerWidget);
	gtk_widget_set_has_window (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), FALSE);
	_tmp0_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	gtk_style_context_add_class (_tmp0_, "avatar");
	_tmp1_ = pixbuf_button_new (FALSE, NULL);
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->set_banner_button);
	self->priv->set_banner_button = _tmp1_;
	_tmp2_ = self->priv->set_banner_button;
	gtk_widget_show_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_widget_get_type (), GtkWidget));
	_tmp3_ = self->priv->set_banner_button;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_button_get_type (), GtkButton), "clicked", (GCallback) _avatar_banner_widget_banner_clicked_cb_gtk_button_clicked, self, 0);
	_tmp4_ = self->priv->set_banner_button;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_widget_get_type (), GtkWidget));
	_tmp5_ = pixbuf_button_new (FALSE, NULL);
	g_object_ref_sink (_tmp5_);
	_g_object_unref0 (self->priv->set_avatar_button);
	self->priv->set_avatar_button = _tmp5_;
	_tmp6_ = self->priv->set_avatar_button;
	gtk_widget_show_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_widget_get_type (), GtkWidget));
	_tmp7_ = self->priv->set_avatar_button;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_button_get_type (), GtkButton), "clicked", (GCallback) _avatar_banner_widget_avatar_clicked_cb_gtk_button_clicked, self, 0);
	_tmp8_ = self->priv->set_avatar_button;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_widget_get_type (), GtkWidget));
	_tmp9_ = settings_get ();
	_tmp10_ = _tmp9_;
	_tmp11_ = self->priv->set_avatar_button;
	g_settings_bind (_tmp10_, "round-avatars", G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, G_TYPE_OBJECT, GObject), "round", G_SETTINGS_BIND_DEFAULT);
	_g_object_unref0 (_tmp10_);
	return obj;
}


static void avatar_banner_widget_class_init (AvatarBannerWidgetClass * klass) {
	avatar_banner_widget_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (AvatarBannerWidgetPrivate));
	((GtkWidgetClass *) klass)->draw = avatar_banner_widget_real_draw;
	((GtkWidgetClass *) klass)->get_request_mode = avatar_banner_widget_real_get_request_mode;
	((GtkWidgetClass *) klass)->get_preferred_width = avatar_banner_widget_real_get_preferred_width;
	((GtkWidgetClass *) klass)->get_preferred_height_for_width = avatar_banner_widget_real_get_preferred_height_for_width;
	((GtkWidgetClass *) klass)->size_allocate = avatar_banner_widget_real_size_allocate;
	((GtkContainerClass *) klass)->add = avatar_banner_widget_real_add;
	((GtkContainerClass *) klass)->remove = avatar_banner_widget_real_remove;
	((GtkContainerClass *) klass)->forall = avatar_banner_widget_real_forall_internal;
	G_OBJECT_CLASS (klass)->get_property = _vala_avatar_banner_widget_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_avatar_banner_widget_set_property;
	G_OBJECT_CLASS (klass)->constructor = avatar_banner_widget_constructor;
	G_OBJECT_CLASS (klass)->finalize = avatar_banner_widget_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), AVATAR_BANNER_WIDGET_AVATAR_SIZE, g_param_spec_int ("avatar-size", "avatar-size", "avatar-size", G_MININT, G_MAXINT, 48, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_signal_new ("avatar_changed", TYPE_AVATAR_BANNER_WIDGET, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GDK_TYPE_PIXBUF);
	g_signal_new ("banner_changed", TYPE_AVATAR_BANNER_WIDGET, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GDK_TYPE_PIXBUF);
}


static void avatar_banner_widget_instance_init (AvatarBannerWidget * self) {
	self->priv = AVATAR_BANNER_WIDGET_GET_PRIVATE (self);
	self->priv->_avatar_size = 48;
}


static void avatar_banner_widget_finalize (GObject* obj) {
	AvatarBannerWidget * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_AVATAR_BANNER_WIDGET, AvatarBannerWidget);
	_g_object_unref0 (self->priv->set_banner_button);
	_g_object_unref0 (self->priv->set_avatar_button);
	G_OBJECT_CLASS (avatar_banner_widget_parent_class)->finalize (obj);
}


GType avatar_banner_widget_get_type (void) {
	static volatile gsize avatar_banner_widget_type_id__volatile = 0;
	if (g_once_init_enter (&avatar_banner_widget_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (AvatarBannerWidgetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) avatar_banner_widget_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AvatarBannerWidget), 0, (GInstanceInitFunc) avatar_banner_widget_instance_init, NULL };
		GType avatar_banner_widget_type_id;
		avatar_banner_widget_type_id = g_type_register_static (gtk_container_get_type (), "AvatarBannerWidget", &g_define_type_info, 0);
		g_once_init_leave (&avatar_banner_widget_type_id__volatile, avatar_banner_widget_type_id);
	}
	return avatar_banner_widget_type_id__volatile;
}


static void _vala_avatar_banner_widget_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	AvatarBannerWidget * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_AVATAR_BANNER_WIDGET, AvatarBannerWidget);
	switch (property_id) {
		case AVATAR_BANNER_WIDGET_AVATAR_SIZE:
		g_value_set_int (value, avatar_banner_widget_get_avatar_size (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_avatar_banner_widget_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	AvatarBannerWidget * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_AVATAR_BANNER_WIDGET, AvatarBannerWidget);
	switch (property_id) {
		case AVATAR_BANNER_WIDGET_AVATAR_SIZE:
		avatar_banner_widget_set_avatar_size (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



