/* AddImageButton.c generated by valac 0.30.0, the Vala compiler
 * generated from AddImageButton.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gdk/gdk.h>
#include <cairo.h>
#include <float.h>
#include <math.h>
#include <pango/pango.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>


#define TYPE_ADD_IMAGE_BUTTON (add_image_button_get_type ())
#define ADD_IMAGE_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ADD_IMAGE_BUTTON, AddImageButton))
#define ADD_IMAGE_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ADD_IMAGE_BUTTON, AddImageButtonClass))
#define IS_ADD_IMAGE_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ADD_IMAGE_BUTTON))
#define IS_ADD_IMAGE_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ADD_IMAGE_BUTTON))
#define ADD_IMAGE_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ADD_IMAGE_BUTTON, AddImageButtonClass))

typedef struct _AddImageButton AddImageButton;
typedef struct _AddImageButtonClass AddImageButtonClass;
typedef struct _AddImageButtonPrivate AddImageButtonPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _AddImageButton {
	GtkButton parent_instance;
	AddImageButtonPrivate * priv;
	gchar* image_path;
};

struct _AddImageButtonClass {
	GtkButtonClass parent_class;
};

struct _AddImageButtonPrivate {
	GdkPixbuf* _image;
	gchar* error_message;
};


static gpointer add_image_button_parent_class = NULL;

GType add_image_button_get_type (void) G_GNUC_CONST;
#define ADD_IMAGE_BUTTON_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_ADD_IMAGE_BUTTON, AddImageButtonPrivate))
enum  {
	ADD_IMAGE_BUTTON_DUMMY_PROPERTY,
	ADD_IMAGE_BUTTON_IMAGE
};
#define ADD_IMAGE_BUTTON_TARGET_STRING ((guint) 1)
#define ADD_IMAGE_BUTTON_TARGET_URI_LIST ((guint) 2)
#define ADD_IMAGE_BUTTON_TARGET_IMAGE ((guint) 3)
#define ADD_IMAGE_BUTTON_ICON_SIZE 32
AddImageButton* add_image_button_new (void);
AddImageButton* add_image_button_construct (GType object_type);
static void __lambda60_ (AddImageButton* self);
static void ___lambda60__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void add_image_button_drag_data_received_cb (AddImageButton* self, GdkDragContext* context, gint x, gint y, GtkSelectionData* selection_data, guint info, guint time);
static void _add_image_button_drag_data_received_cb_gtk_widget_drag_data_received (GtkWidget* _sender, GdkDragContext* context, gint x, gint y, GtkSelectionData* selection_data, guint info, guint time_, gpointer self);
static gboolean add_image_button_real_draw (GtkWidget* base, cairo_t* ct);
static void add_image_button_from_file (AddImageButton* self, GFile* file);
static void add_image_button_from_bigger_pixbuf (AddImageButton* self, GdkPixbuf* pixbuf);
GdkPixbuf* utils_slice_pixbuf (GdkPixbuf* pic, gint thumb_width, gint thumb_height);
#define MULTI_MEDIA_WIDGET_HEIGHT 60
void add_image_button_set_image (AddImageButton* self, GdkPixbuf* value);
void add_image_button_set_error (AddImageButton* self, const gchar* error_message);
GdkPixbuf* add_image_button_get_image (AddImageButton* self);
void add_image_button_start_progress (AddImageButton* self);
void add_image_button_set_success (AddImageButton* self);
static GObject * add_image_button_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void add_image_button_finalize (GObject* obj);
static void _vala_add_image_button_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_add_image_button_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static void __lambda60_ (AddImageButton* self) {
	gboolean _tmp0_ = FALSE;
	GdkPixbuf* _tmp1_ = NULL;
	_tmp1_ = self->priv->_image;
	if (_tmp1_ == NULL) {
		const gchar* _tmp2_ = NULL;
		_tmp2_ = self->priv->error_message;
		_tmp0_ = _tmp2_ == NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		g_signal_emit_by_name (self, "add-clicked");
	} else {
		_g_free0 (self->priv->error_message);
		self->priv->error_message = NULL;
		g_signal_emit_by_name (self, "remove-clicked");
	}
}


static void ___lambda60__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	__lambda60_ ((AddImageButton*) self);
}


static void _add_image_button_drag_data_received_cb_gtk_widget_drag_data_received (GtkWidget* _sender, GdkDragContext* context, gint x, gint y, GtkSelectionData* selection_data, guint info, guint time_, gpointer self) {
	add_image_button_drag_data_received_cb ((AddImageButton*) self, context, x, y, selection_data, info, time_);
}


AddImageButton* add_image_button_construct (GType object_type) {
	AddImageButton * self = NULL;
	static const GtkTargetEntry target_entries[] = {{"STRING", (guint) 0, ADD_IMAGE_BUTTON_TARGET_STRING}, {"text/plain", (guint) 0, ADD_IMAGE_BUTTON_TARGET_STRING}, {"text/uri-list", (guint) 0, ADD_IMAGE_BUTTON_TARGET_URI_LIST}, {"image/png", (guint) 0, ADD_IMAGE_BUTTON_TARGET_IMAGE}, {"image/jpeg", (guint) 0, ADD_IMAGE_BUTTON_TARGET_IMAGE}};
	self = (AddImageButton*) g_object_new (object_type, NULL);
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_button_get_type (), GtkButton), "clicked", (GCallback) ___lambda60__gtk_button_clicked, self, 0);
	gtk_drag_dest_set (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), GTK_DEST_DEFAULT_ALL, target_entries, G_N_ELEMENTS (target_entries), GDK_ACTION_COPY);
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), "drag-data-received", (GCallback) _add_image_button_drag_data_received_cb_gtk_widget_drag_data_received, self, 0);
	return self;
}


AddImageButton* add_image_button_new (void) {
	return add_image_button_construct (TYPE_ADD_IMAGE_BUTTON);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gboolean add_image_button_real_draw (GtkWidget* base, cairo_t* ct) {
	AddImageButton * self;
	gboolean result = FALSE;
	gint widget_width = 0;
	gint _tmp0_ = 0;
	gint widget_height = 0;
	gint _tmp1_ = 0;
	GtkStyleContext* style_context = NULL;
	GtkStyleContext* _tmp2_ = NULL;
	GtkStyleContext* _tmp3_ = NULL;
	GdkPixbuf* _tmp4_ = NULL;
	cairo_t* _tmp18_ = NULL;
	const gchar* _tmp19_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_ADD_IMAGE_BUTTON, AddImageButton);
	g_return_val_if_fail (ct != NULL, FALSE);
	_tmp0_ = gtk_widget_get_allocated_width (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	widget_width = _tmp0_;
	_tmp1_ = gtk_widget_get_allocated_height (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	widget_height = _tmp1_;
	_tmp2_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	_tmp3_ = _g_object_ref0 (_tmp2_);
	style_context = _tmp3_;
	_tmp4_ = self->priv->_image;
	if (_tmp4_ != NULL) {
		cairo_t* _tmp5_ = NULL;
		cairo_t* _tmp6_ = NULL;
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
		gdouble scale = 0.0;
		gint _tmp9_ = 0;
		GdkPixbuf* _tmp10_ = NULL;
		gint _tmp11_ = 0;
		cairo_t* _tmp12_ = NULL;
		gdouble _tmp13_ = 0.0;
		cairo_t* _tmp14_ = NULL;
		GdkPixbuf* _tmp15_ = NULL;
		cairo_t* _tmp16_ = NULL;
		cairo_t* _tmp17_ = NULL;
		_tmp5_ = ct;
		cairo_save (_tmp5_);
		_tmp6_ = ct;
		_tmp7_ = widget_width;
		_tmp8_ = widget_height;
		cairo_rectangle (_tmp6_, (gdouble) 0, (gdouble) 0, (gdouble) _tmp7_, (gdouble) _tmp8_);
		_tmp9_ = widget_width;
		_tmp10_ = self->priv->_image;
		_tmp11_ = gdk_pixbuf_get_width (_tmp10_);
		scale = ((gdouble) _tmp9_) / _tmp11_;
		_tmp12_ = ct;
		_tmp13_ = scale;
		cairo_scale (_tmp12_, _tmp13_, (gdouble) 1);
		_tmp14_ = ct;
		_tmp15_ = self->priv->_image;
		gdk_cairo_set_source_pixbuf (_tmp14_, _tmp15_, (gdouble) 0, (gdouble) 0);
		_tmp16_ = ct;
		cairo_fill (_tmp16_);
		_tmp17_ = ct;
		cairo_restore (_tmp17_);
	}
	_tmp18_ = ct;
	GTK_WIDGET_CLASS (add_image_button_parent_class)->draw (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_button_get_type (), GtkButton), gtk_widget_get_type (), GtkWidget), _tmp18_);
	_tmp19_ = self->priv->error_message;
	if (_tmp19_ == NULL) {
		GtkStyleContext* _tmp20_ = NULL;
		cairo_t* _tmp21_ = NULL;
		gint _tmp22_ = 0;
		gint _tmp23_ = 0;
		_tmp20_ = style_context;
		_tmp21_ = ct;
		_tmp22_ = widget_width;
		_tmp23_ = widget_height;
		gtk_render_check (_tmp20_, _tmp21_, (_tmp22_ / 2.0) - (ADD_IMAGE_BUTTON_ICON_SIZE / 2.0), (_tmp23_ / 2.0) - (ADD_IMAGE_BUTTON_ICON_SIZE / 2.0), (gdouble) ADD_IMAGE_BUTTON_ICON_SIZE, (gdouble) ADD_IMAGE_BUTTON_ICON_SIZE);
	} else {
		GtkStyleContext* _tmp24_ = NULL;
		cairo_t* _tmp25_ = NULL;
		gint _tmp26_ = 0;
		PangoLayout* error_layout = NULL;
		const gchar* _tmp27_ = NULL;
		PangoLayout* _tmp28_ = NULL;
		PangoLayout* _tmp29_ = NULL;
		gint _tmp30_ = 0;
		PangoLayout* _tmp31_ = NULL;
		gint _tmp32_ = 0;
		GtkStyleContext* _tmp33_ = NULL;
		cairo_t* _tmp34_ = NULL;
		gint _tmp35_ = 0;
		PangoLayout* _tmp36_ = NULL;
		gint _tmp37_ = 0;
		PangoLayout* _tmp38_ = NULL;
		_tmp24_ = style_context;
		_tmp25_ = ct;
		_tmp26_ = widget_height;
		gtk_render_check (_tmp24_, _tmp25_, (gdouble) 20, (_tmp26_ / 2.0) - (ADD_IMAGE_BUTTON_ICON_SIZE / 2.0), (gdouble) ADD_IMAGE_BUTTON_ICON_SIZE, (gdouble) ADD_IMAGE_BUTTON_ICON_SIZE);
		_tmp27_ = self->priv->error_message;
		_tmp28_ = gtk_widget_create_pango_layout (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), _tmp27_);
		error_layout = _tmp28_;
		_tmp29_ = error_layout;
		_tmp30_ = widget_width;
		pango_layout_set_width (_tmp29_, ((((_tmp30_ - ADD_IMAGE_BUTTON_ICON_SIZE) - 20) - 20) - 20) * PANGO_SCALE);
		_tmp31_ = error_layout;
		_tmp32_ = widget_height;
		pango_layout_set_height (_tmp31_, (_tmp32_ - 20) * PANGO_SCALE);
		_tmp33_ = style_context;
		_tmp34_ = ct;
		_tmp35_ = widget_height;
		_tmp36_ = error_layout;
		_tmp37_ = pango_layout_get_height (_tmp36_);
		_tmp38_ = error_layout;
		gtk_render_layout (_tmp33_, _tmp34_, (gdouble) ((20 + ADD_IMAGE_BUTTON_ICON_SIZE) + 20), (_tmp35_ / 2.0) - ((_tmp37_ / PANGO_SCALE) / 2.0), _tmp38_);
		_g_object_unref0 (error_layout);
	}
	result = FALSE;
	_g_object_unref0 (style_context);
	return result;
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}


static void add_image_button_drag_data_received_cb (AddImageButton* self, GdkDragContext* context, gint x, gint y, GtkSelectionData* selection_data, guint info, guint time) {
	guint _tmp0_ = 0U;
	g_return_if_fail (IS_ADD_IMAGE_BUTTON (self));
	g_return_if_fail (GDK_IS_DRAG_CONTEXT (context));
	g_return_if_fail (selection_data != NULL);
	_tmp0_ = info;
	if (_tmp0_ == ADD_IMAGE_BUTTON_TARGET_STRING) {
		gchar* uri = NULL;
		GtkSelectionData* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		GFile* file = NULL;
		const gchar* _tmp6_ = NULL;
		GFile* _tmp7_ = NULL;
		GFile* _tmp8_ = NULL;
		_tmp1_ = selection_data;
		_tmp2_ = gtk_selection_data_get_text (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = string_strip (_tmp3_);
		_tmp5_ = _tmp4_;
		_g_free0 (_tmp3_);
		uri = _tmp5_;
		_tmp6_ = uri;
		_tmp7_ = g_file_new_for_uri (_tmp6_);
		file = _tmp7_;
		_tmp8_ = file;
		add_image_button_from_file (self, _tmp8_);
		_g_object_unref0 (file);
		_g_free0 (uri);
	} else {
		guint _tmp9_ = 0U;
		_tmp9_ = info;
		if (_tmp9_ == ADD_IMAGE_BUTTON_TARGET_IMAGE) {
			GdkPixbuf* pixbuf = NULL;
			GtkSelectionData* _tmp10_ = NULL;
			GdkPixbuf* _tmp11_ = NULL;
			GdkPixbuf* _tmp12_ = NULL;
			_tmp10_ = selection_data;
			_tmp11_ = gtk_selection_data_get_pixbuf (_tmp10_);
			pixbuf = _tmp11_;
			_tmp12_ = pixbuf;
			add_image_button_from_bigger_pixbuf (self, _tmp12_);
			_g_object_unref0 (pixbuf);
		} else {
			guint _tmp13_ = 0U;
			_tmp13_ = info;
			if (_tmp13_ == ADD_IMAGE_BUTTON_TARGET_URI_LIST) {
				gchar** uris = NULL;
				GtkSelectionData* _tmp14_ = NULL;
				gchar** _tmp15_ = NULL;
				gchar** _tmp16_ = NULL;
				gint uris_length1 = 0;
				gint _uris_size_ = 0;
				GFile* file = NULL;
				gchar** _tmp17_ = NULL;
				gint _tmp17__length1 = 0;
				const gchar* _tmp18_ = NULL;
				GFile* _tmp19_ = NULL;
				GFile* _tmp20_ = NULL;
				gchar* _tmp21_ = NULL;
				gchar* _tmp22_ = NULL;
				gboolean _tmp23_ = FALSE;
				_tmp14_ = selection_data;
				_tmp16_ = _tmp15_ = gtk_selection_data_get_uris (_tmp14_);
				uris = _tmp16_;
				uris_length1 = _vala_array_length (_tmp15_);
				_uris_size_ = uris_length1;
				_tmp17_ = uris;
				_tmp17__length1 = uris_length1;
				_tmp18_ = _tmp17_[0];
				_tmp19_ = g_file_new_for_uri (_tmp18_);
				file = _tmp19_;
				_tmp20_ = file;
				_tmp21_ = g_file_get_uri_scheme (_tmp20_);
				_tmp22_ = _tmp21_;
				_tmp23_ = g_strcmp0 (_tmp22_, "file") == 0;
				_g_free0 (_tmp22_);
				if (_tmp23_) {
					GFile* _tmp24_ = NULL;
					_tmp24_ = file;
					add_image_button_from_file (self, _tmp24_);
				}
				_g_object_unref0 (file);
				uris = (_vala_array_free (uris, uris_length1, (GDestroyNotify) g_free), NULL);
			}
		}
	}
}


static void add_image_button_from_file (AddImageButton* self, GFile* file) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (IS_ADD_IMAGE_BUTTON (self));
	g_return_if_fail (G_IS_FILE (file));
	{
		GdkPixbuf* pixbuf = NULL;
		GFile* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		GdkPixbuf* _tmp3_ = NULL;
		GdkPixbuf* _tmp4_ = NULL;
		GFile* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		_tmp0_ = file;
		_tmp1_ = g_file_get_path (_tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = gdk_pixbuf_new_from_file (_tmp2_, &_inner_error_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		pixbuf = _tmp4_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch71_g_error;
		}
		_tmp5_ = file;
		_tmp6_ = g_file_get_path (_tmp5_);
		_g_free0 (self->image_path);
		self->image_path = _tmp6_;
		add_image_button_from_bigger_pixbuf (self, pixbuf);
		_g_object_unref0 (pixbuf);
	}
	goto __finally71;
	__catch71_g_error:
	{
		GError* e = NULL;
		GError* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		g_warning ("AddImageButton.vala:155: %s", _tmp8_);
		_g_error_free0 (e);
	}
	__finally71:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void add_image_button_from_bigger_pixbuf (AddImageButton* self, GdkPixbuf* pixbuf) {
	GdkPixbuf* thumb = NULL;
	GdkPixbuf* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	GdkPixbuf* _tmp2_ = NULL;
	g_return_if_fail (IS_ADD_IMAGE_BUTTON (self));
	g_return_if_fail (GDK_IS_PIXBUF (pixbuf));
	_tmp0_ = pixbuf;
	_tmp1_ = gtk_widget_get_allocated_width (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	_tmp2_ = utils_slice_pixbuf (_tmp0_, _tmp1_, MULTI_MEDIA_WIDGET_HEIGHT);
	thumb = _tmp2_;
	add_image_button_set_image (self, thumb);
	_g_object_unref0 (thumb);
}


void add_image_button_set_error (AddImageButton* self, const gchar* error_message) {
	GtkStyleContext* _tmp0_ = NULL;
	GtkStyleContext* _tmp1_ = NULL;
	GtkStyleContext* _tmp2_ = NULL;
	GdkPixbuf* _tmp3_ = NULL;
	GdkPixbuf* _tmp4_ = NULL;
	GtkStyleContext* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	g_return_if_fail (IS_ADD_IMAGE_BUTTON (self));
	g_return_if_fail (error_message != NULL);
	_tmp0_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	gtk_style_context_remove_class (_tmp0_, "image-progress");
	_tmp1_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	gtk_style_context_remove_class (_tmp1_, "image-success");
	_tmp2_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	gtk_style_context_add_class (_tmp2_, "image-added");
	_tmp3_ = add_image_button_get_image (self);
	_tmp4_ = _tmp3_;
	if (_tmp4_ == NULL) {
		g_warning ("AddImageButton.vala:170: Progress started but image == null");
	}
	_tmp5_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	gtk_style_context_add_class (_tmp5_, "image-error");
	_tmp6_ = error_message;
	_tmp7_ = g_strdup (_tmp6_);
	_g_free0 (self->priv->error_message);
	self->priv->error_message = _tmp7_;
	_tmp8_ = _ ("Click to remove image");
	gtk_widget_set_tooltip_text (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), _tmp8_);
}


void add_image_button_start_progress (AddImageButton* self) {
	GtkStyleContext* _tmp0_ = NULL;
	GdkPixbuf* _tmp1_ = NULL;
	GdkPixbuf* _tmp2_ = NULL;
	GtkStyleContext* _tmp3_ = NULL;
	g_return_if_fail (IS_ADD_IMAGE_BUTTON (self));
	_tmp0_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	gtk_style_context_remove_class (_tmp0_, "image-added");
	_tmp1_ = add_image_button_get_image (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == NULL) {
		g_warning ("AddImageButton.vala:181: Progress started but image == null");
	}
	_tmp3_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	gtk_style_context_add_class (_tmp3_, "image-progress");
}


void add_image_button_set_success (AddImageButton* self) {
	GtkStyleContext* _tmp0_ = NULL;
	GtkStyleContext* _tmp1_ = NULL;
	GdkPixbuf* _tmp2_ = NULL;
	GdkPixbuf* _tmp3_ = NULL;
	GtkStyleContext* _tmp4_ = NULL;
	g_return_if_fail (IS_ADD_IMAGE_BUTTON (self));
	_tmp0_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	gtk_style_context_remove_class (_tmp0_, "image-progress");
	_tmp1_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	gtk_style_context_remove_class (_tmp1_, "image-added");
	_tmp2_ = add_image_button_get_image (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		g_warning ("AddImageButton.vala:191: Progress started but image == null");
	}
	_tmp4_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	gtk_style_context_add_class (_tmp4_, "image-success");
	gtk_widget_set_tooltip_text (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), "");
}


GdkPixbuf* add_image_button_get_image (AddImageButton* self) {
	GdkPixbuf* result;
	GdkPixbuf* _tmp0_ = NULL;
	g_return_val_if_fail (IS_ADD_IMAGE_BUTTON (self), NULL);
	_tmp0_ = self->priv->_image;
	result = _tmp0_;
	return result;
}


void add_image_button_set_image (AddImageButton* self, GdkPixbuf* value) {
	GdkPixbuf* _tmp0_ = NULL;
	GdkPixbuf* _tmp1_ = NULL;
	GdkPixbuf* _tmp2_ = NULL;
	g_return_if_fail (IS_ADD_IMAGE_BUTTON (self));
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_image);
	self->priv->_image = _tmp1_;
	_tmp2_ = value;
	if (_tmp2_ != NULL) {
		GtkStyleContext* _tmp3_ = NULL;
		GtkStyleContext* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		_tmp3_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
		gtk_style_context_remove_class (_tmp3_, "image-placeholder");
		_tmp4_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
		gtk_style_context_add_class (_tmp4_, "image-added");
		_tmp5_ = _ ("Click to remove image");
		gtk_widget_set_tooltip_text (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), _tmp5_);
	} else {
		GtkStyleContext* _tmp6_ = NULL;
		GtkStyleContext* _tmp7_ = NULL;
		GtkStyleContext* _tmp8_ = NULL;
		GtkStyleContext* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		_tmp6_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
		gtk_style_context_add_class (_tmp6_, "image-placeholder");
		_tmp7_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
		gtk_style_context_remove_class (_tmp7_, "image-added");
		_tmp8_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
		gtk_style_context_remove_class (_tmp8_, "image-error");
		_tmp9_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
		gtk_style_context_remove_class (_tmp9_, "image-progress");
		_tmp10_ = _ ("Click to add image");
		gtk_widget_set_tooltip_text (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), _tmp10_);
	}
	gtk_widget_queue_draw (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	g_object_notify ((GObject *) self, "image");
}


static GObject * add_image_button_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	AddImageButton * self;
	parent_class = G_OBJECT_CLASS (add_image_button_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_ADD_IMAGE_BUTTON, AddImageButton);
	add_image_button_set_image (self, NULL);
	gtk_widget_set_size_request (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), -1, MULTI_MEDIA_WIDGET_HEIGHT);
	return obj;
}


static void add_image_button_class_init (AddImageButtonClass * klass) {
	add_image_button_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (AddImageButtonPrivate));
	((GtkWidgetClass *) klass)->draw = add_image_button_real_draw;
	G_OBJECT_CLASS (klass)->get_property = _vala_add_image_button_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_add_image_button_set_property;
	G_OBJECT_CLASS (klass)->constructor = add_image_button_constructor;
	G_OBJECT_CLASS (klass)->finalize = add_image_button_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), ADD_IMAGE_BUTTON_IMAGE, g_param_spec_object ("image", "image", "image", GDK_TYPE_PIXBUF, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_signal_new ("add_clicked", TYPE_ADD_IMAGE_BUTTON, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("remove_clicked", TYPE_ADD_IMAGE_BUTTON, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void add_image_button_instance_init (AddImageButton * self) {
	self->priv = ADD_IMAGE_BUTTON_GET_PRIVATE (self);
	self->image_path = NULL;
	self->priv->error_message = NULL;
}


static void add_image_button_finalize (GObject* obj) {
	AddImageButton * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_ADD_IMAGE_BUTTON, AddImageButton);
	_g_object_unref0 (self->priv->_image);
	_g_free0 (self->image_path);
	_g_free0 (self->priv->error_message);
	G_OBJECT_CLASS (add_image_button_parent_class)->finalize (obj);
}


/**
 * Trimmed-down version of MediaButton, used in the Compose Widow
 * to add new images.
 */
GType add_image_button_get_type (void) {
	static volatile gsize add_image_button_type_id__volatile = 0;
	if (g_once_init_enter (&add_image_button_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (AddImageButtonClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) add_image_button_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AddImageButton), 0, (GInstanceInitFunc) add_image_button_instance_init, NULL };
		GType add_image_button_type_id;
		add_image_button_type_id = g_type_register_static (gtk_button_get_type (), "AddImageButton", &g_define_type_info, 0);
		g_once_init_leave (&add_image_button_type_id__volatile, add_image_button_type_id);
	}
	return add_image_button_type_id__volatile;
}


static void _vala_add_image_button_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	AddImageButton * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_ADD_IMAGE_BUTTON, AddImageButton);
	switch (property_id) {
		case ADD_IMAGE_BUTTON_IMAGE:
		g_value_set_object (value, add_image_button_get_image (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_add_image_button_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	AddImageButton * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_ADD_IMAGE_BUTTON, AddImageButton);
	switch (property_id) {
		case ADD_IMAGE_BUTTON_IMAGE:
		add_image_button_set_image (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



