/* Tweet.c generated by valac 0.30.0, the Vala compiler
 * generated from Tweet.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <json-glib/json-glib.h>
#include <cairo.h>
#include <gobject/gvaluecollector.h>


#define TYPE_USER_IDENTITY (user_identity_get_type ())
typedef struct _UserIdentity UserIdentity;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_MINI_TWEET (mini_tweet_get_type ())
#define MINI_TWEET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MINI_TWEET, MiniTweet))
#define MINI_TWEET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MINI_TWEET, MiniTweetClass))
#define IS_MINI_TWEET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MINI_TWEET))
#define IS_MINI_TWEET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MINI_TWEET))
#define MINI_TWEET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MINI_TWEET, MiniTweetClass))

typedef struct _MiniTweet MiniTweet;
typedef struct _MiniTweetClass MiniTweetClass;
typedef struct _MiniTweetPrivate MiniTweetPrivate;

#define TYPE_TEXT_ENTITY (text_entity_get_type ())
typedef struct _TextEntity TextEntity;

#define TYPE_MEDIA (media_get_type ())
#define MEDIA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA, Media))
#define MEDIA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA, MediaClass))
#define IS_MEDIA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA))
#define IS_MEDIA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA))
#define MEDIA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA, MediaClass))

typedef struct _Media Media;
typedef struct _MediaClass MediaClass;
typedef struct _ParamSpecMiniTweet ParamSpecMiniTweet;
#define _user_identity_free0(var) ((var == NULL) ? NULL : (var = (user_identity_free (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _mini_tweet_unref0(var) ((var == NULL) ? NULL : (var = (mini_tweet_unref (var), NULL)))
typedef struct _Block15Data Block15Data;
typedef struct _MediaPrivate MediaPrivate;

#define TYPE_MEDIA_TYPE (media_type_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _json_array_unref0(var) ((var == NULL) ? NULL : (var = (json_array_unref (var), NULL)))
#define _json_object_unref0(var) ((var == NULL) ? NULL : (var = (json_object_unref (var), NULL)))

#define TYPE_INLINE_MEDIA_DOWNLOADER (inline_media_downloader_get_type ())
#define INLINE_MEDIA_DOWNLOADER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_INLINE_MEDIA_DOWNLOADER, InlineMediaDownloader))
#define INLINE_MEDIA_DOWNLOADER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_INLINE_MEDIA_DOWNLOADER, InlineMediaDownloaderClass))
#define IS_INLINE_MEDIA_DOWNLOADER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_INLINE_MEDIA_DOWNLOADER))
#define IS_INLINE_MEDIA_DOWNLOADER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_INLINE_MEDIA_DOWNLOADER))
#define INLINE_MEDIA_DOWNLOADER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_INLINE_MEDIA_DOWNLOADER, InlineMediaDownloaderClass))

typedef struct _InlineMediaDownloader InlineMediaDownloader;
typedef struct _InlineMediaDownloaderClass InlineMediaDownloaderClass;

#define TYPE_TWEET (tweet_get_type ())
#define TWEET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWEET, Tweet))
#define TWEET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWEET, TweetClass))
#define IS_TWEET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWEET))
#define IS_TWEET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWEET))
#define TWEET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWEET, TweetClass))

typedef struct _Tweet Tweet;
typedef struct _TweetClass TweetClass;
typedef struct _TweetPrivate TweetPrivate;
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))

#define TYPE_ACCOUNT (account_get_type ())
#define ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ACCOUNT, Account))
#define ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ACCOUNT, AccountClass))
#define IS_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ACCOUNT))
#define IS_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ACCOUNT))
#define ACCOUNT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ACCOUNT, AccountClass))

typedef struct _Account Account;
typedef struct _AccountClass AccountClass;

#define TYPE_TWITTER (twitter_get_type ())
#define TWITTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWITTER, Twitter))
#define TWITTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWITTER, TwitterClass))
#define IS_TWITTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWITTER))
#define IS_TWITTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWITTER))
#define TWITTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWITTER, TwitterClass))

typedef struct _Twitter Twitter;
typedef struct _TwitterClass TwitterClass;

#define TYPE_TRANSFORM_FLAGS (transform_flags_get_type ())

struct _UserIdentity {
	gint64 id;
	gchar* screen_name;
	gchar* user_name;
};

struct _TextEntity {
	guint from;
	guint to;
	gchar* display_text;
	gchar* tooltip_text;
	gchar* target;
	guint info;
};

struct _MiniTweet {
	GTypeInstance parent_instance;
	volatile int ref_count;
	MiniTweetPrivate * priv;
	gint64 id;
	gint64 created_at;
	UserIdentity author;
	gchar* text;
	TextEntity* entities;
	gint entities_length1;
	Media** medias;
	gint medias_length1;
};

struct _MiniTweetClass {
	GTypeClass parent_class;
	void (*finalize) (MiniTweet *self);
};

struct _ParamSpecMiniTweet {
	GParamSpec parent_instance;
};

struct _Block15Data {
	int _ref_count_;
	gint real_media_count;
	gint url_index;
	MiniTweet* mt;
};

typedef enum  {
	MEDIA_TYPE_IMAGE,
	MEDIA_TYPE_VINE,
	MEDIA_TYPE_GIF,
	MEDIA_TYPE_ANIMATED_GIF,
	MEDIA_TYPE_TWITTER_VIDEO,
	MEDIA_TYPE_UNKNOWN
} MediaType;

struct _Media {
	GObject parent_instance;
	MediaPrivate * priv;
	gint64 id;
	gchar* path;
	gchar* thumb_path;
	gchar* url;
	MediaType type;
	cairo_surface_t* thumbnail;
	gboolean loaded;
	gboolean invalid;
};

struct _MediaClass {
	GObjectClass parent_class;
};

struct _Tweet {
	GObject parent_instance;
	TweetPrivate * priv;
	guint hidden_flags;
	gint64 id;
	MiniTweet* source_tweet;
	MiniTweet* retweeted_tweet;
	MiniTweet* quoted_tweet;
	gchar* avatar_url;
	gboolean verified;
	gint64 my_retweet;
	gboolean protected;
	gchar* notification_id;
	gint64 reply_id;
	gint retweet_count;
	gint favorite_count;
};

struct _TweetClass {
	GObjectClass parent_class;
};

struct _TweetPrivate {
	gboolean _retweeted;
	gboolean _favorited;
	gboolean _deleted;
	cairo_surface_t* _avatar;
	gboolean _seen;
};

typedef void (*TwitterAvatarDownloadedFunc) (cairo_surface_t* avatar, void* user_data);
typedef enum  {
	TRANSFORM_FLAGS_REMOVE_MEDIA_LINKS = 1 << 0,
	TRANSFORM_FLAGS_REMOVE_TRAILING_HASHTAGS = 1 << 1,
	TRANSFORM_FLAGS_EXPAND_LINKS = 1 << 2
} TransformFlags;


static gpointer mini_tweet_parent_class = NULL;
static gpointer tweet_parent_class = NULL;
extern cairo_surface_t* twitter_no_avatar;

GType user_identity_get_type (void) G_GNUC_CONST;
UserIdentity* user_identity_dup (const UserIdentity* self);
void user_identity_free (UserIdentity* self);
void user_identity_copy (const UserIdentity* self, UserIdentity* dest);
void user_identity_destroy (UserIdentity* self);
UserIdentity* parse_identity (JsonObject* user_obj);
gpointer mini_tweet_ref (gpointer instance);
void mini_tweet_unref (gpointer instance);
GParamSpec* param_spec_mini_tweet (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_mini_tweet (GValue* value, gpointer v_object);
void value_take_mini_tweet (GValue* value, gpointer v_object);
gpointer value_get_mini_tweet (const GValue* value);
GType mini_tweet_get_type (void) G_GNUC_CONST;
GType text_entity_get_type (void) G_GNUC_CONST;
TextEntity* text_entity_dup (const TextEntity* self);
void text_entity_free (TextEntity* self);
void text_entity_copy (const TextEntity* self, TextEntity* dest);
void text_entity_destroy (TextEntity* self);
GType media_get_type (void) G_GNUC_CONST;
enum  {
	MINI_TWEET_DUMMY_PROPERTY
};
static void _vala_TextEntity_array_free (TextEntity* array, gint array_length);
MiniTweet* mini_tweet_new (void);
MiniTweet* mini_tweet_construct (GType object_type);
static void mini_tweet_finalize (MiniTweet* obj);
MiniTweet* parse_mini_tweet (JsonObject* status);
GDateTime* utils_parse_date (const gchar* input);
void parse_entities (MiniTweet* mt, JsonObject* status);
static Block15Data* block15_data_ref (Block15Data* _data15_);
static void block15_data_unref (void * _userdata_);
gint utils_get_json_array_size (JsonObject* node, const gchar* object_name);
static void __lambda26_ (Block15Data* _data15_, JsonArray* arr, guint index, JsonNode* node);
gboolean is_media_candidate (const gchar* url);
Media* media_new (void);
Media* media_construct (GType object_type);
GType media_type_get_type (void) G_GNUC_CONST;
MediaType media_type_from_url (const gchar* url);
static void ___lambda26__json_array_foreach (JsonArray* array, guint index_, JsonNode* element_node, gpointer self);
static void __lambda27_ (Block15Data* _data15_, JsonArray* arr, guint index, JsonNode* node);
static void ___lambda27__json_array_foreach (JsonArray* array, guint index_, JsonNode* element_node, gpointer self);
static void __lambda28_ (Block15Data* _data15_, JsonArray* arr, guint index, JsonNode* node);
static void ___lambda28__json_array_foreach (JsonArray* array, guint index_, JsonNode* element_node, gpointer self);
static void ___lambda29_ (Block15Data* _data15_, JsonArray* arr, guint index, JsonNode* node);
void media_set_target_url (Media* self, const gchar* value);
static void ____lambda29__json_array_foreach (JsonArray* array, guint index_, JsonNode* element_node, gpointer self);
static void ___lambda30_ (Block15Data* _data15_, JsonArray* arr, guint index, JsonNode* node);
MediaType media_type_from_string (const gchar* s);
void media_set_thumb_url (Media* self, const gchar* value);
static void ____lambda30__json_array_foreach (JsonArray* array, guint index_, JsonNode* element_node, gpointer self);
GType inline_media_downloader_get_type (void) G_GNUC_CONST;
InlineMediaDownloader* inline_media_downloader_get (void);
void inline_media_downloader_load_all_media (InlineMediaDownloader* self, MiniTweet* t, Media** medias, int medias_length1);
void tweet_utils_sort_entities (TextEntity** entities, int* entities_length1);
GType tweet_get_type (void) G_GNUC_CONST;
#define TWEET_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_TWEET, TweetPrivate))
enum  {
	TWEET_DUMMY_PROPERTY,
	TWEET_IS_HIDDEN,
	TWEET_RETWEETED,
	TWEET_FAVORITED,
	TWEET_DELETED,
	TWEET_USER_ID,
	TWEET_SCREEN_NAME,
	TWEET_USER_NAME,
	TWEET_AVATAR,
	TWEET_SEEN,
	TWEET_HAS_INLINE_MEDIA
};
#define TWEET_MAX_LENGTH 140
#define TWEET_HIDDEN_FORCE ((guint) (1 << 0))
#define TWEET_HIDDEN_UNFOLLOWED ((guint) (1 << 1))
#define TWEET_HIDDEN_FILTERED ((guint) (1 << 2))
#define TWEET_HIDDEN_RTS_DISABLED ((guint) (1 << 3))
#define TWEET_HIDDEN_RT_BY_USER ((guint) (1 << 4))
#define TWEET_HIDDEN_RT_BY_FOLLOWEE ((guint) (1 << 5))
#define TWEET_HIDDEN_AUTHOR_BLOCKED ((guint) (1 << 6))
#define TWEET_HIDDEN_RETWEETER_BLOCKED ((guint) (1 << 7))
Tweet* tweet_new (void);
Tweet* tweet_construct (GType object_type);
void tweet_set_avatar (Tweet* self, cairo_surface_t* value);
gchar** tweet_get_mentions (Tweet* self, int* result_length1);
static TextEntity* _vala_array_dup5 (TextEntity* self, int length);
static TextEntity* _vala_array_dup6 (TextEntity* self, int length);
GType account_get_type (void) G_GNUC_CONST;
void tweet_load_from_json (Tweet* self, JsonNode* status_node, GDateTime* now, Account* account);
void tweet_set_favorited (Tweet* self, gboolean value);
void tweet_set_retweeted (Tweet* self, gboolean value);
GType twitter_get_type (void) G_GNUC_CONST;
Twitter* twitter_get (void);
cairo_surface_t* twitter_get_avatar (Twitter* self, const gchar* url, TwitterAvatarDownloadedFunc func, void* func_target, GDestroyNotify func_target_destroy_notify, gint size);
static void __lambda40_ (Tweet* self, cairo_surface_t* a);
static void ___lambda40__twitter_avatar_downloaded_func (cairo_surface_t* avatar, gpointer self);
gchar* tweet_get_formatted_text (Tweet* self);
GType transform_flags_get_type (void) G_GNUC_CONST;
gchar* text_transform_transform_tweet (MiniTweet* tweet, TransformFlags flags, gint64 quote_id);
gchar* tweet_get_real_text (Tweet* self);
gchar* tweet_get_trimmed_text (Tweet* self);
TransformFlags settings_get_text_transform_flags (void);
gboolean tweet_get_is_hidden (Tweet* self);
gboolean tweet_get_retweeted (Tweet* self);
gboolean tweet_get_favorited (Tweet* self);
gboolean tweet_get_deleted (Tweet* self);
void tweet_set_deleted (Tweet* self, gboolean value);
gint64 tweet_get_user_id (Tweet* self);
const gchar* tweet_get_screen_name (Tweet* self);
const gchar* tweet_get_user_name (Tweet* self);
cairo_surface_t* tweet_get_avatar (Tweet* self);
gboolean tweet_get_seen (Tweet* self);
void tweet_set_seen (Tweet* self, gboolean value);
void notification_manager_withdraw (const gchar* notification_id);
Media** tweet_get_medias (Tweet* self, int* result_length1);
gboolean tweet_get_has_inline_media (Tweet* self);
static void tweet_finalize (GObject* obj);
static void _vala_tweet_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_tweet_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


void user_identity_copy (const UserIdentity* self, UserIdentity* dest) {
	gint64 _tmp0_ = 0LL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	_tmp0_ = (*self).id;
	(*dest).id = _tmp0_;
	_tmp1_ = (*self).screen_name;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 ((*dest).screen_name);
	(*dest).screen_name = _tmp2_;
	_tmp3_ = (*self).user_name;
	_tmp4_ = g_strdup (_tmp3_);
	_g_free0 ((*dest).user_name);
	(*dest).user_name = _tmp4_;
}


void user_identity_destroy (UserIdentity* self) {
	_g_free0 ((*self).screen_name);
	_g_free0 ((*self).user_name);
}


UserIdentity* user_identity_dup (const UserIdentity* self) {
	UserIdentity* dup;
	dup = g_new0 (UserIdentity, 1);
	user_identity_copy (self, dup);
	return dup;
}


void user_identity_free (UserIdentity* self) {
	user_identity_destroy (self);
	g_free (self);
}


GType user_identity_get_type (void) {
	static volatile gsize user_identity_type_id__volatile = 0;
	if (g_once_init_enter (&user_identity_type_id__volatile)) {
		GType user_identity_type_id;
		user_identity_type_id = g_boxed_type_register_static ("UserIdentity", (GBoxedCopyFunc) user_identity_dup, (GBoxedFreeFunc) user_identity_free);
		g_once_init_leave (&user_identity_type_id__volatile, user_identity_type_id);
	}
	return user_identity_type_id__volatile;
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	{
		GRegex* regex = NULL;
		const gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		GRegex* _tmp3_ = NULL;
		GRegex* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		GRegex* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		_tmp0_ = old;
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		regex = _tmp4_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch14_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp6_ = regex;
		_tmp7_ = replacement;
		_tmp8_ = g_regex_replace_literal (_tmp6_, self, (gssize) -1, 0, _tmp7_, 0, &_inner_error_);
		_tmp5_ = _tmp8_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch14_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp9_ = _tmp5_;
		_tmp5_ = NULL;
		result = _tmp9_;
		_g_free0 (_tmp5_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally14;
	__catch14_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally14:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}


static gpointer _user_identity_dup0 (gpointer self) {
	return self ? user_identity_dup (self) : NULL;
}


UserIdentity* parse_identity (JsonObject* user_obj) {
	UserIdentity* result = NULL;
	UserIdentity id = {0};
	UserIdentity _tmp0_ = {0};
	JsonObject* _tmp1_ = NULL;
	gint64 _tmp2_ = 0LL;
	JsonObject* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	JsonObject* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	UserIdentity _tmp11_ = {0};
	UserIdentity* _tmp12_ = NULL;
	UserIdentity* _tmp13_ = NULL;
	g_return_val_if_fail (user_obj != NULL, NULL);
	id = _tmp0_;
	_tmp1_ = user_obj;
	_tmp2_ = json_object_get_int_member (_tmp1_, "id");
	id.id = _tmp2_;
	_tmp3_ = user_obj;
	_tmp4_ = json_object_get_string_member (_tmp3_, "screen_name");
	_tmp5_ = g_strdup (_tmp4_);
	_g_free0 (id.screen_name);
	id.screen_name = _tmp5_;
	_tmp6_ = user_obj;
	_tmp7_ = json_object_get_string_member (_tmp6_, "name");
	_tmp8_ = string_replace (_tmp7_, "&", "&amp;");
	_tmp9_ = _tmp8_;
	_tmp10_ = string_strip (_tmp9_);
	_g_free0 (id.user_name);
	id.user_name = _tmp10_;
	_g_free0 (_tmp9_);
	_tmp11_ = id;
	_tmp12_ = _user_identity_dup0 (&_tmp11_);
	_tmp13_ = _tmp12_;
	user_identity_destroy (&_tmp11_);
	result = _tmp13_;
	return result;
}


static void _vala_TextEntity_array_free (TextEntity* array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			text_entity_destroy (&array[i]);
		}
	}
	g_free (array);
}


MiniTweet* mini_tweet_construct (GType object_type) {
	MiniTweet* self = NULL;
	self = (MiniTweet*) g_type_create_instance (object_type);
	return self;
}


MiniTweet* mini_tweet_new (void) {
	return mini_tweet_construct (TYPE_MINI_TWEET);
}


static void value_mini_tweet_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_mini_tweet_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		mini_tweet_unref (value->data[0].v_pointer);
	}
}


static void value_mini_tweet_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = mini_tweet_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_mini_tweet_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_mini_tweet_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		MiniTweet* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = mini_tweet_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_mini_tweet_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	MiniTweet** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = mini_tweet_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_mini_tweet (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecMiniTweet* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_MINI_TWEET), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_mini_tweet (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_MINI_TWEET), NULL);
	return value->data[0].v_pointer;
}


void value_set_mini_tweet (GValue* value, gpointer v_object) {
	MiniTweet* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_MINI_TWEET));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_MINI_TWEET));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		mini_tweet_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		mini_tweet_unref (old);
	}
}


void value_take_mini_tweet (GValue* value, gpointer v_object) {
	MiniTweet* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_MINI_TWEET));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_MINI_TWEET));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		mini_tweet_unref (old);
	}
}


static void mini_tweet_class_init (MiniTweetClass * klass) {
	mini_tweet_parent_class = g_type_class_peek_parent (klass);
	((MiniTweetClass *) klass)->finalize = mini_tweet_finalize;
}


static void mini_tweet_instance_init (MiniTweet * self) {
	self->ref_count = 1;
}


static void mini_tweet_finalize (MiniTweet* obj) {
	MiniTweet * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MINI_TWEET, MiniTweet);
	g_signal_handlers_destroy (self);
	user_identity_destroy (&self->author);
	_g_free0 (self->text);
	self->entities = (_vala_TextEntity_array_free (self->entities, self->entities_length1), NULL);
	self->medias = (_vala_array_free (self->medias, self->medias_length1, (GDestroyNotify) g_object_unref), NULL);
}


GType mini_tweet_get_type (void) {
	static volatile gsize mini_tweet_type_id__volatile = 0;
	if (g_once_init_enter (&mini_tweet_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_mini_tweet_init, value_mini_tweet_free_value, value_mini_tweet_copy_value, value_mini_tweet_peek_pointer, "p", value_mini_tweet_collect_value, "p", value_mini_tweet_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (MiniTweetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) mini_tweet_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MiniTweet), 0, (GInstanceInitFunc) mini_tweet_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType mini_tweet_type_id;
		mini_tweet_type_id = g_type_register_fundamental (g_type_fundamental_next (), "MiniTweet", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&mini_tweet_type_id__volatile, mini_tweet_type_id);
	}
	return mini_tweet_type_id__volatile;
}


gpointer mini_tweet_ref (gpointer instance) {
	MiniTweet* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void mini_tweet_unref (gpointer instance) {
	MiniTweet* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		MINI_TWEET_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


MiniTweet* parse_mini_tweet (JsonObject* status) {
	MiniTweet* result = NULL;
	MiniTweet* mt = NULL;
	MiniTweet* _tmp0_ = NULL;
	JsonObject* _tmp1_ = NULL;
	gint64 _tmp2_ = 0LL;
	JsonObject* _tmp3_ = NULL;
	JsonObject* _tmp4_ = NULL;
	UserIdentity* _tmp5_ = NULL;
	UserIdentity* _tmp6_ = NULL;
	UserIdentity _tmp7_ = {0};
	JsonObject* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	JsonObject* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	GDateTime* _tmp13_ = NULL;
	GDateTime* _tmp14_ = NULL;
	gint64 _tmp15_ = 0LL;
	g_return_val_if_fail (status != NULL, NULL);
	_tmp0_ = mini_tweet_new ();
	mt = _tmp0_;
	_tmp1_ = status;
	_tmp2_ = json_object_get_int_member (_tmp1_, "id");
	mt->id = _tmp2_;
	_tmp3_ = status;
	_tmp4_ = json_object_get_object_member (_tmp3_, "user");
	_tmp5_ = parse_identity (_tmp4_);
	_tmp6_ = _tmp5_;
	user_identity_copy (_tmp6_, &_tmp7_);
	user_identity_destroy (&mt->author);
	mt->author = _tmp7_;
	_user_identity_free0 (_tmp6_);
	_tmp8_ = status;
	_tmp9_ = json_object_get_string_member (_tmp8_, "text");
	_tmp10_ = g_strdup (_tmp9_);
	_g_free0 (mt->text);
	mt->text = _tmp10_;
	_tmp11_ = status;
	_tmp12_ = json_object_get_string_member (_tmp11_, "created_at");
	_tmp13_ = utils_parse_date (_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = g_date_time_to_unix (_tmp14_);
	mt->created_at = _tmp15_;
	_g_date_time_unref0 (_tmp14_);
	result = mt;
	return result;
}


static gpointer _mini_tweet_ref0 (gpointer self) {
	return self ? mini_tweet_ref (self) : NULL;
}


static Block15Data* block15_data_ref (Block15Data* _data15_) {
	g_atomic_int_inc (&_data15_->_ref_count_);
	return _data15_;
}


static void block15_data_unref (void * _userdata_) {
	Block15Data* _data15_;
	_data15_ = (Block15Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data15_->_ref_count_)) {
		_mini_tweet_unref0 (_data15_->mt);
		g_slice_free (Block15Data, _data15_);
	}
}


static gpointer _json_object_ref0 (gpointer self) {
	return self ? json_object_ref (self) : NULL;
}


static gpointer _json_array_ref0 (gpointer self) {
	return self ? json_array_ref (self) : NULL;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void __lambda26_ (Block15Data* _data15_, JsonArray* arr, guint index, JsonNode* node) {
	JsonObject* url = NULL;
	JsonNode* _tmp0_ = NULL;
	JsonObject* _tmp1_ = NULL;
	JsonObject* _tmp2_ = NULL;
	gchar* expanded_url = NULL;
	JsonObject* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
	JsonArray* indices = NULL;
	JsonObject* _tmp24_ = NULL;
	JsonArray* _tmp25_ = NULL;
	JsonArray* _tmp26_ = NULL;
	const gchar* _tmp27_ = NULL;
	gchar* _tmp28_ = NULL;
	MiniTweet* _tmp29_ = NULL;
	TextEntity* _tmp30_ = NULL;
	gint _tmp30__length1 = 0;
	gint _tmp31_ = 0;
	gint64 _tmp32_ = 0LL;
	gint64 _tmp33_ = 0LL;
	JsonObject* _tmp34_ = NULL;
	const gchar* _tmp35_ = NULL;
	gchar* _tmp36_ = NULL;
	const gchar* _tmp37_ = NULL;
	gchar* _tmp38_ = NULL;
	const gchar* _tmp39_ = NULL;
	gchar* _tmp40_ = NULL;
	TextEntity _tmp41_ = {0};
	TextEntity _tmp42_ = {0};
	gint _tmp43_ = 0;
	g_return_if_fail (arr != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = node;
	_tmp1_ = json_node_get_object (_tmp0_);
	_tmp2_ = _json_object_ref0 (_tmp1_);
	url = _tmp2_;
	_tmp3_ = url;
	_tmp4_ = json_object_get_string_member (_tmp3_, "expanded_url");
	_tmp5_ = g_strdup (_tmp4_);
	expanded_url = _tmp5_;
	_tmp6_ = expanded_url;
	_tmp7_ = is_media_candidate (_tmp6_);
	if (_tmp7_) {
		Media* m = NULL;
		Media* _tmp8_ = NULL;
		Media* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		Media* _tmp12_ = NULL;
		gint _tmp13_ = 0;
		Media* _tmp14_ = NULL;
		const gchar* _tmp15_ = NULL;
		MediaType _tmp16_ = 0;
		MiniTweet* _tmp17_ = NULL;
		Media** _tmp18_ = NULL;
		gint _tmp18__length1 = 0;
		gint _tmp19_ = 0;
		Media* _tmp20_ = NULL;
		Media* _tmp21_ = NULL;
		Media* _tmp22_ = NULL;
		gint _tmp23_ = 0;
		_tmp8_ = media_new ();
		m = _tmp8_;
		_tmp9_ = m;
		_tmp10_ = expanded_url;
		_tmp11_ = g_strdup (_tmp10_);
		_g_free0 (_tmp9_->url);
		_tmp9_->url = _tmp11_;
		_tmp12_ = m;
		_tmp13_ = _data15_->real_media_count;
		_tmp12_->id = (gint64) _tmp13_;
		_tmp14_ = m;
		_tmp15_ = expanded_url;
		_tmp16_ = media_type_from_url (_tmp15_);
		_tmp14_->type = _tmp16_;
		_tmp17_ = _data15_->mt;
		_tmp18_ = _tmp17_->medias;
		_tmp18__length1 = _tmp17_->medias_length1;
		_tmp19_ = _data15_->real_media_count;
		_tmp20_ = m;
		_tmp21_ = _g_object_ref0 (_tmp20_);
		_g_object_unref0 (_tmp18_[_tmp19_]);
		_tmp18_[_tmp19_] = _tmp21_;
		_tmp22_ = _tmp18_[_tmp19_];
		_tmp23_ = _data15_->real_media_count;
		_data15_->real_media_count = _tmp23_ + 1;
		_g_object_unref0 (m);
	}
	_tmp24_ = url;
	_tmp25_ = json_object_get_array_member (_tmp24_, "indices");
	_tmp26_ = _json_array_ref0 (_tmp25_);
	indices = _tmp26_;
	_tmp27_ = expanded_url;
	_tmp28_ = string_replace (_tmp27_, "&", "&amp;");
	_g_free0 (expanded_url);
	expanded_url = _tmp28_;
	_tmp29_ = _data15_->mt;
	_tmp30_ = _tmp29_->entities;
	_tmp30__length1 = _tmp29_->entities_length1;
	_tmp31_ = _data15_->url_index;
	_tmp32_ = json_array_get_int_element (indices, (guint) 0);
	_tmp33_ = json_array_get_int_element (indices, (guint) 1);
	_tmp34_ = url;
	_tmp35_ = json_object_get_string_member (_tmp34_, "display_url");
	_tmp36_ = g_strdup (_tmp35_);
	_tmp37_ = expanded_url;
	_tmp38_ = g_strdup (_tmp37_);
	_tmp39_ = expanded_url;
	_tmp40_ = g_strdup (_tmp39_);
	memset (&_tmp41_, 0, sizeof (TextEntity));
	_tmp41_.from = (guint) _tmp32_;
	_tmp41_.to = (guint) _tmp33_;
	_g_free0 (_tmp41_.display_text);
	_tmp41_.display_text = _tmp36_;
	_g_free0 (_tmp41_.tooltip_text);
	_tmp41_.tooltip_text = _tmp38_;
	_g_free0 (_tmp41_.target);
	_tmp41_.target = _tmp40_;
	text_entity_destroy (&_tmp30_[_tmp31_]);
	_tmp30_[_tmp31_] = _tmp41_;
	_tmp42_ = _tmp30_[_tmp31_];
	_tmp43_ = _data15_->url_index;
	_data15_->url_index = _tmp43_ + 1;
	_json_array_unref0 (indices);
	_g_free0 (expanded_url);
	_json_object_unref0 (url);
}


static void ___lambda26__json_array_foreach (JsonArray* array, guint index_, JsonNode* element_node, gpointer self) {
	__lambda26_ (self, array, index_, element_node);
}


static void __lambda27_ (Block15Data* _data15_, JsonArray* arr, guint index, JsonNode* node) {
	JsonObject* hashtag = NULL;
	JsonNode* _tmp0_ = NULL;
	JsonObject* _tmp1_ = NULL;
	JsonObject* _tmp2_ = NULL;
	JsonArray* indices = NULL;
	JsonArray* _tmp3_ = NULL;
	JsonArray* _tmp4_ = NULL;
	MiniTweet* _tmp5_ = NULL;
	TextEntity* _tmp6_ = NULL;
	gint _tmp6__length1 = 0;
	gint _tmp7_ = 0;
	gint64 _tmp8_ = 0LL;
	gint64 _tmp9_ = 0LL;
	const gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	TextEntity _tmp14_ = {0};
	TextEntity _tmp15_ = {0};
	gint _tmp16_ = 0;
	g_return_if_fail (arr != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = node;
	_tmp1_ = json_node_get_object (_tmp0_);
	_tmp2_ = _json_object_ref0 (_tmp1_);
	hashtag = _tmp2_;
	_tmp3_ = json_object_get_array_member (hashtag, "indices");
	_tmp4_ = _json_array_ref0 (_tmp3_);
	indices = _tmp4_;
	_tmp5_ = _data15_->mt;
	_tmp6_ = _tmp5_->entities;
	_tmp6__length1 = _tmp5_->entities_length1;
	_tmp7_ = _data15_->url_index;
	_tmp8_ = json_array_get_int_element (indices, (guint) 0);
	_tmp9_ = json_array_get_int_element (indices, (guint) 1);
	_tmp10_ = json_object_get_string_member (hashtag, "text");
	_tmp11_ = g_strconcat ("#", _tmp10_, NULL);
	_tmp12_ = json_object_get_string_member (hashtag, "text");
	_tmp13_ = g_strconcat ("#", _tmp12_, NULL);
	memset (&_tmp14_, 0, sizeof (TextEntity));
	_tmp14_.from = (guint) _tmp8_;
	_tmp14_.to = (guint) _tmp9_;
	_g_free0 (_tmp14_.display_text);
	_tmp14_.display_text = _tmp11_;
	_g_free0 (_tmp14_.tooltip_text);
	_tmp14_.tooltip_text = _tmp13_;
	_g_free0 (_tmp14_.target);
	_tmp14_.target = NULL;
	text_entity_destroy (&_tmp6_[_tmp7_]);
	_tmp6_[_tmp7_] = _tmp14_;
	_tmp15_ = _tmp6_[_tmp7_];
	_tmp16_ = _data15_->url_index;
	_data15_->url_index = _tmp16_ + 1;
	_json_array_unref0 (indices);
	_json_object_unref0 (hashtag);
}


static void ___lambda27__json_array_foreach (JsonArray* array, guint index_, JsonNode* element_node, gpointer self) {
	__lambda27_ (self, array, index_, element_node);
}


static void __lambda28_ (Block15Data* _data15_, JsonArray* arr, guint index, JsonNode* node) {
	JsonObject* mention = NULL;
	JsonNode* _tmp0_ = NULL;
	JsonObject* _tmp1_ = NULL;
	JsonObject* _tmp2_ = NULL;
	JsonArray* indices = NULL;
	JsonArray* _tmp3_ = NULL;
	JsonArray* _tmp4_ = NULL;
	gchar* screen_name = NULL;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	MiniTweet* _tmp7_ = NULL;
	TextEntity* _tmp8_ = NULL;
	gint _tmp8__length1 = 0;
	gint _tmp9_ = 0;
	gint64 _tmp10_ = 0LL;
	gint64 _tmp11_ = 0LL;
	gchar* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	gchar* _tmp18_ = NULL;
	const gchar* _tmp19_ = NULL;
	gchar* _tmp20_ = NULL;
	TextEntity _tmp21_ = {0};
	TextEntity _tmp22_ = {0};
	gint _tmp23_ = 0;
	g_return_if_fail (arr != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = node;
	_tmp1_ = json_node_get_object (_tmp0_);
	_tmp2_ = _json_object_ref0 (_tmp1_);
	mention = _tmp2_;
	_tmp3_ = json_object_get_array_member (mention, "indices");
	_tmp4_ = _json_array_ref0 (_tmp3_);
	indices = _tmp4_;
	_tmp5_ = json_object_get_string_member (mention, "screen_name");
	_tmp6_ = g_strdup (_tmp5_);
	screen_name = _tmp6_;
	_tmp7_ = _data15_->mt;
	_tmp8_ = _tmp7_->entities;
	_tmp8__length1 = _tmp7_->entities_length1;
	_tmp9_ = _data15_->url_index;
	_tmp10_ = json_array_get_int_element (indices, (guint) 0);
	_tmp11_ = json_array_get_int_element (indices, (guint) 1);
	_tmp12_ = g_strconcat ("@", screen_name, NULL);
	_tmp13_ = json_object_get_string_member (mention, "id_str");
	_tmp14_ = g_strconcat ("@", _tmp13_, NULL);
	_tmp15_ = _tmp14_;
	_tmp16_ = g_strconcat (_tmp15_, "/@", NULL);
	_tmp17_ = _tmp16_;
	_tmp18_ = g_strconcat (_tmp17_, screen_name, NULL);
	_tmp19_ = json_object_get_string_member (mention, "name");
	_tmp20_ = g_strdup (_tmp19_);
	memset (&_tmp21_, 0, sizeof (TextEntity));
	_tmp21_.from = (guint) _tmp10_;
	_tmp21_.to = (guint) _tmp11_;
	_g_free0 (_tmp21_.display_text);
	_tmp21_.display_text = _tmp12_;
	_g_free0 (_tmp21_.target);
	_tmp21_.target = _tmp18_;
	_g_free0 (_tmp21_.tooltip_text);
	_tmp21_.tooltip_text = _tmp20_;
	text_entity_destroy (&_tmp8_[_tmp9_]);
	_tmp8_[_tmp9_] = _tmp21_;
	_tmp22_ = _tmp8_[_tmp9_];
	_g_free0 (_tmp17_);
	_g_free0 (_tmp15_);
	_tmp23_ = _data15_->url_index;
	_data15_->url_index = _tmp23_ + 1;
	_g_free0 (screen_name);
	_json_array_unref0 (indices);
	_json_object_unref0 (mention);
}


static void ___lambda28__json_array_foreach (JsonArray* array, guint index_, JsonNode* element_node, gpointer self) {
	__lambda28_ (self, array, index_, element_node);
}


static void ___lambda29_ (Block15Data* _data15_, JsonArray* arr, guint index, JsonNode* node) {
	JsonObject* url = NULL;
	JsonNode* _tmp0_ = NULL;
	JsonObject* _tmp1_ = NULL;
	JsonObject* _tmp2_ = NULL;
	gchar* expanded_url = NULL;
	JsonObject* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	JsonArray* indices = NULL;
	JsonObject* _tmp8_ = NULL;
	JsonArray* _tmp9_ = NULL;
	JsonArray* _tmp10_ = NULL;
	MiniTweet* _tmp11_ = NULL;
	TextEntity* _tmp12_ = NULL;
	gint _tmp12__length1 = 0;
	gint _tmp13_ = 0;
	JsonArray* _tmp14_ = NULL;
	gint64 _tmp15_ = 0LL;
	JsonArray* _tmp16_ = NULL;
	gint64 _tmp17_ = 0LL;
	JsonObject* _tmp18_ = NULL;
	const gchar* _tmp19_ = NULL;
	gchar* _tmp20_ = NULL;
	JsonObject* _tmp21_ = NULL;
	const gchar* _tmp22_ = NULL;
	gchar* _tmp23_ = NULL;
	TextEntity _tmp24_ = {0};
	TextEntity _tmp25_ = {0};
	gint _tmp26_ = 0;
	gchar* media_url = NULL;
	JsonObject* _tmp27_ = NULL;
	const gchar* _tmp28_ = NULL;
	gchar* _tmp29_ = NULL;
	const gchar* _tmp30_ = NULL;
	gboolean _tmp31_ = FALSE;
	g_return_if_fail (arr != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = node;
	_tmp1_ = json_node_get_object (_tmp0_);
	_tmp2_ = _json_object_ref0 (_tmp1_);
	url = _tmp2_;
	_tmp3_ = url;
	_tmp4_ = json_object_get_string_member (_tmp3_, "expanded_url");
	_tmp5_ = g_strdup (_tmp4_);
	expanded_url = _tmp5_;
	_tmp6_ = expanded_url;
	_tmp7_ = string_replace (_tmp6_, "&", "&amp;");
	_g_free0 (expanded_url);
	expanded_url = _tmp7_;
	_tmp8_ = url;
	_tmp9_ = json_object_get_array_member (_tmp8_, "indices");
	_tmp10_ = _json_array_ref0 (_tmp9_);
	indices = _tmp10_;
	_tmp11_ = _data15_->mt;
	_tmp12_ = _tmp11_->entities;
	_tmp12__length1 = _tmp11_->entities_length1;
	_tmp13_ = _data15_->url_index;
	_tmp14_ = indices;
	_tmp15_ = json_array_get_int_element (_tmp14_, (guint) 0);
	_tmp16_ = indices;
	_tmp17_ = json_array_get_int_element (_tmp16_, (guint) 1);
	_tmp18_ = url;
	_tmp19_ = json_object_get_string_member (_tmp18_, "url");
	_tmp20_ = g_strdup (_tmp19_);
	_tmp21_ = url;
	_tmp22_ = json_object_get_string_member (_tmp21_, "display_url");
	_tmp23_ = g_strdup (_tmp22_);
	memset (&_tmp24_, 0, sizeof (TextEntity));
	_tmp24_.from = (guint) _tmp15_;
	_tmp24_.to = (guint) _tmp17_;
	_g_free0 (_tmp24_.target);
	_tmp24_.target = _tmp20_;
	_g_free0 (_tmp24_.display_text);
	_tmp24_.display_text = _tmp23_;
	text_entity_destroy (&_tmp12_[_tmp13_]);
	_tmp12_[_tmp13_] = _tmp24_;
	_tmp25_ = _tmp12_[_tmp13_];
	_tmp26_ = _data15_->url_index;
	_data15_->url_index = _tmp26_ + 1;
	_tmp27_ = url;
	_tmp28_ = json_object_get_string_member (_tmp27_, "media_url");
	_tmp29_ = g_strdup (_tmp28_);
	media_url = _tmp29_;
	_tmp30_ = media_url;
	_tmp31_ = is_media_candidate (_tmp30_);
	if (_tmp31_) {
		Media* m = NULL;
		Media* _tmp32_ = NULL;
		Media* _tmp33_ = NULL;
		const gchar* _tmp34_ = NULL;
		gchar* _tmp35_ = NULL;
		Media* _tmp36_ = NULL;
		const gchar* _tmp37_ = NULL;
		gchar* _tmp38_ = NULL;
		gchar* _tmp39_ = NULL;
		MiniTweet* _tmp40_ = NULL;
		Media** _tmp41_ = NULL;
		gint _tmp41__length1 = 0;
		gint _tmp42_ = 0;
		Media* _tmp43_ = NULL;
		Media* _tmp44_ = NULL;
		Media* _tmp45_ = NULL;
		gint _tmp46_ = 0;
		_tmp32_ = media_new ();
		m = _tmp32_;
		_tmp33_ = m;
		_tmp34_ = media_url;
		_tmp35_ = g_strdup (_tmp34_);
		_g_free0 (_tmp33_->url);
		_tmp33_->url = _tmp35_;
		_tmp36_ = m;
		_tmp37_ = media_url;
		_tmp38_ = g_strconcat (_tmp37_, ":large", NULL);
		_tmp39_ = _tmp38_;
		media_set_target_url (_tmp36_, _tmp39_);
		_g_free0 (_tmp39_);
		_tmp40_ = _data15_->mt;
		_tmp41_ = _tmp40_->medias;
		_tmp41__length1 = _tmp40_->medias_length1;
		_tmp42_ = _data15_->real_media_count;
		_tmp43_ = m;
		_tmp44_ = _g_object_ref0 (_tmp43_);
		_g_object_unref0 (_tmp41_[_tmp42_]);
		_tmp41_[_tmp42_] = _tmp44_;
		_tmp45_ = _tmp41_[_tmp42_];
		_tmp46_ = _data15_->real_media_count;
		_data15_->real_media_count = _tmp46_ + 1;
		_g_object_unref0 (m);
	}
	_g_free0 (media_url);
	_json_array_unref0 (indices);
	_g_free0 (expanded_url);
	_json_object_unref0 (url);
}


static void ____lambda29__json_array_foreach (JsonArray* array, guint index_, JsonNode* element_node, gpointer self) {
	___lambda29_ (self, array, index_, element_node);
}


static void ___lambda30_ (Block15Data* _data15_, JsonArray* arr, guint index, JsonNode* node) {
	JsonObject* media_obj = NULL;
	JsonNode* _tmp0_ = NULL;
	JsonObject* _tmp1_ = NULL;
	JsonObject* _tmp2_ = NULL;
	gchar* media_type = NULL;
	JsonObject* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	g_return_if_fail (arr != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = node;
	_tmp1_ = json_node_get_object (_tmp0_);
	_tmp2_ = _json_object_ref0 (_tmp1_);
	media_obj = _tmp2_;
	_tmp3_ = media_obj;
	_tmp4_ = json_object_get_string_member (_tmp3_, "type");
	_tmp5_ = g_strdup (_tmp4_);
	media_type = _tmp5_;
	_tmp6_ = media_type;
	if (g_strcmp0 (_tmp6_, "photo") == 0) {
		gchar* url = NULL;
		JsonObject* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		MiniTweet* _tmp10_ = NULL;
		Media** _tmp11_ = NULL;
		gint _tmp11__length1 = 0;
		const gchar* _tmp18_ = NULL;
		gboolean _tmp19_ = FALSE;
		_tmp7_ = media_obj;
		_tmp8_ = json_object_get_string_member (_tmp7_, "media_url");
		_tmp9_ = g_strdup (_tmp8_);
		url = _tmp9_;
		_tmp10_ = _data15_->mt;
		_tmp11_ = _tmp10_->medias;
		_tmp11__length1 = _tmp10_->medias_length1;
		{
			Media** m_collection = NULL;
			gint m_collection_length1 = 0;
			gint _m_collection_size_ = 0;
			gint m_it = 0;
			m_collection = _tmp11_;
			m_collection_length1 = _tmp11__length1;
			for (m_it = 0; m_it < _tmp11__length1; m_it = m_it + 1) {
				Media* _tmp12_ = NULL;
				Media* m = NULL;
				_tmp12_ = _g_object_ref0 (m_collection[m_it]);
				m = _tmp12_;
				{
					gboolean _tmp13_ = FALSE;
					Media* _tmp14_ = NULL;
					_tmp14_ = m;
					if (_tmp14_ != NULL) {
						Media* _tmp15_ = NULL;
						const gchar* _tmp16_ = NULL;
						const gchar* _tmp17_ = NULL;
						_tmp15_ = m;
						_tmp16_ = _tmp15_->url;
						_tmp17_ = url;
						_tmp13_ = g_strcmp0 (_tmp16_, _tmp17_) == 0;
					} else {
						_tmp13_ = FALSE;
					}
					if (_tmp13_) {
						_g_object_unref0 (m);
						_g_free0 (url);
						_g_free0 (media_type);
						_json_object_unref0 (media_obj);
						return;
					}
					_g_object_unref0 (m);
				}
			}
		}
		_tmp18_ = url;
		_tmp19_ = is_media_candidate (_tmp18_);
		if (_tmp19_) {
			Media* m = NULL;
			Media* _tmp20_ = NULL;
			Media* _tmp21_ = NULL;
			const gchar* _tmp22_ = NULL;
			gchar* _tmp23_ = NULL;
			Media* _tmp24_ = NULL;
			const gchar* _tmp25_ = NULL;
			gchar* _tmp26_ = NULL;
			gchar* _tmp27_ = NULL;
			Media* _tmp28_ = NULL;
			JsonObject* _tmp29_ = NULL;
			gint64 _tmp30_ = 0LL;
			Media* _tmp31_ = NULL;
			JsonObject* _tmp32_ = NULL;
			const gchar* _tmp33_ = NULL;
			MediaType _tmp34_ = 0;
			MiniTweet* _tmp35_ = NULL;
			Media** _tmp36_ = NULL;
			gint _tmp36__length1 = 0;
			gint _tmp37_ = 0;
			Media* _tmp38_ = NULL;
			Media* _tmp39_ = NULL;
			Media* _tmp40_ = NULL;
			gint _tmp41_ = 0;
			_tmp20_ = media_new ();
			m = _tmp20_;
			_tmp21_ = m;
			_tmp22_ = url;
			_tmp23_ = g_strdup (_tmp22_);
			_g_free0 (_tmp21_->url);
			_tmp21_->url = _tmp23_;
			_tmp24_ = m;
			_tmp25_ = url;
			_tmp26_ = g_strconcat (_tmp25_, ":large", NULL);
			_tmp27_ = _tmp26_;
			media_set_target_url (_tmp24_, _tmp27_);
			_g_free0 (_tmp27_);
			_tmp28_ = m;
			_tmp29_ = media_obj;
			_tmp30_ = json_object_get_int_member (_tmp29_, "id");
			_tmp28_->id = _tmp30_;
			_tmp31_ = m;
			_tmp32_ = media_obj;
			_tmp33_ = json_object_get_string_member (_tmp32_, "type");
			_tmp34_ = media_type_from_string (_tmp33_);
			_tmp31_->type = _tmp34_;
			_tmp35_ = _data15_->mt;
			_tmp36_ = _tmp35_->medias;
			_tmp36__length1 = _tmp35_->medias_length1;
			_tmp37_ = _data15_->real_media_count;
			_tmp38_ = m;
			_tmp39_ = _g_object_ref0 (_tmp38_);
			_g_object_unref0 (_tmp36_[_tmp37_]);
			_tmp36_[_tmp37_] = _tmp39_;
			_tmp40_ = _tmp36_[_tmp37_];
			_tmp41_ = _data15_->real_media_count;
			_data15_->real_media_count = _tmp41_ + 1;
			_g_object_unref0 (m);
		}
		_g_free0 (url);
	} else {
		gboolean _tmp42_ = FALSE;
		const gchar* _tmp43_ = NULL;
		_tmp43_ = media_type;
		if (g_strcmp0 (_tmp43_, "video") == 0) {
			_tmp42_ = TRUE;
		} else {
			const gchar* _tmp44_ = NULL;
			_tmp44_ = media_type;
			_tmp42_ = g_strcmp0 (_tmp44_, "animated_gif") == 0;
		}
		if (_tmp42_) {
			JsonObject* variant = NULL;
			JsonArray* variants = NULL;
			JsonObject* _tmp45_ = NULL;
			JsonObject* _tmp46_ = NULL;
			JsonArray* _tmp47_ = NULL;
			JsonArray* _tmp48_ = NULL;
			JsonObject* _tmp61_ = NULL;
			variant = NULL;
			_tmp45_ = media_obj;
			_tmp46_ = json_object_get_object_member (_tmp45_, "video_info");
			_tmp47_ = json_object_get_array_member (_tmp46_, "variants");
			_tmp48_ = _json_array_ref0 (_tmp47_);
			variants = _tmp48_;
			{
				guint i = 0U;
				i = (guint) 0;
				{
					gboolean _tmp49_ = FALSE;
					_tmp49_ = TRUE;
					while (TRUE) {
						guint _tmp51_ = 0U;
						JsonArray* _tmp52_ = NULL;
						guint _tmp53_ = 0U;
						JsonArray* _tmp54_ = NULL;
						guint _tmp55_ = 0U;
						JsonNode* _tmp56_ = NULL;
						JsonObject* _tmp57_ = NULL;
						JsonObject* _tmp58_ = NULL;
						JsonObject* _tmp59_ = NULL;
						const gchar* _tmp60_ = NULL;
						if (!_tmp49_) {
							guint _tmp50_ = 0U;
							_tmp50_ = i;
							i = _tmp50_ + 1;
						}
						_tmp49_ = FALSE;
						_tmp51_ = i;
						_tmp52_ = variants;
						_tmp53_ = json_array_get_length (_tmp52_);
						if (!(_tmp51_ < _tmp53_)) {
							break;
						}
						_tmp54_ = variants;
						_tmp55_ = i;
						_tmp56_ = json_array_get_element (_tmp54_, _tmp55_);
						_tmp57_ = json_node_get_object (_tmp56_);
						_tmp58_ = _json_object_ref0 (_tmp57_);
						_json_object_unref0 (variant);
						variant = _tmp58_;
						_tmp59_ = variant;
						_tmp60_ = json_object_get_string_member (_tmp59_, "content_type");
						if (g_strcmp0 (_tmp60_, "video/mp4") == 0) {
							break;
						}
					}
				}
			}
			_tmp61_ = variant;
			if (_tmp61_ != NULL) {
				Media* m = NULL;
				Media* _tmp62_ = NULL;
				Media* _tmp63_ = NULL;
				JsonObject* _tmp64_ = NULL;
				const gchar* _tmp65_ = NULL;
				gchar* _tmp66_ = NULL;
				Media* _tmp67_ = NULL;
				JsonObject* _tmp68_ = NULL;
				const gchar* _tmp69_ = NULL;
				Media* _tmp70_ = NULL;
				Media* _tmp71_ = NULL;
				JsonObject* _tmp72_ = NULL;
				gint64 _tmp73_ = 0LL;
				MiniTweet* _tmp74_ = NULL;
				Media** _tmp75_ = NULL;
				gint _tmp75__length1 = 0;
				gint _tmp76_ = 0;
				Media* _tmp77_ = NULL;
				Media* _tmp78_ = NULL;
				Media* _tmp79_ = NULL;
				gint _tmp80_ = 0;
				_tmp62_ = media_new ();
				m = _tmp62_;
				_tmp63_ = m;
				_tmp64_ = variant;
				_tmp65_ = json_object_get_string_member (_tmp64_, "url");
				_tmp66_ = g_strdup (_tmp65_);
				_g_free0 (_tmp63_->url);
				_tmp63_->url = _tmp66_;
				_tmp67_ = m;
				_tmp68_ = media_obj;
				_tmp69_ = json_object_get_string_member (_tmp68_, "media_url");
				media_set_thumb_url (_tmp67_, _tmp69_);
				_tmp70_ = m;
				_tmp70_->type = MEDIA_TYPE_TWITTER_VIDEO;
				_tmp71_ = m;
				_tmp72_ = media_obj;
				_tmp73_ = json_object_get_int_member (_tmp72_, "id");
				_tmp71_->id = _tmp73_;
				_tmp74_ = _data15_->mt;
				_tmp75_ = _tmp74_->medias;
				_tmp75__length1 = _tmp74_->medias_length1;
				_tmp76_ = _data15_->real_media_count;
				_tmp77_ = m;
				_tmp78_ = _g_object_ref0 (_tmp77_);
				_g_object_unref0 (_tmp75_[_tmp76_]);
				_tmp75_[_tmp76_] = _tmp78_;
				_tmp79_ = _tmp75_[_tmp76_];
				_tmp80_ = _data15_->real_media_count;
				_data15_->real_media_count = _tmp80_ + 1;
				_g_object_unref0 (m);
			}
			_json_array_unref0 (variants);
			_json_object_unref0 (variant);
		}
	}
	_g_free0 (media_type);
	_json_object_unref0 (media_obj);
}


static void ____lambda30__json_array_foreach (JsonArray* array, guint index_, JsonNode* element_node, gpointer self) {
	___lambda30_ (self, array, index_, element_node);
}


void parse_entities (MiniTweet* mt, JsonObject* status) {
	Block15Data* _data15_;
	MiniTweet* _tmp0_ = NULL;
	MiniTweet* _tmp1_ = NULL;
	JsonObject* entities = NULL;
	JsonObject* _tmp2_ = NULL;
	JsonObject* _tmp3_ = NULL;
	JsonObject* _tmp4_ = NULL;
	JsonArray* urls = NULL;
	JsonObject* _tmp5_ = NULL;
	JsonArray* _tmp6_ = NULL;
	JsonArray* _tmp7_ = NULL;
	JsonArray* hashtags = NULL;
	JsonObject* _tmp8_ = NULL;
	JsonArray* _tmp9_ = NULL;
	JsonArray* _tmp10_ = NULL;
	JsonArray* user_mentions = NULL;
	JsonObject* _tmp11_ = NULL;
	JsonArray* _tmp12_ = NULL;
	JsonArray* _tmp13_ = NULL;
	gint media_count = 0;
	JsonObject* _tmp14_ = NULL;
	gint _tmp15_ = 0;
	JsonObject* _tmp16_ = NULL;
	gboolean _tmp17_ = FALSE;
	gint _tmp22_ = 0;
	JsonArray* _tmp23_ = NULL;
	guint _tmp24_ = 0U;
	MiniTweet* _tmp25_ = NULL;
	gint _tmp26_ = 0;
	Media** _tmp27_ = NULL;
	MiniTweet* _tmp28_ = NULL;
	JsonArray* _tmp29_ = NULL;
	guint _tmp30_ = 0U;
	JsonArray* _tmp31_ = NULL;
	guint _tmp32_ = 0U;
	JsonArray* _tmp33_ = NULL;
	guint _tmp34_ = 0U;
	gint _tmp35_ = 0;
	TextEntity* _tmp36_ = NULL;
	JsonArray* _tmp37_ = NULL;
	JsonArray* _tmp38_ = NULL;
	JsonArray* _tmp39_ = NULL;
	JsonObject* _tmp40_ = NULL;
	gboolean _tmp41_ = FALSE;
	JsonObject* _tmp46_ = NULL;
	gboolean _tmp47_ = FALSE;
	MiniTweet* _tmp55_ = NULL;
	gint _tmp56_ = 0;
	gint _tmp57_ = 0;
	InlineMediaDownloader* _tmp58_ = NULL;
	InlineMediaDownloader* _tmp59_ = NULL;
	MiniTweet* _tmp60_ = NULL;
	MiniTweet* _tmp61_ = NULL;
	Media** _tmp62_ = NULL;
	gint _tmp62__length1 = 0;
	MiniTweet* _tmp63_ = NULL;
	gint _tmp64_ = 0;
	gint _tmp65_ = 0;
	MiniTweet* _tmp66_ = NULL;
	g_return_if_fail (IS_MINI_TWEET (mt));
	g_return_if_fail (status != NULL);
	_data15_ = g_slice_new0 (Block15Data);
	_data15_->_ref_count_ = 1;
	_tmp0_ = mt;
	_tmp1_ = _mini_tweet_ref0 (_tmp0_);
	_mini_tweet_unref0 (_data15_->mt);
	_data15_->mt = _tmp1_;
	_tmp2_ = status;
	_tmp3_ = json_object_get_object_member (_tmp2_, "entities");
	_tmp4_ = _json_object_ref0 (_tmp3_);
	entities = _tmp4_;
	_tmp5_ = entities;
	_tmp6_ = json_object_get_array_member (_tmp5_, "urls");
	_tmp7_ = _json_array_ref0 (_tmp6_);
	urls = _tmp7_;
	_tmp8_ = entities;
	_tmp9_ = json_object_get_array_member (_tmp8_, "hashtags");
	_tmp10_ = _json_array_ref0 (_tmp9_);
	hashtags = _tmp10_;
	_tmp11_ = entities;
	_tmp12_ = json_object_get_array_member (_tmp11_, "user_mentions");
	_tmp13_ = _json_array_ref0 (_tmp12_);
	user_mentions = _tmp13_;
	_tmp14_ = entities;
	_tmp15_ = utils_get_json_array_size (_tmp14_, "media");
	media_count = _tmp15_;
	_tmp16_ = status;
	_tmp17_ = json_object_has_member (_tmp16_, "extended_entities");
	if (_tmp17_) {
		gint _tmp18_ = 0;
		JsonObject* _tmp19_ = NULL;
		JsonObject* _tmp20_ = NULL;
		gint _tmp21_ = 0;
		_tmp18_ = media_count;
		_tmp19_ = status;
		_tmp20_ = json_object_get_object_member (_tmp19_, "extended_entities");
		_tmp21_ = utils_get_json_array_size (_tmp20_, "media");
		media_count = _tmp18_ + _tmp21_;
	}
	_tmp22_ = media_count;
	_tmp23_ = urls;
	_tmp24_ = json_array_get_length (_tmp23_);
	media_count = _tmp22_ + ((gint) _tmp24_);
	_tmp25_ = _data15_->mt;
	_tmp26_ = media_count;
	_tmp27_ = g_new0 (Media*, _tmp26_ + 1);
	_tmp25_->medias = (_vala_array_free (_tmp25_->medias, _tmp25_->medias_length1, (GDestroyNotify) g_object_unref), NULL);
	_tmp25_->medias = _tmp27_;
	_tmp25_->medias_length1 = _tmp26_;
	_data15_->real_media_count = 0;
	_tmp28_ = _data15_->mt;
	_tmp29_ = urls;
	_tmp30_ = json_array_get_length (_tmp29_);
	_tmp31_ = hashtags;
	_tmp32_ = json_array_get_length (_tmp31_);
	_tmp33_ = user_mentions;
	_tmp34_ = json_array_get_length (_tmp33_);
	_tmp35_ = media_count;
	_tmp36_ = g_new0 (TextEntity, ((_tmp30_ + _tmp32_) + _tmp34_) + _tmp35_);
	_tmp28_->entities = (_vala_TextEntity_array_free (_tmp28_->entities, _tmp28_->entities_length1), NULL);
	_tmp28_->entities = _tmp36_;
	_tmp28_->entities_length1 = ((_tmp30_ + _tmp32_) + _tmp34_) + _tmp35_;
	_data15_->url_index = 0;
	_tmp37_ = urls;
	json_array_foreach_element (_tmp37_, ___lambda26__json_array_foreach, _data15_);
	_tmp38_ = hashtags;
	json_array_foreach_element (_tmp38_, ___lambda27__json_array_foreach, _data15_);
	_tmp39_ = user_mentions;
	json_array_foreach_element (_tmp39_, ___lambda28__json_array_foreach, _data15_);
	_tmp40_ = entities;
	_tmp41_ = json_object_has_member (_tmp40_, "media");
	if (_tmp41_) {
		JsonArray* medias = NULL;
		JsonObject* _tmp42_ = NULL;
		JsonArray* _tmp43_ = NULL;
		JsonArray* _tmp44_ = NULL;
		JsonArray* _tmp45_ = NULL;
		_tmp42_ = entities;
		_tmp43_ = json_object_get_array_member (_tmp42_, "media");
		_tmp44_ = _json_array_ref0 (_tmp43_);
		medias = _tmp44_;
		_tmp45_ = medias;
		json_array_foreach_element (_tmp45_, ____lambda29__json_array_foreach, _data15_);
		_json_array_unref0 (medias);
	}
	_tmp46_ = status;
	_tmp47_ = json_object_has_member (_tmp46_, "extended_entities");
	if (_tmp47_) {
		JsonObject* extended_entities = NULL;
		JsonObject* _tmp48_ = NULL;
		JsonObject* _tmp49_ = NULL;
		JsonObject* _tmp50_ = NULL;
		JsonArray* extended_media = NULL;
		JsonObject* _tmp51_ = NULL;
		JsonArray* _tmp52_ = NULL;
		JsonArray* _tmp53_ = NULL;
		JsonArray* _tmp54_ = NULL;
		_tmp48_ = status;
		_tmp49_ = json_object_get_object_member (_tmp48_, "extended_entities");
		_tmp50_ = _json_object_ref0 (_tmp49_);
		extended_entities = _tmp50_;
		_tmp51_ = extended_entities;
		_tmp52_ = json_object_get_array_member (_tmp51_, "media");
		_tmp53_ = _json_array_ref0 (_tmp52_);
		extended_media = _tmp53_;
		_tmp54_ = extended_media;
		json_array_foreach_element (_tmp54_, ____lambda30__json_array_foreach, _data15_);
		_json_array_unref0 (extended_media);
		_json_object_unref0 (extended_entities);
	}
	_tmp55_ = _data15_->mt;
	_tmp56_ = _data15_->real_media_count;
	_tmp57_ = _tmp56_;
	_tmp55_->medias = g_renew (Media*, _tmp55_->medias, _tmp56_);
	(_tmp57_ > _tmp55_->medias_length1) ? memset (_tmp55_->medias + _tmp55_->medias_length1, 0, sizeof (Media*) * (_tmp57_ - _tmp55_->medias_length1)) : NULL;
	_tmp55_->medias_length1 = _tmp57_;
	_tmp58_ = inline_media_downloader_get ();
	_tmp59_ = _tmp58_;
	_tmp60_ = _data15_->mt;
	_tmp61_ = _data15_->mt;
	_tmp62_ = _tmp61_->medias;
	_tmp62__length1 = _tmp61_->medias_length1;
	inline_media_downloader_load_all_media (_tmp59_, _tmp60_, _tmp62_, _tmp62__length1);
	_g_object_unref0 (_tmp59_);
	_tmp63_ = _data15_->mt;
	_tmp64_ = _data15_->url_index;
	_tmp65_ = _tmp64_;
	_tmp63_->entities = g_renew (TextEntity, _tmp63_->entities, _tmp64_);
	(_tmp65_ > _tmp63_->entities_length1) ? memset (_tmp63_->entities + _tmp63_->entities_length1, 0, sizeof (TextEntity) * (_tmp65_ - _tmp63_->entities_length1)) : NULL;
	_tmp63_->entities_length1 = _tmp65_;
	_tmp66_ = _data15_->mt;
	tweet_utils_sort_entities (&_tmp66_->entities, &_tmp66_->entities_length1);
	_json_array_unref0 (user_mentions);
	_json_array_unref0 (hashtags);
	_json_array_unref0 (urls);
	_json_object_unref0 (entities);
	block15_data_unref (_data15_);
	_data15_ = NULL;
}


Tweet* tweet_construct (GType object_type) {
	Tweet * self = NULL;
	cairo_surface_t* _tmp0_ = NULL;
	self = (Tweet*) g_object_new (object_type, NULL);
	_tmp0_ = twitter_no_avatar;
	tweet_set_avatar (self, _tmp0_);
	return self;
}


Tweet* tweet_new (void) {
	return tweet_construct (TYPE_TWEET);
}


static TextEntity* _vala_array_dup5 (TextEntity* self, int length) {
	TextEntity* result;
	int i;
	result = g_new0 (TextEntity, length);
	for (i = 0; i < length; i++) {
		TextEntity _tmp0_ = {0};
		text_entity_copy (&self[i], &_tmp0_);
		result[i] = _tmp0_;
	}
	return result;
}


static TextEntity* _vala_array_dup6 (TextEntity* self, int length) {
	TextEntity* result;
	int i;
	result = g_new0 (TextEntity, length);
	for (i = 0; i < length; i++) {
		TextEntity _tmp0_ = {0};
		text_entity_copy (&self[i], &_tmp0_);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_ = 0L;
	gchar _tmp1_ = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


gchar** tweet_get_mentions (Tweet* self, int* result_length1) {
	gchar** result = NULL;
	TextEntity* entities = NULL;
	gint entities_length1 = 0;
	gint _entities_size_ = 0;
	MiniTweet* _tmp0_ = NULL;
	gchar** e = NULL;
	TextEntity* _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
	gchar** _tmp8_ = NULL;
	gint e_length1 = 0;
	gint _e_size_ = 0;
	gint n_mentions = 0;
	TextEntity* _tmp9_ = NULL;
	gint _tmp9__length1 = 0;
	gint _tmp21_ = 0;
	gint _tmp22_ = 0;
	gchar** _tmp23_ = NULL;
	gint _tmp23__length1 = 0;
	g_return_val_if_fail (IS_TWEET (self), NULL);
	_tmp0_ = self->retweeted_tweet;
	if (_tmp0_ != NULL) {
		MiniTweet* _tmp1_ = NULL;
		TextEntity* _tmp2_ = NULL;
		gint _tmp2__length1 = 0;
		TextEntity* _tmp3_ = NULL;
		gint _tmp3__length1 = 0;
		_tmp1_ = self->retweeted_tweet;
		_tmp2_ = _tmp1_->entities;
		_tmp2__length1 = _tmp1_->entities_length1;
		_tmp3_ = (_tmp2_ != NULL) ? _vala_array_dup5 (_tmp2_, _tmp2__length1) : ((gpointer) _tmp2_);
		_tmp3__length1 = _tmp2__length1;
		entities = (_vala_TextEntity_array_free (entities, entities_length1), NULL);
		entities = _tmp3_;
		entities_length1 = _tmp3__length1;
		_entities_size_ = entities_length1;
	} else {
		MiniTweet* _tmp4_ = NULL;
		TextEntity* _tmp5_ = NULL;
		gint _tmp5__length1 = 0;
		TextEntity* _tmp6_ = NULL;
		gint _tmp6__length1 = 0;
		_tmp4_ = self->source_tweet;
		_tmp5_ = _tmp4_->entities;
		_tmp5__length1 = _tmp4_->entities_length1;
		_tmp6_ = (_tmp5_ != NULL) ? _vala_array_dup6 (_tmp5_, _tmp5__length1) : ((gpointer) _tmp5_);
		_tmp6__length1 = _tmp5__length1;
		entities = (_vala_TextEntity_array_free (entities, entities_length1), NULL);
		entities = _tmp6_;
		entities_length1 = _tmp6__length1;
		_entities_size_ = entities_length1;
	}
	_tmp7_ = entities;
	_tmp7__length1 = entities_length1;
	_tmp8_ = g_new0 (gchar*, _tmp7__length1 + 1);
	e = _tmp8_;
	e_length1 = _tmp7__length1;
	_e_size_ = e_length1;
	n_mentions = 0;
	_tmp9_ = entities;
	_tmp9__length1 = entities_length1;
	{
		TextEntity* entity_collection = NULL;
		gint entity_collection_length1 = 0;
		gint _entity_collection_size_ = 0;
		gint entity_it = 0;
		entity_collection = _tmp9_;
		entity_collection_length1 = _tmp9__length1;
		for (entity_it = 0; entity_it < _tmp9__length1; entity_it = entity_it + 1) {
			TextEntity _tmp10_ = {0};
			TextEntity entity = {0};
			text_entity_copy (&entity_collection[entity_it], &_tmp10_);
			entity = _tmp10_;
			{
				TextEntity _tmp11_ = {0};
				const gchar* _tmp12_ = NULL;
				gchar _tmp13_ = '\0';
				_tmp11_ = entity;
				_tmp12_ = _tmp11_.display_text;
				_tmp13_ = string_get (_tmp12_, (glong) 0);
				if (_tmp13_ == '@') {
					gchar** _tmp14_ = NULL;
					gint _tmp14__length1 = 0;
					gint _tmp15_ = 0;
					TextEntity _tmp16_ = {0};
					const gchar* _tmp17_ = NULL;
					gchar* _tmp18_ = NULL;
					gchar* _tmp19_ = NULL;
					gint _tmp20_ = 0;
					_tmp14_ = e;
					_tmp14__length1 = e_length1;
					_tmp15_ = n_mentions;
					_tmp16_ = entity;
					_tmp17_ = _tmp16_.display_text;
					_tmp18_ = g_strdup (_tmp17_);
					_g_free0 (_tmp14_[_tmp15_]);
					_tmp14_[_tmp15_] = _tmp18_;
					_tmp19_ = _tmp14_[_tmp15_];
					_tmp20_ = n_mentions;
					n_mentions = _tmp20_ + 1;
				}
				text_entity_destroy (&entity);
			}
		}
	}
	_tmp21_ = n_mentions;
	_tmp22_ = _tmp21_;
	e = g_renew (gchar*, e, _tmp21_);
	(_tmp22_ > e_length1) ? memset (e + e_length1, 0, sizeof (gchar*) * (_tmp22_ - e_length1)) : NULL;
	e_length1 = _tmp22_;
	_e_size_ = _tmp22_;
	_tmp23_ = e;
	_tmp23__length1 = e_length1;
	if (result_length1) {
		*result_length1 = _tmp23__length1;
	}
	result = _tmp23_;
	entities = (_vala_TextEntity_array_free (entities, entities_length1), NULL);
	return result;
}


/**
   * Fills all the data of this tweet from Json data.
   * @param status The Json object to get the data from
   * @param now The current time
   */
static void __lambda40_ (Tweet* self, cairo_surface_t* a) {
	cairo_surface_t* _tmp0_ = NULL;
	g_return_if_fail (a != NULL);
	_tmp0_ = a;
	tweet_set_avatar (self, _tmp0_);
}


static void ___lambda40__twitter_avatar_downloaded_func (cairo_surface_t* avatar, gpointer self) {
	__lambda40_ ((Tweet*) self, avatar);
}


void tweet_load_from_json (Tweet* self, JsonNode* status_node, GDateTime* now, Account* account) {
	JsonObject* status = NULL;
	JsonNode* _tmp0_ = NULL;
	JsonObject* _tmp1_ = NULL;
	JsonObject* _tmp2_ = NULL;
	JsonObject* user = NULL;
	JsonObject* _tmp3_ = NULL;
	JsonObject* _tmp4_ = NULL;
	JsonObject* _tmp5_ = NULL;
	JsonObject* _tmp6_ = NULL;
	gint64 _tmp7_ = 0LL;
	JsonObject* _tmp8_ = NULL;
	gboolean _tmp9_ = FALSE;
	JsonObject* _tmp10_ = NULL;
	gboolean _tmp11_ = FALSE;
	JsonObject* _tmp12_ = NULL;
	gint64 _tmp13_ = 0LL;
	JsonObject* _tmp14_ = NULL;
	gint64 _tmp15_ = 0LL;
	JsonObject* _tmp16_ = NULL;
	MiniTweet* _tmp17_ = NULL;
	JsonObject* _tmp18_ = NULL;
	gboolean _tmp19_ = FALSE;
	JsonObject* _tmp54_ = NULL;
	gboolean _tmp55_ = FALSE;
	JsonObject* _tmp76_ = NULL;
	gboolean _tmp77_ = FALSE;
	Twitter* _tmp81_ = NULL;
	Twitter* _tmp82_ = NULL;
	const gchar* _tmp83_ = NULL;
	cairo_surface_t* _tmp84_ = NULL;
	cairo_surface_t* _tmp85_ = NULL;
	g_return_if_fail (IS_TWEET (self));
	g_return_if_fail (status_node != NULL);
	g_return_if_fail (now != NULL);
	g_return_if_fail (IS_ACCOUNT (account));
	_tmp0_ = status_node;
	_tmp1_ = json_node_get_object (_tmp0_);
	_tmp2_ = _json_object_ref0 (_tmp1_);
	status = _tmp2_;
	_tmp3_ = status;
	_tmp4_ = json_object_get_object_member (_tmp3_, "user");
	_tmp5_ = _json_object_ref0 (_tmp4_);
	user = _tmp5_;
	_tmp6_ = status;
	_tmp7_ = json_object_get_int_member (_tmp6_, "id");
	self->id = _tmp7_;
	_tmp8_ = status;
	_tmp9_ = json_object_get_boolean_member (_tmp8_, "favorited");
	tweet_set_favorited (self, _tmp9_);
	_tmp10_ = status;
	_tmp11_ = json_object_get_boolean_member (_tmp10_, "retweeted");
	tweet_set_retweeted (self, _tmp11_);
	_tmp12_ = status;
	_tmp13_ = json_object_get_int_member (_tmp12_, "retweet_count");
	self->retweet_count = (gint) _tmp13_;
	_tmp14_ = status;
	_tmp15_ = json_object_get_int_member (_tmp14_, "favorite_count");
	self->favorite_count = (gint) _tmp15_;
	_tmp16_ = status;
	_tmp17_ = parse_mini_tweet (_tmp16_);
	_mini_tweet_unref0 (self->source_tweet);
	self->source_tweet = _tmp17_;
	_tmp18_ = status;
	_tmp19_ = json_object_has_member (_tmp18_, "retweeted_status");
	if (_tmp19_) {
		JsonObject* rt = NULL;
		JsonObject* _tmp20_ = NULL;
		JsonObject* _tmp21_ = NULL;
		JsonObject* _tmp22_ = NULL;
		JsonObject* _tmp23_ = NULL;
		MiniTweet* _tmp24_ = NULL;
		MiniTweet* _tmp25_ = NULL;
		JsonObject* _tmp26_ = NULL;
		JsonObject* rt_user = NULL;
		JsonObject* _tmp27_ = NULL;
		JsonObject* _tmp28_ = NULL;
		JsonObject* _tmp29_ = NULL;
		JsonObject* _tmp30_ = NULL;
		const gchar* _tmp31_ = NULL;
		gchar* _tmp32_ = NULL;
		JsonObject* _tmp33_ = NULL;
		gboolean _tmp34_ = FALSE;
		JsonObject* _tmp35_ = NULL;
		gboolean _tmp36_ = FALSE;
		JsonObject* _tmp37_ = NULL;
		gboolean _tmp38_ = FALSE;
		_tmp20_ = status;
		_tmp21_ = json_object_get_object_member (_tmp20_, "retweeted_status");
		_tmp22_ = _json_object_ref0 (_tmp21_);
		rt = _tmp22_;
		_tmp23_ = rt;
		_tmp24_ = parse_mini_tweet (_tmp23_);
		_mini_tweet_unref0 (self->retweeted_tweet);
		self->retweeted_tweet = _tmp24_;
		_tmp25_ = self->retweeted_tweet;
		_tmp26_ = rt;
		parse_entities (_tmp25_, _tmp26_);
		_tmp27_ = rt;
		_tmp28_ = json_object_get_object_member (_tmp27_, "user");
		_tmp29_ = _json_object_ref0 (_tmp28_);
		rt_user = _tmp29_;
		_tmp30_ = rt_user;
		_tmp31_ = json_object_get_string_member (_tmp30_, "profile_image_url");
		_tmp32_ = g_strdup (_tmp31_);
		_g_free0 (self->avatar_url);
		self->avatar_url = _tmp32_;
		_tmp33_ = rt_user;
		_tmp34_ = json_object_get_boolean_member (_tmp33_, "verified");
		self->verified = _tmp34_;
		_tmp35_ = rt_user;
		_tmp36_ = json_object_get_boolean_member (_tmp35_, "protected");
		self->protected = _tmp36_;
		_tmp37_ = rt;
		_tmp38_ = json_object_get_null_member (_tmp37_, "in_reply_to_status_id");
		if (!_tmp38_) {
			JsonObject* _tmp39_ = NULL;
			gint64 _tmp40_ = 0LL;
			_tmp39_ = rt;
			_tmp40_ = json_object_get_int_member (_tmp39_, "in_reply_to_status_id");
			self->reply_id = _tmp40_;
		}
		_json_object_unref0 (rt_user);
		_json_object_unref0 (rt);
	} else {
		MiniTweet* _tmp41_ = NULL;
		JsonObject* _tmp42_ = NULL;
		JsonObject* _tmp43_ = NULL;
		const gchar* _tmp44_ = NULL;
		gchar* _tmp45_ = NULL;
		JsonObject* _tmp46_ = NULL;
		gboolean _tmp47_ = FALSE;
		JsonObject* _tmp48_ = NULL;
		gboolean _tmp49_ = FALSE;
		JsonObject* _tmp50_ = NULL;
		gboolean _tmp51_ = FALSE;
		_tmp41_ = self->source_tweet;
		_tmp42_ = status;
		parse_entities (_tmp41_, _tmp42_);
		_tmp43_ = user;
		_tmp44_ = json_object_get_string_member (_tmp43_, "profile_image_url");
		_tmp45_ = g_strdup (_tmp44_);
		_g_free0 (self->avatar_url);
		self->avatar_url = _tmp45_;
		_tmp46_ = user;
		_tmp47_ = json_object_get_boolean_member (_tmp46_, "verified");
		self->verified = _tmp47_;
		_tmp48_ = user;
		_tmp49_ = json_object_get_boolean_member (_tmp48_, "protected");
		self->protected = _tmp49_;
		_tmp50_ = status;
		_tmp51_ = json_object_get_null_member (_tmp50_, "in_reply_to_status_id");
		if (!_tmp51_) {
			JsonObject* _tmp52_ = NULL;
			gint64 _tmp53_ = 0LL;
			_tmp52_ = status;
			_tmp53_ = json_object_get_int_member (_tmp52_, "in_reply_to_status_id");
			self->reply_id = _tmp53_;
		}
	}
	_tmp54_ = status;
	_tmp55_ = json_object_has_member (_tmp54_, "quoted_status");
	if (_tmp55_) {
		JsonObject* quoted_status = NULL;
		JsonObject* _tmp56_ = NULL;
		JsonObject* _tmp57_ = NULL;
		JsonObject* _tmp58_ = NULL;
		JsonObject* _tmp59_ = NULL;
		MiniTweet* _tmp60_ = NULL;
		MiniTweet* _tmp61_ = NULL;
		JsonObject* _tmp62_ = NULL;
		_tmp56_ = status;
		_tmp57_ = json_object_get_object_member (_tmp56_, "quoted_status");
		_tmp58_ = _json_object_ref0 (_tmp57_);
		quoted_status = _tmp58_;
		_tmp59_ = quoted_status;
		_tmp60_ = parse_mini_tweet (_tmp59_);
		_mini_tweet_unref0 (self->quoted_tweet);
		self->quoted_tweet = _tmp60_;
		_tmp61_ = self->quoted_tweet;
		_tmp62_ = quoted_status;
		parse_entities (_tmp61_, _tmp62_);
		_json_object_unref0 (quoted_status);
	} else {
		gboolean _tmp63_ = FALSE;
		MiniTweet* _tmp64_ = NULL;
		_tmp64_ = self->retweeted_tweet;
		if (_tmp64_ != NULL) {
			JsonObject* _tmp65_ = NULL;
			JsonObject* _tmp66_ = NULL;
			gboolean _tmp67_ = FALSE;
			_tmp65_ = status;
			_tmp66_ = json_object_get_object_member (_tmp65_, "retweeted_status");
			_tmp67_ = json_object_has_member (_tmp66_, "quoted_status");
			_tmp63_ = _tmp67_;
		} else {
			_tmp63_ = FALSE;
		}
		if (_tmp63_) {
			JsonObject* quoted_status = NULL;
			JsonObject* _tmp68_ = NULL;
			JsonObject* _tmp69_ = NULL;
			JsonObject* _tmp70_ = NULL;
			JsonObject* _tmp71_ = NULL;
			JsonObject* _tmp72_ = NULL;
			MiniTweet* _tmp73_ = NULL;
			MiniTweet* _tmp74_ = NULL;
			JsonObject* _tmp75_ = NULL;
			_tmp68_ = status;
			_tmp69_ = json_object_get_object_member (_tmp68_, "retweeted_status");
			_tmp70_ = json_object_get_object_member (_tmp69_, "quoted_status");
			_tmp71_ = _json_object_ref0 (_tmp70_);
			quoted_status = _tmp71_;
			_tmp72_ = quoted_status;
			_tmp73_ = parse_mini_tweet (_tmp72_);
			_mini_tweet_unref0 (self->quoted_tweet);
			self->quoted_tweet = _tmp73_;
			_tmp74_ = self->quoted_tweet;
			_tmp75_ = quoted_status;
			parse_entities (_tmp74_, _tmp75_);
			_json_object_unref0 (quoted_status);
		}
	}
	_tmp76_ = status;
	_tmp77_ = json_object_has_member (_tmp76_, "current_user_retweet");
	if (_tmp77_) {
		JsonObject* _tmp78_ = NULL;
		JsonObject* _tmp79_ = NULL;
		gint64 _tmp80_ = 0LL;
		_tmp78_ = status;
		_tmp79_ = json_object_get_object_member (_tmp78_, "current_user_retweet");
		_tmp80_ = json_object_get_int_member (_tmp79_, "id");
		self->my_retweet = _tmp80_;
		tweet_set_retweeted (self, TRUE);
	}
	_tmp81_ = twitter_get ();
	_tmp82_ = _tmp81_;
	_tmp83_ = self->avatar_url;
	_tmp84_ = twitter_get_avatar (_tmp82_, _tmp83_, ___lambda40__twitter_avatar_downloaded_func, g_object_ref (self), g_object_unref, 48);
	_tmp85_ = _tmp84_;
	tweet_set_avatar (self, _tmp85_);
	_cairo_surface_destroy0 (_tmp85_);
	_g_object_unref0 (_tmp82_);
	_json_object_unref0 (user);
	_json_object_unref0 (status);
}


/**
   * Returns the text of this tweet in pango markup form,
   * i.e. formatted with the html tags used by pango.
   *
   * @return The tweet's formatted text.
   */
gchar* tweet_get_formatted_text (Tweet* self) {
	gchar* result = NULL;
	MiniTweet* t = NULL;
	MiniTweet* _tmp0_ = NULL;
	MiniTweet* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	g_return_val_if_fail (IS_TWEET (self), NULL);
	_tmp0_ = self->retweeted_tweet;
	if (_tmp0_ != NULL) {
		MiniTweet* _tmp1_ = NULL;
		MiniTweet* _tmp2_ = NULL;
		_tmp1_ = self->retweeted_tweet;
		_tmp2_ = _mini_tweet_ref0 (_tmp1_);
		_mini_tweet_unref0 (t);
		t = _tmp2_;
	} else {
		MiniTweet* _tmp3_ = NULL;
		MiniTweet* _tmp4_ = NULL;
		_tmp3_ = self->source_tweet;
		_tmp4_ = _mini_tweet_ref0 (_tmp3_);
		_mini_tweet_unref0 (t);
		t = _tmp4_;
	}
	_tmp5_ = t;
	_tmp6_ = text_transform_transform_tweet (_tmp5_, 0, (gint64) -1);
	result = _tmp6_;
	_mini_tweet_unref0 (t);
	return result;
}


/**
   * Returns the text of this tweet, with its long urls.
   * Twitter automatically shortens them.
   *
   * @return The tweet's text with long urls
   */
gchar* tweet_get_real_text (Tweet* self) {
	gchar* result = NULL;
	MiniTweet* t = NULL;
	MiniTweet* _tmp0_ = NULL;
	MiniTweet* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	g_return_val_if_fail (IS_TWEET (self), NULL);
	_tmp0_ = self->retweeted_tweet;
	if (_tmp0_ != NULL) {
		MiniTweet* _tmp1_ = NULL;
		MiniTweet* _tmp2_ = NULL;
		_tmp1_ = self->retweeted_tweet;
		_tmp2_ = _mini_tweet_ref0 (_tmp1_);
		_mini_tweet_unref0 (t);
		t = _tmp2_;
	} else {
		MiniTweet* _tmp3_ = NULL;
		MiniTweet* _tmp4_ = NULL;
		_tmp3_ = self->source_tweet;
		_tmp4_ = _mini_tweet_ref0 (_tmp3_);
		_mini_tweet_unref0 (t);
		t = _tmp4_;
	}
	_tmp5_ = t;
	_tmp6_ = text_transform_transform_tweet (_tmp5_, TRANSFORM_FLAGS_EXPAND_LINKS, (gint64) -1);
	result = _tmp6_;
	_mini_tweet_unref0 (t);
	return result;
}


gchar* tweet_get_trimmed_text (Tweet* self) {
	gchar* result = NULL;
	MiniTweet* t = NULL;
	MiniTweet* _tmp0_ = NULL;
	gint64 _tmp5_ = 0LL;
	MiniTweet* _tmp6_ = NULL;
	gint64 quote_id = 0LL;
	MiniTweet* _tmp9_ = NULL;
	TransformFlags _tmp10_ = 0;
	gchar* _tmp11_ = NULL;
	g_return_val_if_fail (IS_TWEET (self), NULL);
	_tmp0_ = self->retweeted_tweet;
	if (_tmp0_ != NULL) {
		MiniTweet* _tmp1_ = NULL;
		MiniTweet* _tmp2_ = NULL;
		_tmp1_ = self->retweeted_tweet;
		_tmp2_ = _mini_tweet_ref0 (_tmp1_);
		_mini_tweet_unref0 (t);
		t = _tmp2_;
	} else {
		MiniTweet* _tmp3_ = NULL;
		MiniTweet* _tmp4_ = NULL;
		_tmp3_ = self->source_tweet;
		_tmp4_ = _mini_tweet_ref0 (_tmp3_);
		_mini_tweet_unref0 (t);
		t = _tmp4_;
	}
	_tmp6_ = self->quoted_tweet;
	if (_tmp6_ != NULL) {
		MiniTweet* _tmp7_ = NULL;
		gint64 _tmp8_ = 0LL;
		_tmp7_ = self->quoted_tweet;
		_tmp8_ = _tmp7_->id;
		_tmp5_ = _tmp8_;
	} else {
		_tmp5_ = (gint64) -1;
	}
	quote_id = _tmp5_;
	_tmp9_ = t;
	_tmp10_ = settings_get_text_transform_flags ();
	_tmp11_ = text_transform_transform_tweet (_tmp9_, _tmp10_, quote_id);
	result = _tmp11_;
	_mini_tweet_unref0 (t);
	return result;
}


gboolean tweet_get_is_hidden (Tweet* self) {
	gboolean result;
	guint _tmp0_ = 0U;
	g_return_val_if_fail (IS_TWEET (self), FALSE);
	_tmp0_ = self->hidden_flags;
	result = _tmp0_ > ((guint) 0);
	return result;
}


gboolean tweet_get_retweeted (Tweet* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (IS_TWEET (self), FALSE);
	_tmp0_ = self->priv->_retweeted;
	result = _tmp0_;
	return result;
}


void tweet_set_retweeted (Tweet* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (IS_TWEET (self));
	_tmp0_ = value;
	self->priv->_retweeted = _tmp0_;
	g_object_notify ((GObject *) self, "retweeted");
}


gboolean tweet_get_favorited (Tweet* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (IS_TWEET (self), FALSE);
	_tmp0_ = self->priv->_favorited;
	result = _tmp0_;
	return result;
}


void tweet_set_favorited (Tweet* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (IS_TWEET (self));
	_tmp0_ = value;
	self->priv->_favorited = _tmp0_;
	g_object_notify ((GObject *) self, "favorited");
}


gboolean tweet_get_deleted (Tweet* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (IS_TWEET (self), FALSE);
	_tmp0_ = self->priv->_deleted;
	result = _tmp0_;
	return result;
}


void tweet_set_deleted (Tweet* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (IS_TWEET (self));
	_tmp0_ = value;
	self->priv->_deleted = _tmp0_;
	g_object_notify ((GObject *) self, "deleted");
}


gint64 tweet_get_user_id (Tweet* self) {
	gint64 result;
	MiniTweet* _tmp0_ = NULL;
	g_return_val_if_fail (IS_TWEET (self), 0LL);
	_tmp0_ = self->retweeted_tweet;
	if (_tmp0_ != NULL) {
		MiniTweet* _tmp1_ = NULL;
		UserIdentity _tmp2_ = {0};
		gint64 _tmp3_ = 0LL;
		_tmp1_ = self->retweeted_tweet;
		_tmp2_ = _tmp1_->author;
		_tmp3_ = _tmp2_.id;
		result = _tmp3_;
		return result;
	} else {
		MiniTweet* _tmp4_ = NULL;
		UserIdentity _tmp5_ = {0};
		gint64 _tmp6_ = 0LL;
		_tmp4_ = self->source_tweet;
		_tmp5_ = _tmp4_->author;
		_tmp6_ = _tmp5_.id;
		result = _tmp6_;
		return result;
	}
}


const gchar* tweet_get_screen_name (Tweet* self) {
	const gchar* result;
	MiniTweet* _tmp0_ = NULL;
	g_return_val_if_fail (IS_TWEET (self), NULL);
	_tmp0_ = self->retweeted_tweet;
	if (_tmp0_ != NULL) {
		MiniTweet* _tmp1_ = NULL;
		UserIdentity _tmp2_ = {0};
		const gchar* _tmp3_ = NULL;
		_tmp1_ = self->retweeted_tweet;
		_tmp2_ = _tmp1_->author;
		_tmp3_ = _tmp2_.screen_name;
		result = _tmp3_;
		return result;
	} else {
		MiniTweet* _tmp4_ = NULL;
		UserIdentity _tmp5_ = {0};
		const gchar* _tmp6_ = NULL;
		_tmp4_ = self->source_tweet;
		_tmp5_ = _tmp4_->author;
		_tmp6_ = _tmp5_.screen_name;
		result = _tmp6_;
		return result;
	}
}


const gchar* tweet_get_user_name (Tweet* self) {
	const gchar* result;
	MiniTweet* _tmp0_ = NULL;
	g_return_val_if_fail (IS_TWEET (self), NULL);
	_tmp0_ = self->retweeted_tweet;
	if (_tmp0_ != NULL) {
		MiniTweet* _tmp1_ = NULL;
		UserIdentity _tmp2_ = {0};
		const gchar* _tmp3_ = NULL;
		_tmp1_ = self->retweeted_tweet;
		_tmp2_ = _tmp1_->author;
		_tmp3_ = _tmp2_.user_name;
		result = _tmp3_;
		return result;
	} else {
		MiniTweet* _tmp4_ = NULL;
		UserIdentity _tmp5_ = {0};
		const gchar* _tmp6_ = NULL;
		_tmp4_ = self->source_tweet;
		_tmp5_ = _tmp4_->author;
		_tmp6_ = _tmp5_.user_name;
		result = _tmp6_;
		return result;
	}
}


cairo_surface_t* tweet_get_avatar (Tweet* self) {
	cairo_surface_t* result;
	cairo_surface_t* _tmp0_ = NULL;
	g_return_val_if_fail (IS_TWEET (self), NULL);
	_tmp0_ = self->priv->_avatar;
	result = _tmp0_;
	return result;
}


static gpointer _cairo_surface_reference0 (gpointer self) {
	return self ? cairo_surface_reference (self) : NULL;
}


void tweet_set_avatar (Tweet* self, cairo_surface_t* value) {
	cairo_surface_t* _tmp0_ = NULL;
	cairo_surface_t* _tmp1_ = NULL;
	g_return_if_fail (IS_TWEET (self));
	_tmp0_ = value;
	_tmp1_ = _cairo_surface_reference0 (_tmp0_);
	_cairo_surface_destroy0 (self->priv->_avatar);
	self->priv->_avatar = _tmp1_;
	g_object_notify ((GObject *) self, "avatar");
}


gboolean tweet_get_seen (Tweet* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (IS_TWEET (self), FALSE);
	_tmp0_ = self->priv->_seen;
	result = _tmp0_;
	return result;
}


void tweet_set_seen (Tweet* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (IS_TWEET (self));
	_tmp0_ = value;
	self->priv->_seen = _tmp0_;
	_tmp2_ = value;
	if (_tmp2_) {
		const gchar* _tmp3_ = NULL;
		_tmp3_ = self->notification_id;
		_tmp1_ = _tmp3_ != NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		const gchar* _tmp4_ = NULL;
		_tmp4_ = self->notification_id;
		notification_manager_withdraw (_tmp4_);
		_g_free0 (self->notification_id);
		self->notification_id = NULL;
	}
	g_object_notify ((GObject *) self, "seen");
}


Media** tweet_get_medias (Tweet* self, int* result_length1) {
	Media** result;
	MiniTweet* _tmp0_ = NULL;
	g_return_val_if_fail (IS_TWEET (self), NULL);
	_tmp0_ = self->retweeted_tweet;
	if (_tmp0_ != NULL) {
		MiniTweet* _tmp1_ = NULL;
		Media** _tmp2_ = NULL;
		gint _tmp2__length1 = 0;
		Media** _tmp3_ = NULL;
		gint _tmp3__length1 = 0;
		_tmp1_ = self->retweeted_tweet;
		_tmp2_ = _tmp1_->medias;
		_tmp2__length1 = _tmp1_->medias_length1;
		_tmp3_ = _tmp2_;
		_tmp3__length1 = _tmp2__length1;
		if (result_length1) {
			*result_length1 = _tmp3__length1;
		}
		result = _tmp3_;
		return result;
	} else {
		MiniTweet* _tmp4_ = NULL;
		_tmp4_ = self->quoted_tweet;
		if (_tmp4_ != NULL) {
			MiniTweet* _tmp5_ = NULL;
			Media** _tmp6_ = NULL;
			gint _tmp6__length1 = 0;
			Media** _tmp7_ = NULL;
			gint _tmp7__length1 = 0;
			_tmp5_ = self->quoted_tweet;
			_tmp6_ = _tmp5_->medias;
			_tmp6__length1 = _tmp5_->medias_length1;
			_tmp7_ = _tmp6_;
			_tmp7__length1 = _tmp6__length1;
			if (result_length1) {
				*result_length1 = _tmp7__length1;
			}
			result = _tmp7_;
			return result;
		} else {
			MiniTweet* _tmp8_ = NULL;
			Media** _tmp9_ = NULL;
			gint _tmp9__length1 = 0;
			Media** _tmp10_ = NULL;
			gint _tmp10__length1 = 0;
			_tmp8_ = self->source_tweet;
			_tmp9_ = _tmp8_->medias;
			_tmp9__length1 = _tmp8_->medias_length1;
			_tmp10_ = _tmp9_;
			_tmp10__length1 = _tmp9__length1;
			if (result_length1) {
				*result_length1 = _tmp10__length1;
			}
			result = _tmp10_;
			return result;
		}
	}
}


gboolean tweet_get_has_inline_media (Tweet* self) {
	gboolean result;
	MiniTweet* _tmp0_ = NULL;
	g_return_val_if_fail (IS_TWEET (self), FALSE);
	_tmp0_ = self->retweeted_tweet;
	if (_tmp0_ != NULL) {
		gboolean _tmp1_ = FALSE;
		MiniTweet* _tmp2_ = NULL;
		Media** _tmp3_ = NULL;
		gint _tmp3__length1 = 0;
		_tmp2_ = self->retweeted_tweet;
		_tmp3_ = _tmp2_->medias;
		_tmp3__length1 = _tmp2_->medias_length1;
		if (_tmp3_ != NULL) {
			MiniTweet* _tmp4_ = NULL;
			Media** _tmp5_ = NULL;
			gint _tmp5__length1 = 0;
			_tmp4_ = self->retweeted_tweet;
			_tmp5_ = _tmp4_->medias;
			_tmp5__length1 = _tmp4_->medias_length1;
			_tmp1_ = _tmp5__length1 > 0;
		} else {
			_tmp1_ = FALSE;
		}
		result = _tmp1_;
		return result;
	} else {
		MiniTweet* _tmp6_ = NULL;
		_tmp6_ = self->quoted_tweet;
		if (_tmp6_ != NULL) {
			gboolean _tmp7_ = FALSE;
			MiniTweet* _tmp8_ = NULL;
			Media** _tmp9_ = NULL;
			gint _tmp9__length1 = 0;
			_tmp8_ = self->quoted_tweet;
			_tmp9_ = _tmp8_->medias;
			_tmp9__length1 = _tmp8_->medias_length1;
			if (_tmp9_ != NULL) {
				MiniTweet* _tmp10_ = NULL;
				Media** _tmp11_ = NULL;
				gint _tmp11__length1 = 0;
				_tmp10_ = self->quoted_tweet;
				_tmp11_ = _tmp10_->medias;
				_tmp11__length1 = _tmp10_->medias_length1;
				_tmp7_ = _tmp11__length1 > 0;
			} else {
				_tmp7_ = FALSE;
			}
			result = _tmp7_;
			return result;
		} else {
			gboolean _tmp12_ = FALSE;
			MiniTweet* _tmp13_ = NULL;
			Media** _tmp14_ = NULL;
			gint _tmp14__length1 = 0;
			_tmp13_ = self->source_tweet;
			_tmp14_ = _tmp13_->medias;
			_tmp14__length1 = _tmp13_->medias_length1;
			if (_tmp14_ != NULL) {
				MiniTweet* _tmp15_ = NULL;
				Media** _tmp16_ = NULL;
				gint _tmp16__length1 = 0;
				_tmp15_ = self->source_tweet;
				_tmp16_ = _tmp15_->medias;
				_tmp16__length1 = _tmp15_->medias_length1;
				_tmp12_ = _tmp16__length1 > 0;
			} else {
				_tmp12_ = FALSE;
			}
			result = _tmp12_;
			return result;
		}
	}
}


static void tweet_class_init (TweetClass * klass) {
	tweet_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (TweetPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_tweet_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_tweet_set_property;
	G_OBJECT_CLASS (klass)->finalize = tweet_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), TWEET_IS_HIDDEN, g_param_spec_boolean ("is-hidden", "is-hidden", "is-hidden", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TWEET_RETWEETED, g_param_spec_boolean ("retweeted", "retweeted", "retweeted", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TWEET_FAVORITED, g_param_spec_boolean ("favorited", "favorited", "favorited", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TWEET_DELETED, g_param_spec_boolean ("deleted", "deleted", "deleted", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TWEET_USER_ID, g_param_spec_int64 ("user-id", "user-id", "user-id", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TWEET_SCREEN_NAME, g_param_spec_string ("screen-name", "screen-name", "screen-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TWEET_USER_NAME, g_param_spec_string ("user-name", "user-name", "user-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TWEET_AVATAR, g_param_spec_pointer ("avatar", "avatar", "avatar", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TWEET_SEEN, g_param_spec_boolean ("seen", "seen", "seen", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TWEET_HAS_INLINE_MEDIA, g_param_spec_boolean ("has-inline-media", "has-inline-media", "has-inline-media", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_signal_new ("hidden_flags_changed", TYPE_TWEET, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void tweet_instance_init (Tweet * self) {
	self->priv = TWEET_GET_PRIVATE (self);
	self->hidden_flags = (guint) 0;
	self->priv->_retweeted = FALSE;
	self->priv->_favorited = FALSE;
	self->priv->_deleted = FALSE;
	self->retweeted_tweet = NULL;
	self->quoted_tweet = NULL;
	self->verified = FALSE;
	self->notification_id = NULL;
	self->priv->_seen = TRUE;
	self->reply_id = (gint64) 0;
}


static void tweet_finalize (GObject* obj) {
	Tweet * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_TWEET, Tweet);
	_mini_tweet_unref0 (self->source_tweet);
	_mini_tweet_unref0 (self->retweeted_tweet);
	_mini_tweet_unref0 (self->quoted_tweet);
	_cairo_surface_destroy0 (self->priv->_avatar);
	_g_free0 (self->avatar_url);
	_g_free0 (self->notification_id);
	G_OBJECT_CLASS (tweet_parent_class)->finalize (obj);
}


GType tweet_get_type (void) {
	static volatile gsize tweet_type_id__volatile = 0;
	if (g_once_init_enter (&tweet_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TweetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tweet_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Tweet), 0, (GInstanceInitFunc) tweet_instance_init, NULL };
		GType tweet_type_id;
		tweet_type_id = g_type_register_static (G_TYPE_OBJECT, "Tweet", &g_define_type_info, 0);
		g_once_init_leave (&tweet_type_id__volatile, tweet_type_id);
	}
	return tweet_type_id__volatile;
}


static void _vala_tweet_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	Tweet * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_TWEET, Tweet);
	switch (property_id) {
		case TWEET_IS_HIDDEN:
		g_value_set_boolean (value, tweet_get_is_hidden (self));
		break;
		case TWEET_RETWEETED:
		g_value_set_boolean (value, tweet_get_retweeted (self));
		break;
		case TWEET_FAVORITED:
		g_value_set_boolean (value, tweet_get_favorited (self));
		break;
		case TWEET_DELETED:
		g_value_set_boolean (value, tweet_get_deleted (self));
		break;
		case TWEET_USER_ID:
		g_value_set_int64 (value, tweet_get_user_id (self));
		break;
		case TWEET_SCREEN_NAME:
		g_value_set_string (value, tweet_get_screen_name (self));
		break;
		case TWEET_USER_NAME:
		g_value_set_string (value, tweet_get_user_name (self));
		break;
		case TWEET_AVATAR:
		g_value_set_pointer (value, tweet_get_avatar (self));
		break;
		case TWEET_SEEN:
		g_value_set_boolean (value, tweet_get_seen (self));
		break;
		case TWEET_HAS_INLINE_MEDIA:
		g_value_set_boolean (value, tweet_get_has_inline_media (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_tweet_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	Tweet * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_TWEET, Tweet);
	switch (property_id) {
		case TWEET_RETWEETED:
		tweet_set_retweeted (self, g_value_get_boolean (value));
		break;
		case TWEET_FAVORITED:
		tweet_set_favorited (self, g_value_get_boolean (value));
		break;
		case TWEET_DELETED:
		tweet_set_deleted (self, g_value_get_boolean (value));
		break;
		case TWEET_AVATAR:
		tweet_set_avatar (self, g_value_get_pointer (value));
		break;
		case TWEET_SEEN:
		tweet_set_seen (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



