/* MediaDialog.c generated by valac 0.26.2, the Vala compiler
 * generated from MediaDialog.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gdk/gdk.h>


#define TYPE_MEDIA_DIALOG (media_dialog_get_type ())
#define MEDIA_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_DIALOG, MediaDialog))
#define MEDIA_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_DIALOG, MediaDialogClass))
#define IS_MEDIA_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_DIALOG))
#define IS_MEDIA_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_DIALOG))
#define MEDIA_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_DIALOG, MediaDialogClass))

typedef struct _MediaDialog MediaDialog;
typedef struct _MediaDialogClass MediaDialogClass;
typedef struct _MediaDialogPrivate MediaDialogPrivate;

#define TYPE_TWEET (tweet_get_type ())
#define TWEET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWEET, Tweet))
#define TWEET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWEET, TweetClass))
#define IS_TWEET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWEET))
#define IS_TWEET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWEET))
#define TWEET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWEET, TweetClass))

typedef struct _Tweet Tweet;
typedef struct _TweetClass TweetClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_MEDIA (media_get_type ())
#define MEDIA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA, Media))
#define MEDIA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA, MediaClass))
#define IS_MEDIA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA))
#define IS_MEDIA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA))
#define MEDIA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA, MediaClass))

typedef struct _Media Media;
typedef struct _MediaClass MediaClass;
typedef struct _TweetPrivate TweetPrivate;
typedef struct _MediaPrivate MediaPrivate;

#define TYPE_MEDIA_TYPE (media_type_get_type ())

#define TYPE_MEDIA_IMAGE_WIDGET (media_image_widget_get_type ())
#define MEDIA_IMAGE_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_IMAGE_WIDGET, MediaImageWidget))
#define MEDIA_IMAGE_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_IMAGE_WIDGET, MediaImageWidgetClass))
#define IS_MEDIA_IMAGE_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_IMAGE_WIDGET))
#define IS_MEDIA_IMAGE_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_IMAGE_WIDGET))
#define MEDIA_IMAGE_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_IMAGE_WIDGET, MediaImageWidgetClass))

typedef struct _MediaImageWidget MediaImageWidget;
typedef struct _MediaImageWidgetClass MediaImageWidgetClass;

#define TYPE_MEDIA_VIDEO_WIDGET (media_video_widget_get_type ())
#define MEDIA_VIDEO_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_VIDEO_WIDGET, MediaVideoWidget))
#define MEDIA_VIDEO_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_VIDEO_WIDGET, MediaVideoWidgetClass))
#define IS_MEDIA_VIDEO_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_VIDEO_WIDGET))
#define IS_MEDIA_VIDEO_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_VIDEO_WIDGET))
#define MEDIA_VIDEO_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_VIDEO_WIDGET, MediaVideoWidgetClass))

typedef struct _MediaVideoWidget MediaVideoWidget;
typedef struct _MediaVideoWidgetClass MediaVideoWidgetClass;

struct _MediaDialog {
	GtkWindow parent_instance;
	MediaDialogPrivate * priv;
};

struct _MediaDialogClass {
	GtkWindowClass parent_class;
};

struct _MediaDialogPrivate {
	GtkOverlay* overlay;
	Tweet* tweet;
	gint cur_index;
};

struct _Tweet {
	GObject parent_instance;
	TweetPrivate * priv;
	gint64 id;
	gint64 rt_id;
	gchar* text;
	gint64 user_id;
	gchar* user_name;
	gchar* retweeted_by;
	gchar* rt_by_screen_name;
	gint64 rt_by_id;
	gboolean is_retweet;
	GdkPixbuf* inline_media;
	gchar* time_delta;
	gchar* avatar_url;
	gchar* avatar_name;
	gchar* screen_name;
	gint64 created_at;
	gint64 rt_created_at;
	gboolean verified;
	gint64 my_retweet;
	gboolean protected;
	gint64 reply_id;
	Media** medias;
	gint medias_length1;
	gint retweet_count;
	gint favorite_count;
	gchar** mentions;
	gint mentions_length1;
};

struct _TweetClass {
	GObjectClass parent_class;
};

typedef enum  {
	MEDIA_TYPE_IMAGE,
	MEDIA_TYPE_VINE,
	MEDIA_TYPE_GIF,
	MEDIA_TYPE_ANIMATED_GIF,
	MEDIA_TYPE_TWITTER_VIDEO,
	MEDIA_TYPE_UNKNOWN
} MediaType;

struct _Media {
	GObject parent_instance;
	MediaPrivate * priv;
	gint64 id;
	gchar* path;
	gchar* thumb_path;
	gchar* url;
	MediaType type;
	GdkPixbuf* thumbnail;
	gboolean loaded;
	gboolean invalid;
};

struct _MediaClass {
	GObjectClass parent_class;
};


static gpointer media_dialog_parent_class = NULL;

GType media_dialog_get_type (void) G_GNUC_CONST;
GType tweet_get_type (void) G_GNUC_CONST;
#define MEDIA_DIALOG_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_MEDIA_DIALOG, MediaDialogPrivate))
enum  {
	MEDIA_DIALOG_DUMMY_PROPERTY
};
MediaDialog* media_dialog_new (Tweet* tweet, gint start_media_index);
MediaDialog* media_dialog_construct (GType object_type, Tweet* tweet, gint start_media_index);
GType media_get_type (void) G_GNUC_CONST;
static void media_dialog_change_media (MediaDialog* self, Media* media);
GType media_type_get_type (void) G_GNUC_CONST;
MediaImageWidget* media_image_widget_new (const gchar* path);
MediaImageWidget* media_image_widget_construct (GType object_type, const gchar* path);
GType media_image_widget_get_type (void) G_GNUC_CONST;
MediaVideoWidget* media_video_widget_new (Media* media);
MediaVideoWidget* media_video_widget_construct (GType object_type, Media* media);
GType media_video_widget_get_type (void) G_GNUC_CONST;
static void media_dialog_next_media (MediaDialog* self);
static void media_dialog_previous_media (MediaDialog* self);
static gboolean media_dialog_key_press_event_cb (MediaDialog* self, GdkEventKey* evt);
static gboolean _media_dialog_key_press_event_cb_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self);
static gboolean media_dialog_button_press_event_cb (MediaDialog* self);
static gboolean _media_dialog_button_press_event_cb_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static gboolean media_dialog_leave_notify_cb (MediaDialog* self);
static gboolean _media_dialog_leave_notify_cb_gtk_widget_leave_notify_event (GtkWidget* _sender, GdkEventCrossing* event, gpointer self);
static gboolean media_dialog_enter_notify_cb (MediaDialog* self);
static gboolean _media_dialog_enter_notify_cb_gtk_widget_enter_notify_event (GtkWidget* _sender, GdkEventCrossing* event, gpointer self);
static void media_dialog_finalize (GObject* obj);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


MediaDialog* media_dialog_construct (GType object_type, Tweet* tweet, gint start_media_index) {
	MediaDialog * self = NULL;
	Media* cur_media = NULL;
	Tweet* _tmp0_ = NULL;
	Media** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	gint _tmp2_ = 0;
	Media* _tmp3_ = NULL;
	Media* _tmp4_ = NULL;
	Tweet* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	g_return_val_if_fail (IS_TWEET (tweet), NULL);
	self = (MediaDialog*) g_object_new (object_type, NULL);
	_tmp0_ = tweet;
	_tmp1_ = _tmp0_->medias;
	_tmp1__length1 = _tmp0_->medias_length1;
	_tmp2_ = start_media_index;
	_tmp3_ = _tmp1_[_tmp2_];
	_tmp4_ = _g_object_ref0 (_tmp3_);
	cur_media = _tmp4_;
	_tmp5_ = tweet;
	self->priv->tweet = _tmp5_;
	_tmp6_ = start_media_index;
	self->priv->cur_index = _tmp6_;
	media_dialog_change_media (self, cur_media);
	_g_object_unref0 (cur_media);
	return self;
}


MediaDialog* media_dialog_new (Tweet* tweet, gint start_media_index) {
	return media_dialog_construct (TYPE_MEDIA_DIALOG, tweet, start_media_index);
}


static void media_dialog_change_media (MediaDialog* self, Media* media) {
	GtkWidget* cur_child = NULL;
	GtkOverlay* _tmp0_ = NULL;
	GtkWidget* _tmp1_ = NULL;
	GtkWidget* _tmp2_ = NULL;
	gint cur_width = 0;
	gint cur_height = 0;
	gint new_width = 0;
	gint new_height = 0;
	GtkOverlay* _tmp3_ = NULL;
	GtkWidget* _tmp4_ = NULL;
	GtkWidget* new_widget = NULL;
	gboolean _tmp10_ = FALSE;
	Media* _tmp11_ = NULL;
	MediaType _tmp12_ = 0;
	GtkOverlay* _tmp30_ = NULL;
	GtkWidget* _tmp31_ = NULL;
	GtkWidget* _tmp32_ = NULL;
	GtkWidget* _tmp33_ = NULL;
	gint _tmp34_ = 0;
	gint _tmp35_ = 0;
	gboolean _tmp36_ = FALSE;
	gboolean _tmp37_ = FALSE;
	gboolean _tmp38_ = FALSE;
	gint _tmp39_ = 0;
	gint _tmp40_ = 0;
	g_return_if_fail (IS_MEDIA_DIALOG (self));
	g_return_if_fail (IS_MEDIA (media));
	_tmp0_ = self->priv->overlay;
	_tmp1_ = gtk_bin_get_child (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_bin_get_type (), GtkBin));
	_tmp2_ = _g_object_ref0 (_tmp1_);
	cur_child = _tmp2_;
	cur_width = 0;
	cur_height = 0;
	_tmp3_ = self->priv->overlay;
	_tmp4_ = gtk_bin_get_child (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_bin_get_type (), GtkBin));
	if (_tmp4_ != NULL) {
		GtkOverlay* _tmp5_ = NULL;
		GtkWidget* _tmp6_ = NULL;
		GtkWidget* _tmp7_ = NULL;
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
		_tmp5_ = self->priv->overlay;
		_tmp6_ = cur_child;
		gtk_container_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_container_get_type (), GtkContainer), _tmp6_);
		_tmp7_ = cur_child;
		gtk_widget_get_size_request (_tmp7_, &_tmp8_, &_tmp9_);
		cur_width = _tmp8_;
		cur_height = _tmp9_;
	}
	new_widget = NULL;
	_tmp11_ = media;
	_tmp12_ = _tmp11_->type;
	if (_tmp12_ == MEDIA_TYPE_IMAGE) {
		_tmp10_ = TRUE;
	} else {
		Media* _tmp13_ = NULL;
		MediaType _tmp14_ = 0;
		_tmp13_ = media;
		_tmp14_ = _tmp13_->type;
		_tmp10_ = _tmp14_ == MEDIA_TYPE_GIF;
	}
	if (_tmp10_) {
		Media* _tmp15_ = NULL;
		const gchar* _tmp16_ = NULL;
		MediaImageWidget* _tmp17_ = NULL;
		_tmp15_ = media;
		_tmp16_ = _tmp15_->path;
		_tmp17_ = media_image_widget_new (_tmp16_);
		g_object_ref_sink (_tmp17_);
		_g_object_unref0 (new_widget);
		new_widget = G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, gtk_widget_get_type (), GtkWidget);
	} else {
		gboolean _tmp18_ = FALSE;
		gboolean _tmp19_ = FALSE;
		Media* _tmp20_ = NULL;
		MediaType _tmp21_ = 0;
		_tmp20_ = media;
		_tmp21_ = _tmp20_->type;
		if (_tmp21_ == MEDIA_TYPE_VINE) {
			_tmp19_ = TRUE;
		} else {
			Media* _tmp22_ = NULL;
			MediaType _tmp23_ = 0;
			_tmp22_ = media;
			_tmp23_ = _tmp22_->type;
			_tmp19_ = _tmp23_ == MEDIA_TYPE_ANIMATED_GIF;
		}
		if (_tmp19_) {
			_tmp18_ = TRUE;
		} else {
			Media* _tmp24_ = NULL;
			MediaType _tmp25_ = 0;
			_tmp24_ = media;
			_tmp25_ = _tmp24_->type;
			_tmp18_ = _tmp25_ == MEDIA_TYPE_TWITTER_VIDEO;
		}
		if (_tmp18_) {
			Media* _tmp26_ = NULL;
			MediaVideoWidget* _tmp27_ = NULL;
			_tmp26_ = media;
			_tmp27_ = media_video_widget_new (_tmp26_);
			g_object_ref_sink (_tmp27_);
			_g_object_unref0 (new_widget);
			new_widget = G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, gtk_widget_get_type (), GtkWidget);
		} else {
			Media* _tmp28_ = NULL;
			MediaType _tmp29_ = 0;
			_tmp28_ = media;
			_tmp29_ = _tmp28_->type;
			g_critical ("MediaDialog.vala:60: Unknown media type %d", (gint) _tmp29_);
			_g_object_unref0 (new_widget);
			_g_object_unref0 (cur_child);
			return;
		}
	}
	_tmp30_ = self->priv->overlay;
	_tmp31_ = new_widget;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, gtk_container_get_type (), GtkContainer), _tmp31_);
	_tmp32_ = new_widget;
	gtk_widget_show_all (_tmp32_);
	_tmp33_ = new_widget;
	gtk_widget_get_size_request (_tmp33_, &_tmp34_, &_tmp35_);
	new_width = _tmp34_;
	new_height = _tmp35_;
	_tmp39_ = new_width;
	_tmp40_ = cur_width;
	if (_tmp39_ != _tmp40_) {
		_tmp38_ = TRUE;
	} else {
		gint _tmp41_ = 0;
		gint _tmp42_ = 0;
		_tmp41_ = new_height;
		_tmp42_ = cur_height;
		_tmp38_ = _tmp41_ != _tmp42_;
	}
	if (_tmp38_) {
		gint _tmp43_ = 0;
		_tmp43_ = new_width;
		_tmp37_ = _tmp43_ > 0;
	} else {
		_tmp37_ = FALSE;
	}
	if (_tmp37_) {
		gint _tmp44_ = 0;
		_tmp44_ = new_height;
		_tmp36_ = _tmp44_ > 0;
	} else {
		_tmp36_ = FALSE;
	}
	if (_tmp36_) {
		gint _tmp45_ = 0;
		gint _tmp46_ = 0;
		_tmp45_ = new_width;
		_tmp46_ = new_height;
		gtk_window_resize (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), _tmp45_, _tmp46_);
	}
	gtk_widget_queue_resize (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	gtk_widget_queue_draw (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (new_widget);
	_g_object_unref0 (cur_child);
}


static void media_dialog_next_media (MediaDialog* self) {
	gint _tmp0_ = 0;
	Tweet* _tmp1_ = NULL;
	Media** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	g_return_if_fail (IS_MEDIA_DIALOG (self));
	_tmp0_ = self->priv->cur_index;
	_tmp1_ = self->priv->tweet;
	_tmp2_ = _tmp1_->medias;
	_tmp2__length1 = _tmp1_->medias_length1;
	if (_tmp0_ < (_tmp2__length1 - 1)) {
		gint _tmp3_ = 0;
		Tweet* _tmp4_ = NULL;
		Media** _tmp5_ = NULL;
		gint _tmp5__length1 = 0;
		gint _tmp6_ = 0;
		Media* _tmp7_ = NULL;
		_tmp3_ = self->priv->cur_index;
		self->priv->cur_index = _tmp3_ + 1;
		_tmp4_ = self->priv->tweet;
		_tmp5_ = _tmp4_->medias;
		_tmp5__length1 = _tmp4_->medias_length1;
		_tmp6_ = self->priv->cur_index;
		_tmp7_ = _tmp5_[_tmp6_];
		media_dialog_change_media (self, _tmp7_);
	}
}


static void media_dialog_previous_media (MediaDialog* self) {
	gint _tmp0_ = 0;
	g_return_if_fail (IS_MEDIA_DIALOG (self));
	_tmp0_ = self->priv->cur_index;
	if (_tmp0_ > 0) {
		gint _tmp1_ = 0;
		Tweet* _tmp2_ = NULL;
		Media** _tmp3_ = NULL;
		gint _tmp3__length1 = 0;
		gint _tmp4_ = 0;
		Media* _tmp5_ = NULL;
		_tmp1_ = self->priv->cur_index;
		self->priv->cur_index = _tmp1_ - 1;
		_tmp2_ = self->priv->tweet;
		_tmp3_ = _tmp2_->medias;
		_tmp3__length1 = _tmp2_->medias_length1;
		_tmp4_ = self->priv->cur_index;
		_tmp5_ = _tmp3_[_tmp4_];
		media_dialog_change_media (self, _tmp5_);
	}
}


static gboolean media_dialog_key_press_event_cb (MediaDialog* self, GdkEventKey* evt) {
	gboolean result = FALSE;
	GdkEventKey* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	g_return_val_if_fail (IS_MEDIA_DIALOG (self), FALSE);
	g_return_val_if_fail (evt != NULL, FALSE);
	_tmp0_ = evt;
	_tmp1_ = _tmp0_->keyval;
	if (_tmp1_ == ((guint) GDK_KEY_Left)) {
		media_dialog_previous_media (self);
	} else {
		GdkEventKey* _tmp2_ = NULL;
		guint _tmp3_ = 0U;
		_tmp2_ = evt;
		_tmp3_ = _tmp2_->keyval;
		if (_tmp3_ == ((guint) GDK_KEY_Right)) {
			media_dialog_next_media (self);
		} else {
			gtk_widget_destroy (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
		}
	}
	result = TRUE;
	return result;
}


static gboolean _media_dialog_key_press_event_cb_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self) {
	gboolean result;
	result = media_dialog_key_press_event_cb ((MediaDialog*) self, event);
	return result;
}


static gboolean media_dialog_button_press_event_cb (MediaDialog* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (IS_MEDIA_DIALOG (self), FALSE);
	gtk_widget_destroy (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	result = TRUE;
	return result;
}


static gboolean _media_dialog_button_press_event_cb_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = media_dialog_button_press_event_cb ((MediaDialog*) self);
	return result;
}


static gboolean media_dialog_leave_notify_cb (MediaDialog* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (IS_MEDIA_DIALOG (self), FALSE);
	result = TRUE;
	return result;
}


static gboolean _media_dialog_leave_notify_cb_gtk_widget_leave_notify_event (GtkWidget* _sender, GdkEventCrossing* event, gpointer self) {
	gboolean result;
	result = media_dialog_leave_notify_cb ((MediaDialog*) self);
	return result;
}


static gboolean media_dialog_enter_notify_cb (MediaDialog* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (IS_MEDIA_DIALOG (self), FALSE);
	result = TRUE;
	return result;
}


static gboolean _media_dialog_enter_notify_cb_gtk_widget_enter_notify_event (GtkWidget* _sender, GdkEventCrossing* event, gpointer self) {
	gboolean result;
	result = media_dialog_enter_notify_cb ((MediaDialog*) self);
	return result;
}


static void media_dialog_class_init (MediaDialogClass * klass) {
	gint MediaDialog_private_offset;
	media_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (MediaDialogPrivate));
	G_OBJECT_CLASS (klass)->finalize = media_dialog_finalize;
	MediaDialog_private_offset = g_type_class_get_instance_private_offset (klass);
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/baedert/corebird/ui/media-dialog.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "overlay", FALSE, MediaDialog_private_offset + G_STRUCT_OFFSET (MediaDialogPrivate, overlay));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "key_press_event_cb", G_CALLBACK(_media_dialog_key_press_event_cb_gtk_widget_key_press_event));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "button_press_event_cb", G_CALLBACK(_media_dialog_button_press_event_cb_gtk_widget_button_press_event));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "leave_notify_cb", G_CALLBACK(_media_dialog_leave_notify_cb_gtk_widget_leave_notify_event));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "enter_notify_cb", G_CALLBACK(_media_dialog_enter_notify_cb_gtk_widget_enter_notify_event));
}


static void media_dialog_instance_init (MediaDialog * self) {
	self->priv = MEDIA_DIALOG_GET_PRIVATE (self);
	self->priv->cur_index = 0;
	gtk_widget_init_template (GTK_WIDGET (self));
}


static void media_dialog_finalize (GObject* obj) {
	MediaDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MEDIA_DIALOG, MediaDialog);
	_g_object_unref0 (self->priv->overlay);
	G_OBJECT_CLASS (media_dialog_parent_class)->finalize (obj);
}


GType media_dialog_get_type (void) {
	static volatile gsize media_dialog_type_id__volatile = 0;
	if (g_once_init_enter (&media_dialog_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MediaDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) media_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MediaDialog), 0, (GInstanceInitFunc) media_dialog_instance_init, NULL };
		GType media_dialog_type_id;
		media_dialog_type_id = g_type_register_static (gtk_window_get_type (), "MediaDialog", &g_define_type_info, 0);
		g_once_init_leave (&media_dialog_type_id__volatile, media_dialog_type_id);
	}
	return media_dialog_type_id__volatile;
}



