/* TweetListBox.c generated by valac 0.26.2, the Vala compiler
 * generated from TweetListBox.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>
#include <glib/gi18n-lib.h>
#include <pango/pango.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>


#define TYPE_TWEET_LIST_BOX (tweet_list_box_get_type ())
#define TWEET_LIST_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWEET_LIST_BOX, TweetListBox))
#define TWEET_LIST_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWEET_LIST_BOX, TweetListBoxClass))
#define IS_TWEET_LIST_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWEET_LIST_BOX))
#define IS_TWEET_LIST_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWEET_LIST_BOX))
#define TWEET_LIST_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWEET_LIST_BOX, TweetListBoxClass))

typedef struct _TweetListBox TweetListBox;
typedef struct _TweetListBoxClass TweetListBoxClass;
typedef struct _TweetListBoxPrivate TweetListBoxPrivate;

#define TYPE_PROGRESS_ENTRY (progress_entry_get_type ())
#define PROGRESS_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROGRESS_ENTRY, ProgressEntry))
#define PROGRESS_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROGRESS_ENTRY, ProgressEntryClass))
#define IS_PROGRESS_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROGRESS_ENTRY))
#define IS_PROGRESS_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROGRESS_ENTRY))
#define PROGRESS_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROGRESS_ENTRY, ProgressEntryClass))

typedef struct _ProgressEntry ProgressEntry;
typedef struct _ProgressEntryClass ProgressEntryClass;

#define TYPE_TWEET_LIST_ENTRY (tweet_list_entry_get_type ())
#define TWEET_LIST_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWEET_LIST_ENTRY, TweetListEntry))
#define TWEET_LIST_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWEET_LIST_ENTRY, TweetListEntryClass))
#define IS_TWEET_LIST_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWEET_LIST_ENTRY))
#define IS_TWEET_LIST_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWEET_LIST_ENTRY))
#define TWEET_LIST_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWEET_LIST_ENTRY, TweetListEntryClass))

typedef struct _TweetListEntry TweetListEntry;
typedef struct _TweetListEntryClass TweetListEntryClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _TweetListBox {
	GtkListBox parent_instance;
	TweetListBoxPrivate * priv;
};

struct _TweetListBoxClass {
	GtkListBoxClass parent_class;
};

struct _TweetListBoxPrivate {
	GtkStack* placeholder;
	GtkLabel* no_entries_label;
	ProgressEntry* progress_entry;
	GtkBox* error_box;
	GtkLabel* error_label;
	GtkButton* retry_button;
	TweetListEntry* _action_entry;
	GtkSpinner* spinner;
	gint _spinner_size;
};


static gpointer tweet_list_box_parent_class = NULL;

GType tweet_list_box_get_type (void) G_GNUC_CONST;
GType progress_entry_get_type (void) G_GNUC_CONST;
GType tweet_list_entry_get_type (void) G_GNUC_CONST;
#define TWEET_LIST_BOX_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_TWEET_LIST_BOX, TweetListBoxPrivate))
enum  {
	TWEET_LIST_BOX_DUMMY_PROPERTY,
	TWEET_LIST_BOX_ACTION_ENTRY,
	TWEET_LIST_BOX_SPINNER_SIZE
};
TweetListBox* tweet_list_box_new (gboolean show_placeholder);
TweetListBox* tweet_list_box_construct (GType object_type, gboolean show_placeholder);
static void tweet_list_box_add_placeholder (TweetListBox* self);
static gboolean tweet_list_box_button_press_cb (TweetListBox* self, GdkEventButton* evt);
gboolean tweet_list_entry_get_shows_actions (TweetListEntry* self);
void tweet_list_entry_toggle_mode (TweetListEntry* self);
static void __lambda86_ (TweetListBox* self);
static void ___lambda86__gtk_button_clicked (GtkButton* _sender, gpointer self);
void tweet_list_box_set_empty (TweetListBox* self);
void tweet_list_box_set_unempty (TweetListBox* self);
void tweet_list_box_set_error (TweetListBox* self, const gchar* err_msg);
GtkStack* tweet_list_box_get_placeholder (TweetListBox* self);
void tweet_list_box_set_placeholder_text (TweetListBox* self, const gchar* text);
void tweet_list_box_reset_placeholder_text (TweetListBox* self);
void tweet_list_box_remove_all (TweetListBox* self);
static void __lambda87_ (TweetListBox* self, GtkWidget* w);
static void ___lambda87__gtk_callback (GtkWidget* widget, gpointer self);
void tweet_list_box_add_progress_entry (TweetListBox* self);
void tweet_list_box_remove_progress_entry (TweetListBox* self);
GtkWidget* tweet_list_box_get_first_visible_row (TweetListBox* self);
TweetListEntry* tweet_list_box_get_action_entry (TweetListBox* self);
void tweet_list_box_set_spinner_size (TweetListBox* self, gint value);
static GObject * tweet_list_box_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
ProgressEntry* progress_entry_new (void);
ProgressEntry* progress_entry_construct (GType object_type);
static gboolean _tweet_list_box_button_press_cb_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
GSettings* settings_get (void);
static void tweet_list_box_finalize (GObject* obj);
static void _vala_tweet_list_box_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_tweet_list_box_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


TweetListBox* tweet_list_box_construct (GType object_type, gboolean show_placeholder) {
	TweetListBox * self = NULL;
	gboolean _tmp0_ = FALSE;
	self = (TweetListBox*) g_object_new (object_type, NULL);
	_tmp0_ = show_placeholder;
	if (_tmp0_) {
		tweet_list_box_add_placeholder (self);
	}
	return self;
}


TweetListBox* tweet_list_box_new (gboolean show_placeholder) {
	return tweet_list_box_construct (TYPE_TWEET_LIST_BOX, show_placeholder);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gboolean tweet_list_box_button_press_cb (TweetListBox* self, GdkEventButton* evt) {
	gboolean result = FALSE;
	GdkEventButton* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	g_return_val_if_fail (IS_TWEET_LIST_BOX (self), FALSE);
	g_return_val_if_fail (evt != NULL, FALSE);
	_tmp0_ = evt;
	_tmp1_ = gdk_event_triggers_context_menu ((GdkEvent*) _tmp0_);
	if (_tmp1_) {
		GdkWindow* event_window = NULL;
		GdkEventButton* _tmp2_ = NULL;
		GdkWindow* _tmp3_ = NULL;
		GdkWindow* _tmp4_ = NULL;
		GdkWindow* window = NULL;
		GdkWindow* _tmp5_ = NULL;
		GdkWindow* _tmp6_ = NULL;
		gdouble relative_y = 0.0;
		GdkEventButton* _tmp7_ = NULL;
		gdouble _tmp8_ = 0.0;
		gdouble parent_y = 0.0;
		GtkWidget* row = NULL;
		gdouble _tmp20_ = 0.0;
		GtkListBoxRow* _tmp21_ = NULL;
		GtkWidget* _tmp22_ = NULL;
		gboolean _tmp23_ = FALSE;
		GtkWidget* _tmp24_ = NULL;
		_tmp2_ = evt;
		_tmp3_ = _tmp2_->window;
		_tmp4_ = _g_object_ref0 (_tmp3_);
		event_window = _tmp4_;
		_tmp5_ = gtk_widget_get_window (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
		_tmp6_ = _g_object_ref0 (_tmp5_);
		window = _tmp6_;
		_tmp7_ = evt;
		_tmp8_ = _tmp7_->y;
		relative_y = _tmp8_;
		while (TRUE) {
			gboolean _tmp9_ = FALSE;
			GdkWindow* _tmp10_ = NULL;
			GdkWindow* _tmp13_ = NULL;
			gdouble _tmp14_ = 0.0;
			gdouble _tmp15_ = 0.0;
			gdouble _tmp16_ = 0.0;
			GdkWindow* _tmp17_ = NULL;
			GdkWindow* _tmp18_ = NULL;
			GdkWindow* _tmp19_ = NULL;
			_tmp10_ = event_window;
			if (_tmp10_ != NULL) {
				GdkWindow* _tmp11_ = NULL;
				GdkWindow* _tmp12_ = NULL;
				_tmp11_ = event_window;
				_tmp12_ = window;
				_tmp9_ = _tmp11_ != _tmp12_;
			} else {
				_tmp9_ = FALSE;
			}
			if (!_tmp9_) {
				break;
			}
			_tmp13_ = event_window;
			_tmp14_ = relative_y;
			gdk_window_coords_to_parent (_tmp13_, (gdouble) 0, _tmp14_, NULL, &_tmp15_);
			parent_y = _tmp15_;
			_tmp16_ = parent_y;
			relative_y = _tmp16_;
			_tmp17_ = event_window;
			_tmp18_ = gdk_window_get_effective_parent (_tmp17_);
			_tmp19_ = _g_object_ref0 (_tmp18_);
			_g_object_unref0 (event_window);
			event_window = _tmp19_;
		}
		_tmp20_ = relative_y;
		_tmp21_ = gtk_list_box_get_row_at_y (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_list_box_get_type (), GtkListBox), (gint) _tmp20_);
		_tmp22_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, gtk_widget_get_type (), GtkWidget));
		row = _tmp22_;
		_tmp24_ = row;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp24_, TYPE_TWEET_LIST_ENTRY)) {
			GtkWidget* _tmp25_ = NULL;
			gboolean _tmp26_ = FALSE;
			gboolean _tmp27_ = FALSE;
			_tmp25_ = row;
			_tmp26_ = gtk_widget_get_sensitive (_tmp25_);
			_tmp27_ = _tmp26_;
			_tmp23_ = _tmp27_;
		} else {
			_tmp23_ = FALSE;
		}
		if (_tmp23_) {
			TweetListEntry* tle = NULL;
			GtkWidget* _tmp28_ = NULL;
			TweetListEntry* _tmp29_ = NULL;
			gboolean _tmp30_ = FALSE;
			gboolean _tmp31_ = FALSE;
			TweetListEntry* _tmp32_ = NULL;
			TweetListEntry* _tmp33_ = NULL;
			TweetListEntry* _tmp39_ = NULL;
			TweetListEntry* _tmp40_ = NULL;
			gboolean _tmp41_ = FALSE;
			gboolean _tmp42_ = FALSE;
			_tmp28_ = row;
			_tmp29_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, TYPE_TWEET_LIST_ENTRY, TweetListEntry));
			tle = _tmp29_;
			_tmp32_ = tle;
			_tmp33_ = self->priv->_action_entry;
			if (_tmp32_ != _tmp33_) {
				TweetListEntry* _tmp34_ = NULL;
				_tmp34_ = self->priv->_action_entry;
				_tmp31_ = _tmp34_ != NULL;
			} else {
				_tmp31_ = FALSE;
			}
			if (_tmp31_) {
				TweetListEntry* _tmp35_ = NULL;
				gboolean _tmp36_ = FALSE;
				gboolean _tmp37_ = FALSE;
				_tmp35_ = self->priv->_action_entry;
				_tmp36_ = tweet_list_entry_get_shows_actions (_tmp35_);
				_tmp37_ = _tmp36_;
				_tmp30_ = _tmp37_;
			} else {
				_tmp30_ = FALSE;
			}
			if (_tmp30_) {
				TweetListEntry* _tmp38_ = NULL;
				_tmp38_ = self->priv->_action_entry;
				tweet_list_entry_toggle_mode (_tmp38_);
			}
			_tmp39_ = tle;
			tweet_list_entry_toggle_mode (_tmp39_);
			_tmp40_ = tle;
			_tmp41_ = tweet_list_entry_get_shows_actions (_tmp40_);
			_tmp42_ = _tmp41_;
			if (_tmp42_) {
				TweetListEntry* _tmp43_ = NULL;
				TweetListEntry* _tmp44_ = NULL;
				_tmp43_ = tle;
				_tmp44_ = _g_object_ref0 (_tmp43_);
				_g_object_unref0 (self->priv->_action_entry);
				self->priv->_action_entry = _tmp44_;
			} else {
				_g_object_unref0 (self->priv->_action_entry);
				self->priv->_action_entry = NULL;
			}
			result = TRUE;
			_g_object_unref0 (tle);
			_g_object_unref0 (row);
			_g_object_unref0 (window);
			_g_object_unref0 (event_window);
			return result;
		}
		_g_object_unref0 (row);
		_g_object_unref0 (window);
		_g_object_unref0 (event_window);
	}
	result = FALSE;
	return result;
}


static void __lambda86_ (TweetListBox* self) {
	GtkStack* _tmp0_ = NULL;
	_tmp0_ = self->priv->placeholder;
	gtk_stack_set_visible_child_name (_tmp0_, "spinner");
	g_signal_emit_by_name (self, "retry-button-clicked");
}


static void ___lambda86__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	__lambda86_ ((TweetListBox*) self);
}


static void tweet_list_box_add_placeholder (TweetListBox* self) {
	GtkStack* _tmp0_ = NULL;
	GtkStack* _tmp1_ = NULL;
	GtkSpinner* _tmp2_ = NULL;
	GtkSpinner* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	GtkSpinner* _tmp6_ = NULL;
	GtkSpinner* _tmp7_ = NULL;
	GtkSpinner* _tmp8_ = NULL;
	GtkSpinner* _tmp9_ = NULL;
	GtkStack* _tmp10_ = NULL;
	GtkSpinner* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	GtkLabel* _tmp13_ = NULL;
	GtkLabel* _tmp14_ = NULL;
	GtkStyleContext* _tmp15_ = NULL;
	GtkLabel* _tmp16_ = NULL;
	GtkStack* _tmp17_ = NULL;
	GtkLabel* _tmp18_ = NULL;
	GtkBox* _tmp19_ = NULL;
	GtkLabel* _tmp20_ = NULL;
	GtkLabel* _tmp21_ = NULL;
	GtkStyleContext* _tmp22_ = NULL;
	const gchar* _tmp23_ = NULL;
	GtkButton* _tmp24_ = NULL;
	GtkButton* _tmp25_ = NULL;
	GtkButton* _tmp26_ = NULL;
	GtkBox* _tmp27_ = NULL;
	GtkLabel* _tmp28_ = NULL;
	GtkBox* _tmp29_ = NULL;
	GtkButton* _tmp30_ = NULL;
	GtkStack* _tmp31_ = NULL;
	GtkBox* _tmp32_ = NULL;
	GtkStack* _tmp33_ = NULL;
	GtkStack* _tmp34_ = NULL;
	GtkStack* _tmp35_ = NULL;
	GtkStack* _tmp36_ = NULL;
	GtkStack* _tmp37_ = NULL;
	g_return_if_fail (IS_TWEET_LIST_BOX (self));
	_tmp0_ = (GtkStack*) gtk_stack_new ();
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->placeholder);
	self->priv->placeholder = _tmp0_;
	_tmp1_ = self->priv->placeholder;
	gtk_stack_set_transition_type (_tmp1_, GTK_STACK_TRANSITION_TYPE_CROSSFADE);
	_tmp2_ = (GtkSpinner*) gtk_spinner_new ();
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->spinner);
	self->priv->spinner = _tmp2_;
	_tmp3_ = self->priv->spinner;
	_tmp4_ = self->priv->_spinner_size;
	_tmp5_ = self->priv->_spinner_size;
	gtk_widget_set_size_request (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_widget_get_type (), GtkWidget), _tmp4_, _tmp5_);
	_tmp6_ = self->priv->spinner;
	gtk_widget_set_valign (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_widget_get_type (), GtkWidget), GTK_ALIGN_CENTER);
	_tmp7_ = self->priv->spinner;
	gtk_widget_set_halign (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_widget_get_type (), GtkWidget), GTK_ALIGN_CENTER);
	_tmp8_ = self->priv->spinner;
	gtk_spinner_start (_tmp8_);
	_tmp9_ = self->priv->spinner;
	gtk_widget_show_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_widget_get_type (), GtkWidget));
	_tmp10_ = self->priv->placeholder;
	_tmp11_ = self->priv->spinner;
	gtk_stack_add_named (_tmp10_, G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, gtk_widget_get_type (), GtkWidget), "spinner");
	_tmp12_ = _ ("No entries found");
	_tmp13_ = (GtkLabel*) gtk_label_new (_tmp12_);
	g_object_ref_sink (_tmp13_);
	_g_object_unref0 (self->priv->no_entries_label);
	self->priv->no_entries_label = _tmp13_;
	_tmp14_ = self->priv->no_entries_label;
	_tmp15_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, gtk_widget_get_type (), GtkWidget));
	gtk_style_context_add_class (_tmp15_, "dim-label");
	_tmp16_ = self->priv->no_entries_label;
	g_object_set (_tmp16_, "wrap-mode", PANGO_WRAP_WORD_CHAR, NULL);
	_tmp17_ = self->priv->placeholder;
	_tmp18_ = self->priv->no_entries_label;
	gtk_stack_add_named (_tmp17_, G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, gtk_widget_get_type (), GtkWidget), "no-entries");
	_tmp19_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 12);
	g_object_ref_sink (_tmp19_);
	_g_object_unref0 (self->priv->error_box);
	self->priv->error_box = _tmp19_;
	_tmp20_ = (GtkLabel*) gtk_label_new ("");
	g_object_ref_sink (_tmp20_);
	_g_object_unref0 (self->priv->error_label);
	self->priv->error_label = _tmp20_;
	_tmp21_ = self->priv->error_label;
	_tmp22_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, gtk_widget_get_type (), GtkWidget));
	gtk_style_context_add_class (_tmp22_, "dim-label");
	_tmp23_ = _ ("Retry");
	_tmp24_ = (GtkButton*) gtk_button_new_with_label (_tmp23_);
	g_object_ref_sink (_tmp24_);
	_g_object_unref0 (self->priv->retry_button);
	self->priv->retry_button = _tmp24_;
	_tmp25_ = self->priv->retry_button;
	gtk_widget_set_halign (G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, gtk_widget_get_type (), GtkWidget), GTK_ALIGN_CENTER);
	_tmp26_ = self->priv->retry_button;
	g_signal_connect_object (_tmp26_, "clicked", (GCallback) ___lambda86__gtk_button_clicked, self, 0);
	_tmp27_ = self->priv->error_box;
	_tmp28_ = self->priv->error_label;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, gtk_widget_get_type (), GtkWidget));
	_tmp29_ = self->priv->error_box;
	_tmp30_ = self->priv->retry_button;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, gtk_widget_get_type (), GtkWidget));
	_tmp31_ = self->priv->placeholder;
	_tmp32_ = self->priv->error_box;
	gtk_stack_add_named (_tmp31_, G_TYPE_CHECK_INSTANCE_CAST (_tmp32_, gtk_widget_get_type (), GtkWidget), "error");
	_tmp33_ = self->priv->placeholder;
	gtk_stack_set_visible_child_name (_tmp33_, "spinner");
	_tmp34_ = self->priv->placeholder;
	gtk_widget_show_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp34_, gtk_widget_get_type (), GtkWidget));
	_tmp35_ = self->priv->placeholder;
	gtk_widget_set_valign (G_TYPE_CHECK_INSTANCE_CAST (_tmp35_, gtk_widget_get_type (), GtkWidget), GTK_ALIGN_CENTER);
	_tmp36_ = self->priv->placeholder;
	gtk_widget_set_halign (G_TYPE_CHECK_INSTANCE_CAST (_tmp36_, gtk_widget_get_type (), GtkWidget), GTK_ALIGN_CENTER);
	_tmp37_ = self->priv->placeholder;
	gtk_list_box_set_placeholder (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_list_box_get_type (), GtkListBox), G_TYPE_CHECK_INSTANCE_CAST (_tmp37_, gtk_widget_get_type (), GtkWidget));
}


void tweet_list_box_set_empty (TweetListBox* self) {
	GtkStack* _tmp0_ = NULL;
	g_return_if_fail (IS_TWEET_LIST_BOX (self));
	_tmp0_ = self->priv->placeholder;
	gtk_stack_set_visible_child_name (_tmp0_, "no-entries");
}


void tweet_list_box_set_unempty (TweetListBox* self) {
	GtkStack* _tmp0_ = NULL;
	g_return_if_fail (IS_TWEET_LIST_BOX (self));
	_tmp0_ = self->priv->placeholder;
	gtk_stack_set_visible_child_name (_tmp0_, "spinner");
}


void tweet_list_box_set_error (TweetListBox* self, const gchar* err_msg) {
	GtkLabel* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GtkStack* _tmp2_ = NULL;
	g_return_if_fail (IS_TWEET_LIST_BOX (self));
	g_return_if_fail (err_msg != NULL);
	_tmp0_ = self->priv->error_label;
	_tmp1_ = err_msg;
	gtk_label_set_label (_tmp0_, _tmp1_);
	_tmp2_ = self->priv->placeholder;
	gtk_stack_set_visible_child_name (_tmp2_, "error");
}


GtkStack* tweet_list_box_get_placeholder (TweetListBox* self) {
	GtkStack* result = NULL;
	GtkStack* _tmp0_ = NULL;
	GtkStack* _tmp1_ = NULL;
	g_return_val_if_fail (IS_TWEET_LIST_BOX (self), NULL);
	_tmp0_ = self->priv->placeholder;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


void tweet_list_box_set_placeholder_text (TweetListBox* self, const gchar* text) {
	GtkLabel* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_if_fail (IS_TWEET_LIST_BOX (self));
	g_return_if_fail (text != NULL);
	_tmp0_ = self->priv->no_entries_label;
	_tmp1_ = text;
	gtk_label_set_label (_tmp0_, _tmp1_);
}


void tweet_list_box_reset_placeholder_text (TweetListBox* self) {
	GtkLabel* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_if_fail (IS_TWEET_LIST_BOX (self));
	_tmp0_ = self->priv->no_entries_label;
	_tmp1_ = _ ("No entries found");
	gtk_label_set_label (_tmp0_, _tmp1_);
}


static void __lambda87_ (TweetListBox* self, GtkWidget* w) {
	GtkWidget* _tmp0_ = NULL;
	g_return_if_fail (GTK_IS_WIDGET (w));
	_tmp0_ = w;
	gtk_container_remove (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_container_get_type (), GtkContainer), _tmp0_);
}


static void ___lambda87__gtk_callback (GtkWidget* widget, gpointer self) {
	__lambda87_ ((TweetListBox*) self, widget);
}


void tweet_list_box_remove_all (TweetListBox* self) {
	g_return_if_fail (IS_TWEET_LIST_BOX (self));
	gtk_container_foreach (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_container_get_type (), GtkContainer), ___lambda87__gtk_callback, self);
}


void tweet_list_box_add_progress_entry (TweetListBox* self) {
	ProgressEntry* _tmp0_ = NULL;
	GtkContainer* _tmp1_ = NULL;
	GtkContainer* _tmp2_ = NULL;
	g_return_if_fail (IS_TWEET_LIST_BOX (self));
	_tmp0_ = self->priv->progress_entry;
	_tmp1_ = gtk_widget_get_parent (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_widget_get_type (), GtkWidget));
	_tmp2_ = _tmp1_;
	if (_tmp2_ == NULL) {
		ProgressEntry* _tmp3_ = NULL;
		ProgressEntry* _tmp4_ = NULL;
		_tmp3_ = self->priv->progress_entry;
		gtk_widget_show_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_widget_get_type (), GtkWidget));
		_tmp4_ = self->priv->progress_entry;
		gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_widget_get_type (), GtkWidget));
	}
}


void tweet_list_box_remove_progress_entry (TweetListBox* self) {
	ProgressEntry* _tmp0_ = NULL;
	GtkContainer* _tmp1_ = NULL;
	GtkContainer* _tmp2_ = NULL;
	g_return_if_fail (IS_TWEET_LIST_BOX (self));
	_tmp0_ = self->priv->progress_entry;
	_tmp1_ = gtk_widget_get_parent (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_widget_get_type (), GtkWidget));
	_tmp2_ = _tmp1_;
	if (_tmp2_ != NULL) {
		ProgressEntry* _tmp3_ = NULL;
		_tmp3_ = self->priv->progress_entry;
		gtk_container_remove (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_widget_get_type (), GtkWidget));
	}
}


GtkWidget* tweet_list_box_get_first_visible_row (TweetListBox* self) {
	GtkWidget* result = NULL;
	GtkListBoxRow* _tmp0_ = NULL;
	GtkWidget* _tmp1_ = NULL;
	g_return_val_if_fail (IS_TWEET_LIST_BOX (self), NULL);
	_tmp0_ = gtk_list_box_get_row_at_y (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_list_box_get_type (), GtkListBox), 1);
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_widget_get_type (), GtkWidget));
	result = _tmp1_;
	return result;
}


TweetListEntry* tweet_list_box_get_action_entry (TweetListBox* self) {
	TweetListEntry* result;
	TweetListEntry* _tmp0_ = NULL;
	g_return_val_if_fail (IS_TWEET_LIST_BOX (self), NULL);
	_tmp0_ = self->priv->_action_entry;
	result = _tmp0_;
	return result;
}


void tweet_list_box_set_spinner_size (TweetListBox* self, gint value) {
	gint _tmp0_ = 0;
	GtkSpinner* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	g_return_if_fail (IS_TWEET_LIST_BOX (self));
	_tmp0_ = value;
	self->priv->_spinner_size = _tmp0_;
	_tmp1_ = self->priv->spinner;
	_tmp2_ = value;
	_tmp3_ = value;
	gtk_widget_set_size_request (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_widget_get_type (), GtkWidget), _tmp2_, _tmp3_);
	g_object_notify ((GObject *) self, "spinner-size");
}


static gboolean _tweet_list_box_button_press_cb_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = tweet_list_box_button_press_cb ((TweetListBox*) self, event);
	return result;
}


static GObject * tweet_list_box_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	TweetListBox * self;
	ProgressEntry* _tmp0_ = NULL;
	GtkStyleContext* _tmp1_ = NULL;
	GSettings* _tmp2_ = NULL;
	GSettings* _tmp3_ = NULL;
	parent_class = G_OBJECT_CLASS (tweet_list_box_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_TWEET_LIST_BOX, TweetListBox);
	tweet_list_box_add_placeholder (self);
	_tmp0_ = progress_entry_new ();
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->progress_entry);
	self->priv->progress_entry = _tmp0_;
	_tmp1_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	gtk_style_context_add_class (_tmp1_, "stream");
	gtk_list_box_set_selection_mode (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_list_box_get_type (), GtkListBox), GTK_SELECTION_NONE);
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), "button-press-event", (GCallback) _tweet_list_box_button_press_cb_gtk_widget_button_press_event, self, 0);
	_tmp2_ = settings_get ();
	_tmp3_ = _tmp2_;
	g_settings_bind (_tmp3_, "double-click-activation", G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject), "activate-on-single-click", G_SETTINGS_BIND_INVERT_BOOLEAN);
	_g_object_unref0 (_tmp3_);
	return obj;
}


static void tweet_list_box_class_init (TweetListBoxClass * klass) {
	tweet_list_box_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (TweetListBoxPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_tweet_list_box_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_tweet_list_box_set_property;
	G_OBJECT_CLASS (klass)->constructor = tweet_list_box_constructor;
	G_OBJECT_CLASS (klass)->finalize = tweet_list_box_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), TWEET_LIST_BOX_ACTION_ENTRY, g_param_spec_object ("action-entry", "action-entry", "action-entry", TYPE_TWEET_LIST_ENTRY, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TWEET_LIST_BOX_SPINNER_SIZE, g_param_spec_int ("spinner-size", "spinner-size", "spinner-size", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE));
	g_signal_new ("retry_button_clicked", TYPE_TWEET_LIST_BOX, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void tweet_list_box_instance_init (TweetListBox * self) {
	self->priv = TWEET_LIST_BOX_GET_PRIVATE (self);
	self->priv->_spinner_size = 32;
}


static void tweet_list_box_finalize (GObject* obj) {
	TweetListBox * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_TWEET_LIST_BOX, TweetListBox);
	_g_object_unref0 (self->priv->placeholder);
	_g_object_unref0 (self->priv->no_entries_label);
	_g_object_unref0 (self->priv->progress_entry);
	_g_object_unref0 (self->priv->error_box);
	_g_object_unref0 (self->priv->error_label);
	_g_object_unref0 (self->priv->retry_button);
	_g_object_unref0 (self->priv->_action_entry);
	_g_object_unref0 (self->priv->spinner);
	G_OBJECT_CLASS (tweet_list_box_parent_class)->finalize (obj);
}


GType tweet_list_box_get_type (void) {
	static volatile gsize tweet_list_box_type_id__volatile = 0;
	if (g_once_init_enter (&tweet_list_box_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TweetListBoxClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tweet_list_box_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TweetListBox), 0, (GInstanceInitFunc) tweet_list_box_instance_init, NULL };
		GType tweet_list_box_type_id;
		tweet_list_box_type_id = g_type_register_static (gtk_list_box_get_type (), "TweetListBox", &g_define_type_info, 0);
		g_once_init_leave (&tweet_list_box_type_id__volatile, tweet_list_box_type_id);
	}
	return tweet_list_box_type_id__volatile;
}


static void _vala_tweet_list_box_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	TweetListBox * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_TWEET_LIST_BOX, TweetListBox);
	switch (property_id) {
		case TWEET_LIST_BOX_ACTION_ENTRY:
		g_value_set_object (value, tweet_list_box_get_action_entry (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_tweet_list_box_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	TweetListBox * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_TWEET_LIST_BOX, TweetListBox);
	switch (property_id) {
		case TWEET_LIST_BOX_SPINNER_SIZE:
		tweet_list_box_set_spinner_size (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



