/* TweetUtils.c generated by valac 0.26.2, the Vala compiler
 * generated from TweetUtils.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <rest/rest-proxy-call.h>
#include <rest/oauth-proxy.h>
#include <rest/rest-proxy.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <json-glib/json-glib.h>
#include <libsoup/soup.h>
#include <gtk/gtk.h>


#define TWEET_UTILS_TYPE_SEQUENCE (tweet_utils_sequence_get_type ())
typedef struct _TweetUtilsSequence TweetUtilsSequence;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_ACCOUNT (account_get_type ())
#define ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ACCOUNT, Account))
#define ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ACCOUNT, AccountClass))
#define IS_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ACCOUNT))
#define IS_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ACCOUNT))
#define ACCOUNT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ACCOUNT, AccountClass))

typedef struct _Account Account;
typedef struct _AccountClass AccountClass;

#define TYPE_TWEET (tweet_get_type ())
#define TWEET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWEET, Tweet))
#define TWEET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWEET, TweetClass))
#define IS_TWEET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWEET))
#define IS_TWEET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWEET))
#define TWEET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWEET, TweetClass))

typedef struct _Tweet Tweet;
typedef struct _TweetClass TweetClass;
typedef struct _Block49Data Block49Data;
typedef struct _TweetPrivate TweetPrivate;

#define TYPE_MEDIA (media_get_type ())
#define MEDIA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA, Media))
#define MEDIA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA, MediaClass))
#define IS_MEDIA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA))
#define IS_MEDIA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA))
#define MEDIA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA, MediaClass))

typedef struct _Media Media;
typedef struct _MediaClass MediaClass;
typedef struct _TweetUtilsDeleteTweetData TweetUtilsDeleteTweetData;
typedef struct _Block50Data Block50Data;
typedef struct _TweetUtilsReplyToTweetData TweetUtilsReplyToTweetData;
typedef struct _Block51Data Block51Data;
typedef struct _TweetUtilsToggleFavoriteTweetData TweetUtilsToggleFavoriteTweetData;
typedef struct _Block52Data Block52Data;
typedef struct _TweetUtilsToggleRetweetTweetData TweetUtilsToggleRetweetTweetData;
typedef struct _Block53Data Block53Data;
typedef struct _TweetUtilsDownloadAvatarData TweetUtilsDownloadAvatarData;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;

#define TYPE_BUNDLE (bundle_get_type ())
#define BUNDLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUNDLE, Bundle))
#define BUNDLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUNDLE, BundleClass))
#define IS_BUNDLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUNDLE))
#define IS_BUNDLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUNDLE))
#define BUNDLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUNDLE, BundleClass))

typedef struct _Bundle Bundle;
typedef struct _BundleClass BundleClass;
typedef struct _MainWindowPrivate MainWindowPrivate;

#define TYPE_MAIN_WIDGET (main_widget_get_type ())
#define MAIN_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WIDGET, MainWidget))
#define MAIN_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WIDGET, MainWidgetClass))
#define IS_MAIN_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WIDGET))
#define IS_MAIN_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WIDGET))
#define MAIN_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WIDGET, MainWidgetClass))

typedef struct _MainWidget MainWidget;
typedef struct _MainWidgetClass MainWidgetClass;

#define TYPE_PAGE (page_get_type ())

#define TWEET_UTILS_TYPE_WORKER_RESULT (tweet_utils_worker_result_get_type ())
typedef struct _TweetUtilsWorkerResult TweetUtilsWorkerResult;

#define TYPE_DELTA_UPDATER (delta_updater_get_type ())
#define DELTA_UPDATER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DELTA_UPDATER, DeltaUpdater))
#define DELTA_UPDATER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DELTA_UPDATER, DeltaUpdaterClass))
#define IS_DELTA_UPDATER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DELTA_UPDATER))
#define IS_DELTA_UPDATER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DELTA_UPDATER))
#define DELTA_UPDATER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DELTA_UPDATER, DeltaUpdaterClass))

typedef struct _DeltaUpdater DeltaUpdater;
typedef struct _DeltaUpdaterClass DeltaUpdaterClass;

#define TYPE_TWEET_LIST_BOX (tweet_list_box_get_type ())
#define TWEET_LIST_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWEET_LIST_BOX, TweetListBox))
#define TWEET_LIST_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWEET_LIST_BOX, TweetListBoxClass))
#define IS_TWEET_LIST_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWEET_LIST_BOX))
#define IS_TWEET_LIST_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWEET_LIST_BOX))
#define TWEET_LIST_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWEET_LIST_BOX, TweetListBoxClass))

typedef struct _TweetListBox TweetListBox;
typedef struct _TweetListBoxClass TweetListBoxClass;
#define _json_array_unref0(var) ((var == NULL) ? NULL : (var = (json_array_unref (var), NULL)))
typedef struct _Block54Data Block54Data;
typedef struct _Block55Data Block55Data;
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))

#define TYPE_TWEET_LIST_ENTRY (tweet_list_entry_get_type ())
#define TWEET_LIST_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWEET_LIST_ENTRY, TweetListEntry))
#define TWEET_LIST_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWEET_LIST_ENTRY, TweetListEntryClass))
#define IS_TWEET_LIST_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWEET_LIST_ENTRY))
#define IS_TWEET_LIST_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWEET_LIST_ENTRY))
#define TWEET_LIST_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWEET_LIST_ENTRY, TweetListEntryClass))

typedef struct _TweetListEntry TweetListEntry;
typedef struct _TweetListEntryClass TweetListEntryClass;

#define TYPE_USER_COUNTER (user_counter_get_type ())
#define USER_COUNTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_USER_COUNTER, UserCounter))
#define USER_COUNTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_USER_COUNTER, UserCounterClass))
#define IS_USER_COUNTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_USER_COUNTER))
#define IS_USER_COUNTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_USER_COUNTER))
#define USER_COUNTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_USER_COUNTER, UserCounterClass))

typedef struct _UserCounter UserCounter;
typedef struct _UserCounterClass UserCounterClass;

#define TYPE_ITWITTER_ITEM (itwitter_item_get_type ())
#define ITWITTER_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ITWITTER_ITEM, ITwitterItem))
#define IS_ITWITTER_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ITWITTER_ITEM))
#define ITWITTER_ITEM_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_ITWITTER_ITEM, ITwitterItemIface))

typedef struct _ITwitterItem ITwitterItem;
typedef struct _ITwitterItemIface ITwitterItemIface;
typedef struct _TweetListEntryPrivate TweetListEntryPrivate;
#define _g_thread_unref0(var) ((var == NULL) ? NULL : (var = (g_thread_unref (var), NULL)))
typedef struct _TweetUtilsWorkArrayData TweetUtilsWorkArrayData;

#define TYPE_MEDIA_DIALOG (media_dialog_get_type ())
#define MEDIA_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_DIALOG, MediaDialog))
#define MEDIA_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_DIALOG, MediaDialogClass))
#define IS_MEDIA_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_DIALOG))
#define IS_MEDIA_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_DIALOG))
#define MEDIA_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_DIALOG, MediaDialogClass))

typedef struct _MediaDialog MediaDialog;
typedef struct _MediaDialogClass MediaDialogClass;
#define __vala_JsonNode_free0(var) ((var == NULL) ? NULL : (var = (_vala_JsonNode_free (var), NULL)))
typedef struct _Block56Data Block56Data;
typedef struct _TweetUtilsLoadThreadedData TweetUtilsLoadThreadedData;

struct _TweetUtilsSequence {
	gint start;
	gint end;
	gchar* url;
	gchar* display_url;
	gboolean visual_display_url;
	gchar* title;
};

struct _Block49Data {
	int _ref_count_;
	RestProxyCall* call;
	gpointer _async_data_;
};

struct _Tweet {
	GObject parent_instance;
	TweetPrivate * priv;
	gint64 id;
	gint64 rt_id;
	gchar* text;
	gint64 user_id;
	gchar* user_name;
	gchar* retweeted_by;
	gchar* rt_by_screen_name;
	gint64 rt_by_id;
	gboolean is_retweet;
	GdkPixbuf* inline_media;
	gchar* time_delta;
	gchar* avatar_url;
	gchar* avatar_name;
	gchar* screen_name;
	gint64 created_at;
	gint64 rt_created_at;
	gboolean verified;
	gint64 my_retweet;
	gboolean protected;
	gint64 reply_id;
	Media** medias;
	gint medias_length1;
	gint retweet_count;
	gint favorite_count;
	gchar** mentions;
	gint mentions_length1;
};

struct _TweetClass {
	GObjectClass parent_class;
};

struct _TweetUtilsDeleteTweetData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	Account* account;
	Tweet* tweet;
	Block49Data* _data49_;
	Account* _tmp0_;
	OAuthProxy* _tmp1_;
	OAuthProxy* _tmp2_;
	RestProxyCall* _tmp3_;
	Tweet* _tmp4_;
	gint64 _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	Tweet* _tmp12_;
	gint64 _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
};

struct _Block50Data {
	int _ref_count_;
	gpointer _async_data_;
};

struct _TweetUtilsReplyToTweetData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	Account* account;
	Tweet* tweet;
	gchar* text;
	Block50Data* _data50_;
	RestProxyCall* call;
	Account* _tmp0_;
	OAuthProxy* _tmp1_;
	OAuthProxy* _tmp2_;
	RestProxyCall* _tmp3_;
	Tweet* _tmp4_;
	gint64 _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	const gchar* _tmp8_;
};

struct _Block51Data {
	int _ref_count_;
	RestProxyCall* call;
	Tweet* tweet;
	gboolean unfavorite;
	gpointer _async_data_;
};

struct _TweetUtilsToggleFavoriteTweetData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	Account* account;
	Tweet* tweet;
	gboolean unfavorite;
	Block51Data* _data51_;
	Tweet* _tmp0_;
	gboolean _tmp1_;
	Account* _tmp2_;
	OAuthProxy* _tmp3_;
	OAuthProxy* _tmp4_;
	RestProxyCall* _tmp5_;
	gboolean _tmp6_;
	RestProxyCall* _tmp7_;
	RestProxyCall* _tmp8_;
	RestProxyCall* _tmp9_;
	RestProxyCall* _tmp10_;
	Tweet* _tmp11_;
	gint64 _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	RestProxyCall* _tmp15_;
};

struct _Block52Data {
	int _ref_count_;
	RestProxyCall* call;
	Tweet* tweet;
	gboolean unretweet;
	gpointer _async_data_;
};

struct _TweetUtilsToggleRetweetTweetData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	Account* account;
	Tweet* tweet;
	gboolean unretweet;
	Block52Data* _data52_;
	Tweet* _tmp0_;
	gboolean _tmp1_;
	Account* _tmp2_;
	OAuthProxy* _tmp3_;
	OAuthProxy* _tmp4_;
	RestProxyCall* _tmp5_;
	RestProxyCall* _tmp6_;
	gboolean _tmp7_;
	RestProxyCall* _tmp8_;
	Tweet* _tmp9_;
	gint64 _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	RestProxyCall* _tmp15_;
	Tweet* _tmp16_;
	gint64 _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	RestProxyCall* _tmp22_;
};

struct _Block53Data {
	int _ref_count_;
	gchar* avatar_name;
	GdkPixbuf* avatar;
	GError* err;
	gpointer _async_data_;
};

struct _TweetUtilsDownloadAvatarData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	gchar* avatar_url;
	GdkPixbuf* result;
	Block53Data* _data53_;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	SoupMessage* msg;
	const gchar* _tmp2_;
	SoupMessage* _tmp3_;
	SoupSession* _tmp4_;
	SoupMessage* _tmp5_;
	SoupMessage* _tmp6_;
	GError* _tmp7_;
	GError* _tmp8_;
	GError* _tmp9_;
	GdkPixbuf* _tmp10_;
	GdkPixbuf* _tmp11_;
	GError * _inner_error_;
};

struct _MainWindow {
	GtkApplicationWindow parent_instance;
	MainWindowPrivate * priv;
	GtkButton* back_button;
	GtkToggleButton* compose_tweet_button;
	MainWidget* main_widget;
};

struct _MainWindowClass {
	GtkApplicationWindowClass parent_class;
};

typedef enum  {
	PAGE_STREAM = 0,
	PAGE_MENTIONS,
	PAGE_FAVORITES,
	PAGE_DM_THREADS,
	PAGE_LISTS,
	PAGE_FILTERS,
	PAGE_SEARCH,
	PAGE_PROFILE,
	PAGE_TWEET_INFO,
	PAGE_DM,
	PAGE_LIST_STATUSES,
	PAGE_PREVIOUS = 1024,
	PAGE_NEXT = 2048
} Page;

struct _TweetUtilsWorkerResult {
	gint64 max_id;
	gint64 min_id;
};

struct _Block54Data {
	int _ref_count_;
	gint64 max;
	gint64 min;
	JsonArray* json_array;
	guint requested_tweet_count;
	DeltaUpdater* delta_updater;
	TweetListBox* tweet_list;
	MainWindow* main_window;
	Account* account;
	gpointer _async_data_;
};

struct _Block55Data {
	int _ref_count_;
	Block54Data * _data54_;
	Tweet** tweet_array;
	gint tweet_array_length1;
	gint _tweet_array_size_;
	GDateTime* now;
	gint index;
};

struct _ITwitterItemIface {
	GTypeInterface parent_iface;
	gint (*update_time_delta) (ITwitterItem* self, GDateTime* now);
	gint64 (*get_sort_factor) (ITwitterItem* self);
	gboolean (*get_seen) (ITwitterItem* self);
	void (*set_seen) (ITwitterItem* self, gboolean value);
};

struct _TweetListEntry {
	GtkListBoxRow parent_instance;
	TweetListEntryPrivate * priv;
	gchar* notification_id;
	Tweet* tweet;
};

struct _TweetListEntryClass {
	GtkListBoxRowClass parent_class;
};

struct _TweetUtilsWorkArrayData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	JsonArray* json_array;
	guint requested_tweet_count;
	DeltaUpdater* delta_updater;
	TweetListBox* tweet_list;
	MainWindow* main_window;
	Account* account;
	TweetUtilsWorkerResult result;
	Block54Data* _data54_;
	JsonArray* _tmp0_;
	guint _tmp1_;
	DeltaUpdater* _tmp2_;
	TweetListBox* _tmp3_;
	MainWindow* _tmp4_;
	Account* _tmp5_;
	GThread* _tmp6_;
	GThread* _tmp7_;
	TweetUtilsWorkerResult _tmp8_;
};

struct _Block56Data {
	int _ref_count_;
	JsonNode* _result_;
	GSourceFunc callback;
	gpointer callback_target;
	GDestroyNotify callback_target_destroy_notify;
	RestProxyCall* call;
	gpointer _async_data_;
};

struct _TweetUtilsLoadThreadedData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RestProxyCall* call;
	JsonNode* result;
	Block56Data* _data56_;
	RestProxyCall* _tmp0_;
	RestProxyCall* _tmp1_;
	GError* e;
	GError* _tmp2_;
	const gchar* _tmp3_;
	GThread* _tmp4_;
	GThread* _tmp5_;
	JsonNode* _tmp6_;
	JsonNode* _tmp7_;
	GError * _inner_error_;
};


extern SoupSession* SOUP_SESSION;

GType tweet_utils_sequence_get_type (void) G_GNUC_CONST;
TweetUtilsSequence* tweet_utils_sequence_dup (const TweetUtilsSequence* self);
void tweet_utils_sequence_free (TweetUtilsSequence* self);
void tweet_utils_sequence_copy (const TweetUtilsSequence* self, TweetUtilsSequence* dest);
void tweet_utils_sequence_destroy (TweetUtilsSequence* self);
gchar* tweet_utils_get_formatted_text (const gchar* tweet_text, GSList* urls);
gchar* tweet_utils_get_trimmed_text (const gchar* tweet_text, GSList* urls, gint media_count);
gboolean inline_media_downloader_is_media_candidate (const gchar* url);
gchar* tweet_utils_get_real_text (const gchar* tweet_text, GSList* urls);
static void tweet_utils_delete_tweet_data_free (gpointer _data);
GType account_get_type (void) G_GNUC_CONST;
GType tweet_get_type (void) G_GNUC_CONST;
void tweet_utils_delete_tweet (Account* account, Tweet* tweet, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tweet_utils_delete_tweet_finish (GAsyncResult* _res_);
static gboolean tweet_utils_delete_tweet_co (TweetUtilsDeleteTweetData* _data_);
static Block49Data* block49_data_ref (Block49Data* _data49_);
static void block49_data_unref (void * _userdata_);
OAuthProxy* account_get_proxy (Account* self);
GType media_get_type (void) G_GNUC_CONST;
static void __lambda66_ (Block49Data* _data49_, GObject* obj, GAsyncResult* res);
static void ___lambda66__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void tweet_utils_reply_to_tweet_data_free (gpointer _data);
void tweet_utils_reply_to_tweet (Account* account, Tweet* tweet, const gchar* text, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tweet_utils_reply_to_tweet_finish (GAsyncResult* _res_);
static gboolean tweet_utils_reply_to_tweet_co (TweetUtilsReplyToTweetData* _data_);
static Block50Data* block50_data_ref (Block50Data* _data50_);
static void block50_data_unref (void * _userdata_);
static void __lambda216_ (Block50Data* _data50_);
static void ___lambda216__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void tweet_utils_toggle_favorite_tweet_data_free (gpointer _data);
void tweet_utils_toggle_favorite_tweet (Account* account, Tweet* tweet, gboolean unfavorite, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tweet_utils_toggle_favorite_tweet_finish (GAsyncResult* _res_);
static gboolean tweet_utils_toggle_favorite_tweet_co (TweetUtilsToggleFavoriteTweetData* _data_);
static Block51Data* block51_data_ref (Block51Data* _data51_);
static void block51_data_unref (void * _userdata_);
static void __lambda72_ (Block51Data* _data51_, GObject* obj, GAsyncResult* res);
void utils_show_error_object (const gchar* json_data, const gchar* alternative, gint line, const gchar* file);
void tweet_set_favorited (Tweet* self, gboolean value);
static void ___lambda72__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void tweet_utils_toggle_retweet_tweet_data_free (gpointer _data);
void tweet_utils_toggle_retweet_tweet (Account* account, Tweet* tweet, gboolean unretweet, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tweet_utils_toggle_retweet_tweet_finish (GAsyncResult* _res_);
static gboolean tweet_utils_toggle_retweet_tweet_co (TweetUtilsToggleRetweetTweetData* _data_);
static Block52Data* block52_data_ref (Block52Data* _data52_);
static void block52_data_unref (void * _userdata_);
static void __lambda70_ (Block52Data* _data52_, GObject* obj, GAsyncResult* res);
void tweet_set_retweeted (Tweet* self, gboolean value);
static void ___lambda70__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void tweet_utils_download_avatar_data_free (gpointer _data);
void tweet_utils_download_avatar (const gchar* avatar_url, GAsyncReadyCallback _callback_, gpointer _user_data_);
GdkPixbuf* tweet_utils_download_avatar_finish (GAsyncResult* _res_, GError** error);
static gboolean tweet_utils_download_avatar_co (TweetUtilsDownloadAvatarData* _data_);
static Block53Data* block53_data_ref (Block53Data* _data53_);
static void block53_data_unref (void * _userdata_);
gchar* utils_get_avatar_name (const gchar* path);
static void __lambda26_ (Block53Data* _data53_, SoupSession* s, SoupMessage* _msg);
gchar* dirs_cache (const gchar* path);
static guint8* _vala_array_dup6 (guint8* self, int length);
static void ___lambda26__soup_session_callback (SoupSession* session, SoupMessage* msg, gpointer self);
gint tweet_utils_calc_tweet_length (const gchar* text, gint media_count);
gint tweet_utils_get_word_length (const gchar* s);
gint twitter_get_short_url_length_https (void);
gint twitter_get_short_url_length (void);
GType main_window_get_type (void) G_GNUC_CONST;
gboolean tweet_utils_activate_link (const gchar* uri, MainWindow* window);
GType bundle_get_type (void) G_GNUC_CONST;
Bundle* bundle_new (void);
Bundle* bundle_construct (GType object_type);
void bundle_put_int64 (Bundle* self, const gchar* key, gint64 value);
GType main_widget_get_type (void) G_GNUC_CONST;
void main_widget_switch_page (MainWidget* self, gint page_id, Bundle* args);
GType page_get_type (void) G_GNUC_CONST;
void bundle_put_string (Bundle* self, const gchar* key, const gchar* value);
void bundle_put_int (Bundle* self, const gchar* key, gint value);
#define TWEET_INFO_PAGE_BY_ID 2
GType tweet_utils_worker_result_get_type (void) G_GNUC_CONST;
TweetUtilsWorkerResult* tweet_utils_worker_result_dup (const TweetUtilsWorkerResult* self);
void tweet_utils_worker_result_free (TweetUtilsWorkerResult* self);
static void tweet_utils_work_array_data_free (gpointer _data);
GType delta_updater_get_type (void) G_GNUC_CONST;
GType tweet_list_box_get_type (void) G_GNUC_CONST;
void tweet_utils_work_array (JsonArray* json_array, guint requested_tweet_count, DeltaUpdater* delta_updater, TweetListBox* tweet_list, MainWindow* main_window, Account* account, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tweet_utils_work_array_finish (GAsyncResult* _res_, TweetUtilsWorkerResult* result);
static gboolean tweet_utils_work_array_co (TweetUtilsWorkArrayData* _data_);
static Block54Data* block54_data_ref (Block54Data* _data54_);
static void block54_data_unref (void * _userdata_);
static void* __lambda88_ (Block54Data* _data54_);
static Block55Data* block55_data_ref (Block55Data* _data55_);
static void block55_data_unref (void * _userdata_);
static gboolean ___lambda89_ (Block55Data* _data55_);
void tweet_list_box_remove_progress_entry (TweetListBox* self);
static gboolean ____lambda89__gsource_func (gpointer self);
static void __lambda90_ (Block55Data* _data55_, JsonArray* array, guint index, JsonNode* node);
Tweet* tweet_new (void);
Tweet* tweet_construct (GType object_type);
void tweet_load_from_json (Tweet* self, JsonNode* status_node, GDateTime* now, Account* account);
static void ___lambda90__json_array_foreach (JsonArray* array, guint index_, JsonNode* element_node, gpointer self);
static gboolean __lambda91_ (Block55Data* _data55_);
GType tweet_list_entry_get_type (void) G_GNUC_CONST;
TweetListEntry* tweet_list_entry_new (Tweet* tweet, MainWindow* window, Account* account);
TweetListEntry* tweet_list_entry_construct (GType object_type, Tweet* tweet, MainWindow* window, Account* account);
GType user_counter_get_type (void) G_GNUC_CONST;
UserCounter* account_get_user_counter (Account* self);
void user_counter_user_seen (UserCounter* self, gint64 id, const gchar* screen_name, const gchar* name);
GType itwitter_item_get_type (void) G_GNUC_CONST;
void delta_updater_add (DeltaUpdater* self, ITwitterItem* entry);
gboolean account_filter_matches (Account* self, Tweet* t);
void tweet_list_box_add_progress_entry (TweetListBox* self);
static gboolean ___lambda91__gsource_func (gpointer self);
static gpointer ___lambda88__gthread_func (gpointer self);
void tweet_utils_handle_media_click (Tweet* t, MainWindow* window, gint index);
GType media_dialog_get_type (void) G_GNUC_CONST;
MediaDialog* media_dialog_new (Tweet* tweet, gint start_media_index);
MediaDialog* media_dialog_construct (GType object_type, Tweet* tweet, gint start_media_index);
gboolean tweet_utils_is_link (const gchar* word);
gboolean tweet_utils_is_mention (const gchar* word);
gboolean tweet_utils_is_hashtag (const gchar* word);
void tweet_utils_highlight_link (GtkTextBuffer* buffer, GtkTextIter* word_start, GtkTextIter* word_end);
static GtkTextIter* _gtk_text_iter_dup (GtkTextIter* self);
void tweet_utils_highlight_mention (GtkTextBuffer* buffer, GtkTextIter* word_start, GtkTextIter* word_end);
void tweet_utils_highlight_hashtag (GtkTextBuffer* buffer, GtkTextIter* word_start, GtkTextIter* word_end);
void tweet_utils_annotate_text (GtkTextBuffer* buffer);
static void _vala_JsonNode_free (JsonNode* self);
static void tweet_utils_load_threaded_data_free (gpointer _data);
void tweet_utils_load_threaded (RestProxyCall* call, GAsyncReadyCallback _callback_, gpointer _user_data_);
JsonNode* tweet_utils_load_threaded_finish (GAsyncResult* _res_);
static gboolean tweet_utils_load_threaded_co (TweetUtilsLoadThreadedData* _data_);
static Block56Data* block56_data_ref (Block56Data* _data56_);
static void block56_data_unref (void * _userdata_);
static gboolean _tweet_utils_load_threaded_co_gsource_func (gpointer self);
static void tweet_utils_load_threaded_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void* __lambda16_ (Block56Data* _data56_);
static JsonNode* _vala_JsonNode_copy (JsonNode* self);
static gboolean __lambda17_ (Block56Data* _data56_);
static gboolean ___lambda17__gsource_func (gpointer self);
static gpointer ___lambda16__gthread_func (gpointer self);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

const gchar* TWEET_UTILS_DOMAINS[24] = {".com", ".net", ".org", ".xxx", ".sexy", ".pro", ".biz", ".name", ".info", ".arpa", ".gov", ".aero", ".asia", ".cat", ".coop", ".edu", ".int", ".jobs", ".mil", ".mobi", ".museum", ".post", ".tel", ".travel"};

void tweet_utils_sequence_copy (const TweetUtilsSequence* self, TweetUtilsSequence* dest) {
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	const gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	_tmp0_ = (*self).start;
	(*dest).start = _tmp0_;
	_tmp1_ = (*self).end;
	(*dest).end = _tmp1_;
	_tmp2_ = (*self).url;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 ((*dest).url);
	(*dest).url = _tmp3_;
	_tmp4_ = (*self).display_url;
	_tmp5_ = g_strdup (_tmp4_);
	_g_free0 ((*dest).display_url);
	(*dest).display_url = _tmp5_;
	_tmp6_ = (*self).visual_display_url;
	(*dest).visual_display_url = _tmp6_;
	_tmp7_ = (*self).title;
	_tmp8_ = g_strdup (_tmp7_);
	_g_free0 ((*dest).title);
	(*dest).title = _tmp8_;
}


void tweet_utils_sequence_destroy (TweetUtilsSequence* self) {
	_g_free0 ((*self).url);
	_g_free0 ((*self).display_url);
	_g_free0 ((*self).title);
}


TweetUtilsSequence* tweet_utils_sequence_dup (const TweetUtilsSequence* self) {
	TweetUtilsSequence* dup;
	dup = g_new0 (TweetUtilsSequence, 1);
	tweet_utils_sequence_copy (self, dup);
	return dup;
}


void tweet_utils_sequence_free (TweetUtilsSequence* self) {
	tweet_utils_sequence_destroy (self);
	g_free (self);
}


GType tweet_utils_sequence_get_type (void) {
	static volatile gsize tweet_utils_sequence_type_id__volatile = 0;
	if (g_once_init_enter (&tweet_utils_sequence_type_id__volatile)) {
		GType tweet_utils_sequence_type_id;
		tweet_utils_sequence_type_id = g_boxed_type_register_static ("TweetUtilsSequence", (GBoxedCopyFunc) tweet_utils_sequence_dup, (GBoxedFreeFunc) tweet_utils_sequence_free);
		g_once_init_leave (&tweet_utils_sequence_type_id__volatile, tweet_utils_sequence_type_id);
	}
	return tweet_utils_sequence_type_id__volatile;
}


/**
   * Formats the given Tweet, using the given url list to insert
   * links(i.e. <a> tags).
   *
   * @param tweet_text The text to format
   * @param urls The urls to insert
   *
   * @return The formatted text
   */
static gint string_index_of_nth_char (const gchar* self, glong c) {
	gint result = 0;
	glong _tmp0_ = 0L;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = c;
	_tmp1_ = g_utf8_offset_to_pointer (self, _tmp0_);
	result = (gint) (_tmp1_ - ((gchar*) self));
	return result;
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	{
		GRegex* regex = NULL;
		const gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		GRegex* _tmp3_ = NULL;
		GRegex* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		GRegex* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		_tmp0_ = old;
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		regex = _tmp4_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch61_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp6_ = regex;
		_tmp7_ = replacement;
		_tmp8_ = g_regex_replace_literal (_tmp6_, self, (gssize) (-1), 0, _tmp7_, 0, &_inner_error_);
		_tmp5_ = _tmp8_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch61_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp9_ = _tmp5_;
		_tmp5_ = NULL;
		result = _tmp9_;
		_g_free0 (_tmp5_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally61;
	__catch61_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally61:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static gchar* string_splice (const gchar* self, glong start, glong end, const gchar* str) {
	gchar* result = NULL;
	glong string_length = 0L;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	glong _tmp2_ = 0L;
	glong _tmp5_ = 0L;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_ = 0L;
	gboolean _tmp12_ = FALSE;
	glong _tmp13_ = 0L;
	glong _tmp16_ = 0L;
	glong _tmp17_ = 0L;
	gsize str_size = 0UL;
	const gchar* _tmp18_ = NULL;
	const gchar* _result_ = NULL;
	gint _tmp22_ = 0;
	gint _tmp23_ = 0;
	glong _tmp24_ = 0L;
	glong _tmp25_ = 0L;
	gsize _tmp26_ = 0UL;
	void* _tmp27_ = NULL;
	gchar* dest = NULL;
	const gchar* _tmp28_ = NULL;
	gchar* _tmp29_ = NULL;
	glong _tmp30_ = 0L;
	gchar* _tmp31_ = NULL;
	glong _tmp32_ = 0L;
	gchar* _tmp33_ = NULL;
	const gchar* _tmp34_ = NULL;
	gsize _tmp35_ = 0UL;
	gchar* _tmp36_ = NULL;
	gsize _tmp37_ = 0UL;
	gchar* _tmp38_ = NULL;
	glong _tmp39_ = 0L;
	glong _tmp40_ = 0L;
	glong _tmp41_ = 0L;
	const gchar* _tmp42_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	_tmp2_ = start;
	if (_tmp2_ < ((glong) 0)) {
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		_tmp3_ = string_length;
		_tmp4_ = start;
		start = _tmp3_ + _tmp4_;
	}
	_tmp5_ = end;
	if (_tmp5_ < ((glong) 0)) {
		glong _tmp6_ = 0L;
		glong _tmp7_ = 0L;
		_tmp6_ = string_length;
		_tmp7_ = end;
		end = _tmp6_ + _tmp7_;
	}
	_tmp9_ = start;
	if (_tmp9_ >= ((glong) 0)) {
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		_tmp10_ = start;
		_tmp11_ = string_length;
		_tmp8_ = _tmp10_ <= _tmp11_;
	} else {
		_tmp8_ = FALSE;
	}
	g_return_val_if_fail (_tmp8_, NULL);
	_tmp13_ = end;
	if (_tmp13_ >= ((glong) 0)) {
		glong _tmp14_ = 0L;
		glong _tmp15_ = 0L;
		_tmp14_ = end;
		_tmp15_ = string_length;
		_tmp12_ = _tmp14_ <= _tmp15_;
	} else {
		_tmp12_ = FALSE;
	}
	g_return_val_if_fail (_tmp12_, NULL);
	_tmp16_ = start;
	_tmp17_ = end;
	g_return_val_if_fail (_tmp16_ <= _tmp17_, NULL);
	_tmp18_ = str;
	if (_tmp18_ == NULL) {
		str_size = (gsize) 0;
	} else {
		const gchar* _tmp19_ = NULL;
		gint _tmp20_ = 0;
		gint _tmp21_ = 0;
		_tmp19_ = str;
		_tmp20_ = strlen ((const gchar*) _tmp19_);
		_tmp21_ = _tmp20_;
		str_size = (gsize) _tmp21_;
	}
	_tmp22_ = strlen (self);
	_tmp23_ = _tmp22_;
	_tmp24_ = end;
	_tmp25_ = start;
	_tmp26_ = str_size;
	_tmp27_ = g_malloc0 (((_tmp23_ - (_tmp24_ - _tmp25_)) + _tmp26_) + 1);
	_result_ = _tmp27_;
	_tmp28_ = _result_;
	dest = (gchar*) _tmp28_;
	_tmp29_ = dest;
	_tmp30_ = start;
	memcpy (_tmp29_, self, (gsize) _tmp30_);
	_tmp31_ = dest;
	_tmp32_ = start;
	dest = _tmp31_ + _tmp32_;
	_tmp33_ = dest;
	_tmp34_ = str;
	_tmp35_ = str_size;
	memcpy (_tmp33_, _tmp34_, _tmp35_);
	_tmp36_ = dest;
	_tmp37_ = str_size;
	dest = _tmp36_ + _tmp37_;
	_tmp38_ = dest;
	_tmp39_ = end;
	_tmp40_ = string_length;
	_tmp41_ = end;
	memcpy (_tmp38_, ((gchar*) self) + _tmp39_, (gsize) (_tmp40_ - _tmp41_));
	_tmp42_ = _result_;
	_result_ = NULL;
	result = (gchar*) _tmp42_;
	return result;
}


gchar* tweet_utils_get_formatted_text (const gchar* tweet_text, GSList* urls) {
	gchar* result = NULL;
	gchar* formatted_text = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gint char_diff = 0;
	GSList* _tmp2_ = NULL;
	g_return_val_if_fail (tweet_text != NULL, NULL);
	_tmp0_ = tweet_text;
	_tmp1_ = g_strdup (_tmp0_);
	formatted_text = _tmp1_;
	char_diff = 0;
	_tmp2_ = urls;
	{
		GSList* s_collection = NULL;
		GSList* s_it = NULL;
		s_collection = _tmp2_;
		for (s_it = s_collection; s_it != NULL; s_it = s_it->next) {
			TweetUtilsSequence _tmp3_ = {0};
			TweetUtilsSequence s = {0};
			tweet_utils_sequence_copy ((TweetUtilsSequence*) s_it->data, &_tmp3_);
			s = _tmp3_;
			{
				gint length_before = 0;
				const gchar* _tmp4_ = NULL;
				gint _tmp5_ = 0;
				gint from = 0;
				const gchar* _tmp6_ = NULL;
				TweetUtilsSequence _tmp7_ = {0};
				gint _tmp8_ = 0;
				gint _tmp9_ = 0;
				gint _tmp10_ = 0;
				gint to = 0;
				const gchar* _tmp11_ = NULL;
				TweetUtilsSequence _tmp12_ = {0};
				gint _tmp13_ = 0;
				gint _tmp14_ = 0;
				gint _tmp15_ = 0;
				gchar* title = NULL;
				TweetUtilsSequence _tmp16_ = {0};
				const gchar* _tmp17_ = NULL;
				const gchar* _tmp24_ = NULL;
				gint _tmp25_ = 0;
				gint _tmp26_ = 0;
				TweetUtilsSequence _tmp27_ = {0};
				const gchar* _tmp28_ = NULL;
				const gchar* _tmp29_ = NULL;
				TweetUtilsSequence _tmp30_ = {0};
				const gchar* _tmp31_ = NULL;
				gchar* _tmp32_ = NULL;
				gchar* _tmp33_ = NULL;
				gchar* _tmp34_ = NULL;
				gchar* _tmp35_ = NULL;
				gchar* _tmp36_ = NULL;
				gint _tmp37_ = 0;
				const gchar* _tmp38_ = NULL;
				gint _tmp39_ = 0;
				gint _tmp40_ = 0;
				_tmp4_ = formatted_text;
				_tmp5_ = g_utf8_strlen (_tmp4_, (gssize) (-1));
				length_before = _tmp5_;
				_tmp6_ = formatted_text;
				_tmp7_ = s;
				_tmp8_ = _tmp7_.start;
				_tmp9_ = char_diff;
				_tmp10_ = string_index_of_nth_char (_tmp6_, (glong) (_tmp8_ + _tmp9_));
				from = _tmp10_;
				_tmp11_ = formatted_text;
				_tmp12_ = s;
				_tmp13_ = _tmp12_.end;
				_tmp14_ = char_diff;
				_tmp15_ = string_index_of_nth_char (_tmp11_, (glong) (_tmp13_ + _tmp14_));
				to = _tmp15_;
				title = NULL;
				_tmp16_ = s;
				_tmp17_ = _tmp16_.title;
				if (_tmp17_ != NULL) {
					TweetUtilsSequence _tmp18_ = {0};
					const gchar* _tmp19_ = NULL;
					gchar* _tmp20_ = NULL;
					_tmp18_ = s;
					_tmp19_ = _tmp18_.title;
					_tmp20_ = string_replace (_tmp19_, "&", "&amp;amp;");
					_g_free0 (title);
					title = _tmp20_;
				} else {
					TweetUtilsSequence _tmp21_ = {0};
					const gchar* _tmp22_ = NULL;
					gchar* _tmp23_ = NULL;
					_tmp21_ = s;
					_tmp22_ = _tmp21_.url;
					_tmp23_ = string_replace (_tmp22_, "&", "&amp;");
					_g_free0 (title);
					title = _tmp23_;
				}
				_tmp24_ = formatted_text;
				_tmp25_ = from;
				_tmp26_ = to;
				_tmp27_ = s;
				_tmp28_ = _tmp27_.url;
				_tmp29_ = title;
				_tmp30_ = s;
				_tmp31_ = _tmp30_.display_url;
				_tmp32_ = string_replace (_tmp31_, "&", "&amp;");
				_tmp33_ = _tmp32_;
				_tmp34_ = g_strdup_printf ("<span underline='none'><a href=\"%s\" title=\"%s\">%s</a></span>", _tmp28_, _tmp29_, _tmp33_);
				_tmp35_ = _tmp34_;
				_tmp36_ = string_splice (_tmp24_, (glong) _tmp25_, (glong) _tmp26_, _tmp35_);
				_g_free0 (formatted_text);
				formatted_text = _tmp36_;
				_g_free0 (_tmp35_);
				_g_free0 (_tmp33_);
				_tmp37_ = char_diff;
				_tmp38_ = formatted_text;
				_tmp39_ = g_utf8_strlen (_tmp38_, (gssize) (-1));
				_tmp40_ = length_before;
				char_diff = _tmp37_ + (_tmp39_ - _tmp40_);
				_g_free0 (title);
				tweet_utils_sequence_destroy (&s);
			}
		}
	}
	result = formatted_text;
	return result;
}


/**
   * Basically the same as get_formatted_text *BUT* it removes pic.twitter.com links.
   */
gchar* tweet_utils_get_trimmed_text (const gchar* tweet_text, GSList* urls, gint media_count) {
	gchar* result = NULL;
	gchar* formatted_text = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gint char_diff = 0;
	GSList* _tmp2_ = NULL;
	g_return_val_if_fail (tweet_text != NULL, NULL);
	_tmp0_ = tweet_text;
	_tmp1_ = g_strdup (_tmp0_);
	formatted_text = _tmp1_;
	char_diff = 0;
	_tmp2_ = urls;
	{
		GSList* s_collection = NULL;
		GSList* s_it = NULL;
		s_collection = _tmp2_;
		for (s_it = s_collection; s_it != NULL; s_it = s_it->next) {
			TweetUtilsSequence _tmp3_ = {0};
			TweetUtilsSequence s = {0};
			tweet_utils_sequence_copy ((TweetUtilsSequence*) s_it->data, &_tmp3_);
			s = _tmp3_;
			{
				gint length_before = 0;
				const gchar* _tmp4_ = NULL;
				gint _tmp5_ = 0;
				gint from = 0;
				const gchar* _tmp6_ = NULL;
				TweetUtilsSequence _tmp7_ = {0};
				gint _tmp8_ = 0;
				gint _tmp9_ = 0;
				gint _tmp10_ = 0;
				gint to = 0;
				const gchar* _tmp11_ = NULL;
				TweetUtilsSequence _tmp12_ = {0};
				gint _tmp13_ = 0;
				gint _tmp14_ = 0;
				gint _tmp15_ = 0;
				gboolean _tmp16_ = FALSE;
				TweetUtilsSequence _tmp17_ = {0};
				const gchar* _tmp18_ = NULL;
				gboolean _tmp19_ = FALSE;
				gint _tmp50_ = 0;
				const gchar* _tmp51_ = NULL;
				gint _tmp52_ = 0;
				gint _tmp53_ = 0;
				_tmp4_ = formatted_text;
				_tmp5_ = g_utf8_strlen (_tmp4_, (gssize) (-1));
				length_before = _tmp5_;
				_tmp6_ = formatted_text;
				_tmp7_ = s;
				_tmp8_ = _tmp7_.start;
				_tmp9_ = char_diff;
				_tmp10_ = string_index_of_nth_char (_tmp6_, (glong) (_tmp8_ + _tmp9_));
				from = _tmp10_;
				_tmp11_ = formatted_text;
				_tmp12_ = s;
				_tmp13_ = _tmp12_.end;
				_tmp14_ = char_diff;
				_tmp15_ = string_index_of_nth_char (_tmp11_, (glong) (_tmp13_ + _tmp14_));
				to = _tmp15_;
				_tmp17_ = s;
				_tmp18_ = _tmp17_.display_url;
				_tmp19_ = g_str_has_prefix (_tmp18_, "pic.twitter.com/");
				if (_tmp19_) {
					_tmp16_ = TRUE;
				} else {
					gboolean _tmp20_ = FALSE;
					gint _tmp21_ = 0;
					_tmp21_ = media_count;
					if (_tmp21_ == 1) {
						TweetUtilsSequence _tmp22_ = {0};
						const gchar* _tmp23_ = NULL;
						gboolean _tmp24_ = FALSE;
						_tmp22_ = s;
						_tmp23_ = _tmp22_.url;
						_tmp24_ = inline_media_downloader_is_media_candidate (_tmp23_);
						_tmp20_ = _tmp24_;
					} else {
						_tmp20_ = FALSE;
					}
					_tmp16_ = _tmp20_;
				}
				if (_tmp16_) {
					const gchar* _tmp25_ = NULL;
					gint _tmp26_ = 0;
					gint _tmp27_ = 0;
					gchar* _tmp28_ = NULL;
					_tmp25_ = formatted_text;
					_tmp26_ = from;
					_tmp27_ = to;
					_tmp28_ = string_splice (_tmp25_, (glong) _tmp26_, (glong) _tmp27_, "");
					_g_free0 (formatted_text);
					formatted_text = _tmp28_;
				} else {
					gchar* title = NULL;
					TweetUtilsSequence _tmp29_ = {0};
					const gchar* _tmp30_ = NULL;
					const gchar* _tmp37_ = NULL;
					gint _tmp38_ = 0;
					gint _tmp39_ = 0;
					TweetUtilsSequence _tmp40_ = {0};
					const gchar* _tmp41_ = NULL;
					const gchar* _tmp42_ = NULL;
					TweetUtilsSequence _tmp43_ = {0};
					const gchar* _tmp44_ = NULL;
					gchar* _tmp45_ = NULL;
					gchar* _tmp46_ = NULL;
					gchar* _tmp47_ = NULL;
					gchar* _tmp48_ = NULL;
					gchar* _tmp49_ = NULL;
					title = NULL;
					_tmp29_ = s;
					_tmp30_ = _tmp29_.title;
					if (_tmp30_ != NULL) {
						TweetUtilsSequence _tmp31_ = {0};
						const gchar* _tmp32_ = NULL;
						gchar* _tmp33_ = NULL;
						_tmp31_ = s;
						_tmp32_ = _tmp31_.title;
						_tmp33_ = string_replace (_tmp32_, "&", "&amp;amp;");
						_g_free0 (title);
						title = _tmp33_;
					} else {
						TweetUtilsSequence _tmp34_ = {0};
						const gchar* _tmp35_ = NULL;
						gchar* _tmp36_ = NULL;
						_tmp34_ = s;
						_tmp35_ = _tmp34_.url;
						_tmp36_ = string_replace (_tmp35_, "&", "&amp;");
						_g_free0 (title);
						title = _tmp36_;
					}
					_tmp37_ = formatted_text;
					_tmp38_ = from;
					_tmp39_ = to;
					_tmp40_ = s;
					_tmp41_ = _tmp40_.url;
					_tmp42_ = title;
					_tmp43_ = s;
					_tmp44_ = _tmp43_.display_url;
					_tmp45_ = string_replace (_tmp44_, "&", "&amp;");
					_tmp46_ = _tmp45_;
					_tmp47_ = g_strdup_printf ("<span underline='none'><a href=\"%s\" title=\"%s\">%s</a></span>", _tmp41_, _tmp42_, _tmp46_);
					_tmp48_ = _tmp47_;
					_tmp49_ = string_splice (_tmp37_, (glong) _tmp38_, (glong) _tmp39_, _tmp48_);
					_g_free0 (formatted_text);
					formatted_text = _tmp49_;
					_g_free0 (_tmp48_);
					_g_free0 (_tmp46_);
					_g_free0 (title);
				}
				_tmp50_ = char_diff;
				_tmp51_ = formatted_text;
				_tmp52_ = g_utf8_strlen (_tmp51_, (gssize) (-1));
				_tmp53_ = length_before;
				char_diff = _tmp50_ + (_tmp52_ - _tmp53_);
				tweet_utils_sequence_destroy (&s);
			}
		}
	}
	result = formatted_text;
	return result;
}


/**
   * Formats the given Tweet, using the given url list to insert
   * links(the real urls, protocol etc. included).
   *
   * @param tweet_text The text to format
   * @param urls The urls to insert
   *
   * @return The formatted text
   */
gchar* tweet_utils_get_real_text (const gchar* tweet_text, GSList* urls) {
	gchar* result = NULL;
	gchar* formatted_text = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gint char_diff = 0;
	GSList* _tmp2_ = NULL;
	g_return_val_if_fail (tweet_text != NULL, NULL);
	_tmp0_ = tweet_text;
	_tmp1_ = g_strdup (_tmp0_);
	formatted_text = _tmp1_;
	char_diff = 0;
	_tmp2_ = urls;
	{
		GSList* s_collection = NULL;
		GSList* s_it = NULL;
		s_collection = _tmp2_;
		for (s_it = s_collection; s_it != NULL; s_it = s_it->next) {
			TweetUtilsSequence _tmp3_ = {0};
			TweetUtilsSequence s = {0};
			tweet_utils_sequence_copy ((TweetUtilsSequence*) s_it->data, &_tmp3_);
			s = _tmp3_;
			{
				TweetUtilsSequence _tmp4_ = {0};
				gboolean _tmp5_ = FALSE;
				gint length_before = 0;
				const gchar* _tmp6_ = NULL;
				gint _tmp7_ = 0;
				gint from = 0;
				const gchar* _tmp8_ = NULL;
				TweetUtilsSequence _tmp9_ = {0};
				gint _tmp10_ = 0;
				gint _tmp11_ = 0;
				gint _tmp12_ = 0;
				gint to = 0;
				const gchar* _tmp13_ = NULL;
				TweetUtilsSequence _tmp14_ = {0};
				gint _tmp15_ = 0;
				gint _tmp16_ = 0;
				gint _tmp17_ = 0;
				const gchar* _tmp18_ = NULL;
				gint _tmp19_ = 0;
				gint _tmp20_ = 0;
				TweetUtilsSequence _tmp21_ = {0};
				const gchar* _tmp22_ = NULL;
				gchar* _tmp23_ = NULL;
				gint _tmp24_ = 0;
				const gchar* _tmp25_ = NULL;
				gint _tmp26_ = 0;
				gint _tmp27_ = 0;
				_tmp4_ = s;
				_tmp5_ = _tmp4_.visual_display_url;
				if (_tmp5_) {
					tweet_utils_sequence_destroy (&s);
					continue;
				}
				_tmp6_ = formatted_text;
				_tmp7_ = g_utf8_strlen (_tmp6_, (gssize) (-1));
				length_before = _tmp7_;
				_tmp8_ = formatted_text;
				_tmp9_ = s;
				_tmp10_ = _tmp9_.start;
				_tmp11_ = char_diff;
				_tmp12_ = string_index_of_nth_char (_tmp8_, (glong) (_tmp10_ + _tmp11_));
				from = _tmp12_;
				_tmp13_ = formatted_text;
				_tmp14_ = s;
				_tmp15_ = _tmp14_.end;
				_tmp16_ = char_diff;
				_tmp17_ = string_index_of_nth_char (_tmp13_, (glong) (_tmp15_ + _tmp16_));
				to = _tmp17_;
				_tmp18_ = formatted_text;
				_tmp19_ = from;
				_tmp20_ = to;
				_tmp21_ = s;
				_tmp22_ = _tmp21_.url;
				_tmp23_ = string_splice (_tmp18_, (glong) _tmp19_, (glong) _tmp20_, _tmp22_);
				_g_free0 (formatted_text);
				formatted_text = _tmp23_;
				_tmp24_ = char_diff;
				_tmp25_ = formatted_text;
				_tmp26_ = g_utf8_strlen (_tmp25_, (gssize) (-1));
				_tmp27_ = length_before;
				char_diff = _tmp24_ + (_tmp26_ - _tmp27_);
				tweet_utils_sequence_destroy (&s);
			}
		}
	}
	result = formatted_text;
	return result;
}


static void tweet_utils_delete_tweet_data_free (gpointer _data) {
	TweetUtilsDeleteTweetData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->account);
	_g_object_unref0 (_data_->tweet);
	g_slice_free (TweetUtilsDeleteTweetData, _data_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void tweet_utils_delete_tweet (Account* account, Tweet* tweet, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TweetUtilsDeleteTweetData* _data_;
	Account* _tmp0_ = NULL;
	Account* _tmp1_ = NULL;
	Tweet* _tmp2_ = NULL;
	Tweet* _tmp3_ = NULL;
	_data_ = g_slice_new0 (TweetUtilsDeleteTweetData);
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, tweet_utils_delete_tweet);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tweet_utils_delete_tweet_data_free);
	_tmp0_ = account;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data_->account);
	_data_->account = _tmp1_;
	_tmp2_ = tweet;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (_data_->tweet);
	_data_->tweet = _tmp3_;
	tweet_utils_delete_tweet_co (_data_);
}


void tweet_utils_delete_tweet_finish (GAsyncResult* _res_) {
	TweetUtilsDeleteTweetData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * Deletes the given tweet.
   *
   * @param account The account to delete the tweet from
   * @param tweet the tweet to delete
   */
static Block49Data* block49_data_ref (Block49Data* _data49_) {
	g_atomic_int_inc (&_data49_->_ref_count_);
	return _data49_;
}


static void block49_data_unref (void * _userdata_) {
	Block49Data* _data49_;
	_data49_ = (Block49Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data49_->_ref_count_)) {
		_g_object_unref0 (_data49_->call);
		g_slice_free (Block49Data, _data49_);
	}
}


static void __lambda66_ (Block49Data* _data49_, GObject* obj, GAsyncResult* res) {
	GError * _inner_error_ = NULL;
	g_return_if_fail ((obj == NULL) || G_IS_OBJECT (obj));
	g_return_if_fail (G_IS_ASYNC_RESULT (res));
	{
		GAsyncResult* _tmp0_ = NULL;
		_tmp0_ = res;
		rest_proxy_call_invoke_finish (_data49_->call, _tmp0_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch62_g_error;
		}
	}
	goto __finally62;
	__catch62_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		g_critical ("TweetUtils.vala:150: %s", _tmp2_);
		_g_error_free0 (e);
	}
	__finally62:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	tweet_utils_delete_tweet_co (_data49_->_async_data_);
}


static void ___lambda66__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda66_ (self, source_object, res);
	block49_data_unref (self);
}


static gboolean tweet_utils_delete_tweet_co (TweetUtilsDeleteTweetData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data49_ = g_slice_new0 (Block49Data);
	_data_->_data49_->_ref_count_ = 1;
	_data_->_data49_->_async_data_ = _data_;
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->account;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = account_get_proxy (_data_->_tmp0_);
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp2_, rest_proxy_get_type (), RestProxy));
	_data_->_data49_->call = _data_->_tmp3_;
	rest_proxy_call_set_method (_data_->_data49_->call, "POST");
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = _data_->tweet;
	_data_->_tmp5_ = 0LL;
	_data_->_tmp5_ = _data_->_tmp4_->id;
	_data_->_tmp6_ = NULL;
	_data_->_tmp6_ = g_strdup_printf ("%" G_GINT64_FORMAT, _data_->_tmp5_);
	_data_->_tmp7_ = NULL;
	_data_->_tmp7_ = _data_->_tmp6_;
	_data_->_tmp8_ = NULL;
	_data_->_tmp8_ = g_strconcat ("1.1/statuses/destroy/", _data_->_tmp7_, NULL);
	_data_->_tmp9_ = NULL;
	_data_->_tmp9_ = _data_->_tmp8_;
	_data_->_tmp10_ = NULL;
	_data_->_tmp10_ = g_strconcat (_data_->_tmp9_, ".json", NULL);
	_data_->_tmp11_ = NULL;
	_data_->_tmp11_ = _data_->_tmp10_;
	rest_proxy_call_set_function (_data_->_data49_->call, _data_->_tmp11_);
	_g_free0 (_data_->_tmp11_);
	_g_free0 (_data_->_tmp9_);
	_g_free0 (_data_->_tmp7_);
	_data_->_tmp12_ = NULL;
	_data_->_tmp12_ = _data_->tweet;
	_data_->_tmp13_ = 0LL;
	_data_->_tmp13_ = _data_->_tmp12_->id;
	_data_->_tmp14_ = NULL;
	_data_->_tmp14_ = g_strdup_printf ("%" G_GINT64_FORMAT, _data_->_tmp13_);
	_data_->_tmp15_ = NULL;
	_data_->_tmp15_ = _data_->_tmp14_;
	rest_proxy_call_add_param (_data_->_data49_->call, "id", _data_->_tmp15_);
	_g_free0 (_data_->_tmp15_);
	rest_proxy_call_invoke_async (_data_->_data49_->call, NULL, ___lambda66__gasync_ready_callback, block49_data_ref (_data_->_data49_));
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	block49_data_unref (_data_->_data49_);
	_data_->_data49_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void tweet_utils_reply_to_tweet_data_free (gpointer _data) {
	TweetUtilsReplyToTweetData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->account);
	_g_object_unref0 (_data_->tweet);
	_g_free0 (_data_->text);
	g_slice_free (TweetUtilsReplyToTweetData, _data_);
}


void tweet_utils_reply_to_tweet (Account* account, Tweet* tweet, const gchar* text, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TweetUtilsReplyToTweetData* _data_;
	Account* _tmp0_ = NULL;
	Account* _tmp1_ = NULL;
	Tweet* _tmp2_ = NULL;
	Tweet* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	_data_ = g_slice_new0 (TweetUtilsReplyToTweetData);
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, tweet_utils_reply_to_tweet);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tweet_utils_reply_to_tweet_data_free);
	_tmp0_ = account;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data_->account);
	_data_->account = _tmp1_;
	_tmp2_ = tweet;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (_data_->tweet);
	_data_->tweet = _tmp3_;
	_tmp4_ = text;
	_tmp5_ = g_strdup (_tmp4_);
	_g_free0 (_data_->text);
	_data_->text = _tmp5_;
	tweet_utils_reply_to_tweet_co (_data_);
}


void tweet_utils_reply_to_tweet_finish (GAsyncResult* _res_) {
	TweetUtilsReplyToTweetData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * Replies to the given tweet. This intended for quick/easy replies, without any
   * additional data such as media.
   *
   * @param account The account to reply from
   * @param tweet The tweet to reply to
   * @param text The text to reply
   */
static Block50Data* block50_data_ref (Block50Data* _data50_) {
	g_atomic_int_inc (&_data50_->_ref_count_);
	return _data50_;
}


static void block50_data_unref (void * _userdata_) {
	Block50Data* _data50_;
	_data50_ = (Block50Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data50_->_ref_count_)) {
		g_slice_free (Block50Data, _data50_);
	}
}


static void __lambda216_ (Block50Data* _data50_) {
	tweet_utils_reply_to_tweet_co (_data50_->_async_data_);
}


static void ___lambda216__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda216_ (self);
	block50_data_unref (self);
}


static gboolean tweet_utils_reply_to_tweet_co (TweetUtilsReplyToTweetData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data50_ = g_slice_new0 (Block50Data);
	_data_->_data50_->_ref_count_ = 1;
	_data_->_data50_->_async_data_ = _data_;
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->account;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = account_get_proxy (_data_->_tmp0_);
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp2_, rest_proxy_get_type (), RestProxy));
	_data_->call = _data_->_tmp3_;
	rest_proxy_call_set_function (_data_->call, "1.1/statuses/update.json");
	rest_proxy_call_set_method (_data_->call, "POST");
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = _data_->tweet;
	_data_->_tmp5_ = 0LL;
	_data_->_tmp5_ = _data_->_tmp4_->id;
	_data_->_tmp6_ = NULL;
	_data_->_tmp6_ = g_strdup_printf ("%" G_GINT64_FORMAT, _data_->_tmp5_);
	_data_->_tmp7_ = NULL;
	_data_->_tmp7_ = _data_->_tmp6_;
	rest_proxy_call_add_param (_data_->call, "in_reply_to_status_id", _data_->_tmp7_);
	_g_free0 (_data_->_tmp7_);
	_data_->_tmp8_ = NULL;
	_data_->_tmp8_ = _data_->text;
	rest_proxy_call_add_param (_data_->call, "status", _data_->_tmp8_);
	rest_proxy_call_invoke_async (_data_->call, NULL, ___lambda216__gasync_ready_callback, block50_data_ref (_data_->_data50_));
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	_g_object_unref0 (_data_->call);
	block50_data_unref (_data_->_data50_);
	_data_->_data50_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void tweet_utils_toggle_favorite_tweet_data_free (gpointer _data) {
	TweetUtilsToggleFavoriteTweetData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->account);
	g_slice_free (TweetUtilsToggleFavoriteTweetData, _data_);
}


void tweet_utils_toggle_favorite_tweet (Account* account, Tweet* tweet, gboolean unfavorite, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TweetUtilsToggleFavoriteTweetData* _data_;
	Account* _tmp0_ = NULL;
	Account* _tmp1_ = NULL;
	Tweet* _tmp2_ = NULL;
	Tweet* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	_data_ = g_slice_new0 (TweetUtilsToggleFavoriteTweetData);
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, tweet_utils_toggle_favorite_tweet);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tweet_utils_toggle_favorite_tweet_data_free);
	_tmp0_ = account;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data_->account);
	_data_->account = _tmp1_;
	_tmp2_ = tweet;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (_data_->tweet);
	_data_->tweet = _tmp3_;
	_tmp4_ = unfavorite;
	_data_->unfavorite = _tmp4_;
	tweet_utils_toggle_favorite_tweet_co (_data_);
}


void tweet_utils_toggle_favorite_tweet_finish (GAsyncResult* _res_) {
	TweetUtilsToggleFavoriteTweetData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * (Un)favorites the given tweet.
   *
   * @param account The account to (un)favorite from
   * @param tweet The tweet to (un)favorite
   * @param unfavorite If set to true, this function will unfavorite the tiven tweet,
   *                   else it will favorite it.
   */
static Block51Data* block51_data_ref (Block51Data* _data51_) {
	g_atomic_int_inc (&_data51_->_ref_count_);
	return _data51_;
}


static void block51_data_unref (void * _userdata_) {
	Block51Data* _data51_;
	_data51_ = (Block51Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data51_->_ref_count_)) {
		_g_object_unref0 (_data51_->call);
		_g_object_unref0 (_data51_->tweet);
		g_slice_free (Block51Data, _data51_);
	}
}


static void __lambda72_ (Block51Data* _data51_, GObject* obj, GAsyncResult* res) {
	Tweet* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_if_fail ((obj == NULL) || G_IS_OBJECT (obj));
	g_return_if_fail (G_IS_ASYNC_RESULT (res));
	{
		RestProxyCall* _tmp0_ = NULL;
		GAsyncResult* _tmp1_ = NULL;
		_tmp0_ = _data51_->call;
		_tmp1_ = res;
		rest_proxy_call_invoke_finish (_tmp0_, _tmp1_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch63_g_error;
		}
	}
	goto __finally63;
	__catch63_g_error:
	{
		GError* e = NULL;
		RestProxyCall* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		GError* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = _data51_->call;
		_tmp3_ = rest_proxy_call_get_payload (_tmp2_);
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		utils_show_error_object (_tmp3_, _tmp5_, 200, "TweetUtils.vala");
		_g_error_free0 (e);
	}
	__finally63:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp6_ = _data51_->tweet;
	_tmp7_ = _data51_->unfavorite;
	tweet_set_favorited (_tmp6_, !_tmp7_);
	tweet_utils_toggle_favorite_tweet_co (_data51_->_async_data_);
}


static void ___lambda72__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda72_ (self, source_object, res);
	block51_data_unref (self);
}


static gboolean tweet_utils_toggle_favorite_tweet_co (TweetUtilsToggleFavoriteTweetData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data51_ = g_slice_new0 (Block51Data);
	_data_->_data51_->_ref_count_ = 1;
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->tweet;
	_g_object_unref0 (_data_->_data51_->tweet);
	_data_->_data51_->tweet = _data_->_tmp0_;
	_data_->_tmp1_ = FALSE;
	_data_->_tmp1_ = _data_->unfavorite;
	_data_->_data51_->unfavorite = _data_->_tmp1_;
	_data_->_data51_->_async_data_ = _data_;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = _data_->account;
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = account_get_proxy (_data_->_tmp2_);
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = _data_->_tmp3_;
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp4_, rest_proxy_get_type (), RestProxy));
	_data_->_data51_->call = _data_->_tmp5_;
	_data_->_tmp6_ = FALSE;
	_data_->_tmp6_ = _data_->_data51_->unfavorite;
	if (!_data_->_tmp6_) {
		_data_->_tmp7_ = NULL;
		_data_->_tmp7_ = _data_->_data51_->call;
		rest_proxy_call_set_function (_data_->_tmp7_, "1.1/favorites/create.json");
	} else {
		_data_->_tmp8_ = NULL;
		_data_->_tmp8_ = _data_->_data51_->call;
		rest_proxy_call_set_function (_data_->_tmp8_, "1.1/favorites/destroy.json");
	}
	_data_->_tmp9_ = NULL;
	_data_->_tmp9_ = _data_->_data51_->call;
	rest_proxy_call_set_method (_data_->_tmp9_, "POST");
	_data_->_tmp10_ = NULL;
	_data_->_tmp10_ = _data_->_data51_->call;
	_data_->_tmp11_ = NULL;
	_data_->_tmp11_ = _data_->_data51_->tweet;
	_data_->_tmp12_ = 0LL;
	_data_->_tmp12_ = _data_->_tmp11_->id;
	_data_->_tmp13_ = NULL;
	_data_->_tmp13_ = g_strdup_printf ("%" G_GINT64_FORMAT, _data_->_tmp12_);
	_data_->_tmp14_ = NULL;
	_data_->_tmp14_ = _data_->_tmp13_;
	rest_proxy_call_add_param (_data_->_tmp10_, "id", _data_->_tmp14_);
	_g_free0 (_data_->_tmp14_);
	_data_->_tmp15_ = NULL;
	_data_->_tmp15_ = _data_->_data51_->call;
	rest_proxy_call_invoke_async (_data_->_tmp15_, NULL, ___lambda72__gasync_ready_callback, block51_data_ref (_data_->_data51_));
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	block51_data_unref (_data_->_data51_);
	_data_->_data51_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void tweet_utils_toggle_retweet_tweet_data_free (gpointer _data) {
	TweetUtilsToggleRetweetTweetData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->account);
	g_slice_free (TweetUtilsToggleRetweetTweetData, _data_);
}


void tweet_utils_toggle_retweet_tweet (Account* account, Tweet* tweet, gboolean unretweet, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TweetUtilsToggleRetweetTweetData* _data_;
	Account* _tmp0_ = NULL;
	Account* _tmp1_ = NULL;
	Tweet* _tmp2_ = NULL;
	Tweet* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	_data_ = g_slice_new0 (TweetUtilsToggleRetweetTweetData);
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, tweet_utils_toggle_retweet_tweet);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tweet_utils_toggle_retweet_tweet_data_free);
	_tmp0_ = account;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data_->account);
	_data_->account = _tmp1_;
	_tmp2_ = tweet;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (_data_->tweet);
	_data_->tweet = _tmp3_;
	_tmp4_ = unretweet;
	_data_->unretweet = _tmp4_;
	tweet_utils_toggle_retweet_tweet_co (_data_);
}


void tweet_utils_toggle_retweet_tweet_finish (GAsyncResult* _res_) {
	TweetUtilsToggleRetweetTweetData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * (Un)retweets the given tweet.
   *
   * @param account The account to (un)retweet from
   * @param tweet The tweet to (un)retweet
   * @param unretweet If set to true, this function will delete te retweet of #tweet,
   *                  else it will retweet it.
   */
static Block52Data* block52_data_ref (Block52Data* _data52_) {
	g_atomic_int_inc (&_data52_->_ref_count_);
	return _data52_;
}


static void block52_data_unref (void * _userdata_) {
	Block52Data* _data52_;
	_data52_ = (Block52Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data52_->_ref_count_)) {
		_g_object_unref0 (_data52_->call);
		_g_object_unref0 (_data52_->tweet);
		g_slice_free (Block52Data, _data52_);
	}
}


static void __lambda70_ (Block52Data* _data52_, GObject* obj, GAsyncResult* res) {
	gchar* back = NULL;
	RestProxyCall* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	JsonParser* parser = NULL;
	JsonParser* _tmp9_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail ((obj == NULL) || G_IS_OBJECT (obj));
	g_return_if_fail (G_IS_ASYNC_RESULT (res));
	{
		RestProxyCall* _tmp0_ = NULL;
		GAsyncResult* _tmp1_ = NULL;
		_tmp0_ = _data52_->call;
		_tmp1_ = res;
		rest_proxy_call_invoke_finish (_tmp0_, _tmp1_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch64_g_error;
		}
	}
	goto __finally64;
	__catch64_g_error:
	{
		GError* e = NULL;
		RestProxyCall* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		GError* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = _data52_->call;
		_tmp3_ = rest_proxy_call_get_payload (_tmp2_);
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		utils_show_error_object (_tmp3_, _tmp5_, 229, "TweetUtils.vala");
		_g_error_free0 (e);
	}
	__finally64:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp6_ = _data52_->call;
	_tmp7_ = rest_proxy_call_get_payload (_tmp6_);
	_tmp8_ = g_strdup (_tmp7_);
	back = _tmp8_;
	_tmp9_ = json_parser_new ();
	parser = _tmp9_;
	{
		gboolean _tmp10_ = FALSE;
		Tweet* _tmp17_ = NULL;
		gboolean _tmp18_ = FALSE;
		json_parser_load_from_data (parser, back, (gssize) (-1), &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch65_g_error;
		}
		_tmp10_ = _data52_->unretweet;
		if (!_tmp10_) {
			gint64 new_id = 0LL;
			JsonNode* _tmp11_ = NULL;
			JsonObject* _tmp12_ = NULL;
			gint64 _tmp13_ = 0LL;
			Tweet* _tmp14_ = NULL;
			gint64 _tmp15_ = 0LL;
			_tmp11_ = json_parser_get_root (parser);
			_tmp12_ = json_node_get_object (_tmp11_);
			_tmp13_ = json_object_get_int_member (_tmp12_, "id");
			new_id = _tmp13_;
			_tmp14_ = _data52_->tweet;
			_tmp15_ = new_id;
			_tmp14_->my_retweet = _tmp15_;
		} else {
			Tweet* _tmp16_ = NULL;
			_tmp16_ = _data52_->tweet;
			_tmp16_->my_retweet = (gint64) 0;
		}
		_tmp17_ = _data52_->tweet;
		_tmp18_ = _data52_->unretweet;
		tweet_set_retweeted (_tmp17_, !_tmp18_);
	}
	goto __finally65;
	__catch65_g_error:
	{
		GError* e = NULL;
		GError* _tmp19_ = NULL;
		const gchar* _tmp20_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp19_ = e;
		_tmp20_ = _tmp19_->message;
		g_critical ("TweetUtils.vala:243: %s", _tmp20_);
		g_critical ("TweetUtils.vala:244: %s", back);
		_g_error_free0 (e);
	}
	__finally65:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (parser);
		_g_free0 (back);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	tweet_utils_toggle_retweet_tweet_co (_data52_->_async_data_);
	_g_object_unref0 (parser);
	_g_free0 (back);
}


static void ___lambda70__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda70_ (self, source_object, res);
	block52_data_unref (self);
}


static gboolean tweet_utils_toggle_retweet_tweet_co (TweetUtilsToggleRetweetTweetData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data52_ = g_slice_new0 (Block52Data);
	_data_->_data52_->_ref_count_ = 1;
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->tweet;
	_g_object_unref0 (_data_->_data52_->tweet);
	_data_->_data52_->tweet = _data_->_tmp0_;
	_data_->_tmp1_ = FALSE;
	_data_->_tmp1_ = _data_->unretweet;
	_data_->_data52_->unretweet = _data_->_tmp1_;
	_data_->_data52_->_async_data_ = _data_;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = _data_->account;
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = account_get_proxy (_data_->_tmp2_);
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = _data_->_tmp3_;
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp4_, rest_proxy_get_type (), RestProxy));
	_data_->_data52_->call = _data_->_tmp5_;
	_data_->_tmp6_ = NULL;
	_data_->_tmp6_ = _data_->_data52_->call;
	rest_proxy_call_set_method (_data_->_tmp6_, "POST");
	_data_->_tmp7_ = FALSE;
	_data_->_tmp7_ = _data_->_data52_->unretweet;
	if (!_data_->_tmp7_) {
		_data_->_tmp8_ = NULL;
		_data_->_tmp8_ = _data_->_data52_->call;
		_data_->_tmp9_ = NULL;
		_data_->_tmp9_ = _data_->_data52_->tweet;
		_data_->_tmp10_ = 0LL;
		_data_->_tmp10_ = _data_->_tmp9_->id;
		_data_->_tmp11_ = NULL;
		_data_->_tmp11_ = g_strdup_printf ("%" G_GINT64_FORMAT, _data_->_tmp10_);
		_data_->_tmp12_ = NULL;
		_data_->_tmp12_ = _data_->_tmp11_;
		_data_->_tmp13_ = NULL;
		_data_->_tmp13_ = g_strconcat ("1.1/statuses/retweet/", _data_->_tmp12_, ".json", NULL);
		_data_->_tmp14_ = NULL;
		_data_->_tmp14_ = _data_->_tmp13_;
		rest_proxy_call_set_function (_data_->_tmp8_, _data_->_tmp14_);
		_g_free0 (_data_->_tmp14_);
		_g_free0 (_data_->_tmp12_);
	} else {
		_data_->_tmp15_ = NULL;
		_data_->_tmp15_ = _data_->_data52_->call;
		_data_->_tmp16_ = NULL;
		_data_->_tmp16_ = _data_->_data52_->tweet;
		_data_->_tmp17_ = 0LL;
		_data_->_tmp17_ = _data_->_tmp16_->my_retweet;
		_data_->_tmp18_ = NULL;
		_data_->_tmp18_ = g_strdup_printf ("%" G_GINT64_FORMAT, _data_->_tmp17_);
		_data_->_tmp19_ = NULL;
		_data_->_tmp19_ = _data_->_tmp18_;
		_data_->_tmp20_ = NULL;
		_data_->_tmp20_ = g_strconcat ("1.1/statuses/destroy/", _data_->_tmp19_, ".json", NULL);
		_data_->_tmp21_ = NULL;
		_data_->_tmp21_ = _data_->_tmp20_;
		rest_proxy_call_set_function (_data_->_tmp15_, _data_->_tmp21_);
		_g_free0 (_data_->_tmp21_);
		_g_free0 (_data_->_tmp19_);
	}
	_data_->_tmp22_ = NULL;
	_data_->_tmp22_ = _data_->_data52_->call;
	rest_proxy_call_invoke_async (_data_->_tmp22_, NULL, ___lambda70__gasync_ready_callback, block52_data_ref (_data_->_data52_));
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	block52_data_unref (_data_->_data52_);
	_data_->_data52_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void tweet_utils_download_avatar_data_free (gpointer _data) {
	TweetUtilsDownloadAvatarData* _data_;
	_data_ = _data;
	_g_free0 (_data_->avatar_url);
	_g_object_unref0 (_data_->result);
	g_slice_free (TweetUtilsDownloadAvatarData, _data_);
}


void tweet_utils_download_avatar (const gchar* avatar_url, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TweetUtilsDownloadAvatarData* _data_;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	_data_ = g_slice_new0 (TweetUtilsDownloadAvatarData);
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, tweet_utils_download_avatar);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tweet_utils_download_avatar_data_free);
	_tmp0_ = avatar_url;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (_data_->avatar_url);
	_data_->avatar_url = _tmp1_;
	tweet_utils_download_avatar_co (_data_);
}


GdkPixbuf* tweet_utils_download_avatar_finish (GAsyncResult* _res_, GError** error) {
	GdkPixbuf* result;
	TweetUtilsDownloadAvatarData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


/**
   * Downloads the avatar from the given url.
   *
   * @param avatar_url The avatar url to download
   *
   * @return The loaded avatar.
   */
static Block53Data* block53_data_ref (Block53Data* _data53_) {
	g_atomic_int_inc (&_data53_->_ref_count_);
	return _data53_;
}


static void block53_data_unref (void * _userdata_) {
	Block53Data* _data53_;
	_data53_ = (Block53Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data53_->_ref_count_)) {
		_g_error_free0 (_data53_->err);
		_g_object_unref0 (_data53_->avatar);
		_g_free0 (_data53_->avatar_name);
		g_slice_free (Block53Data, _data53_);
	}
}


static guint8* _vala_array_dup6 (guint8* self, int length) {
	return g_memdup (self, length * sizeof (guint8));
}


static gpointer _g_error_copy0 (gpointer self) {
	return self ? g_error_copy (self) : NULL;
}


static void __lambda26_ (Block53Data* _data53_, SoupSession* s, SoupMessage* _msg) {
	gchar* dest = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	GMemoryInputStream* memory_stream = NULL;
	SoupMessage* _tmp5_ = NULL;
	SoupMessageBody* _tmp6_ = NULL;
	guint8* _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
	guint8* _tmp8_ = NULL;
	gint _tmp8__length1 = 0;
	GMemoryInputStream* _tmp9_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (SOUP_IS_SESSION (s));
	g_return_if_fail (SOUP_IS_MESSAGE (_msg));
	_tmp0_ = _data53_->avatar_name;
	_tmp1_ = g_strconcat ("assets/avatars/", _tmp0_, NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = dirs_cache (_tmp2_);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	dest = _tmp4_;
	_tmp5_ = _msg;
	_tmp6_ = _tmp5_->response_body;
	_tmp7_ = _tmp6_->data;
	_tmp7__length1 = (gint) _tmp6_->length;
	_tmp8_ = (_tmp7_ != NULL) ? _vala_array_dup6 (_tmp7_, _tmp7__length1) : ((gpointer) _tmp7_);
	_tmp8__length1 = _tmp7__length1;
	_tmp9_ = (GMemoryInputStream*) g_memory_input_stream_new_from_data (_tmp8_, _tmp8__length1, NULL);
	memory_stream = _tmp9_;
	{
		GdkPixbuf* _tmp10_ = NULL;
		GMemoryInputStream* _tmp11_ = NULL;
		GdkPixbuf* _tmp12_ = NULL;
		GdkPixbuf* _tmp13_ = NULL;
		GdkPixbuf* _tmp14_ = NULL;
		const gchar* _tmp15_ = NULL;
		_tmp11_ = memory_stream;
		_tmp12_ = gdk_pixbuf_new_from_stream_at_scale (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, G_TYPE_INPUT_STREAM, GInputStream), 48, 48, FALSE, NULL, &_inner_error_);
		_tmp10_ = _tmp12_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch66_g_error;
		}
		_tmp13_ = _tmp10_;
		_tmp10_ = NULL;
		_g_object_unref0 (_data53_->avatar);
		_data53_->avatar = _tmp13_;
		_tmp14_ = _data53_->avatar;
		_tmp15_ = dest;
		gdk_pixbuf_save (_tmp14_, _tmp15_, "png", &_inner_error_, NULL);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (_tmp10_);
			goto __catch66_g_error;
		}
		_g_object_unref0 (_tmp10_);
	}
	goto __finally66;
	__catch66_g_error:
	{
		GError* e = NULL;
		GError* _tmp16_ = NULL;
		GError* _tmp17_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp16_ = e;
		_tmp17_ = _g_error_copy0 (_tmp16_);
		_g_error_free0 (_data53_->err);
		_data53_->err = _tmp17_;
		_g_error_free0 (e);
	}
	__finally66:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (memory_stream);
		_g_free0 (dest);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	tweet_utils_download_avatar_co (_data53_->_async_data_);
	_g_object_unref0 (memory_stream);
	_g_free0 (dest);
}


static void ___lambda26__soup_session_callback (SoupSession* session, SoupMessage* msg, gpointer self) {
	__lambda26_ (self, session, msg);
	block53_data_unref (self);
}


static gboolean tweet_utils_download_avatar_co (TweetUtilsDownloadAvatarData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data53_ = g_slice_new0 (Block53Data);
	_data_->_data53_->_ref_count_ = 1;
	_data_->_data53_->_async_data_ = _data_;
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->avatar_url;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = utils_get_avatar_name (_data_->_tmp0_);
	_data_->_data53_->avatar_name = _data_->_tmp1_;
	_data_->_data53_->avatar = NULL;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = _data_->avatar_url;
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = soup_message_new ("GET", _data_->_tmp2_);
	_data_->msg = _data_->_tmp3_;
	_data_->_data53_->err = NULL;
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = SOUP_SESSION;
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = _data_->msg;
	_data_->_tmp6_ = NULL;
	_data_->_tmp6_ = _g_object_ref0 (_data_->_tmp5_);
	soup_session_queue_message (_data_->_tmp4_, _data_->_tmp6_, ___lambda26__soup_session_callback, block53_data_ref (_data_->_data53_));
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	_data_->_tmp7_ = NULL;
	_data_->_tmp7_ = _data_->_data53_->err;
	if (_data_->_tmp7_ != NULL) {
		_data_->_tmp8_ = NULL;
		_data_->_tmp8_ = _data_->_data53_->err;
		_data_->_tmp9_ = NULL;
		_data_->_tmp9_ = _g_error_copy0 (_data_->_tmp8_);
		_data_->_inner_error_ = _data_->_tmp9_;
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		_g_object_unref0 (_data_->msg);
		block53_data_unref (_data_->_data53_);
		_data_->_data53_ = NULL;
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp10_ = NULL;
	_data_->_tmp10_ = _data_->_data53_->avatar;
	_data_->_tmp11_ = NULL;
	_data_->_tmp11_ = _g_object_ref0 (_data_->_tmp10_);
	_data_->result = _data_->_tmp11_;
	_g_object_unref0 (_data_->msg);
	block53_data_unref (_data_->_data53_);
	_data_->_data53_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	_g_object_unref0 (_data_->msg);
	block53_data_unref (_data_->_data53_);
	_data_->_data53_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


/**
   * Calculates the length of a tweet.
   * See https://dev.twitter.com/docs/faq#5810 for details
   *
   * @param text The text to calculate the length for
   *
   * @return The length of the tweet, taking Twitter's rules for
   *         tweet length into account.
   */
gint tweet_utils_calc_tweet_length (const gchar* text, gint media_count) {
	gint result = 0;
	gchar** words = NULL;
	const gchar* _tmp0_ = NULL;
	gchar** _tmp1_ = NULL;
	gchar** _tmp2_ = NULL;
	gint words_length1 = 0;
	gint _words_size_ = 0;
	gint length = 0;
	gchar** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	gint _tmp15_ = 0;
	gchar** _tmp16_ = NULL;
	gint _tmp16__length1 = 0;
	gint _tmp17_ = 0;
	gint _tmp21_ = 0;
	gint _tmp22_ = 0;
	gint _tmp23_ = 0;
	gint _tmp24_ = 0;
	g_return_val_if_fail (text != NULL, 0);
	_tmp0_ = text;
	_tmp2_ = _tmp1_ = g_strsplit (_tmp0_, " ", 0);
	words = _tmp2_;
	words_length1 = _vala_array_length (_tmp1_);
	_words_size_ = words_length1;
	length = 0;
	_tmp3_ = words;
	_tmp3__length1 = words_length1;
	{
		gchar** s_collection = NULL;
		gint s_collection_length1 = 0;
		gint _s_collection_size_ = 0;
		gint s_it = 0;
		s_collection = _tmp3_;
		s_collection_length1 = _tmp3__length1;
		for (s_it = 0; s_it < _tmp3__length1; s_it = s_it + 1) {
			gchar* _tmp4_ = NULL;
			gchar* s = NULL;
			_tmp4_ = g_strdup (s_collection[s_it]);
			s = _tmp4_;
			{
				gchar** subwords = NULL;
				const gchar* _tmp5_ = NULL;
				gchar** _tmp6_ = NULL;
				gchar** _tmp7_ = NULL;
				gint subwords_length1 = 0;
				gint _subwords_size_ = 0;
				gchar** _tmp8_ = NULL;
				gint _tmp8__length1 = 0;
				gint _tmp13_ = 0;
				gchar** _tmp14_ = NULL;
				gint _tmp14__length1 = 0;
				_tmp5_ = s;
				_tmp7_ = _tmp6_ = g_strsplit (_tmp5_, "\n", 0);
				subwords = _tmp7_;
				subwords_length1 = _vala_array_length (_tmp6_);
				_subwords_size_ = subwords_length1;
				_tmp8_ = subwords;
				_tmp8__length1 = subwords_length1;
				{
					gchar** sw_collection = NULL;
					gint sw_collection_length1 = 0;
					gint _sw_collection_size_ = 0;
					gint sw_it = 0;
					sw_collection = _tmp8_;
					sw_collection_length1 = _tmp8__length1;
					for (sw_it = 0; sw_it < _tmp8__length1; sw_it = sw_it + 1) {
						gchar* _tmp9_ = NULL;
						gchar* sw = NULL;
						_tmp9_ = g_strdup (sw_collection[sw_it]);
						sw = _tmp9_;
						{
							gint _tmp10_ = 0;
							const gchar* _tmp11_ = NULL;
							gint _tmp12_ = 0;
							_tmp10_ = length;
							_tmp11_ = sw;
							_tmp12_ = tweet_utils_get_word_length (_tmp11_);
							length = _tmp10_ + _tmp12_;
							_g_free0 (sw);
						}
					}
				}
				_tmp13_ = length;
				_tmp14_ = subwords;
				_tmp14__length1 = subwords_length1;
				length = _tmp13_ + (_tmp14__length1 - 1);
				subwords = (_vala_array_free (subwords, subwords_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (s);
			}
		}
	}
	_tmp15_ = length;
	_tmp16_ = words;
	_tmp16__length1 = words_length1;
	length = _tmp15_ + (_tmp16__length1 - 1);
	_tmp17_ = length;
	if (_tmp17_ < 0) {
		gint _tmp18_ = 0;
		gint _tmp19_ = 0;
		gint _tmp20_ = 0;
		_tmp18_ = twitter_get_short_url_length_https ();
		_tmp19_ = _tmp18_;
		_tmp20_ = media_count;
		result = _tmp19_ * _tmp20_;
		words = (_vala_array_free (words, words_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	_tmp21_ = length;
	_tmp22_ = twitter_get_short_url_length_https ();
	_tmp23_ = _tmp22_;
	_tmp24_ = media_count;
	length = _tmp21_ + (_tmp23_ * _tmp24_);
	result = length;
	words = (_vala_array_free (words, words_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


gint tweet_utils_get_word_length (const gchar* s) {
	gint result = 0;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	const gchar* _tmp23_ = NULL;
	gint _tmp24_ = 0;
	g_return_val_if_fail (s != NULL, 0);
	_tmp1_ = s;
	_tmp2_ = g_str_has_prefix (_tmp1_, "www.");
	if (_tmp2_) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp3_ = NULL;
		gboolean _tmp4_ = FALSE;
		_tmp3_ = s;
		_tmp4_ = g_str_has_prefix (_tmp3_, "http://");
		_tmp0_ = _tmp4_;
	}
	if (_tmp0_) {
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
		_tmp5_ = twitter_get_short_url_length ();
		_tmp6_ = _tmp5_;
		result = _tmp6_;
		return result;
	}
	_tmp7_ = s;
	_tmp8_ = g_str_has_prefix (_tmp7_, "https://");
	if (_tmp8_) {
		gint _tmp9_ = 0;
		gint _tmp10_ = 0;
		_tmp9_ = twitter_get_short_url_length_https ();
		_tmp10_ = _tmp9_;
		result = _tmp10_;
		return result;
	}
	{
		const gchar** tld_collection = NULL;
		gint tld_collection_length1 = 0;
		gint _tld_collection_size_ = 0;
		gint tld_it = 0;
		tld_collection = TWEET_UTILS_DOMAINS;
		tld_collection_length1 = G_N_ELEMENTS (TWEET_UTILS_DOMAINS);
		for (tld_it = 0; tld_it < G_N_ELEMENTS (TWEET_UTILS_DOMAINS); tld_it = tld_it + 1) {
			gchar* _tmp11_ = NULL;
			gchar* tld = NULL;
			_tmp11_ = g_strdup (tld_collection[tld_it]);
			tld = _tmp11_;
			{
				gchar** parts = NULL;
				const gchar* _tmp12_ = NULL;
				gchar** _tmp13_ = NULL;
				gchar** _tmp14_ = NULL;
				gint parts_length1 = 0;
				gint _parts_size_ = 0;
				gboolean _tmp15_ = FALSE;
				gchar** _tmp16_ = NULL;
				gint _tmp16__length1 = 0;
				_tmp12_ = s;
				_tmp14_ = _tmp13_ = g_strsplit (_tmp12_, "/", 0);
				parts = _tmp14_;
				parts_length1 = _vala_array_length (_tmp13_);
				_parts_size_ = parts_length1;
				_tmp16_ = parts;
				_tmp16__length1 = parts_length1;
				if (_tmp16__length1 > 0) {
					gchar** _tmp17_ = NULL;
					gint _tmp17__length1 = 0;
					const gchar* _tmp18_ = NULL;
					const gchar* _tmp19_ = NULL;
					gboolean _tmp20_ = FALSE;
					_tmp17_ = parts;
					_tmp17__length1 = parts_length1;
					_tmp18_ = _tmp17_[0];
					_tmp19_ = tld;
					_tmp20_ = g_str_has_suffix (_tmp18_, _tmp19_);
					_tmp15_ = _tmp20_;
				} else {
					_tmp15_ = FALSE;
				}
				if (_tmp15_) {
					gint _tmp21_ = 0;
					gint _tmp22_ = 0;
					_tmp21_ = twitter_get_short_url_length ();
					_tmp22_ = _tmp21_;
					result = _tmp22_;
					parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (tld);
					return result;
				}
				parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (tld);
			}
		}
	}
	_tmp23_ = s;
	_tmp24_ = g_utf8_strlen (_tmp23_, (gssize) (-1));
	result = _tmp24_;
	return result;
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_ = NULL;
	glong _tmp1_ = 0L;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_ = 0L;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_ = 0L;
	glong _tmp8_ = 0L;
	glong _tmp14_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	gchar* _tmp22_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_ = 0L;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		glong _tmp5_ = 0L;
		_tmp3_ = offset;
		_tmp4_ = len;
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
		string_length = _tmp5_;
	} else {
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		_tmp6_ = strlen (self);
		_tmp7_ = _tmp6_;
		string_length = (glong) _tmp7_;
	}
	_tmp8_ = offset;
	if (_tmp8_ < ((glong) 0)) {
		glong _tmp9_ = 0L;
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		_tmp9_ = string_length;
		_tmp10_ = offset;
		offset = _tmp9_ + _tmp10_;
		_tmp11_ = offset;
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
	} else {
		glong _tmp12_ = 0L;
		glong _tmp13_ = 0L;
		_tmp12_ = offset;
		_tmp13_ = string_length;
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
	}
	_tmp14_ = len;
	if (_tmp14_ < ((glong) 0)) {
		glong _tmp15_ = 0L;
		glong _tmp16_ = 0L;
		_tmp15_ = string_length;
		_tmp16_ = offset;
		len = _tmp15_ - _tmp16_;
	}
	_tmp17_ = offset;
	_tmp18_ = len;
	_tmp19_ = string_length;
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
	_tmp20_ = offset;
	_tmp21_ = len;
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
	result = _tmp22_;
	return result;
}


static gint string_index_of (const gchar* self, const gchar* needle, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_ = 0;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = needle;
	_tmp2_ = strstr (((gchar*) self) + _tmp0_, (gchar*) _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_ = NULL;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static gint64 int64_parse (const gchar* str) {
	gint64 result = 0LL;
	const gchar* _tmp0_ = NULL;
	gint64 _tmp1_ = 0LL;
	g_return_val_if_fail (str != NULL, 0LL);
	_tmp0_ = str;
	_tmp1_ = g_ascii_strtoll (_tmp0_, NULL, (guint) 0);
	result = _tmp1_;
	return result;
}


gboolean tweet_utils_activate_link (const gchar* uri, MainWindow* window) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* term = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	g_return_val_if_fail (uri != NULL, FALSE);
	g_return_val_if_fail (IS_MAIN_WINDOW (window), FALSE);
	_tmp0_ = uri;
	_tmp1_ = g_strstrip (_tmp0_);
	uri = _tmp1_;
	_tmp2_ = uri;
	_tmp3_ = string_substring (_tmp2_, (glong) 1, (glong) (-1));
	term = _tmp3_;
	_tmp4_ = uri;
	_tmp5_ = g_str_has_prefix (_tmp4_, "@");
	if (_tmp5_) {
		gint slash_index = 0;
		const gchar* _tmp6_ = NULL;
		gint _tmp7_ = 0;
		Bundle* bundle = NULL;
		Bundle* _tmp8_ = NULL;
		gint _tmp9_ = 0;
		_tmp6_ = uri;
		_tmp7_ = string_index_of (_tmp6_, "/", 0);
		slash_index = _tmp7_;
		_tmp8_ = bundle_new ();
		bundle = _tmp8_;
		_tmp9_ = slash_index;
		if (_tmp9_ == (-1)) {
			Bundle* _tmp10_ = NULL;
			const gchar* _tmp11_ = NULL;
			gint64 _tmp12_ = 0LL;
			MainWindow* _tmp13_ = NULL;
			MainWidget* _tmp14_ = NULL;
			Bundle* _tmp15_ = NULL;
			_tmp10_ = bundle;
			_tmp11_ = term;
			_tmp12_ = int64_parse (_tmp11_);
			bundle_put_int64 (_tmp10_, "user_id", _tmp12_);
			_tmp13_ = window;
			_tmp14_ = _tmp13_->main_widget;
			_tmp15_ = bundle;
			main_widget_switch_page (_tmp14_, (gint) PAGE_PROFILE, _tmp15_);
		} else {
			Bundle* _tmp16_ = NULL;
			const gchar* _tmp17_ = NULL;
			gint _tmp18_ = 0;
			gchar* _tmp19_ = NULL;
			gchar* _tmp20_ = NULL;
			gint64 _tmp21_ = 0LL;
			Bundle* _tmp22_ = NULL;
			const gchar* _tmp23_ = NULL;
			gint _tmp24_ = 0;
			const gchar* _tmp25_ = NULL;
			gint _tmp26_ = 0;
			gint _tmp27_ = 0;
			gint _tmp28_ = 0;
			gchar* _tmp29_ = NULL;
			gchar* _tmp30_ = NULL;
			MainWindow* _tmp31_ = NULL;
			MainWidget* _tmp32_ = NULL;
			Bundle* _tmp33_ = NULL;
			_tmp16_ = bundle;
			_tmp17_ = term;
			_tmp18_ = slash_index;
			_tmp19_ = string_substring (_tmp17_, (glong) 0, (glong) (_tmp18_ - 1));
			_tmp20_ = _tmp19_;
			_tmp21_ = int64_parse (_tmp20_);
			bundle_put_int64 (_tmp16_, "user_id", _tmp21_);
			_g_free0 (_tmp20_);
			_tmp22_ = bundle;
			_tmp23_ = term;
			_tmp24_ = slash_index;
			_tmp25_ = term;
			_tmp26_ = strlen (_tmp25_);
			_tmp27_ = _tmp26_;
			_tmp28_ = slash_index;
			_tmp29_ = string_substring (_tmp23_, (glong) (_tmp24_ + 1), (glong) ((_tmp27_ - _tmp28_) - 1));
			_tmp30_ = _tmp29_;
			bundle_put_string (_tmp22_, "screen_name", _tmp30_);
			_g_free0 (_tmp30_);
			_tmp31_ = window;
			_tmp32_ = _tmp31_->main_widget;
			_tmp33_ = bundle;
			main_widget_switch_page (_tmp32_, (gint) PAGE_PROFILE, _tmp33_);
		}
		result = TRUE;
		_g_object_unref0 (bundle);
		_g_free0 (term);
		return result;
	} else {
		const gchar* _tmp34_ = NULL;
		gboolean _tmp35_ = FALSE;
		_tmp34_ = uri;
		_tmp35_ = g_str_has_prefix (_tmp34_, "#");
		if (_tmp35_) {
			Bundle* bundle = NULL;
			Bundle* _tmp36_ = NULL;
			Bundle* _tmp37_ = NULL;
			const gchar* _tmp38_ = NULL;
			MainWindow* _tmp39_ = NULL;
			MainWidget* _tmp40_ = NULL;
			Bundle* _tmp41_ = NULL;
			_tmp36_ = bundle_new ();
			bundle = _tmp36_;
			_tmp37_ = bundle;
			_tmp38_ = uri;
			bundle_put_string (_tmp37_, "query", _tmp38_);
			_tmp39_ = window;
			_tmp40_ = _tmp39_->main_widget;
			_tmp41_ = bundle;
			main_widget_switch_page (_tmp40_, (gint) PAGE_SEARCH, _tmp41_);
			result = TRUE;
			_g_object_unref0 (bundle);
			_g_free0 (term);
			return result;
		} else {
			const gchar* _tmp42_ = NULL;
			gboolean _tmp43_ = FALSE;
			_tmp42_ = uri;
			_tmp43_ = g_str_has_prefix (_tmp42_, "https://twitter.com/");
			if (_tmp43_) {
				gchar** parts = NULL;
				const gchar* _tmp44_ = NULL;
				gchar** _tmp45_ = NULL;
				gchar** _tmp46_ = NULL;
				gint parts_length1 = 0;
				gint _parts_size_ = 0;
				gchar** _tmp47_ = NULL;
				gint _tmp47__length1 = 0;
				gchar** _tmp50_ = NULL;
				gint _tmp50__length1 = 0;
				const gchar* _tmp51_ = NULL;
				_tmp44_ = uri;
				_tmp46_ = _tmp45_ = g_strsplit (_tmp44_, "/", 0);
				parts = _tmp46_;
				parts_length1 = _vala_array_length (_tmp45_);
				_parts_size_ = parts_length1;
				_tmp47_ = parts;
				_tmp47__length1 = parts_length1;
				{
					gchar** s_collection = NULL;
					gint s_collection_length1 = 0;
					gint _s_collection_size_ = 0;
					gint s_it = 0;
					s_collection = _tmp47_;
					s_collection_length1 = _tmp47__length1;
					for (s_it = 0; s_it < _tmp47__length1; s_it = s_it + 1) {
						gchar* _tmp48_ = NULL;
						gchar* s = NULL;
						_tmp48_ = g_strdup (s_collection[s_it]);
						s = _tmp48_;
						{
							const gchar* _tmp49_ = NULL;
							_tmp49_ = s;
							g_message ("TweetUtils.vala:359: %s", _tmp49_);
							_g_free0 (s);
						}
					}
				}
				_tmp50_ = parts;
				_tmp50__length1 = parts_length1;
				_tmp51_ = _tmp50_[4];
				if (g_strcmp0 (_tmp51_, "status") == 0) {
					gint64 tweet_id = 0LL;
					gchar** _tmp52_ = NULL;
					gint _tmp52__length1 = 0;
					const gchar* _tmp53_ = NULL;
					gint64 _tmp54_ = 0LL;
					Bundle* bundle = NULL;
					Bundle* _tmp55_ = NULL;
					Bundle* _tmp56_ = NULL;
					Bundle* _tmp57_ = NULL;
					gint64 _tmp58_ = 0LL;
					Bundle* _tmp59_ = NULL;
					gchar** _tmp60_ = NULL;
					gint _tmp60__length1 = 0;
					const gchar* _tmp61_ = NULL;
					MainWindow* _tmp62_ = NULL;
					MainWidget* _tmp63_ = NULL;
					Bundle* _tmp64_ = NULL;
					_tmp52_ = parts;
					_tmp52__length1 = parts_length1;
					_tmp53_ = _tmp52_[5];
					_tmp54_ = int64_parse (_tmp53_);
					tweet_id = _tmp54_;
					_tmp55_ = bundle_new ();
					bundle = _tmp55_;
					_tmp56_ = bundle;
					bundle_put_int (_tmp56_, "mode", TWEET_INFO_PAGE_BY_ID);
					_tmp57_ = bundle;
					_tmp58_ = tweet_id;
					bundle_put_int64 (_tmp57_, "tweet_id", _tmp58_);
					_tmp59_ = bundle;
					_tmp60_ = parts;
					_tmp60__length1 = parts_length1;
					_tmp61_ = _tmp60_[3];
					bundle_put_string (_tmp59_, "screen_name", _tmp61_);
					_tmp62_ = window;
					_tmp63_ = _tmp62_->main_widget;
					_tmp64_ = bundle;
					main_widget_switch_page (_tmp63_, (gint) PAGE_TWEET_INFO, _tmp64_);
					result = TRUE;
					_g_object_unref0 (bundle);
					parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (term);
					return result;
				}
				parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
			}
		}
	}
	result = FALSE;
	_g_free0 (term);
	return result;
}


TweetUtilsWorkerResult* tweet_utils_worker_result_dup (const TweetUtilsWorkerResult* self) {
	TweetUtilsWorkerResult* dup;
	dup = g_new0 (TweetUtilsWorkerResult, 1);
	memcpy (dup, self, sizeof (TweetUtilsWorkerResult));
	return dup;
}


void tweet_utils_worker_result_free (TweetUtilsWorkerResult* self) {
	g_free (self);
}


GType tweet_utils_worker_result_get_type (void) {
	static volatile gsize tweet_utils_worker_result_type_id__volatile = 0;
	if (g_once_init_enter (&tweet_utils_worker_result_type_id__volatile)) {
		GType tweet_utils_worker_result_type_id;
		tweet_utils_worker_result_type_id = g_boxed_type_register_static ("TweetUtilsWorkerResult", (GBoxedCopyFunc) tweet_utils_worker_result_dup, (GBoxedFreeFunc) tweet_utils_worker_result_free);
		g_once_init_leave (&tweet_utils_worker_result_type_id__volatile, tweet_utils_worker_result_type_id);
	}
	return tweet_utils_worker_result_type_id__volatile;
}


static void tweet_utils_work_array_data_free (gpointer _data) {
	TweetUtilsWorkArrayData* _data_;
	_data_ = _data;
	g_slice_free (TweetUtilsWorkArrayData, _data_);
}


static gpointer _json_array_ref0 (gpointer self) {
	return self ? json_array_ref (self) : NULL;
}


void tweet_utils_work_array (JsonArray* json_array, guint requested_tweet_count, DeltaUpdater* delta_updater, TweetListBox* tweet_list, MainWindow* main_window, Account* account, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TweetUtilsWorkArrayData* _data_;
	JsonArray* _tmp0_ = NULL;
	JsonArray* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	DeltaUpdater* _tmp3_ = NULL;
	DeltaUpdater* _tmp4_ = NULL;
	TweetListBox* _tmp5_ = NULL;
	TweetListBox* _tmp6_ = NULL;
	MainWindow* _tmp7_ = NULL;
	MainWindow* _tmp8_ = NULL;
	Account* _tmp9_ = NULL;
	Account* _tmp10_ = NULL;
	_data_ = g_slice_new0 (TweetUtilsWorkArrayData);
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, tweet_utils_work_array);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tweet_utils_work_array_data_free);
	_tmp0_ = json_array;
	_tmp1_ = _json_array_ref0 (_tmp0_);
	_json_array_unref0 (_data_->json_array);
	_data_->json_array = _tmp1_;
	_tmp2_ = requested_tweet_count;
	_data_->requested_tweet_count = _tmp2_;
	_tmp3_ = delta_updater;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_g_object_unref0 (_data_->delta_updater);
	_data_->delta_updater = _tmp4_;
	_tmp5_ = tweet_list;
	_tmp6_ = _g_object_ref0 (_tmp5_);
	_g_object_unref0 (_data_->tweet_list);
	_data_->tweet_list = _tmp6_;
	_tmp7_ = main_window;
	_tmp8_ = _g_object_ref0 (_tmp7_);
	_g_object_unref0 (_data_->main_window);
	_data_->main_window = _tmp8_;
	_tmp9_ = account;
	_tmp10_ = _g_object_ref0 (_tmp9_);
	_g_object_unref0 (_data_->account);
	_data_->account = _tmp10_;
	tweet_utils_work_array_co (_data_);
}


void tweet_utils_work_array_finish (GAsyncResult* _res_, TweetUtilsWorkerResult* result) {
	TweetUtilsWorkArrayData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	*result = _data_->result;
}


static Block54Data* block54_data_ref (Block54Data* _data54_) {
	g_atomic_int_inc (&_data54_->_ref_count_);
	return _data54_;
}


static void block54_data_unref (void * _userdata_) {
	Block54Data* _data54_;
	_data54_ = (Block54Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data54_->_ref_count_)) {
		_json_array_unref0 (_data54_->json_array);
		_g_object_unref0 (_data54_->delta_updater);
		_g_object_unref0 (_data54_->tweet_list);
		_g_object_unref0 (_data54_->main_window);
		_g_object_unref0 (_data54_->account);
		g_slice_free (Block54Data, _data54_);
	}
}


static Block55Data* block55_data_ref (Block55Data* _data55_) {
	g_atomic_int_inc (&_data55_->_ref_count_);
	return _data55_;
}


static void block55_data_unref (void * _userdata_) {
	Block55Data* _data55_;
	_data55_ = (Block55Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data55_->_ref_count_)) {
		_g_date_time_unref0 (_data55_->now);
		_data55_->tweet_array = (_vala_array_free (_data55_->tweet_array, _data55_->tweet_array_length1, (GDestroyNotify) g_object_unref), NULL);
		block54_data_unref (_data55_->_data54_);
		_data55_->_data54_ = NULL;
		g_slice_free (Block55Data, _data55_);
	}
}


static gboolean ___lambda89_ (Block55Data* _data55_) {
	Block54Data* _data54_;
	gboolean result = FALSE;
	TweetListBox* _tmp0_ = NULL;
	_data54_ = _data55_->_data54_;
	_tmp0_ = _data54_->tweet_list;
	tweet_list_box_remove_progress_entry (_tmp0_);
	tweet_utils_work_array_co (_data54_->_async_data_);
	result = FALSE;
	return result;
}


static gboolean ____lambda89__gsource_func (gpointer self) {
	gboolean result;
	result = ___lambda89_ (self);
	return result;
}


static void __lambda90_ (Block55Data* _data55_, JsonArray* array, guint index, JsonNode* node) {
	Block54Data* _data54_;
	Tweet* t = NULL;
	Tweet* _tmp0_ = NULL;
	Tweet* _tmp1_ = NULL;
	JsonNode* _tmp2_ = NULL;
	GDateTime* _tmp3_ = NULL;
	Account* _tmp4_ = NULL;
	Tweet* _tmp5_ = NULL;
	gint64 _tmp6_ = 0LL;
	Tweet* _tmp9_ = NULL;
	gint64 _tmp10_ = 0LL;
	Tweet** _tmp13_ = NULL;
	gint _tmp13__length1 = 0;
	guint _tmp14_ = 0U;
	Tweet* _tmp15_ = NULL;
	Tweet* _tmp16_ = NULL;
	Tweet* _tmp17_ = NULL;
	_data54_ = _data55_->_data54_;
	g_return_if_fail (array != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = tweet_new ();
	t = _tmp0_;
	_tmp1_ = t;
	_tmp2_ = node;
	_tmp3_ = _data55_->now;
	_tmp4_ = _data54_->account;
	tweet_load_from_json (_tmp1_, _tmp2_, _tmp3_, _tmp4_);
	_tmp5_ = t;
	_tmp6_ = _tmp5_->id;
	if (_tmp6_ > _data54_->max) {
		Tweet* _tmp7_ = NULL;
		gint64 _tmp8_ = 0LL;
		_tmp7_ = t;
		_tmp8_ = _tmp7_->id;
		_data54_->max = _tmp8_;
	}
	_tmp9_ = t;
	_tmp10_ = _tmp9_->id;
	if (_tmp10_ < _data54_->min) {
		Tweet* _tmp11_ = NULL;
		gint64 _tmp12_ = 0LL;
		_tmp11_ = t;
		_tmp12_ = _tmp11_->id;
		_data54_->min = _tmp12_;
	}
	_tmp13_ = _data55_->tweet_array;
	_tmp13__length1 = _data55_->tweet_array_length1;
	_tmp14_ = index;
	_tmp15_ = t;
	_tmp16_ = _g_object_ref0 (_tmp15_);
	_g_object_unref0 (_tmp13_[_tmp14_]);
	_tmp13_[_tmp14_] = _tmp16_;
	_tmp17_ = _tmp13_[_tmp14_];
	_g_object_unref0 (t);
}


static void ___lambda90__json_array_foreach (JsonArray* array, guint index_, JsonNode* element_node, gpointer self) {
	__lambda90_ (self, array, index_, element_node);
}


static gboolean __lambda91_ (Block55Data* _data55_) {
	Block54Data* _data54_;
	gboolean result = FALSE;
	Tweet* tweet = NULL;
	Tweet** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gint _tmp1_ = 0;
	Tweet* _tmp2_ = NULL;
	Tweet* _tmp3_ = NULL;
	TweetListEntry* entry = NULL;
	Tweet* _tmp4_ = NULL;
	Tweet* _tmp5_ = NULL;
	MainWindow* _tmp6_ = NULL;
	Account* _tmp7_ = NULL;
	TweetListEntry* _tmp8_ = NULL;
	Account* _tmp9_ = NULL;
	UserCounter* _tmp10_ = NULL;
	UserCounter* _tmp11_ = NULL;
	Account* _tmp12_ = NULL;
	UserCounter* _tmp13_ = NULL;
	UserCounter* _tmp14_ = NULL;
	Tweet* _tmp15_ = NULL;
	gint64 _tmp16_ = 0LL;
	Tweet* _tmp17_ = NULL;
	const gchar* _tmp18_ = NULL;
	Tweet* _tmp19_ = NULL;
	const gchar* _tmp20_ = NULL;
	DeltaUpdater* _tmp21_ = NULL;
	TweetListEntry* _tmp22_ = NULL;
	TweetListBox* _tmp23_ = NULL;
	TweetListEntry* _tmp24_ = NULL;
	Account* _tmp25_ = NULL;
	TweetListEntry* _tmp26_ = NULL;
	Tweet* _tmp27_ = NULL;
	gboolean _tmp28_ = FALSE;
	gint _tmp31_ = 0;
	gint _tmp32_ = 0;
	Tweet** _tmp33_ = NULL;
	gint _tmp33__length1 = 0;
	_data54_ = _data55_->_data54_;
	_tmp0_ = _data55_->tweet_array;
	_tmp0__length1 = _data55_->tweet_array_length1;
	_tmp1_ = _data55_->index;
	_tmp2_ = _tmp0_[_tmp1_];
	_tmp3_ = _g_object_ref0 (_tmp2_);
	tweet = _tmp3_;
	_tmp4_ = tweet;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	_tmp6_ = _data54_->main_window;
	_tmp7_ = _data54_->account;
	_tmp8_ = tweet_list_entry_new (_tmp5_, _tmp6_, _tmp7_);
	g_object_ref_sink (_tmp8_);
	entry = _tmp8_;
	_tmp9_ = _data54_->account;
	_tmp10_ = account_get_user_counter (_tmp9_);
	_tmp11_ = _tmp10_;
	if (_tmp11_ == NULL) {
		result = FALSE;
		_g_object_unref0 (entry);
		_g_object_unref0 (tweet);
		return result;
	}
	_tmp12_ = _data54_->account;
	_tmp13_ = account_get_user_counter (_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = tweet;
	_tmp16_ = _tmp15_->user_id;
	_tmp17_ = tweet;
	_tmp18_ = _tmp17_->screen_name;
	_tmp19_ = tweet;
	_tmp20_ = _tmp19_->user_name;
	user_counter_user_seen (_tmp14_, _tmp16_, _tmp18_, _tmp20_);
	_tmp21_ = _data54_->delta_updater;
	_tmp22_ = entry;
	delta_updater_add (_tmp21_, G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, TYPE_ITWITTER_ITEM, ITwitterItem));
	_tmp23_ = _data54_->tweet_list;
	_tmp24_ = entry;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, gtk_widget_get_type (), GtkWidget));
	_tmp25_ = _data54_->account;
	_tmp26_ = entry;
	_tmp27_ = _tmp26_->tweet;
	_tmp28_ = account_filter_matches (_tmp25_, _tmp27_);
	if (_tmp28_) {
		TweetListEntry* _tmp29_ = NULL;
		_tmp29_ = entry;
		gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, gtk_widget_get_type (), GtkWidget));
	} else {
		TweetListEntry* _tmp30_ = NULL;
		_tmp30_ = entry;
		gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, gtk_widget_get_type (), GtkWidget));
	}
	_tmp31_ = _data55_->index;
	_data55_->index = _tmp31_ + 1;
	_tmp32_ = _data55_->index;
	_tmp33_ = _data55_->tweet_array;
	_tmp33__length1 = _data55_->tweet_array_length1;
	if (_tmp32_ == _tmp33__length1) {
		Tweet** _tmp34_ = NULL;
		gint _tmp34__length1 = 0;
		guint _tmp35_ = 0U;
		_tmp34_ = _data55_->tweet_array;
		_tmp34__length1 = _data55_->tweet_array_length1;
		_tmp35_ = _data54_->requested_tweet_count;
		if (((guint) _tmp34__length1) < (_tmp35_ - 5)) {
			guint _tmp36_ = 0U;
			Tweet** _tmp37_ = NULL;
			gint _tmp37__length1 = 0;
			TweetListBox* _tmp38_ = NULL;
			_tmp36_ = _data54_->requested_tweet_count;
			_tmp37_ = _data55_->tweet_array;
			_tmp37__length1 = _data55_->tweet_array_length1;
			g_debug ("TweetUtils.vala:438: Removing progress entry. Requested: %u, Got: %d", _tmp36_, _tmp37__length1);
			_tmp38_ = _data54_->tweet_list;
			tweet_list_box_remove_progress_entry (_tmp38_);
		} else {
			TweetListBox* _tmp39_ = NULL;
			_tmp39_ = _data54_->tweet_list;
			tweet_list_box_add_progress_entry (_tmp39_);
		}
		tweet_utils_work_array_co (_data54_->_async_data_);
		result = FALSE;
		_g_object_unref0 (entry);
		_g_object_unref0 (tweet);
		return result;
	}
	result = TRUE;
	_g_object_unref0 (entry);
	_g_object_unref0 (tweet);
	return result;
}


static gboolean ___lambda91__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda91_ (self);
	return result;
}


static void* __lambda88_ (Block54Data* _data54_) {
	void* result = NULL;
	Block55Data* _data55_;
	JsonArray* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	Tweet** _tmp2_ = NULL;
	Tweet** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	GDateTime* _tmp4_ = NULL;
	JsonArray* _tmp5_ = NULL;
	_data55_ = g_slice_new0 (Block55Data);
	_data55_->_ref_count_ = 1;
	_data55_->_data54_ = block54_data_ref (_data54_);
	_tmp0_ = _data54_->json_array;
	_tmp1_ = json_array_get_length (_tmp0_);
	_tmp2_ = g_new0 (Tweet*, _tmp1_ + 1);
	_data55_->tweet_array = _tmp2_;
	_data55_->tweet_array_length1 = _tmp1_;
	_data55_->_tweet_array_size_ = _data55_->tweet_array_length1;
	_tmp3_ = _data55_->tweet_array;
	_tmp3__length1 = _data55_->tweet_array_length1;
	if (_tmp3__length1 == 0) {
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ____lambda89__gsource_func, block55_data_ref (_data55_), block55_data_unref);
		result = NULL;
		block55_data_unref (_data55_);
		_data55_ = NULL;
		return result;
	}
	_tmp4_ = g_date_time_new_now_local ();
	_data55_->now = _tmp4_;
	_tmp5_ = _data54_->json_array;
	json_array_foreach_element (_tmp5_, ___lambda90__json_array_foreach, _data55_);
	_data55_->index = 0;
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda91__gsource_func, block55_data_ref (_data55_), block55_data_unref);
	result = NULL;
	block55_data_unref (_data55_);
	_data55_ = NULL;
	return result;
}


static gpointer ___lambda88__gthread_func (gpointer self) {
	gpointer result;
	result = __lambda88_ (self);
	block54_data_unref (self);
	return result;
}


static gboolean tweet_utils_work_array_co (TweetUtilsWorkArrayData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data54_ = g_slice_new0 (Block54Data);
	_data_->_data54_->_ref_count_ = 1;
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->json_array;
	_json_array_unref0 (_data_->_data54_->json_array);
	_data_->_data54_->json_array = _data_->_tmp0_;
	_data_->_tmp1_ = 0U;
	_data_->_tmp1_ = _data_->requested_tweet_count;
	_data_->_data54_->requested_tweet_count = _data_->_tmp1_;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = _data_->delta_updater;
	_g_object_unref0 (_data_->_data54_->delta_updater);
	_data_->_data54_->delta_updater = _data_->_tmp2_;
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = _data_->tweet_list;
	_g_object_unref0 (_data_->_data54_->tweet_list);
	_data_->_data54_->tweet_list = _data_->_tmp3_;
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = _data_->main_window;
	_g_object_unref0 (_data_->_data54_->main_window);
	_data_->_data54_->main_window = _data_->_tmp4_;
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = _data_->account;
	_g_object_unref0 (_data_->_data54_->account);
	_data_->_data54_->account = _data_->_tmp5_;
	_data_->_data54_->_async_data_ = _data_;
	_data_->_data54_->max = (gint64) 0;
	_data_->_data54_->min = G_MAXINT64;
	_data_->_tmp6_ = NULL;
	_data_->_tmp6_ = g_thread_new ("TweetWorker", ___lambda88__gthread_func, block54_data_ref (_data_->_data54_));
	_data_->_tmp7_ = NULL;
	_data_->_tmp7_ = _data_->_tmp6_;
	_g_thread_unref0 (_data_->_tmp7_);
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	memset (&_data_->_tmp8_, 0, sizeof (TweetUtilsWorkerResult));
	_data_->_tmp8_.max_id = _data_->_data54_->max;
	_data_->_tmp8_.min_id = _data_->_data54_->min;
	_data_->result = _data_->_tmp8_;
	block54_data_unref (_data_->_data54_);
	_data_->_data54_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	block54_data_unref (_data_->_data54_);
	_data_->_data54_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


void tweet_utils_handle_media_click (Tweet* t, MainWindow* window, gint index) {
	MediaDialog* media_dialog = NULL;
	Tweet* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	MediaDialog* _tmp2_ = NULL;
	MainWindow* _tmp3_ = NULL;
	g_return_if_fail (IS_TWEET (t));
	g_return_if_fail (IS_MAIN_WINDOW (window));
	_tmp0_ = t;
	_tmp1_ = index;
	_tmp2_ = media_dialog_new (_tmp0_, _tmp1_);
	g_object_ref_sink (_tmp2_);
	media_dialog = _tmp2_;
	_tmp3_ = window;
	gtk_window_set_transient_for (G_TYPE_CHECK_INSTANCE_CAST (media_dialog, gtk_window_get_type (), GtkWindow), G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_window_get_type (), GtkWindow));
	gtk_window_set_modal (G_TYPE_CHECK_INSTANCE_CAST (media_dialog, gtk_window_get_type (), GtkWindow), TRUE);
	gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (media_dialog, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (media_dialog);
}


gboolean tweet_utils_is_link (const gchar* word) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp6_ = FALSE;
	const gchar* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	g_return_val_if_fail (word != NULL, FALSE);
	_tmp1_ = word;
	_tmp2_ = g_str_has_prefix (_tmp1_, "http://");
	if (_tmp2_) {
		const gchar* _tmp3_ = NULL;
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
		_tmp3_ = word;
		_tmp4_ = strlen (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp0_ = _tmp5_ > 7;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	}
	_tmp7_ = word;
	_tmp8_ = g_str_has_prefix (_tmp7_, "https://");
	if (_tmp8_) {
		const gchar* _tmp9_ = NULL;
		gint _tmp10_ = 0;
		gint _tmp11_ = 0;
		_tmp9_ = word;
		_tmp10_ = strlen (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp6_ = _tmp11_ > 8;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		result = TRUE;
		return result;
	}
	{
		const gchar** tld_collection = NULL;
		gint tld_collection_length1 = 0;
		gint _tld_collection_size_ = 0;
		gint tld_it = 0;
		tld_collection = TWEET_UTILS_DOMAINS;
		tld_collection_length1 = G_N_ELEMENTS (TWEET_UTILS_DOMAINS);
		for (tld_it = 0; tld_it < G_N_ELEMENTS (TWEET_UTILS_DOMAINS); tld_it = tld_it + 1) {
			gchar* _tmp12_ = NULL;
			gchar* tld = NULL;
			_tmp12_ = g_strdup (tld_collection[tld_it]);
			tld = _tmp12_;
			{
				const gchar* _tmp13_ = NULL;
				const gchar* _tmp14_ = NULL;
				gboolean _tmp15_ = FALSE;
				_tmp13_ = word;
				_tmp14_ = tld;
				_tmp15_ = g_str_has_suffix (_tmp13_, _tmp14_);
				if (_tmp15_) {
					result = TRUE;
					_g_free0 (tld);
					return result;
				}
				_g_free0 (tld);
			}
		}
	}
	result = FALSE;
	return result;
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_ = 0L;
	gchar _tmp1_ = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


gboolean tweet_utils_is_mention (const gchar* word) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_ = NULL;
	gchar _tmp2_ = '\0';
	g_return_val_if_fail (word != NULL, FALSE);
	_tmp1_ = word;
	_tmp2_ = string_get (_tmp1_, (glong) 0);
	if (_tmp2_ == '@') {
		const gchar* _tmp3_ = NULL;
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
		_tmp3_ = word;
		_tmp4_ = strlen (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp0_ = _tmp5_ > 1;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


gboolean tweet_utils_is_hashtag (const gchar* word) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_ = NULL;
	gchar _tmp2_ = '\0';
	g_return_val_if_fail (word != NULL, FALSE);
	_tmp1_ = word;
	_tmp2_ = string_get (_tmp1_, (glong) 0);
	if (_tmp2_ == '#') {
		const gchar* _tmp3_ = NULL;
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
		_tmp3_ = word;
		_tmp4_ = strlen (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp0_ = _tmp5_ > 1;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


static GtkTextIter* _gtk_text_iter_dup (GtkTextIter* self) {
	GtkTextIter* dup;
	dup = g_new0 (GtkTextIter, 1);
	memcpy (dup, self, sizeof (GtkTextIter));
	return dup;
}


static gpointer __gtk_text_iter_dup0 (gpointer self) {
	return self ? _gtk_text_iter_dup (self) : NULL;
}


static gunichar string_get_char (const gchar* self, glong index) {
	gunichar result = 0U;
	glong _tmp0_ = 0L;
	gunichar _tmp1_ = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = index;
	_tmp1_ = g_utf8_get_char (((gchar*) self) + _tmp0_);
	result = _tmp1_;
	return result;
}


void tweet_utils_highlight_link (GtkTextBuffer* buffer, GtkTextIter* word_start, GtkTextIter* word_end) {
	GtkTextIter* iter1 = NULL;
	GtkTextIter* _tmp0_ = NULL;
	GtkTextIter* _tmp1_ = NULL;
	GtkTextIter* iter2 = NULL;
	GtkTextIter* _tmp2_ = NULL;
	GtkTextIter* _tmp3_ = NULL;
	GtkTextIter* _tmp4_ = NULL;
	GtkTextIter* _tmp5_ = NULL;
	GtkTextBuffer* _tmp23_ = NULL;
	GtkTextIter* _tmp24_ = NULL;
	GtkTextIter* _tmp25_ = NULL;
	GtkTextIter _tmp26_ = {0};
	GtkTextIter _tmp27_ = {0};
	g_return_if_fail (GTK_IS_TEXT_BUFFER (buffer));
	_tmp0_ = word_start;
	_tmp1_ = __gtk_text_iter_dup0 (_tmp0_);
	iter1 = _tmp1_;
	_tmp2_ = word_start;
	_tmp3_ = __gtk_text_iter_dup0 (_tmp2_);
	iter2 = _tmp3_;
	_tmp4_ = iter1;
	gtk_text_iter_forward_char (_tmp4_);
	_tmp5_ = iter2;
	gtk_text_iter_forward_chars (_tmp5_, 2);
	while (TRUE) {
		GtkTextIter* _tmp6_ = NULL;
		GtkTextIter* _tmp7_ = NULL;
		GtkTextIter _tmp8_ = {0};
		gint _tmp9_ = 0;
		gchar* t = NULL;
		GtkTextBuffer* _tmp10_ = NULL;
		GtkTextIter* _tmp11_ = NULL;
		GtkTextIter* _tmp12_ = NULL;
		GtkTextIter _tmp13_ = {0};
		GtkTextIter _tmp14_ = {0};
		gchar* _tmp15_ = NULL;
		gunichar c = 0U;
		const gchar* _tmp16_ = NULL;
		gunichar _tmp17_ = 0U;
		gboolean _tmp18_ = FALSE;
		gunichar _tmp19_ = 0U;
		GtkTextIter* _tmp21_ = NULL;
		GtkTextIter* _tmp22_ = NULL;
		_tmp6_ = iter1;
		_tmp7_ = word_end;
		_tmp8_ = *_tmp7_;
		_tmp9_ = gtk_text_iter_compare (_tmp6_, &_tmp8_);
		if (!(_tmp9_ < 0)) {
			break;
		}
		_tmp10_ = buffer;
		_tmp11_ = iter1;
		_tmp12_ = iter2;
		_tmp13_ = *_tmp11_;
		_tmp14_ = *_tmp12_;
		_tmp15_ = gtk_text_buffer_get_text (_tmp10_, &_tmp13_, &_tmp14_, FALSE);
		t = _tmp15_;
		_tmp16_ = t;
		_tmp17_ = string_get_char (_tmp16_, (glong) 0);
		c = _tmp17_;
		_tmp19_ = c;
		if (_tmp19_ == ((gunichar) '"')) {
			_tmp18_ = TRUE;
		} else {
			gunichar _tmp20_ = 0U;
			_tmp20_ = c;
			_tmp18_ = _tmp20_ == 8220U;
		}
		if (_tmp18_) {
			_g_free0 (t);
			break;
		}
		_tmp21_ = iter1;
		gtk_text_iter_forward_char (_tmp21_);
		_tmp22_ = iter2;
		gtk_text_iter_forward_char (_tmp22_);
		_g_free0 (t);
	}
	_tmp23_ = buffer;
	_tmp24_ = word_start;
	_tmp25_ = iter1;
	_tmp26_ = *_tmp24_;
	_tmp27_ = *_tmp25_;
	gtk_text_buffer_apply_tag_by_name (_tmp23_, "link", &_tmp26_, &_tmp27_);
	_g_free0 (iter2);
	_g_free0 (iter1);
}


/** Invariant: The word passed to this function starts with a @ */
void tweet_utils_highlight_mention (GtkTextBuffer* buffer, GtkTextIter* word_start, GtkTextIter* word_end) {
	GtkTextIter* iter1 = NULL;
	GtkTextIter* _tmp0_ = NULL;
	GtkTextIter* _tmp1_ = NULL;
	GtkTextIter* iter2 = NULL;
	GtkTextIter* _tmp2_ = NULL;
	GtkTextIter* _tmp3_ = NULL;
	GtkTextIter* _tmp4_ = NULL;
	GtkTextIter* _tmp5_ = NULL;
	GtkTextBuffer* _tmp28_ = NULL;
	GtkTextIter* _tmp29_ = NULL;
	GtkTextIter* _tmp30_ = NULL;
	GtkTextIter _tmp31_ = {0};
	GtkTextIter _tmp32_ = {0};
	g_return_if_fail (GTK_IS_TEXT_BUFFER (buffer));
	_tmp0_ = word_start;
	_tmp1_ = __gtk_text_iter_dup0 (_tmp0_);
	iter1 = _tmp1_;
	_tmp2_ = word_start;
	_tmp3_ = __gtk_text_iter_dup0 (_tmp2_);
	iter2 = _tmp3_;
	_tmp4_ = iter1;
	gtk_text_iter_forward_char (_tmp4_);
	_tmp5_ = iter2;
	gtk_text_iter_forward_chars (_tmp5_, 2);
	while (TRUE) {
		GtkTextIter* _tmp6_ = NULL;
		GtkTextIter* _tmp7_ = NULL;
		GtkTextIter _tmp8_ = {0};
		gint _tmp9_ = 0;
		gchar* t = NULL;
		GtkTextBuffer* _tmp10_ = NULL;
		GtkTextIter* _tmp11_ = NULL;
		GtkTextIter* _tmp12_ = NULL;
		GtkTextIter _tmp13_ = {0};
		GtkTextIter _tmp14_ = {0};
		gchar* _tmp15_ = NULL;
		gunichar c = 0U;
		const gchar* _tmp16_ = NULL;
		gunichar _tmp17_ = 0U;
		gboolean _tmp18_ = FALSE;
		gboolean _tmp19_ = FALSE;
		gboolean _tmp20_ = FALSE;
		gunichar _tmp21_ = 0U;
		gboolean _tmp22_ = FALSE;
		GtkTextIter* _tmp26_ = NULL;
		GtkTextIter* _tmp27_ = NULL;
		_tmp6_ = iter1;
		_tmp7_ = word_end;
		_tmp8_ = *_tmp7_;
		_tmp9_ = gtk_text_iter_compare (_tmp6_, &_tmp8_);
		if (!(_tmp9_ < 0)) {
			break;
		}
		_tmp10_ = buffer;
		_tmp11_ = iter1;
		_tmp12_ = iter2;
		_tmp13_ = *_tmp11_;
		_tmp14_ = *_tmp12_;
		_tmp15_ = gtk_text_buffer_get_text (_tmp10_, &_tmp13_, &_tmp14_, FALSE);
		t = _tmp15_;
		_tmp16_ = t;
		_tmp17_ = string_get_char (_tmp16_, (glong) 0);
		c = _tmp17_;
		_tmp21_ = c;
		_tmp22_ = g_unichar_ispunct (_tmp21_);
		if (_tmp22_) {
			gunichar _tmp23_ = 0U;
			_tmp23_ = c;
			_tmp20_ = _tmp23_ != ((gunichar) '_');
		} else {
			_tmp20_ = FALSE;
		}
		if (_tmp20_) {
			_tmp19_ = TRUE;
		} else {
			gunichar _tmp24_ = 0U;
			_tmp24_ = c;
			_tmp19_ = _tmp24_ == ((gunichar) '"');
		}
		if (_tmp19_) {
			_tmp18_ = TRUE;
		} else {
			gunichar _tmp25_ = 0U;
			_tmp25_ = c;
			_tmp18_ = _tmp25_ == 8220U;
		}
		if (_tmp18_) {
			_g_free0 (t);
			break;
		}
		_tmp26_ = iter1;
		gtk_text_iter_forward_char (_tmp26_);
		_tmp27_ = iter2;
		gtk_text_iter_forward_char (_tmp27_);
		_g_free0 (t);
	}
	_tmp28_ = buffer;
	_tmp29_ = word_start;
	_tmp30_ = iter1;
	_tmp31_ = *_tmp29_;
	_tmp32_ = *_tmp30_;
	gtk_text_buffer_apply_tag_by_name (_tmp28_, "mention", &_tmp31_, &_tmp32_);
	_g_free0 (iter2);
	_g_free0 (iter1);
}


/** Invariant: the word passed to this function starts with a # */
void tweet_utils_highlight_hashtag (GtkTextBuffer* buffer, GtkTextIter* word_start, GtkTextIter* word_end) {
	GtkTextIter* iter1 = NULL;
	GtkTextIter* _tmp0_ = NULL;
	GtkTextIter* _tmp1_ = NULL;
	GtkTextIter* iter2 = NULL;
	GtkTextIter* _tmp2_ = NULL;
	GtkTextIter* _tmp3_ = NULL;
	GtkTextIter* _tmp4_ = NULL;
	GtkTextIter* _tmp5_ = NULL;
	GtkTextBuffer* _tmp26_ = NULL;
	GtkTextIter* _tmp27_ = NULL;
	GtkTextIter* _tmp28_ = NULL;
	GtkTextIter _tmp29_ = {0};
	GtkTextIter _tmp30_ = {0};
	g_return_if_fail (GTK_IS_TEXT_BUFFER (buffer));
	_tmp0_ = word_start;
	_tmp1_ = __gtk_text_iter_dup0 (_tmp0_);
	iter1 = _tmp1_;
	_tmp2_ = word_start;
	_tmp3_ = __gtk_text_iter_dup0 (_tmp2_);
	iter2 = _tmp3_;
	_tmp4_ = iter1;
	gtk_text_iter_forward_char (_tmp4_);
	_tmp5_ = iter2;
	gtk_text_iter_forward_chars (_tmp5_, 2);
	while (TRUE) {
		GtkTextIter* _tmp6_ = NULL;
		GtkTextIter* _tmp7_ = NULL;
		GtkTextIter _tmp8_ = {0};
		gint _tmp9_ = 0;
		gchar* t = NULL;
		GtkTextBuffer* _tmp10_ = NULL;
		GtkTextIter* _tmp11_ = NULL;
		GtkTextIter* _tmp12_ = NULL;
		GtkTextIter _tmp13_ = {0};
		GtkTextIter _tmp14_ = {0};
		gchar* _tmp15_ = NULL;
		gunichar c = 0U;
		const gchar* _tmp16_ = NULL;
		gunichar _tmp17_ = 0U;
		gboolean _tmp18_ = FALSE;
		gboolean _tmp19_ = FALSE;
		gunichar _tmp20_ = 0U;
		gboolean _tmp21_ = FALSE;
		GtkTextIter* _tmp24_ = NULL;
		GtkTextIter* _tmp25_ = NULL;
		_tmp6_ = iter1;
		_tmp7_ = word_end;
		_tmp8_ = *_tmp7_;
		_tmp9_ = gtk_text_iter_compare (_tmp6_, &_tmp8_);
		if (!(_tmp9_ < 0)) {
			break;
		}
		_tmp10_ = buffer;
		_tmp11_ = iter1;
		_tmp12_ = iter2;
		_tmp13_ = *_tmp11_;
		_tmp14_ = *_tmp12_;
		_tmp15_ = gtk_text_buffer_get_text (_tmp10_, &_tmp13_, &_tmp14_, FALSE);
		t = _tmp15_;
		_tmp16_ = t;
		_tmp17_ = string_get_char (_tmp16_, (glong) 0);
		c = _tmp17_;
		_tmp20_ = c;
		_tmp21_ = g_unichar_ispunct (_tmp20_);
		if (_tmp21_) {
			gunichar _tmp22_ = 0U;
			_tmp22_ = c;
			_tmp19_ = _tmp22_ != ((gunichar) '_');
		} else {
			_tmp19_ = FALSE;
		}
		if (_tmp19_) {
			_tmp18_ = TRUE;
		} else {
			gunichar _tmp23_ = 0U;
			_tmp23_ = c;
			_tmp18_ = _tmp23_ == 8221U;
		}
		if (_tmp18_) {
			_g_free0 (t);
			break;
		}
		_tmp24_ = iter1;
		gtk_text_iter_forward_char (_tmp24_);
		_tmp25_ = iter2;
		gtk_text_iter_forward_char (_tmp25_);
		_g_free0 (t);
	}
	_tmp26_ = buffer;
	_tmp27_ = word_start;
	_tmp28_ = iter1;
	_tmp29_ = *_tmp27_;
	_tmp30_ = *_tmp28_;
	gtk_text_buffer_apply_tag_by_name (_tmp26_, "hashtag", &_tmp29_, &_tmp30_);
	_g_free0 (iter2);
	_g_free0 (iter1);
}


void tweet_utils_annotate_text (GtkTextBuffer* buffer) {
	GtkTextIter* start_iter = NULL;
	GtkTextIter* cur_iter = NULL;
	GtkTextIter* word_start_iter = NULL;
	GtkTextIter* next_iter = NULL;
	GtkTextBuffer* _tmp0_ = NULL;
	GtkTextIter _tmp1_ = {0};
	GtkTextIter _tmp2_ = {0};
	GtkTextIter* _tmp3_ = NULL;
	GtkTextIter* _tmp4_ = NULL;
	GtkTextIter* _tmp5_ = NULL;
	GtkTextIter* _tmp6_ = NULL;
	GtkTextIter* _tmp7_ = NULL;
	g_return_if_fail (GTK_IS_TEXT_BUFFER (buffer));
	_tmp0_ = buffer;
	gtk_text_buffer_get_start_iter (_tmp0_, &_tmp1_);
	_g_free0 (start_iter);
	_tmp2_ = _tmp1_;
	_tmp3_ = __gtk_text_iter_dup0 (&_tmp2_);
	start_iter = _tmp3_;
	_tmp4_ = start_iter;
	_tmp5_ = __gtk_text_iter_dup0 (_tmp4_);
	_g_free0 (cur_iter);
	cur_iter = _tmp5_;
	_tmp6_ = cur_iter;
	_tmp7_ = __gtk_text_iter_dup0 (_tmp6_);
	_g_free0 (word_start_iter);
	word_start_iter = _tmp7_;
	while (TRUE) {
		GtkTextIter* _tmp8_ = NULL;
		gunichar _tmp9_ = 0U;
		gboolean _tmp10_ = FALSE;
		GtkTextIter* _tmp14_ = NULL;
		GtkTextIter* _tmp15_ = NULL;
		gboolean done = FALSE;
		GtkTextIter* _tmp16_ = NULL;
		gboolean _tmp17_ = FALSE;
		gboolean _tmp18_ = FALSE;
		gboolean _tmp19_ = FALSE;
		gboolean word_end = FALSE;
		gboolean _tmp27_ = FALSE;
		gboolean _tmp49_ = FALSE;
		GtkTextIter* _tmp50_ = NULL;
		GtkTextIter* _tmp51_ = NULL;
		_tmp8_ = cur_iter;
		_tmp9_ = gtk_text_iter_get_char (_tmp8_);
		_tmp10_ = g_unichar_isspace (_tmp9_);
		if (_tmp10_) {
			GtkTextIter* _tmp11_ = NULL;
			GtkTextIter* _tmp12_ = NULL;
			GtkTextIter* _tmp13_ = NULL;
			_tmp11_ = cur_iter;
			_tmp12_ = __gtk_text_iter_dup0 (_tmp11_);
			_g_free0 (word_start_iter);
			word_start_iter = _tmp12_;
			_tmp13_ = word_start_iter;
			gtk_text_iter_forward_char (_tmp13_);
		}
		_tmp14_ = cur_iter;
		_tmp15_ = __gtk_text_iter_dup0 (_tmp14_);
		_g_free0 (next_iter);
		next_iter = _tmp15_;
		_tmp16_ = next_iter;
		_tmp17_ = gtk_text_iter_forward_char (_tmp16_);
		done = !_tmp17_;
		_tmp19_ = done;
		if (_tmp19_) {
			_tmp18_ = TRUE;
		} else {
			gboolean _tmp20_ = FALSE;
			GtkTextIter* _tmp21_ = NULL;
			gunichar _tmp22_ = 0U;
			gboolean _tmp23_ = FALSE;
			_tmp21_ = next_iter;
			_tmp22_ = gtk_text_iter_get_char (_tmp21_);
			_tmp23_ = g_unichar_isspace (_tmp22_);
			if (_tmp23_) {
				GtkTextIter* _tmp24_ = NULL;
				gunichar _tmp25_ = 0U;
				gboolean _tmp26_ = FALSE;
				_tmp24_ = cur_iter;
				_tmp25_ = gtk_text_iter_get_char (_tmp24_);
				_tmp26_ = g_unichar_isspace (_tmp25_);
				_tmp20_ = !_tmp26_;
			} else {
				_tmp20_ = FALSE;
			}
			_tmp18_ = _tmp20_;
		}
		word_end = _tmp18_;
		_tmp27_ = word_end;
		if (_tmp27_) {
			gchar* w = NULL;
			GtkTextBuffer* _tmp28_ = NULL;
			GtkTextIter* _tmp29_ = NULL;
			GtkTextIter* _tmp30_ = NULL;
			GtkTextIter _tmp31_ = {0};
			GtkTextIter _tmp32_ = {0};
			gchar* _tmp33_ = NULL;
			const gchar* _tmp34_ = NULL;
			gboolean _tmp35_ = FALSE;
			_tmp28_ = buffer;
			_tmp29_ = word_start_iter;
			_tmp30_ = next_iter;
			_tmp31_ = *_tmp29_;
			_tmp32_ = *_tmp30_;
			_tmp33_ = gtk_text_buffer_get_text (_tmp28_, &_tmp31_, &_tmp32_, FALSE);
			w = _tmp33_;
			_tmp34_ = w;
			_tmp35_ = tweet_utils_is_link (_tmp34_);
			if (_tmp35_) {
				GtkTextBuffer* _tmp36_ = NULL;
				GtkTextIter* _tmp37_ = NULL;
				GtkTextIter* _tmp38_ = NULL;
				_tmp36_ = buffer;
				_tmp37_ = word_start_iter;
				_tmp38_ = next_iter;
				tweet_utils_highlight_link (_tmp36_, _tmp37_, _tmp38_);
			} else {
				const gchar* _tmp39_ = NULL;
				gboolean _tmp40_ = FALSE;
				_tmp39_ = w;
				_tmp40_ = tweet_utils_is_mention (_tmp39_);
				if (_tmp40_) {
					GtkTextBuffer* _tmp41_ = NULL;
					GtkTextIter* _tmp42_ = NULL;
					GtkTextIter* _tmp43_ = NULL;
					_tmp41_ = buffer;
					_tmp42_ = word_start_iter;
					_tmp43_ = next_iter;
					tweet_utils_highlight_mention (_tmp41_, _tmp42_, _tmp43_);
				} else {
					const gchar* _tmp44_ = NULL;
					gboolean _tmp45_ = FALSE;
					_tmp44_ = w;
					_tmp45_ = tweet_utils_is_hashtag (_tmp44_);
					if (_tmp45_) {
						GtkTextBuffer* _tmp46_ = NULL;
						GtkTextIter* _tmp47_ = NULL;
						GtkTextIter* _tmp48_ = NULL;
						_tmp46_ = buffer;
						_tmp47_ = word_start_iter;
						_tmp48_ = next_iter;
						tweet_utils_highlight_hashtag (_tmp46_, _tmp47_, _tmp48_);
					}
				}
			}
			_g_free0 (w);
		}
		_tmp49_ = done;
		if (_tmp49_) {
			break;
		}
		_tmp50_ = next_iter;
		_tmp51_ = __gtk_text_iter_dup0 (_tmp50_);
		_g_free0 (cur_iter);
		cur_iter = _tmp51_;
	}
	_g_free0 (next_iter);
	_g_free0 (word_start_iter);
	_g_free0 (cur_iter);
	_g_free0 (start_iter);
}


static void _vala_JsonNode_free (JsonNode* self) {
	g_boxed_free (json_node_get_type (), self);
}


static void tweet_utils_load_threaded_data_free (gpointer _data) {
	TweetUtilsLoadThreadedData* _data_;
	_data_ = _data;
	__vala_JsonNode_free0 (_data_->result);
	g_slice_free (TweetUtilsLoadThreadedData, _data_);
}


void tweet_utils_load_threaded (RestProxyCall* call, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TweetUtilsLoadThreadedData* _data_;
	RestProxyCall* _tmp0_ = NULL;
	RestProxyCall* _tmp1_ = NULL;
	_data_ = g_slice_new0 (TweetUtilsLoadThreadedData);
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, tweet_utils_load_threaded);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tweet_utils_load_threaded_data_free);
	_tmp0_ = call;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data_->call);
	_data_->call = _tmp1_;
	tweet_utils_load_threaded_co (_data_);
}


JsonNode* tweet_utils_load_threaded_finish (GAsyncResult* _res_) {
	JsonNode* result;
	TweetUtilsLoadThreadedData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static Block56Data* block56_data_ref (Block56Data* _data56_) {
	g_atomic_int_inc (&_data56_->_ref_count_);
	return _data56_;
}


static void block56_data_unref (void * _userdata_) {
	Block56Data* _data56_;
	_data56_ = (Block56Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data56_->_ref_count_)) {
		(_data56_->callback_target_destroy_notify == NULL) ? NULL : (_data56_->callback_target_destroy_notify (_data56_->callback_target), NULL);
		_data56_->callback = NULL;
		_data56_->callback_target = NULL;
		_data56_->callback_target_destroy_notify = NULL;
		__vala_JsonNode_free0 (_data56_->_result_);
		_g_object_unref0 (_data56_->call);
		g_slice_free (Block56Data, _data56_);
	}
}


static gboolean _tweet_utils_load_threaded_co_gsource_func (gpointer self) {
	gboolean result;
	result = tweet_utils_load_threaded_co (self);
	return result;
}


static void tweet_utils_load_threaded_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TweetUtilsLoadThreadedData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	tweet_utils_load_threaded_co (_data_);
}


static JsonNode* _vala_JsonNode_copy (JsonNode* self) {
	return g_boxed_copy (json_node_get_type (), self);
}


static gpointer __vala_JsonNode_copy0 (gpointer self) {
	return self ? _vala_JsonNode_copy (self) : NULL;
}


static gboolean __lambda17_ (Block56Data* _data56_) {
	gboolean result = FALSE;
	GSourceFunc _tmp0_ = NULL;
	void* _tmp0__target = NULL;
	_tmp0_ = _data56_->callback;
	_tmp0__target = _data56_->callback_target;
	_tmp0_ (_tmp0__target);
	result = FALSE;
	return result;
}


static gboolean ___lambda17__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda17_ (self);
	return result;
}


static void* __lambda16_ (Block56Data* _data56_) {
	void* result = NULL;
	JsonParser* parser = NULL;
	JsonParser* _tmp0_ = NULL;
	JsonParser* _tmp6_ = NULL;
	JsonNode* _tmp7_ = NULL;
	JsonNode* _tmp8_ = NULL;
	GError * _inner_error_ = NULL;
	_tmp0_ = json_parser_new ();
	parser = _tmp0_;
	{
		JsonParser* _tmp1_ = NULL;
		RestProxyCall* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		_tmp1_ = parser;
		_tmp2_ = _data56_->call;
		_tmp3_ = rest_proxy_call_get_payload (_tmp2_);
		json_parser_load_from_data (_tmp1_, _tmp3_, (gssize) (-1), &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch68_g_error;
		}
	}
	goto __finally68;
	__catch68_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_warning ("TweetUtils.vala:631: %s", _tmp5_);
		result = NULL;
		_g_error_free0 (e);
		_g_object_unref0 (parser);
		return result;
	}
	__finally68:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (parser);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp6_ = parser;
	_tmp7_ = json_parser_get_root (_tmp6_);
	_tmp8_ = __vala_JsonNode_copy0 (_tmp7_);
	__vala_JsonNode_free0 (_data56_->_result_);
	_data56_->_result_ = _tmp8_;
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda17__gsource_func, block56_data_ref (_data56_), block56_data_unref);
	result = NULL;
	_g_object_unref0 (parser);
	return result;
}


static gpointer ___lambda16__gthread_func (gpointer self) {
	gpointer result;
	result = __lambda16_ (self);
	block56_data_unref (self);
	return result;
}


static gboolean tweet_utils_load_threaded_co (TweetUtilsLoadThreadedData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data56_ = g_slice_new0 (Block56Data);
	_data_->_data56_->_ref_count_ = 1;
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->call;
	_g_object_unref0 (_data_->_data56_->call);
	_data_->_data56_->call = _data_->_tmp0_;
	_data_->_data56_->_async_data_ = _data_;
	_data_->_data56_->_result_ = NULL;
	_data_->_data56_->callback = _tweet_utils_load_threaded_co_gsource_func;
	_data_->_data56_->callback_target = _data_;
	_data_->_data56_->callback_target_destroy_notify = NULL;
	{
		_data_->_tmp1_ = NULL;
		_data_->_tmp1_ = _data_->_data56_->call;
		_data_->_state_ = 1;
		rest_proxy_call_invoke_async (_data_->_tmp1_, NULL, tweet_utils_load_threaded_ready, _data_);
		return FALSE;
		_state_1:
		rest_proxy_call_invoke_finish (_data_->_tmp1_, _data_->_res_, &_data_->_inner_error_);
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			goto __catch67_g_error;
		}
	}
	goto __finally67;
	__catch67_g_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp2_ = NULL;
		_data_->_tmp2_ = _data_->e;
		_data_->_tmp3_ = NULL;
		_data_->_tmp3_ = _data_->_tmp2_->message;
		g_warning ("TweetUtils.vala:615: %s", _data_->_tmp3_);
		_data_->result = NULL;
		_g_error_free0 (_data_->e);
		block56_data_unref (_data_->_data56_);
		_data_->_data56_ = NULL;
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally67:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		block56_data_unref (_data_->_data56_);
		_data_->_data56_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = g_thread_new ("json parser", ___lambda16__gthread_func, block56_data_ref (_data_->_data56_));
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = _data_->_tmp4_;
	_g_thread_unref0 (_data_->_tmp5_);
	_data_->_state_ = 2;
	return FALSE;
	_state_2:
	;
	_data_->_tmp6_ = NULL;
	_data_->_tmp6_ = _data_->_data56_->_result_;
	_data_->_tmp7_ = NULL;
	_data_->_tmp7_ = __vala_JsonNode_copy0 (_data_->_tmp6_);
	_data_->result = _data_->_tmp7_;
	block56_data_unref (_data_->_data56_);
	_data_->_data56_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	block56_data_unref (_data_->_data56_);
	_data_->_data56_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



