/* SelectStatement.c generated by valac 0.26.2, the Vala compiler
 * generated from SelectStatement.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <sqlite3.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#include <gobject/gvaluecollector.h>


#define SQL_TYPE_ISTATEMENT (sql_istatement_get_type ())
#define SQL_ISTATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SQL_TYPE_ISTATEMENT, SqlIStatement))
#define SQL_IS_ISTATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SQL_TYPE_ISTATEMENT))
#define SQL_ISTATEMENT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SQL_TYPE_ISTATEMENT, SqlIStatementIface))

typedef struct _SqlIStatement SqlIStatement;
typedef struct _SqlIStatementIface SqlIStatementIface;

#define SQL_TYPE_SELECT_STATEMENT (sql_select_statement_get_type ())
#define SQL_SELECT_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SQL_TYPE_SELECT_STATEMENT, SqlSelectStatement))
#define SQL_SELECT_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SQL_TYPE_SELECT_STATEMENT, SqlSelectStatementClass))
#define SQL_IS_SELECT_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SQL_TYPE_SELECT_STATEMENT))
#define SQL_IS_SELECT_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SQL_TYPE_SELECT_STATEMENT))
#define SQL_SELECT_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SQL_TYPE_SELECT_STATEMENT, SqlSelectStatementClass))

typedef struct _SqlSelectStatement SqlSelectStatement;
typedef struct _SqlSelectStatementClass SqlSelectStatementClass;
typedef struct _SqlSelectStatementPrivate SqlSelectStatementPrivate;
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _sqlite3_finalize0(var) ((var == NULL) ? NULL : (var = (sqlite3_finalize (var), NULL)))
typedef struct _Block82Data Block82Data;
#define _sql_select_statement_unref0(var) ((var == NULL) ? NULL : (var = (sql_select_statement_unref (var), NULL)))
typedef struct _SqlParamSpecSelectStatement SqlParamSpecSelectStatement;

struct _SqlIStatementIface {
	GTypeInterface parent_iface;
	sqlite3* (*get_db) (SqlIStatement* self);
	void (*set_db) (SqlIStatement* self, sqlite3* value);
};

struct _SqlSelectStatement {
	GTypeInstance parent_instance;
	volatile int ref_count;
	SqlSelectStatementPrivate * priv;
};

struct _SqlSelectStatementClass {
	GTypeClass parent_class;
	void (*finalize) (SqlSelectStatement *self);
};

struct _SqlSelectStatementPrivate {
	sqlite3* _db;
	GString* query_builder;
	gchar* table_name;
};

typedef gboolean (*SqlSelectCallback) (gchar** vals, int vals_length1, void* user_data);
struct _Block82Data {
	int _ref_count_;
	SqlSelectStatement* self;
	gint64 back;
};

struct _SqlParamSpecSelectStatement {
	GParamSpec parent_instance;
};


static gpointer sql_select_statement_parent_class = NULL;
static SqlIStatementIface* sql_select_statement_sql_istatement_parent_iface = NULL;

GType sql_istatement_get_type (void) G_GNUC_CONST;
gpointer sql_select_statement_ref (gpointer instance);
void sql_select_statement_unref (gpointer instance);
GParamSpec* sql_param_spec_select_statement (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void sql_value_set_select_statement (GValue* value, gpointer v_object);
void sql_value_take_select_statement (GValue* value, gpointer v_object);
gpointer sql_value_get_select_statement (const GValue* value);
GType sql_select_statement_get_type (void) G_GNUC_CONST;
#define SQL_SELECT_STATEMENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SQL_TYPE_SELECT_STATEMENT, SqlSelectStatementPrivate))
enum  {
	SQL_SELECT_STATEMENT_DUMMY_PROPERTY
};
SqlSelectStatement* sql_select_statement_new (const gchar* table_name);
SqlSelectStatement* sql_select_statement_construct (GType object_type, const gchar* table_name);
SqlSelectStatement* sql_select_statement_cols (SqlSelectStatement* self, const gchar* first, ...);
SqlSelectStatement* sql_select_statement_where (SqlSelectStatement* self, const gchar* stmt);
SqlSelectStatement* sql_select_statement_where_eqi (SqlSelectStatement* self, const gchar* w, gint64 v);
SqlSelectStatement* sql_select_statement_order (SqlSelectStatement* self, const gchar* order_by);
SqlSelectStatement* sql_select_statement_limit (SqlSelectStatement* self, gint limit);
gint sql_select_statement_run (SqlSelectStatement* self, SqlSelectCallback callback, void* callback_target);
sqlite3* sql_istatement_get_db (SqlIStatement* self);
gint64 sql_select_statement_once_i64 (SqlSelectStatement* self);
static Block82Data* block82_data_ref (Block82Data* _data82_);
static void block82_data_unref (void * _userdata_);
static gboolean __lambda6_ (Block82Data* _data82_, gchar** vals, int vals_length1);
static gboolean ___lambda6__sql_select_callback (gchar** vals, int vals_length1, gpointer self);
static void sql_select_statement_finalize (SqlSelectStatement* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


SqlSelectStatement* sql_select_statement_construct (GType object_type, const gchar* table_name) {
	SqlSelectStatement* self = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (table_name != NULL, NULL);
	self = (SqlSelectStatement*) g_type_create_instance (object_type);
	_tmp0_ = table_name;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->table_name);
	self->priv->table_name = _tmp1_;
	return self;
}


SqlSelectStatement* sql_select_statement_new (const gchar* table_name) {
	return sql_select_statement_construct (SQL_TYPE_SELECT_STATEMENT, table_name);
}


static gpointer _sql_select_statement_ref0 (gpointer self) {
	return self ? sql_select_statement_ref (self) : NULL;
}


SqlSelectStatement* sql_select_statement_cols (SqlSelectStatement* self, const gchar* first, ...) {
	SqlSelectStatement* result = NULL;
	va_list arg_list = {0};
	GString* _tmp0_ = NULL;
	GString* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	GString* _tmp3_ = NULL;
	GString* _tmp14_ = NULL;
	GString* _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
	GString* _tmp17_ = NULL;
	SqlSelectStatement* _tmp18_ = NULL;
	g_return_val_if_fail (SQL_IS_SELECT_STATEMENT (self), NULL);
	g_return_val_if_fail (first != NULL, NULL);
	va_start (arg_list, first);
	_tmp0_ = self->priv->query_builder;
	_tmp1_ = g_string_append (_tmp0_, "SELECT `");
	_tmp2_ = first;
	_tmp3_ = g_string_append (_tmp1_, _tmp2_);
	g_string_append (_tmp3_, "`");
	{
		gchar* arg = NULL;
		const gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		_tmp4_ = va_arg (arg_list, gchar*);
		_tmp5_ = g_strdup (_tmp4_);
		arg = _tmp5_;
		{
			gboolean _tmp6_ = FALSE;
			_tmp6_ = TRUE;
			while (TRUE) {
				const gchar* _tmp9_ = NULL;
				GString* _tmp10_ = NULL;
				GString* _tmp11_ = NULL;
				const gchar* _tmp12_ = NULL;
				GString* _tmp13_ = NULL;
				if (!_tmp6_) {
					const gchar* _tmp7_ = NULL;
					gchar* _tmp8_ = NULL;
					_tmp7_ = va_arg (arg_list, gchar*);
					_tmp8_ = g_strdup (_tmp7_);
					_g_free0 (arg);
					arg = _tmp8_;
				}
				_tmp6_ = FALSE;
				_tmp9_ = arg;
				if (!(_tmp9_ != NULL)) {
					break;
				}
				_tmp10_ = self->priv->query_builder;
				_tmp11_ = g_string_append (_tmp10_, ", `");
				_tmp12_ = arg;
				_tmp13_ = g_string_append (_tmp11_, _tmp12_);
				g_string_append (_tmp13_, "`");
			}
		}
		_g_free0 (arg);
	}
	_tmp14_ = self->priv->query_builder;
	_tmp15_ = g_string_append (_tmp14_, " FROM `");
	_tmp16_ = self->priv->table_name;
	_tmp17_ = g_string_append (_tmp15_, _tmp16_);
	g_string_append (_tmp17_, "`");
	_tmp18_ = _sql_select_statement_ref0 (self);
	result = _tmp18_;
	va_end (arg_list);
	return result;
}


SqlSelectStatement* sql_select_statement_where (SqlSelectStatement* self, const gchar* stmt) {
	SqlSelectStatement* result = NULL;
	GString* _tmp0_ = NULL;
	GString* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	SqlSelectStatement* _tmp3_ = NULL;
	g_return_val_if_fail (SQL_IS_SELECT_STATEMENT (self), NULL);
	g_return_val_if_fail (stmt != NULL, NULL);
	_tmp0_ = self->priv->query_builder;
	_tmp1_ = g_string_append (_tmp0_, " WHERE ");
	_tmp2_ = stmt;
	g_string_append (_tmp1_, _tmp2_);
	_tmp3_ = _sql_select_statement_ref0 (self);
	result = _tmp3_;
	return result;
}


SqlSelectStatement* sql_select_statement_where_eqi (SqlSelectStatement* self, const gchar* w, gint64 v) {
	SqlSelectStatement* result = NULL;
	GString* _tmp0_ = NULL;
	GString* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	GString* _tmp3_ = NULL;
	GString* _tmp4_ = NULL;
	gint64 _tmp5_ = 0LL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	GString* _tmp8_ = NULL;
	SqlSelectStatement* _tmp9_ = NULL;
	g_return_val_if_fail (SQL_IS_SELECT_STATEMENT (self), NULL);
	g_return_val_if_fail (w != NULL, NULL);
	_tmp0_ = self->priv->query_builder;
	_tmp1_ = g_string_append (_tmp0_, " WHERE `");
	_tmp2_ = w;
	_tmp3_ = g_string_append (_tmp1_, _tmp2_);
	_tmp4_ = g_string_append (_tmp3_, "`='");
	_tmp5_ = v;
	_tmp6_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_string_append (_tmp4_, _tmp7_);
	g_string_append (_tmp8_, "'");
	_g_free0 (_tmp7_);
	_tmp9_ = _sql_select_statement_ref0 (self);
	result = _tmp9_;
	return result;
}


SqlSelectStatement* sql_select_statement_order (SqlSelectStatement* self, const gchar* order_by) {
	SqlSelectStatement* result = NULL;
	GString* _tmp0_ = NULL;
	GString* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	SqlSelectStatement* _tmp3_ = NULL;
	g_return_val_if_fail (SQL_IS_SELECT_STATEMENT (self), NULL);
	g_return_val_if_fail (order_by != NULL, NULL);
	_tmp0_ = self->priv->query_builder;
	_tmp1_ = g_string_append (_tmp0_, " ORDER BY ");
	_tmp2_ = order_by;
	g_string_append (_tmp1_, _tmp2_);
	_tmp3_ = _sql_select_statement_ref0 (self);
	result = _tmp3_;
	return result;
}


SqlSelectStatement* sql_select_statement_limit (SqlSelectStatement* self, gint limit) {
	SqlSelectStatement* result = NULL;
	GString* _tmp0_ = NULL;
	GString* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	SqlSelectStatement* _tmp5_ = NULL;
	g_return_val_if_fail (SQL_IS_SELECT_STATEMENT (self), NULL);
	_tmp0_ = self->priv->query_builder;
	_tmp1_ = g_string_append (_tmp0_, " LIMIT ");
	_tmp2_ = limit;
	_tmp3_ = g_strdup_printf ("%i", _tmp2_);
	_tmp4_ = _tmp3_;
	g_string_append (_tmp1_, _tmp4_);
	_g_free0 (_tmp4_);
	_tmp5_ = _sql_select_statement_ref0 (self);
	result = _tmp5_;
	return result;
}


gint sql_select_statement_run (SqlSelectStatement* self, SqlSelectCallback callback, void* callback_target) {
	gint result = 0;
	sqlite3_stmt* stmt = NULL;
	gint ok = 0;
	sqlite3* _tmp0_ = NULL;
	sqlite3* _tmp1_ = NULL;
	GString* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	sqlite3_stmt* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gboolean next = FALSE;
	gint n_cols = 0;
	sqlite3_stmt* _tmp12_ = NULL;
	gint _tmp13_ = 0;
	gint n_rows = 0;
	g_return_val_if_fail (SQL_IS_SELECT_STATEMENT (self), 0);
	_tmp0_ = sql_istatement_get_db (G_TYPE_CHECK_INSTANCE_CAST (self, SQL_TYPE_ISTATEMENT, SqlIStatement));
	_tmp1_ = _tmp0_;
	_tmp2_ = self->priv->query_builder;
	_tmp3_ = _tmp2_->str;
	_tmp5_ = sqlite3_prepare_v2 (_tmp1_, _tmp3_, -1, &_tmp4_, NULL);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp4_;
	ok = _tmp5_;
	_tmp6_ = ok;
	if (_tmp6_ != SQLITE_OK) {
		sqlite3* _tmp7_ = NULL;
		sqlite3* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		GString* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
		_tmp7_ = sql_istatement_get_db (G_TYPE_CHECK_INSTANCE_CAST (self, SQL_TYPE_ISTATEMENT, SqlIStatement));
		_tmp8_ = _tmp7_;
		_tmp9_ = sqlite3_errmsg (_tmp8_);
		g_critical ("SelectStatement.vala:61: %s", _tmp9_);
		_tmp10_ = self->priv->query_builder;
		_tmp11_ = _tmp10_->str;
		g_critical ("SelectStatement.vala:62: %s", _tmp11_);
		result = 0;
		_sqlite3_finalize0 (stmt);
		return result;
	}
	next = TRUE;
	_tmp12_ = stmt;
	_tmp13_ = sqlite3_column_count (_tmp12_);
	n_cols = _tmp13_;
	n_rows = 0;
	while (TRUE) {
		gboolean _tmp14_ = FALSE;
		sqlite3_stmt* _tmp15_ = NULL;
		gint _tmp16_ = 0;
		gchar** vals = NULL;
		gint _tmp18_ = 0;
		gchar** _tmp19_ = NULL;
		gint vals_length1 = 0;
		gint _vals_size_ = 0;
		SqlSelectCallback _tmp31_ = NULL;
		void* _tmp31__target = NULL;
		gchar** _tmp32_ = NULL;
		gint _tmp32__length1 = 0;
		gboolean _tmp33_ = FALSE;
		gint _tmp34_ = 0;
		_tmp15_ = stmt;
		_tmp16_ = sqlite3_step (_tmp15_);
		if (_tmp16_ == SQLITE_ROW) {
			gboolean _tmp17_ = FALSE;
			_tmp17_ = next;
			_tmp14_ = _tmp17_;
		} else {
			_tmp14_ = FALSE;
		}
		if (!_tmp14_) {
			break;
		}
		_tmp18_ = n_cols;
		_tmp19_ = g_new0 (gchar*, _tmp18_ + 1);
		vals = _tmp19_;
		vals_length1 = _tmp18_;
		_vals_size_ = vals_length1;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp20_ = FALSE;
				_tmp20_ = TRUE;
				while (TRUE) {
					gint _tmp22_ = 0;
					gint _tmp23_ = 0;
					gchar** _tmp24_ = NULL;
					gint _tmp24__length1 = 0;
					gint _tmp25_ = 0;
					sqlite3_stmt* _tmp26_ = NULL;
					gint _tmp27_ = 0;
					const gchar* _tmp28_ = NULL;
					gchar* _tmp29_ = NULL;
					gchar* _tmp30_ = NULL;
					if (!_tmp20_) {
						gint _tmp21_ = 0;
						_tmp21_ = i;
						i = _tmp21_ + 1;
					}
					_tmp20_ = FALSE;
					_tmp22_ = i;
					_tmp23_ = n_cols;
					if (!(_tmp22_ < _tmp23_)) {
						break;
					}
					_tmp24_ = vals;
					_tmp24__length1 = vals_length1;
					_tmp25_ = i;
					_tmp26_ = stmt;
					_tmp27_ = i;
					_tmp28_ = sqlite3_column_text (_tmp26_, _tmp27_);
					_tmp29_ = g_strdup (_tmp28_);
					_g_free0 (_tmp24_[_tmp25_]);
					_tmp24_[_tmp25_] = _tmp29_;
					_tmp30_ = _tmp24_[_tmp25_];
				}
			}
		}
		_tmp31_ = callback;
		_tmp31__target = callback_target;
		_tmp32_ = vals;
		_tmp32__length1 = vals_length1;
		_tmp33_ = _tmp31_ (_tmp32_, _tmp32__length1, _tmp31__target);
		next = _tmp33_;
		_tmp34_ = n_rows;
		n_rows = _tmp34_ + 1;
		vals = (_vala_array_free (vals, vals_length1, (GDestroyNotify) g_free), NULL);
	}
	result = n_rows;
	_sqlite3_finalize0 (stmt);
	return result;
}


static Block82Data* block82_data_ref (Block82Data* _data82_) {
	g_atomic_int_inc (&_data82_->_ref_count_);
	return _data82_;
}


static void block82_data_unref (void * _userdata_) {
	Block82Data* _data82_;
	_data82_ = (Block82Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data82_->_ref_count_)) {
		SqlSelectStatement* self;
		self = _data82_->self;
		_sql_select_statement_unref0 (self);
		g_slice_free (Block82Data, _data82_);
	}
}


static gint64 int64_parse (const gchar* str) {
	gint64 result = 0LL;
	const gchar* _tmp0_ = NULL;
	gint64 _tmp1_ = 0LL;
	g_return_val_if_fail (str != NULL, 0LL);
	_tmp0_ = str;
	_tmp1_ = g_ascii_strtoll (_tmp0_, NULL, (guint) 0);
	result = _tmp1_;
	return result;
}


static gboolean __lambda6_ (Block82Data* _data82_, gchar** vals, int vals_length1) {
	SqlSelectStatement* self;
	gboolean result = FALSE;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	const gchar* _tmp1_ = NULL;
	gint64 _tmp2_ = 0LL;
	self = _data82_->self;
	_tmp0_ = vals;
	_tmp0__length1 = vals_length1;
	_tmp1_ = _tmp0_[0];
	_tmp2_ = int64_parse (_tmp1_);
	_data82_->back = _tmp2_;
	result = FALSE;
	return result;
}


static gboolean ___lambda6__sql_select_callback (gchar** vals, int vals_length1, gpointer self) {
	gboolean result;
	result = __lambda6_ (self, vals, vals_length1);
	return result;
}


gint64 sql_select_statement_once_i64 (SqlSelectStatement* self) {
	gint64 result = 0LL;
	Block82Data* _data82_;
	g_return_val_if_fail (SQL_IS_SELECT_STATEMENT (self), 0LL);
	_data82_ = g_slice_new0 (Block82Data);
	_data82_->_ref_count_ = 1;
	_data82_->self = sql_select_statement_ref (self);
	_data82_->back = (gint64) (-1);
	sql_select_statement_run (self, ___lambda6__sql_select_callback, _data82_);
	result = _data82_->back;
	block82_data_unref (_data82_);
	_data82_ = NULL;
	return result;
}


static sqlite3* sql_select_statement_real_get_db (SqlIStatement* base) {
	sqlite3* result;
	SqlSelectStatement* self;
	sqlite3* _tmp0_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, SQL_TYPE_SELECT_STATEMENT, SqlSelectStatement);
	_tmp0_ = self->priv->_db;
	result = _tmp0_;
	return result;
}


static void sql_select_statement_real_set_db (SqlIStatement* base, sqlite3* value) {
	SqlSelectStatement* self;
	sqlite3* _tmp0_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, SQL_TYPE_SELECT_STATEMENT, SqlSelectStatement);
	_tmp0_ = value;
	self->priv->_db = _tmp0_;
}


static void sql_value_select_statement_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void sql_value_select_statement_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		sql_select_statement_unref (value->data[0].v_pointer);
	}
}


static void sql_value_select_statement_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = sql_select_statement_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer sql_value_select_statement_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* sql_value_select_statement_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		SqlSelectStatement* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = sql_select_statement_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* sql_value_select_statement_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	SqlSelectStatement** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = sql_select_statement_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* sql_param_spec_select_statement (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	SqlParamSpecSelectStatement* spec;
	g_return_val_if_fail (g_type_is_a (object_type, SQL_TYPE_SELECT_STATEMENT), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer sql_value_get_select_statement (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SQL_TYPE_SELECT_STATEMENT), NULL);
	return value->data[0].v_pointer;
}


void sql_value_set_select_statement (GValue* value, gpointer v_object) {
	SqlSelectStatement* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SQL_TYPE_SELECT_STATEMENT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, SQL_TYPE_SELECT_STATEMENT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		sql_select_statement_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		sql_select_statement_unref (old);
	}
}


void sql_value_take_select_statement (GValue* value, gpointer v_object) {
	SqlSelectStatement* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SQL_TYPE_SELECT_STATEMENT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, SQL_TYPE_SELECT_STATEMENT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		sql_select_statement_unref (old);
	}
}


static void sql_select_statement_class_init (SqlSelectStatementClass * klass) {
	sql_select_statement_parent_class = g_type_class_peek_parent (klass);
	((SqlSelectStatementClass *) klass)->finalize = sql_select_statement_finalize;
	g_type_class_add_private (klass, sizeof (SqlSelectStatementPrivate));
}


static void sql_select_statement_sql_istatement_interface_init (SqlIStatementIface * iface) {
	sql_select_statement_sql_istatement_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_db = sql_select_statement_real_get_db;
	iface->set_db = sql_select_statement_real_set_db;
}


static void sql_select_statement_instance_init (SqlSelectStatement * self) {
	GString* _tmp0_ = NULL;
	self->priv = SQL_SELECT_STATEMENT_GET_PRIVATE (self);
	_tmp0_ = g_string_new ("");
	self->priv->query_builder = _tmp0_;
	self->ref_count = 1;
}


static void sql_select_statement_finalize (SqlSelectStatement* obj) {
	SqlSelectStatement * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SQL_TYPE_SELECT_STATEMENT, SqlSelectStatement);
	g_signal_handlers_destroy (self);
	_g_string_free0 (self->priv->query_builder);
	_g_free0 (self->priv->table_name);
}


GType sql_select_statement_get_type (void) {
	static volatile gsize sql_select_statement_type_id__volatile = 0;
	if (g_once_init_enter (&sql_select_statement_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { sql_value_select_statement_init, sql_value_select_statement_free_value, sql_value_select_statement_copy_value, sql_value_select_statement_peek_pointer, "p", sql_value_select_statement_collect_value, "p", sql_value_select_statement_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (SqlSelectStatementClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sql_select_statement_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SqlSelectStatement), 0, (GInstanceInitFunc) sql_select_statement_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		static const GInterfaceInfo sql_istatement_info = { (GInterfaceInitFunc) sql_select_statement_sql_istatement_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType sql_select_statement_type_id;
		sql_select_statement_type_id = g_type_register_fundamental (g_type_fundamental_next (), "SqlSelectStatement", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_type_add_interface_static (sql_select_statement_type_id, SQL_TYPE_ISTATEMENT, &sql_istatement_info);
		g_once_init_leave (&sql_select_statement_type_id__volatile, sql_select_statement_type_id);
	}
	return sql_select_statement_type_id__volatile;
}


gpointer sql_select_statement_ref (gpointer instance) {
	SqlSelectStatement* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void sql_select_statement_unref (gpointer instance) {
	SqlSelectStatement* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		SQL_SELECT_STATEMENT_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



