/* Twitter.c generated by valac 0.26.2, the Vala compiler
 * generated from Twitter.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gio/gio.h>


#define TYPE_TWITTER (twitter_get_type ())
#define TWITTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWITTER, Twitter))
#define TWITTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWITTER, TwitterClass))
#define IS_TWITTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWITTER))
#define IS_TWITTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWITTER))
#define TWITTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWITTER, TwitterClass))

typedef struct _Twitter Twitter;
typedef struct _TwitterClass TwitterClass;
typedef struct _TwitterPrivate TwitterPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block22Data Block22Data;
typedef struct _Block23Data Block23Data;

struct _Twitter {
	GObject parent_instance;
	TwitterPrivate * priv;
	GeeHashMap* avatars;
};

struct _TwitterClass {
	GObjectClass parent_class;
};

typedef void (*TwitterAvatarDownloadedFunc) (GdkPixbuf* avatar, void* user_data);
struct _Block22Data {
	int _ref_count_;
	Twitter* self;
	gchar* url;
	TwitterAvatarDownloadedFunc func;
	gpointer func_target;
	GDestroyNotify func_target_destroy_notify;
};

struct _Block23Data {
	int _ref_count_;
	Block22Data * _data22_;
	gulong handler_id;
};


static gpointer twitter_parent_class = NULL;
static Twitter* twitter_twitter;
static Twitter* twitter_twitter = NULL;
static gint twitter__short_url_length;
static gint twitter__short_url_length = 22;
static gint twitter__short_url_length_https;
static gint twitter__short_url_length_https = 23;
static gint twitter__max_media_per_upload;
static gint twitter__max_media_per_upload = 4;
extern GdkPixbuf* twitter_no_avatar;
GdkPixbuf* twitter_no_avatar = NULL;
extern GdkPixbuf* twitter_no_banner;
GdkPixbuf* twitter_no_banner = NULL;

GType twitter_get_type (void) G_GNUC_CONST;
enum  {
	TWITTER_DUMMY_PROPERTY
};
Twitter* twitter_get (void);
Twitter* twitter_new (void);
Twitter* twitter_construct (GType object_type);
void twitter_init (Twitter* self);
GdkPixbuf* twitter_get_avatar (Twitter* self, const gchar* url, TwitterAvatarDownloadedFunc func, void* func_target, GDestroyNotify func_target_destroy_notify);
static Block22Data* block22_data_ref (Block22Data* _data22_);
static void block22_data_unref (void * _userdata_);
gchar* utils_get_avatar_name (const gchar* path);
gchar* dirs_cache (const gchar* path);
static Block23Data* block23_data_ref (Block23Data* _data23_);
static void block23_data_unref (void * _userdata_);
static void ___lambda25_ (Block23Data* _data23_, GdkPixbuf* ava);
static void ____lambda25__twitter_avatar_downloaded (Twitter* _sender, GdkPixbuf* avatar, gpointer self);
void tweet_utils_download_avatar (const gchar* avatar_url, GAsyncReadyCallback _callback_, gpointer _user_data_);
GdkPixbuf* tweet_utils_download_avatar_finish (GAsyncResult* _res_, GError** error);
static void ___lambda27_ (Block22Data* _data22_, GObject* obj, GAsyncResult* res);
static void ____lambda27__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
gint twitter_get_short_url_length (void);
static void twitter_set_short_url_length (gint value);
gint twitter_get_short_url_length_https (void);
static void twitter_set_short_url_length_https (gint value);
gint twitter_get_max_media_per_upload (void);
static void twitter_set_max_media_per_upload (gint value);
static void twitter_finalize (GObject* obj);
static void _vala_twitter_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_twitter_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


Twitter* twitter_get (void) {
	Twitter* result = NULL;
	Twitter* _tmp0_ = NULL;
	Twitter* _tmp2_ = NULL;
	Twitter* _tmp3_ = NULL;
	_tmp0_ = twitter_twitter;
	if (_tmp0_ == NULL) {
		Twitter* _tmp1_ = NULL;
		_tmp1_ = twitter_new ();
		_g_object_unref0 (twitter_twitter);
		twitter_twitter = _tmp1_;
	}
	_tmp2_ = twitter_twitter;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}


Twitter* twitter_construct (GType object_type) {
	Twitter * self = NULL;
	self = (Twitter*) g_object_new (object_type, NULL);
	return self;
}


Twitter* twitter_new (void) {
	return twitter_construct (TYPE_TWITTER);
}


void twitter_init (Twitter* self) {
	GeeHashMap* _tmp7_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (IS_TWITTER (self));
	{
		GdkPixbuf* _tmp0_ = NULL;
		GdkPixbuf* _tmp1_ = NULL;
		GdkPixbuf* _tmp2_ = NULL;
		GdkPixbuf* _tmp3_ = NULL;
		GdkPixbuf* _tmp4_ = NULL;
		GdkPixbuf* _tmp5_ = NULL;
		_tmp1_ = gdk_pixbuf_new_from_resource ("/org/baedert/corebird/assets/no_avatar.png", &_inner_error_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch25_g_error;
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (twitter_no_avatar);
		twitter_no_avatar = _tmp2_;
		_tmp4_ = gdk_pixbuf_new_from_resource ("/org/baedert/corebird/assets/no_banner.png", &_inner_error_);
		_tmp3_ = _tmp4_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (_tmp0_);
			goto __catch25_g_error;
		}
		_tmp5_ = _tmp3_;
		_tmp3_ = NULL;
		_g_object_unref0 (twitter_no_banner);
		twitter_no_banner = _tmp5_;
		_g_object_unref0 (_tmp3_);
		_g_object_unref0 (_tmp0_);
	}
	goto __finally25;
	__catch25_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp6_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp6_ = e->message;
		g_error ("Twitter.vala:46: Error while loading assets: %s", _tmp6_);
		_g_error_free0 (e);
	}
	__finally25:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp7_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, GDK_TYPE_PIXBUF, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->avatars);
	self->avatars = _tmp7_;
}


/**
   * Get the avatar with the given url. If the avatar exists on the
   * hard drive already, it is loaded and returned immediately. If
   * the avatar is in memory already, that version is returned.
   * If the avatar is neither on disk nor in memory, it will be downladed
   * first and set via the supplied `func`.
   *
   * Example usage:
   *
   * Gdk.Pixbuf? a = get_avatar("http://foo", (avatar) => {
   *   a = avatar;
   * });
   * (a may be null here)
   *
   * @param url The url of the avatar to return
   * @param func The AvatarDownloadedFunc to call once the avatar has been
   *             downloaded successfully.
   *
   * @return The requested avatar if it was already downloaded/in ram, or null
   *         if it has to be downloaded first, in which case the AvatarDownloadedFunc
   *         will be called after that's finished.
   */
static Block22Data* block22_data_ref (Block22Data* _data22_) {
	g_atomic_int_inc (&_data22_->_ref_count_);
	return _data22_;
}


static void block22_data_unref (void * _userdata_) {
	Block22Data* _data22_;
	_data22_ = (Block22Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data22_->_ref_count_)) {
		Twitter* self;
		self = _data22_->self;
		_g_free0 (_data22_->url);
		(_data22_->func_target_destroy_notify == NULL) ? NULL : (_data22_->func_target_destroy_notify (_data22_->func_target), NULL);
		_data22_->func = NULL;
		_data22_->func_target = NULL;
		_data22_->func_target_destroy_notify = NULL;
		_g_object_unref0 (self);
		g_slice_free (Block22Data, _data22_);
	}
}


static Block23Data* block23_data_ref (Block23Data* _data23_) {
	g_atomic_int_inc (&_data23_->_ref_count_);
	return _data23_;
}


static void block23_data_unref (void * _userdata_) {
	Block23Data* _data23_;
	_data23_ = (Block23Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data23_->_ref_count_)) {
		Twitter* self;
		self = _data23_->_data22_->self;
		block22_data_unref (_data23_->_data22_);
		_data23_->_data22_ = NULL;
		g_slice_free (Block23Data, _data23_);
	}
}


static void ___lambda25_ (Block23Data* _data23_, GdkPixbuf* ava) {
	Block22Data* _data22_;
	Twitter* self;
	TwitterAvatarDownloadedFunc _tmp0_ = NULL;
	void* _tmp0__target = NULL;
	GdkPixbuf* _tmp1_ = NULL;
	gulong _tmp2_ = 0UL;
	_data22_ = _data23_->_data22_;
	self = _data22_->self;
	g_return_if_fail (GDK_IS_PIXBUF (ava));
	_tmp0_ = _data22_->func;
	_tmp0__target = _data22_->func_target;
	_tmp1_ = ava;
	_tmp0_ (_tmp1_, _tmp0__target);
	_tmp2_ = _data23_->handler_id;
	g_signal_handler_disconnect (G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject), _tmp2_);
}


static void ____lambda25__twitter_avatar_downloaded (Twitter* _sender, GdkPixbuf* avatar, gpointer self) {
	___lambda25_ (self, avatar);
}


static void ___lambda27_ (Block22Data* _data22_, GObject* obj, GAsyncResult* res) {
	Twitter* self;
	GdkPixbuf* avatar = NULL;
	TwitterAvatarDownloadedFunc _tmp16_ = NULL;
	void* _tmp16__target = NULL;
	GdkPixbuf* _tmp17_ = NULL;
	const gchar* _tmp18_ = NULL;
	gchar* _tmp19_ = NULL;
	GdkPixbuf* _tmp20_ = NULL;
	GeeHashMap* _tmp21_ = NULL;
	const gchar* _tmp22_ = NULL;
	GdkPixbuf* _tmp23_ = NULL;
	GError * _inner_error_ = NULL;
	self = _data22_->self;
	g_return_if_fail ((obj == NULL) || G_IS_OBJECT (obj));
	g_return_if_fail (G_IS_ASYNC_RESULT (res));
	avatar = NULL;
	{
		GdkPixbuf* _tmp0_ = NULL;
		GAsyncResult* _tmp1_ = NULL;
		GdkPixbuf* _tmp2_ = NULL;
		GdkPixbuf* _tmp3_ = NULL;
		_tmp1_ = res;
		_tmp2_ = tweet_utils_download_avatar_finish (_tmp1_, &_inner_error_);
		_tmp0_ = _tmp2_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch27_g_error;
		}
		_tmp3_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (avatar);
		avatar = _tmp3_;
		_g_object_unref0 (_tmp0_);
	}
	goto __finally27;
	__catch27_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		TwitterAvatarDownloadedFunc _tmp11_ = NULL;
		void* _tmp11__target = NULL;
		GdkPixbuf* _tmp12_ = NULL;
		GeeHashMap* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		GdkPixbuf* _tmp15_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		_tmp6_ = g_strconcat (_tmp5_, " for ", NULL);
		_tmp7_ = _tmp6_;
		_tmp8_ = _data22_->url;
		_tmp9_ = g_strconcat (_tmp7_, _tmp8_, NULL);
		_tmp10_ = _tmp9_;
		g_warning ("Twitter.vala:115: %s", _tmp10_);
		_g_free0 (_tmp10_);
		_g_free0 (_tmp7_);
		_tmp11_ = _data22_->func;
		_tmp11__target = _data22_->func_target;
		_tmp12_ = twitter_no_avatar;
		_tmp11_ (_tmp12_, _tmp11__target);
		_tmp13_ = self->avatars;
		_tmp14_ = _data22_->url;
		_tmp15_ = twitter_no_avatar;
		gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp14_, _tmp15_);
		_g_error_free0 (e);
		_g_object_unref0 (avatar);
		return;
	}
	__finally27:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (avatar);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp16_ = _data22_->func;
	_tmp16__target = _data22_->func_target;
	_tmp17_ = avatar;
	_tmp16_ (_tmp17_, _tmp16__target);
	_tmp18_ = _data22_->url;
	_tmp19_ = g_strconcat ("avatar-downloaded::", _tmp18_, NULL);
	_tmp20_ = avatar;
	g_signal_emit_by_name (self, _tmp19_, _tmp20_);
	_g_free0 (_tmp19_);
	_tmp21_ = self->avatars;
	_tmp22_ = _data22_->url;
	_tmp23_ = avatar;
	gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp22_, _tmp23_);
	_g_object_unref0 (avatar);
}


static void ____lambda27__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	___lambda27_ (self, source_object, res);
	block22_data_unref (self);
}


GdkPixbuf* twitter_get_avatar (Twitter* self, const gchar* url, TwitterAvatarDownloadedFunc func, void* func_target, GDestroyNotify func_target_destroy_notify) {
	GdkPixbuf* result = NULL;
	Block22Data* _data22_;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	TwitterAvatarDownloadedFunc _tmp2_ = NULL;
	void* _tmp2__target = NULL;
	GdkPixbuf* a = NULL;
	GeeHashMap* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gpointer _tmp5_ = NULL;
	gboolean has_key = FALSE;
	GeeHashMap* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	GdkPixbuf* _tmp9_ = NULL;
	gchar* avatar_name = NULL;
	const gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gchar* avatar_dest = NULL;
	const gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	gboolean _tmp31_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (IS_TWITTER (self), NULL);
	g_return_val_if_fail (url != NULL, NULL);
	_data22_ = g_slice_new0 (Block22Data);
	_data22_->_ref_count_ = 1;
	_data22_->self = g_object_ref (self);
	_tmp0_ = url;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (_data22_->url);
	_data22_->url = _tmp1_;
	_tmp2_ = func;
	_tmp2__target = func_target;
	(_data22_->func_target_destroy_notify == NULL) ? NULL : (_data22_->func_target_destroy_notify (_data22_->func_target), NULL);
	_data22_->func = NULL;
	_data22_->func_target = NULL;
	_data22_->func_target_destroy_notify = NULL;
	_data22_->func = _tmp2_;
	_data22_->func_target = _tmp2__target;
	_data22_->func_target_destroy_notify = func_target_destroy_notify;
	_tmp3_ = self->avatars;
	_tmp4_ = _data22_->url;
	_tmp5_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp4_);
	a = (GdkPixbuf*) _tmp5_;
	_tmp6_ = self->avatars;
	_tmp7_ = _data22_->url;
	_tmp8_ = gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp7_);
	has_key = _tmp8_;
	_tmp9_ = a;
	if (_tmp9_ != NULL) {
		result = a;
		block22_data_unref (_data22_);
		_data22_ = NULL;
		return result;
	}
	_tmp10_ = _data22_->url;
	_tmp11_ = utils_get_avatar_name (_tmp10_);
	avatar_name = _tmp11_;
	_tmp12_ = avatar_name;
	_tmp13_ = g_strconcat ("assets/avatars/", _tmp12_, NULL);
	_tmp14_ = _tmp13_;
	_tmp15_ = dirs_cache (_tmp14_);
	_tmp16_ = _tmp15_;
	_g_free0 (_tmp14_);
	avatar_dest = _tmp16_;
	{
		GdkPixbuf* p = NULL;
		const gchar* _tmp17_ = NULL;
		GdkPixbuf* _tmp18_ = NULL;
		GeeHashMap* _tmp19_ = NULL;
		const gchar* _tmp20_ = NULL;
		GdkPixbuf* _tmp21_ = NULL;
		_tmp17_ = avatar_dest;
		_tmp18_ = gdk_pixbuf_new_from_file (_tmp17_, &_inner_error_);
		p = _tmp18_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch26_g_error;
		}
		_tmp19_ = self->avatars;
		_tmp20_ = _data22_->url;
		_tmp21_ = p;
		gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp20_, _tmp21_);
		result = p;
		_g_free0 (avatar_dest);
		_g_free0 (avatar_name);
		_g_object_unref0 (a);
		block22_data_unref (_data22_);
		_data22_ = NULL;
		return result;
	}
	goto __finally26;
	__catch26_g_error:
	{
		GError* e = NULL;
		GError* _tmp22_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp22_ = e;
		if (!g_error_matches (_tmp22_, G_FILE_ERROR, G_FILE_ERROR_NOENT)) {
			const gchar* _tmp23_ = NULL;
			GError* _tmp24_ = NULL;
			const gchar* _tmp25_ = NULL;
			GeeHashMap* _tmp26_ = NULL;
			const gchar* _tmp27_ = NULL;
			GdkPixbuf* _tmp28_ = NULL;
			GdkPixbuf* _tmp29_ = NULL;
			GdkPixbuf* _tmp30_ = NULL;
			_tmp23_ = _data22_->url;
			_tmp24_ = e;
			_tmp25_ = _tmp24_->message;
			g_critical ("Twitter.vala:93: Error while loading avatar `%s`: %s", _tmp23_, _tmp25_);
			_tmp26_ = self->avatars;
			_tmp27_ = _data22_->url;
			_tmp28_ = twitter_no_avatar;
			gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp27_, _tmp28_);
			_tmp29_ = twitter_no_avatar;
			_tmp30_ = _g_object_ref0 (_tmp29_);
			result = _tmp30_;
			_g_error_free0 (e);
			_g_free0 (avatar_dest);
			_g_free0 (avatar_name);
			_g_object_unref0 (a);
			block22_data_unref (_data22_);
			_data22_ = NULL;
			return result;
		}
		_g_error_free0 (e);
	}
	__finally26:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (avatar_dest);
		_g_free0 (avatar_name);
		_g_object_unref0 (a);
		block22_data_unref (_data22_);
		_data22_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp31_ = has_key;
	if (_tmp31_) {
		Block23Data* _data23_;
		const gchar* _tmp32_ = NULL;
		gchar* _tmp33_ = NULL;
		gulong _tmp34_ = 0UL;
		_data23_ = g_slice_new0 (Block23Data);
		_data23_->_ref_count_ = 1;
		_data23_->_data22_ = block22_data_ref (_data22_);
		_data23_->handler_id = (gulong) 0;
		_tmp32_ = _data22_->url;
		_tmp33_ = g_strconcat ("avatar-downloaded::", _tmp32_, NULL);
		_tmp34_ = g_signal_connect_data (self, _tmp33_, (GCallback) ____lambda25__twitter_avatar_downloaded, block23_data_ref (_data23_), (GClosureNotify) block23_data_unref, 0);
		_data23_->handler_id = _tmp34_;
		_g_free0 (_tmp33_);
		block23_data_unref (_data23_);
		_data23_ = NULL;
	} else {
		GeeHashMap* _tmp35_ = NULL;
		const gchar* _tmp36_ = NULL;
		const gchar* _tmp37_ = NULL;
		_tmp35_ = self->avatars;
		_tmp36_ = _data22_->url;
		gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp35_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp36_, NULL);
		_tmp37_ = _data22_->url;
		tweet_utils_download_avatar (_tmp37_, ____lambda27__gasync_ready_callback, block22_data_ref (_data22_));
	}
	result = NULL;
	_g_free0 (avatar_dest);
	_g_free0 (avatar_name);
	_g_object_unref0 (a);
	block22_data_unref (_data22_);
	_data22_ = NULL;
	return result;
}


gint twitter_get_short_url_length (void) {
	gint result;
	gint _tmp0_ = 0;
	_tmp0_ = twitter__short_url_length;
	result = _tmp0_;
	return result;
}


static void twitter_set_short_url_length (gint value) {
	gint _tmp0_ = 0;
	_tmp0_ = value;
	twitter__short_url_length = _tmp0_;
}


gint twitter_get_short_url_length_https (void) {
	gint result;
	gint _tmp0_ = 0;
	_tmp0_ = twitter__short_url_length_https;
	result = _tmp0_;
	return result;
}


static void twitter_set_short_url_length_https (gint value) {
	gint _tmp0_ = 0;
	_tmp0_ = value;
	twitter__short_url_length_https = _tmp0_;
}


gint twitter_get_max_media_per_upload (void) {
	gint result;
	gint _tmp0_ = 0;
	_tmp0_ = twitter__max_media_per_upload;
	result = _tmp0_;
	return result;
}


static void twitter_set_max_media_per_upload (gint value) {
	gint _tmp0_ = 0;
	_tmp0_ = value;
	twitter__max_media_per_upload = _tmp0_;
}


static void twitter_class_init (TwitterClass * klass) {
	twitter_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->get_property = _vala_twitter_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_twitter_set_property;
	G_OBJECT_CLASS (klass)->finalize = twitter_finalize;
	g_signal_new ("avatar_downloaded", TYPE_TWITTER, G_SIGNAL_RUN_LAST | G_SIGNAL_DETAILED, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GDK_TYPE_PIXBUF);
}


static void twitter_instance_init (Twitter * self) {
}


static void twitter_finalize (GObject* obj) {
	Twitter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_TWITTER, Twitter);
	_g_object_unref0 (self->avatars);
	G_OBJECT_CLASS (twitter_parent_class)->finalize (obj);
}


GType twitter_get_type (void) {
	static volatile gsize twitter_type_id__volatile = 0;
	if (g_once_init_enter (&twitter_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TwitterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) twitter_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Twitter), 0, (GInstanceInitFunc) twitter_instance_init, NULL };
		GType twitter_type_id;
		twitter_type_id = g_type_register_static (G_TYPE_OBJECT, "Twitter", &g_define_type_info, 0);
		g_once_init_leave (&twitter_type_id__volatile, twitter_type_id);
	}
	return twitter_type_id__volatile;
}


static void _vala_twitter_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	Twitter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_TWITTER, Twitter);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_twitter_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	Twitter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_TWITTER, Twitter);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



