/* SearchPage.c generated by valac 0.26.2, the Vala compiler
 * generated from SearchPage.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */
/* TODO: Add timeout that removes all entries after X seconds when switched away*/

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <rest/rest-proxy-call.h>
#include <rest/oauth-proxy.h>
#include <rest/rest-proxy.h>
#include <gio/gio.h>
#include <json-glib/json-glib.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <glib/gi18n-lib.h>


#define TYPE_IPAGE (ipage_get_type ())
#define IPAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IPAGE, IPage))
#define IS_IPAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IPAGE))
#define IPAGE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_IPAGE, IPageIface))

typedef struct _IPage IPage;
typedef struct _IPageIface IPageIface;

#define TYPE_BUNDLE (bundle_get_type ())
#define BUNDLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUNDLE, Bundle))
#define BUNDLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUNDLE, BundleClass))
#define IS_BUNDLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUNDLE))
#define IS_BUNDLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUNDLE))
#define BUNDLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUNDLE, BundleClass))

typedef struct _Bundle Bundle;
typedef struct _BundleClass BundleClass;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;

#define TYPE_ACCOUNT (account_get_type ())
#define ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ACCOUNT, Account))
#define ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ACCOUNT, AccountClass))
#define IS_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ACCOUNT))
#define IS_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ACCOUNT))
#define ACCOUNT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ACCOUNT, AccountClass))

typedef struct _Account Account;
typedef struct _AccountClass AccountClass;

#define TYPE_SEARCH_PAGE (search_page_get_type ())
#define SEARCH_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SEARCH_PAGE, SearchPage))
#define SEARCH_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SEARCH_PAGE, SearchPageClass))
#define IS_SEARCH_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SEARCH_PAGE))
#define IS_SEARCH_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SEARCH_PAGE))
#define SEARCH_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SEARCH_PAGE, SearchPageClass))

typedef struct _SearchPage SearchPage;
typedef struct _SearchPageClass SearchPageClass;
typedef struct _SearchPagePrivate SearchPagePrivate;

#define TYPE_DELTA_UPDATER (delta_updater_get_type ())
#define DELTA_UPDATER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DELTA_UPDATER, DeltaUpdater))
#define DELTA_UPDATER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DELTA_UPDATER, DeltaUpdaterClass))
#define IS_DELTA_UPDATER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DELTA_UPDATER))
#define IS_DELTA_UPDATER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DELTA_UPDATER))
#define DELTA_UPDATER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DELTA_UPDATER, DeltaUpdaterClass))

typedef struct _DeltaUpdater DeltaUpdater;
typedef struct _DeltaUpdaterClass DeltaUpdaterClass;

#define TYPE_TWEET_LIST_BOX (tweet_list_box_get_type ())
#define TWEET_LIST_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWEET_LIST_BOX, TweetListBox))
#define TWEET_LIST_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWEET_LIST_BOX, TweetListBoxClass))
#define IS_TWEET_LIST_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWEET_LIST_BOX))
#define IS_TWEET_LIST_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWEET_LIST_BOX))
#define TWEET_LIST_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWEET_LIST_BOX, TweetListBoxClass))

typedef struct _TweetListBox TweetListBox;
typedef struct _TweetListBoxClass TweetListBoxClass;

#define TYPE_SCROLL_WIDGET (scroll_widget_get_type ())
#define SCROLL_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCROLL_WIDGET, ScrollWidget))
#define SCROLL_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCROLL_WIDGET, ScrollWidgetClass))
#define IS_SCROLL_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCROLL_WIDGET))
#define IS_SCROLL_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCROLL_WIDGET))
#define SCROLL_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCROLL_WIDGET, ScrollWidgetClass))

typedef struct _ScrollWidget ScrollWidget;
typedef struct _ScrollWidgetClass ScrollWidgetClass;

#define TYPE_LOAD_MORE_ENTRY (load_more_entry_get_type ())
#define LOAD_MORE_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LOAD_MORE_ENTRY, LoadMoreEntry))
#define LOAD_MORE_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LOAD_MORE_ENTRY, LoadMoreEntryClass))
#define IS_LOAD_MORE_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LOAD_MORE_ENTRY))
#define IS_LOAD_MORE_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LOAD_MORE_ENTRY))
#define LOAD_MORE_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LOAD_MORE_ENTRY, LoadMoreEntryClass))

typedef struct _LoadMoreEntry LoadMoreEntry;
typedef struct _LoadMoreEntryClass LoadMoreEntryClass;

#define TYPE_COLLECT (collect_get_type ())
#define COLLECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COLLECT, Collect))
#define COLLECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COLLECT, CollectClass))
#define IS_COLLECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COLLECT))
#define IS_COLLECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COLLECT))
#define COLLECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COLLECT, CollectClass))

typedef struct _Collect Collect;
typedef struct _CollectClass CollectClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_USER_LIST_ENTRY (user_list_entry_get_type ())
#define USER_LIST_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_USER_LIST_ENTRY, UserListEntry))
#define USER_LIST_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_USER_LIST_ENTRY, UserListEntryClass))
#define IS_USER_LIST_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_USER_LIST_ENTRY))
#define IS_USER_LIST_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_USER_LIST_ENTRY))
#define USER_LIST_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_USER_LIST_ENTRY, UserListEntryClass))

typedef struct _UserListEntry UserListEntry;
typedef struct _UserListEntryClass UserListEntryClass;
typedef struct _MainWindowPrivate MainWindowPrivate;

#define TYPE_MAIN_WIDGET (main_widget_get_type ())
#define MAIN_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WIDGET, MainWidget))
#define MAIN_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WIDGET, MainWidgetClass))
#define IS_MAIN_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WIDGET))
#define IS_MAIN_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WIDGET))
#define MAIN_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WIDGET, MainWidgetClass))

typedef struct _MainWidget MainWidget;
typedef struct _MainWidgetClass MainWidgetClass;

#define TYPE_PAGE (page_get_type ())

#define TYPE_TWEET_LIST_ENTRY (tweet_list_entry_get_type ())
#define TWEET_LIST_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWEET_LIST_ENTRY, TweetListEntry))
#define TWEET_LIST_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWEET_LIST_ENTRY, TweetListEntryClass))
#define IS_TWEET_LIST_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWEET_LIST_ENTRY))
#define IS_TWEET_LIST_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWEET_LIST_ENTRY))
#define TWEET_LIST_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWEET_LIST_ENTRY, TweetListEntryClass))

typedef struct _TweetListEntry TweetListEntry;
typedef struct _TweetListEntryClass TweetListEntryClass;

#define TYPE_ITWITTER_ITEM (itwitter_item_get_type ())
#define ITWITTER_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ITWITTER_ITEM, ITwitterItem))
#define IS_ITWITTER_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ITWITTER_ITEM))
#define ITWITTER_ITEM_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_ITWITTER_ITEM, ITwitterItemIface))

typedef struct _ITwitterItem ITwitterItem;
typedef struct _ITwitterItemIface ITwitterItemIface;
typedef struct _TweetListEntryPrivate TweetListEntryPrivate;

#define TYPE_TWEET (tweet_get_type ())
#define TWEET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWEET, Tweet))
#define TWEET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWEET, TweetClass))
#define IS_TWEET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWEET))
#define IS_TWEET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWEET))
#define TWEET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWEET, TweetClass))

typedef struct _Tweet Tweet;
typedef struct _TweetClass TweetClass;
#define __vala_JsonNode_free0(var) ((var == NULL) ? NULL : (var = (_vala_JsonNode_free (var), NULL)))
#define _json_object_unref0(var) ((var == NULL) ? NULL : (var = (json_object_unref (var), NULL)))
#define _json_array_unref0(var) ((var == NULL) ? NULL : (var = (json_array_unref (var), NULL)))
typedef struct _Block8Data Block8Data;
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
typedef struct _TweetPrivate TweetPrivate;

#define TYPE_MEDIA (media_get_type ())
#define MEDIA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA, Media))
#define MEDIA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA, MediaClass))
#define IS_MEDIA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA))
#define IS_MEDIA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA))
#define MEDIA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA, MediaClass))

typedef struct _Media Media;
typedef struct _MediaClass MediaClass;

#define TYPE_BADGE_RADIO_TOOL_BUTTON (badge_radio_tool_button_get_type ())
#define BADGE_RADIO_TOOL_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BADGE_RADIO_TOOL_BUTTON, BadgeRadioToolButton))
#define BADGE_RADIO_TOOL_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BADGE_RADIO_TOOL_BUTTON, BadgeRadioToolButtonClass))
#define IS_BADGE_RADIO_TOOL_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BADGE_RADIO_TOOL_BUTTON))
#define IS_BADGE_RADIO_TOOL_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BADGE_RADIO_TOOL_BUTTON))
#define BADGE_RADIO_TOOL_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BADGE_RADIO_TOOL_BUTTON, BadgeRadioToolButtonClass))

typedef struct _BadgeRadioToolButton BadgeRadioToolButton;
typedef struct _BadgeRadioToolButtonClass BadgeRadioToolButtonClass;
typedef struct _LoadMoreEntryPrivate LoadMoreEntryPrivate;

struct _IPageIface {
	GTypeInterface parent_iface;
	void (*on_join) (IPage* self, gint page_id, Bundle* args);
	void (*on_leave) (IPage* self);
	void (*create_tool_button) (IPage* self, GtkRadioButton* group);
	GtkRadioButton* (*get_tool_button) (IPage* self);
	gchar* (*get_title) (IPage* self);
	gboolean (*handles_double_open) (IPage* self);
	void (*double_open) (IPage* self);
	gint (*get_id) (IPage* self);
	void (*set_id) (IPage* self, gint value);
	MainWindow* (*get_main_window) (IPage* self);
	void (*set_main_window) (IPage* self, MainWindow* value);
	Account* (*get_account) (IPage* self);
	void (*set_account) (IPage* self, Account* value);
};

struct _SearchPage {
	GtkBox parent_instance;
	SearchPagePrivate * priv;
	DeltaUpdater* delta_updater;
};

struct _SearchPageClass {
	GtkBoxClass parent_class;
};

struct _SearchPagePrivate {
	Account* _account;
	MainWindow* _main_window;
	gint _id;
	GtkSearchEntry* search_entry;
	GtkButton* search_button;
	TweetListBox* tweet_list;
	GtkLabel* users_header;
	GtkLabel* tweets_header;
	ScrollWidget* scroll_widget;
	GtkRadioButton* tool_button;
	LoadMoreEntry* load_more_entry;
	gchar* search_query;
	gint user_page;
	gint64 lowest_tweet_id;
	gboolean loading_tweets;
	GtkWidget* last_focus_widget;
	gint n_results;
	Collect* collect_obj;
};

struct _MainWindow {
	GtkApplicationWindow parent_instance;
	MainWindowPrivate * priv;
	GtkButton* back_button;
	GtkToggleButton* compose_tweet_button;
	MainWidget* main_widget;
};

struct _MainWindowClass {
	GtkApplicationWindowClass parent_class;
};

typedef enum  {
	PAGE_STREAM = 0,
	PAGE_MENTIONS,
	PAGE_FAVORITES,
	PAGE_DM_THREADS,
	PAGE_LISTS,
	PAGE_FILTERS,
	PAGE_SEARCH,
	PAGE_PROFILE,
	PAGE_TWEET_INFO,
	PAGE_DM,
	PAGE_LIST_STATUSES,
	PAGE_PREVIOUS = 1024,
	PAGE_NEXT = 2048
} Page;

struct _ITwitterItemIface {
	GTypeInterface parent_iface;
	gint (*update_time_delta) (ITwitterItem* self, GDateTime* now);
	gint64 (*get_sort_factor) (ITwitterItem* self);
	gboolean (*get_seen) (ITwitterItem* self);
	void (*set_seen) (ITwitterItem* self, gboolean value);
};

struct _TweetListEntry {
	GtkListBoxRow parent_instance;
	TweetListEntryPrivate * priv;
	gchar* notification_id;
	Tweet* tweet;
};

struct _TweetListEntryClass {
	GtkListBoxRowClass parent_class;
};

struct _Block8Data {
	int _ref_count_;
	SearchPage* self;
	GDateTime* now;
};

struct _Tweet {
	GObject parent_instance;
	TweetPrivate * priv;
	gint64 id;
	gint64 rt_id;
	gchar* text;
	gint64 user_id;
	gchar* user_name;
	gchar* retweeted_by;
	gchar* rt_by_screen_name;
	gint64 rt_by_id;
	gboolean is_retweet;
	GdkPixbuf* inline_media;
	gchar* time_delta;
	gchar* avatar_url;
	gchar* avatar_name;
	gchar* screen_name;
	gint64 created_at;
	gint64 rt_created_at;
	gboolean verified;
	gint64 my_retweet;
	gboolean protected;
	gint64 reply_id;
	Media** medias;
	gint medias_length1;
	gint retweet_count;
	gint favorite_count;
	gchar** mentions;
	gint mentions_length1;
};

struct _TweetClass {
	GObjectClass parent_class;
};

struct _LoadMoreEntry {
	GtkListBoxRow parent_instance;
	LoadMoreEntryPrivate * priv;
};

struct _LoadMoreEntryClass {
	GtkListBoxRowClass parent_class;
};

struct _LoadMoreEntryPrivate {
	GtkButton* load_more_button;
};


static gpointer search_page_parent_class = NULL;
static IPageIface* search_page_ipage_parent_iface = NULL;
static gpointer load_more_entry_parent_class = NULL;
static ITwitterItemIface* load_more_entry_itwitter_item_parent_iface = NULL;

GType bundle_get_type (void) G_GNUC_CONST;
GType main_window_get_type (void) G_GNUC_CONST;
GType account_get_type (void) G_GNUC_CONST;
GType ipage_get_type (void) G_GNUC_CONST;
GType search_page_get_type (void) G_GNUC_CONST;
GType delta_updater_get_type (void) G_GNUC_CONST;
GType tweet_list_box_get_type (void) G_GNUC_CONST;
GType scroll_widget_get_type (void) G_GNUC_CONST;
GType load_more_entry_get_type (void) G_GNUC_CONST;
GType collect_get_type (void) G_GNUC_CONST;
#define SEARCH_PAGE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SEARCH_PAGE, SearchPagePrivate))
enum  {
	SEARCH_PAGE_DUMMY_PROPERTY,
	SEARCH_PAGE_UNREAD_COUNT,
	SEARCH_PAGE_ACCOUNT,
	SEARCH_PAGE_MAIN_WINDOW,
	SEARCH_PAGE_ID
};
LoadMoreEntry* load_more_entry_new (void);
LoadMoreEntry* load_more_entry_construct (GType object_type);
#define SEARCH_PAGE_USER_COUNT 3
SearchPage* search_page_new (gint id);
SearchPage* search_page_construct (GType object_type, gint id);
void ipage_set_id (IPage* self, gint value);
static void search_page_header_func (SearchPage* self, GtkListBoxRow* row, GtkListBoxRow* before);
static void _search_page_header_func_gtk_list_box_update_header_func (GtkListBoxRow* row, GtkListBoxRow* before, gpointer self);
gint itwitter_item_sort_func (GtkListBoxRow* a, GtkListBoxRow* b);
static gint _itwitter_item_sort_func_gtk_list_box_sort_func (GtkListBoxRow* row1, GtkListBoxRow* row2, gpointer self);
static void search_page_row_activated_cb (SearchPage* self, GtkListBoxRow* row);
static void _search_page_row_activated_cb_gtk_list_box_row_activated (GtkListBox* _sender, GtkListBoxRow* row, gpointer self);
static void __lambda172_ (SearchPage* self);
void search_page_search_for (SearchPage* self, const gchar* search_term, gboolean set_text);
static void ___lambda172__gtk_button_clicked (GtkButton* _sender, gpointer self);
GtkButton* load_more_entry_get_button (LoadMoreEntry* self);
static void __lambda178_ (SearchPage* self);
static void search_page_load_users (SearchPage* self);
static void ___lambda178__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void search_page_load_tweets (SearchPage* self);
static void _search_page_load_tweets_scroll_widget_scrolled_to_end (ScrollWidget* _sender, gpointer self);
GtkStack* tweet_list_box_get_placeholder (TweetListBox* self);
static void search_page_search_entry_activate_cb (SearchPage* self);
static void _search_page_search_entry_activate_cb_gtk_entry_activate (GtkEntry* _sender, gpointer self);
static void search_page_real_on_join (IPage* base, gint page_id, Bundle* args);
gchar* bundle_get_string (Bundle* self, const gchar* key);
static void search_page_real_on_leave (IPage* base);
void tweet_list_box_remove_all (TweetListBox* self);
void tweet_list_box_set_unempty (TweetListBox* self);
Collect* collect_new (gint max);
Collect* collect_construct (GType object_type, gint max);
static void search_page_show_entries (SearchPage* self, GError* e);
static void _search_page_show_entries_collect_finished (Collect* _sender, GError* _error_, gpointer self);
Bundle* bundle_new (void);
Bundle* bundle_construct (GType object_type);
GType user_list_entry_get_type (void) G_GNUC_CONST;
void bundle_put_int64 (Bundle* self, const gchar* key, gint64 value);
gint64 user_list_entry_get_user_id (UserListEntry* self);
void bundle_put_string (Bundle* self, const gchar* key, const gchar* value);
gchar* user_list_entry_get_screen_name (UserListEntry* self);
MainWindow* ipage_get_main_window (IPage* self);
GType main_widget_get_type (void) G_GNUC_CONST;
void main_widget_switch_page (MainWidget* self, gint page_id, Bundle* args);
GType page_get_type (void) G_GNUC_CONST;
GType tweet_list_entry_get_type (void) G_GNUC_CONST;
void bundle_put_int (Bundle* self, const gchar* key, gint value);
#define TWEET_INFO_PAGE_BY_INSTANCE 1
void bundle_put_object (Bundle* self, const gchar* key, GObject* object);
GType itwitter_item_get_type (void) G_GNUC_CONST;
GType tweet_get_type (void) G_GNUC_CONST;
Account* ipage_get_account (IPage* self);
OAuthProxy* account_get_proxy (Account* self);
void tweet_utils_load_threaded (RestProxyCall* call, GAsyncReadyCallback _callback_, gpointer _user_data_);
JsonNode* tweet_utils_load_threaded_finish (GAsyncResult* _res_);
static void __lambda176_ (SearchPage* self, GObject* _, GAsyncResult* res);
void collect_emit (Collect* self, GError* _error_);
static void _vala_JsonNode_free (JsonNode* self);
void tweet_list_box_set_empty (TweetListBox* self);
static void __lambda177_ (SearchPage* self, JsonArray* array, guint index, JsonNode* node);
UserListEntry* user_list_entry_new (void);
UserListEntry* user_list_entry_construct (GType object_type);
void user_list_entry_set_screen_name (UserListEntry* self, const gchar* value);
void user_list_entry_set_name (UserListEntry* self, const gchar* value);
void user_list_entry_set_avatar (UserListEntry* self, const gchar* value);
void user_list_entry_set_user_id (UserListEntry* self, gint64 value);
void user_list_entry_set_show_settings (UserListEntry* self, gboolean value);
static void ___lambda177__json_array_foreach (JsonArray* array, guint index_, JsonNode* element_node, gpointer self);
static void ___lambda176__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void __lambda174_ (SearchPage* self, GObject* _, GAsyncResult* res);
static Block8Data* block8_data_ref (Block8Data* _data8_);
static void block8_data_unref (void * _userdata_);
static void __lambda175_ (Block8Data* _data8_, JsonArray* array, guint index, JsonNode* node);
Tweet* tweet_new (void);
Tweet* tweet_construct (GType object_type);
void tweet_load_from_json (Tweet* self, JsonNode* status_node, GDateTime* now, Account* account);
GType media_get_type (void) G_GNUC_CONST;
TweetListEntry* tweet_list_entry_new (Tweet* tweet, MainWindow* window, Account* account);
TweetListEntry* tweet_list_entry_construct (GType object_type, Tweet* tweet, MainWindow* window, Account* account);
void delta_updater_add (DeltaUpdater* self, ITwitterItem* entry);
static void ___lambda175__json_array_foreach (JsonArray* array, guint index_, JsonNode* element_node, gpointer self);
static void ___lambda174__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
void tweet_list_box_set_error (TweetListBox* self, const gchar* err_msg);
static void __lambda173_ (SearchPage* self, GtkWidget* w);
static void ___lambda173__gtk_callback (GtkWidget* widget, gpointer self);
static void search_page_real_create_tool_button (IPage* base, GtkRadioButton* group);
BadgeRadioToolButton* badge_radio_tool_button_new (GtkRadioButton* group, const gchar* icon_name, const gchar* text);
BadgeRadioToolButton* badge_radio_tool_button_construct (GType object_type, GtkRadioButton* group, const gchar* icon_name, const gchar* text);
GType badge_radio_tool_button_get_type (void) G_GNUC_CONST;
static GtkRadioButton* search_page_real_get_tool_button (IPage* base);
static gchar* search_page_real_get_title (IPage* base);
static gboolean search_page_real_handles_double_open (IPage* base);
gint search_page_get_unread_count (SearchPage* self);
void search_page_set_unread_count (SearchPage* self, gint value);
static void search_page_finalize (GObject* obj);
gint ipage_get_id (IPage* self);
static void _vala_search_page_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
void ipage_set_account (IPage* self, Account* value);
void ipage_set_main_window (IPage* self, MainWindow* value);
static void _vala_search_page_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
#define LOAD_MORE_ENTRY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_LOAD_MORE_ENTRY, LoadMoreEntryPrivate))
enum  {
	LOAD_MORE_ENTRY_DUMMY_PROPERTY,
	LOAD_MORE_ENTRY_SORT_FACTOR,
	LOAD_MORE_ENTRY_SEEN
};
static gint load_more_entry_real_update_time_delta (ITwitterItem* base, GDateTime* now);
static void load_more_entry_finalize (GObject* obj);
gint64 itwitter_item_get_sort_factor (ITwitterItem* self);
gboolean itwitter_item_get_seen (ITwitterItem* self);
static void _vala_load_more_entry_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
void itwitter_item_set_seen (ITwitterItem* self, gboolean value);
static void _vala_load_more_entry_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static void _search_page_header_func_gtk_list_box_update_header_func (GtkListBoxRow* row, GtkListBoxRow* before, gpointer self) {
	search_page_header_func ((SearchPage*) self, row, before);
}


static gint _itwitter_item_sort_func_gtk_list_box_sort_func (GtkListBoxRow* row1, GtkListBoxRow* row2, gpointer self) {
	gint result;
	result = itwitter_item_sort_func (row1, row2);
	return result;
}


static void _search_page_row_activated_cb_gtk_list_box_row_activated (GtkListBox* _sender, GtkListBoxRow* row, gpointer self) {
	search_page_row_activated_cb ((SearchPage*) self, row);
}


static void __lambda172_ (SearchPage* self) {
	GtkSearchEntry* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	_tmp0_ = self->priv->search_entry;
	_tmp1_ = gtk_entry_get_text (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_entry_get_type (), GtkEntry));
	search_page_search_for (self, _tmp1_, FALSE);
}


static void ___lambda172__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	__lambda172_ ((SearchPage*) self);
}


static void __lambda178_ (SearchPage* self) {
	gint _tmp0_ = 0;
	_tmp0_ = self->priv->user_page;
	self->priv->user_page = _tmp0_ + 1;
	search_page_load_users (self);
}


static void ___lambda178__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	__lambda178_ ((SearchPage*) self);
}


static void _search_page_load_tweets_scroll_widget_scrolled_to_end (ScrollWidget* _sender, gpointer self) {
	search_page_load_tweets ((SearchPage*) self);
}


SearchPage* search_page_construct (GType object_type, gint id) {
	SearchPage * self = NULL;
	gint _tmp0_ = 0;
	TweetListBox* _tmp1_ = NULL;
	TweetListBox* _tmp2_ = NULL;
	TweetListBox* _tmp3_ = NULL;
	GtkButton* _tmp4_ = NULL;
	LoadMoreEntry* _tmp5_ = NULL;
	GtkButton* _tmp6_ = NULL;
	GtkButton* _tmp7_ = NULL;
	ScrollWidget* _tmp8_ = NULL;
	TweetListBox* _tmp9_ = NULL;
	GtkStack* _tmp10_ = NULL;
	GtkStack* _tmp11_ = NULL;
	TweetListBox* _tmp12_ = NULL;
	ScrollWidget* _tmp13_ = NULL;
	GtkAdjustment* _tmp14_ = NULL;
	self = (SearchPage*) g_object_new (object_type, NULL);
	_tmp0_ = id;
	ipage_set_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage), _tmp0_);
	_tmp1_ = self->priv->tweet_list;
	gtk_list_box_set_header_func (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_list_box_get_type (), GtkListBox), _search_page_header_func_gtk_list_box_update_header_func, g_object_ref (self), g_object_unref);
	_tmp2_ = self->priv->tweet_list;
	gtk_list_box_set_sort_func (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_list_box_get_type (), GtkListBox), _itwitter_item_sort_func_gtk_list_box_sort_func, NULL, NULL);
	_tmp3_ = self->priv->tweet_list;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_list_box_get_type (), GtkListBox), "row-activated", (GCallback) _search_page_row_activated_cb_gtk_list_box_row_activated, self, 0);
	_tmp4_ = self->priv->search_button;
	g_signal_connect_object (_tmp4_, "clicked", (GCallback) ___lambda172__gtk_button_clicked, self, 0);
	_tmp5_ = self->priv->load_more_entry;
	_tmp6_ = load_more_entry_get_button (_tmp5_);
	_tmp7_ = _tmp6_;
	g_signal_connect_object (_tmp7_, "clicked", (GCallback) ___lambda178__gtk_button_clicked, self, 0);
	_g_object_unref0 (_tmp7_);
	_tmp8_ = self->priv->scroll_widget;
	g_signal_connect_object (_tmp8_, "scrolled-to-end", (GCallback) _search_page_load_tweets_scroll_widget_scrolled_to_end, self, 0);
	_tmp9_ = self->priv->tweet_list;
	_tmp10_ = tweet_list_box_get_placeholder (_tmp9_);
	_tmp11_ = _tmp10_;
	gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (_tmp11_);
	_tmp12_ = self->priv->tweet_list;
	_tmp13_ = self->priv->scroll_widget;
	_tmp14_ = gtk_scrolled_window_get_vadjustment (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, gtk_scrolled_window_get_type (), GtkScrolledWindow));
	gtk_list_box_set_adjustment (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, gtk_list_box_get_type (), GtkListBox), _tmp14_);
	return self;
}


SearchPage* search_page_new (gint id) {
	return search_page_construct (TYPE_SEARCH_PAGE, id);
}


static void search_page_search_entry_activate_cb (SearchPage* self) {
	GtkSearchEntry* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_if_fail (IS_SEARCH_PAGE (self));
	_tmp0_ = self->priv->search_entry;
	_tmp1_ = gtk_entry_get_text (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_entry_get_type (), GtkEntry));
	search_page_search_for (self, _tmp1_, FALSE);
}


static void _search_page_search_entry_activate_cb_gtk_entry_activate (GtkEntry* _sender, gpointer self) {
	search_page_search_entry_activate_cb ((SearchPage*) self);
}


/**
   * see IPage#onJoin
   */
static void search_page_real_on_join (IPage* base, gint page_id, Bundle* args) {
	SearchPage * self;
	gchar* _tmp0_ = NULL;
	Bundle* _tmp1_ = NULL;
	gchar* term = NULL;
	gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp9_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_SEARCH_PAGE, SearchPage);
	g_return_if_fail ((args == NULL) || IS_BUNDLE (args));
	_tmp1_ = args;
	if (_tmp1_ != NULL) {
		Bundle* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		_tmp2_ = args;
		_tmp3_ = bundle_get_string (_tmp2_, "query");
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp3_;
	} else {
		_g_free0 (_tmp0_);
		_tmp0_ = NULL;
	}
	_tmp4_ = g_strdup (_tmp0_);
	term = _tmp4_;
	_tmp5_ = term;
	if (_tmp5_ == NULL) {
		GtkWidget* _tmp6_ = NULL;
		_tmp6_ = self->priv->last_focus_widget;
		if (_tmp6_ != NULL) {
			GtkWidget* _tmp7_ = NULL;
			_tmp7_ = self->priv->last_focus_widget;
			gtk_widget_grab_focus (_tmp7_);
		} else {
			GtkSearchEntry* _tmp8_ = NULL;
			_tmp8_ = self->priv->search_entry;
			gtk_widget_grab_focus (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_widget_get_type (), GtkWidget));
		}
		_g_free0 (term);
		_g_free0 (_tmp0_);
		return;
	}
	_tmp9_ = term;
	search_page_search_for (self, _tmp9_, TRUE);
	_g_free0 (term);
	_g_free0 (_tmp0_);
}


static void search_page_real_on_leave (IPage* base) {
	SearchPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_SEARCH_PAGE, SearchPage);
}


static void _search_page_show_entries_collect_finished (Collect* _sender, GError* _error_, gpointer self) {
	search_page_show_entries ((SearchPage*) self, _error_);
}


void search_page_search_for (SearchPage* self, const gchar* search_term, gboolean set_text) {
	const gchar* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gchar* q = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	TweetListBox* _tmp5_ = NULL;
	TweetListBox* _tmp6_ = NULL;
	TweetListBox* _tmp7_ = NULL;
	GtkStack* _tmp8_ = NULL;
	GtkStack* _tmp9_ = NULL;
	gboolean _tmp10_ = FALSE;
	const gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	const gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	Collect* _tmp17_ = NULL;
	Collect* _tmp18_ = NULL;
	g_return_if_fail (IS_SEARCH_PAGE (self));
	g_return_if_fail (search_term != NULL);
	_tmp0_ = search_term;
	_tmp1_ = strlen (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == 0) {
		return;
	}
	self->priv->n_results = 0;
	_tmp3_ = search_term;
	_tmp4_ = g_strdup (_tmp3_);
	q = _tmp4_;
	_tmp5_ = self->priv->tweet_list;
	tweet_list_box_remove_all (_tmp5_);
	_tmp6_ = self->priv->tweet_list;
	tweet_list_box_set_unempty (_tmp6_);
	_tmp7_ = self->priv->tweet_list;
	_tmp8_ = tweet_list_box_get_placeholder (_tmp7_);
	_tmp9_ = _tmp8_;
	gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (_tmp9_);
	_tmp10_ = set_text;
	if (_tmp10_) {
		GtkSearchEntry* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		_tmp11_ = self->priv->search_entry;
		_tmp12_ = search_term;
		gtk_entry_set_text (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, gtk_entry_get_type (), GtkEntry), _tmp12_);
	}
	_tmp13_ = q;
	_tmp14_ = g_strconcat (_tmp13_, " -rt", NULL);
	_g_free0 (q);
	q = _tmp14_;
	_tmp15_ = q;
	_tmp16_ = g_uri_escape_string (_tmp15_, NULL, TRUE);
	_g_free0 (self->priv->search_query);
	self->priv->search_query = _tmp16_;
	self->priv->user_page = 1;
	self->priv->lowest_tweet_id = G_MAXINT64 - 1;
	_tmp17_ = collect_new (2);
	_g_object_unref0 (self->priv->collect_obj);
	self->priv->collect_obj = _tmp17_;
	_tmp18_ = self->priv->collect_obj;
	g_signal_connect_object (_tmp18_, "finished", (GCallback) _search_page_show_entries_collect_finished, self, 0);
	search_page_load_tweets (self);
	search_page_load_users (self);
	_g_free0 (q);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void search_page_row_activated_cb (SearchPage* self, GtkListBoxRow* row) {
	GtkListBoxRow* _tmp0_ = NULL;
	GtkWidget* _tmp1_ = NULL;
	Bundle* bundle = NULL;
	Bundle* _tmp2_ = NULL;
	GtkListBoxRow* _tmp3_ = NULL;
	g_return_if_fail (IS_SEARCH_PAGE (self));
	g_return_if_fail (GTK_IS_LIST_BOX_ROW (row));
	_tmp0_ = row;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (self->priv->last_focus_widget);
	self->priv->last_focus_widget = _tmp1_;
	_tmp2_ = bundle_new ();
	bundle = _tmp2_;
	_tmp3_ = row;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, TYPE_USER_LIST_ENTRY)) {
		Bundle* _tmp4_ = NULL;
		GtkListBoxRow* _tmp5_ = NULL;
		gint64 _tmp6_ = 0LL;
		gint64 _tmp7_ = 0LL;
		Bundle* _tmp8_ = NULL;
		GtkListBoxRow* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		MainWindow* _tmp13_ = NULL;
		MainWindow* _tmp14_ = NULL;
		MainWidget* _tmp15_ = NULL;
		Bundle* _tmp16_ = NULL;
		_tmp4_ = bundle;
		_tmp5_ = row;
		_tmp6_ = user_list_entry_get_user_id (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, TYPE_USER_LIST_ENTRY, UserListEntry));
		_tmp7_ = _tmp6_;
		bundle_put_int64 (_tmp4_, "user_id", _tmp7_);
		_tmp8_ = bundle;
		_tmp9_ = row;
		_tmp10_ = user_list_entry_get_screen_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, TYPE_USER_LIST_ENTRY, UserListEntry));
		_tmp11_ = _tmp10_;
		_tmp12_ = _tmp11_;
		bundle_put_string (_tmp8_, "screen_name", _tmp12_);
		_g_free0 (_tmp12_);
		_tmp13_ = ipage_get_main_window (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
		_tmp14_ = _tmp13_;
		_tmp15_ = _tmp14_->main_widget;
		_tmp16_ = bundle;
		main_widget_switch_page (_tmp15_, (gint) PAGE_PROFILE, _tmp16_);
	} else {
		GtkListBoxRow* _tmp17_ = NULL;
		_tmp17_ = row;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp17_, TYPE_TWEET_LIST_ENTRY)) {
			Bundle* _tmp18_ = NULL;
			Bundle* _tmp19_ = NULL;
			GtkListBoxRow* _tmp20_ = NULL;
			Tweet* _tmp21_ = NULL;
			MainWindow* _tmp22_ = NULL;
			MainWindow* _tmp23_ = NULL;
			MainWidget* _tmp24_ = NULL;
			Bundle* _tmp25_ = NULL;
			_tmp18_ = bundle;
			bundle_put_int (_tmp18_, "mode", TWEET_INFO_PAGE_BY_INSTANCE);
			_tmp19_ = bundle;
			_tmp20_ = row;
			_tmp21_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, TYPE_TWEET_LIST_ENTRY, TweetListEntry)->tweet;
			bundle_put_object (_tmp19_, "tweet", G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, G_TYPE_OBJECT, GObject));
			_tmp22_ = ipage_get_main_window (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
			_tmp23_ = _tmp22_;
			_tmp24_ = _tmp23_->main_widget;
			_tmp25_ = bundle;
			main_widget_switch_page (_tmp24_, (gint) PAGE_TWEET_INFO, _tmp25_);
		}
	}
	_g_object_unref0 (bundle);
}


static void search_page_header_func (SearchPage* self, GtkListBoxRow* row, GtkListBoxRow* before) {
	GtkWidget* header = NULL;
	GtkListBoxRow* _tmp0_ = NULL;
	GtkWidget* _tmp1_ = NULL;
	GtkWidget* _tmp2_ = NULL;
	GtkWidget* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	GtkListBoxRow* _tmp5_ = NULL;
	g_return_if_fail (IS_SEARCH_PAGE (self));
	g_return_if_fail (GTK_IS_LIST_BOX_ROW (row));
	g_return_if_fail ((before == NULL) || GTK_IS_LIST_BOX_ROW (before));
	_tmp0_ = row;
	_tmp1_ = gtk_list_box_row_get_header (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	header = _tmp2_;
	_tmp3_ = header;
	if (_tmp3_ != NULL) {
		_g_object_unref0 (header);
		return;
	}
	_tmp5_ = before;
	if (_tmp5_ == NULL) {
		GtkListBoxRow* _tmp6_ = NULL;
		_tmp6_ = row;
		_tmp4_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, TYPE_USER_LIST_ENTRY);
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		GtkListBoxRow* _tmp7_ = NULL;
		GtkLabel* _tmp8_ = NULL;
		_tmp7_ = row;
		_tmp8_ = self->priv->users_header;
		gtk_list_box_row_set_header (_tmp7_, G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_widget_get_type (), GtkWidget));
	} else {
		gboolean _tmp9_ = FALSE;
		gboolean _tmp10_ = FALSE;
		GtkListBoxRow* _tmp11_ = NULL;
		_tmp11_ = before;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp11_, TYPE_USER_LIST_ENTRY)) {
			_tmp10_ = TRUE;
		} else {
			GtkListBoxRow* _tmp12_ = NULL;
			_tmp12_ = before;
			_tmp10_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp12_, TYPE_LOAD_MORE_ENTRY);
		}
		if (_tmp10_) {
			GtkListBoxRow* _tmp13_ = NULL;
			_tmp13_ = row;
			_tmp9_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp13_, TYPE_TWEET_LIST_ENTRY);
		} else {
			_tmp9_ = FALSE;
		}
		if (_tmp9_) {
			GtkListBoxRow* _tmp14_ = NULL;
			GtkLabel* _tmp15_ = NULL;
			_tmp14_ = row;
			_tmp15_ = self->priv->tweets_header;
			gtk_list_box_row_set_header (_tmp14_, G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, gtk_widget_get_type (), GtkWidget));
		}
	}
	_g_object_unref0 (header);
}


static void _vala_JsonNode_free (JsonNode* self) {
	g_boxed_free (json_node_get_type (), self);
}


static gpointer _json_array_ref0 (gpointer self) {
	return self ? json_array_ref (self) : NULL;
}


static gpointer _json_object_ref0 (gpointer self) {
	return self ? json_object_ref (self) : NULL;
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}


static void __lambda177_ (SearchPage* self, JsonArray* array, guint index, JsonNode* node) {
	guint _tmp0_ = 0U;
	JsonObject* user_obj = NULL;
	JsonNode* _tmp1_ = NULL;
	JsonObject* _tmp2_ = NULL;
	JsonObject* _tmp3_ = NULL;
	UserListEntry* entry = NULL;
	UserListEntry* _tmp4_ = NULL;
	UserListEntry* _tmp5_ = NULL;
	JsonObject* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	UserListEntry* _tmp10_ = NULL;
	JsonObject* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	UserListEntry* _tmp15_ = NULL;
	JsonObject* _tmp16_ = NULL;
	const gchar* _tmp17_ = NULL;
	UserListEntry* _tmp18_ = NULL;
	JsonObject* _tmp19_ = NULL;
	gint64 _tmp20_ = 0LL;
	UserListEntry* _tmp21_ = NULL;
	UserListEntry* _tmp22_ = NULL;
	TweetListBox* _tmp23_ = NULL;
	UserListEntry* _tmp24_ = NULL;
	g_return_if_fail (array != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = index;
	if (_tmp0_ > ((guint) (SEARCH_PAGE_USER_COUNT - 1))) {
		return;
	}
	_tmp1_ = node;
	_tmp2_ = json_node_get_object (_tmp1_);
	_tmp3_ = _json_object_ref0 (_tmp2_);
	user_obj = _tmp3_;
	_tmp4_ = user_list_entry_new ();
	g_object_ref_sink (_tmp4_);
	entry = _tmp4_;
	_tmp5_ = entry;
	_tmp6_ = user_obj;
	_tmp7_ = json_object_get_string_member (_tmp6_, "screen_name");
	_tmp8_ = g_strconcat ("@", _tmp7_, NULL);
	_tmp9_ = _tmp8_;
	user_list_entry_set_screen_name (_tmp5_, _tmp9_);
	_g_free0 (_tmp9_);
	_tmp10_ = entry;
	_tmp11_ = user_obj;
	_tmp12_ = json_object_get_string_member (_tmp11_, "name");
	_tmp13_ = string_strip (_tmp12_);
	_tmp14_ = _tmp13_;
	user_list_entry_set_name (_tmp10_, _tmp14_);
	_g_free0 (_tmp14_);
	_tmp15_ = entry;
	_tmp16_ = user_obj;
	_tmp17_ = json_object_get_string_member (_tmp16_, "profile_image_url");
	user_list_entry_set_avatar (_tmp15_, _tmp17_);
	_tmp18_ = entry;
	_tmp19_ = user_obj;
	_tmp20_ = json_object_get_int_member (_tmp19_, "id");
	user_list_entry_set_user_id (_tmp18_, _tmp20_);
	_tmp21_ = entry;
	user_list_entry_set_show_settings (_tmp21_, FALSE);
	_tmp22_ = entry;
	gtk_widget_set_visible (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, gtk_widget_get_type (), GtkWidget), FALSE);
	_tmp23_ = self->priv->tweet_list;
	_tmp24_ = entry;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (entry);
	_json_object_unref0 (user_obj);
}


static void ___lambda177__json_array_foreach (JsonArray* array, guint index_, JsonNode* element_node, gpointer self) {
	__lambda177_ ((SearchPage*) self, array, index_, element_node);
}


static void __lambda176_ (SearchPage* self, GObject* _, GAsyncResult* res) {
	JsonNode* root = NULL;
	GAsyncResult* _tmp0_ = NULL;
	JsonNode* _tmp1_ = NULL;
	JsonNode* _tmp2_ = NULL;
	JsonArray* users = NULL;
	JsonNode* _tmp4_ = NULL;
	JsonArray* _tmp5_ = NULL;
	JsonArray* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
	JsonArray* _tmp8_ = NULL;
	guint _tmp9_ = 0U;
	gint _tmp14_ = 0;
	JsonArray* _tmp16_ = NULL;
	JsonArray* _tmp17_ = NULL;
	guint _tmp18_ = 0U;
	Collect* _tmp26_ = NULL;
	g_return_if_fail ((_ == NULL) || G_IS_OBJECT (_));
	g_return_if_fail (G_IS_ASYNC_RESULT (res));
	_tmp0_ = res;
	_tmp1_ = tweet_utils_load_threaded_finish (_tmp0_);
	root = _tmp1_;
	_tmp2_ = root;
	if (_tmp2_ == NULL) {
		Collect* _tmp3_ = NULL;
		_tmp3_ = self->priv->collect_obj;
		collect_emit (_tmp3_, NULL);
		__vala_JsonNode_free0 (root);
		return;
	}
	_tmp4_ = root;
	_tmp5_ = json_node_get_array (_tmp4_);
	_tmp6_ = _json_array_ref0 (_tmp5_);
	users = _tmp6_;
	_tmp8_ = users;
	_tmp9_ = json_array_get_length (_tmp8_);
	if (_tmp9_ == ((guint) 0)) {
		gint _tmp10_ = 0;
		_tmp10_ = self->priv->n_results;
		_tmp7_ = _tmp10_ <= 0;
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		self->priv->n_results = -1;
	} else {
		gint _tmp11_ = 0;
		JsonArray* _tmp12_ = NULL;
		guint _tmp13_ = 0U;
		_tmp11_ = self->priv->n_results;
		_tmp12_ = users;
		_tmp13_ = json_array_get_length (_tmp12_);
		self->priv->n_results = _tmp11_ + ((gint) _tmp13_);
	}
	_tmp14_ = self->priv->n_results;
	if (_tmp14_ <= 0) {
		TweetListBox* _tmp15_ = NULL;
		_tmp15_ = self->priv->tweet_list;
		tweet_list_box_set_empty (_tmp15_);
	}
	_tmp16_ = users;
	json_array_foreach_element (_tmp16_, ___lambda177__json_array_foreach, self);
	_tmp17_ = users;
	_tmp18_ = json_array_get_length (_tmp17_);
	if (_tmp18_ > ((guint) SEARCH_PAGE_USER_COUNT)) {
		LoadMoreEntry* _tmp19_ = NULL;
		GtkContainer* _tmp20_ = NULL;
		GtkContainer* _tmp21_ = NULL;
		_tmp19_ = self->priv->load_more_entry;
		_tmp20_ = gtk_widget_get_parent (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, gtk_widget_get_type (), GtkWidget));
		_tmp21_ = _tmp20_;
		if (_tmp21_ == NULL) {
			LoadMoreEntry* _tmp22_ = NULL;
			TweetListBox* _tmp23_ = NULL;
			LoadMoreEntry* _tmp24_ = NULL;
			_tmp22_ = self->priv->load_more_entry;
			gtk_widget_set_visible (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, gtk_widget_get_type (), GtkWidget), FALSE);
			_tmp23_ = self->priv->tweet_list;
			_tmp24_ = self->priv->load_more_entry;
			gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, gtk_widget_get_type (), GtkWidget));
		}
	} else {
		LoadMoreEntry* _tmp25_ = NULL;
		_tmp25_ = self->priv->load_more_entry;
		gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, gtk_widget_get_type (), GtkWidget));
	}
	_tmp26_ = self->priv->collect_obj;
	collect_emit (_tmp26_, NULL);
	_json_array_unref0 (users);
	__vala_JsonNode_free0 (root);
}


static void ___lambda176__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda176_ ((SearchPage*) self, source_object, res);
	g_object_unref (self);
}


static void search_page_load_users (SearchPage* self) {
	RestProxyCall* user_call = NULL;
	Account* _tmp0_ = NULL;
	Account* _tmp1_ = NULL;
	OAuthProxy* _tmp2_ = NULL;
	OAuthProxy* _tmp3_ = NULL;
	RestProxyCall* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	g_return_if_fail (IS_SEARCH_PAGE (self));
	_tmp0_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp1_ = _tmp0_;
	_tmp2_ = account_get_proxy (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, rest_proxy_get_type (), RestProxy));
	user_call = _tmp4_;
	rest_proxy_call_set_method (user_call, "GET");
	rest_proxy_call_set_function (user_call, "1.1/users/search.json");
	_tmp5_ = self->priv->search_query;
	rest_proxy_call_add_param (user_call, "q", _tmp5_);
	_tmp6_ = g_strdup_printf ("%i", SEARCH_PAGE_USER_COUNT + 1);
	_tmp7_ = _tmp6_;
	rest_proxy_call_add_param (user_call, "count", _tmp7_);
	_g_free0 (_tmp7_);
	rest_proxy_call_add_param (user_call, "include_entities", "false");
	_tmp8_ = self->priv->user_page;
	_tmp9_ = g_strdup_printf ("%i", _tmp8_);
	_tmp10_ = _tmp9_;
	rest_proxy_call_add_param (user_call, "page", _tmp10_);
	_g_free0 (_tmp10_);
	tweet_utils_load_threaded (user_call, ___lambda176__gasync_ready_callback, g_object_ref (self));
	_g_object_unref0 (user_call);
}


static Block8Data* block8_data_ref (Block8Data* _data8_) {
	g_atomic_int_inc (&_data8_->_ref_count_);
	return _data8_;
}


static void block8_data_unref (void * _userdata_) {
	Block8Data* _data8_;
	_data8_ = (Block8Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data8_->_ref_count_)) {
		SearchPage* self;
		self = _data8_->self;
		_g_date_time_unref0 (_data8_->now);
		_g_object_unref0 (self);
		g_slice_free (Block8Data, _data8_);
	}
}


static void __lambda175_ (Block8Data* _data8_, JsonArray* array, guint index, JsonNode* node) {
	SearchPage* self;
	Tweet* tweet = NULL;
	Tweet* _tmp0_ = NULL;
	Tweet* _tmp1_ = NULL;
	JsonNode* _tmp2_ = NULL;
	GDateTime* _tmp3_ = NULL;
	Account* _tmp4_ = NULL;
	Account* _tmp5_ = NULL;
	Tweet* _tmp6_ = NULL;
	gint64 _tmp7_ = 0LL;
	gint64 _tmp8_ = 0LL;
	TweetListEntry* entry = NULL;
	Tweet* _tmp11_ = NULL;
	Tweet* _tmp12_ = NULL;
	MainWindow* _tmp13_ = NULL;
	MainWindow* _tmp14_ = NULL;
	Account* _tmp15_ = NULL;
	Account* _tmp16_ = NULL;
	TweetListEntry* _tmp17_ = NULL;
	DeltaUpdater* _tmp18_ = NULL;
	TweetListBox* _tmp19_ = NULL;
	self = _data8_->self;
	g_return_if_fail (array != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = tweet_new ();
	tweet = _tmp0_;
	_tmp1_ = tweet;
	_tmp2_ = node;
	_tmp3_ = _data8_->now;
	_tmp4_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp5_ = _tmp4_;
	tweet_load_from_json (_tmp1_, _tmp2_, _tmp3_, _tmp5_);
	_tmp6_ = tweet;
	_tmp7_ = _tmp6_->id;
	_tmp8_ = self->priv->lowest_tweet_id;
	if (_tmp7_ < _tmp8_) {
		Tweet* _tmp9_ = NULL;
		gint64 _tmp10_ = 0LL;
		_tmp9_ = tweet;
		_tmp10_ = _tmp9_->id;
		self->priv->lowest_tweet_id = _tmp10_;
	}
	_tmp11_ = tweet;
	_tmp12_ = _g_object_ref0 (_tmp11_);
	_tmp13_ = ipage_get_main_window (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp14_ = _tmp13_;
	_tmp15_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp16_ = _tmp15_;
	_tmp17_ = tweet_list_entry_new (_tmp12_, _tmp14_, _tmp16_);
	g_object_ref_sink (_tmp17_);
	entry = _tmp17_;
	_tmp18_ = self->delta_updater;
	delta_updater_add (_tmp18_, G_TYPE_CHECK_INSTANCE_CAST (entry, TYPE_ITWITTER_ITEM, ITwitterItem));
	gtk_widget_set_visible (G_TYPE_CHECK_INSTANCE_CAST (entry, gtk_widget_get_type (), GtkWidget), FALSE);
	_tmp19_ = self->priv->tweet_list;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (entry, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (entry);
	_g_object_unref0 (tweet);
}


static void ___lambda175__json_array_foreach (JsonArray* array, guint index_, JsonNode* element_node, gpointer self) {
	__lambda175_ (self, array, index_, element_node);
}


static void __lambda174_ (SearchPage* self, GObject* _, GAsyncResult* res) {
	Block8Data* _data8_;
	JsonNode* root = NULL;
	GAsyncResult* _tmp0_ = NULL;
	JsonNode* _tmp1_ = NULL;
	JsonNode* _tmp2_ = NULL;
	GDateTime* _tmp4_ = NULL;
	JsonArray* statuses = NULL;
	JsonNode* _tmp5_ = NULL;
	JsonObject* _tmp6_ = NULL;
	JsonArray* _tmp7_ = NULL;
	JsonArray* _tmp8_ = NULL;
	gboolean _tmp9_ = FALSE;
	JsonArray* _tmp10_ = NULL;
	guint _tmp11_ = 0U;
	gint _tmp16_ = 0;
	JsonArray* _tmp18_ = NULL;
	Collect* _tmp19_ = NULL;
	g_return_if_fail ((_ == NULL) || G_IS_OBJECT (_));
	g_return_if_fail (G_IS_ASYNC_RESULT (res));
	_data8_ = g_slice_new0 (Block8Data);
	_data8_->_ref_count_ = 1;
	_data8_->self = g_object_ref (self);
	_tmp0_ = res;
	_tmp1_ = tweet_utils_load_threaded_finish (_tmp0_);
	root = _tmp1_;
	_tmp2_ = root;
	if (_tmp2_ == NULL) {
		Collect* _tmp3_ = NULL;
		_tmp3_ = self->priv->collect_obj;
		collect_emit (_tmp3_, NULL);
		__vala_JsonNode_free0 (root);
		block8_data_unref (_data8_);
		_data8_ = NULL;
		return;
	}
	_tmp4_ = g_date_time_new_now_local ();
	_data8_->now = _tmp4_;
	_tmp5_ = root;
	_tmp6_ = json_node_get_object (_tmp5_);
	_tmp7_ = json_object_get_array_member (_tmp6_, "statuses");
	_tmp8_ = _json_array_ref0 (_tmp7_);
	statuses = _tmp8_;
	_tmp10_ = statuses;
	_tmp11_ = json_array_get_length (_tmp10_);
	if (_tmp11_ == ((guint) 0)) {
		gint _tmp12_ = 0;
		_tmp12_ = self->priv->n_results;
		_tmp9_ = _tmp12_ <= 0;
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		self->priv->n_results = -1;
	} else {
		gint _tmp13_ = 0;
		JsonArray* _tmp14_ = NULL;
		guint _tmp15_ = 0U;
		_tmp13_ = self->priv->n_results;
		_tmp14_ = statuses;
		_tmp15_ = json_array_get_length (_tmp14_);
		self->priv->n_results = _tmp13_ + ((gint) _tmp15_);
	}
	_tmp16_ = self->priv->n_results;
	if (_tmp16_ <= 0) {
		TweetListBox* _tmp17_ = NULL;
		_tmp17_ = self->priv->tweet_list;
		tweet_list_box_set_empty (_tmp17_);
	}
	_tmp18_ = statuses;
	json_array_foreach_element (_tmp18_, ___lambda175__json_array_foreach, _data8_);
	self->priv->loading_tweets = FALSE;
	_tmp19_ = self->priv->collect_obj;
	collect_emit (_tmp19_, NULL);
	_json_array_unref0 (statuses);
	__vala_JsonNode_free0 (root);
	block8_data_unref (_data8_);
	_data8_ = NULL;
}


static void ___lambda174__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda174_ ((SearchPage*) self, source_object, res);
	g_object_unref (self);
}


static void search_page_load_tweets (SearchPage* self) {
	gboolean _tmp0_ = FALSE;
	RestProxyCall* call = NULL;
	Account* _tmp1_ = NULL;
	Account* _tmp2_ = NULL;
	OAuthProxy* _tmp3_ = NULL;
	OAuthProxy* _tmp4_ = NULL;
	RestProxyCall* _tmp5_ = NULL;
	RestProxyCall* _tmp6_ = NULL;
	RestProxyCall* _tmp7_ = NULL;
	RestProxyCall* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	RestProxyCall* _tmp10_ = NULL;
	gint64 _tmp11_ = 0LL;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	RestProxyCall* _tmp14_ = NULL;
	RestProxyCall* _tmp15_ = NULL;
	g_return_if_fail (IS_SEARCH_PAGE (self));
	_tmp0_ = self->priv->loading_tweets;
	if (_tmp0_) {
		return;
	}
	self->priv->loading_tweets = TRUE;
	_tmp1_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp2_ = _tmp1_;
	_tmp3_ = account_get_proxy (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, rest_proxy_get_type (), RestProxy));
	call = _tmp5_;
	_tmp6_ = call;
	rest_proxy_call_set_function (_tmp6_, "1.1/search/tweets.json");
	_tmp7_ = call;
	rest_proxy_call_set_method (_tmp7_, "GET");
	_tmp8_ = call;
	_tmp9_ = self->priv->search_query;
	rest_proxy_call_add_param (_tmp8_, "q", _tmp9_);
	_tmp10_ = call;
	_tmp11_ = self->priv->lowest_tweet_id;
	_tmp12_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp11_ - 1);
	_tmp13_ = _tmp12_;
	rest_proxy_call_add_param (_tmp10_, "max_id", _tmp13_);
	_g_free0 (_tmp13_);
	_tmp14_ = call;
	rest_proxy_call_add_param (_tmp14_, "count", "35");
	_tmp15_ = call;
	tweet_utils_load_threaded (_tmp15_, ___lambda174__gasync_ready_callback, g_object_ref (self));
	_g_object_unref0 (call);
}


static void __lambda173_ (SearchPage* self, GtkWidget* w) {
	GtkWidget* _tmp0_ = NULL;
	g_return_if_fail (GTK_IS_WIDGET (w));
	_tmp0_ = w;
	gtk_widget_show (_tmp0_);
}


static void ___lambda173__gtk_callback (GtkWidget* widget, gpointer self) {
	__lambda173_ ((SearchPage*) self, widget);
}


static void search_page_show_entries (SearchPage* self, GError* e) {
	GError* _tmp0_ = NULL;
	TweetListBox* _tmp5_ = NULL;
	g_return_if_fail (IS_SEARCH_PAGE (self));
	_tmp0_ = e;
	if (_tmp0_ != NULL) {
		TweetListBox* _tmp1_ = NULL;
		GError* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		TweetListBox* _tmp4_ = NULL;
		_tmp1_ = self->priv->tweet_list;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		tweet_list_box_set_error (_tmp1_, _tmp3_);
		_tmp4_ = self->priv->tweet_list;
		tweet_list_box_set_empty (_tmp4_);
		return;
	}
	_tmp5_ = self->priv->tweet_list;
	gtk_container_foreach (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_container_get_type (), GtkContainer), ___lambda173__gtk_callback, self);
}


static void search_page_real_create_tool_button (IPage* base, GtkRadioButton* group) {
	SearchPage * self;
	GtkRadioButton* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	BadgeRadioToolButton* _tmp2_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_SEARCH_PAGE, SearchPage);
	g_return_if_fail ((group == NULL) || GTK_IS_RADIO_BUTTON (group));
	_tmp0_ = group;
	_tmp1_ = _ ("Search");
	_tmp2_ = badge_radio_tool_button_new (_tmp0_, "edit-find-symbolic", _tmp1_);
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->tool_button);
	self->priv->tool_button = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_radio_button_get_type (), GtkRadioButton);
}


static GtkRadioButton* search_page_real_get_tool_button (IPage* base) {
	SearchPage * self;
	GtkRadioButton* result = NULL;
	GtkRadioButton* _tmp0_ = NULL;
	GtkRadioButton* _tmp1_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_SEARCH_PAGE, SearchPage);
	_tmp0_ = self->priv->tool_button;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


static gchar* search_page_real_get_title (IPage* base) {
	SearchPage * self;
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_SEARCH_PAGE, SearchPage);
	_tmp0_ = _ ("Search");
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


static gboolean search_page_real_handles_double_open (IPage* base) {
	SearchPage * self;
	gboolean result = FALSE;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_SEARCH_PAGE, SearchPage);
	result = TRUE;
	return result;
}


gint search_page_get_unread_count (SearchPage* self) {
	gint result;
	g_return_val_if_fail (IS_SEARCH_PAGE (self), 0);
	result = 0;
	return result;
}


void search_page_set_unread_count (SearchPage* self, gint value) {
	g_return_if_fail (IS_SEARCH_PAGE (self));
	g_object_notify ((GObject *) self, "unread-count");
}


static Account* search_page_real_get_account (IPage* base) {
	Account* result;
	SearchPage* self;
	Account* _tmp0_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_SEARCH_PAGE, SearchPage);
	_tmp0_ = self->priv->_account;
	result = _tmp0_;
	return result;
}


static void search_page_real_set_account (IPage* base, Account* value) {
	SearchPage* self;
	Account* _tmp0_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_SEARCH_PAGE, SearchPage);
	_tmp0_ = value;
	self->priv->_account = _tmp0_;
	g_object_notify ((GObject *) self, "account");
}


static MainWindow* search_page_real_get_main_window (IPage* base) {
	MainWindow* result;
	SearchPage* self;
	MainWindow* _tmp0_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_SEARCH_PAGE, SearchPage);
	_tmp0_ = self->priv->_main_window;
	result = _tmp0_;
	return result;
}


static void search_page_real_set_main_window (IPage* base, MainWindow* value) {
	SearchPage* self;
	MainWindow* _tmp0_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_SEARCH_PAGE, SearchPage);
	_tmp0_ = value;
	self->priv->_main_window = _tmp0_;
	g_object_notify ((GObject *) self, "main-window");
}


static gint search_page_real_get_id (IPage* base) {
	gint result;
	SearchPage* self;
	gint _tmp0_ = 0;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_SEARCH_PAGE, SearchPage);
	_tmp0_ = self->priv->_id;
	result = _tmp0_;
	return result;
}


static void search_page_real_set_id (IPage* base, gint value) {
	SearchPage* self;
	gint _tmp0_ = 0;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_SEARCH_PAGE, SearchPage);
	_tmp0_ = value;
	self->priv->_id = _tmp0_;
	g_object_notify ((GObject *) self, "id");
}


static void search_page_class_init (SearchPageClass * klass) {
	gint SearchPage_private_offset;
	search_page_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SearchPagePrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_search_page_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_search_page_set_property;
	G_OBJECT_CLASS (klass)->finalize = search_page_finalize;
	/** The unread count here is always zero */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEARCH_PAGE_UNREAD_COUNT, g_param_spec_int ("unread-count", "unread-count", "unread-count", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEARCH_PAGE_ACCOUNT, g_param_spec_object ("account", "account", "account", TYPE_ACCOUNT, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEARCH_PAGE_MAIN_WINDOW, g_param_spec_object ("main-window", "main-window", "main-window", TYPE_MAIN_WINDOW, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEARCH_PAGE_ID, g_param_spec_int ("id", "id", "id", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	SearchPage_private_offset = g_type_class_get_instance_private_offset (klass);
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/baedert/corebird/ui/search-page.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "search_entry", FALSE, SearchPage_private_offset + G_STRUCT_OFFSET (SearchPagePrivate, search_entry));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "search_button", FALSE, SearchPage_private_offset + G_STRUCT_OFFSET (SearchPagePrivate, search_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "tweet_list", FALSE, SearchPage_private_offset + G_STRUCT_OFFSET (SearchPagePrivate, tweet_list));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "users_header", FALSE, SearchPage_private_offset + G_STRUCT_OFFSET (SearchPagePrivate, users_header));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "tweets_header", FALSE, SearchPage_private_offset + G_STRUCT_OFFSET (SearchPagePrivate, tweets_header));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "scroll_widget", FALSE, SearchPage_private_offset + G_STRUCT_OFFSET (SearchPagePrivate, scroll_widget));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "search_entry_activate_cb", G_CALLBACK(_search_page_search_entry_activate_cb_gtk_entry_activate));
}


static void search_page_ipage_interface_init (IPageIface * iface) {
	search_page_ipage_parent_iface = g_type_interface_peek_parent (iface);
	iface->on_join = (void (*)(IPage*, gint, Bundle*)) search_page_real_on_join;
	iface->on_leave = (void (*)(IPage*)) search_page_real_on_leave;
	iface->create_tool_button = (void (*)(IPage*, GtkRadioButton*)) search_page_real_create_tool_button;
	iface->get_tool_button = (GtkRadioButton* (*)(IPage*)) search_page_real_get_tool_button;
	iface->get_title = (gchar* (*)(IPage*)) search_page_real_get_title;
	iface->handles_double_open = (gboolean (*)(IPage*)) search_page_real_handles_double_open;
	iface->get_account = search_page_real_get_account;
	iface->set_account = search_page_real_set_account;
	iface->get_main_window = search_page_real_get_main_window;
	iface->set_main_window = search_page_real_set_main_window;
	iface->get_id = search_page_real_get_id;
	iface->set_id = search_page_real_set_id;
}


static void search_page_instance_init (SearchPage * self) {
	LoadMoreEntry* _tmp0_ = NULL;
	self->priv = SEARCH_PAGE_GET_PRIVATE (self);
	_tmp0_ = load_more_entry_new ();
	g_object_ref_sink (_tmp0_);
	self->priv->load_more_entry = _tmp0_;
	self->priv->user_page = 1;
	self->priv->lowest_tweet_id = G_MAXINT64 - 1;
	self->priv->loading_tweets = FALSE;
	self->priv->n_results = 0;
	g_type_ensure (TYPE_SCROLL_WIDGET);
	g_type_ensure (TYPE_TWEET_LIST_BOX);
	gtk_widget_init_template (GTK_WIDGET (self));
}


static void search_page_finalize (GObject* obj) {
	SearchPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SEARCH_PAGE, SearchPage);
	_g_object_unref0 (self->priv->search_entry);
	_g_object_unref0 (self->priv->search_button);
	_g_object_unref0 (self->priv->tweet_list);
	_g_object_unref0 (self->priv->users_header);
	_g_object_unref0 (self->priv->tweets_header);
	_g_object_unref0 (self->priv->scroll_widget);
	_g_object_unref0 (self->priv->tool_button);
	_g_object_unref0 (self->delta_updater);
	_g_object_unref0 (self->priv->load_more_entry);
	_g_free0 (self->priv->search_query);
	_g_object_unref0 (self->priv->last_focus_widget);
	_g_object_unref0 (self->priv->collect_obj);
	G_OBJECT_CLASS (search_page_parent_class)->finalize (obj);
}


GType search_page_get_type (void) {
	static volatile gsize search_page_type_id__volatile = 0;
	if (g_once_init_enter (&search_page_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SearchPageClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) search_page_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SearchPage), 0, (GInstanceInitFunc) search_page_instance_init, NULL };
		static const GInterfaceInfo ipage_info = { (GInterfaceInitFunc) search_page_ipage_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType search_page_type_id;
		search_page_type_id = g_type_register_static (gtk_box_get_type (), "SearchPage", &g_define_type_info, 0);
		g_type_add_interface_static (search_page_type_id, TYPE_IPAGE, &ipage_info);
		g_once_init_leave (&search_page_type_id__volatile, search_page_type_id);
	}
	return search_page_type_id__volatile;
}


static void _vala_search_page_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SearchPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SEARCH_PAGE, SearchPage);
	switch (property_id) {
		case SEARCH_PAGE_UNREAD_COUNT:
		g_value_set_int (value, search_page_get_unread_count (self));
		break;
		case SEARCH_PAGE_ACCOUNT:
		g_value_set_object (value, ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage)));
		break;
		case SEARCH_PAGE_MAIN_WINDOW:
		g_value_set_object (value, ipage_get_main_window (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage)));
		break;
		case SEARCH_PAGE_ID:
		g_value_set_int (value, ipage_get_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage)));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_search_page_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SearchPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SEARCH_PAGE, SearchPage);
	switch (property_id) {
		case SEARCH_PAGE_UNREAD_COUNT:
		search_page_set_unread_count (self, g_value_get_int (value));
		break;
		case SEARCH_PAGE_ACCOUNT:
		ipage_set_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage), g_value_get_object (value));
		break;
		case SEARCH_PAGE_MAIN_WINDOW:
		ipage_set_main_window (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage), g_value_get_object (value));
		break;
		case SEARCH_PAGE_ID:
		ipage_set_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage), g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


LoadMoreEntry* load_more_entry_construct (GType object_type) {
	LoadMoreEntry * self = NULL;
	self = (LoadMoreEntry*) g_object_new (object_type, NULL);
	gtk_list_box_row_set_activatable (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_list_box_row_get_type (), GtkListBoxRow), FALSE);
	return self;
}


LoadMoreEntry* load_more_entry_new (void) {
	return load_more_entry_construct (TYPE_LOAD_MORE_ENTRY);
}


GtkButton* load_more_entry_get_button (LoadMoreEntry* self) {
	GtkButton* result = NULL;
	GtkButton* _tmp0_ = NULL;
	GtkButton* _tmp1_ = NULL;
	g_return_val_if_fail (IS_LOAD_MORE_ENTRY (self), NULL);
	_tmp0_ = self->priv->load_more_button;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


static gint load_more_entry_real_update_time_delta (ITwitterItem* base, GDateTime* now) {
	LoadMoreEntry * self;
	gint result = 0;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_LOAD_MORE_ENTRY, LoadMoreEntry);
	result = 0;
	return result;
}


static gint64 load_more_entry_real_get_sort_factor (ITwitterItem* base) {
	gint64 result;
	LoadMoreEntry* self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_LOAD_MORE_ENTRY, LoadMoreEntry);
	result = G_MAXINT64 - 2;
	return result;
}


static gboolean load_more_entry_real_get_seen (ITwitterItem* base) {
	gboolean result;
	LoadMoreEntry* self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_LOAD_MORE_ENTRY, LoadMoreEntry);
	result = TRUE;
	return result;
}


static void load_more_entry_real_set_seen (ITwitterItem* base, gboolean value) {
	LoadMoreEntry* self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_LOAD_MORE_ENTRY, LoadMoreEntry);
	g_object_notify ((GObject *) self, "seen");
}


static void load_more_entry_class_init (LoadMoreEntryClass * klass) {
	gint LoadMoreEntry_private_offset;
	load_more_entry_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (LoadMoreEntryPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_load_more_entry_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_load_more_entry_set_property;
	G_OBJECT_CLASS (klass)->finalize = load_more_entry_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), LOAD_MORE_ENTRY_SORT_FACTOR, g_param_spec_int64 ("sort-factor", "sort-factor", "sort-factor", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), LOAD_MORE_ENTRY_SEEN, g_param_spec_boolean ("seen", "seen", "seen", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	LoadMoreEntry_private_offset = g_type_class_get_instance_private_offset (klass);
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/baedert/corebird/ui/load-more-entry.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "load_more_button", FALSE, LoadMoreEntry_private_offset + G_STRUCT_OFFSET (LoadMoreEntryPrivate, load_more_button));
}


static void load_more_entry_itwitter_item_interface_init (ITwitterItemIface * iface) {
	load_more_entry_itwitter_item_parent_iface = g_type_interface_peek_parent (iface);
	iface->update_time_delta = (gint (*)(ITwitterItem*, GDateTime*)) load_more_entry_real_update_time_delta;
	iface->get_sort_factor = load_more_entry_real_get_sort_factor;
	iface->get_seen = load_more_entry_real_get_seen;
	iface->set_seen = load_more_entry_real_set_seen;
}


static void load_more_entry_instance_init (LoadMoreEntry * self) {
	self->priv = LOAD_MORE_ENTRY_GET_PRIVATE (self);
	gtk_widget_init_template (GTK_WIDGET (self));
}


static void load_more_entry_finalize (GObject* obj) {
	LoadMoreEntry * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_LOAD_MORE_ENTRY, LoadMoreEntry);
	_g_object_unref0 (self->priv->load_more_button);
	G_OBJECT_CLASS (load_more_entry_parent_class)->finalize (obj);
}


GType load_more_entry_get_type (void) {
	static volatile gsize load_more_entry_type_id__volatile = 0;
	if (g_once_init_enter (&load_more_entry_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (LoadMoreEntryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) load_more_entry_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (LoadMoreEntry), 0, (GInstanceInitFunc) load_more_entry_instance_init, NULL };
		static const GInterfaceInfo itwitter_item_info = { (GInterfaceInitFunc) load_more_entry_itwitter_item_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType load_more_entry_type_id;
		load_more_entry_type_id = g_type_register_static (gtk_list_box_row_get_type (), "LoadMoreEntry", &g_define_type_info, 0);
		g_type_add_interface_static (load_more_entry_type_id, TYPE_ITWITTER_ITEM, &itwitter_item_info);
		g_once_init_leave (&load_more_entry_type_id__volatile, load_more_entry_type_id);
	}
	return load_more_entry_type_id__volatile;
}


static void _vala_load_more_entry_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	LoadMoreEntry * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_LOAD_MORE_ENTRY, LoadMoreEntry);
	switch (property_id) {
		case LOAD_MORE_ENTRY_SORT_FACTOR:
		g_value_set_int64 (value, itwitter_item_get_sort_factor (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_ITWITTER_ITEM, ITwitterItem)));
		break;
		case LOAD_MORE_ENTRY_SEEN:
		g_value_set_boolean (value, itwitter_item_get_seen (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_ITWITTER_ITEM, ITwitterItem)));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_load_more_entry_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	LoadMoreEntry * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_LOAD_MORE_ENTRY, LoadMoreEntry);
	switch (property_id) {
		case LOAD_MORE_ENTRY_SEEN:
		itwitter_item_set_seen (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_ITWITTER_ITEM, ITwitterItem), g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



