/* InlineMediaDownloader.c generated by valac 0.26.2, the Vala compiler
 * generated from InlineMediaDownloader.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <glib/gstdio.h>
#include <stdlib.h>
#include <string.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <float.h>
#include <math.h>
#include <libsoup/soup.h>

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_TWEET (tweet_get_type ())
#define TWEET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWEET, Tweet))
#define TWEET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWEET, TweetClass))
#define IS_TWEET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWEET))
#define IS_TWEET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWEET))
#define TWEET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWEET, TweetClass))

typedef struct _Tweet Tweet;
typedef struct _TweetClass TweetClass;

#define TYPE_MEDIA (media_get_type ())
#define MEDIA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA, Media))
#define MEDIA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA, MediaClass))
#define IS_MEDIA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA))
#define IS_MEDIA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA))
#define MEDIA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA, MediaClass))

typedef struct _Media Media;
typedef struct _MediaClass MediaClass;
typedef struct _InlineMediaDownloaderLoadMediaData InlineMediaDownloaderLoadMediaData;
typedef struct _MediaPrivate MediaPrivate;

#define TYPE_MEDIA_TYPE (media_type_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block20Data Block20Data;
#define _g_match_info_unref0(var) ((var == NULL) ? NULL : (var = (g_match_info_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
typedef struct _InlineMediaDownloaderLoadRealUrlData InlineMediaDownloaderLoadRealUrlData;
typedef struct _Block21Data Block21Data;
typedef struct _InlineMediaDownloaderLoadInlineMediaData InlineMediaDownloaderLoadInlineMediaData;
typedef struct _TweetPrivate TweetPrivate;
typedef struct _InlineMediaDownloaderLoadAnimationData InlineMediaDownloaderLoadAnimationData;
typedef struct _InlineMediaDownloaderLoadNormalMediaData InlineMediaDownloaderLoadNormalMediaData;

struct _InlineMediaDownloaderLoadMediaData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	Tweet* t;
	Media* media;
	Tweet* _tmp0_;
	Media* _tmp1_;
};

typedef enum  {
	MEDIA_TYPE_IMAGE,
	MEDIA_TYPE_VINE,
	MEDIA_TYPE_GIF,
	MEDIA_TYPE_ANIMATED_GIF,
	MEDIA_TYPE_TWITTER_VIDEO,
	MEDIA_TYPE_UNKNOWN
} MediaType;

struct _Media {
	GObject parent_instance;
	MediaPrivate * priv;
	gint64 id;
	gchar* path;
	gchar* thumb_path;
	gchar* url;
	MediaType type;
	GdkPixbuf* thumbnail;
	gboolean loaded;
	gboolean invalid;
};

struct _MediaClass {
	GObjectClass parent_class;
};

struct _Block20Data {
	int _ref_count_;
	SoupMessage* msg;
	Media* media;
	gchar* regex_str1;
	gint match_index1;
	gpointer _async_data_;
};

struct _InlineMediaDownloaderLoadRealUrlData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	Tweet* t;
	Media* media;
	gchar* regex_str1;
	gint match_index1;
	Block20Data* _data20_;
	Media* _tmp0_;
	const gchar* _tmp1_;
	gint _tmp2_;
	Media* _tmp3_;
	const gchar* _tmp4_;
	SoupMessage* _tmp5_;
	SoupSession* _tmp6_;
	SoupMessage* _tmp7_;
};

struct _Block21Data {
	int _ref_count_;
	GSourceFunc callback;
	gpointer callback_target;
	GDestroyNotify callback_target_destroy_notify;
	gchar* ext;
	GOutputStream* thumb_out_stream;
	GOutputStream* media_out_stream;
	SoupMessage* msg;
	Tweet* t;
	Media* media;
	gpointer _async_data_;
};

struct _InlineMediaDownloaderLoadInlineMediaData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	Tweet* t;
	Media* media;
	Block21Data* _data21_;
	Tweet* _tmp0_;
	Media* _tmp1_;
	Media* _tmp2_;
	Tweet* _tmp3_;
	Media* _tmp4_;
	gchar* _tmp5_;
	Media* _tmp6_;
	Tweet* _tmp7_;
	Media* _tmp8_;
	gchar* _tmp9_;
	Media* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	const gchar* _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	gchar* _tmp16_;
	const gchar* _tmp17_;
	gchar* _tmp18_;
	gint qm_index;
	const gchar* _tmp19_;
	gint _tmp20_;
	gint _tmp21_;
	const gchar* _tmp22_;
	gint _tmp23_;
	gchar* _tmp24_;
	const gchar* _tmp25_;
	gchar* _tmp26_;
	gboolean main_file_exists;
	GFileOutputStream* _tmp27_;
	Media* _tmp28_;
	const gchar* _tmp29_;
	GFile* _tmp30_;
	GFile* _tmp31_;
	GFileOutputStream* _tmp32_;
	GFileOutputStream* _tmp33_;
	GFileOutputStream* _tmp34_;
	GError* e;
	GError* _tmp35_;
	GError* _tmp36_;
	const gchar* _tmp37_;
	GFileOutputStream* _tmp38_;
	Media* _tmp39_;
	const gchar* _tmp40_;
	GFile* _tmp41_;
	GFile* _tmp42_;
	GFileOutputStream* _tmp43_;
	GFileOutputStream* _tmp44_;
	GFileOutputStream* _tmp45_;
	gboolean _tmp46_;
	GFileInputStream* in_stream;
	Media* _tmp47_;
	const gchar* _tmp48_;
	GFile* _tmp49_;
	GFile* _tmp50_;
	GFileInputStream* _tmp51_;
	GFileInputStream* _tmp52_;
	Tweet* _tmp53_;
	GFileInputStream* _tmp54_;
	GOutputStream* _tmp55_;
	Media* _tmp56_;
	GError* _vala1_e;
	GError* _tmp57_;
	gboolean _tmp58_;
	GdkPixbuf* thumb;
	Media* _tmp59_;
	const gchar* _tmp60_;
	GdkPixbuf* _tmp61_;
	Media* _tmp62_;
	GdkPixbuf* _tmp63_;
	GdkPixbuf* _tmp64_;
	Media* _tmp65_;
	Media* _tmp66_;
	GError* _vala2_e;
	GError* _tmp67_;
	const gchar* _tmp68_;
	GError* _tmp69_;
	gint _tmp70_;
	Media* _tmp71_;
	const gchar* _tmp72_;
	GFileOutputStream* _tmp73_;
	Media* _tmp74_;
	const gchar* _tmp75_;
	GFile* _tmp76_;
	GFile* _tmp77_;
	GFileOutputStream* _tmp78_;
	GFileOutputStream* _tmp79_;
	GFileOutputStream* _tmp80_;
	GError* _vala3_e;
	GError* _tmp81_;
	const gchar* _tmp82_;
	GError* _tmp83_;
	const gchar* _tmp84_;
	gchar* url;
	Media* _tmp85_;
	const gchar* _tmp86_;
	gchar* _tmp87_;
	gboolean _tmp88_;
	gboolean _tmp89_;
	gboolean _tmp90_;
	gboolean _tmp91_;
	gboolean _tmp92_;
	gboolean _tmp93_;
	gboolean _tmp94_;
	const gchar* _tmp95_;
	gboolean _tmp96_;
	const gchar* _tmp97_;
	gboolean _tmp98_;
	const gchar* _tmp99_;
	gboolean _tmp100_;
	const gchar* _tmp101_;
	gboolean _tmp102_;
	const gchar* _tmp103_;
	gboolean _tmp104_;
	const gchar* _tmp105_;
	gboolean _tmp106_;
	const gchar* _tmp107_;
	gboolean _tmp108_;
	const gchar* _tmp109_;
	gboolean _tmp110_;
	Tweet* _tmp111_;
	Media* _tmp112_;
	const gchar* _tmp113_;
	gboolean _tmp114_;
	Tweet* _tmp115_;
	Media* _tmp116_;
	const gchar* _tmp117_;
	gboolean _tmp118_;
	Tweet* _tmp119_;
	Media* _tmp120_;
	const gchar* _tmp121_;
	gboolean _tmp122_;
	Tweet* _tmp123_;
	Media* _tmp124_;
	const gchar* _tmp125_;
	gboolean _tmp126_;
	Tweet* _tmp127_;
	Media* _tmp128_;
	Media* _tmp129_;
	const gchar* _tmp130_;
	const gchar* _tmp131_;
	SoupMessage* _tmp132_;
	SoupMessage* _tmp133_;
	SoupMessage* _tmp134_;
	SoupSession* _tmp135_;
	SoupMessage* _tmp136_;
	SoupMessage* _tmp137_;
	GError * _inner_error_;
};

struct _Tweet {
	GObject parent_instance;
	TweetPrivate * priv;
	gint64 id;
	gint64 rt_id;
	gchar* text;
	gint64 user_id;
	gchar* user_name;
	gchar* retweeted_by;
	gchar* rt_by_screen_name;
	gint64 rt_by_id;
	gboolean is_retweet;
	GdkPixbuf* inline_media;
	gchar* time_delta;
	gchar* avatar_url;
	gchar* avatar_name;
	gchar* screen_name;
	gint64 created_at;
	gint64 rt_created_at;
	gboolean verified;
	gint64 my_retweet;
	gboolean protected;
	gint64 reply_id;
	Media** medias;
	gint medias_length1;
	gint retweet_count;
	gint favorite_count;
	gchar** mentions;
	gint mentions_length1;
};

struct _TweetClass {
	GObjectClass parent_class;
};

struct _InlineMediaDownloaderLoadAnimationData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	Tweet* t;
	GMemoryInputStream* in_stream;
	GOutputStream* thumb_out_stream;
	Media* media;
	GdkPixbufAnimation* anim;
	GdkPixbufAnimation* _tmp0_;
	GMemoryInputStream* _tmp1_;
	GdkPixbufAnimation* _tmp2_;
	GdkPixbufAnimation* _tmp3_;
	GError* e;
	GError* _tmp4_;
	const gchar* _tmp5_;
	Media* _tmp6_;
	GMemoryInputStream* _tmp7_;
	GOutputStream* _tmp8_;
	GdkPixbuf* pic;
	GdkPixbufAnimation* _tmp9_;
	GdkPixbuf* _tmp10_;
	GdkPixbuf* _tmp11_;
	gint thumb_width;
	Tweet* _tmp12_;
	Media** _tmp13_;
	gint _tmp13__length1;
	GdkPixbuf* thumb;
	GdkPixbuf* _tmp14_;
	gint _tmp15_;
	GdkPixbuf* _tmp16_;
	GdkPixbuf* _tmp17_;
	GOutputStream* _tmp18_;
	Media* _tmp19_;
	GdkPixbuf* _tmp20_;
	GdkPixbuf* _tmp21_;
	Media* _tmp22_;
	Media* _tmp23_;
	GMemoryInputStream* _tmp24_;
	GOutputStream* _tmp25_;
	GError* _vala1_e;
	GError* _tmp26_;
	const gchar* _tmp27_;
	GError * _inner_error_;
};

struct _InlineMediaDownloaderLoadNormalMediaData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	Tweet* t;
	GInputStream* in_stream;
	GOutputStream* thumb_out_stream;
	Media* media;
	GdkPixbuf* pic;
	GdkPixbuf* _tmp0_;
	GInputStream* _tmp1_;
	GdkPixbuf* _tmp2_;
	GdkPixbuf* _tmp3_;
	GError* e;
	GError* _tmp4_;
	const gchar* _tmp5_;
	Media* _tmp6_;
	const gchar* _tmp7_;
	Media* _tmp8_;
	GInputStream* _tmp9_;
	GOutputStream* _tmp10_;
	gint thumb_width;
	Tweet* _tmp11_;
	Media** _tmp12_;
	gint _tmp12__length1;
	GdkPixbuf* thumb;
	GdkPixbuf* _tmp13_;
	gint _tmp14_;
	GdkPixbuf* _tmp15_;
	GdkPixbuf* _tmp16_;
	GOutputStream* _tmp17_;
	Media* _tmp18_;
	GdkPixbuf* _tmp19_;
	GdkPixbuf* _tmp20_;
	Media* _tmp21_;
	Media* _tmp22_;
	GInputStream* _tmp23_;
	GOutputStream* _tmp24_;
	GError* _vala1_e;
	GError* _tmp25_;
	const gchar* _tmp26_;
	GError * _inner_error_;
};


extern SoupSession* SOUP_SESSION;

static void inline_media_downloader_load_media_data_free (gpointer _data);
GType tweet_get_type (void) G_GNUC_CONST;
GType media_get_type (void) G_GNUC_CONST;
void inline_media_downloader_load_media (Tweet* t, Media* media, GAsyncReadyCallback _callback_, gpointer _user_data_);
void inline_media_downloader_load_media_finish (GAsyncResult* _res_);
static gboolean inline_media_downloader_load_media_co (InlineMediaDownloaderLoadMediaData* _data_);
void inline_media_downloader_load_inline_media (Tweet* t, Media* media, GAsyncReadyCallback _callback_, gpointer _user_data_);
void inline_media_downloader_load_inline_media_finish (GAsyncResult* _res_);
static void inline_media_downloader_load_media_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void inline_media_downloader_load_all_media (Tweet* t, Media** medias, int medias_length1);
void inline_media_downloader_mark_invalid (Media* m, GInputStream* in_stream, GOutputStream* out_stream, GOutputStream* out_stream2);
GType media_type_get_type (void) G_GNUC_CONST;
gboolean inline_media_downloader_is_media_candidate (const gchar* url);
gdouble settings_max_media_size (void);
static void inline_media_downloader_load_real_url_data_free (gpointer _data);
void inline_media_downloader_load_real_url (Tweet* t, Media* media, const gchar* regex_str1, gint match_index1, GAsyncReadyCallback _callback_, gpointer _user_data_);
void inline_media_downloader_load_real_url_finish (GAsyncResult* _res_);
static gboolean inline_media_downloader_load_real_url_co (InlineMediaDownloaderLoadRealUrlData* _data_);
static Block20Data* block20_data_ref (Block20Data* _data20_);
static void block20_data_unref (void * _userdata_);
static void __lambda36_ (Block20Data* _data20_, SoupSession* _s, SoupMessage* _msg);
void media_set_thumb_url (Media* self, const gchar* value);
static void ___lambda36__soup_session_callback (SoupSession* session, SoupMessage* msg, gpointer self);
static void inline_media_downloader_load_inline_media_data_free (gpointer _data);
static gboolean inline_media_downloader_load_inline_media_co (InlineMediaDownloaderLoadInlineMediaData* _data_);
static Block21Data* block21_data_ref (Block21Data* _data21_);
static void block21_data_unref (void * _userdata_);
static gboolean _inline_media_downloader_load_inline_media_co_gsource_func (gpointer self);
gchar* inline_media_downloader_get_media_path (Tweet* t, Media* media);
gchar* inline_media_downloader_get_thumb_path (Tweet* t, Media* media);
gchar* utils_get_file_type (const gchar* path);
void inline_media_downloader_load_normal_media (Tweet* t, GInputStream* in_stream, GOutputStream* thumb_out_stream, Media* media, GAsyncReadyCallback _callback_, gpointer _user_data_);
void inline_media_downloader_load_normal_media_finish (GAsyncResult* _res_);
static void inline_media_downloader_load_inline_media_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
const gchar* media_get_thumb_url (Media* self);
static void __lambda37_ (Block21Data* _data21_);
void media_set_length (Media* self, gint64 value);
static void ___lambda37__soup_message_got_headers (SoupMessage* _sender, gpointer self);
static void __lambda38_ (Block21Data* _data21_, SoupBuffer* buf);
gint64 media_get_length (Media* self);
gdouble media_get_percent_loaded (Media* self);
void media_set_percent_loaded (Media* self, gdouble value);
static void ___lambda38__soup_message_got_chunk (SoupMessage* _sender, SoupBuffer* chunk, gpointer self);
static void __lambda39_ (Block21Data* _data21_, SoupSession* s, SoupMessage* _msg);
static guint8* _vala_array_dup5 (guint8* self, int length);
void inline_media_downloader_load_animation (Tweet* t, GMemoryInputStream* in_stream, GOutputStream* thumb_out_stream, Media* media, GAsyncReadyCallback _callback_, gpointer _user_data_);
void inline_media_downloader_load_animation_finish (GAsyncResult* _res_);
static void ____lambda40_ (Block21Data* _data21_);
static void _____lambda40__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void ____lambda41_ (Block21Data* _data21_);
static void _____lambda41__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void ___lambda39__soup_session_callback (SoupSession* session, SoupMessage* msg, gpointer self);
static void inline_media_downloader_load_animation_data_free (gpointer _data);
static gboolean inline_media_downloader_load_animation_co (InlineMediaDownloaderLoadAnimationData* _data_);
static void inline_media_downloader_load_animation_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
GdkPixbuf* utils_slice_pixbuf (GdkPixbuf* pic, gint thumb_width, gint thumb_height);
#define MULTI_MEDIA_WIDGET_HEIGHT 60
void utils_write_pixbuf_async (GdkPixbuf* pixbuf, GOutputStream* out_stream, const gchar* type, GAsyncReadyCallback _callback_, gpointer _user_data_);
void utils_write_pixbuf_finish (GAsyncResult* _res_);
static void inline_media_downloader_load_normal_media_data_free (gpointer _data);
static gboolean inline_media_downloader_load_normal_media_co (InlineMediaDownloaderLoadNormalMediaData* _data_);
static void inline_media_downloader_load_normal_media_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
gchar* dirs_cache (const gchar* path);


static void inline_media_downloader_load_media_data_free (gpointer _data) {
	InlineMediaDownloaderLoadMediaData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->t);
	_g_object_unref0 (_data_->media);
	g_slice_free (InlineMediaDownloaderLoadMediaData, _data_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void inline_media_downloader_load_media (Tweet* t, Media* media, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	InlineMediaDownloaderLoadMediaData* _data_;
	Tweet* _tmp0_ = NULL;
	Tweet* _tmp1_ = NULL;
	Media* _tmp2_ = NULL;
	Media* _tmp3_ = NULL;
	_data_ = g_slice_new0 (InlineMediaDownloaderLoadMediaData);
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, inline_media_downloader_load_media);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, inline_media_downloader_load_media_data_free);
	_tmp0_ = t;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data_->t);
	_data_->t = _tmp1_;
	_tmp2_ = media;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (_data_->media);
	_data_->media = _tmp3_;
	inline_media_downloader_load_media_co (_data_);
}


void inline_media_downloader_load_media_finish (GAsyncResult* _res_) {
	InlineMediaDownloaderLoadMediaData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void inline_media_downloader_load_media_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	InlineMediaDownloaderLoadMediaData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	inline_media_downloader_load_media_co (_data_);
}


static gboolean inline_media_downloader_load_media_co (InlineMediaDownloaderLoadMediaData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->t;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = _data_->media;
	_data_->_state_ = 1;
	inline_media_downloader_load_inline_media (_data_->_tmp0_, _data_->_tmp1_, inline_media_downloader_load_media_ready, _data_);
	return FALSE;
	_state_1:
	inline_media_downloader_load_inline_media_finish (_data_->_res_);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


void inline_media_downloader_load_all_media (Tweet* t, Media** medias, int medias_length1) {
	Media** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	g_return_if_fail (IS_TWEET (t));
	_tmp0_ = medias;
	_tmp0__length1 = medias_length1;
	{
		Media** m_collection = NULL;
		gint m_collection_length1 = 0;
		gint _m_collection_size_ = 0;
		gint m_it = 0;
		m_collection = _tmp0_;
		m_collection_length1 = _tmp0__length1;
		for (m_it = 0; m_it < _tmp0__length1; m_it = m_it + 1) {
			Media* _tmp1_ = NULL;
			Media* m = NULL;
			_tmp1_ = _g_object_ref0 (m_collection[m_it]);
			m = _tmp1_;
			{
				Tweet* _tmp2_ = NULL;
				Media* _tmp3_ = NULL;
				_tmp2_ = t;
				_tmp3_ = m;
				inline_media_downloader_load_media (_tmp2_, _tmp3_, NULL, NULL);
				_g_object_unref0 (m);
			}
		}
	}
}


void inline_media_downloader_mark_invalid (Media* m, GInputStream* in_stream, GOutputStream* out_stream, GOutputStream* out_stream2) {
	Media* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	Media* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	Media* _tmp4_ = NULL;
	Media* _tmp5_ = NULL;
	Media* _tmp14_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (IS_MEDIA (m));
	g_return_if_fail ((in_stream == NULL) || G_IS_INPUT_STREAM (in_stream));
	g_return_if_fail ((out_stream == NULL) || G_IS_OUTPUT_STREAM (out_stream));
	g_return_if_fail ((out_stream2 == NULL) || G_IS_OUTPUT_STREAM (out_stream2));
	_tmp0_ = m;
	_tmp1_ = _tmp0_->path;
	g_remove (_tmp1_);
	_tmp2_ = m;
	_tmp3_ = _tmp2_->thumb_path;
	g_remove (_tmp3_);
	_tmp4_ = m;
	_tmp4_->invalid = TRUE;
	_tmp5_ = m;
	_tmp5_->loaded = TRUE;
	{
		GInputStream* _tmp6_ = NULL;
		GOutputStream* _tmp8_ = NULL;
		GOutputStream* _tmp10_ = NULL;
		_tmp6_ = in_stream;
		if (_tmp6_ != NULL) {
			GInputStream* _tmp7_ = NULL;
			_tmp7_ = in_stream;
			g_input_stream_close (_tmp7_, NULL, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch13_g_error;
			}
		}
		_tmp8_ = out_stream;
		if (_tmp8_ != NULL) {
			GOutputStream* _tmp9_ = NULL;
			_tmp9_ = out_stream;
			g_output_stream_close (_tmp9_, NULL, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch13_g_error;
			}
		}
		_tmp10_ = out_stream2;
		if (_tmp10_ != NULL) {
			GOutputStream* _tmp11_ = NULL;
			_tmp11_ = out_stream2;
			g_output_stream_close (_tmp11_, NULL, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch13_g_error;
			}
		}
	}
	goto __finally13;
	__catch13_g_error:
	{
		GError* e = NULL;
		GError* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp12_ = e;
		_tmp13_ = _tmp12_->message;
		g_warning ("InlineMediaDownloader.vala:44: %s", _tmp13_);
		_g_error_free0 (e);
	}
	__finally13:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp14_ = m;
	g_signal_emit_by_name (_tmp14_, "finished-loading");
}


gboolean inline_media_downloader_is_media_candidate (const gchar* url) {
	gboolean result = FALSE;
	gdouble _tmp0_ = 0.0;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp11_ = FALSE;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_ = FALSE;
	const gchar* _tmp14_ = NULL;
	gboolean _tmp15_ = FALSE;
	g_return_val_if_fail (url != NULL, FALSE);
	_tmp0_ = settings_max_media_size ();
	if (_tmp0_ < 0.001) {
		result = FALSE;
		return result;
	}
	_tmp14_ = url;
	_tmp15_ = g_str_has_prefix (_tmp14_, "http://instagra.am");
	if (_tmp15_) {
		_tmp13_ = TRUE;
	} else {
		const gchar* _tmp16_ = NULL;
		gboolean _tmp17_ = FALSE;
		_tmp16_ = url;
		_tmp17_ = g_str_has_prefix (_tmp16_, "http://instagram.com/p/");
		_tmp13_ = _tmp17_;
	}
	if (_tmp13_) {
		_tmp12_ = TRUE;
	} else {
		const gchar* _tmp18_ = NULL;
		gboolean _tmp19_ = FALSE;
		_tmp18_ = url;
		_tmp19_ = g_str_has_prefix (_tmp18_, "https://instagr.am");
		_tmp12_ = _tmp19_;
	}
	if (_tmp12_) {
		_tmp11_ = TRUE;
	} else {
		const gchar* _tmp20_ = NULL;
		gboolean _tmp21_ = FALSE;
		_tmp20_ = url;
		_tmp21_ = g_str_has_prefix (_tmp20_, "https://instagram.com/p/");
		_tmp11_ = _tmp21_;
	}
	if (_tmp11_) {
		_tmp10_ = TRUE;
	} else {
		const gchar* _tmp22_ = NULL;
		gboolean _tmp23_ = FALSE;
		_tmp22_ = url;
		_tmp23_ = g_str_has_prefix (_tmp22_, "http://i.imgur.com");
		_tmp10_ = _tmp23_;
	}
	if (_tmp10_) {
		_tmp9_ = TRUE;
	} else {
		const gchar* _tmp24_ = NULL;
		gboolean _tmp25_ = FALSE;
		_tmp24_ = url;
		_tmp25_ = g_str_has_prefix (_tmp24_, "http://d.pr/i/");
		_tmp9_ = _tmp25_;
	}
	if (_tmp9_) {
		_tmp8_ = TRUE;
	} else {
		const gchar* _tmp26_ = NULL;
		gboolean _tmp27_ = FALSE;
		_tmp26_ = url;
		_tmp27_ = g_str_has_prefix (_tmp26_, "http://ow.ly/i/");
		_tmp8_ = _tmp27_;
	}
	if (_tmp8_) {
		_tmp7_ = TRUE;
	} else {
		const gchar* _tmp28_ = NULL;
		gboolean _tmp29_ = FALSE;
		_tmp28_ = url;
		_tmp29_ = g_str_has_prefix (_tmp28_, "http://www.flickr.com/photos/");
		_tmp7_ = _tmp29_;
	}
	if (_tmp7_) {
		_tmp6_ = TRUE;
	} else {
		const gchar* _tmp30_ = NULL;
		gboolean _tmp31_ = FALSE;
		_tmp30_ = url;
		_tmp31_ = g_str_has_prefix (_tmp30_, "https://www.flickr.com/photos/");
		_tmp6_ = _tmp31_;
	}
	if (_tmp6_) {
		_tmp5_ = TRUE;
	} else {
		const gchar* _tmp32_ = NULL;
		gboolean _tmp33_ = FALSE;
		_tmp32_ = url;
		_tmp33_ = g_str_has_prefix (_tmp32_, "https://vine.co/v/");
		_tmp5_ = _tmp33_;
	}
	if (_tmp5_) {
		_tmp4_ = TRUE;
	} else {
		const gchar* _tmp34_ = NULL;
		gboolean _tmp35_ = FALSE;
		_tmp34_ = url;
		_tmp35_ = g_str_has_suffix (_tmp34_, "/photo/1");
		_tmp4_ = _tmp35_;
	}
	if (_tmp4_) {
		_tmp3_ = TRUE;
	} else {
		const gchar* _tmp36_ = NULL;
		gboolean _tmp37_ = FALSE;
		_tmp36_ = url;
		_tmp37_ = g_str_has_prefix (_tmp36_, "https://video.twimg.com/ext_tw_video/");
		_tmp3_ = _tmp37_;
	}
	if (_tmp3_) {
		_tmp2_ = TRUE;
	} else {
		const gchar* _tmp38_ = NULL;
		gboolean _tmp39_ = FALSE;
		_tmp38_ = url;
		_tmp39_ = g_str_has_prefix (_tmp38_, "http://pbs.twimg.com/media/");
		_tmp2_ = _tmp39_;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		const gchar* _tmp40_ = NULL;
		gboolean _tmp41_ = FALSE;
		_tmp40_ = url;
		_tmp41_ = g_str_has_prefix (_tmp40_, "http://twitpic.com/");
		_tmp1_ = _tmp41_;
	}
	result = _tmp1_;
	return result;
}


static void inline_media_downloader_load_real_url_data_free (gpointer _data) {
	InlineMediaDownloaderLoadRealUrlData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->t);
	g_slice_free (InlineMediaDownloaderLoadRealUrlData, _data_);
}


void inline_media_downloader_load_real_url (Tweet* t, Media* media, const gchar* regex_str1, gint match_index1, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	InlineMediaDownloaderLoadRealUrlData* _data_;
	Tweet* _tmp0_ = NULL;
	Tweet* _tmp1_ = NULL;
	Media* _tmp2_ = NULL;
	Media* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	_data_ = g_slice_new0 (InlineMediaDownloaderLoadRealUrlData);
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, inline_media_downloader_load_real_url);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, inline_media_downloader_load_real_url_data_free);
	_tmp0_ = t;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data_->t);
	_data_->t = _tmp1_;
	_tmp2_ = media;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (_data_->media);
	_data_->media = _tmp3_;
	_tmp4_ = regex_str1;
	_tmp5_ = g_strdup (_tmp4_);
	_g_free0 (_data_->regex_str1);
	_data_->regex_str1 = _tmp5_;
	_tmp6_ = match_index1;
	_data_->match_index1 = _tmp6_;
	inline_media_downloader_load_real_url_co (_data_);
}


void inline_media_downloader_load_real_url_finish (GAsyncResult* _res_) {
	InlineMediaDownloaderLoadRealUrlData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static Block20Data* block20_data_ref (Block20Data* _data20_) {
	g_atomic_int_inc (&_data20_->_ref_count_);
	return _data20_;
}


static void block20_data_unref (void * _userdata_) {
	Block20Data* _data20_;
	_data20_ = (Block20Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data20_->_ref_count_)) {
		_g_object_unref0 (_data20_->msg);
		_g_object_unref0 (_data20_->media);
		_g_free0 (_data20_->regex_str1);
		g_slice_free (Block20Data, _data20_);
	}
}


static void __lambda36_ (Block20Data* _data20_, SoupSession* _s, SoupMessage* _msg) {
	gchar* back = NULL;
	SoupMessage* _tmp0_ = NULL;
	SoupMessageBody* _tmp1_ = NULL;
	guint8* _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	gchar* _tmp3_ = NULL;
	guint _tmp4_ = 0U;
	guint _tmp5_ = 0U;
	const gchar* _tmp11_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (SOUP_IS_SESSION (_s));
	g_return_if_fail (SOUP_IS_MESSAGE (_msg));
	_tmp0_ = _msg;
	_tmp1_ = _tmp0_->response_body;
	_tmp2_ = _tmp1_->data;
	_tmp2__length1 = (gint) _tmp1_->length;
	_tmp3_ = g_strdup ((const gchar*) _tmp2_);
	back = _tmp3_;
	g_object_get (_data20_->msg, "status-code", &_tmp4_, NULL);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != ((guint) SOUP_STATUS_OK)) {
		guint _tmp6_ = 0U;
		guint _tmp7_ = 0U;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		Media* _tmp10_ = NULL;
		g_object_get (_data20_->msg, "status-code", &_tmp6_, NULL);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_strdup_printf ("%u", _tmp7_);
		_tmp9_ = _tmp8_;
		g_warning ("InlineMediaDownloader.vala:81: Message status: %s", _tmp9_);
		_g_free0 (_tmp9_);
		_tmp10_ = _data20_->media;
		inline_media_downloader_mark_invalid (_tmp10_, NULL, NULL, NULL);
		_g_free0 (back);
		return;
	}
	_tmp11_ = back;
	if (_tmp11_ == NULL) {
		Media* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		Media* _tmp14_ = NULL;
		_tmp12_ = _data20_->media;
		_tmp13_ = _tmp12_->url;
		g_warning ("InlineMediaDownloader.vala:87: Url '%s' returned null", _tmp13_);
		_tmp14_ = _data20_->media;
		inline_media_downloader_mark_invalid (_tmp14_, NULL, NULL, NULL);
		_g_free0 (back);
		return;
	}
	{
		GRegex* regex = NULL;
		const gchar* _tmp15_ = NULL;
		GRegex* _tmp16_ = NULL;
		GMatchInfo* info = NULL;
		GRegex* _tmp17_ = NULL;
		const gchar* _tmp18_ = NULL;
		GMatchInfo* _tmp19_ = NULL;
		gchar* real_url = NULL;
		GMatchInfo* _tmp20_ = NULL;
		gint _tmp21_ = 0;
		gchar* _tmp22_ = NULL;
		Media* _tmp23_ = NULL;
		const gchar* _tmp24_ = NULL;
		_tmp15_ = _data20_->regex_str1;
		_tmp16_ = g_regex_new (_tmp15_, 0, 0, &_inner_error_);
		regex = _tmp16_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch14_g_regex_error;
			}
			_g_free0 (back);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp17_ = regex;
		_tmp18_ = back;
		g_regex_match (_tmp17_, _tmp18_, 0, &_tmp19_);
		_g_match_info_unref0 (info);
		info = _tmp19_;
		_tmp20_ = info;
		_tmp21_ = _data20_->match_index1;
		_tmp22_ = g_match_info_fetch (_tmp20_, _tmp21_);
		real_url = _tmp22_;
		_tmp23_ = _data20_->media;
		_tmp24_ = real_url;
		media_set_thumb_url (_tmp23_, _tmp24_);
		inline_media_downloader_load_real_url_co (_data20_->_async_data_);
		_g_free0 (real_url);
		_g_match_info_unref0 (info);
		_g_regex_unref0 (regex);
	}
	goto __finally14;
	__catch14_g_regex_error:
	{
		GError* e = NULL;
		const gchar* _tmp25_ = NULL;
		GError* _tmp26_ = NULL;
		const gchar* _tmp27_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp25_ = _data20_->regex_str1;
		_tmp26_ = e;
		_tmp27_ = _tmp26_->message;
		g_critical ("InlineMediaDownloader.vala:100: Regex Error(%s): %s", _tmp25_, _tmp27_);
		_g_error_free0 (e);
	}
	__finally14:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (back);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (back);
}


static void ___lambda36__soup_session_callback (SoupSession* session, SoupMessage* msg, gpointer self) {
	__lambda36_ (self, session, msg);
	block20_data_unref (self);
}


static gboolean inline_media_downloader_load_real_url_co (InlineMediaDownloaderLoadRealUrlData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data20_ = g_slice_new0 (Block20Data);
	_data_->_data20_->_ref_count_ = 1;
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->media;
	_g_object_unref0 (_data_->_data20_->media);
	_data_->_data20_->media = _data_->_tmp0_;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = _data_->regex_str1;
	_g_free0 (_data_->_data20_->regex_str1);
	_data_->_data20_->regex_str1 = _data_->_tmp1_;
	_data_->_tmp2_ = 0;
	_data_->_tmp2_ = _data_->match_index1;
	_data_->_data20_->match_index1 = _data_->_tmp2_;
	_data_->_data20_->_async_data_ = _data_;
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = _data_->_data20_->media;
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = _data_->_tmp3_->url;
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = soup_message_new ("GET", _data_->_tmp4_);
	_data_->_data20_->msg = _data_->_tmp5_;
	_data_->_tmp6_ = NULL;
	_data_->_tmp6_ = SOUP_SESSION;
	_data_->_tmp7_ = NULL;
	_data_->_tmp7_ = _g_object_ref0 (_data_->_data20_->msg);
	soup_session_queue_message (_data_->_tmp6_, _data_->_tmp7_, ___lambda36__soup_session_callback, block20_data_ref (_data_->_data20_));
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	block20_data_unref (_data_->_data20_);
	_data_->_data20_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void inline_media_downloader_load_inline_media_data_free (gpointer _data) {
	InlineMediaDownloaderLoadInlineMediaData* _data_;
	_data_ = _data;
	g_slice_free (InlineMediaDownloaderLoadInlineMediaData, _data_);
}


void inline_media_downloader_load_inline_media (Tweet* t, Media* media, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	InlineMediaDownloaderLoadInlineMediaData* _data_;
	Tweet* _tmp0_ = NULL;
	Tweet* _tmp1_ = NULL;
	Media* _tmp2_ = NULL;
	Media* _tmp3_ = NULL;
	_data_ = g_slice_new0 (InlineMediaDownloaderLoadInlineMediaData);
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, inline_media_downloader_load_inline_media);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, inline_media_downloader_load_inline_media_data_free);
	_tmp0_ = t;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data_->t);
	_data_->t = _tmp1_;
	_tmp2_ = media;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (_data_->media);
	_data_->media = _tmp3_;
	inline_media_downloader_load_inline_media_co (_data_);
}


void inline_media_downloader_load_inline_media_finish (GAsyncResult* _res_) {
	InlineMediaDownloaderLoadInlineMediaData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static Block21Data* block21_data_ref (Block21Data* _data21_) {
	g_atomic_int_inc (&_data21_->_ref_count_);
	return _data21_;
}


static void block21_data_unref (void * _userdata_) {
	Block21Data* _data21_;
	_data21_ = (Block21Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data21_->_ref_count_)) {
		_g_object_unref0 (_data21_->msg);
		_g_object_unref0 (_data21_->media_out_stream);
		_g_object_unref0 (_data21_->thumb_out_stream);
		_g_free0 (_data21_->ext);
		(_data21_->callback_target_destroy_notify == NULL) ? NULL : (_data21_->callback_target_destroy_notify (_data21_->callback_target), NULL);
		_data21_->callback = NULL;
		_data21_->callback_target = NULL;
		_data21_->callback_target_destroy_notify = NULL;
		_g_object_unref0 (_data21_->t);
		_g_object_unref0 (_data21_->media);
		g_slice_free (Block21Data, _data21_);
	}
}


static gboolean _inline_media_downloader_load_inline_media_co_gsource_func (gpointer self) {
	gboolean result;
	result = inline_media_downloader_load_inline_media_co (self);
	return result;
}


static gint string_index_of_char (const gchar* self, gunichar c, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_ = 0;
	gunichar _tmp1_ = 0U;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = c;
	_tmp2_ = g_utf8_strchr (((gchar*) self) + _tmp0_, (gssize) (-1), _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_ = NULL;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_ = NULL;
	glong _tmp1_ = 0L;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_ = 0L;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_ = 0L;
	glong _tmp8_ = 0L;
	glong _tmp14_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	gchar* _tmp22_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_ = 0L;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		glong _tmp5_ = 0L;
		_tmp3_ = offset;
		_tmp4_ = len;
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
		string_length = _tmp5_;
	} else {
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		_tmp6_ = strlen (self);
		_tmp7_ = _tmp6_;
		string_length = (glong) _tmp7_;
	}
	_tmp8_ = offset;
	if (_tmp8_ < ((glong) 0)) {
		glong _tmp9_ = 0L;
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		_tmp9_ = string_length;
		_tmp10_ = offset;
		offset = _tmp9_ + _tmp10_;
		_tmp11_ = offset;
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
	} else {
		glong _tmp12_ = 0L;
		glong _tmp13_ = 0L;
		_tmp12_ = offset;
		_tmp13_ = string_length;
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
	}
	_tmp14_ = len;
	if (_tmp14_ < ((glong) 0)) {
		glong _tmp15_ = 0L;
		glong _tmp16_ = 0L;
		_tmp15_ = string_length;
		_tmp16_ = offset;
		len = _tmp15_ - _tmp16_;
	}
	_tmp17_ = offset;
	_tmp18_ = len;
	_tmp19_ = string_length;
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
	_tmp20_ = offset;
	_tmp21_ = len;
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
	result = _tmp22_;
	return result;
}


static void inline_media_downloader_load_inline_media_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	InlineMediaDownloaderLoadInlineMediaData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	inline_media_downloader_load_inline_media_co (_data_);
}


static void __lambda37_ (Block21Data* _data21_) {
	gint64 content_length = 0LL;
	SoupMessage* _tmp0_ = NULL;
	SoupMessageHeaders* _tmp1_ = NULL;
	gint64 _tmp2_ = 0LL;
	gdouble mb = 0.0;
	gint64 _tmp3_ = 0LL;
	gdouble max = 0.0;
	gdouble _tmp4_ = 0.0;
	gdouble _tmp5_ = 0.0;
	gdouble _tmp6_ = 0.0;
	_tmp0_ = _data21_->msg;
	_tmp1_ = _tmp0_->response_headers;
	_tmp2_ = soup_message_headers_get_content_length (_tmp1_);
	content_length = _tmp2_;
	_tmp3_ = content_length;
	mb = (_tmp3_ / 1024.0) / 1024.0;
	_tmp4_ = settings_max_media_size ();
	max = _tmp4_;
	_tmp5_ = mb;
	_tmp6_ = max;
	if (_tmp5_ > _tmp6_) {
		Media* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		gdouble _tmp10_ = 0.0;
		gdouble _tmp11_ = 0.0;
		Media* _tmp12_ = NULL;
		GOutputStream* _tmp13_ = NULL;
		GOutputStream* _tmp14_ = NULL;
		SoupSession* _tmp15_ = NULL;
		SoupMessage* _tmp16_ = NULL;
		_tmp7_ = _data21_->media;
		_tmp8_ = media_get_thumb_url (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = mb;
		_tmp11_ = max;
		g_debug ("InlineMediaDownloader.vala:210: Image %s won't be downloaded,  %fMB > " \
"%fMB", _tmp9_, _tmp10_, _tmp11_);
		_tmp12_ = _data21_->media;
		_tmp13_ = _data21_->thumb_out_stream;
		_tmp14_ = _data21_->media_out_stream;
		inline_media_downloader_mark_invalid (_tmp12_, NULL, _tmp13_, _tmp14_);
		_tmp15_ = SOUP_SESSION;
		_tmp16_ = _data21_->msg;
		soup_session_cancel_message (_tmp15_, _tmp16_, (guint) SOUP_STATUS_CANCELLED);
	} else {
		Media* _tmp17_ = NULL;
		gint64 _tmp18_ = 0LL;
		_tmp17_ = _data21_->media;
		_tmp18_ = content_length;
		media_set_length (_tmp17_, _tmp18_);
	}
}


static void ___lambda37__soup_message_got_headers (SoupMessage* _sender, gpointer self) {
	__lambda37_ (self);
}


static void __lambda38_ (Block21Data* _data21_, SoupBuffer* buf) {
	gdouble percent = 0.0;
	SoupBuffer* _tmp0_ = NULL;
	gsize _tmp1_ = 0UL;
	Media* _tmp2_ = NULL;
	gint64 _tmp3_ = 0LL;
	gint64 _tmp4_ = 0LL;
	Media* _tmp5_ = NULL;
	Media* _tmp6_ = NULL;
	gdouble _tmp7_ = 0.0;
	gdouble _tmp8_ = 0.0;
	g_return_if_fail (buf != NULL);
	_tmp0_ = buf;
	_tmp1_ = _tmp0_->length;
	_tmp2_ = _data21_->media;
	_tmp3_ = media_get_length (_tmp2_);
	_tmp4_ = _tmp3_;
	percent = ((gdouble) _tmp1_) / ((gdouble) _tmp4_);
	_tmp5_ = _data21_->media;
	_tmp6_ = _data21_->media;
	_tmp7_ = media_get_percent_loaded (_tmp6_);
	_tmp8_ = _tmp7_;
	media_set_percent_loaded (_tmp6_, _tmp8_ + percent);
}


static void ___lambda38__soup_message_got_chunk (SoupMessage* _sender, SoupBuffer* chunk, gpointer self) {
	__lambda38_ (self, chunk);
}


static guint8* _vala_array_dup5 (guint8* self, int length) {
	return g_memdup (self, length * sizeof (guint8));
}


static void ____lambda40_ (Block21Data* _data21_) {
	GSourceFunc _tmp0_ = NULL;
	void* _tmp0__target = NULL;
	_tmp0_ = _data21_->callback;
	_tmp0__target = _data21_->callback_target;
	_tmp0_ (_tmp0__target);
}


static void _____lambda40__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	____lambda40_ (self);
	block21_data_unref (self);
}


static void ____lambda41_ (Block21Data* _data21_) {
	GSourceFunc _tmp0_ = NULL;
	void* _tmp0__target = NULL;
	_tmp0_ = _data21_->callback;
	_tmp0__target = _data21_->callback_target;
	_tmp0_ (_tmp0__target);
}


static void _____lambda41__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	____lambda41_ (self);
	block21_data_unref (self);
}


static void __lambda39_ (Block21Data* _data21_, SoupSession* s, SoupMessage* _msg) {
	SoupMessage* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	guint _tmp2_ = 0U;
	GError * _inner_error_ = NULL;
	g_return_if_fail (SOUP_IS_SESSION (s));
	g_return_if_fail (SOUP_IS_MESSAGE (_msg));
	_tmp0_ = _msg;
	g_object_get (_tmp0_, "status-code", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != ((guint) SOUP_STATUS_OK)) {
		Media* _tmp3_ = NULL;
		GOutputStream* _tmp4_ = NULL;
		GOutputStream* _tmp5_ = NULL;
		GSourceFunc _tmp6_ = NULL;
		void* _tmp6__target = NULL;
		_tmp3_ = _data21_->media;
		_tmp4_ = _data21_->thumb_out_stream;
		_tmp5_ = _data21_->media_out_stream;
		inline_media_downloader_mark_invalid (_tmp3_, NULL, _tmp4_, _tmp5_);
		_tmp6_ = _data21_->callback;
		_tmp6__target = _data21_->callback_target;
		_tmp6_ (_tmp6__target);
		return;
	}
	{
		GMemoryInputStream* ms = NULL;
		SoupMessage* _tmp7_ = NULL;
		SoupMessageBody* _tmp8_ = NULL;
		guint8* _tmp9_ = NULL;
		gint _tmp9__length1 = 0;
		guint8* _tmp10_ = NULL;
		gint _tmp10__length1 = 0;
		GMemoryInputStream* _tmp11_ = NULL;
		GOutputStream* _tmp12_ = NULL;
		SoupMessage* _tmp13_ = NULL;
		SoupMessageBody* _tmp14_ = NULL;
		guint8* _tmp15_ = NULL;
		gint _tmp15__length1 = 0;
		GOutputStream* _tmp16_ = NULL;
		const gchar* _tmp17_ = NULL;
		_tmp7_ = _msg;
		_tmp8_ = _tmp7_->response_body;
		_tmp9_ = _tmp8_->data;
		_tmp9__length1 = (gint) _tmp8_->length;
		_tmp10_ = (_tmp9_ != NULL) ? _vala_array_dup5 (_tmp9_, _tmp9__length1) : ((gpointer) _tmp9_);
		_tmp10__length1 = _tmp9__length1;
		_tmp11_ = (GMemoryInputStream*) g_memory_input_stream_new_from_data (_tmp10_, _tmp10__length1, NULL);
		ms = _tmp11_;
		_tmp12_ = _data21_->media_out_stream;
		_tmp13_ = _msg;
		_tmp14_ = _tmp13_->response_body;
		_tmp15_ = _tmp14_->data;
		_tmp15__length1 = (gint) _tmp14_->length;
		g_output_stream_write_all (_tmp12_, _tmp15_, (gsize) _tmp15__length1, NULL, NULL, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (ms);
			goto __catch19_g_error;
		}
		_tmp16_ = _data21_->media_out_stream;
		g_output_stream_close (_tmp16_, NULL, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (ms);
			goto __catch19_g_error;
		}
		_tmp17_ = _data21_->ext;
		if (g_strcmp0 (_tmp17_, "gif") == 0) {
			Tweet* _tmp18_ = NULL;
			GMemoryInputStream* _tmp19_ = NULL;
			GOutputStream* _tmp20_ = NULL;
			Media* _tmp21_ = NULL;
			_tmp18_ = _data21_->t;
			_tmp19_ = ms;
			_tmp20_ = _data21_->thumb_out_stream;
			_tmp21_ = _data21_->media;
			inline_media_downloader_load_animation (_tmp18_, _tmp19_, _tmp20_, _tmp21_, _____lambda40__gasync_ready_callback, block21_data_ref (_data21_));
		} else {
			Tweet* _tmp22_ = NULL;
			GMemoryInputStream* _tmp23_ = NULL;
			GOutputStream* _tmp24_ = NULL;
			Media* _tmp25_ = NULL;
			_tmp22_ = _data21_->t;
			_tmp23_ = ms;
			_tmp24_ = _data21_->thumb_out_stream;
			_tmp25_ = _data21_->media;
			inline_media_downloader_load_normal_media (_tmp22_, G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, G_TYPE_INPUT_STREAM, GInputStream), _tmp24_, _tmp25_, _____lambda41__gasync_ready_callback, block21_data_ref (_data21_));
		}
		_g_object_unref0 (ms);
	}
	goto __finally19;
	__catch19_g_error:
	{
		GError* e = NULL;
		GError* _tmp26_ = NULL;
		const gchar* _tmp27_ = NULL;
		gchar* _tmp28_ = NULL;
		gchar* _tmp29_ = NULL;
		Media* _tmp30_ = NULL;
		const gchar* _tmp31_ = NULL;
		const gchar* _tmp32_ = NULL;
		gchar* _tmp33_ = NULL;
		gchar* _tmp34_ = NULL;
		GSourceFunc _tmp35_ = NULL;
		void* _tmp35__target = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp26_ = e;
		_tmp27_ = _tmp26_->message;
		_tmp28_ = g_strconcat (_tmp27_, " for MEDIA ", NULL);
		_tmp29_ = _tmp28_;
		_tmp30_ = _data21_->media;
		_tmp31_ = media_get_thumb_url (_tmp30_);
		_tmp32_ = _tmp31_;
		_tmp33_ = g_strconcat (_tmp29_, _tmp32_, NULL);
		_tmp34_ = _tmp33_;
		g_critical ("InlineMediaDownloader.vala:246: %s", _tmp34_);
		_g_free0 (_tmp34_);
		_g_free0 (_tmp29_);
		_tmp35_ = _data21_->callback;
		_tmp35__target = _data21_->callback_target;
		_tmp35_ (_tmp35__target);
		_g_error_free0 (e);
	}
	__finally19:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void ___lambda39__soup_session_callback (SoupSession* session, SoupMessage* msg, gpointer self) {
	__lambda39_ (self, session, msg);
	block21_data_unref (self);
}


static gboolean inline_media_downloader_load_inline_media_co (InlineMediaDownloaderLoadInlineMediaData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		case 4:
		goto _state_4;
		case 5:
		goto _state_5;
		case 6:
		goto _state_6;
		case 7:
		goto _state_7;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data21_ = g_slice_new0 (Block21Data);
	_data_->_data21_->_ref_count_ = 1;
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->t;
	_g_object_unref0 (_data_->_data21_->t);
	_data_->_data21_->t = _data_->_tmp0_;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = _data_->media;
	_g_object_unref0 (_data_->_data21_->media);
	_data_->_data21_->media = _data_->_tmp1_;
	_data_->_data21_->_async_data_ = _data_;
	_data_->_data21_->callback = _inline_media_downloader_load_inline_media_co_gsource_func;
	_data_->_data21_->callback_target = _data_;
	_data_->_data21_->callback_target_destroy_notify = NULL;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = _data_->_data21_->media;
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = _data_->_data21_->t;
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = _data_->_data21_->media;
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = inline_media_downloader_get_media_path (_data_->_tmp3_, _data_->_tmp4_);
	_g_free0 (_data_->_tmp2_->path);
	_data_->_tmp2_->path = _data_->_tmp5_;
	_data_->_tmp6_ = NULL;
	_data_->_tmp6_ = _data_->_data21_->media;
	_data_->_tmp7_ = NULL;
	_data_->_tmp7_ = _data_->_data21_->t;
	_data_->_tmp8_ = NULL;
	_data_->_tmp8_ = _data_->_data21_->media;
	_data_->_tmp9_ = NULL;
	_data_->_tmp9_ = inline_media_downloader_get_thumb_path (_data_->_tmp7_, _data_->_tmp8_);
	_g_free0 (_data_->_tmp6_->thumb_path);
	_data_->_tmp6_->thumb_path = _data_->_tmp9_;
	_data_->_tmp10_ = NULL;
	_data_->_tmp10_ = _data_->_data21_->media;
	_data_->_tmp11_ = NULL;
	_data_->_tmp11_ = _data_->_tmp10_->url;
	_data_->_tmp12_ = NULL;
	_data_->_tmp12_ = utils_get_file_type (_data_->_tmp11_);
	_data_->_data21_->ext = _data_->_tmp12_;
	{
		_data_->_tmp13_ = NULL;
		_data_->_tmp13_ = _data_->_data21_->ext;
		_data_->_tmp14_ = 0;
		_data_->_tmp14_ = strlen (_data_->_tmp13_);
		_data_->_tmp15_ = 0;
		_data_->_tmp15_ = _data_->_tmp14_;
		if (_data_->_tmp15_ == 0) {
			_data_->_tmp16_ = NULL;
			_data_->_tmp16_ = g_strdup ("png");
			_g_free0 (_data_->_data21_->ext);
			_data_->_data21_->ext = _data_->_tmp16_;
		}
		_data_->_tmp17_ = NULL;
		_data_->_tmp17_ = _data_->_data21_->ext;
		_data_->_tmp18_ = NULL;
		_data_->_tmp18_ = g_utf8_strdown (_data_->_tmp17_, (gssize) (-1));
		_g_free0 (_data_->_data21_->ext);
		_data_->_data21_->ext = _data_->_tmp18_;
		_data_->_tmp19_ = NULL;
		_data_->_tmp19_ = _data_->_data21_->ext;
		_data_->_tmp20_ = 0;
		_data_->_tmp20_ = string_index_of_char (_data_->_tmp19_, (gunichar) '?', 0);
		_data_->qm_index = _data_->_tmp20_;
		_data_->_tmp21_ = 0;
		_data_->_tmp21_ = _data_->qm_index;
		if (_data_->_tmp21_ != (-1)) {
			_data_->_tmp22_ = NULL;
			_data_->_tmp22_ = _data_->_data21_->ext;
			_data_->_tmp23_ = 0;
			_data_->_tmp23_ = _data_->qm_index;
			_data_->_tmp24_ = NULL;
			_data_->_tmp24_ = string_substring (_data_->_tmp22_, (glong) 0, (glong) _data_->_tmp23_);
			_g_free0 (_data_->_data21_->ext);
			_data_->_data21_->ext = _data_->_tmp24_;
		}
		_data_->_tmp25_ = NULL;
		_data_->_tmp25_ = _data_->_data21_->ext;
		if (g_strcmp0 (_data_->_tmp25_, "jpg") == 0) {
			_data_->_tmp26_ = NULL;
			_data_->_tmp26_ = g_strdup ("jpeg");
			_g_free0 (_data_->_data21_->ext);
			_data_->_data21_->ext = _data_->_tmp26_;
		}
	}
	_data_->_data21_->thumb_out_stream = NULL;
	_data_->_data21_->media_out_stream = NULL;
	_data_->main_file_exists = FALSE;
	{
		_data_->_tmp28_ = NULL;
		_data_->_tmp28_ = _data_->_data21_->media;
		_data_->_tmp29_ = NULL;
		_data_->_tmp29_ = _data_->_tmp28_->path;
		_data_->_tmp30_ = NULL;
		_data_->_tmp30_ = g_file_new_for_path (_data_->_tmp29_);
		_data_->_tmp31_ = NULL;
		_data_->_tmp31_ = _data_->_tmp30_;
		_data_->_tmp32_ = NULL;
		_data_->_tmp32_ = g_file_create (_data_->_tmp31_, G_FILE_CREATE_NONE, NULL, &_data_->_inner_error_);
		_data_->_tmp33_ = NULL;
		_data_->_tmp33_ = _data_->_tmp32_;
		_g_object_unref0 (_data_->_tmp31_);
		_data_->_tmp27_ = _data_->_tmp33_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			goto __catch15_g_error;
		}
		_data_->_tmp34_ = NULL;
		_data_->_tmp34_ = _data_->_tmp27_;
		_data_->_tmp27_ = NULL;
		_g_object_unref0 (_data_->_data21_->media_out_stream);
		_data_->_data21_->media_out_stream = G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp34_, G_TYPE_OUTPUT_STREAM, GOutputStream);
		_g_object_unref0 (_data_->_tmp27_);
	}
	goto __finally15;
	__catch15_g_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp35_ = NULL;
		_data_->_tmp35_ = _data_->e;
		if (g_error_matches (_data_->_tmp35_, G_IO_ERROR, G_IO_ERROR_EXISTS)) {
			_data_->main_file_exists = TRUE;
		} else {
			_data_->_tmp36_ = NULL;
			_data_->_tmp36_ = _data_->e;
			_data_->_tmp37_ = NULL;
			_data_->_tmp37_ = _data_->_tmp36_->message;
			g_warning ("InlineMediaDownloader.vala:137: %s", _data_->_tmp37_);
			_g_error_free0 (_data_->e);
			block21_data_unref (_data_->_data21_);
			_data_->_data21_ = NULL;
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_g_error_free0 (_data_->e);
	}
	__finally15:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		block21_data_unref (_data_->_data21_);
		_data_->_data21_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	{
		_data_->_tmp39_ = NULL;
		_data_->_tmp39_ = _data_->_data21_->media;
		_data_->_tmp40_ = NULL;
		_data_->_tmp40_ = _data_->_tmp39_->thumb_path;
		_data_->_tmp41_ = NULL;
		_data_->_tmp41_ = g_file_new_for_path (_data_->_tmp40_);
		_data_->_tmp42_ = NULL;
		_data_->_tmp42_ = _data_->_tmp41_;
		_data_->_tmp43_ = NULL;
		_data_->_tmp43_ = g_file_create (_data_->_tmp42_, G_FILE_CREATE_NONE, NULL, &_data_->_inner_error_);
		_data_->_tmp44_ = NULL;
		_data_->_tmp44_ = _data_->_tmp43_;
		_g_object_unref0 (_data_->_tmp42_);
		_data_->_tmp38_ = _data_->_tmp44_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			goto __catch16_g_error;
		}
		_data_->_tmp45_ = NULL;
		_data_->_tmp45_ = _data_->_tmp38_;
		_data_->_tmp38_ = NULL;
		_g_object_unref0 (_data_->_data21_->thumb_out_stream);
		_data_->_data21_->thumb_out_stream = G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp45_, G_TYPE_OUTPUT_STREAM, GOutputStream);
		_data_->_tmp46_ = FALSE;
		_data_->_tmp46_ = _data_->main_file_exists;
		if (_data_->_tmp46_) {
			_data_->_tmp47_ = NULL;
			_data_->_tmp47_ = _data_->_data21_->media;
			_data_->_tmp48_ = NULL;
			_data_->_tmp48_ = _data_->_tmp47_->path;
			_data_->_tmp49_ = NULL;
			_data_->_tmp49_ = g_file_new_for_path (_data_->_tmp48_);
			_data_->_tmp50_ = NULL;
			_data_->_tmp50_ = _data_->_tmp49_;
			_data_->_tmp51_ = NULL;
			_data_->_tmp51_ = g_file_read (_data_->_tmp50_, NULL, &_data_->_inner_error_);
			_data_->_tmp52_ = NULL;
			_data_->_tmp52_ = _data_->_tmp51_;
			_g_object_unref0 (_data_->_tmp50_);
			_data_->in_stream = _data_->_tmp52_;
			if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
				_g_object_unref0 (_data_->_tmp38_);
				goto __catch16_g_error;
			}
			_data_->_tmp53_ = NULL;
			_data_->_tmp53_ = _data_->_data21_->t;
			_data_->_tmp54_ = NULL;
			_data_->_tmp54_ = _data_->in_stream;
			_data_->_tmp55_ = NULL;
			_data_->_tmp55_ = _data_->_data21_->thumb_out_stream;
			_data_->_tmp56_ = NULL;
			_data_->_tmp56_ = _data_->_data21_->media;
			_data_->_state_ = 1;
			inline_media_downloader_load_normal_media (_data_->_tmp53_, G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp54_, G_TYPE_INPUT_STREAM, GInputStream), _data_->_tmp55_, _data_->_tmp56_, inline_media_downloader_load_inline_media_ready, _data_);
			return FALSE;
			_state_1:
			inline_media_downloader_load_normal_media_finish (_data_->_res_);
			_g_object_unref0 (_data_->in_stream);
			_g_object_unref0 (_data_->_tmp38_);
			block21_data_unref (_data_->_data21_);
			_data_->_data21_ = NULL;
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_g_object_unref0 (_data_->_tmp38_);
	}
	goto __finally16;
	__catch16_g_error:
	{
		_data_->_vala1_e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp57_ = NULL;
		_data_->_tmp57_ = _data_->_vala1_e;
		if (g_error_matches (_data_->_tmp57_, G_IO_ERROR, G_IO_ERROR_EXISTS)) {
			_data_->_tmp58_ = FALSE;
			_data_->_tmp58_ = _data_->main_file_exists;
			if (_data_->_tmp58_) {
				{
					_data_->_tmp59_ = NULL;
					_data_->_tmp59_ = _data_->_data21_->media;
					_data_->_tmp60_ = NULL;
					_data_->_tmp60_ = _data_->_tmp59_->thumb_path;
					_data_->_tmp61_ = NULL;
					_data_->_tmp61_ = gdk_pixbuf_new_from_file (_data_->_tmp60_, &_data_->_inner_error_);
					_data_->thumb = _data_->_tmp61_;
					if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
						goto __catch17_g_error;
					}
					_data_->_tmp62_ = NULL;
					_data_->_tmp62_ = _data_->_data21_->media;
					_data_->_tmp63_ = NULL;
					_data_->_tmp63_ = _data_->thumb;
					_data_->_tmp64_ = NULL;
					_data_->_tmp64_ = _g_object_ref0 (_data_->_tmp63_);
					_g_object_unref0 (_data_->_tmp62_->thumbnail);
					_data_->_tmp62_->thumbnail = _data_->_tmp64_;
					_data_->_tmp65_ = NULL;
					_data_->_tmp65_ = _data_->_data21_->media;
					_data_->_tmp65_->loaded = TRUE;
					_data_->_tmp66_ = NULL;
					_data_->_tmp66_ = _data_->_data21_->media;
					g_signal_emit_by_name (_data_->_tmp66_, "finished-loading");
					_g_object_unref0 (_data_->thumb);
				}
				goto __finally17;
				__catch17_g_error:
				{
					_data_->_vala2_e = _data_->_inner_error_;
					_data_->_inner_error_ = NULL;
					_data_->_tmp67_ = NULL;
					_data_->_tmp67_ = _data_->_vala2_e;
					_data_->_tmp68_ = NULL;
					_data_->_tmp68_ = _data_->_tmp67_->message;
					_data_->_tmp69_ = NULL;
					_data_->_tmp69_ = _data_->_vala2_e;
					_data_->_tmp70_ = 0;
					_data_->_tmp70_ = _data_->_tmp69_->code;
					g_critical ("InlineMediaDownloader.vala:160: %s (error code %d)", _data_->_tmp68_, _data_->_tmp70_);
					_g_error_free0 (_data_->_vala2_e);
				}
				__finally17:
				if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
					_g_error_free0 (_data_->_vala1_e);
					_g_error_free0 (_data_->_vala1_e);
					block21_data_unref (_data_->_data21_);
					_data_->_data21_ = NULL;
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
					g_clear_error (&_data_->_inner_error_);
					return FALSE;
				}
				_g_error_free0 (_data_->_vala1_e);
				block21_data_unref (_data_->_data21_);
				_data_->_data21_ = NULL;
				if (_data_->_state_ == 0) {
					g_simple_async_result_complete_in_idle (_data_->_async_result);
				} else {
					g_simple_async_result_complete (_data_->_async_result);
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			} else {
				_data_->_tmp71_ = NULL;
				_data_->_tmp71_ = _data_->_data21_->media;
				_data_->_tmp72_ = NULL;
				_data_->_tmp72_ = _data_->_tmp71_->thumb_path;
				g_remove (_data_->_tmp72_);
				{
					_data_->_tmp74_ = NULL;
					_data_->_tmp74_ = _data_->_data21_->media;
					_data_->_tmp75_ = NULL;
					_data_->_tmp75_ = _data_->_tmp74_->thumb_path;
					_data_->_tmp76_ = NULL;
					_data_->_tmp76_ = g_file_new_for_path (_data_->_tmp75_);
					_data_->_tmp77_ = NULL;
					_data_->_tmp77_ = _data_->_tmp76_;
					_data_->_tmp78_ = NULL;
					_data_->_tmp78_ = g_file_create (_data_->_tmp77_, G_FILE_CREATE_NONE, NULL, &_data_->_inner_error_);
					_data_->_tmp79_ = NULL;
					_data_->_tmp79_ = _data_->_tmp78_;
					_g_object_unref0 (_data_->_tmp77_);
					_data_->_tmp73_ = _data_->_tmp79_;
					if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
						goto __catch18_g_error;
					}
					_data_->_tmp80_ = NULL;
					_data_->_tmp80_ = _data_->_tmp73_;
					_data_->_tmp73_ = NULL;
					_g_object_unref0 (_data_->_data21_->thumb_out_stream);
					_data_->_data21_->thumb_out_stream = G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp80_, G_TYPE_OUTPUT_STREAM, GOutputStream);
					_g_object_unref0 (_data_->_tmp73_);
				}
				goto __finally18;
				__catch18_g_error:
				{
					_data_->_vala3_e = _data_->_inner_error_;
					_data_->_inner_error_ = NULL;
					_data_->_tmp81_ = NULL;
					_data_->_tmp81_ = _data_->_vala3_e;
					_data_->_tmp82_ = NULL;
					_data_->_tmp82_ = _data_->_tmp81_->message;
					g_critical ("InlineMediaDownloader.vala:169: %s", _data_->_tmp82_);
					_g_error_free0 (_data_->_vala3_e);
					_g_error_free0 (_data_->_vala1_e);
					block21_data_unref (_data_->_data21_);
					_data_->_data21_ = NULL;
					if (_data_->_state_ == 0) {
						g_simple_async_result_complete_in_idle (_data_->_async_result);
					} else {
						g_simple_async_result_complete (_data_->_async_result);
					}
					g_object_unref (_data_->_async_result);
					return FALSE;
				}
				__finally18:
				if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
					_g_error_free0 (_data_->_vala1_e);
					_g_error_free0 (_data_->_vala1_e);
					block21_data_unref (_data_->_data21_);
					_data_->_data21_ = NULL;
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
					g_clear_error (&_data_->_inner_error_);
					return FALSE;
				}
			}
		} else {
			_data_->_tmp83_ = NULL;
			_data_->_tmp83_ = _data_->_vala1_e;
			_data_->_tmp84_ = NULL;
			_data_->_tmp84_ = _data_->_tmp83_->message;
			g_warning ("InlineMediaDownloader.vala:174: %s", _data_->_tmp84_);
			_g_error_free0 (_data_->_vala1_e);
			block21_data_unref (_data_->_data21_);
			_data_->_data21_ = NULL;
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_g_error_free0 (_data_->_vala1_e);
	}
	__finally16:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		block21_data_unref (_data_->_data21_);
		_data_->_data21_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	_data_->_tmp85_ = NULL;
	_data_->_tmp85_ = _data_->_data21_->media;
	_data_->_tmp86_ = NULL;
	_data_->_tmp86_ = _data_->_tmp85_->url;
	_data_->_tmp87_ = NULL;
	_data_->_tmp87_ = g_strdup (_data_->_tmp86_);
	_data_->url = _data_->_tmp87_;
	_data_->_tmp95_ = NULL;
	_data_->_tmp95_ = _data_->url;
	_data_->_tmp96_ = FALSE;
	_data_->_tmp96_ = g_str_has_prefix (_data_->_tmp95_, "http://instagr.am");
	if (_data_->_tmp96_) {
		_data_->_tmp94_ = TRUE;
	} else {
		_data_->_tmp97_ = NULL;
		_data_->_tmp97_ = _data_->url;
		_data_->_tmp98_ = FALSE;
		_data_->_tmp98_ = g_str_has_prefix (_data_->_tmp97_, "http://instagram.com/p/");
		_data_->_tmp94_ = _data_->_tmp98_;
	}
	if (_data_->_tmp94_) {
		_data_->_tmp93_ = TRUE;
	} else {
		_data_->_tmp99_ = NULL;
		_data_->_tmp99_ = _data_->url;
		_data_->_tmp100_ = FALSE;
		_data_->_tmp100_ = g_str_has_prefix (_data_->_tmp99_, "https://instagr.am");
		_data_->_tmp93_ = _data_->_tmp100_;
	}
	if (_data_->_tmp93_) {
		_data_->_tmp92_ = TRUE;
	} else {
		_data_->_tmp101_ = NULL;
		_data_->_tmp101_ = _data_->url;
		_data_->_tmp102_ = FALSE;
		_data_->_tmp102_ = g_str_has_prefix (_data_->_tmp101_, "https://instagram.com/p/");
		_data_->_tmp92_ = _data_->_tmp102_;
	}
	if (_data_->_tmp92_) {
		_data_->_tmp91_ = TRUE;
	} else {
		_data_->_tmp103_ = NULL;
		_data_->_tmp103_ = _data_->url;
		_data_->_tmp104_ = FALSE;
		_data_->_tmp104_ = g_str_has_prefix (_data_->_tmp103_, "http://ow.ly/i/");
		_data_->_tmp91_ = _data_->_tmp104_;
	}
	if (_data_->_tmp91_) {
		_data_->_tmp90_ = TRUE;
	} else {
		_data_->_tmp105_ = NULL;
		_data_->_tmp105_ = _data_->url;
		_data_->_tmp106_ = FALSE;
		_data_->_tmp106_ = g_str_has_prefix (_data_->_tmp105_, "https://ow.ly/i/");
		_data_->_tmp90_ = _data_->_tmp106_;
	}
	if (_data_->_tmp90_) {
		_data_->_tmp89_ = TRUE;
	} else {
		_data_->_tmp107_ = NULL;
		_data_->_tmp107_ = _data_->url;
		_data_->_tmp108_ = FALSE;
		_data_->_tmp108_ = g_str_has_prefix (_data_->_tmp107_, "http://www.flickr.com/photos/");
		_data_->_tmp89_ = _data_->_tmp108_;
	}
	if (_data_->_tmp89_) {
		_data_->_tmp88_ = TRUE;
	} else {
		_data_->_tmp109_ = NULL;
		_data_->_tmp109_ = _data_->url;
		_data_->_tmp110_ = FALSE;
		_data_->_tmp110_ = g_str_has_prefix (_data_->_tmp109_, "https://www.flickr.com/photos/");
		_data_->_tmp88_ = _data_->_tmp110_;
	}
	if (_data_->_tmp88_) {
		_data_->_tmp111_ = NULL;
		_data_->_tmp111_ = _data_->_data21_->t;
		_data_->_tmp112_ = NULL;
		_data_->_tmp112_ = _data_->_data21_->media;
		_data_->_state_ = 2;
		inline_media_downloader_load_real_url (_data_->_tmp111_, _data_->_tmp112_, "<meta property=\"og:image\" content=\"(.*?)\"", 1, inline_media_downloader_load_inline_media_ready, _data_);
		return FALSE;
		_state_2:
		inline_media_downloader_load_real_url_finish (_data_->_res_);
	} else {
		_data_->_tmp113_ = NULL;
		_data_->_tmp113_ = _data_->url;
		_data_->_tmp114_ = FALSE;
		_data_->_tmp114_ = g_str_has_prefix (_data_->_tmp113_, "http://twitpic.com/");
		if (_data_->_tmp114_) {
			_data_->_tmp115_ = NULL;
			_data_->_tmp115_ = _data_->_data21_->t;
			_data_->_tmp116_ = NULL;
			_data_->_tmp116_ = _data_->_data21_->media;
			_data_->_state_ = 3;
			inline_media_downloader_load_real_url (_data_->_tmp115_, _data_->_tmp116_, "<meta name=\"twitter:image\" value=\"(.*?)\"", 1, inline_media_downloader_load_inline_media_ready, _data_);
			return FALSE;
			_state_3:
			inline_media_downloader_load_real_url_finish (_data_->_res_);
		} else {
			_data_->_tmp117_ = NULL;
			_data_->_tmp117_ = _data_->url;
			_data_->_tmp118_ = FALSE;
			_data_->_tmp118_ = g_str_has_prefix (_data_->_tmp117_, "https://vine.co/v/");
			if (_data_->_tmp118_) {
				_data_->_tmp119_ = NULL;
				_data_->_tmp119_ = _data_->_data21_->t;
				_data_->_tmp120_ = NULL;
				_data_->_tmp120_ = _data_->_data21_->media;
				_data_->_state_ = 4;
				inline_media_downloader_load_real_url (_data_->_tmp119_, _data_->_tmp120_, "<meta property=\"og:image\" content=\"(.*?)\"", 1, inline_media_downloader_load_inline_media_ready, _data_);
				return FALSE;
				_state_4:
				inline_media_downloader_load_real_url_finish (_data_->_res_);
			} else {
				_data_->_tmp121_ = NULL;
				_data_->_tmp121_ = _data_->url;
				_data_->_tmp122_ = FALSE;
				_data_->_tmp122_ = g_str_has_suffix (_data_->_tmp121_, "/photo/1");
				if (_data_->_tmp122_) {
					_data_->_tmp123_ = NULL;
					_data_->_tmp123_ = _data_->_data21_->t;
					_data_->_tmp124_ = NULL;
					_data_->_tmp124_ = _data_->_data21_->media;
					_data_->_state_ = 5;
					inline_media_downloader_load_real_url (_data_->_tmp123_, _data_->_tmp124_, "<img src=\"(.*?)\" class=\"animated-gif-thumbnail", 1, inline_media_downloader_load_inline_media_ready, _data_);
					return FALSE;
					_state_5:
					inline_media_downloader_load_real_url_finish (_data_->_res_);
				} else {
					_data_->_tmp125_ = NULL;
					_data_->_tmp125_ = _data_->url;
					_data_->_tmp126_ = FALSE;
					_data_->_tmp126_ = g_str_has_prefix (_data_->_tmp125_, "http://d.pr/i/");
					if (_data_->_tmp126_) {
						_data_->_tmp127_ = NULL;
						_data_->_tmp127_ = _data_->_data21_->t;
						_data_->_tmp128_ = NULL;
						_data_->_tmp128_ = _data_->_data21_->media;
						_data_->_state_ = 6;
						inline_media_downloader_load_real_url (_data_->_tmp127_, _data_->_tmp128_, "<meta property=\"og:image\"\\s+content=\"(.*?)\"", 1, inline_media_downloader_load_inline_media_ready, _data_);
						return FALSE;
						_state_6:
						inline_media_downloader_load_real_url_finish (_data_->_res_);
					}
				}
			}
		}
	}
	_data_->_tmp129_ = NULL;
	_data_->_tmp129_ = _data_->_data21_->media;
	_data_->_tmp130_ = NULL;
	_data_->_tmp130_ = media_get_thumb_url (_data_->_tmp129_);
	_data_->_tmp131_ = NULL;
	_data_->_tmp131_ = _data_->_tmp130_;
	_data_->_tmp132_ = NULL;
	_data_->_tmp132_ = soup_message_new ("GET", _data_->_tmp131_);
	_data_->_data21_->msg = _data_->_tmp132_;
	_data_->_tmp133_ = NULL;
	_data_->_tmp133_ = _data_->_data21_->msg;
	g_signal_connect_data (_data_->_tmp133_, "got-headers", (GCallback) ___lambda37__soup_message_got_headers, block21_data_ref (_data_->_data21_), (GClosureNotify) block21_data_unref, 0);
	_data_->_tmp134_ = NULL;
	_data_->_tmp134_ = _data_->_data21_->msg;
	g_signal_connect_data (_data_->_tmp134_, "got-chunk", (GCallback) ___lambda38__soup_message_got_chunk, block21_data_ref (_data_->_data21_), (GClosureNotify) block21_data_unref, 0);
	_data_->_tmp135_ = NULL;
	_data_->_tmp135_ = SOUP_SESSION;
	_data_->_tmp136_ = NULL;
	_data_->_tmp136_ = _data_->_data21_->msg;
	_data_->_tmp137_ = NULL;
	_data_->_tmp137_ = _g_object_ref0 (_data_->_tmp136_);
	soup_session_queue_message (_data_->_tmp135_, _data_->_tmp137_, ___lambda39__soup_session_callback, block21_data_ref (_data_->_data21_));
	_data_->_state_ = 7;
	return FALSE;
	_state_7:
	;
	_g_free0 (_data_->url);
	block21_data_unref (_data_->_data21_);
	_data_->_data21_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void inline_media_downloader_load_animation_data_free (gpointer _data) {
	InlineMediaDownloaderLoadAnimationData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->t);
	_g_object_unref0 (_data_->in_stream);
	_g_object_unref0 (_data_->thumb_out_stream);
	_g_object_unref0 (_data_->media);
	g_slice_free (InlineMediaDownloaderLoadAnimationData, _data_);
}


void inline_media_downloader_load_animation (Tweet* t, GMemoryInputStream* in_stream, GOutputStream* thumb_out_stream, Media* media, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	InlineMediaDownloaderLoadAnimationData* _data_;
	Tweet* _tmp0_ = NULL;
	Tweet* _tmp1_ = NULL;
	GMemoryInputStream* _tmp2_ = NULL;
	GMemoryInputStream* _tmp3_ = NULL;
	GOutputStream* _tmp4_ = NULL;
	GOutputStream* _tmp5_ = NULL;
	Media* _tmp6_ = NULL;
	Media* _tmp7_ = NULL;
	_data_ = g_slice_new0 (InlineMediaDownloaderLoadAnimationData);
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, inline_media_downloader_load_animation);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, inline_media_downloader_load_animation_data_free);
	_tmp0_ = t;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data_->t);
	_data_->t = _tmp1_;
	_tmp2_ = in_stream;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (_data_->in_stream);
	_data_->in_stream = _tmp3_;
	_tmp4_ = thumb_out_stream;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	_g_object_unref0 (_data_->thumb_out_stream);
	_data_->thumb_out_stream = _tmp5_;
	_tmp6_ = media;
	_tmp7_ = _g_object_ref0 (_tmp6_);
	_g_object_unref0 (_data_->media);
	_data_->media = _tmp7_;
	inline_media_downloader_load_animation_co (_data_);
}


void inline_media_downloader_load_animation_finish (GAsyncResult* _res_) {
	InlineMediaDownloaderLoadAnimationData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void inline_media_downloader_load_animation_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	InlineMediaDownloaderLoadAnimationData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	inline_media_downloader_load_animation_co (_data_);
}


static gboolean inline_media_downloader_load_animation_co (InlineMediaDownloaderLoadAnimationData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_tmp1_ = NULL;
		_data_->_tmp1_ = _data_->in_stream;
		_data_->_state_ = 1;
		gdk_pixbuf_animation_new_from_stream_async (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp1_, G_TYPE_INPUT_STREAM, GInputStream), NULL, inline_media_downloader_load_animation_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp2_ = NULL;
		_data_->_tmp2_ = gdk_pixbuf_animation_new_from_stream_finish (_data_->_res_, &_data_->_inner_error_);
		_data_->_tmp0_ = _data_->_tmp2_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			goto __catch20_g_error;
		}
		_data_->_tmp3_ = NULL;
		_data_->_tmp3_ = _data_->_tmp0_;
		_data_->_tmp0_ = NULL;
		_g_object_unref0 (_data_->anim);
		_data_->anim = _data_->_tmp3_;
		_g_object_unref0 (_data_->_tmp0_);
	}
	goto __finally20;
	__catch20_g_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp4_ = NULL;
		_data_->_tmp4_ = _data_->e;
		_data_->_tmp5_ = NULL;
		_data_->_tmp5_ = _data_->_tmp4_->message;
		g_warning ("InlineMediaDownloader.vala:261: %s", _data_->_tmp5_);
		_data_->_tmp6_ = NULL;
		_data_->_tmp6_ = _data_->media;
		_data_->_tmp7_ = NULL;
		_data_->_tmp7_ = _data_->in_stream;
		_data_->_tmp8_ = NULL;
		_data_->_tmp8_ = _data_->thumb_out_stream;
		inline_media_downloader_mark_invalid (_data_->_tmp6_, G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp7_, G_TYPE_INPUT_STREAM, GInputStream), _data_->_tmp8_, NULL);
		_g_error_free0 (_data_->e);
		_g_object_unref0 (_data_->anim);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally20:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		_g_object_unref0 (_data_->anim);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	_data_->_tmp9_ = NULL;
	_data_->_tmp9_ = _data_->anim;
	_data_->_tmp10_ = NULL;
	_data_->_tmp10_ = gdk_pixbuf_animation_get_static_image (_data_->_tmp9_);
	_data_->_tmp11_ = NULL;
	_data_->_tmp11_ = _g_object_ref0 (_data_->_tmp10_);
	_data_->pic = _data_->_tmp11_;
	_data_->_tmp12_ = NULL;
	_data_->_tmp12_ = _data_->t;
	_data_->_tmp13_ = NULL;
	_data_->_tmp13__length1 = 0;
	_data_->_tmp13_ = _data_->_tmp12_->medias;
	_data_->_tmp13__length1 = _data_->_tmp12_->medias_length1;
	_data_->thumb_width = (gint) (600.0 / ((gfloat) _data_->_tmp13__length1));
	_data_->_tmp14_ = NULL;
	_data_->_tmp14_ = _data_->pic;
	_data_->_tmp15_ = 0;
	_data_->_tmp15_ = _data_->thumb_width;
	_data_->_tmp16_ = NULL;
	_data_->_tmp16_ = utils_slice_pixbuf (_data_->_tmp14_, _data_->_tmp15_, MULTI_MEDIA_WIDGET_HEIGHT);
	_data_->thumb = _data_->_tmp16_;
	_data_->_tmp17_ = NULL;
	_data_->_tmp17_ = _data_->thumb;
	_data_->_tmp18_ = NULL;
	_data_->_tmp18_ = _data_->thumb_out_stream;
	_data_->_state_ = 2;
	utils_write_pixbuf_async (_data_->_tmp17_, _data_->_tmp18_, "png", inline_media_downloader_load_animation_ready, _data_);
	return FALSE;
	_state_2:
	utils_write_pixbuf_finish (_data_->_res_);
	_data_->_tmp19_ = NULL;
	_data_->_tmp19_ = _data_->media;
	_data_->_tmp20_ = NULL;
	_data_->_tmp20_ = _data_->thumb;
	_data_->_tmp21_ = NULL;
	_data_->_tmp21_ = _g_object_ref0 (_data_->_tmp20_);
	_g_object_unref0 (_data_->_tmp19_->thumbnail);
	_data_->_tmp19_->thumbnail = _data_->_tmp21_;
	_data_->_tmp22_ = NULL;
	_data_->_tmp22_ = _data_->media;
	_data_->_tmp22_->loaded = TRUE;
	_data_->_tmp23_ = NULL;
	_data_->_tmp23_ = _data_->media;
	g_signal_emit_by_name (_data_->_tmp23_, "finished-loading");
	{
		_data_->_tmp24_ = NULL;
		_data_->_tmp24_ = _data_->in_stream;
		g_input_stream_close (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp24_, G_TYPE_INPUT_STREAM, GInputStream), NULL, &_data_->_inner_error_);
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			goto __catch21_g_error;
		}
		_data_->_tmp25_ = NULL;
		_data_->_tmp25_ = _data_->thumb_out_stream;
		g_output_stream_close (_data_->_tmp25_, NULL, &_data_->_inner_error_);
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			goto __catch21_g_error;
		}
	}
	goto __finally21;
	__catch21_g_error:
	{
		_data_->_vala1_e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp26_ = NULL;
		_data_->_tmp26_ = _data_->_vala1_e;
		_data_->_tmp27_ = NULL;
		_data_->_tmp27_ = _data_->_tmp26_->message;
		g_warning ("InlineMediaDownloader.vala:276: %s", _data_->_tmp27_);
		_g_error_free0 (_data_->_vala1_e);
	}
	__finally21:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		_g_object_unref0 (_data_->thumb);
		_g_object_unref0 (_data_->pic);
		_g_object_unref0 (_data_->anim);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	_g_object_unref0 (_data_->thumb);
	_g_object_unref0 (_data_->pic);
	_g_object_unref0 (_data_->anim);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void inline_media_downloader_load_normal_media_data_free (gpointer _data) {
	InlineMediaDownloaderLoadNormalMediaData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->t);
	_g_object_unref0 (_data_->in_stream);
	_g_object_unref0 (_data_->thumb_out_stream);
	_g_object_unref0 (_data_->media);
	g_slice_free (InlineMediaDownloaderLoadNormalMediaData, _data_);
}


void inline_media_downloader_load_normal_media (Tweet* t, GInputStream* in_stream, GOutputStream* thumb_out_stream, Media* media, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	InlineMediaDownloaderLoadNormalMediaData* _data_;
	Tweet* _tmp0_ = NULL;
	Tweet* _tmp1_ = NULL;
	GInputStream* _tmp2_ = NULL;
	GInputStream* _tmp3_ = NULL;
	GOutputStream* _tmp4_ = NULL;
	GOutputStream* _tmp5_ = NULL;
	Media* _tmp6_ = NULL;
	Media* _tmp7_ = NULL;
	_data_ = g_slice_new0 (InlineMediaDownloaderLoadNormalMediaData);
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, inline_media_downloader_load_normal_media);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, inline_media_downloader_load_normal_media_data_free);
	_tmp0_ = t;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data_->t);
	_data_->t = _tmp1_;
	_tmp2_ = in_stream;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (_data_->in_stream);
	_data_->in_stream = _tmp3_;
	_tmp4_ = thumb_out_stream;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	_g_object_unref0 (_data_->thumb_out_stream);
	_data_->thumb_out_stream = _tmp5_;
	_tmp6_ = media;
	_tmp7_ = _g_object_ref0 (_tmp6_);
	_g_object_unref0 (_data_->media);
	_data_->media = _tmp7_;
	inline_media_downloader_load_normal_media_co (_data_);
}


void inline_media_downloader_load_normal_media_finish (GAsyncResult* _res_) {
	InlineMediaDownloaderLoadNormalMediaData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void inline_media_downloader_load_normal_media_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	InlineMediaDownloaderLoadNormalMediaData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	inline_media_downloader_load_normal_media_co (_data_);
}


static gboolean inline_media_downloader_load_normal_media_co (InlineMediaDownloaderLoadNormalMediaData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->pic = NULL;
	{
		_data_->_tmp1_ = NULL;
		_data_->_tmp1_ = _data_->in_stream;
		_data_->_state_ = 1;
		gdk_pixbuf_new_from_stream_async (_data_->_tmp1_, NULL, inline_media_downloader_load_normal_media_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp2_ = NULL;
		_data_->_tmp2_ = gdk_pixbuf_new_from_stream_finish (_data_->_res_, &_data_->_inner_error_);
		_data_->_tmp0_ = _data_->_tmp2_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			goto __catch22_g_error;
		}
		_data_->_tmp3_ = NULL;
		_data_->_tmp3_ = _data_->_tmp0_;
		_data_->_tmp0_ = NULL;
		_g_object_unref0 (_data_->pic);
		_data_->pic = _data_->_tmp3_;
		_g_object_unref0 (_data_->_tmp0_);
	}
	goto __finally22;
	__catch22_g_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp4_ = NULL;
		_data_->_tmp4_ = _data_->e;
		_data_->_tmp5_ = NULL;
		_data_->_tmp5_ = _data_->_tmp4_->message;
		_data_->_tmp6_ = NULL;
		_data_->_tmp6_ = _data_->media;
		_data_->_tmp7_ = NULL;
		_data_->_tmp7_ = _data_->_tmp6_->path;
		g_warning ("InlineMediaDownloader.vala:289: %s(%s)", _data_->_tmp5_, _data_->_tmp7_);
		_data_->_tmp8_ = NULL;
		_data_->_tmp8_ = _data_->media;
		_data_->_tmp9_ = NULL;
		_data_->_tmp9_ = _data_->in_stream;
		_data_->_tmp10_ = NULL;
		_data_->_tmp10_ = _data_->thumb_out_stream;
		inline_media_downloader_mark_invalid (_data_->_tmp8_, _data_->_tmp9_, _data_->_tmp10_, NULL);
		_g_error_free0 (_data_->e);
		_g_object_unref0 (_data_->pic);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally22:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		_g_object_unref0 (_data_->pic);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	_data_->_tmp11_ = NULL;
	_data_->_tmp11_ = _data_->t;
	_data_->_tmp12_ = NULL;
	_data_->_tmp12__length1 = 0;
	_data_->_tmp12_ = _data_->_tmp11_->medias;
	_data_->_tmp12__length1 = _data_->_tmp11_->medias_length1;
	_data_->thumb_width = (gint) (600.0 / ((gfloat) _data_->_tmp12__length1));
	_data_->_tmp13_ = NULL;
	_data_->_tmp13_ = _data_->pic;
	_data_->_tmp14_ = 0;
	_data_->_tmp14_ = _data_->thumb_width;
	_data_->_tmp15_ = NULL;
	_data_->_tmp15_ = utils_slice_pixbuf (_data_->_tmp13_, _data_->_tmp14_, MULTI_MEDIA_WIDGET_HEIGHT);
	_data_->thumb = _data_->_tmp15_;
	_data_->_tmp16_ = NULL;
	_data_->_tmp16_ = _data_->thumb;
	_data_->_tmp17_ = NULL;
	_data_->_tmp17_ = _data_->thumb_out_stream;
	_data_->_state_ = 2;
	utils_write_pixbuf_async (_data_->_tmp16_, _data_->_tmp17_, "png", inline_media_downloader_load_normal_media_ready, _data_);
	return FALSE;
	_state_2:
	utils_write_pixbuf_finish (_data_->_res_);
	_data_->_tmp18_ = NULL;
	_data_->_tmp18_ = _data_->media;
	_data_->_tmp19_ = NULL;
	_data_->_tmp19_ = _data_->thumb;
	_data_->_tmp20_ = NULL;
	_data_->_tmp20_ = _g_object_ref0 (_data_->_tmp19_);
	_g_object_unref0 (_data_->_tmp18_->thumbnail);
	_data_->_tmp18_->thumbnail = _data_->_tmp20_;
	_data_->_tmp21_ = NULL;
	_data_->_tmp21_ = _data_->media;
	_data_->_tmp21_->loaded = TRUE;
	_data_->_tmp22_ = NULL;
	_data_->_tmp22_ = _data_->media;
	g_signal_emit_by_name (_data_->_tmp22_, "finished-loading");
	{
		_data_->_tmp23_ = NULL;
		_data_->_tmp23_ = _data_->in_stream;
		g_input_stream_close (_data_->_tmp23_, NULL, &_data_->_inner_error_);
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			goto __catch23_g_error;
		}
		_data_->_tmp24_ = NULL;
		_data_->_tmp24_ = _data_->thumb_out_stream;
		g_output_stream_close (_data_->_tmp24_, NULL, &_data_->_inner_error_);
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			goto __catch23_g_error;
		}
	}
	goto __finally23;
	__catch23_g_error:
	{
		_data_->_vala1_e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp25_ = NULL;
		_data_->_tmp25_ = _data_->_vala1_e;
		_data_->_tmp26_ = NULL;
		_data_->_tmp26_ = _data_->_tmp25_->message;
		g_warning ("InlineMediaDownloader.vala:304: %s", _data_->_tmp26_);
		_g_error_free0 (_data_->_vala1_e);
	}
	__finally23:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		_g_object_unref0 (_data_->thumb);
		_g_object_unref0 (_data_->pic);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	_g_object_unref0 (_data_->thumb);
	_g_object_unref0 (_data_->pic);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


gchar* inline_media_downloader_get_media_path (Tweet* t, Media* media) {
	gchar* result = NULL;
	gchar* ext = NULL;
	Media* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	gint64 id = 0LL;
	Tweet* _tmp10_ = NULL;
	gint64 _tmp11_ = 0LL;
	Tweet* _tmp12_ = NULL;
	gboolean _tmp13_ = FALSE;
	gint64 _tmp16_ = 0LL;
	gchar* _tmp17_ = NULL;
	gchar* _tmp18_ = NULL;
	Tweet* _tmp19_ = NULL;
	gint64 _tmp20_ = 0LL;
	gchar* _tmp21_ = NULL;
	gchar* _tmp22_ = NULL;
	Media* _tmp23_ = NULL;
	gint64 _tmp24_ = 0LL;
	gchar* _tmp25_ = NULL;
	gchar* _tmp26_ = NULL;
	const gchar* _tmp27_ = NULL;
	const gchar* _tmp28_ = NULL;
	gchar* _tmp29_ = NULL;
	gchar* _tmp30_ = NULL;
	gchar* _tmp31_ = NULL;
	gchar* _tmp32_ = NULL;
	g_return_val_if_fail (IS_TWEET (t), NULL);
	g_return_val_if_fail (IS_MEDIA (media), NULL);
	_tmp0_ = media;
	_tmp1_ = media_get_thumb_url (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = utils_get_file_type (_tmp2_);
	ext = _tmp3_;
	_tmp4_ = ext;
	_tmp5_ = g_utf8_strdown (_tmp4_, (gssize) (-1));
	_g_free0 (ext);
	ext = _tmp5_;
	_tmp6_ = ext;
	_tmp7_ = strlen (_tmp6_);
	_tmp8_ = _tmp7_;
	if (_tmp8_ == 0) {
		gchar* _tmp9_ = NULL;
		_tmp9_ = g_strdup ("png");
		_g_free0 (ext);
		ext = _tmp9_;
	}
	_tmp10_ = t;
	_tmp11_ = _tmp10_->id;
	id = _tmp11_;
	_tmp12_ = t;
	_tmp13_ = _tmp12_->is_retweet;
	if (_tmp13_) {
		Tweet* _tmp14_ = NULL;
		gint64 _tmp15_ = 0LL;
		_tmp14_ = t;
		_tmp15_ = _tmp14_->rt_id;
		id = _tmp15_;
	}
	_tmp16_ = id;
	_tmp17_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp16_);
	_tmp18_ = _tmp17_;
	_tmp19_ = t;
	_tmp20_ = _tmp19_->user_id;
	_tmp21_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp20_);
	_tmp22_ = _tmp21_;
	_tmp23_ = media;
	_tmp24_ = _tmp23_->id;
	_tmp25_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp24_);
	_tmp26_ = _tmp25_;
	_tmp27_ = ext;
	_tmp28_ = string_to_string (_tmp27_);
	_tmp29_ = g_strconcat ("assets/media/", _tmp18_, "_", _tmp22_, "_", _tmp26_, ".", _tmp28_, NULL);
	_tmp30_ = _tmp29_;
	_tmp31_ = dirs_cache (_tmp30_);
	_tmp32_ = _tmp31_;
	_g_free0 (_tmp30_);
	_g_free0 (_tmp26_);
	_g_free0 (_tmp22_);
	_g_free0 (_tmp18_);
	result = _tmp32_;
	_g_free0 (ext);
	return result;
}


gchar* inline_media_downloader_get_thumb_path (Tweet* t, Media* media) {
	gchar* result = NULL;
	gint64 id = 0LL;
	Tweet* _tmp0_ = NULL;
	gint64 _tmp1_ = 0LL;
	Tweet* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	gint64 _tmp6_ = 0LL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	Tweet* _tmp9_ = NULL;
	gint64 _tmp10_ = 0LL;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	Media* _tmp13_ = NULL;
	gint64 _tmp14_ = 0LL;
	gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	gchar* _tmp18_ = NULL;
	gchar* _tmp19_ = NULL;
	gchar* _tmp20_ = NULL;
	g_return_val_if_fail (IS_TWEET (t), NULL);
	g_return_val_if_fail (IS_MEDIA (media), NULL);
	_tmp0_ = t;
	_tmp1_ = _tmp0_->id;
	id = _tmp1_;
	_tmp2_ = t;
	_tmp3_ = _tmp2_->is_retweet;
	if (_tmp3_) {
		Tweet* _tmp4_ = NULL;
		gint64 _tmp5_ = 0LL;
		_tmp4_ = t;
		_tmp5_ = _tmp4_->rt_id;
		id = _tmp5_;
	}
	_tmp6_ = id;
	_tmp7_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = t;
	_tmp10_ = _tmp9_->user_id;
	_tmp11_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = media;
	_tmp14_ = _tmp13_->id;
	_tmp15_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp14_);
	_tmp16_ = _tmp15_;
	_tmp17_ = g_strconcat ("assets/media/thumbs/", _tmp8_, "_", _tmp12_, "_", _tmp16_, ".png", NULL);
	_tmp18_ = _tmp17_;
	_tmp19_ = dirs_cache (_tmp18_);
	_tmp20_ = _tmp19_;
	_g_free0 (_tmp18_);
	_g_free0 (_tmp16_);
	_g_free0 (_tmp12_);
	_g_free0 (_tmp8_);
	result = _tmp20_;
	return result;
}



