/* DMThreadsPage.c generated by valac 0.26.2, the Vala compiler
 * generated from DMThreadsPage.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <json-glib/json-glib.h>
#include <gee.h>
#include <gio/gio.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <rest/rest-proxy-call.h>
#include <rest/oauth-proxy.h>
#include <rest/rest-proxy.h>
#include <glib/gi18n-lib.h>


#define TYPE_SCROLL_WIDGET (scroll_widget_get_type ())
#define SCROLL_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCROLL_WIDGET, ScrollWidget))
#define SCROLL_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCROLL_WIDGET, ScrollWidgetClass))
#define IS_SCROLL_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCROLL_WIDGET))
#define IS_SCROLL_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCROLL_WIDGET))
#define SCROLL_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCROLL_WIDGET, ScrollWidgetClass))

typedef struct _ScrollWidget ScrollWidget;
typedef struct _ScrollWidgetClass ScrollWidgetClass;
typedef struct _ScrollWidgetPrivate ScrollWidgetPrivate;

#define TYPE_IPAGE (ipage_get_type ())
#define IPAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IPAGE, IPage))
#define IS_IPAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IPAGE))
#define IPAGE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_IPAGE, IPageIface))

typedef struct _IPage IPage;
typedef struct _IPageIface IPageIface;

#define TYPE_BUNDLE (bundle_get_type ())
#define BUNDLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUNDLE, Bundle))
#define BUNDLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUNDLE, BundleClass))
#define IS_BUNDLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUNDLE))
#define IS_BUNDLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUNDLE))
#define BUNDLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUNDLE, BundleClass))

typedef struct _Bundle Bundle;
typedef struct _BundleClass BundleClass;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;

#define TYPE_ACCOUNT (account_get_type ())
#define ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ACCOUNT, Account))
#define ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ACCOUNT, AccountClass))
#define IS_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ACCOUNT))
#define IS_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ACCOUNT))
#define ACCOUNT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ACCOUNT, AccountClass))

typedef struct _Account Account;
typedef struct _AccountClass AccountClass;

#define TYPE_IMESSAGE_RECEIVER (imessage_receiver_get_type ())
#define IMESSAGE_RECEIVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IMESSAGE_RECEIVER, IMessageReceiver))
#define IS_IMESSAGE_RECEIVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IMESSAGE_RECEIVER))
#define IMESSAGE_RECEIVER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_IMESSAGE_RECEIVER, IMessageReceiverIface))

typedef struct _IMessageReceiver IMessageReceiver;
typedef struct _IMessageReceiverIface IMessageReceiverIface;

#define TYPE_STREAM_MESSAGE_TYPE (stream_message_type_get_type ())

#define TYPE_DM_THREADS_PAGE (dm_threads_page_get_type ())
#define DM_THREADS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DM_THREADS_PAGE, DMThreadsPage))
#define DM_THREADS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DM_THREADS_PAGE, DMThreadsPageClass))
#define IS_DM_THREADS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DM_THREADS_PAGE))
#define IS_DM_THREADS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DM_THREADS_PAGE))
#define DM_THREADS_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DM_THREADS_PAGE, DMThreadsPageClass))

typedef struct _DMThreadsPage DMThreadsPage;
typedef struct _DMThreadsPageClass DMThreadsPageClass;
typedef struct _DMThreadsPagePrivate DMThreadsPagePrivate;

#define TYPE_DELTA_UPDATER (delta_updater_get_type ())
#define DELTA_UPDATER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DELTA_UPDATER, DeltaUpdater))
#define DELTA_UPDATER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DELTA_UPDATER, DeltaUpdaterClass))
#define IS_DELTA_UPDATER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DELTA_UPDATER))
#define IS_DELTA_UPDATER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DELTA_UPDATER))
#define DELTA_UPDATER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DELTA_UPDATER, DeltaUpdaterClass))

typedef struct _DeltaUpdater DeltaUpdater;
typedef struct _DeltaUpdaterClass DeltaUpdaterClass;

#define TYPE_BADGE_RADIO_TOOL_BUTTON (badge_radio_tool_button_get_type ())
#define BADGE_RADIO_TOOL_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BADGE_RADIO_TOOL_BUTTON, BadgeRadioToolButton))
#define BADGE_RADIO_TOOL_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BADGE_RADIO_TOOL_BUTTON, BadgeRadioToolButtonClass))
#define IS_BADGE_RADIO_TOOL_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BADGE_RADIO_TOOL_BUTTON))
#define IS_BADGE_RADIO_TOOL_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BADGE_RADIO_TOOL_BUTTON))
#define BADGE_RADIO_TOOL_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BADGE_RADIO_TOOL_BUTTON, BadgeRadioToolButtonClass))

typedef struct _BadgeRadioToolButton BadgeRadioToolButton;
typedef struct _BadgeRadioToolButtonClass BadgeRadioToolButtonClass;

#define TYPE_DM_THREAD_ENTRY (dm_thread_entry_get_type ())
#define DM_THREAD_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DM_THREAD_ENTRY, DMThreadEntry))
#define DM_THREAD_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DM_THREAD_ENTRY, DMThreadEntryClass))
#define IS_DM_THREAD_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DM_THREAD_ENTRY))
#define IS_DM_THREAD_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DM_THREAD_ENTRY))
#define DM_THREAD_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DM_THREAD_ENTRY, DMThreadEntryClass))

typedef struct _DMThreadEntry DMThreadEntry;
typedef struct _DMThreadEntryClass DMThreadEntryClass;

#define TYPE_START_CONVERSATION_ENTRY (start_conversation_entry_get_type ())
#define START_CONVERSATION_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_START_CONVERSATION_ENTRY, StartConversationEntry))
#define START_CONVERSATION_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_START_CONVERSATION_ENTRY, StartConversationEntryClass))
#define IS_START_CONVERSATION_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_START_CONVERSATION_ENTRY))
#define IS_START_CONVERSATION_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_START_CONVERSATION_ENTRY))
#define START_CONVERSATION_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_START_CONVERSATION_ENTRY, StartConversationEntryClass))

typedef struct _StartConversationEntry StartConversationEntry;
typedef struct _StartConversationEntryClass StartConversationEntryClass;

#define TYPE_COLLECT (collect_get_type ())
#define COLLECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COLLECT, Collect))
#define COLLECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COLLECT, CollectClass))
#define IS_COLLECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COLLECT))
#define IS_COLLECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COLLECT))
#define COLLECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COLLECT, CollectClass))

typedef struct _Collect Collect;
typedef struct _CollectClass CollectClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _DMThreadEntryPrivate DMThreadEntryPrivate;
typedef struct _MainWindowPrivate MainWindowPrivate;

#define TYPE_MAIN_WIDGET (main_widget_get_type ())
#define MAIN_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WIDGET, MainWidget))
#define MAIN_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WIDGET, MainWidgetClass))
#define IS_MAIN_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WIDGET))
#define IS_MAIN_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WIDGET))
#define MAIN_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WIDGET, MainWidgetClass))

typedef struct _MainWidget MainWidget;
typedef struct _MainWidgetClass MainWidgetClass;

#define TYPE_PAGE (page_get_type ())
#define _json_object_unref0(var) ((var == NULL) ? NULL : (var = (json_object_unref (var), NULL)))

#define SQL_TYPE_DATABASE (sql_database_get_type ())
#define SQL_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SQL_TYPE_DATABASE, SqlDatabase))
#define SQL_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SQL_TYPE_DATABASE, SqlDatabaseClass))
#define SQL_IS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SQL_TYPE_DATABASE))
#define SQL_IS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SQL_TYPE_DATABASE))
#define SQL_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SQL_TYPE_DATABASE, SqlDatabaseClass))

typedef struct _SqlDatabase SqlDatabase;
typedef struct _SqlDatabaseClass SqlDatabaseClass;

#define SQL_TYPE_SELECT_STATEMENT (sql_select_statement_get_type ())
#define SQL_SELECT_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SQL_TYPE_SELECT_STATEMENT, SqlSelectStatement))
#define SQL_SELECT_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SQL_TYPE_SELECT_STATEMENT, SqlSelectStatementClass))
#define SQL_IS_SELECT_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SQL_TYPE_SELECT_STATEMENT))
#define SQL_IS_SELECT_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SQL_TYPE_SELECT_STATEMENT))
#define SQL_SELECT_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SQL_TYPE_SELECT_STATEMENT, SqlSelectStatementClass))

typedef struct _SqlSelectStatement SqlSelectStatement;
typedef struct _SqlSelectStatementClass SqlSelectStatementClass;
#define _sql_select_statement_unref0(var) ((var == NULL) ? NULL : (var = (sql_select_statement_unref (var), NULL)))
typedef struct _Block17Data Block17Data;

#define TYPE_TWITTER (twitter_get_type ())
#define TWITTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWITTER, Twitter))
#define TWITTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWITTER, TwitterClass))
#define IS_TWITTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWITTER))
#define IS_TWITTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWITTER))
#define TWITTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWITTER, TwitterClass))

typedef struct _Twitter Twitter;
typedef struct _TwitterClass TwitterClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define __vala_JsonNode_free0(var) ((var == NULL) ? NULL : (var = (_vala_JsonNode_free (var), NULL)))
#define _json_array_unref0(var) ((var == NULL) ? NULL : (var = (json_array_unref (var), NULL)))

#define TWEET_UTILS_TYPE_SEQUENCE (tweet_utils_sequence_get_type ())
typedef struct _TweetUtilsSequence TweetUtilsSequence;
typedef struct _Block18Data Block18Data;
#define __g_slist_free__tweet_utils_sequence_free0_0(var) ((var == NULL) ? NULL : (var = (_g_slist_free__tweet_utils_sequence_free0_ (var), NULL)))

#define SQL_TYPE_UPDATE_STATEMENT (sql_update_statement_get_type ())
#define SQL_UPDATE_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SQL_TYPE_UPDATE_STATEMENT, SqlUpdateStatement))
#define SQL_UPDATE_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SQL_TYPE_UPDATE_STATEMENT, SqlUpdateStatementClass))
#define SQL_IS_UPDATE_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SQL_TYPE_UPDATE_STATEMENT))
#define SQL_IS_UPDATE_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SQL_TYPE_UPDATE_STATEMENT))
#define SQL_UPDATE_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SQL_TYPE_UPDATE_STATEMENT, SqlUpdateStatementClass))

typedef struct _SqlUpdateStatement SqlUpdateStatement;
typedef struct _SqlUpdateStatementClass SqlUpdateStatementClass;
#define _sql_update_statement_unref0(var) ((var == NULL) ? NULL : (var = (sql_update_statement_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define SQL_TYPE_INSERT_STATEMENT (sql_insert_statement_get_type ())
#define SQL_INSERT_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SQL_TYPE_INSERT_STATEMENT, SqlInsertStatement))
#define SQL_INSERT_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SQL_TYPE_INSERT_STATEMENT, SqlInsertStatementClass))
#define SQL_IS_INSERT_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SQL_TYPE_INSERT_STATEMENT))
#define SQL_IS_INSERT_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SQL_TYPE_INSERT_STATEMENT))
#define SQL_INSERT_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SQL_TYPE_INSERT_STATEMENT, SqlInsertStatementClass))

typedef struct _SqlInsertStatement SqlInsertStatement;
typedef struct _SqlInsertStatementClass SqlInsertStatementClass;
#define _sql_insert_statement_unref0(var) ((var == NULL) ? NULL : (var = (sql_insert_statement_unref (var), NULL)))

#define TYPE_USER_COUNTER (user_counter_get_type ())
#define USER_COUNTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_USER_COUNTER, UserCounter))
#define USER_COUNTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_USER_COUNTER, UserCounterClass))
#define IS_USER_COUNTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_USER_COUNTER))
#define IS_USER_COUNTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_USER_COUNTER))
#define USER_COUNTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_USER_COUNTER, UserCounterClass))

typedef struct _UserCounter UserCounter;
typedef struct _UserCounterClass UserCounterClass;
typedef struct _Block19Data Block19Data;
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))

#define TYPE_DM_PAGE (dm_page_get_type ())
#define DM_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DM_PAGE, DMPage))
#define DM_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DM_PAGE, DMPageClass))
#define IS_DM_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DM_PAGE))
#define IS_DM_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DM_PAGE))
#define DM_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DM_PAGE, DMPageClass))

typedef struct _DMPage DMPage;
typedef struct _DMPageClass DMPageClass;
typedef struct _DMPagePrivate DMPagePrivate;

struct _ScrollWidget {
	GtkScrolledWindow parent_instance;
	ScrollWidgetPrivate * priv;
};

struct _ScrollWidgetClass {
	GtkScrolledWindowClass parent_class;
};

struct _IPageIface {
	GTypeInterface parent_iface;
	void (*on_join) (IPage* self, gint page_id, Bundle* args);
	void (*on_leave) (IPage* self);
	void (*create_tool_button) (IPage* self, GtkRadioButton* group);
	GtkRadioButton* (*get_tool_button) (IPage* self);
	gchar* (*get_title) (IPage* self);
	gboolean (*handles_double_open) (IPage* self);
	void (*double_open) (IPage* self);
	gint (*get_id) (IPage* self);
	void (*set_id) (IPage* self, gint value);
	MainWindow* (*get_main_window) (IPage* self);
	void (*set_main_window) (IPage* self, MainWindow* value);
	Account* (*get_account) (IPage* self);
	void (*set_account) (IPage* self, Account* value);
};

typedef enum  {
	STREAM_MESSAGE_TYPE_UNSUPPORTED,
	STREAM_MESSAGE_TYPE_DELETE,
	STREAM_MESSAGE_TYPE_SCRUB_GEO,
	STREAM_MESSAGE_TYPE_LIMIT,
	STREAM_MESSAGE_TYPE_DISCONNECT,
	STREAM_MESSAGE_TYPE_FRIENDS,
	STREAM_MESSAGE_TYPE_EVENT,
	STREAM_MESSAGE_TYPE_WARNING,
	STREAM_MESSAGE_TYPE_DIRECT_MESSAGE,
	STREAM_MESSAGE_TYPE_TWEET,
	STREAM_MESSAGE_TYPE_EVENT_LIST_CREATED,
	STREAM_MESSAGE_TYPE_EVENT_LIST_DESTROYED,
	STREAM_MESSAGE_TYPE_EVENT_LIST_UPDATED,
	STREAM_MESSAGE_TYPE_EVENT_LIST_UNSUBSCRIBED,
	STREAM_MESSAGE_TYPE_EVENT_LIST_SUBSCRIBED,
	STREAM_MESSAGE_TYPE_EVENT_LIST_MEMBER_ADDED,
	STREAM_MESSAGE_TYPE_EVENT_LIST_MEMBER_REMOVED,
	STREAM_MESSAGE_TYPE_EVENT_FAVORITE,
	STREAM_MESSAGE_TYPE_EVENT_UNFAVORITE,
	STREAM_MESSAGE_TYPE_EVENT_FOLLOW,
	STREAM_MESSAGE_TYPE_EVENT_UNFOLLOW,
	STREAM_MESSAGE_TYPE_EVENT_BLOCK,
	STREAM_MESSAGE_TYPE_EVENT_UNBLOCK,
	STREAM_MESSAGE_TYPE_EVENT_MUTE,
	STREAM_MESSAGE_TYPE_EVENT_UNMUTE,
	STREAM_MESSAGE_TYPE_EVENT_USER_UPDATE
} StreamMessageType;

struct _IMessageReceiverIface {
	GTypeInterface parent_iface;
	void (*stream_message_received) (IMessageReceiver* self, StreamMessageType type, JsonNode* root_node);
};

struct _DMThreadsPage {
	ScrollWidget parent_instance;
	DMThreadsPagePrivate * priv;
};

struct _DMThreadsPageClass {
	ScrollWidgetClass parent_class;
};

struct _DMThreadsPagePrivate {
	gboolean initialized;
	gint _unread_count;
	MainWindow* _main_window;
	Account* _account;
	DeltaUpdater* _delta_updater;
	gint _id;
	BadgeRadioToolButton* tool_button;
	GeeHashMap* thread_map;
	StartConversationEntry* start_conversation_entry;
	gint64 max_received_id;
	gint64 max_sent_id;
	GtkListBox* thread_list;
	GtkSpinner* progress_spinner;
	Collect* dm_download_collect;
};

struct _DMThreadEntry {
	GtkListBoxRow parent_instance;
	DMThreadEntryPrivate * priv;
	gint unread_count;
	gchar* notification_id;
};

struct _DMThreadEntryClass {
	GtkListBoxRowClass parent_class;
};

struct _MainWindow {
	GtkApplicationWindow parent_instance;
	MainWindowPrivate * priv;
	GtkButton* back_button;
	GtkToggleButton* compose_tweet_button;
	MainWidget* main_widget;
};

struct _MainWindowClass {
	GtkApplicationWindowClass parent_class;
};

typedef enum  {
	PAGE_STREAM = 0,
	PAGE_MENTIONS,
	PAGE_FAVORITES,
	PAGE_DM_THREADS,
	PAGE_LISTS,
	PAGE_FILTERS,
	PAGE_SEARCH,
	PAGE_PROFILE,
	PAGE_TWEET_INFO,
	PAGE_DM,
	PAGE_LIST_STATUSES,
	PAGE_PREVIOUS = 1024,
	PAGE_NEXT = 2048
} Page;

typedef gboolean (*SqlSelectCallback) (gchar** vals, int vals_length1, void* user_data);
struct _Block17Data {
	int _ref_count_;
	DMThreadsPage* self;
	DMThreadEntry* entry;
};

typedef void (*TwitterAvatarDownloadedFunc) (GdkPixbuf* avatar, void* user_data);
struct _TweetUtilsSequence {
	gint start;
	gint end;
	gchar* url;
	gchar* display_url;
	gboolean visual_display_url;
	gchar* title;
};

struct _Block18Data {
	int _ref_count_;
	DMThreadsPage* self;
	GSList* url_list;
	DMThreadEntry* thread_entry;
};

struct _Block19Data {
	int _ref_count_;
	DMThreadsPage* self;
	GSList* url_list;
};

struct _DMPage {
	GtkBox parent_instance;
	DMPagePrivate * priv;
	gint64 user_id;
};

struct _DMPageClass {
	GtkBoxClass parent_class;
};


static gpointer dm_threads_page_parent_class = NULL;
static IPageIface* dm_threads_page_ipage_parent_iface = NULL;
static IMessageReceiverIface* dm_threads_page_imessage_receiver_parent_iface = NULL;

GType scroll_widget_get_type (void) G_GNUC_CONST;
GType bundle_get_type (void) G_GNUC_CONST;
GType main_window_get_type (void) G_GNUC_CONST;
GType account_get_type (void) G_GNUC_CONST;
GType ipage_get_type (void) G_GNUC_CONST;
GType stream_message_type_get_type (void) G_GNUC_CONST;
GType imessage_receiver_get_type (void) G_GNUC_CONST;
GType dm_threads_page_get_type (void) G_GNUC_CONST;
GType delta_updater_get_type (void) G_GNUC_CONST;
GType badge_radio_tool_button_get_type (void) G_GNUC_CONST;
GType dm_thread_entry_get_type (void) G_GNUC_CONST;
GType start_conversation_entry_get_type (void) G_GNUC_CONST;
GType collect_get_type (void) G_GNUC_CONST;
#define DM_THREADS_PAGE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_DM_THREADS_PAGE, DMThreadsPagePrivate))
enum  {
	DM_THREADS_PAGE_DUMMY_PROPERTY,
	DM_THREADS_PAGE_UNREAD_COUNT,
	DM_THREADS_PAGE_MAIN_WINDOW,
	DM_THREADS_PAGE_ACCOUNT,
	DM_THREADS_PAGE_DELTA_UPDATER,
	DM_THREADS_PAGE_ID
};
guint utils_int64_hash_func (gint64* k);
static guint _utils_int64_hash_func_gee_hash_data_func (gconstpointer v, gpointer self);
gboolean utils_int64_equal_func (gint64* a, gint64* b);
static gboolean _utils_int64_equal_func_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self);
gboolean dm_thread_entry_equal_func (DMThreadEntry* a, DMThreadEntry* b);
static gboolean _dm_thread_entry_equal_func_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self);
static gint64* _int64_dup (gint64* self);
DMThreadsPage* dm_threads_page_new (gint id, Account* account);
DMThreadsPage* dm_threads_page_construct (GType object_type, gint id, Account* account);
ScrollWidget* scroll_widget_new (void);
ScrollWidget* scroll_widget_construct (GType object_type);
void ipage_set_id (IPage* self, gint value);
void ipage_set_account (IPage* self, Account* value);
Collect* collect_new (gint max);
Collect* collect_construct (GType object_type, gint max);
static void dm_threads_page_header_func (DMThreadsPage* self, GtkListBoxRow* row, GtkListBoxRow* row_before);
static void _dm_threads_page_header_func_gtk_list_box_update_header_func (GtkListBoxRow* row, GtkListBoxRow* before, gpointer self);
gint dm_thread_entry_sort_func (GtkListBoxRow* r1, GtkListBoxRow* r2);
static gint _dm_thread_entry_sort_func_gtk_list_box_sort_func (GtkListBoxRow* row1, GtkListBoxRow* row2, gpointer self);
static void __lambda113_ (DMThreadsPage* self, GtkListBoxRow* row);
void start_conversation_entry_reveal (StartConversationEntry* self);
Bundle* bundle_new (void);
Bundle* bundle_construct (GType object_type);
void bundle_put_int64 (Bundle* self, const gchar* key, gint64 value);
gint64 dm_thread_entry_get_user_id (DMThreadEntry* self);
MainWindow* ipage_get_main_window (IPage* self);
GType main_widget_get_type (void) G_GNUC_CONST;
void main_widget_switch_page (MainWidget* self, gint page_id, Bundle* args);
GType page_get_type (void) G_GNUC_CONST;
static void ___lambda113__gtk_list_box_row_activated (GtkListBox* _sender, GtkListBoxRow* row, gpointer self);
StartConversationEntry* start_conversation_entry_new (Account* account);
StartConversationEntry* start_conversation_entry_construct (GType object_type, Account* account);
static void __lambda114_ (DMThreadsPage* self, gint64 user_id, const gchar* screen_name, const gchar* name, const gchar* avatar_url);
gint dm_threads_page_get_unread_count (DMThreadsPage* self);
void dm_threads_page_set_unread_count (DMThreadsPage* self, gint value);
static void dm_threads_page_update_unread_count (DMThreadsPage* self);
void bundle_put_string (Bundle* self, const gchar* key, const gchar* value);
static void ___lambda114__start_conversation_entry_start (StartConversationEntry* _sender, gint64 user_id, const gchar* screen_name, const gchar* name, const gchar* avatar_url, gpointer self);
void dm_threads_page_load_cached (DMThreadsPage* self);
static void dm_threads_page_real_stream_message_received (IMessageReceiver* base, StreamMessageType type, JsonNode* root);
static void dm_threads_page_add_new_thread (DMThreadsPage* self, JsonObject* dm_obj);
Account* ipage_get_account (IPage* self);
gint64 account_get_id (Account* self);
static gboolean dm_threads_page_user_id_visible (DMThreadsPage* self, gint64 sender_id);
static void dm_threads_page_real_on_join (IPage* base, gint page_id, Bundle* args);
void dm_threads_page_load_newest (DMThreadsPage* self);
static void dm_threads_page_real_on_leave (IPage* base);
void start_conversation_entry_unreveal (StartConversationEntry* self);
gpointer sql_database_ref (gpointer instance);
void sql_database_unref (gpointer instance);
GParamSpec* sql_param_spec_database (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void sql_value_set_database (GValue* value, gpointer v_object);
void sql_value_take_database (GValue* value, gpointer v_object);
gpointer sql_value_get_database (const GValue* value);
GType sql_database_get_type (void) G_GNUC_CONST;
SqlDatabase* account_get_db (Account* self);
gpointer sql_select_statement_ref (gpointer instance);
void sql_select_statement_unref (gpointer instance);
GParamSpec* sql_param_spec_select_statement (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void sql_value_set_select_statement (GValue* value, gpointer v_object);
void sql_value_take_select_statement (GValue* value, gpointer v_object);
gpointer sql_value_get_select_statement (const GValue* value);
GType sql_select_statement_get_type (void) G_GNUC_CONST;
SqlSelectStatement* sql_database_select (SqlDatabase* self, const gchar* table_name);
SqlSelectStatement* sql_select_statement_cols (SqlSelectStatement* self, const gchar* first, ...);
SqlSelectStatement* sql_select_statement_where_eqi (SqlSelectStatement* self, const gchar* w, gint64 v);
SqlSelectStatement* sql_select_statement_order (SqlSelectStatement* self, const gchar* order_by);
SqlSelectStatement* sql_select_statement_limit (SqlSelectStatement* self, gint limit);
gint64 sql_select_statement_once_i64 (SqlSelectStatement* self);
gint sql_select_statement_run (SqlSelectStatement* self, SqlSelectCallback callback, void* callback_target);
static gboolean __lambda115_ (DMThreadsPage* self, gchar** vals, int vals_length1);
static Block17Data* block17_data_ref (Block17Data* _data17_);
static void block17_data_unref (void * _userdata_);
DMThreadEntry* dm_thread_entry_new (gint64 user_id);
DMThreadEntry* dm_thread_entry_construct (GType object_type, gint64 user_id);
void dm_thread_entry_set_screen_name (DMThreadEntry* self, const gchar* value);
void dm_thread_entry_set_name (DMThreadEntry* self, const gchar* value);
void dm_thread_entry_set_last_message (DMThreadEntry* self, const gchar* value);
void dm_thread_entry_set_last_message_id (DMThreadEntry* self, gint64 value);
GType twitter_get_type (void) G_GNUC_CONST;
Twitter* twitter_get (void);
GdkPixbuf* twitter_get_avatar (Twitter* self, const gchar* url, TwitterAvatarDownloadedFunc func, void* func_target, GDestroyNotify func_target_destroy_notify);
static void __lambda116_ (Block17Data* _data17_, GdkPixbuf* a);
void dm_thread_entry_set_avatar (DMThreadEntry* self, GdkPixbuf* value);
static void ___lambda116__twitter_avatar_downloaded_func (GdkPixbuf* avatar, gpointer self);
static gboolean ___lambda115__sql_select_callback (gchar** vals, int vals_length1, gpointer self);
static void __lambda128_ (DMThreadsPage* self);
static void dm_threads_page_remove_spinner (DMThreadsPage* self);
static void dm_threads_page_save_last_messages (DMThreadsPage* self);
static void ___lambda128__collect_finished (Collect* _sender, GError* _error_, gpointer self);
OAuthProxy* account_get_proxy (Account* self);
void tweet_utils_load_threaded (RestProxyCall* call, GAsyncReadyCallback _callback_, gpointer _user_data_);
JsonNode* tweet_utils_load_threaded_finish (GAsyncResult* _res_);
static void __lambda129_ (DMThreadsPage* self, GObject* obj, GAsyncResult* res);
static void dm_threads_page_on_dm_result (DMThreadsPage* self, JsonNode* root);
static void _vala_JsonNode_free (JsonNode* self);
static void ___lambda129__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void __lambda131_ (DMThreadsPage* self, GObject* obj, GAsyncResult* res);
static void ___lambda131__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
void collect_emit (Collect* self, GError* _error_);
void sql_database_begin_transaction (SqlDatabase* self);
static void ___lambda130_ (DMThreadsPage* self, JsonArray* arr, guint pos, JsonNode* node);
static void dm_threads_page_save_message (DMThreadsPage* self, JsonObject* dm_obj);
static void ____lambda130__json_array_foreach (JsonArray* array, guint index_, JsonNode* element_node, gpointer self);
void sql_database_end_transaction (SqlDatabase* self);
GType tweet_utils_sequence_get_type (void) G_GNUC_CONST;
TweetUtilsSequence* tweet_utils_sequence_dup (const TweetUtilsSequence* self);
void tweet_utils_sequence_free (TweetUtilsSequence* self);
void tweet_utils_sequence_copy (const TweetUtilsSequence* self, TweetUtilsSequence* dest);
void tweet_utils_sequence_destroy (TweetUtilsSequence* self);
static Block18Data* block18_data_ref (Block18Data* _data18_);
static void _tweet_utils_sequence_free0_ (gpointer var);
static void _g_slist_free__tweet_utils_sequence_free0_ (GSList* self);
static void block18_data_unref (void * _userdata_);
gint64 dm_thread_entry_get_last_message_id (DMThreadEntry* self);
void dm_thread_entry_update_unread_count (DMThreadEntry* self);
gpointer sql_update_statement_ref (gpointer instance);
void sql_update_statement_unref (gpointer instance);
GParamSpec* sql_param_spec_update_statement (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void sql_value_set_update_statement (GValue* value, gpointer v_object);
void sql_value_take_update_statement (GValue* value, gpointer v_object);
gpointer sql_value_get_update_statement (const GValue* value);
GType sql_update_statement_get_type (void) G_GNUC_CONST;
SqlUpdateStatement* sql_database_update (SqlDatabase* self, const gchar* table_name);
SqlUpdateStatement* sql_update_statement_val (SqlUpdateStatement* self, const gchar* col_name, const gchar* col_value);
SqlUpdateStatement* sql_update_statement_vali64 (SqlUpdateStatement* self, const gchar* col_name, gint64 col_value);
SqlUpdateStatement* sql_update_statement_where_eqi (SqlUpdateStatement* self, const gchar* col, gint64 iv);
gint64 sql_update_statement_run (SqlUpdateStatement* self);
static gchar* dm_threads_page_notify_new_dm (DMThreadsPage* self, DMThreadEntry* thread_entry, const gchar* msg_text);
gchar* utils_unescape_html (const gchar* input);
static void __lambda126_ (Block18Data* _data18_, JsonArray* arr, guint index, JsonNode* node);
static void ___lambda126__json_array_foreach (JsonArray* array, guint index_, JsonNode* element_node, gpointer self);
gchar* tweet_utils_get_real_text (const gchar* tweet_text, GSList* urls);
gpointer sql_insert_statement_ref (gpointer instance);
void sql_insert_statement_unref (gpointer instance);
GParamSpec* sql_param_spec_insert_statement (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void sql_value_set_insert_statement (GValue* value, gpointer v_object);
void sql_value_take_insert_statement (GValue* value, gpointer v_object);
gpointer sql_value_get_insert_statement (const GValue* value);
GType sql_insert_statement_get_type (void) G_GNUC_CONST;
SqlInsertStatement* sql_database_insert (SqlDatabase* self, const gchar* table_name);
SqlInsertStatement* sql_insert_statement_vali64 (SqlInsertStatement* self, const gchar* col_name, gint64 col_value);
SqlInsertStatement* sql_insert_statement_val (SqlInsertStatement* self, const gchar* col_name, const gchar* col_value);
const gchar* dm_thread_entry_get_last_message (DMThreadEntry* self);
gint64 sql_insert_statement_run (SqlInsertStatement* self);
GType user_counter_get_type (void) G_GNUC_CONST;
UserCounter* account_get_user_counter (Account* self);
void user_counter_user_seen (UserCounter* self, gint64 id, const gchar* screen_name, const gchar* name);
static void __lambda127_ (Block18Data* _data18_, GdkPixbuf* a);
static void ___lambda127__twitter_avatar_downloaded_func (GdkPixbuf* avatar, gpointer self);
static Block19Data* block19_data_ref (Block19Data* _data19_);
static void block19_data_unref (void * _userdata_);
static void ___lambda117_ (Block19Data* _data19_, JsonArray* arr, guint index, JsonNode* node);
static void ____lambda117__json_array_foreach (JsonArray* array, guint index_, JsonNode* element_node, gpointer self);
gchar* tweet_utils_get_formatted_text (const gchar* tweet_text, GSList* urls);
GDateTime* utils_parse_date (const gchar* input);
gboolean settings_notify_new_dms (void);
const gchar* dm_thread_entry_get_screen_name (DMThreadEntry* self);
const gchar* dm_thread_entry_get_name (DMThreadEntry* self);
static void dm_threads_page_real_create_tool_button (IPage* base, GtkRadioButton* group);
BadgeRadioToolButton* badge_radio_tool_button_new (GtkRadioButton* group, const gchar* icon_name, const gchar* text);
BadgeRadioToolButton* badge_radio_tool_button_construct (GType object_type, GtkRadioButton* group, const gchar* icon_name, const gchar* text);
static GtkRadioButton* dm_threads_page_real_get_tool_button (IPage* base);
gint main_window_get_cur_page_id (MainWindow* self);
IPage* main_window_get_page (MainWindow* self, gint page_id);
GType dm_page_get_type (void) G_GNUC_CONST;
static gchar* dm_threads_page_real_get_title (IPage* base);
void badge_radio_tool_button_set_show_badge (BadgeRadioToolButton* self, gboolean value);
void dm_threads_page_adjust_unread_count_for_user_id (DMThreadsPage* self, gint64 user_id);
gchar* dm_threads_page_get_notification_id_for_user_id (DMThreadsPage* self, gint64 user_id);
DeltaUpdater* dm_threads_page_get_delta_updater (DMThreadsPage* self);
void dm_threads_page_set_delta_updater (DMThreadsPage* self, DeltaUpdater* value);
static void dm_threads_page_finalize (GObject* obj);
gint ipage_get_id (IPage* self);
static void _vala_dm_threads_page_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
void ipage_set_main_window (IPage* self, MainWindow* value);
static void _vala_dm_threads_page_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static guint _utils_int64_hash_func_gee_hash_data_func (gconstpointer v, gpointer self) {
	guint result;
	result = utils_int64_hash_func ((gint64*) v);
	return result;
}


static gboolean _utils_int64_equal_func_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self) {
	gboolean result;
	result = utils_int64_equal_func ((gint64*) a, (gint64*) b);
	return result;
}


static gboolean _dm_thread_entry_equal_func_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self) {
	gboolean result;
	result = dm_thread_entry_equal_func ((DMThreadEntry*) a, (DMThreadEntry*) b);
	return result;
}


static gint64* _int64_dup (gint64* self) {
	gint64* dup;
	dup = g_new0 (gint64, 1);
	memcpy (dup, self, sizeof (gint64));
	return dup;
}


static void _dm_threads_page_header_func_gtk_list_box_update_header_func (GtkListBoxRow* row, GtkListBoxRow* before, gpointer self) {
	dm_threads_page_header_func ((DMThreadsPage*) self, row, before);
}


static gint _dm_thread_entry_sort_func_gtk_list_box_sort_func (GtkListBoxRow* row1, GtkListBoxRow* row2, gpointer self) {
	gint result;
	result = dm_thread_entry_sort_func (row1, row2);
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void __lambda113_ (DMThreadsPage* self, GtkListBoxRow* row) {
	GtkListBoxRow* _tmp0_ = NULL;
	g_return_if_fail (GTK_IS_LIST_BOX_ROW (row));
	_tmp0_ = row;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, TYPE_START_CONVERSATION_ENTRY)) {
		GtkListBoxRow* _tmp1_ = NULL;
		_tmp1_ = row;
		start_conversation_entry_reveal (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_START_CONVERSATION_ENTRY, StartConversationEntry));
	} else {
		GtkListBoxRow* _tmp2_ = NULL;
		_tmp2_ = row;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, TYPE_DM_THREAD_ENTRY)) {
			DMThreadEntry* entry = NULL;
			GtkListBoxRow* _tmp3_ = NULL;
			DMThreadEntry* _tmp4_ = NULL;
			DMThreadEntry* _tmp5_ = NULL;
			const gchar* _tmp6_ = NULL;
			Bundle* bundle = NULL;
			Bundle* _tmp10_ = NULL;
			Bundle* _tmp11_ = NULL;
			DMThreadEntry* _tmp12_ = NULL;
			gint64 _tmp13_ = 0LL;
			gint64 _tmp14_ = 0LL;
			MainWindow* _tmp15_ = NULL;
			MainWindow* _tmp16_ = NULL;
			MainWidget* _tmp17_ = NULL;
			Bundle* _tmp18_ = NULL;
			_tmp3_ = row;
			_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, TYPE_DM_THREAD_ENTRY, DMThreadEntry));
			entry = _tmp4_;
			_tmp5_ = entry;
			_tmp6_ = _tmp5_->notification_id;
			if (_tmp6_ != NULL) {
				GApplication* _tmp7_ = NULL;
				DMThreadEntry* _tmp8_ = NULL;
				const gchar* _tmp9_ = NULL;
				_tmp7_ = g_application_get_default ();
				_tmp8_ = entry;
				_tmp9_ = _tmp8_->notification_id;
				g_application_withdraw_notification (_tmp7_, _tmp9_);
			}
			_tmp10_ = bundle_new ();
			bundle = _tmp10_;
			_tmp11_ = bundle;
			_tmp12_ = entry;
			_tmp13_ = dm_thread_entry_get_user_id (_tmp12_);
			_tmp14_ = _tmp13_;
			bundle_put_int64 (_tmp11_, "sender_id", _tmp14_);
			_tmp15_ = ipage_get_main_window (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
			_tmp16_ = _tmp15_;
			_tmp17_ = _tmp16_->main_widget;
			_tmp18_ = bundle;
			main_widget_switch_page (_tmp17_, (gint) PAGE_DM, _tmp18_);
			_g_object_unref0 (bundle);
			_g_object_unref0 (entry);
		}
	}
}


static void ___lambda113__gtk_list_box_row_activated (GtkListBox* _sender, GtkListBoxRow* row, gpointer self) {
	__lambda113_ ((DMThreadsPage*) self, row);
}


static void __lambda114_ (DMThreadsPage* self, gint64 user_id, const gchar* screen_name, const gchar* name, const gchar* avatar_url) {
	DMThreadEntry* thread_entry = NULL;
	GeeHashMap* _tmp0_ = NULL;
	gint64 _tmp1_ = 0LL;
	gpointer _tmp2_ = NULL;
	DMThreadEntry* _tmp3_ = NULL;
	DMThreadEntry* _tmp4_ = NULL;
	Bundle* bundle = NULL;
	Bundle* _tmp8_ = NULL;
	gint64 _tmp9_ = 0LL;
	const gchar* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	MainWindow* _tmp13_ = NULL;
	MainWindow* _tmp14_ = NULL;
	MainWidget* _tmp15_ = NULL;
	g_return_if_fail (screen_name != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (avatar_url != NULL);
	_tmp0_ = self->priv->thread_map;
	_tmp1_ = user_id;
	_tmp2_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), &_tmp1_);
	_tmp3_ = _g_object_ref0 ((DMThreadEntry*) _tmp2_);
	thread_entry = _tmp3_;
	_tmp4_ = thread_entry;
	if (_tmp4_ != NULL) {
		gint _tmp5_ = 0;
		DMThreadEntry* _tmp6_ = NULL;
		gint _tmp7_ = 0;
		_tmp5_ = self->priv->_unread_count;
		_tmp6_ = thread_entry;
		_tmp7_ = _tmp6_->unread_count;
		dm_threads_page_set_unread_count (self, _tmp5_ - _tmp7_);
		dm_threads_page_update_unread_count (self);
	}
	_tmp8_ = bundle_new ();
	bundle = _tmp8_;
	_tmp9_ = user_id;
	bundle_put_int64 (bundle, "sender_id", _tmp9_);
	_tmp10_ = screen_name;
	bundle_put_string (bundle, "screen_name", _tmp10_);
	_tmp11_ = name;
	bundle_put_string (bundle, "name", _tmp11_);
	_tmp12_ = avatar_url;
	bundle_put_string (bundle, "avatar_url", _tmp12_);
	_tmp13_ = ipage_get_main_window (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp14_ = _tmp13_;
	_tmp15_ = _tmp14_->main_widget;
	main_widget_switch_page (_tmp15_, (gint) PAGE_DM, bundle);
	_g_object_unref0 (bundle);
	_g_object_unref0 (thread_entry);
}


static void ___lambda114__start_conversation_entry_start (StartConversationEntry* _sender, gint64 user_id, const gchar* screen_name, const gchar* name, const gchar* avatar_url, gpointer self) {
	__lambda114_ ((DMThreadsPage*) self, user_id, screen_name, name, avatar_url);
}


DMThreadsPage* dm_threads_page_construct (GType object_type, gint id, Account* account) {
	DMThreadsPage * self = NULL;
	gint _tmp0_ = 0;
	Account* _tmp1_ = NULL;
	Collect* _tmp2_ = NULL;
	GtkListBox* _tmp3_ = NULL;
	GtkListBox* _tmp4_ = NULL;
	GtkListBox* _tmp5_ = NULL;
	Account* _tmp6_ = NULL;
	StartConversationEntry* _tmp7_ = NULL;
	StartConversationEntry* _tmp8_ = NULL;
	GtkListBox* _tmp9_ = NULL;
	StartConversationEntry* _tmp10_ = NULL;
	g_return_val_if_fail (IS_ACCOUNT (account), NULL);
	self = (DMThreadsPage*) scroll_widget_construct (object_type);
	_tmp0_ = id;
	ipage_set_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage), _tmp0_);
	_tmp1_ = account;
	ipage_set_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage), _tmp1_);
	_tmp2_ = collect_new (2);
	_g_object_unref0 (self->priv->dm_download_collect);
	self->priv->dm_download_collect = _tmp2_;
	_tmp3_ = self->priv->thread_list;
	gtk_list_box_set_header_func (_tmp3_, _dm_threads_page_header_func_gtk_list_box_update_header_func, g_object_ref (self), g_object_unref);
	_tmp4_ = self->priv->thread_list;
	gtk_list_box_set_sort_func (_tmp4_, _dm_thread_entry_sort_func_gtk_list_box_sort_func, NULL, NULL);
	_tmp5_ = self->priv->thread_list;
	g_signal_connect_object (_tmp5_, "row-activated", (GCallback) ___lambda113__gtk_list_box_row_activated, self, 0);
	_tmp6_ = account;
	_tmp7_ = start_conversation_entry_new (_tmp6_);
	g_object_ref_sink (_tmp7_);
	_g_object_unref0 (self->priv->start_conversation_entry);
	self->priv->start_conversation_entry = _tmp7_;
	_tmp8_ = self->priv->start_conversation_entry;
	g_signal_connect_object (_tmp8_, "start", (GCallback) ___lambda114__start_conversation_entry_start, self, 0);
	_tmp9_ = self->priv->thread_list;
	_tmp10_ = self->priv->start_conversation_entry;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, gtk_widget_get_type (), GtkWidget));
	dm_threads_page_load_cached (self);
	return self;
}


DMThreadsPage* dm_threads_page_new (gint id, Account* account) {
	return dm_threads_page_construct (TYPE_DM_THREADS_PAGE, id, account);
}


static gpointer _json_object_ref0 (gpointer self) {
	return self ? json_object_ref (self) : NULL;
}


static void dm_threads_page_real_stream_message_received (IMessageReceiver* base, StreamMessageType type, JsonNode* root) {
	DMThreadsPage * self;
	StreamMessageType _tmp0_ = 0;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DM_THREADS_PAGE, DMThreadsPage);
	g_return_if_fail (root != NULL);
	_tmp0_ = type;
	if (_tmp0_ == STREAM_MESSAGE_TYPE_DIRECT_MESSAGE) {
		JsonObject* obj = NULL;
		JsonNode* _tmp1_ = NULL;
		JsonObject* _tmp2_ = NULL;
		JsonObject* _tmp3_ = NULL;
		JsonObject* _tmp4_ = NULL;
		JsonObject* _tmp5_ = NULL;
		gint64 sender_id = 0LL;
		JsonObject* _tmp6_ = NULL;
		gint64 _tmp7_ = 0LL;
		gint64 _tmp8_ = 0LL;
		Account* _tmp9_ = NULL;
		Account* _tmp10_ = NULL;
		gint64 _tmp11_ = 0LL;
		gint64 _tmp12_ = 0LL;
		_tmp1_ = root;
		_tmp2_ = json_node_get_object (_tmp1_);
		_tmp3_ = json_object_get_object_member (_tmp2_, "direct_message");
		_tmp4_ = _json_object_ref0 (_tmp3_);
		obj = _tmp4_;
		_tmp5_ = obj;
		dm_threads_page_add_new_thread (self, _tmp5_);
		_tmp6_ = obj;
		_tmp7_ = json_object_get_int_member (_tmp6_, "sender_id");
		sender_id = _tmp7_;
		_tmp8_ = sender_id;
		_tmp9_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
		_tmp10_ = _tmp9_;
		_tmp11_ = account_get_id (_tmp10_);
		_tmp12_ = _tmp11_;
		if (_tmp8_ != _tmp12_) {
			gint64 _tmp13_ = 0LL;
			gboolean _tmp14_ = FALSE;
			_tmp13_ = sender_id;
			_tmp14_ = dm_threads_page_user_id_visible (self, _tmp13_);
			if (!_tmp14_) {
				gint _tmp15_ = 0;
				_tmp15_ = self->priv->_unread_count;
				dm_threads_page_set_unread_count (self, _tmp15_ + 1);
				dm_threads_page_update_unread_count (self);
				g_debug ("DMThreadsPage.vala:89: Increasing global unread count by 1");
			}
		}
		_json_object_unref0 (obj);
	}
}


static void dm_threads_page_real_on_join (IPage* base, gint page_id, Bundle* args) {
	DMThreadsPage * self;
	GNetworkMonitor* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DM_THREADS_PAGE, DMThreadsPage);
	g_return_if_fail ((args == NULL) || IS_BUNDLE (args));
	_tmp0_ = g_network_monitor_get_default ();
	_tmp1_ = g_network_monitor_get_network_available (_tmp0_);
	if (!_tmp1_) {
		return;
	}
	_tmp2_ = self->priv->initialized;
	if (!_tmp2_) {
		dm_threads_page_load_newest (self);
		self->priv->initialized = TRUE;
	}
}


static void dm_threads_page_real_on_leave (IPage* base) {
	DMThreadsPage * self;
	StartConversationEntry* _tmp0_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DM_THREADS_PAGE, DMThreadsPage);
	_tmp0_ = self->priv->start_conversation_entry;
	start_conversation_entry_unreveal (_tmp0_);
}


static Block17Data* block17_data_ref (Block17Data* _data17_) {
	g_atomic_int_inc (&_data17_->_ref_count_);
	return _data17_;
}


static void block17_data_unref (void * _userdata_) {
	Block17Data* _data17_;
	_data17_ = (Block17Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data17_->_ref_count_)) {
		DMThreadsPage* self;
		self = _data17_->self;
		_g_object_unref0 (_data17_->entry);
		_g_object_unref0 (self);
		g_slice_free (Block17Data, _data17_);
	}
}


static gint64 int64_parse (const gchar* str) {
	gint64 result = 0LL;
	const gchar* _tmp0_ = NULL;
	gint64 _tmp1_ = 0LL;
	g_return_val_if_fail (str != NULL, 0LL);
	_tmp0_ = str;
	_tmp1_ = g_ascii_strtoll (_tmp0_, NULL, (guint) 0);
	result = _tmp1_;
	return result;
}


static void __lambda116_ (Block17Data* _data17_, GdkPixbuf* a) {
	DMThreadsPage* self;
	GdkPixbuf* _tmp0_ = NULL;
	self = _data17_->self;
	g_return_if_fail (GDK_IS_PIXBUF (a));
	_tmp0_ = a;
	dm_thread_entry_set_avatar (_data17_->entry, _tmp0_);
}


static void ___lambda116__twitter_avatar_downloaded_func (GdkPixbuf* avatar, gpointer self) {
	__lambda116_ (self, avatar);
}


static gboolean __lambda115_ (DMThreadsPage* self, gchar** vals, int vals_length1) {
	gboolean result = FALSE;
	Block17Data* _data17_;
	gint64 user_id = 0LL;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	const gchar* _tmp1_ = NULL;
	gint64 _tmp2_ = 0LL;
	DMThreadEntry* _tmp3_ = NULL;
	gchar** _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	const gchar* _tmp5_ = NULL;
	gchar** _tmp6_ = NULL;
	gint _tmp6__length1 = 0;
	const gchar* _tmp7_ = NULL;
	gchar** _tmp8_ = NULL;
	gint _tmp8__length1 = 0;
	const gchar* _tmp9_ = NULL;
	gchar** _tmp10_ = NULL;
	gint _tmp10__length1 = 0;
	const gchar* _tmp11_ = NULL;
	gint64 _tmp12_ = 0LL;
	Twitter* _tmp13_ = NULL;
	Twitter* _tmp14_ = NULL;
	gchar** _tmp15_ = NULL;
	gint _tmp15__length1 = 0;
	const gchar* _tmp16_ = NULL;
	GdkPixbuf* _tmp17_ = NULL;
	GdkPixbuf* _tmp18_ = NULL;
	GtkListBox* _tmp19_ = NULL;
	GeeHashMap* _tmp20_ = NULL;
	_data17_ = g_slice_new0 (Block17Data);
	_data17_->_ref_count_ = 1;
	_data17_->self = g_object_ref (self);
	_tmp0_ = vals;
	_tmp0__length1 = vals_length1;
	_tmp1_ = _tmp0_[0];
	_tmp2_ = int64_parse (_tmp1_);
	user_id = _tmp2_;
	_tmp3_ = dm_thread_entry_new (user_id);
	g_object_ref_sink (_tmp3_);
	_data17_->entry = _tmp3_;
	_tmp4_ = vals;
	_tmp4__length1 = vals_length1;
	_tmp5_ = _tmp4_[1];
	dm_thread_entry_set_screen_name (_data17_->entry, _tmp5_);
	_tmp6_ = vals;
	_tmp6__length1 = vals_length1;
	_tmp7_ = _tmp6_[5];
	dm_thread_entry_set_name (_data17_->entry, _tmp7_);
	_tmp8_ = vals;
	_tmp8__length1 = vals_length1;
	_tmp9_ = _tmp8_[2];
	dm_thread_entry_set_last_message (_data17_->entry, _tmp9_);
	_tmp10_ = vals;
	_tmp10__length1 = vals_length1;
	_tmp11_ = _tmp10_[3];
	_tmp12_ = int64_parse (_tmp11_);
	dm_thread_entry_set_last_message_id (_data17_->entry, _tmp12_);
	_data17_->entry->unread_count = 0;
	_tmp13_ = twitter_get ();
	_tmp14_ = _tmp13_;
	_tmp15_ = vals;
	_tmp15__length1 = vals_length1;
	_tmp16_ = _tmp15_[4];
	_tmp17_ = twitter_get_avatar (_tmp14_, _tmp16_, ___lambda116__twitter_avatar_downloaded_func, block17_data_ref (_data17_), block17_data_unref);
	_tmp18_ = _tmp17_;
	dm_thread_entry_set_avatar (_data17_->entry, _tmp18_);
	_g_object_unref0 (_tmp18_);
	_g_object_unref0 (_tmp14_);
	_tmp19_ = self->priv->thread_list;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_data17_->entry, gtk_widget_get_type (), GtkWidget));
	_tmp20_ = self->priv->thread_map;
	gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), &user_id, _data17_->entry);
	result = TRUE;
	block17_data_unref (_data17_);
	_data17_ = NULL;
	return result;
}


static gboolean ___lambda115__sql_select_callback (gchar** vals, int vals_length1, gpointer self) {
	gboolean result;
	result = __lambda115_ ((DMThreadsPage*) self, vals, vals_length1);
	return result;
}


void dm_threads_page_load_cached (DMThreadsPage* self) {
	Account* _tmp0_ = NULL;
	Account* _tmp1_ = NULL;
	SqlDatabase* _tmp2_ = NULL;
	SqlDatabase* _tmp3_ = NULL;
	SqlSelectStatement* _tmp4_ = NULL;
	SqlSelectStatement* _tmp5_ = NULL;
	SqlSelectStatement* _tmp6_ = NULL;
	SqlSelectStatement* _tmp7_ = NULL;
	Account* _tmp8_ = NULL;
	Account* _tmp9_ = NULL;
	gint64 _tmp10_ = 0LL;
	gint64 _tmp11_ = 0LL;
	SqlSelectStatement* _tmp12_ = NULL;
	SqlSelectStatement* _tmp13_ = NULL;
	SqlSelectStatement* _tmp14_ = NULL;
	SqlSelectStatement* _tmp15_ = NULL;
	SqlSelectStatement* _tmp16_ = NULL;
	SqlSelectStatement* _tmp17_ = NULL;
	gint64 _tmp18_ = 0LL;
	Account* _tmp19_ = NULL;
	Account* _tmp20_ = NULL;
	SqlDatabase* _tmp21_ = NULL;
	SqlDatabase* _tmp22_ = NULL;
	SqlSelectStatement* _tmp23_ = NULL;
	SqlSelectStatement* _tmp24_ = NULL;
	SqlSelectStatement* _tmp25_ = NULL;
	SqlSelectStatement* _tmp26_ = NULL;
	Account* _tmp27_ = NULL;
	Account* _tmp28_ = NULL;
	gint64 _tmp29_ = 0LL;
	gint64 _tmp30_ = 0LL;
	SqlSelectStatement* _tmp31_ = NULL;
	SqlSelectStatement* _tmp32_ = NULL;
	SqlSelectStatement* _tmp33_ = NULL;
	SqlSelectStatement* _tmp34_ = NULL;
	SqlSelectStatement* _tmp35_ = NULL;
	SqlSelectStatement* _tmp36_ = NULL;
	gint64 _tmp37_ = 0LL;
	gint n_rows = 0;
	Account* _tmp38_ = NULL;
	Account* _tmp39_ = NULL;
	SqlDatabase* _tmp40_ = NULL;
	SqlDatabase* _tmp41_ = NULL;
	SqlSelectStatement* _tmp42_ = NULL;
	SqlSelectStatement* _tmp43_ = NULL;
	SqlSelectStatement* _tmp44_ = NULL;
	SqlSelectStatement* _tmp45_ = NULL;
	SqlSelectStatement* _tmp46_ = NULL;
	SqlSelectStatement* _tmp47_ = NULL;
	gint _tmp48_ = 0;
	gint _tmp49_ = 0;
	gboolean _tmp50_ = FALSE;
	gint _tmp51_ = 0;
	g_return_if_fail (IS_DM_THREADS_PAGE (self));
	_tmp0_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp1_ = _tmp0_;
	_tmp2_ = account_get_db (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = sql_database_select (_tmp3_, "dms");
	_tmp5_ = _tmp4_;
	_tmp6_ = sql_select_statement_cols (_tmp5_, "id", NULL);
	_tmp7_ = _tmp6_;
	_tmp8_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp9_ = _tmp8_;
	_tmp10_ = account_get_id (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = sql_select_statement_where_eqi (_tmp7_, "to_id", _tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = sql_select_statement_order (_tmp13_, "id DESC");
	_tmp15_ = _tmp14_;
	_tmp16_ = sql_select_statement_limit (_tmp15_, 1);
	_tmp17_ = _tmp16_;
	_tmp18_ = sql_select_statement_once_i64 (_tmp17_);
	self->priv->max_received_id = _tmp18_;
	_sql_select_statement_unref0 (_tmp17_);
	_sql_select_statement_unref0 (_tmp15_);
	_sql_select_statement_unref0 (_tmp13_);
	_sql_select_statement_unref0 (_tmp7_);
	_sql_select_statement_unref0 (_tmp5_);
	_tmp19_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp20_ = _tmp19_;
	_tmp21_ = account_get_db (_tmp20_);
	_tmp22_ = _tmp21_;
	_tmp23_ = sql_database_select (_tmp22_, "dms");
	_tmp24_ = _tmp23_;
	_tmp25_ = sql_select_statement_cols (_tmp24_, "id", NULL);
	_tmp26_ = _tmp25_;
	_tmp27_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp28_ = _tmp27_;
	_tmp29_ = account_get_id (_tmp28_);
	_tmp30_ = _tmp29_;
	_tmp31_ = sql_select_statement_where_eqi (_tmp26_, "from_id", _tmp30_);
	_tmp32_ = _tmp31_;
	_tmp33_ = sql_select_statement_order (_tmp32_, "id DESC");
	_tmp34_ = _tmp33_;
	_tmp35_ = sql_select_statement_limit (_tmp34_, 1);
	_tmp36_ = _tmp35_;
	_tmp37_ = sql_select_statement_once_i64 (_tmp36_);
	self->priv->max_sent_id = _tmp37_;
	_sql_select_statement_unref0 (_tmp36_);
	_sql_select_statement_unref0 (_tmp34_);
	_sql_select_statement_unref0 (_tmp32_);
	_sql_select_statement_unref0 (_tmp26_);
	_sql_select_statement_unref0 (_tmp24_);
	_tmp38_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp39_ = _tmp38_;
	_tmp40_ = account_get_db (_tmp39_);
	_tmp41_ = _tmp40_;
	_tmp42_ = sql_database_select (_tmp41_, "dm_threads");
	_tmp43_ = _tmp42_;
	_tmp44_ = sql_select_statement_cols (_tmp43_, "user_id", "screen_name", "last_message", "last_message_id", "avatar_url", "name", NULL);
	_tmp45_ = _tmp44_;
	_tmp46_ = sql_select_statement_order (_tmp45_, "last_message_id");
	_tmp47_ = _tmp46_;
	_tmp48_ = sql_select_statement_run (_tmp47_, ___lambda115__sql_select_callback, self);
	_tmp49_ = _tmp48_;
	_sql_select_statement_unref0 (_tmp47_);
	_sql_select_statement_unref0 (_tmp45_);
	_sql_select_statement_unref0 (_tmp43_);
	n_rows = _tmp49_;
	_tmp51_ = n_rows;
	if (_tmp51_ == 0) {
		GNetworkMonitor* _tmp52_ = NULL;
		gboolean _tmp53_ = FALSE;
		_tmp52_ = g_network_monitor_get_default ();
		_tmp53_ = g_network_monitor_get_network_available (_tmp52_);
		_tmp50_ = _tmp53_;
	} else {
		_tmp50_ = FALSE;
	}
	if (_tmp50_) {
		GtkListBoxRow* row = NULL;
		GtkListBoxRow* _tmp54_ = NULL;
		GtkSpinner* _tmp55_ = NULL;
		GtkSpinner* _tmp56_ = NULL;
		GtkSpinner* _tmp57_ = NULL;
		GtkSpinner* _tmp58_ = NULL;
		GtkListBoxRow* _tmp59_ = NULL;
		GtkSpinner* _tmp60_ = NULL;
		GtkListBoxRow* _tmp61_ = NULL;
		GtkListBox* _tmp62_ = NULL;
		GtkListBoxRow* _tmp63_ = NULL;
		_tmp54_ = (GtkListBoxRow*) gtk_list_box_row_new ();
		g_object_ref_sink (_tmp54_);
		row = _tmp54_;
		_tmp55_ = (GtkSpinner*) gtk_spinner_new ();
		g_object_ref_sink (_tmp55_);
		_g_object_unref0 (self->priv->progress_spinner);
		self->priv->progress_spinner = _tmp55_;
		_tmp56_ = self->priv->progress_spinner;
		gtk_widget_set_size_request (G_TYPE_CHECK_INSTANCE_CAST (_tmp56_, gtk_widget_get_type (), GtkWidget), 16, 16);
		_tmp57_ = self->priv->progress_spinner;
		g_object_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp57_, gtk_widget_get_type (), GtkWidget), "margin", 12, NULL);
		_tmp58_ = self->priv->progress_spinner;
		gtk_spinner_start (_tmp58_);
		_tmp59_ = row;
		_tmp60_ = self->priv->progress_spinner;
		gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp59_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp60_, gtk_widget_get_type (), GtkWidget));
		_tmp61_ = row;
		gtk_list_box_row_set_activatable (_tmp61_, FALSE);
		_tmp62_ = self->priv->thread_list;
		_tmp63_ = row;
		gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp62_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp63_, gtk_widget_get_type (), GtkWidget));
		_g_object_unref0 (row);
	}
}


static void __lambda128_ (DMThreadsPage* self) {
	dm_threads_page_remove_spinner (self);
	dm_threads_page_save_last_messages (self);
}


static void ___lambda128__collect_finished (Collect* _sender, GError* _error_, gpointer self) {
	__lambda128_ ((DMThreadsPage*) self);
}


static void _vala_JsonNode_free (JsonNode* self) {
	g_boxed_free (json_node_get_type (), self);
}


static void __lambda129_ (DMThreadsPage* self, GObject* obj, GAsyncResult* res) {
	JsonNode* root = NULL;
	GAsyncResult* _tmp0_ = NULL;
	JsonNode* _tmp1_ = NULL;
	g_return_if_fail ((obj == NULL) || G_IS_OBJECT (obj));
	g_return_if_fail (G_IS_ASYNC_RESULT (res));
	_tmp0_ = res;
	_tmp1_ = tweet_utils_load_threaded_finish (_tmp0_);
	root = _tmp1_;
	dm_threads_page_on_dm_result (self, root);
	__vala_JsonNode_free0 (root);
}


static void ___lambda129__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda129_ ((DMThreadsPage*) self, source_object, res);
	g_object_unref (self);
}


static void __lambda131_ (DMThreadsPage* self, GObject* obj, GAsyncResult* res) {
	JsonNode* root = NULL;
	GAsyncResult* _tmp0_ = NULL;
	JsonNode* _tmp1_ = NULL;
	g_return_if_fail ((obj == NULL) || G_IS_OBJECT (obj));
	g_return_if_fail (G_IS_ASYNC_RESULT (res));
	_tmp0_ = res;
	_tmp1_ = tweet_utils_load_threaded_finish (_tmp0_);
	root = _tmp1_;
	dm_threads_page_on_dm_result (self, root);
	__vala_JsonNode_free0 (root);
}


static void ___lambda131__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda131_ ((DMThreadsPage*) self, source_object, res);
	g_object_unref (self);
}


void dm_threads_page_load_newest (DMThreadsPage* self) {
	Collect* _tmp0_ = NULL;
	RestProxyCall* call = NULL;
	Account* _tmp1_ = NULL;
	Account* _tmp2_ = NULL;
	OAuthProxy* _tmp3_ = NULL;
	OAuthProxy* _tmp4_ = NULL;
	RestProxyCall* _tmp5_ = NULL;
	gint64 _tmp6_ = 0LL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	RestProxyCall* sent_call = NULL;
	Account* _tmp9_ = NULL;
	Account* _tmp10_ = NULL;
	OAuthProxy* _tmp11_ = NULL;
	OAuthProxy* _tmp12_ = NULL;
	RestProxyCall* _tmp13_ = NULL;
	gint64 _tmp14_ = 0LL;
	gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	g_return_if_fail (IS_DM_THREADS_PAGE (self));
	_tmp0_ = self->priv->dm_download_collect;
	g_signal_connect_object (_tmp0_, "finished", (GCallback) ___lambda128__collect_finished, self, 0);
	_tmp1_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp2_ = _tmp1_;
	_tmp3_ = account_get_proxy (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, rest_proxy_get_type (), RestProxy));
	call = _tmp5_;
	rest_proxy_call_set_function (call, "1.1/direct_messages.json");
	rest_proxy_call_set_method (call, "GET");
	rest_proxy_call_add_param (call, "skip_status", "true");
	_tmp6_ = self->priv->max_received_id;
	_tmp7_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp6_);
	_tmp8_ = _tmp7_;
	rest_proxy_call_add_param (call, "since_id", _tmp8_);
	_g_free0 (_tmp8_);
	rest_proxy_call_add_param (call, "count", "200");
	tweet_utils_load_threaded (call, ___lambda129__gasync_ready_callback, g_object_ref (self));
	_tmp9_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp10_ = _tmp9_;
	_tmp11_ = account_get_proxy (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, rest_proxy_get_type (), RestProxy));
	sent_call = _tmp13_;
	rest_proxy_call_set_function (sent_call, "1.1/direct_messages/sent.json");
	rest_proxy_call_add_param (sent_call, "skip_status", "true");
	_tmp14_ = self->priv->max_sent_id;
	_tmp15_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp14_);
	_tmp16_ = _tmp15_;
	rest_proxy_call_add_param (sent_call, "since_id", _tmp16_);
	_g_free0 (_tmp16_);
	rest_proxy_call_add_param (sent_call, "count", "200");
	rest_proxy_call_set_method (sent_call, "GET");
	tweet_utils_load_threaded (sent_call, ___lambda131__gasync_ready_callback, g_object_ref (self));
	_g_object_unref0 (sent_call);
	_g_object_unref0 (call);
}


static gpointer _json_array_ref0 (gpointer self) {
	return self ? json_array_ref (self) : NULL;
}


static void ___lambda130_ (DMThreadsPage* self, JsonArray* arr, guint pos, JsonNode* node) {
	JsonObject* dm_obj = NULL;
	JsonNode* _tmp0_ = NULL;
	JsonObject* _tmp1_ = NULL;
	JsonObject* _tmp2_ = NULL;
	JsonObject* _tmp3_ = NULL;
	gint64 _tmp4_ = 0LL;
	Account* _tmp5_ = NULL;
	Account* _tmp6_ = NULL;
	gint64 _tmp7_ = 0LL;
	gint64 _tmp8_ = 0LL;
	g_return_if_fail (arr != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = node;
	_tmp1_ = json_node_get_object (_tmp0_);
	_tmp2_ = _json_object_ref0 (_tmp1_);
	dm_obj = _tmp2_;
	_tmp3_ = dm_obj;
	_tmp4_ = json_object_get_int_member (_tmp3_, "sender_id");
	_tmp5_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp6_ = _tmp5_;
	_tmp7_ = account_get_id (_tmp6_);
	_tmp8_ = _tmp7_;
	if (_tmp4_ == _tmp8_) {
		JsonObject* _tmp9_ = NULL;
		_tmp9_ = dm_obj;
		dm_threads_page_save_message (self, _tmp9_);
	} else {
		JsonObject* _tmp10_ = NULL;
		_tmp10_ = dm_obj;
		dm_threads_page_add_new_thread (self, _tmp10_);
	}
	_json_object_unref0 (dm_obj);
}


static void ____lambda130__json_array_foreach (JsonArray* array, guint index_, JsonNode* element_node, gpointer self) {
	___lambda130_ ((DMThreadsPage*) self, array, index_, element_node);
}


static void dm_threads_page_on_dm_result (DMThreadsPage* self, JsonNode* root) {
	Collect* _tmp0_ = NULL;
	JsonNode* _tmp1_ = NULL;
	JsonArray* root_arr = NULL;
	JsonNode* _tmp2_ = NULL;
	JsonArray* _tmp3_ = NULL;
	JsonArray* _tmp4_ = NULL;
	JsonArray* _tmp5_ = NULL;
	guint _tmp6_ = 0U;
	JsonArray* _tmp7_ = NULL;
	guint _tmp8_ = 0U;
	g_return_if_fail (IS_DM_THREADS_PAGE (self));
	_tmp0_ = self->priv->dm_download_collect;
	collect_emit (_tmp0_, NULL);
	_tmp1_ = root;
	if (_tmp1_ == NULL) {
		return;
	}
	_tmp2_ = root;
	_tmp3_ = json_node_get_array (_tmp2_);
	_tmp4_ = _json_array_ref0 (_tmp3_);
	root_arr = _tmp4_;
	_tmp5_ = root_arr;
	_tmp6_ = json_array_get_length (_tmp5_);
	g_debug ("DMThreadsPage.vala:189: sent: %u", _tmp6_);
	_tmp7_ = root_arr;
	_tmp8_ = json_array_get_length (_tmp7_);
	if (_tmp8_ > ((guint) 0)) {
		Account* _tmp9_ = NULL;
		Account* _tmp10_ = NULL;
		SqlDatabase* _tmp11_ = NULL;
		SqlDatabase* _tmp12_ = NULL;
		JsonArray* _tmp13_ = NULL;
		Account* _tmp14_ = NULL;
		Account* _tmp15_ = NULL;
		SqlDatabase* _tmp16_ = NULL;
		SqlDatabase* _tmp17_ = NULL;
		_tmp9_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
		_tmp10_ = _tmp9_;
		_tmp11_ = account_get_db (_tmp10_);
		_tmp12_ = _tmp11_;
		sql_database_begin_transaction (_tmp12_);
		_tmp13_ = root_arr;
		json_array_foreach_element (_tmp13_, ____lambda130__json_array_foreach, self);
		_tmp14_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
		_tmp15_ = _tmp14_;
		_tmp16_ = account_get_db (_tmp15_);
		_tmp17_ = _tmp16_;
		sql_database_end_transaction (_tmp17_);
	}
	_json_array_unref0 (root_arr);
}


static Block18Data* block18_data_ref (Block18Data* _data18_) {
	g_atomic_int_inc (&_data18_->_ref_count_);
	return _data18_;
}


static void _tweet_utils_sequence_free0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (tweet_utils_sequence_free (var), NULL));
}


static void _g_slist_free__tweet_utils_sequence_free0_ (GSList* self) {
	g_slist_foreach (self, (GFunc) _tweet_utils_sequence_free0_, NULL);
	g_slist_free (self);
}


static void block18_data_unref (void * _userdata_) {
	Block18Data* _data18_;
	_data18_ = (Block18Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data18_->_ref_count_)) {
		DMThreadsPage* self;
		self = _data18_->self;
		_g_object_unref0 (_data18_->thread_entry);
		__g_slist_free__tweet_utils_sequence_free0_0 (_data18_->url_list);
		_g_object_unref0 (self);
		g_slice_free (Block18Data, _data18_);
	}
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	{
		GRegex* regex = NULL;
		const gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		GRegex* _tmp3_ = NULL;
		GRegex* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		GRegex* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		_tmp0_ = old;
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		regex = _tmp4_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch12_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp6_ = regex;
		_tmp7_ = replacement;
		_tmp8_ = g_regex_replace_literal (_tmp6_, self, (gssize) (-1), 0, _tmp7_, 0, &_inner_error_);
		_tmp5_ = _tmp8_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch12_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp9_ = _tmp5_;
		_tmp5_ = NULL;
		result = _tmp9_;
		_g_free0 (_tmp5_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally12;
	__catch12_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally12:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static gpointer _tweet_utils_sequence_dup0 (gpointer self) {
	return self ? tweet_utils_sequence_dup (self) : NULL;
}


static void __lambda126_ (Block18Data* _data18_, JsonArray* arr, guint index, JsonNode* node) {
	DMThreadsPage* self;
	JsonObject* url = NULL;
	JsonNode* _tmp0_ = NULL;
	JsonObject* _tmp1_ = NULL;
	JsonObject* _tmp2_ = NULL;
	gchar* expanded_url = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	JsonArray* indices = NULL;
	JsonArray* _tmp5_ = NULL;
	JsonArray* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gint64 _tmp9_ = 0LL;
	gint64 _tmp10_ = 0LL;
	const gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	TweetUtilsSequence _tmp13_ = {0};
	TweetUtilsSequence _tmp14_ = {0};
	TweetUtilsSequence* _tmp15_ = NULL;
	self = _data18_->self;
	g_return_if_fail (arr != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = node;
	_tmp1_ = json_node_get_object (_tmp0_);
	_tmp2_ = _json_object_ref0 (_tmp1_);
	url = _tmp2_;
	_tmp3_ = json_object_get_string_member (url, "expanded_url");
	_tmp4_ = g_strdup (_tmp3_);
	expanded_url = _tmp4_;
	_tmp5_ = json_object_get_array_member (url, "indices");
	_tmp6_ = _json_array_ref0 (_tmp5_);
	indices = _tmp6_;
	_tmp7_ = expanded_url;
	_tmp8_ = string_replace (_tmp7_, "&", "&amp;");
	_g_free0 (expanded_url);
	expanded_url = _tmp8_;
	_tmp9_ = json_array_get_int_element (indices, (guint) 0);
	_tmp10_ = json_array_get_int_element (indices, (guint) 1);
	_tmp11_ = json_object_get_string_member (url, "display_url");
	_tmp12_ = g_strdup (_tmp11_);
	memset (&_tmp13_, 0, sizeof (TweetUtilsSequence));
	_tmp13_.start = (gint) _tmp9_;
	_tmp13_.end = (gint) _tmp10_;
	_g_free0 (_tmp13_.url);
	_tmp13_.url = _tmp12_;
	_tmp13_.visual_display_url = FALSE;
	_tmp14_ = _tmp13_;
	_tmp15_ = _tweet_utils_sequence_dup0 (&_tmp14_);
	_data18_->url_list = g_slist_prepend (_data18_->url_list, _tmp15_);
	tweet_utils_sequence_destroy (&_tmp14_);
	_json_array_unref0 (indices);
	_g_free0 (expanded_url);
	_json_object_unref0 (url);
}


static void ___lambda126__json_array_foreach (JsonArray* array, guint index_, JsonNode* element_node, gpointer self) {
	__lambda126_ (self, array, index_, element_node);
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}


static void __lambda127_ (Block18Data* _data18_, GdkPixbuf* a) {
	DMThreadsPage* self;
	DMThreadEntry* _tmp0_ = NULL;
	GdkPixbuf* _tmp1_ = NULL;
	self = _data18_->self;
	g_return_if_fail (GDK_IS_PIXBUF (a));
	_tmp0_ = _data18_->thread_entry;
	_tmp1_ = a;
	dm_thread_entry_set_avatar (_tmp0_, _tmp1_);
}


static void ___lambda127__twitter_avatar_downloaded_func (GdkPixbuf* avatar, gpointer self) {
	__lambda127_ (self, avatar);
}


static void dm_threads_page_add_new_thread (DMThreadsPage* self, JsonObject* dm_obj) {
	Block18Data* _data18_;
	gint64 sender_id = 0LL;
	JsonObject* _tmp0_ = NULL;
	gint64 _tmp1_ = 0LL;
	gint64 message_id = 0LL;
	JsonObject* _tmp2_ = NULL;
	gint64 _tmp3_ = 0LL;
	JsonObject* _tmp4_ = NULL;
	gint64 _tmp5_ = 0LL;
	Account* _tmp6_ = NULL;
	Account* _tmp7_ = NULL;
	gint64 _tmp8_ = 0LL;
	gint64 _tmp9_ = 0LL;
	gchar* text = NULL;
	JsonObject* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	GeeHashMap* _tmp13_ = NULL;
	gint64 _tmp14_ = 0LL;
	gboolean _tmp15_ = FALSE;
	JsonArray* urls = NULL;
	JsonObject* _tmp57_ = NULL;
	JsonObject* _tmp58_ = NULL;
	JsonArray* _tmp59_ = NULL;
	JsonArray* _tmp60_ = NULL;
	JsonArray* _tmp61_ = NULL;
	gint64 _tmp62_ = 0LL;
	DMThreadEntry* _tmp63_ = NULL;
	gchar* author = NULL;
	JsonObject* _tmp64_ = NULL;
	const gchar* _tmp65_ = NULL;
	gchar* _tmp66_ = NULL;
	gchar* sender_name = NULL;
	JsonObject* _tmp67_ = NULL;
	JsonObject* _tmp68_ = NULL;
	const gchar* _tmp69_ = NULL;
	gchar* _tmp70_ = NULL;
	DMThreadEntry* _tmp71_ = NULL;
	const gchar* _tmp72_ = NULL;
	DMThreadEntry* _tmp73_ = NULL;
	const gchar* _tmp74_ = NULL;
	DMThreadEntry* _tmp75_ = NULL;
	const gchar* _tmp76_ = NULL;
	GSList* _tmp77_ = NULL;
	gchar* _tmp78_ = NULL;
	gchar* _tmp79_ = NULL;
	DMThreadEntry* _tmp80_ = NULL;
	gint64 _tmp81_ = 0LL;
	GtkListBox* _tmp82_ = NULL;
	DMThreadEntry* _tmp83_ = NULL;
	GtkListBox* _tmp84_ = NULL;
	GeeHashMap* _tmp85_ = NULL;
	gint64 _tmp86_ = 0LL;
	DMThreadEntry* _tmp87_ = NULL;
	gchar* avatar_url = NULL;
	JsonObject* _tmp88_ = NULL;
	JsonObject* _tmp89_ = NULL;
	const gchar* _tmp90_ = NULL;
	gchar* _tmp91_ = NULL;
	Account* _tmp92_ = NULL;
	Account* _tmp93_ = NULL;
	SqlDatabase* _tmp94_ = NULL;
	SqlDatabase* _tmp95_ = NULL;
	SqlInsertStatement* _tmp96_ = NULL;
	SqlInsertStatement* _tmp97_ = NULL;
	gint64 _tmp98_ = 0LL;
	SqlInsertStatement* _tmp99_ = NULL;
	SqlInsertStatement* _tmp100_ = NULL;
	const gchar* _tmp101_ = NULL;
	SqlInsertStatement* _tmp102_ = NULL;
	SqlInsertStatement* _tmp103_ = NULL;
	const gchar* _tmp104_ = NULL;
	SqlInsertStatement* _tmp105_ = NULL;
	SqlInsertStatement* _tmp106_ = NULL;
	DMThreadEntry* _tmp107_ = NULL;
	const gchar* _tmp108_ = NULL;
	const gchar* _tmp109_ = NULL;
	SqlInsertStatement* _tmp110_ = NULL;
	SqlInsertStatement* _tmp111_ = NULL;
	gint64 _tmp112_ = 0LL;
	SqlInsertStatement* _tmp113_ = NULL;
	SqlInsertStatement* _tmp114_ = NULL;
	const gchar* _tmp115_ = NULL;
	SqlInsertStatement* _tmp116_ = NULL;
	SqlInsertStatement* _tmp117_ = NULL;
	Account* _tmp118_ = NULL;
	Account* _tmp119_ = NULL;
	UserCounter* _tmp120_ = NULL;
	UserCounter* _tmp121_ = NULL;
	gint64 _tmp122_ = 0LL;
	const gchar* _tmp123_ = NULL;
	const gchar* _tmp124_ = NULL;
	DMThreadEntry* _tmp125_ = NULL;
	Twitter* _tmp126_ = NULL;
	Twitter* _tmp127_ = NULL;
	const gchar* _tmp128_ = NULL;
	GdkPixbuf* _tmp129_ = NULL;
	GdkPixbuf* _tmp130_ = NULL;
	g_return_if_fail (IS_DM_THREADS_PAGE (self));
	g_return_if_fail (dm_obj != NULL);
	_data18_ = g_slice_new0 (Block18Data);
	_data18_->_ref_count_ = 1;
	_data18_->self = g_object_ref (self);
	_tmp0_ = dm_obj;
	_tmp1_ = json_object_get_int_member (_tmp0_, "sender_id");
	sender_id = _tmp1_;
	_tmp2_ = dm_obj;
	_tmp3_ = json_object_get_int_member (_tmp2_, "id");
	message_id = _tmp3_;
	_tmp4_ = dm_obj;
	dm_threads_page_save_message (self, _tmp4_);
	_tmp5_ = sender_id;
	_tmp6_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp7_ = _tmp6_;
	_tmp8_ = account_get_id (_tmp7_);
	_tmp9_ = _tmp8_;
	if (_tmp5_ == _tmp9_) {
		block18_data_unref (_data18_);
		_data18_ = NULL;
		return;
	}
	_tmp10_ = dm_obj;
	_tmp11_ = json_object_get_string_member (_tmp10_, "text");
	_tmp12_ = g_strdup (_tmp11_);
	text = _tmp12_;
	_tmp13_ = self->priv->thread_map;
	_tmp14_ = sender_id;
	_tmp15_ = gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), &_tmp14_);
	if (_tmp15_) {
		DMThreadEntry* t_e = NULL;
		GeeHashMap* _tmp16_ = NULL;
		gint64 _tmp17_ = 0LL;
		gpointer _tmp18_ = NULL;
		DMThreadEntry* _tmp19_ = NULL;
		DMThreadEntry* _tmp20_ = NULL;
		gint64 _tmp21_ = 0LL;
		gint64 _tmp22_ = 0LL;
		gint64 _tmp23_ = 0LL;
		DMThreadEntry* _tmp24_ = NULL;
		gint64 _tmp25_ = 0LL;
		gint64 _tmp26_ = 0LL;
		gboolean _tmp27_ = FALSE;
		DMThreadEntry* _tmp31_ = NULL;
		const gchar* _tmp32_ = NULL;
		DMThreadEntry* _tmp33_ = NULL;
		gint64 _tmp34_ = 0LL;
		Account* _tmp35_ = NULL;
		Account* _tmp36_ = NULL;
		SqlDatabase* _tmp37_ = NULL;
		SqlDatabase* _tmp38_ = NULL;
		SqlUpdateStatement* _tmp39_ = NULL;
		SqlUpdateStatement* _tmp40_ = NULL;
		const gchar* _tmp41_ = NULL;
		SqlUpdateStatement* _tmp42_ = NULL;
		SqlUpdateStatement* _tmp43_ = NULL;
		gint64 _tmp44_ = 0LL;
		SqlUpdateStatement* _tmp45_ = NULL;
		SqlUpdateStatement* _tmp46_ = NULL;
		gint64 _tmp47_ = 0LL;
		SqlUpdateStatement* _tmp48_ = NULL;
		SqlUpdateStatement* _tmp49_ = NULL;
		DMThreadEntry* _tmp50_ = NULL;
		DMThreadEntry* _tmp51_ = NULL;
		const gchar* _tmp52_ = NULL;
		gchar* _tmp53_ = NULL;
		gchar* _tmp54_ = NULL;
		gchar* _tmp55_ = NULL;
		GtkListBox* _tmp56_ = NULL;
		_tmp16_ = self->priv->thread_map;
		_tmp17_ = sender_id;
		_tmp18_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), &_tmp17_);
		_tmp19_ = _g_object_ref0 ((DMThreadEntry*) _tmp18_);
		t_e = _tmp19_;
		_tmp20_ = t_e;
		_tmp21_ = dm_thread_entry_get_last_message_id (_tmp20_);
		_tmp22_ = _tmp21_;
		_tmp23_ = message_id;
		if (_tmp22_ > _tmp23_) {
			_g_object_unref0 (t_e);
			_g_free0 (text);
			block18_data_unref (_data18_);
			_data18_ = NULL;
			return;
		}
		_tmp24_ = t_e;
		_tmp25_ = dm_thread_entry_get_user_id (_tmp24_);
		_tmp26_ = _tmp25_;
		_tmp27_ = dm_threads_page_user_id_visible (self, _tmp26_);
		if (!_tmp27_) {
			DMThreadEntry* _tmp28_ = NULL;
			gint _tmp29_ = 0;
			DMThreadEntry* _tmp30_ = NULL;
			_tmp28_ = t_e;
			_tmp29_ = _tmp28_->unread_count;
			_tmp28_->unread_count = _tmp29_ + 1;
			_tmp30_ = t_e;
			dm_thread_entry_update_unread_count (_tmp30_);
		}
		_tmp31_ = t_e;
		_tmp32_ = text;
		dm_thread_entry_set_last_message (_tmp31_, _tmp32_);
		_tmp33_ = t_e;
		_tmp34_ = message_id;
		dm_thread_entry_set_last_message_id (_tmp33_, _tmp34_);
		_tmp35_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
		_tmp36_ = _tmp35_;
		_tmp37_ = account_get_db (_tmp36_);
		_tmp38_ = _tmp37_;
		_tmp39_ = sql_database_update (_tmp38_, "dm_threads");
		_tmp40_ = _tmp39_;
		_tmp41_ = text;
		_tmp42_ = sql_update_statement_val (_tmp40_, "last_message", _tmp41_);
		_tmp43_ = _tmp42_;
		_tmp44_ = message_id;
		_tmp45_ = sql_update_statement_vali64 (_tmp43_, "last_message_id", _tmp44_);
		_tmp46_ = _tmp45_;
		_tmp47_ = sender_id;
		_tmp48_ = sql_update_statement_where_eqi (_tmp46_, "user_id", _tmp47_);
		_tmp49_ = _tmp48_;
		sql_update_statement_run (_tmp49_);
		_sql_update_statement_unref0 (_tmp49_);
		_sql_update_statement_unref0 (_tmp46_);
		_sql_update_statement_unref0 (_tmp43_);
		_sql_update_statement_unref0 (_tmp40_);
		_tmp50_ = t_e;
		_tmp51_ = t_e;
		_tmp52_ = text;
		_tmp53_ = utils_unescape_html (_tmp52_);
		_tmp54_ = _tmp53_;
		_tmp55_ = dm_threads_page_notify_new_dm (self, _tmp51_, _tmp54_);
		_g_free0 (_tmp50_->notification_id);
		_tmp50_->notification_id = _tmp55_;
		_g_free0 (_tmp54_);
		_tmp56_ = self->priv->thread_list;
		gtk_list_box_invalidate_sort (_tmp56_);
		_g_object_unref0 (t_e);
		_g_free0 (text);
		block18_data_unref (_data18_);
		_data18_ = NULL;
		return;
	}
	_tmp57_ = dm_obj;
	_tmp58_ = json_object_get_object_member (_tmp57_, "entities");
	_tmp59_ = json_object_get_array_member (_tmp58_, "urls");
	_tmp60_ = _json_array_ref0 (_tmp59_);
	urls = _tmp60_;
	_data18_->url_list = NULL;
	_tmp61_ = urls;
	json_array_foreach_element (_tmp61_, ___lambda126__json_array_foreach, _data18_);
	_tmp62_ = sender_id;
	_tmp63_ = dm_thread_entry_new (_tmp62_);
	g_object_ref_sink (_tmp63_);
	_data18_->thread_entry = _tmp63_;
	_tmp64_ = dm_obj;
	_tmp65_ = json_object_get_string_member (_tmp64_, "sender_screen_name");
	_tmp66_ = g_strdup (_tmp65_);
	author = _tmp66_;
	_tmp67_ = dm_obj;
	_tmp68_ = json_object_get_object_member (_tmp67_, "sender");
	_tmp69_ = json_object_get_string_member (_tmp68_, "name");
	_tmp70_ = string_strip (_tmp69_);
	sender_name = _tmp70_;
	_tmp71_ = _data18_->thread_entry;
	_tmp72_ = sender_name;
	dm_thread_entry_set_name (_tmp71_, _tmp72_);
	_tmp73_ = _data18_->thread_entry;
	_tmp74_ = author;
	dm_thread_entry_set_screen_name (_tmp73_, _tmp74_);
	_tmp75_ = _data18_->thread_entry;
	_tmp76_ = text;
	_tmp77_ = _data18_->url_list;
	_tmp78_ = tweet_utils_get_real_text (_tmp76_, _tmp77_);
	_tmp79_ = _tmp78_;
	dm_thread_entry_set_last_message (_tmp75_, _tmp79_);
	_g_free0 (_tmp79_);
	_tmp80_ = _data18_->thread_entry;
	_tmp81_ = message_id;
	dm_thread_entry_set_last_message_id (_tmp80_, _tmp81_);
	_tmp82_ = self->priv->thread_list;
	_tmp83_ = _data18_->thread_entry;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp82_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp83_, gtk_widget_get_type (), GtkWidget));
	_tmp84_ = self->priv->thread_list;
	gtk_list_box_invalidate_sort (_tmp84_);
	_tmp85_ = self->priv->thread_map;
	_tmp86_ = sender_id;
	_tmp87_ = _data18_->thread_entry;
	gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp85_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), &_tmp86_, _tmp87_);
	_tmp88_ = dm_obj;
	_tmp89_ = json_object_get_object_member (_tmp88_, "sender");
	_tmp90_ = json_object_get_string_member (_tmp89_, "profile_image_url");
	_tmp91_ = g_strdup (_tmp90_);
	avatar_url = _tmp91_;
	_tmp92_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp93_ = _tmp92_;
	_tmp94_ = account_get_db (_tmp93_);
	_tmp95_ = _tmp94_;
	_tmp96_ = sql_database_insert (_tmp95_, "dm_threads");
	_tmp97_ = _tmp96_;
	_tmp98_ = sender_id;
	_tmp99_ = sql_insert_statement_vali64 (_tmp97_, "user_id", _tmp98_);
	_tmp100_ = _tmp99_;
	_tmp101_ = sender_name;
	_tmp102_ = sql_insert_statement_val (_tmp100_, "name", _tmp101_);
	_tmp103_ = _tmp102_;
	_tmp104_ = author;
	_tmp105_ = sql_insert_statement_val (_tmp103_, "screen_name", _tmp104_);
	_tmp106_ = _tmp105_;
	_tmp107_ = _data18_->thread_entry;
	_tmp108_ = dm_thread_entry_get_last_message (_tmp107_);
	_tmp109_ = _tmp108_;
	_tmp110_ = sql_insert_statement_val (_tmp106_, "last_message", _tmp109_);
	_tmp111_ = _tmp110_;
	_tmp112_ = message_id;
	_tmp113_ = sql_insert_statement_vali64 (_tmp111_, "last_message_id", _tmp112_);
	_tmp114_ = _tmp113_;
	_tmp115_ = avatar_url;
	_tmp116_ = sql_insert_statement_val (_tmp114_, "avatar_url", _tmp115_);
	_tmp117_ = _tmp116_;
	sql_insert_statement_run (_tmp117_);
	_sql_insert_statement_unref0 (_tmp117_);
	_sql_insert_statement_unref0 (_tmp114_);
	_sql_insert_statement_unref0 (_tmp111_);
	_sql_insert_statement_unref0 (_tmp106_);
	_sql_insert_statement_unref0 (_tmp103_);
	_sql_insert_statement_unref0 (_tmp100_);
	_sql_insert_statement_unref0 (_tmp97_);
	_tmp118_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp119_ = _tmp118_;
	_tmp120_ = account_get_user_counter (_tmp119_);
	_tmp121_ = _tmp120_;
	_tmp122_ = sender_id;
	_tmp123_ = author;
	_tmp124_ = sender_name;
	user_counter_user_seen (_tmp121_, _tmp122_, _tmp123_, _tmp124_);
	_tmp125_ = _data18_->thread_entry;
	_tmp126_ = twitter_get ();
	_tmp127_ = _tmp126_;
	_tmp128_ = avatar_url;
	_tmp129_ = twitter_get_avatar (_tmp127_, _tmp128_, ___lambda127__twitter_avatar_downloaded_func, block18_data_ref (_data18_), block18_data_unref);
	_tmp130_ = _tmp129_;
	dm_thread_entry_set_avatar (_tmp125_, _tmp130_);
	_g_object_unref0 (_tmp130_);
	_g_object_unref0 (_tmp127_);
	_g_free0 (avatar_url);
	_g_free0 (sender_name);
	_g_free0 (author);
	_json_array_unref0 (urls);
	_g_free0 (text);
	block18_data_unref (_data18_);
	_data18_ = NULL;
}


static Block19Data* block19_data_ref (Block19Data* _data19_) {
	g_atomic_int_inc (&_data19_->_ref_count_);
	return _data19_;
}


static void block19_data_unref (void * _userdata_) {
	Block19Data* _data19_;
	_data19_ = (Block19Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data19_->_ref_count_)) {
		DMThreadsPage* self;
		self = _data19_->self;
		__g_slist_free__tweet_utils_sequence_free0_0 (_data19_->url_list);
		_g_object_unref0 (self);
		g_slice_free (Block19Data, _data19_);
	}
}


static void ___lambda117_ (Block19Data* _data19_, JsonArray* arr, guint index, JsonNode* node) {
	DMThreadsPage* self;
	JsonObject* url = NULL;
	JsonNode* _tmp0_ = NULL;
	JsonObject* _tmp1_ = NULL;
	JsonObject* _tmp2_ = NULL;
	gchar* expanded_url = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	JsonArray* indices = NULL;
	JsonArray* _tmp5_ = NULL;
	JsonArray* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gint64 _tmp9_ = 0LL;
	gint64 _tmp10_ = 0LL;
	const gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	TweetUtilsSequence _tmp15_ = {0};
	TweetUtilsSequence _tmp16_ = {0};
	TweetUtilsSequence* _tmp17_ = NULL;
	self = _data19_->self;
	g_return_if_fail (arr != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = node;
	_tmp1_ = json_node_get_object (_tmp0_);
	_tmp2_ = _json_object_ref0 (_tmp1_);
	url = _tmp2_;
	_tmp3_ = json_object_get_string_member (url, "expanded_url");
	_tmp4_ = g_strdup (_tmp3_);
	expanded_url = _tmp4_;
	_tmp5_ = json_object_get_array_member (url, "indices");
	_tmp6_ = _json_array_ref0 (_tmp5_);
	indices = _tmp6_;
	_tmp7_ = expanded_url;
	_tmp8_ = string_replace (_tmp7_, "&", "&amp;");
	_g_free0 (expanded_url);
	expanded_url = _tmp8_;
	_tmp9_ = json_array_get_int_element (indices, (guint) 0);
	_tmp10_ = json_array_get_int_element (indices, (guint) 1);
	_tmp11_ = expanded_url;
	_tmp12_ = g_strdup (_tmp11_);
	_tmp13_ = json_object_get_string_member (url, "display_url");
	_tmp14_ = g_strdup (_tmp13_);
	memset (&_tmp15_, 0, sizeof (TweetUtilsSequence));
	_tmp15_.start = (gint) _tmp9_;
	_tmp15_.end = (gint) _tmp10_;
	_g_free0 (_tmp15_.url);
	_tmp15_.url = _tmp12_;
	_g_free0 (_tmp15_.display_url);
	_tmp15_.display_url = _tmp14_;
	_tmp15_.visual_display_url = FALSE;
	_tmp16_ = _tmp15_;
	_tmp17_ = _tweet_utils_sequence_dup0 (&_tmp16_);
	_data19_->url_list = g_slist_prepend (_data19_->url_list, _tmp17_);
	tweet_utils_sequence_destroy (&_tmp16_);
	_json_array_unref0 (indices);
	_g_free0 (expanded_url);
	_json_object_unref0 (url);
}


static void ____lambda117__json_array_foreach (JsonArray* array, guint index_, JsonNode* element_node, gpointer self) {
	___lambda117_ (self, array, index_, element_node);
}


static void dm_threads_page_save_message (DMThreadsPage* self, JsonObject* dm_obj) {
	JsonObject* sender = NULL;
	JsonObject* _tmp0_ = NULL;
	JsonObject* _tmp1_ = NULL;
	JsonObject* _tmp2_ = NULL;
	JsonObject* recipient = NULL;
	JsonObject* _tmp3_ = NULL;
	JsonObject* _tmp4_ = NULL;
	JsonObject* _tmp5_ = NULL;
	gint64 sender_id = 0LL;
	JsonObject* _tmp6_ = NULL;
	gint64 _tmp7_ = 0LL;
	gint64 dm_id = 0LL;
	JsonObject* _tmp8_ = NULL;
	gint64 _tmp9_ = 0LL;
	gchar* text = NULL;
	JsonObject* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	JsonObject* _tmp13_ = NULL;
	gboolean _tmp14_ = FALSE;
	Account* _tmp23_ = NULL;
	Account* _tmp24_ = NULL;
	SqlDatabase* _tmp25_ = NULL;
	SqlDatabase* _tmp26_ = NULL;
	SqlInsertStatement* _tmp27_ = NULL;
	SqlInsertStatement* _tmp28_ = NULL;
	gint64 _tmp29_ = 0LL;
	SqlInsertStatement* _tmp30_ = NULL;
	SqlInsertStatement* _tmp31_ = NULL;
	gint64 _tmp32_ = 0LL;
	SqlInsertStatement* _tmp33_ = NULL;
	SqlInsertStatement* _tmp34_ = NULL;
	JsonObject* _tmp35_ = NULL;
	gint64 _tmp36_ = 0LL;
	SqlInsertStatement* _tmp37_ = NULL;
	SqlInsertStatement* _tmp38_ = NULL;
	JsonObject* _tmp39_ = NULL;
	const gchar* _tmp40_ = NULL;
	SqlInsertStatement* _tmp41_ = NULL;
	SqlInsertStatement* _tmp42_ = NULL;
	JsonObject* _tmp43_ = NULL;
	const gchar* _tmp44_ = NULL;
	SqlInsertStatement* _tmp45_ = NULL;
	SqlInsertStatement* _tmp46_ = NULL;
	JsonObject* _tmp47_ = NULL;
	const gchar* _tmp48_ = NULL;
	SqlInsertStatement* _tmp49_ = NULL;
	SqlInsertStatement* _tmp50_ = NULL;
	JsonObject* _tmp51_ = NULL;
	const gchar* _tmp52_ = NULL;
	SqlInsertStatement* _tmp53_ = NULL;
	SqlInsertStatement* _tmp54_ = NULL;
	JsonObject* _tmp55_ = NULL;
	const gchar* _tmp56_ = NULL;
	SqlInsertStatement* _tmp57_ = NULL;
	SqlInsertStatement* _tmp58_ = NULL;
	JsonObject* _tmp59_ = NULL;
	const gchar* _tmp60_ = NULL;
	GDateTime* _tmp61_ = NULL;
	GDateTime* _tmp62_ = NULL;
	gint64 _tmp63_ = 0LL;
	SqlInsertStatement* _tmp64_ = NULL;
	SqlInsertStatement* _tmp65_ = NULL;
	const gchar* _tmp66_ = NULL;
	SqlInsertStatement* _tmp67_ = NULL;
	SqlInsertStatement* _tmp68_ = NULL;
	gint64 _tmp69_ = 0LL;
	Account* _tmp70_ = NULL;
	Account* _tmp71_ = NULL;
	gint64 _tmp72_ = 0LL;
	gint64 _tmp73_ = 0LL;
	g_return_if_fail (IS_DM_THREADS_PAGE (self));
	g_return_if_fail (dm_obj != NULL);
	_tmp0_ = dm_obj;
	_tmp1_ = json_object_get_object_member (_tmp0_, "sender");
	_tmp2_ = _json_object_ref0 (_tmp1_);
	sender = _tmp2_;
	_tmp3_ = dm_obj;
	_tmp4_ = json_object_get_object_member (_tmp3_, "recipient");
	_tmp5_ = _json_object_ref0 (_tmp4_);
	recipient = _tmp5_;
	_tmp6_ = dm_obj;
	_tmp7_ = json_object_get_int_member (_tmp6_, "sender_id");
	sender_id = _tmp7_;
	_tmp8_ = dm_obj;
	_tmp9_ = json_object_get_int_member (_tmp8_, "id");
	dm_id = _tmp9_;
	_tmp10_ = dm_obj;
	_tmp11_ = json_object_get_string_member (_tmp10_, "text");
	_tmp12_ = g_strdup (_tmp11_);
	text = _tmp12_;
	_tmp13_ = dm_obj;
	_tmp14_ = json_object_has_member (_tmp13_, "entities");
	if (_tmp14_) {
		Block19Data* _data19_;
		JsonArray* urls = NULL;
		JsonObject* _tmp15_ = NULL;
		JsonObject* _tmp16_ = NULL;
		JsonArray* _tmp17_ = NULL;
		JsonArray* _tmp18_ = NULL;
		JsonArray* _tmp19_ = NULL;
		const gchar* _tmp20_ = NULL;
		GSList* _tmp21_ = NULL;
		gchar* _tmp22_ = NULL;
		_data19_ = g_slice_new0 (Block19Data);
		_data19_->_ref_count_ = 1;
		_data19_->self = g_object_ref (self);
		_tmp15_ = dm_obj;
		_tmp16_ = json_object_get_object_member (_tmp15_, "entities");
		_tmp17_ = json_object_get_array_member (_tmp16_, "urls");
		_tmp18_ = _json_array_ref0 (_tmp17_);
		urls = _tmp18_;
		_data19_->url_list = NULL;
		_tmp19_ = urls;
		json_array_foreach_element (_tmp19_, ____lambda117__json_array_foreach, _data19_);
		_tmp20_ = text;
		_tmp21_ = _data19_->url_list;
		_tmp22_ = tweet_utils_get_formatted_text (_tmp20_, _tmp21_);
		_g_free0 (text);
		text = _tmp22_;
		_json_array_unref0 (urls);
		block19_data_unref (_data19_);
		_data19_ = NULL;
	}
	_tmp23_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp24_ = _tmp23_;
	_tmp25_ = account_get_db (_tmp24_);
	_tmp26_ = _tmp25_;
	_tmp27_ = sql_database_insert (_tmp26_, "dms");
	_tmp28_ = _tmp27_;
	_tmp29_ = dm_id;
	_tmp30_ = sql_insert_statement_vali64 (_tmp28_, "id", _tmp29_);
	_tmp31_ = _tmp30_;
	_tmp32_ = sender_id;
	_tmp33_ = sql_insert_statement_vali64 (_tmp31_, "from_id", _tmp32_);
	_tmp34_ = _tmp33_;
	_tmp35_ = dm_obj;
	_tmp36_ = json_object_get_int_member (_tmp35_, "recipient_id");
	_tmp37_ = sql_insert_statement_vali64 (_tmp34_, "to_id", _tmp36_);
	_tmp38_ = _tmp37_;
	_tmp39_ = dm_obj;
	_tmp40_ = json_object_get_string_member (_tmp39_, "sender_screen_name");
	_tmp41_ = sql_insert_statement_val (_tmp38_, "from_screen_name", _tmp40_);
	_tmp42_ = _tmp41_;
	_tmp43_ = dm_obj;
	_tmp44_ = json_object_get_string_member (_tmp43_, "recipient_screen_name");
	_tmp45_ = sql_insert_statement_val (_tmp42_, "to_screen_name", _tmp44_);
	_tmp46_ = _tmp45_;
	_tmp47_ = sender;
	_tmp48_ = json_object_get_string_member (_tmp47_, "name");
	_tmp49_ = sql_insert_statement_val (_tmp46_, "from_name", _tmp48_);
	_tmp50_ = _tmp49_;
	_tmp51_ = recipient;
	_tmp52_ = json_object_get_string_member (_tmp51_, "name");
	_tmp53_ = sql_insert_statement_val (_tmp50_, "to_name", _tmp52_);
	_tmp54_ = _tmp53_;
	_tmp55_ = sender;
	_tmp56_ = json_object_get_string_member (_tmp55_, "profile_image_url");
	_tmp57_ = sql_insert_statement_val (_tmp54_, "avatar_url", _tmp56_);
	_tmp58_ = _tmp57_;
	_tmp59_ = dm_obj;
	_tmp60_ = json_object_get_string_member (_tmp59_, "created_at");
	_tmp61_ = utils_parse_date (_tmp60_);
	_tmp62_ = _tmp61_;
	_tmp63_ = g_date_time_to_unix (_tmp62_);
	_tmp64_ = sql_insert_statement_vali64 (_tmp58_, "timestamp", _tmp63_);
	_tmp65_ = _tmp64_;
	_tmp66_ = text;
	_tmp67_ = sql_insert_statement_val (_tmp65_, "text", _tmp66_);
	_tmp68_ = _tmp67_;
	sql_insert_statement_run (_tmp68_);
	_sql_insert_statement_unref0 (_tmp68_);
	_sql_insert_statement_unref0 (_tmp65_);
	_g_date_time_unref0 (_tmp62_);
	_sql_insert_statement_unref0 (_tmp58_);
	_sql_insert_statement_unref0 (_tmp54_);
	_sql_insert_statement_unref0 (_tmp50_);
	_sql_insert_statement_unref0 (_tmp46_);
	_sql_insert_statement_unref0 (_tmp42_);
	_sql_insert_statement_unref0 (_tmp38_);
	_sql_insert_statement_unref0 (_tmp34_);
	_sql_insert_statement_unref0 (_tmp31_);
	_sql_insert_statement_unref0 (_tmp28_);
	_tmp69_ = sender_id;
	_tmp70_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp71_ = _tmp70_;
	_tmp72_ = account_get_id (_tmp71_);
	_tmp73_ = _tmp72_;
	if (_tmp69_ != _tmp73_) {
		gint64 _tmp74_ = 0LL;
		_tmp74_ = dm_id;
		self->priv->max_received_id = _tmp74_;
	} else {
		gint64 _tmp75_ = 0LL;
		_tmp75_ = dm_id;
		self->priv->max_sent_id = _tmp75_;
	}
	_g_free0 (text);
	_json_object_unref0 (recipient);
	_json_object_unref0 (sender);
}


static void dm_threads_page_save_last_messages (DMThreadsPage* self) {
	Account* _tmp0_ = NULL;
	Account* _tmp1_ = NULL;
	SqlDatabase* _tmp2_ = NULL;
	SqlDatabase* _tmp3_ = NULL;
	Account* _tmp30_ = NULL;
	Account* _tmp31_ = NULL;
	SqlDatabase* _tmp32_ = NULL;
	SqlDatabase* _tmp33_ = NULL;
	g_return_if_fail (IS_DM_THREADS_PAGE (self));
	_tmp0_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp1_ = _tmp0_;
	_tmp2_ = account_get_db (_tmp1_);
	_tmp3_ = _tmp2_;
	sql_database_begin_transaction (_tmp3_);
	{
		GeeIterator* _thread_entry_it = NULL;
		GeeHashMap* _tmp4_ = NULL;
		GeeCollection* _tmp5_ = NULL;
		GeeCollection* _tmp6_ = NULL;
		GeeCollection* _tmp7_ = NULL;
		GeeIterator* _tmp8_ = NULL;
		GeeIterator* _tmp9_ = NULL;
		_tmp4_ = self->priv->thread_map;
		_tmp5_ = gee_abstract_map_get_values (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_TYPE_MAP, GeeMap));
		_tmp6_ = _tmp5_;
		_tmp7_ = _tmp6_;
		_tmp8_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GEE_TYPE_ITERABLE, GeeIterable));
		_tmp9_ = _tmp8_;
		_g_object_unref0 (_tmp7_);
		_thread_entry_it = _tmp9_;
		while (TRUE) {
			GeeIterator* _tmp10_ = NULL;
			gboolean _tmp11_ = FALSE;
			DMThreadEntry* thread_entry = NULL;
			GeeIterator* _tmp12_ = NULL;
			gpointer _tmp13_ = NULL;
			Account* _tmp14_ = NULL;
			Account* _tmp15_ = NULL;
			SqlDatabase* _tmp16_ = NULL;
			SqlDatabase* _tmp17_ = NULL;
			SqlUpdateStatement* _tmp18_ = NULL;
			SqlUpdateStatement* _tmp19_ = NULL;
			DMThreadEntry* _tmp20_ = NULL;
			const gchar* _tmp21_ = NULL;
			const gchar* _tmp22_ = NULL;
			SqlUpdateStatement* _tmp23_ = NULL;
			SqlUpdateStatement* _tmp24_ = NULL;
			DMThreadEntry* _tmp25_ = NULL;
			gint64 _tmp26_ = 0LL;
			gint64 _tmp27_ = 0LL;
			SqlUpdateStatement* _tmp28_ = NULL;
			SqlUpdateStatement* _tmp29_ = NULL;
			_tmp10_ = _thread_entry_it;
			_tmp11_ = gee_iterator_next (_tmp10_);
			if (!_tmp11_) {
				break;
			}
			_tmp12_ = _thread_entry_it;
			_tmp13_ = gee_iterator_get (_tmp12_);
			thread_entry = (DMThreadEntry*) _tmp13_;
			_tmp14_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
			_tmp15_ = _tmp14_;
			_tmp16_ = account_get_db (_tmp15_);
			_tmp17_ = _tmp16_;
			_tmp18_ = sql_database_update (_tmp17_, "dm_threads");
			_tmp19_ = _tmp18_;
			_tmp20_ = thread_entry;
			_tmp21_ = dm_thread_entry_get_last_message (_tmp20_);
			_tmp22_ = _tmp21_;
			_tmp23_ = sql_update_statement_val (_tmp19_, "last_message", _tmp22_);
			_tmp24_ = _tmp23_;
			_tmp25_ = thread_entry;
			_tmp26_ = dm_thread_entry_get_user_id (_tmp25_);
			_tmp27_ = _tmp26_;
			_tmp28_ = sql_update_statement_where_eqi (_tmp24_, "user_id", _tmp27_);
			_tmp29_ = _tmp28_;
			sql_update_statement_run (_tmp29_);
			_sql_update_statement_unref0 (_tmp29_);
			_sql_update_statement_unref0 (_tmp24_);
			_sql_update_statement_unref0 (_tmp19_);
		}
		_g_object_unref0 (_thread_entry_it);
	}
	_tmp30_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp31_ = _tmp30_;
	_tmp32_ = account_get_db (_tmp31_);
	_tmp33_ = _tmp32_;
	sql_database_end_transaction (_tmp33_);
}


static void dm_threads_page_header_func (DMThreadsPage* self, GtkListBoxRow* row, GtkListBoxRow* row_before) {
	GtkListBoxRow* _tmp0_ = NULL;
	GtkWidget* header = NULL;
	GtkListBoxRow* _tmp1_ = NULL;
	GtkWidget* _tmp2_ = NULL;
	GtkWidget* _tmp3_ = NULL;
	GtkWidget* _tmp4_ = NULL;
	g_return_if_fail (IS_DM_THREADS_PAGE (self));
	g_return_if_fail (GTK_IS_LIST_BOX_ROW (row));
	g_return_if_fail ((row_before == NULL) || GTK_IS_LIST_BOX_ROW (row_before));
	_tmp0_ = row_before;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = row;
	_tmp2_ = gtk_list_box_row_get_header (_tmp1_);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	header = _tmp3_;
	_tmp4_ = header;
	if (_tmp4_ == NULL) {
		GtkSeparator* _tmp5_ = NULL;
		GtkWidget* _tmp6_ = NULL;
		GtkListBoxRow* _tmp7_ = NULL;
		GtkWidget* _tmp8_ = NULL;
		_tmp5_ = (GtkSeparator*) gtk_separator_new (GTK_ORIENTATION_HORIZONTAL);
		g_object_ref_sink (_tmp5_);
		_g_object_unref0 (header);
		header = G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_widget_get_type (), GtkWidget);
		_tmp6_ = header;
		gtk_widget_show (_tmp6_);
		_tmp7_ = row;
		_tmp8_ = header;
		gtk_list_box_row_set_header (_tmp7_, _tmp8_);
	}
	_g_object_unref0 (header);
}


static void dm_threads_page_remove_spinner (DMThreadsPage* self) {
	gboolean _tmp0_ = FALSE;
	GtkSpinner* _tmp1_ = NULL;
	g_return_if_fail (IS_DM_THREADS_PAGE (self));
	_tmp1_ = self->priv->progress_spinner;
	if (_tmp1_ != NULL) {
		GtkSpinner* _tmp2_ = NULL;
		GtkContainer* _tmp3_ = NULL;
		GtkContainer* _tmp4_ = NULL;
		_tmp2_ = self->priv->progress_spinner;
		_tmp3_ = gtk_widget_get_parent (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_widget_get_type (), GtkWidget));
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_ != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GtkListBox* _tmp5_ = NULL;
		GtkListBox* _tmp6_ = NULL;
		GtkListBoxRow* _tmp7_ = NULL;
		_tmp5_ = self->priv->thread_list;
		_tmp6_ = self->priv->thread_list;
		_tmp7_ = gtk_list_box_get_row_at_index (_tmp6_, 1);
		gtk_container_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_widget_get_type (), GtkWidget));
		_g_object_unref0 (self->priv->progress_spinner);
		self->priv->progress_spinner = NULL;
	}
}


static gchar* dm_threads_page_notify_new_dm (DMThreadsPage* self, DMThreadEntry* thread_entry, const gchar* msg_text) {
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	gchar* sender_screen_name = NULL;
	DMThreadEntry* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gint64 sender_id = 0LL;
	DMThreadEntry* _tmp5_ = NULL;
	gint64 _tmp6_ = 0LL;
	gint64 _tmp7_ = 0LL;
	gchar* id = NULL;
	gint64 _tmp8_ = 0LL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gchar* summary = NULL;
	gchar* text = NULL;
	DMThreadEntry* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	GNotification* n = NULL;
	const gchar* _tmp32_ = NULL;
	GNotification* _tmp33_ = NULL;
	GNotification* _tmp34_ = NULL;
	const gchar* _tmp35_ = NULL;
	GVariant* value = NULL;
	Account* _tmp36_ = NULL;
	Account* _tmp37_ = NULL;
	gint64 _tmp38_ = 0LL;
	gint64 _tmp39_ = 0LL;
	GVariant* _tmp40_ = NULL;
	gint64 _tmp41_ = 0LL;
	GVariant* _tmp42_ = NULL;
	GVariant** _tmp43_ = NULL;
	GVariant** _tmp44_ = NULL;
	gint _tmp44__length1 = 0;
	GVariant* _tmp45_ = NULL;
	GVariant* _tmp46_ = NULL;
	GNotification* _tmp47_ = NULL;
	GVariant* _tmp48_ = NULL;
	GApplication* _tmp49_ = NULL;
	const gchar* _tmp50_ = NULL;
	GNotification* _tmp51_ = NULL;
	g_return_val_if_fail (IS_DM_THREADS_PAGE (self), NULL);
	g_return_val_if_fail (IS_DM_THREAD_ENTRY (thread_entry), NULL);
	g_return_val_if_fail (msg_text != NULL, NULL);
	_tmp0_ = settings_notify_new_dms ();
	if (!_tmp0_) {
		result = NULL;
		return result;
	}
	_tmp1_ = thread_entry;
	_tmp2_ = dm_thread_entry_get_screen_name (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup (_tmp3_);
	sender_screen_name = _tmp4_;
	_tmp5_ = thread_entry;
	_tmp6_ = dm_thread_entry_get_user_id (_tmp5_);
	_tmp7_ = _tmp6_;
	sender_id = _tmp7_;
	_tmp8_ = sender_id;
	_tmp9_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = g_strconcat ("new-dm-", _tmp10_, NULL);
	_tmp12_ = _tmp11_;
	_g_free0 (_tmp10_);
	id = _tmp12_;
	_tmp13_ = thread_entry;
	_tmp14_ = _tmp13_->notification_id;
	if (_tmp14_ != NULL) {
		GApplication* _tmp15_ = NULL;
		const gchar* _tmp16_ = NULL;
		DMThreadEntry* _tmp17_ = NULL;
		gint _tmp18_ = 0;
		const gchar* _tmp19_ = NULL;
		DMThreadEntry* _tmp20_ = NULL;
		gint _tmp21_ = 0;
		DMThreadEntry* _tmp22_ = NULL;
		const gchar* _tmp23_ = NULL;
		const gchar* _tmp24_ = NULL;
		gchar* _tmp25_ = NULL;
		gchar* _tmp26_ = NULL;
		_tmp15_ = g_application_get_default ();
		_tmp16_ = id;
		g_application_withdraw_notification (_tmp15_, _tmp16_);
		_tmp17_ = thread_entry;
		_tmp18_ = _tmp17_->unread_count;
		_tmp19_ = ngettext ("%d new Message from %s", "%d new Messages from %s", (gulong) _tmp18_);
		_tmp20_ = thread_entry;
		_tmp21_ = _tmp20_->unread_count;
		_tmp22_ = thread_entry;
		_tmp23_ = dm_thread_entry_get_name (_tmp22_);
		_tmp24_ = _tmp23_;
		_tmp25_ = g_strdup_printf (_tmp19_, _tmp21_, _tmp24_);
		_g_free0 (summary);
		summary = _tmp25_;
		_tmp26_ = g_strdup ("");
		_g_free0 (text);
		text = _tmp26_;
	} else {
		const gchar* _tmp27_ = NULL;
		const gchar* _tmp28_ = NULL;
		gchar* _tmp29_ = NULL;
		const gchar* _tmp30_ = NULL;
		gchar* _tmp31_ = NULL;
		_tmp27_ = _ ("New direct message from %s");
		_tmp28_ = sender_screen_name;
		_tmp29_ = g_strdup_printf (_tmp27_, _tmp28_);
		_g_free0 (summary);
		summary = _tmp29_;
		_tmp30_ = msg_text;
		_tmp31_ = g_strdup (_tmp30_);
		_g_free0 (text);
		text = _tmp31_;
	}
	_tmp32_ = summary;
	_tmp33_ = g_notification_new (_tmp32_);
	n = _tmp33_;
	_tmp34_ = n;
	_tmp35_ = text;
	g_notification_set_body (_tmp34_, _tmp35_);
	_tmp36_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp37_ = _tmp36_;
	_tmp38_ = account_get_id (_tmp37_);
	_tmp39_ = _tmp38_;
	_tmp40_ = g_variant_new_int64 (_tmp39_);
	g_variant_ref_sink (_tmp40_);
	_tmp41_ = sender_id;
	_tmp42_ = g_variant_new_int64 (_tmp41_);
	g_variant_ref_sink (_tmp42_);
	_tmp43_ = g_new0 (GVariant*, 2 + 1);
	_tmp43_[0] = _tmp40_;
	_tmp43_[1] = _tmp42_;
	_tmp44_ = _tmp43_;
	_tmp44__length1 = 2;
	_tmp45_ = g_variant_new_tuple (_tmp44_, 2);
	g_variant_ref_sink (_tmp45_);
	_tmp46_ = _tmp45_;
	_tmp44_ = (_vala_array_free (_tmp44_, _tmp44__length1, (GDestroyNotify) g_variant_unref), NULL);
	value = _tmp46_;
	_tmp47_ = n;
	_tmp48_ = value;
	g_notification_set_default_action_and_target_value (_tmp47_, "app.show-dm-thread", _tmp48_);
	_tmp49_ = g_application_get_default ();
	_tmp50_ = id;
	_tmp51_ = n;
	g_application_send_notification (_tmp49_, _tmp50_, _tmp51_);
	result = id;
	_g_variant_unref0 (value);
	_g_object_unref0 (n);
	_g_free0 (text);
	_g_free0 (summary);
	_g_free0 (sender_screen_name);
	return result;
}


static void dm_threads_page_real_create_tool_button (IPage* base, GtkRadioButton* group) {
	DMThreadsPage * self;
	GtkRadioButton* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	BadgeRadioToolButton* _tmp2_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DM_THREADS_PAGE, DMThreadsPage);
	g_return_if_fail ((group == NULL) || GTK_IS_RADIO_BUTTON (group));
	_tmp0_ = group;
	_tmp1_ = _ ("Direct Messages");
	_tmp2_ = badge_radio_tool_button_new (_tmp0_, "corebird-dms-symbolic", _tmp1_);
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->tool_button);
	self->priv->tool_button = _tmp2_;
}


static GtkRadioButton* dm_threads_page_real_get_tool_button (IPage* base) {
	DMThreadsPage * self;
	GtkRadioButton* result = NULL;
	BadgeRadioToolButton* _tmp0_ = NULL;
	GtkRadioButton* _tmp1_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DM_THREADS_PAGE, DMThreadsPage);
	_tmp0_ = self->priv->tool_button;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_radio_button_get_type (), GtkRadioButton));
	result = _tmp1_;
	return result;
}


static gboolean dm_threads_page_user_id_visible (DMThreadsPage* self, gint64 sender_id) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	MainWindow* _tmp1_ = NULL;
	MainWindow* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	g_return_val_if_fail (IS_DM_THREADS_PAGE (self), FALSE);
	_tmp1_ = ipage_get_main_window (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
	_tmp2_ = _tmp1_;
	_tmp3_ = main_window_get_cur_page_id (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ == ((gint) PAGE_DM)) {
		MainWindow* _tmp5_ = NULL;
		MainWindow* _tmp6_ = NULL;
		IPage* _tmp7_ = NULL;
		DMPage* _tmp8_ = NULL;
		gint64 _tmp9_ = 0LL;
		gint64 _tmp10_ = 0LL;
		_tmp5_ = ipage_get_main_window (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
		_tmp6_ = _tmp5_;
		_tmp7_ = main_window_get_page (_tmp6_, (gint) PAGE_DM);
		_tmp8_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, TYPE_DM_PAGE, DMPage);
		_tmp9_ = _tmp8_->user_id;
		_tmp10_ = sender_id;
		_tmp0_ = _tmp9_ == _tmp10_;
		_g_object_unref0 (_tmp8_);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


static gchar* dm_threads_page_real_get_title (IPage* base) {
	DMThreadsPage * self;
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DM_THREADS_PAGE, DMThreadsPage);
	_tmp0_ = _ ("Direct Messages");
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


static void dm_threads_page_update_unread_count (DMThreadsPage* self) {
	BadgeRadioToolButton* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	BadgeRadioToolButton* _tmp2_ = NULL;
	g_return_if_fail (IS_DM_THREADS_PAGE (self));
	_tmp0_ = self->priv->tool_button;
	_tmp1_ = self->priv->_unread_count;
	badge_radio_tool_button_set_show_badge (_tmp0_, _tmp1_ > 0);
	_tmp2_ = self->priv->tool_button;
	gtk_widget_queue_draw (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_widget_get_type (), GtkWidget));
}


void dm_threads_page_adjust_unread_count_for_user_id (DMThreadsPage* self, gint64 user_id) {
	DMThreadEntry* user_entry = NULL;
	GeeHashMap* _tmp0_ = NULL;
	gint64 _tmp1_ = 0LL;
	gpointer _tmp2_ = NULL;
	DMThreadEntry* _tmp3_ = NULL;
	DMThreadEntry* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	DMThreadEntry* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	DMThreadEntry* _tmp8_ = NULL;
	DMThreadEntry* _tmp9_ = NULL;
	g_return_if_fail (IS_DM_THREADS_PAGE (self));
	_tmp0_ = self->priv->thread_map;
	_tmp1_ = user_id;
	_tmp2_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), &_tmp1_);
	_tmp3_ = _g_object_ref0 ((DMThreadEntry*) _tmp2_);
	user_entry = _tmp3_;
	_tmp4_ = user_entry;
	if (_tmp4_ == NULL) {
		_g_object_unref0 (user_entry);
		return;
	}
	_tmp5_ = self->priv->_unread_count;
	_tmp6_ = user_entry;
	_tmp7_ = _tmp6_->unread_count;
	dm_threads_page_set_unread_count (self, _tmp5_ - _tmp7_);
	_tmp8_ = user_entry;
	_tmp8_->unread_count = 0;
	dm_threads_page_update_unread_count (self);
	_tmp9_ = user_entry;
	dm_thread_entry_update_unread_count (_tmp9_);
	_g_object_unref0 (user_entry);
}


gchar* dm_threads_page_get_notification_id_for_user_id (DMThreadsPage* self, gint64 user_id) {
	gchar* result = NULL;
	DMThreadEntry* user_entry = NULL;
	GeeHashMap* _tmp0_ = NULL;
	gint64 _tmp1_ = 0LL;
	gpointer _tmp2_ = NULL;
	DMThreadEntry* _tmp3_ = NULL;
	DMThreadEntry* _tmp4_ = NULL;
	gchar* id = NULL;
	DMThreadEntry* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	DMThreadEntry* _tmp8_ = NULL;
	g_return_val_if_fail (IS_DM_THREADS_PAGE (self), NULL);
	_tmp0_ = self->priv->thread_map;
	_tmp1_ = user_id;
	_tmp2_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), &_tmp1_);
	_tmp3_ = _g_object_ref0 ((DMThreadEntry*) _tmp2_);
	user_entry = _tmp3_;
	_tmp4_ = user_entry;
	if (_tmp4_ == NULL) {
		result = NULL;
		_g_object_unref0 (user_entry);
		return result;
	}
	_tmp5_ = user_entry;
	_tmp6_ = _tmp5_->notification_id;
	_tmp7_ = g_strdup (_tmp6_);
	id = _tmp7_;
	_tmp8_ = user_entry;
	_g_free0 (_tmp8_->notification_id);
	_tmp8_->notification_id = NULL;
	result = id;
	_g_object_unref0 (user_entry);
	return result;
}


gint dm_threads_page_get_unread_count (DMThreadsPage* self) {
	gint result;
	gint _tmp0_ = 0;
	g_return_val_if_fail (IS_DM_THREADS_PAGE (self), 0);
	_tmp0_ = self->priv->_unread_count;
	result = _tmp0_;
	return result;
}


void dm_threads_page_set_unread_count (DMThreadsPage* self, gint value) {
	gint _tmp0_ = 0;
	g_return_if_fail (IS_DM_THREADS_PAGE (self));
	_tmp0_ = value;
	self->priv->_unread_count = _tmp0_;
	g_object_notify ((GObject *) self, "unread-count");
}


static MainWindow* dm_threads_page_real_get_main_window (IPage* base) {
	MainWindow* result;
	DMThreadsPage* self;
	MainWindow* _tmp0_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DM_THREADS_PAGE, DMThreadsPage);
	_tmp0_ = self->priv->_main_window;
	result = _tmp0_;
	return result;
}


static void dm_threads_page_real_set_main_window (IPage* base, MainWindow* value) {
	DMThreadsPage* self;
	MainWindow* _tmp0_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DM_THREADS_PAGE, DMThreadsPage);
	_tmp0_ = value;
	self->priv->_main_window = _tmp0_;
	g_object_notify ((GObject *) self, "main-window");
}


static Account* dm_threads_page_real_get_account (IPage* base) {
	Account* result;
	DMThreadsPage* self;
	Account* _tmp0_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DM_THREADS_PAGE, DMThreadsPage);
	_tmp0_ = self->priv->_account;
	result = _tmp0_;
	return result;
}


static void dm_threads_page_real_set_account (IPage* base, Account* value) {
	DMThreadsPage* self;
	Account* _tmp0_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DM_THREADS_PAGE, DMThreadsPage);
	_tmp0_ = value;
	self->priv->_account = _tmp0_;
	g_object_notify ((GObject *) self, "account");
}


DeltaUpdater* dm_threads_page_get_delta_updater (DMThreadsPage* self) {
	DeltaUpdater* result;
	DeltaUpdater* _tmp0_ = NULL;
	g_return_val_if_fail (IS_DM_THREADS_PAGE (self), NULL);
	_tmp0_ = self->priv->_delta_updater;
	result = _tmp0_;
	return result;
}


void dm_threads_page_set_delta_updater (DMThreadsPage* self, DeltaUpdater* value) {
	DeltaUpdater* _tmp0_ = NULL;
	g_return_if_fail (IS_DM_THREADS_PAGE (self));
	_tmp0_ = value;
	self->priv->_delta_updater = _tmp0_;
	g_object_notify ((GObject *) self, "delta-updater");
}


static gint dm_threads_page_real_get_id (IPage* base) {
	gint result;
	DMThreadsPage* self;
	gint _tmp0_ = 0;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DM_THREADS_PAGE, DMThreadsPage);
	_tmp0_ = self->priv->_id;
	result = _tmp0_;
	return result;
}


static void dm_threads_page_real_set_id (IPage* base, gint value) {
	DMThreadsPage* self;
	gint _tmp0_ = 0;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DM_THREADS_PAGE, DMThreadsPage);
	_tmp0_ = value;
	self->priv->_id = _tmp0_;
	g_object_notify ((GObject *) self, "id");
}


static void dm_threads_page_class_init (DMThreadsPageClass * klass) {
	gint DMThreadsPage_private_offset;
	dm_threads_page_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DMThreadsPagePrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_dm_threads_page_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_dm_threads_page_set_property;
	G_OBJECT_CLASS (klass)->finalize = dm_threads_page_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DM_THREADS_PAGE_UNREAD_COUNT, g_param_spec_int ("unread-count", "unread-count", "unread-count", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DM_THREADS_PAGE_MAIN_WINDOW, g_param_spec_object ("main-window", "main-window", "main-window", TYPE_MAIN_WINDOW, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DM_THREADS_PAGE_ACCOUNT, g_param_spec_object ("account", "account", "account", TYPE_ACCOUNT, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DM_THREADS_PAGE_DELTA_UPDATER, g_param_spec_object ("delta-updater", "delta-updater", "delta-updater", TYPE_DELTA_UPDATER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DM_THREADS_PAGE_ID, g_param_spec_int ("id", "id", "id", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	DMThreadsPage_private_offset = g_type_class_get_instance_private_offset (klass);
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/baedert/corebird/ui/dm-threads-page.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "thread_list", FALSE, DMThreadsPage_private_offset + G_STRUCT_OFFSET (DMThreadsPagePrivate, thread_list));
}


static void dm_threads_page_ipage_interface_init (IPageIface * iface) {
	dm_threads_page_ipage_parent_iface = g_type_interface_peek_parent (iface);
	iface->on_join = (void (*)(IPage*, gint, Bundle*)) dm_threads_page_real_on_join;
	iface->on_leave = (void (*)(IPage*)) dm_threads_page_real_on_leave;
	iface->create_tool_button = (void (*)(IPage*, GtkRadioButton*)) dm_threads_page_real_create_tool_button;
	iface->get_tool_button = (GtkRadioButton* (*)(IPage*)) dm_threads_page_real_get_tool_button;
	iface->get_title = (gchar* (*)(IPage*)) dm_threads_page_real_get_title;
	iface->get_main_window = dm_threads_page_real_get_main_window;
	iface->set_main_window = dm_threads_page_real_set_main_window;
	iface->get_account = dm_threads_page_real_get_account;
	iface->set_account = dm_threads_page_real_set_account;
	iface->get_id = dm_threads_page_real_get_id;
	iface->set_id = dm_threads_page_real_set_id;
}


static void dm_threads_page_imessage_receiver_interface_init (IMessageReceiverIface * iface) {
	dm_threads_page_imessage_receiver_parent_iface = g_type_interface_peek_parent (iface);
	iface->stream_message_received = (void (*)(IMessageReceiver*, StreamMessageType, JsonNode*)) dm_threads_page_real_stream_message_received;
}


static void dm_threads_page_instance_init (DMThreadsPage * self) {
	GeeHashMap* _tmp0_ = NULL;
	self->priv = DM_THREADS_PAGE_GET_PRIVATE (self);
	self->priv->initialized = FALSE;
	_tmp0_ = gee_hash_map_new (G_TYPE_INT64, (GBoxedCopyFunc) _int64_dup, g_free, TYPE_DM_THREAD_ENTRY, NULL, NULL, _utils_int64_hash_func_gee_hash_data_func, NULL, NULL, _utils_int64_equal_func_gee_equal_data_func, NULL, NULL, _dm_thread_entry_equal_func_gee_equal_data_func, NULL, NULL);
	self->priv->thread_map = _tmp0_;
	self->priv->max_received_id = (gint64) (-1);
	self->priv->max_sent_id = (gint64) (-1);
	gtk_widget_init_template (GTK_WIDGET (self));
}


static void dm_threads_page_finalize (GObject* obj) {
	DMThreadsPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DM_THREADS_PAGE, DMThreadsPage);
	_g_object_unref0 (self->priv->tool_button);
	_g_object_unref0 (self->priv->thread_map);
	_g_object_unref0 (self->priv->start_conversation_entry);
	_g_object_unref0 (self->priv->thread_list);
	_g_object_unref0 (self->priv->progress_spinner);
	_g_object_unref0 (self->priv->dm_download_collect);
	G_OBJECT_CLASS (dm_threads_page_parent_class)->finalize (obj);
}


GType dm_threads_page_get_type (void) {
	static volatile gsize dm_threads_page_type_id__volatile = 0;
	if (g_once_init_enter (&dm_threads_page_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DMThreadsPageClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dm_threads_page_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DMThreadsPage), 0, (GInstanceInitFunc) dm_threads_page_instance_init, NULL };
		static const GInterfaceInfo ipage_info = { (GInterfaceInitFunc) dm_threads_page_ipage_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo imessage_receiver_info = { (GInterfaceInitFunc) dm_threads_page_imessage_receiver_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType dm_threads_page_type_id;
		dm_threads_page_type_id = g_type_register_static (TYPE_SCROLL_WIDGET, "DMThreadsPage", &g_define_type_info, 0);
		g_type_add_interface_static (dm_threads_page_type_id, TYPE_IPAGE, &ipage_info);
		g_type_add_interface_static (dm_threads_page_type_id, TYPE_IMESSAGE_RECEIVER, &imessage_receiver_info);
		g_once_init_leave (&dm_threads_page_type_id__volatile, dm_threads_page_type_id);
	}
	return dm_threads_page_type_id__volatile;
}


static void _vala_dm_threads_page_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DMThreadsPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_DM_THREADS_PAGE, DMThreadsPage);
	switch (property_id) {
		case DM_THREADS_PAGE_UNREAD_COUNT:
		g_value_set_int (value, dm_threads_page_get_unread_count (self));
		break;
		case DM_THREADS_PAGE_MAIN_WINDOW:
		g_value_set_object (value, ipage_get_main_window (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage)));
		break;
		case DM_THREADS_PAGE_ACCOUNT:
		g_value_set_object (value, ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage)));
		break;
		case DM_THREADS_PAGE_DELTA_UPDATER:
		g_value_set_object (value, dm_threads_page_get_delta_updater (self));
		break;
		case DM_THREADS_PAGE_ID:
		g_value_set_int (value, ipage_get_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage)));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_dm_threads_page_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DMThreadsPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_DM_THREADS_PAGE, DMThreadsPage);
	switch (property_id) {
		case DM_THREADS_PAGE_UNREAD_COUNT:
		dm_threads_page_set_unread_count (self, g_value_get_int (value));
		break;
		case DM_THREADS_PAGE_MAIN_WINDOW:
		ipage_set_main_window (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage), g_value_get_object (value));
		break;
		case DM_THREADS_PAGE_ACCOUNT:
		ipage_set_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage), g_value_get_object (value));
		break;
		case DM_THREADS_PAGE_DELTA_UPDATER:
		dm_threads_page_set_delta_updater (self, g_value_get_object (value));
		break;
		case DM_THREADS_PAGE_ID:
		ipage_set_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage), g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



