/* valapropertyaccessor.c generated by valac, the Vala compiler
 * generated from valapropertyaccessor.vala, do not modify */

/* valapropertyaccessor.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include "vala.h"
#include <stdlib.h>
#include <string.h>
#include <valagee.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))

struct _ValaPropertyAccessorPrivate {
	gboolean _readable;
	gboolean _writable;
	gboolean _construction;
	gboolean _automatic_body;
	ValaParameter* _value_parameter;
	ValaDataType* _value_type;
};


static gpointer vala_property_accessor_parent_class = NULL;

#define VALA_PROPERTY_ACCESSOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_PROPERTY_ACCESSOR, ValaPropertyAccessorPrivate))
static void vala_property_accessor_set_readable (ValaPropertyAccessor* self, gboolean value);
static void vala_property_accessor_set_writable (ValaPropertyAccessor* self, gboolean value);
static void vala_property_accessor_set_construction (ValaPropertyAccessor* self, gboolean value);
static void vala_property_accessor_set_value_type (ValaPropertyAccessor* self, ValaDataType* value);
static void vala_property_accessor_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static void vala_property_accessor_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor);
static gboolean vala_property_accessor_real_check (ValaCodeNode* base, ValaCodeContext* context);
static void vala_property_accessor_set_value_parameter (ValaPropertyAccessor* self, ValaParameter* value);
static void vala_property_accessor_set_automatic_body (ValaPropertyAccessor* self, gboolean value);
static void vala_property_accessor_real_replace_type (ValaCodeNode* base, ValaDataType* old_type, ValaDataType* new_type);
static void vala_property_accessor_finalize (ValaCodeNode * obj);


/**
 * Creates a new property accessor.
 *
 * @param readable           true if get accessor, false otherwise
 * @param writable           true if set accessor, false otherwise
 * @param construction       true if construct accessor, false otherwise
 * @param body               accessor body
 * @param source_reference   reference to source code
 * @return                   newly created property accessor
 */
ValaPropertyAccessor* vala_property_accessor_construct (GType object_type, gboolean readable, gboolean writable, gboolean construction, ValaDataType* value_type, ValaBlock* body, ValaSourceReference* source_reference, ValaComment* comment) {
	ValaPropertyAccessor* self = NULL;
	ValaSourceReference* _tmp0_;
	ValaComment* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	ValaDataType* _tmp5_;
	ValaBlock* _tmp6_;
	_tmp0_ = source_reference;
	_tmp1_ = comment;
	self = (ValaPropertyAccessor*) vala_subroutine_construct (object_type, NULL, _tmp0_, _tmp1_);
	_tmp2_ = readable;
	vala_property_accessor_set_readable (self, _tmp2_);
	_tmp3_ = writable;
	vala_property_accessor_set_writable (self, _tmp3_);
	_tmp4_ = construction;
	vala_property_accessor_set_construction (self, _tmp4_);
	_tmp5_ = value_type;
	vala_property_accessor_set_value_type (self, _tmp5_);
	_tmp6_ = body;
	vala_subroutine_set_body ((ValaSubroutine*) self, _tmp6_);
	vala_symbol_set_access ((ValaSymbol*) self, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	return self;
}


ValaPropertyAccessor* vala_property_accessor_new (gboolean readable, gboolean writable, gboolean construction, ValaDataType* value_type, ValaBlock* body, ValaSourceReference* source_reference, ValaComment* comment) {
	return vala_property_accessor_construct (VALA_TYPE_PROPERTY_ACCESSOR, readable, writable, construction, value_type, body, source_reference, comment);
}


static void vala_property_accessor_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaPropertyAccessor * self;
	ValaCodeVisitor* _tmp0_;
	self = (ValaPropertyAccessor*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = visitor;
	vala_code_visitor_visit_property_accessor (_tmp0_, self);
}


static void vala_property_accessor_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaPropertyAccessor * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaCodeVisitor* _tmp2_;
	ValaLocalVariable* _tmp3_;
	ValaLocalVariable* _tmp4_;
	ValaBlock* _tmp8_;
	ValaBlock* _tmp9_;
	self = (ValaPropertyAccessor*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_property_accessor_get_value_type (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = visitor;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, _tmp2_);
	_tmp3_ = vala_subroutine_get_result_var ((ValaSubroutine*) self);
	_tmp4_ = _tmp3_;
	if (_tmp4_ != NULL) {
		ValaLocalVariable* _tmp5_;
		ValaLocalVariable* _tmp6_;
		ValaCodeVisitor* _tmp7_;
		_tmp5_ = vala_subroutine_get_result_var ((ValaSubroutine*) self);
		_tmp6_ = _tmp5_;
		_tmp7_ = visitor;
		vala_code_node_accept ((ValaCodeNode*) _tmp6_, _tmp7_);
	}
	_tmp8_ = vala_subroutine_get_body ((ValaSubroutine*) self);
	_tmp9_ = _tmp8_;
	if (_tmp9_ != NULL) {
		ValaBlock* _tmp10_;
		ValaBlock* _tmp11_;
		ValaCodeVisitor* _tmp12_;
		_tmp10_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp11_ = _tmp10_;
		_tmp12_ = visitor;
		vala_code_node_accept ((ValaCodeNode*) _tmp11_, _tmp12_);
	}
}


/**
 * Get the method representing this property accessor
 * @return   null if the accessor is neither readable nor writable
 */
ValaMethod* vala_property_accessor_get_method (ValaPropertyAccessor* self) {
	ValaMethod* result = NULL;
	ValaMethod* m = NULL;
	gboolean _tmp0_;
	ValaMethod* _tmp32_;
	g_return_val_if_fail (self != NULL, NULL);
	m = NULL;
	_tmp0_ = self->priv->_readable;
	if (_tmp0_) {
		ValaProperty* _tmp1_;
		ValaProperty* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		ValaDataType* _tmp7_;
		ValaDataType* _tmp8_;
		ValaSourceReference* _tmp9_;
		ValaSourceReference* _tmp10_;
		ValaComment* _tmp11_;
		ValaComment* _tmp12_;
		ValaMethod* _tmp13_;
		_tmp1_ = vala_property_accessor_get_prop (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = vala_symbol_get_name ((ValaSymbol*) _tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_strdup_printf ("get_%s", _tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_property_accessor_get_value_type (self);
		_tmp8_ = _tmp7_;
		_tmp9_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp10_ = _tmp9_;
		_tmp11_ = vala_symbol_get_comment ((ValaSymbol*) self);
		_tmp12_ = _tmp11_;
		_tmp13_ = vala_method_new (_tmp6_, _tmp8_, _tmp10_, _tmp12_);
		_vala_code_node_unref0 (m);
		m = _tmp13_;
		_g_free0 (_tmp6_);
	} else {
		gboolean _tmp14_;
		_tmp14_ = self->priv->_writable;
		if (_tmp14_) {
			ValaProperty* _tmp15_;
			ValaProperty* _tmp16_;
			const gchar* _tmp17_;
			const gchar* _tmp18_;
			gchar* _tmp19_;
			gchar* _tmp20_;
			ValaVoidType* _tmp21_;
			ValaVoidType* _tmp22_;
			ValaSourceReference* _tmp23_;
			ValaSourceReference* _tmp24_;
			ValaComment* _tmp25_;
			ValaComment* _tmp26_;
			ValaMethod* _tmp27_;
			ValaMethod* _tmp28_;
			ValaParameter* _tmp29_;
			ValaParameter* _tmp30_;
			ValaParameter* _tmp31_;
			_tmp15_ = vala_property_accessor_get_prop (self);
			_tmp16_ = _tmp15_;
			_tmp17_ = vala_symbol_get_name ((ValaSymbol*) _tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = g_strdup_printf ("set_%s", _tmp18_);
			_tmp20_ = _tmp19_;
			_tmp21_ = vala_void_type_new (NULL);
			_tmp22_ = _tmp21_;
			_tmp23_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp24_ = _tmp23_;
			_tmp25_ = vala_symbol_get_comment ((ValaSymbol*) self);
			_tmp26_ = _tmp25_;
			_tmp27_ = vala_method_new (_tmp20_, (ValaDataType*) _tmp22_, _tmp24_, _tmp26_);
			_vala_code_node_unref0 (m);
			m = _tmp27_;
			_vala_code_node_unref0 (_tmp22_);
			_g_free0 (_tmp20_);
			_tmp28_ = m;
			_tmp29_ = self->priv->_value_parameter;
			_tmp30_ = vala_parameter_copy (_tmp29_);
			_tmp31_ = _tmp30_;
			vala_callable_add_parameter ((ValaCallable*) _tmp28_, _tmp31_);
			_vala_code_node_unref0 (_tmp31_);
		}
	}
	_tmp32_ = m;
	if (_tmp32_ != NULL) {
		ValaMethod* _tmp33_;
		ValaProperty* _tmp34_;
		ValaProperty* _tmp35_;
		ValaScope* _tmp36_;
		ValaScope* _tmp37_;
		ValaMethod* _tmp38_;
		ValaSymbolAccessibility _tmp39_;
		ValaSymbolAccessibility _tmp40_;
		ValaMethod* _tmp41_;
		ValaProperty* _tmp42_;
		ValaProperty* _tmp43_;
		ValaMemberBinding _tmp44_;
		ValaMemberBinding _tmp45_;
		ValaMethod* _tmp46_;
		ValaProperty* _tmp47_;
		ValaProperty* _tmp48_;
		gboolean _tmp49_;
		gboolean _tmp50_;
		ValaMethod* _tmp51_;
		ValaProperty* _tmp52_;
		ValaProperty* _tmp53_;
		gboolean _tmp54_;
		gboolean _tmp55_;
		_tmp33_ = m;
		_tmp34_ = vala_property_accessor_get_prop (self);
		_tmp35_ = _tmp34_;
		_tmp36_ = vala_symbol_get_owner ((ValaSymbol*) _tmp35_);
		_tmp37_ = _tmp36_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp33_, _tmp37_);
		_tmp38_ = m;
		_tmp39_ = vala_symbol_get_access ((ValaSymbol*) self);
		_tmp40_ = _tmp39_;
		vala_symbol_set_access ((ValaSymbol*) _tmp38_, _tmp40_);
		_tmp41_ = m;
		_tmp42_ = vala_property_accessor_get_prop (self);
		_tmp43_ = _tmp42_;
		_tmp44_ = vala_property_get_binding (_tmp43_);
		_tmp45_ = _tmp44_;
		vala_method_set_binding (_tmp41_, _tmp45_);
		_tmp46_ = m;
		_tmp47_ = vala_property_accessor_get_prop (self);
		_tmp48_ = _tmp47_;
		_tmp49_ = vala_property_get_is_abstract (_tmp48_);
		_tmp50_ = _tmp49_;
		vala_method_set_is_abstract (_tmp46_, _tmp50_);
		_tmp51_ = m;
		_tmp52_ = vala_property_accessor_get_prop (self);
		_tmp53_ = _tmp52_;
		_tmp54_ = vala_property_get_is_virtual (_tmp53_);
		_tmp55_ = _tmp54_;
		vala_method_set_is_virtual (_tmp51_, _tmp55_);
	}
	result = m;
	return result;
}


static gpointer _vala_code_node_ref0 (gpointer self) {
	return self ? vala_code_node_ref (self) : NULL;
}


static gboolean vala_property_accessor_real_check (ValaCodeNode* base, ValaCodeContext* context) {
	ValaPropertyAccessor * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaDataType* _tmp4_;
	ValaDataType* _tmp5_;
	ValaCodeContext* _tmp6_;
	gboolean _tmp7_;
	ValaSymbol* old_symbol = NULL;
	ValaCodeContext* _tmp8_;
	ValaSemanticAnalyzer* _tmp9_;
	ValaSemanticAnalyzer* _tmp10_;
	ValaSymbol* _tmp11_;
	ValaSymbol* _tmp12_;
	ValaSymbol* _tmp13_;
	ValaCodeContext* _tmp14_;
	ValaSemanticAnalyzer* _tmp15_;
	ValaSemanticAnalyzer* _tmp16_;
	gboolean _tmp17_ = FALSE;
	gboolean _tmp18_;
	ValaProperty* _tmp26_;
	ValaProperty* _tmp27_;
	ValaSourceFileType _tmp28_;
	ValaSourceFileType _tmp29_;
	gboolean _tmp85_ = FALSE;
	gboolean _tmp86_ = FALSE;
	gboolean _tmp87_ = FALSE;
	ValaProperty* _tmp88_;
	ValaProperty* _tmp89_;
	gboolean _tmp90_;
	gboolean _tmp91_;
	ValaBlock* _tmp110_;
	ValaBlock* _tmp111_;
	ValaCodeContext* _tmp149_;
	ValaSemanticAnalyzer* _tmp150_;
	ValaSemanticAnalyzer* _tmp151_;
	ValaSymbol* _tmp152_;
	gboolean _tmp153_;
	gboolean _tmp154_;
	self = (ValaPropertyAccessor*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_property_accessor_get_value_type (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = context;
	_tmp7_ = vala_code_node_check ((ValaCodeNode*) _tmp5_, _tmp6_);
	if (!_tmp7_) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	_tmp8_ = context;
	_tmp9_ = vala_code_context_get_analyzer (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_semantic_analyzer_get_current_symbol (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = _vala_code_node_ref0 (_tmp12_);
	old_symbol = _tmp13_;
	_tmp14_ = context;
	_tmp15_ = vala_code_context_get_analyzer (_tmp14_);
	_tmp16_ = _tmp15_;
	vala_semantic_analyzer_set_current_symbol (_tmp16_, (ValaSymbol*) self);
	_tmp18_ = self->priv->_writable;
	if (_tmp18_) {
		_tmp17_ = TRUE;
	} else {
		gboolean _tmp19_;
		_tmp19_ = self->priv->_construction;
		_tmp17_ = _tmp19_;
	}
	if (_tmp17_) {
		ValaDataType* _tmp20_;
		ValaDataType* _tmp21_;
		ValaSourceReference* _tmp22_;
		ValaSourceReference* _tmp23_;
		ValaParameter* _tmp24_;
		ValaParameter* _tmp25_;
		_tmp20_ = vala_property_accessor_get_value_type (self);
		_tmp21_ = _tmp20_;
		_tmp22_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp23_ = _tmp22_;
		_tmp24_ = vala_parameter_new ("value", _tmp21_, _tmp23_);
		_tmp25_ = _tmp24_;
		vala_property_accessor_set_value_parameter (self, _tmp25_);
		_vala_code_node_unref0 (_tmp25_);
	}
	_tmp26_ = vala_property_accessor_get_prop (self);
	_tmp27_ = _tmp26_;
	_tmp28_ = vala_symbol_get_source_type ((ValaSymbol*) _tmp27_);
	_tmp29_ = _tmp28_;
	if (_tmp29_ == VALA_SOURCE_FILE_TYPE_SOURCE) {
		gboolean _tmp30_ = FALSE;
		gboolean _tmp31_ = FALSE;
		ValaBlock* _tmp32_;
		ValaBlock* _tmp33_;
		_tmp32_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp33_ = _tmp32_;
		if (_tmp33_ == NULL) {
			ValaProperty* _tmp34_;
			ValaProperty* _tmp35_;
			gboolean _tmp36_;
			gboolean _tmp37_;
			_tmp34_ = vala_property_accessor_get_prop (self);
			_tmp35_ = _tmp34_;
			_tmp36_ = vala_property_get_interface_only (_tmp35_);
			_tmp37_ = _tmp36_;
			_tmp31_ = !_tmp37_;
		} else {
			_tmp31_ = FALSE;
		}
		if (_tmp31_) {
			ValaProperty* _tmp38_;
			ValaProperty* _tmp39_;
			gboolean _tmp40_;
			gboolean _tmp41_;
			_tmp38_ = vala_property_accessor_get_prop (self);
			_tmp39_ = _tmp38_;
			_tmp40_ = vala_property_get_is_abstract (_tmp39_);
			_tmp41_ = _tmp40_;
			_tmp30_ = !_tmp41_;
		} else {
			_tmp30_ = FALSE;
		}
		if (_tmp30_) {
			ValaSourceReference* _tmp42_;
			ValaSourceReference* _tmp43_;
			ValaBlock* _tmp44_;
			ValaBlock* _tmp45_;
			ValaMemberAccess* ma = NULL;
			ValaProperty* _tmp46_;
			ValaProperty* _tmp47_;
			const gchar* _tmp48_;
			const gchar* _tmp49_;
			gchar* _tmp50_;
			gchar* _tmp51_;
			ValaSourceReference* _tmp52_;
			ValaSourceReference* _tmp53_;
			ValaMemberAccess* _tmp54_;
			ValaMemberAccess* _tmp55_;
			gboolean _tmp56_;
			vala_property_accessor_set_automatic_body (self, TRUE);
			_tmp42_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp43_ = _tmp42_;
			_tmp44_ = vala_block_new (_tmp43_);
			_tmp45_ = _tmp44_;
			vala_subroutine_set_body ((ValaSubroutine*) self, _tmp45_);
			_vala_code_node_unref0 (_tmp45_);
			_tmp46_ = vala_property_accessor_get_prop (self);
			_tmp47_ = _tmp46_;
			_tmp48_ = vala_symbol_get_name ((ValaSymbol*) _tmp47_);
			_tmp49_ = _tmp48_;
			_tmp50_ = g_strdup_printf ("_%s", _tmp49_);
			_tmp51_ = _tmp50_;
			_tmp52_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp53_ = _tmp52_;
			_tmp54_ = vala_member_access_new_simple (_tmp51_, _tmp53_);
			_tmp55_ = _tmp54_;
			_g_free0 (_tmp51_);
			ma = _tmp55_;
			_tmp56_ = self->priv->_readable;
			if (_tmp56_) {
				ValaBlock* _tmp57_;
				ValaBlock* _tmp58_;
				ValaMemberAccess* _tmp59_;
				ValaSourceReference* _tmp60_;
				ValaSourceReference* _tmp61_;
				ValaReturnStatement* _tmp62_;
				ValaReturnStatement* _tmp63_;
				_tmp57_ = vala_subroutine_get_body ((ValaSubroutine*) self);
				_tmp58_ = _tmp57_;
				_tmp59_ = ma;
				_tmp60_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp61_ = _tmp60_;
				_tmp62_ = vala_return_statement_new ((ValaExpression*) _tmp59_, _tmp61_);
				_tmp63_ = _tmp62_;
				vala_block_add_statement (_tmp58_, (ValaStatement*) _tmp63_);
				_vala_code_node_unref0 (_tmp63_);
			} else {
				ValaExpression* value = NULL;
				ValaSourceReference* _tmp64_;
				ValaSourceReference* _tmp65_;
				ValaMemberAccess* _tmp66_;
				ValaDataType* _tmp67_;
				ValaDataType* _tmp68_;
				gboolean _tmp69_;
				gboolean _tmp70_;
				ValaAssignment* assignment = NULL;
				ValaMemberAccess* _tmp75_;
				ValaExpression* _tmp76_;
				ValaSourceReference* _tmp77_;
				ValaSourceReference* _tmp78_;
				ValaAssignment* _tmp79_;
				ValaBlock* _tmp80_;
				ValaBlock* _tmp81_;
				ValaAssignment* _tmp82_;
				ValaExpressionStatement* _tmp83_;
				ValaExpressionStatement* _tmp84_;
				_tmp64_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp65_ = _tmp64_;
				_tmp66_ = vala_member_access_new_simple ("value", _tmp65_);
				value = (ValaExpression*) _tmp66_;
				_tmp67_ = vala_property_accessor_get_value_type (self);
				_tmp68_ = _tmp67_;
				_tmp69_ = vala_data_type_get_value_owned (_tmp68_);
				_tmp70_ = _tmp69_;
				if (_tmp70_) {
					ValaExpression* _tmp71_;
					ValaSourceReference* _tmp72_;
					ValaSourceReference* _tmp73_;
					ValaReferenceTransferExpression* _tmp74_;
					_tmp71_ = value;
					_tmp72_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp73_ = _tmp72_;
					_tmp74_ = vala_reference_transfer_expression_new (_tmp71_, _tmp73_);
					_vala_code_node_unref0 (value);
					value = (ValaExpression*) _tmp74_;
				}
				_tmp75_ = ma;
				_tmp76_ = value;
				_tmp77_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp78_ = _tmp77_;
				_tmp79_ = vala_assignment_new ((ValaExpression*) _tmp75_, _tmp76_, VALA_ASSIGNMENT_OPERATOR_SIMPLE, _tmp78_);
				assignment = _tmp79_;
				_tmp80_ = vala_subroutine_get_body ((ValaSubroutine*) self);
				_tmp81_ = _tmp80_;
				_tmp82_ = assignment;
				_tmp83_ = vala_expression_statement_new ((ValaExpression*) _tmp82_, NULL);
				_tmp84_ = _tmp83_;
				vala_block_add_statement (_tmp81_, (ValaStatement*) _tmp84_);
				_vala_code_node_unref0 (_tmp84_);
				_vala_code_node_unref0 (assignment);
				_vala_code_node_unref0 (value);
			}
			_vala_code_node_unref0 (ma);
		}
	}
	_tmp88_ = vala_property_accessor_get_prop (self);
	_tmp89_ = _tmp88_;
	_tmp90_ = vala_property_get_is_abstract (_tmp89_);
	_tmp91_ = _tmp90_;
	if (_tmp91_) {
		_tmp87_ = TRUE;
	} else {
		ValaProperty* _tmp92_;
		ValaProperty* _tmp93_;
		gboolean _tmp94_;
		gboolean _tmp95_;
		_tmp92_ = vala_property_accessor_get_prop (self);
		_tmp93_ = _tmp92_;
		_tmp94_ = vala_property_get_is_virtual (_tmp93_);
		_tmp95_ = _tmp94_;
		_tmp87_ = _tmp95_;
	}
	if (_tmp87_) {
		_tmp86_ = TRUE;
	} else {
		ValaProperty* _tmp96_;
		ValaProperty* _tmp97_;
		gboolean _tmp98_;
		gboolean _tmp99_;
		_tmp96_ = vala_property_accessor_get_prop (self);
		_tmp97_ = _tmp96_;
		_tmp98_ = vala_property_get_overrides (_tmp97_);
		_tmp99_ = _tmp98_;
		_tmp86_ = _tmp99_;
	}
	if (_tmp86_) {
		ValaSymbolAccessibility _tmp100_;
		ValaSymbolAccessibility _tmp101_;
		_tmp100_ = vala_symbol_get_access ((ValaSymbol*) self);
		_tmp101_ = _tmp100_;
		_tmp85_ = _tmp101_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE;
	} else {
		_tmp85_ = FALSE;
	}
	if (_tmp85_) {
		ValaSourceReference* _tmp102_;
		ValaSourceReference* _tmp103_;
		ValaProperty* _tmp104_;
		ValaProperty* _tmp105_;
		gchar* _tmp106_;
		gchar* _tmp107_;
		gchar* _tmp108_;
		gchar* _tmp109_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp102_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp103_ = _tmp102_;
		_tmp104_ = vala_property_accessor_get_prop (self);
		_tmp105_ = _tmp104_;
		_tmp106_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp105_);
		_tmp107_ = _tmp106_;
		_tmp108_ = g_strdup_printf ("Property `%s' with private accessor cannot be marked as abstract, virt" \
"ual or override", _tmp107_);
		_tmp109_ = _tmp108_;
		vala_report_error (_tmp103_, _tmp109_);
		_g_free0 (_tmp109_);
		_g_free0 (_tmp107_);
		result = FALSE;
		_vala_code_node_unref0 (old_symbol);
		return result;
	}
	_tmp110_ = vala_subroutine_get_body ((ValaSubroutine*) self);
	_tmp111_ = _tmp110_;
	if (_tmp111_ != NULL) {
		gboolean _tmp112_ = FALSE;
		gboolean _tmp113_;
		ValaBlock* _tmp123_;
		ValaBlock* _tmp124_;
		ValaCodeContext* _tmp125_;
		_tmp113_ = self->priv->_writable;
		if (_tmp113_) {
			_tmp112_ = TRUE;
		} else {
			gboolean _tmp114_;
			_tmp114_ = self->priv->_construction;
			_tmp112_ = _tmp114_;
		}
		if (_tmp112_) {
			ValaBlock* _tmp115_;
			ValaBlock* _tmp116_;
			ValaScope* _tmp117_;
			ValaScope* _tmp118_;
			ValaParameter* _tmp119_;
			const gchar* _tmp120_;
			const gchar* _tmp121_;
			ValaParameter* _tmp122_;
			_tmp115_ = vala_subroutine_get_body ((ValaSubroutine*) self);
			_tmp116_ = _tmp115_;
			_tmp117_ = vala_symbol_get_scope ((ValaSymbol*) _tmp116_);
			_tmp118_ = _tmp117_;
			_tmp119_ = self->priv->_value_parameter;
			_tmp120_ = vala_symbol_get_name ((ValaSymbol*) _tmp119_);
			_tmp121_ = _tmp120_;
			_tmp122_ = self->priv->_value_parameter;
			vala_scope_add (_tmp118_, _tmp121_, (ValaSymbol*) _tmp122_);
		}
		_tmp123_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp124_ = _tmp123_;
		_tmp125_ = context;
		vala_code_node_check ((ValaCodeNode*) _tmp124_, _tmp125_);
		{
			ValaList* _body_error_type_list = NULL;
			ValaBlock* _tmp126_;
			ValaBlock* _tmp127_;
			ValaList* _tmp128_;
			gint _body_error_type_size = 0;
			ValaList* _tmp129_;
			gint _tmp130_;
			gint _tmp131_;
			gint _body_error_type_index = 0;
			_tmp126_ = vala_subroutine_get_body ((ValaSubroutine*) self);
			_tmp127_ = _tmp126_;
			_tmp128_ = vala_code_node_get_error_types ((ValaCodeNode*) _tmp127_);
			_body_error_type_list = _tmp128_;
			_tmp129_ = _body_error_type_list;
			_tmp130_ = vala_collection_get_size ((ValaCollection*) _tmp129_);
			_tmp131_ = _tmp130_;
			_body_error_type_size = _tmp131_;
			_body_error_type_index = -1;
			while (TRUE) {
				gint _tmp132_;
				gint _tmp133_;
				gint _tmp134_;
				ValaDataType* body_error_type = NULL;
				ValaList* _tmp135_;
				gint _tmp136_;
				gpointer _tmp137_;
				ValaDataType* _tmp138_;
				gboolean _tmp139_;
				gboolean _tmp140_;
				_tmp132_ = _body_error_type_index;
				_body_error_type_index = _tmp132_ + 1;
				_tmp133_ = _body_error_type_index;
				_tmp134_ = _body_error_type_size;
				if (!(_tmp133_ < _tmp134_)) {
					break;
				}
				_tmp135_ = _body_error_type_list;
				_tmp136_ = _body_error_type_index;
				_tmp137_ = vala_list_get (_tmp135_, _tmp136_);
				body_error_type = (ValaDataType*) _tmp137_;
				_tmp138_ = body_error_type;
				_tmp139_ = vala_error_type_get_dynamic_error (G_TYPE_CHECK_INSTANCE_CAST (_tmp138_, VALA_TYPE_ERROR_TYPE, ValaErrorType));
				_tmp140_ = _tmp139_;
				if (!_tmp140_) {
					ValaDataType* _tmp141_;
					ValaSourceReference* _tmp142_;
					ValaSourceReference* _tmp143_;
					ValaDataType* _tmp144_;
					gchar* _tmp145_;
					gchar* _tmp146_;
					gchar* _tmp147_;
					gchar* _tmp148_;
					_tmp141_ = body_error_type;
					_tmp142_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp141_);
					_tmp143_ = _tmp142_;
					_tmp144_ = body_error_type;
					_tmp145_ = vala_code_node_to_string ((ValaCodeNode*) _tmp144_);
					_tmp146_ = _tmp145_;
					_tmp147_ = g_strdup_printf ("unhandled error `%s'", _tmp146_);
					_tmp148_ = _tmp147_;
					vala_report_warning (_tmp143_, _tmp148_);
					_g_free0 (_tmp148_);
					_g_free0 (_tmp146_);
				}
				_vala_code_node_unref0 (body_error_type);
			}
			_vala_iterable_unref0 (_body_error_type_list);
		}
	}
	_tmp149_ = context;
	_tmp150_ = vala_code_context_get_analyzer (_tmp149_);
	_tmp151_ = _tmp150_;
	_tmp152_ = old_symbol;
	vala_semantic_analyzer_set_current_symbol (_tmp151_, _tmp152_);
	_tmp153_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp154_ = _tmp153_;
	result = !_tmp154_;
	_vala_code_node_unref0 (old_symbol);
	return result;
}


static void vala_property_accessor_real_replace_type (ValaCodeNode* base, ValaDataType* old_type, ValaDataType* new_type) {
	ValaPropertyAccessor * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaDataType* _tmp2_;
	self = (ValaPropertyAccessor*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	_tmp0_ = vala_property_accessor_get_value_type (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = old_type;
	if (_tmp1_ == _tmp2_) {
		ValaDataType* _tmp3_;
		_tmp3_ = new_type;
		vala_property_accessor_set_value_type (self, _tmp3_);
	}
}


ValaProperty* vala_property_accessor_get_prop (ValaPropertyAccessor* self) {
	ValaProperty* result;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
	_tmp1_ = _tmp0_;
	result = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, VALA_TYPE_PROPERTY) ? ((ValaProperty*) _tmp1_) : NULL;
	return result;
}


ValaDataType* vala_property_accessor_get_value_type (ValaPropertyAccessor* self) {
	ValaDataType* result;
	ValaDataType* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_value_type;
	result = _tmp0_;
	return result;
}


static void vala_property_accessor_set_value_type (ValaPropertyAccessor* self, ValaDataType* value) {
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaDataType* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _vala_code_node_ref0 (_tmp0_);
	_vala_code_node_unref0 (self->priv->_value_type);
	self->priv->_value_type = _tmp1_;
	_tmp2_ = value;
	if (_tmp2_ != NULL) {
		ValaDataType* _tmp3_;
		_tmp3_ = self->priv->_value_type;
		vala_code_node_set_parent_node ((ValaCodeNode*) _tmp3_, (ValaCodeNode*) self);
	}
}


gboolean vala_property_accessor_get_readable (ValaPropertyAccessor* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_readable;
	result = _tmp0_;
	return result;
}


static void vala_property_accessor_set_readable (ValaPropertyAccessor* self, gboolean value) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_readable = _tmp0_;
}


gboolean vala_property_accessor_get_writable (ValaPropertyAccessor* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_writable;
	result = _tmp0_;
	return result;
}


static void vala_property_accessor_set_writable (ValaPropertyAccessor* self, gboolean value) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_writable = _tmp0_;
}


gboolean vala_property_accessor_get_construction (ValaPropertyAccessor* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_construction;
	result = _tmp0_;
	return result;
}


static void vala_property_accessor_set_construction (ValaPropertyAccessor* self, gboolean value) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_construction = _tmp0_;
}


gboolean vala_property_accessor_get_automatic_body (ValaPropertyAccessor* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_automatic_body;
	result = _tmp0_;
	return result;
}


static void vala_property_accessor_set_automatic_body (ValaPropertyAccessor* self, gboolean value) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_automatic_body = _tmp0_;
}


static gboolean vala_property_accessor_real_get_has_result (ValaSubroutine* base) {
	gboolean result;
	ValaPropertyAccessor* self;
	gboolean _tmp0_;
	self = (ValaPropertyAccessor*) base;
	_tmp0_ = self->priv->_readable;
	result = _tmp0_;
	return result;
}


ValaParameter* vala_property_accessor_get_value_parameter (ValaPropertyAccessor* self) {
	ValaParameter* result;
	ValaParameter* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_value_parameter;
	result = _tmp0_;
	return result;
}


static void vala_property_accessor_set_value_parameter (ValaPropertyAccessor* self, ValaParameter* value) {
	ValaParameter* _tmp0_;
	ValaParameter* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _vala_code_node_ref0 (_tmp0_);
	_vala_code_node_unref0 (self->priv->_value_parameter);
	self->priv->_value_parameter = _tmp1_;
}


static void vala_property_accessor_class_init (ValaPropertyAccessorClass * klass) {
	vala_property_accessor_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_property_accessor_finalize;
	g_type_class_add_private (klass, sizeof (ValaPropertyAccessorPrivate));
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_property_accessor_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_property_accessor_real_accept_children;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode *, ValaCodeContext*)) vala_property_accessor_real_check;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode *, ValaDataType*, ValaDataType*)) vala_property_accessor_real_replace_type;
	VALA_SUBROUTINE_CLASS (klass)->get_has_result = vala_property_accessor_real_get_has_result;
}


static void vala_property_accessor_instance_init (ValaPropertyAccessor * self) {
	self->priv = VALA_PROPERTY_ACCESSOR_GET_PRIVATE (self);
}


static void vala_property_accessor_finalize (ValaCodeNode * obj) {
	ValaPropertyAccessor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_PROPERTY_ACCESSOR, ValaPropertyAccessor);
	_vala_code_node_unref0 (self->priv->_value_parameter);
	_vala_code_node_unref0 (self->priv->_value_type);
	VALA_CODE_NODE_CLASS (vala_property_accessor_parent_class)->finalize (obj);
}


/**
 * Represents a get or set accessor of a property in the source code.
 */
GType vala_property_accessor_get_type (void) {
	static volatile gsize vala_property_accessor_type_id__volatile = 0;
	if (g_once_init_enter (&vala_property_accessor_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaPropertyAccessorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_property_accessor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaPropertyAccessor), 0, (GInstanceInitFunc) vala_property_accessor_instance_init, NULL };
		GType vala_property_accessor_type_id;
		vala_property_accessor_type_id = g_type_register_static (VALA_TYPE_SUBROUTINE, "ValaPropertyAccessor", &g_define_type_info, 0);
		g_once_init_leave (&vala_property_accessor_type_id__volatile, vala_property_accessor_type_id);
	}
	return vala_property_accessor_type_id__volatile;
}



