; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --filter-out "\b(sp)\b" --filter "^\s*(ld[^r]|st|swp|cas|bl|add|and|eor|orn|orr|sub|mvn|sxt|cmp|ccmp|csel|dmb)"
; The base test file was generated by ./llvm/test/CodeGen/AArch64/Atomics/generate-tests.py
; RUN: llc %s -o - -verify-machineinstrs -mtriple=aarch64_be -mattr=+v8.1a -O0 | FileCheck %s --check-prefixes=CHECK,-O0
; RUN: llc %s -o - -verify-machineinstrs -mtriple=aarch64_be -mattr=+v8.1a -O1 | FileCheck %s --check-prefixes=CHECK,-O1

define dso_local void @store_atomic_i8_aligned_unordered(i8 %value, ptr %ptr) {
; CHECK-LABEL: store_atomic_i8_aligned_unordered:
; CHECK:    strb w0, [x1]
    store atomic i8 %value, ptr %ptr unordered, align 1
    ret void
}

define dso_local void @store_atomic_i8_aligned_monotonic(i8 %value, ptr %ptr) {
; CHECK-LABEL: store_atomic_i8_aligned_monotonic:
; CHECK:    strb w0, [x1]
    store atomic i8 %value, ptr %ptr monotonic, align 1
    ret void
}

define dso_local void @store_atomic_i8_aligned_release(i8 %value, ptr %ptr) {
; CHECK-LABEL: store_atomic_i8_aligned_release:
; CHECK:    stlrb w0, [x1]
    store atomic i8 %value, ptr %ptr release, align 1
    ret void
}

define dso_local void @store_atomic_i8_aligned_seq_cst(i8 %value, ptr %ptr) {
; CHECK-LABEL: store_atomic_i8_aligned_seq_cst:
; CHECK:    stlrb w0, [x1]
    store atomic i8 %value, ptr %ptr seq_cst, align 1
    ret void
}

define dso_local void @store_atomic_i16_aligned_unordered(i16 %value, ptr %ptr) {
; CHECK-LABEL: store_atomic_i16_aligned_unordered:
; CHECK:    strh w0, [x1]
    store atomic i16 %value, ptr %ptr unordered, align 2
    ret void
}

define dso_local void @store_atomic_i16_aligned_monotonic(i16 %value, ptr %ptr) {
; CHECK-LABEL: store_atomic_i16_aligned_monotonic:
; CHECK:    strh w0, [x1]
    store atomic i16 %value, ptr %ptr monotonic, align 2
    ret void
}

define dso_local void @store_atomic_i16_aligned_release(i16 %value, ptr %ptr) {
; CHECK-LABEL: store_atomic_i16_aligned_release:
; CHECK:    stlrh w0, [x1]
    store atomic i16 %value, ptr %ptr release, align 2
    ret void
}

define dso_local void @store_atomic_i16_aligned_seq_cst(i16 %value, ptr %ptr) {
; CHECK-LABEL: store_atomic_i16_aligned_seq_cst:
; CHECK:    stlrh w0, [x1]
    store atomic i16 %value, ptr %ptr seq_cst, align 2
    ret void
}

define dso_local void @store_atomic_i32_aligned_unordered(i32 %value, ptr %ptr) {
; CHECK-LABEL: store_atomic_i32_aligned_unordered:
; CHECK:    str w0, [x1]
    store atomic i32 %value, ptr %ptr unordered, align 4
    ret void
}

define dso_local void @store_atomic_i32_aligned_monotonic(i32 %value, ptr %ptr) {
; CHECK-LABEL: store_atomic_i32_aligned_monotonic:
; CHECK:    str w0, [x1]
    store atomic i32 %value, ptr %ptr monotonic, align 4
    ret void
}

define dso_local void @store_atomic_i32_aligned_release(i32 %value, ptr %ptr) {
; CHECK-LABEL: store_atomic_i32_aligned_release:
; CHECK:    stlr w0, [x1]
    store atomic i32 %value, ptr %ptr release, align 4
    ret void
}

define dso_local void @store_atomic_i32_aligned_seq_cst(i32 %value, ptr %ptr) {
; CHECK-LABEL: store_atomic_i32_aligned_seq_cst:
; CHECK:    stlr w0, [x1]
    store atomic i32 %value, ptr %ptr seq_cst, align 4
    ret void
}

define dso_local void @store_atomic_i64_aligned_unordered(i64 %value, ptr %ptr) {
; CHECK-LABEL: store_atomic_i64_aligned_unordered:
; CHECK:    str x0, [x1]
    store atomic i64 %value, ptr %ptr unordered, align 8
    ret void
}

define dso_local void @store_atomic_i64_aligned_monotonic(i64 %value, ptr %ptr) {
; CHECK-LABEL: store_atomic_i64_aligned_monotonic:
; CHECK:    str x0, [x1]
    store atomic i64 %value, ptr %ptr monotonic, align 8
    ret void
}

define dso_local void @store_atomic_i64_aligned_release(i64 %value, ptr %ptr) {
; CHECK-LABEL: store_atomic_i64_aligned_release:
; CHECK:    stlr x0, [x1]
    store atomic i64 %value, ptr %ptr release, align 8
    ret void
}

define dso_local void @store_atomic_i64_aligned_seq_cst(i64 %value, ptr %ptr) {
; CHECK-LABEL: store_atomic_i64_aligned_seq_cst:
; CHECK:    stlr x0, [x1]
    store atomic i64 %value, ptr %ptr seq_cst, align 8
    ret void
}

define dso_local void @store_atomic_i128_aligned_unordered(i128 %value, ptr %ptr) {
; -O0-LABEL: store_atomic_i128_aligned_unordered:
; -O0:    casp x0, x1, x2, x3, [x8]
; -O0:    subs x11, x9, x11
; -O0:    ccmp x8, x10, #0, eq
;
; -O1-LABEL: store_atomic_i128_aligned_unordered:
; -O1:    ldp x4, x5, [x2]
; -O1:    casp x6, x7, x0, x1, [x2]
; -O1:    cmp x6, x4
; -O1:    ccmp x7, x5, #0, eq
    store atomic i128 %value, ptr %ptr unordered, align 16
    ret void
}

define dso_local void @store_atomic_i128_aligned_monotonic(i128 %value, ptr %ptr) {
; -O0-LABEL: store_atomic_i128_aligned_monotonic:
; -O0:    casp x0, x1, x2, x3, [x8]
; -O0:    subs x11, x9, x11
; -O0:    ccmp x8, x10, #0, eq
;
; -O1-LABEL: store_atomic_i128_aligned_monotonic:
; -O1:    ldp x4, x5, [x2]
; -O1:    casp x6, x7, x0, x1, [x2]
; -O1:    cmp x6, x4
; -O1:    ccmp x7, x5, #0, eq
    store atomic i128 %value, ptr %ptr monotonic, align 16
    ret void
}

define dso_local void @store_atomic_i128_aligned_release(i128 %value, ptr %ptr) {
; -O0-LABEL: store_atomic_i128_aligned_release:
; -O0:    caspl x0, x1, x2, x3, [x8]
; -O0:    subs x11, x9, x11
; -O0:    ccmp x8, x10, #0, eq
;
; -O1-LABEL: store_atomic_i128_aligned_release:
; -O1:    ldp x4, x5, [x2]
; -O1:    caspl x6, x7, x0, x1, [x2]
; -O1:    cmp x6, x4
; -O1:    ccmp x7, x5, #0, eq
    store atomic i128 %value, ptr %ptr release, align 16
    ret void
}

define dso_local void @store_atomic_i128_aligned_seq_cst(i128 %value, ptr %ptr) {
; -O0-LABEL: store_atomic_i128_aligned_seq_cst:
; -O0:    caspal x0, x1, x2, x3, [x8]
; -O0:    subs x11, x9, x11
; -O0:    ccmp x8, x10, #0, eq
;
; -O1-LABEL: store_atomic_i128_aligned_seq_cst:
; -O1:    ldp x4, x5, [x2]
; -O1:    caspal x6, x7, x0, x1, [x2]
; -O1:    cmp x6, x4
; -O1:    ccmp x7, x5, #0, eq
    store atomic i128 %value, ptr %ptr seq_cst, align 16
    ret void
}

define dso_local void @store_atomic_i8_unaligned_unordered(i8 %value, ptr %ptr) {
; CHECK-LABEL: store_atomic_i8_unaligned_unordered:
; CHECK:    strb w0, [x1]
    store atomic i8 %value, ptr %ptr unordered, align 1
    ret void
}

define dso_local void @store_atomic_i8_unaligned_monotonic(i8 %value, ptr %ptr) {
; CHECK-LABEL: store_atomic_i8_unaligned_monotonic:
; CHECK:    strb w0, [x1]
    store atomic i8 %value, ptr %ptr monotonic, align 1
    ret void
}

define dso_local void @store_atomic_i8_unaligned_release(i8 %value, ptr %ptr) {
; CHECK-LABEL: store_atomic_i8_unaligned_release:
; CHECK:    stlrb w0, [x1]
    store atomic i8 %value, ptr %ptr release, align 1
    ret void
}

define dso_local void @store_atomic_i8_unaligned_seq_cst(i8 %value, ptr %ptr) {
; CHECK-LABEL: store_atomic_i8_unaligned_seq_cst:
; CHECK:    stlrb w0, [x1]
    store atomic i8 %value, ptr %ptr seq_cst, align 1
    ret void
}

define dso_local void @store_atomic_i16_unaligned_unordered(i16 %value, ptr %ptr) {
; CHECK-LABEL: store_atomic_i16_unaligned_unordered:
; CHECK:    bl __atomic_store
    store atomic i16 %value, ptr %ptr unordered, align 1
    ret void
}

define dso_local void @store_atomic_i16_unaligned_monotonic(i16 %value, ptr %ptr) {
; CHECK-LABEL: store_atomic_i16_unaligned_monotonic:
; CHECK:    bl __atomic_store
    store atomic i16 %value, ptr %ptr monotonic, align 1
    ret void
}

define dso_local void @store_atomic_i16_unaligned_release(i16 %value, ptr %ptr) {
; CHECK-LABEL: store_atomic_i16_unaligned_release:
; CHECK:    bl __atomic_store
    store atomic i16 %value, ptr %ptr release, align 1
    ret void
}

define dso_local void @store_atomic_i16_unaligned_seq_cst(i16 %value, ptr %ptr) {
; CHECK-LABEL: store_atomic_i16_unaligned_seq_cst:
; CHECK:    bl __atomic_store
    store atomic i16 %value, ptr %ptr seq_cst, align 1
    ret void
}

define dso_local void @store_atomic_i32_unaligned_unordered(i32 %value, ptr %ptr) {
; CHECK-LABEL: store_atomic_i32_unaligned_unordered:
; CHECK:    bl __atomic_store
    store atomic i32 %value, ptr %ptr unordered, align 1
    ret void
}

define dso_local void @store_atomic_i32_unaligned_monotonic(i32 %value, ptr %ptr) {
; CHECK-LABEL: store_atomic_i32_unaligned_monotonic:
; CHECK:    bl __atomic_store
    store atomic i32 %value, ptr %ptr monotonic, align 1
    ret void
}

define dso_local void @store_atomic_i32_unaligned_release(i32 %value, ptr %ptr) {
; CHECK-LABEL: store_atomic_i32_unaligned_release:
; CHECK:    bl __atomic_store
    store atomic i32 %value, ptr %ptr release, align 1
    ret void
}

define dso_local void @store_atomic_i32_unaligned_seq_cst(i32 %value, ptr %ptr) {
; CHECK-LABEL: store_atomic_i32_unaligned_seq_cst:
; CHECK:    bl __atomic_store
    store atomic i32 %value, ptr %ptr seq_cst, align 1
    ret void
}

define dso_local void @store_atomic_i64_unaligned_unordered(i64 %value, ptr %ptr) {
; CHECK-LABEL: store_atomic_i64_unaligned_unordered:
; CHECK:    bl __atomic_store
    store atomic i64 %value, ptr %ptr unordered, align 1
    ret void
}

define dso_local void @store_atomic_i64_unaligned_monotonic(i64 %value, ptr %ptr) {
; CHECK-LABEL: store_atomic_i64_unaligned_monotonic:
; CHECK:    bl __atomic_store
    store atomic i64 %value, ptr %ptr monotonic, align 1
    ret void
}

define dso_local void @store_atomic_i64_unaligned_release(i64 %value, ptr %ptr) {
; CHECK-LABEL: store_atomic_i64_unaligned_release:
; CHECK:    bl __atomic_store
    store atomic i64 %value, ptr %ptr release, align 1
    ret void
}

define dso_local void @store_atomic_i64_unaligned_seq_cst(i64 %value, ptr %ptr) {
; CHECK-LABEL: store_atomic_i64_unaligned_seq_cst:
; CHECK:    bl __atomic_store
    store atomic i64 %value, ptr %ptr seq_cst, align 1
    ret void
}

define dso_local void @store_atomic_i128_unaligned_unordered(i128 %value, ptr %ptr) {
; CHECK-LABEL: store_atomic_i128_unaligned_unordered:
; CHECK:    bl __atomic_store
    store atomic i128 %value, ptr %ptr unordered, align 1
    ret void
}

define dso_local void @store_atomic_i128_unaligned_monotonic(i128 %value, ptr %ptr) {
; CHECK-LABEL: store_atomic_i128_unaligned_monotonic:
; CHECK:    bl __atomic_store
    store atomic i128 %value, ptr %ptr monotonic, align 1
    ret void
}

define dso_local void @store_atomic_i128_unaligned_release(i128 %value, ptr %ptr) {
; CHECK-LABEL: store_atomic_i128_unaligned_release:
; CHECK:    bl __atomic_store
    store atomic i128 %value, ptr %ptr release, align 1
    ret void
}

define dso_local void @store_atomic_i128_unaligned_seq_cst(i128 %value, ptr %ptr) {
; CHECK-LABEL: store_atomic_i128_unaligned_seq_cst:
; CHECK:    bl __atomic_store
    store atomic i128 %value, ptr %ptr seq_cst, align 1
    ret void
}
