; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -mattr=+sme2,+fp8 -enable-subreg-liveness --force-streaming < %s | FileCheck %s

target triple = "aarch64-linux"

define { <vscale x 16 x i8>, <vscale x 16 x i8> } @cvtn_f16_tuple(i64 %stride, ptr %ptr) {
; CHECK-LABEL: cvtn_f16_tuple:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    str x29, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    addvl sp, sp, #-3
; CHECK-NEXT:    str p8, [sp, #7, mul vl] // 2-byte Folded Spill
; CHECK-NEXT:    str z11, [sp, #1, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z10, [sp, #2, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    .cfi_escape 0x0f, 0x0c, 0x8f, 0x00, 0x11, 0x10, 0x22, 0x11, 0x18, 0x92, 0x2e, 0x00, 0x1e, 0x22 // sp + 16 + 24 * VG
; CHECK-NEXT:    .cfi_offset w29, -16
; CHECK-NEXT:    .cfi_escape 0x10, 0x4a, 0x0a, 0x11, 0x70, 0x22, 0x11, 0x78, 0x92, 0x2e, 0x00, 0x1e, 0x22 // $d10 @ cfa - 16 - 8 * VG
; CHECK-NEXT:    .cfi_escape 0x10, 0x4b, 0x0a, 0x11, 0x70, 0x22, 0x11, 0x70, 0x92, 0x2e, 0x00, 0x1e, 0x22 // $d11 @ cfa - 16 - 16 * VG
; CHECK-NEXT:    ptrue pn8.b
; CHECK-NEXT:    add x8, x1, x0
; CHECK-NEXT:    ld1h { z2.h, z10.h }, pn8/z, [x1]
; CHECK-NEXT:    ld1h { z3.h, z11.h }, pn8/z, [x8]
; CHECK-NEXT:    fcvtn z0.b, { z2.h, z3.h }
; CHECK-NEXT:    fcvtn z1.b, { z10.h, z11.h }
; CHECK-NEXT:    ldr z11, [sp, #1, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z10, [sp, #2, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr p8, [sp, #7, mul vl] // 2-byte Folded Reload
; CHECK-NEXT:    addvl sp, sp, #3
; CHECK-NEXT:    ldr x29, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
entry:
    %0 = tail call target("aarch64.svcount") @llvm.aarch64.sve.ptrue.c8()
    %1 = tail call { <vscale x 8 x half>, <vscale x 8 x half> } @llvm.aarch64.sve.ld1.pn.x2.nxv4i32(target("aarch64.svcount") %0, ptr %ptr)
    %2 = extractvalue { <vscale x 8 x half>, <vscale x 8 x half> } %1, 0
    %3 = extractvalue { <vscale x 8 x half>, <vscale x 8 x half> } %1, 1
    %arrayidx2 = getelementptr inbounds i8, ptr %ptr, i64 %stride
    %4 = tail call { <vscale x 8 x half>, <vscale x 8 x half> } @llvm.aarch64.sve.ld1.pn.x2.nxv4i32(target("aarch64.svcount") %0, ptr %arrayidx2)
    %5 = extractvalue { <vscale x 8 x half>, <vscale x 8 x half> } %4, 0
    %6 = extractvalue { <vscale x 8 x half>, <vscale x 8 x half> } %4, 1
    %res1 = call <vscale x 16 x i8> @llvm.aarch64.sve.fp8.cvtn.nxv8f16(<vscale x 8 x half> %2, <vscale x 8 x half> %5)
    %res2 = call <vscale x 16 x i8> @llvm.aarch64.sve.fp8.cvtn.nxv8f16(<vscale x 8 x half> %3, <vscale x 8 x half> %6)
    %ins1 = insertvalue { <vscale x 16 x i8>, <vscale x 16 x i8> } poison, <vscale x 16 x i8> %res1, 0
    %ins2 = insertvalue { <vscale x 16 x i8>, <vscale x 16 x i8> } %ins1, <vscale x 16 x i8> %res2, 1
    ret { <vscale x 16 x i8>, <vscale x 16 x i8> } %ins2
}


define { <vscale x 16 x i8>, <vscale x 16 x i8> } @cvtnt_f32_tuple(i64 %stride, ptr %ptr, <vscale x 16 x i8> %d) {
; CHECK-LABEL: cvtnt_f32_tuple:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    str x29, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    addvl sp, sp, #-3
; CHECK-NEXT:    str p8, [sp, #7, mul vl] // 2-byte Folded Spill
; CHECK-NEXT:    str z11, [sp, #1, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    str z10, [sp, #2, mul vl] // 16-byte Folded Spill
; CHECK-NEXT:    .cfi_escape 0x0f, 0x0c, 0x8f, 0x00, 0x11, 0x10, 0x22, 0x11, 0x18, 0x92, 0x2e, 0x00, 0x1e, 0x22 // sp + 16 + 24 * VG
; CHECK-NEXT:    .cfi_offset w29, -16
; CHECK-NEXT:    .cfi_escape 0x10, 0x4a, 0x0a, 0x11, 0x70, 0x22, 0x11, 0x78, 0x92, 0x2e, 0x00, 0x1e, 0x22 // $d10 @ cfa - 16 - 8 * VG
; CHECK-NEXT:    .cfi_escape 0x10, 0x4b, 0x0a, 0x11, 0x70, 0x22, 0x11, 0x70, 0x92, 0x2e, 0x00, 0x1e, 0x22 // $d11 @ cfa - 16 - 16 * VG
; CHECK-NEXT:    ptrue pn8.b
; CHECK-NEXT:    add x8, x1, x0
; CHECK-NEXT:    mov z1.d, z0.d
; CHECK-NEXT:    ld1w { z2.s, z10.s }, pn8/z, [x1]
; CHECK-NEXT:    ld1w { z3.s, z11.s }, pn8/z, [x8]
; CHECK-NEXT:    fcvtnt z0.b, { z2.s, z3.s }
; CHECK-NEXT:    fcvtnt z1.b, { z10.s, z11.s }
; CHECK-NEXT:    ldr z11, [sp, #1, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr z10, [sp, #2, mul vl] // 16-byte Folded Reload
; CHECK-NEXT:    ldr p8, [sp, #7, mul vl] // 2-byte Folded Reload
; CHECK-NEXT:    addvl sp, sp, #3
; CHECK-NEXT:    ldr x29, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
entry:
    %0 = tail call target("aarch64.svcount") @llvm.aarch64.sve.ptrue.c8()
    %1 = tail call { <vscale x 4 x float>, <vscale x 4 x float> } @llvm.aarch64.sve.ld1.pn.x2.nxv4f32(target("aarch64.svcount") %0, ptr %ptr)
    %2 = extractvalue { <vscale x 4 x float>, <vscale x 4 x float> } %1, 0
    %3 = extractvalue { <vscale x 4 x float>, <vscale x 4 x float> } %1, 1
    %arrayidx2 = getelementptr inbounds i8, ptr %ptr, i64 %stride
    %4 = tail call { <vscale x 4 x float>, <vscale x 4 x float> } @llvm.aarch64.sve.ld1.pn.x2.nxv4f32(target("aarch64.svcount") %0, ptr %arrayidx2)
    %5 = extractvalue { <vscale x 4 x float>, <vscale x 4 x float> } %4, 0
    %6 = extractvalue { <vscale x 4 x float>, <vscale x 4 x float> } %4, 1
    %res1 = call <vscale x 16 x i8> @llvm.aarch64.sve.fp8.cvtnt.nxv4f32(<vscale x 16 x i8> %d, <vscale x 4 x float> %2, <vscale x 4 x float> %5)
    %res2 = call <vscale x 16 x i8> @llvm.aarch64.sve.fp8.cvtnt.nxv4f32(<vscale x 16 x i8> %d, <vscale x 4 x float> %3, <vscale x 4 x float> %6)
    %ins1 = insertvalue { <vscale x 16 x i8>, <vscale x 16 x i8> } poison, <vscale x 16 x i8> %res1, 0
    %ins2 = insertvalue { <vscale x 16 x i8>, <vscale x 16 x i8> } %ins1, <vscale x 16 x i8> %res2, 1
    ret { <vscale x 16 x i8>, <vscale x 16 x i8> } %ins2
}
