/*
 * Copyright (C) 2006 Evgeniy Stepanov <eugeni.stepanov@gmail.com>
 *
 * This file is part of libass.
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#ifndef LIBASS_LIBRARY_H
#define LIBASS_LIBRARY_H

#include <stdarg.h>

#include "ass_filesystem.h"

typedef struct {
    char *name;
    char *data;
    int size;
} ASS_Fontdata;

struct ass_library {
    char *fonts_dir;
    int extract_fonts;
    char **style_overrides;

    ASS_Fontdata *fontdata;
    size_t num_fontdata;
    void (*msg_callback)(int, const char *, va_list, void *);
    void *msg_callback_data;
};

char *ass_load_file(struct ass_library *library, const char *fname, FileNameSource hint, size_t *bufsize);

#endif                          /* LIBASS_LIBRARY_H */
