; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -mtriple=aarch64-none-eabi -verify-machineinstrs %s -o - | FileCheck %s --check-prefixes=CHECK,CHECK-SD
; RUN: llc -mtriple=aarch64-none-eabi -global-isel -verify-machineinstrs %s -o - | FileCheck %s --check-prefixes=CHECK,CHECK-GI


define void @v2i8(ptr %p1) {
; CHECK-SD-LABEL: v2i8:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    ldrb w8, [x0]
; CHECK-SD-NEXT:    ldrb w9, [x0, #1]
; CHECK-SD-NEXT:    fmov s0, w8
; CHECK-SD-NEXT:    mov v0.s[1], w9
; CHECK-SD-NEXT:    cnt v0.8b, v0.8b
; CHECK-SD-NEXT:    uaddlp v0.4h, v0.8b
; CHECK-SD-NEXT:    uaddlp v0.2s, v0.4h
; CHECK-SD-NEXT:    mov s1, v0.s[1]
; CHECK-SD-NEXT:    str b0, [x0]
; CHECK-SD-NEXT:    stur b1, [x0, #1]
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: v2i8:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    ldr b0, [x0]
; CHECK-GI-NEXT:    add x8, x0, #1
; CHECK-GI-NEXT:    ld1 { v0.b }[1], [x8]
; CHECK-GI-NEXT:    cnt v0.8b, v0.8b
; CHECK-GI-NEXT:    st1 { v0.b }[0], [x0]
; CHECK-GI-NEXT:    st1 { v0.b }[1], [x8]
; CHECK-GI-NEXT:    ret
entry:
  %d = load <2 x i8>, ptr %p1
  %s = call <2 x i8> @llvm.ctpop(<2 x i8> %d)
  store <2 x i8> %s, ptr %p1
  ret void
}

define void @v3i8(ptr %p1) {
; CHECK-SD-LABEL: v3i8:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    sub sp, sp, #16
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 16
; CHECK-SD-NEXT:    ldr s0, [x0]
; CHECK-SD-NEXT:    zip1 v0.8b, v0.8b, v0.8b
; CHECK-SD-NEXT:    bic v0.4h, #255, lsl #8
; CHECK-SD-NEXT:    cnt v0.8b, v0.8b
; CHECK-SD-NEXT:    uaddlp v0.4h, v0.8b
; CHECK-SD-NEXT:    uzp1 v1.8b, v0.8b, v0.8b
; CHECK-SD-NEXT:    mov h0, v0.h[2]
; CHECK-SD-NEXT:    str s1, [sp, #12]
; CHECK-SD-NEXT:    ldrh w8, [sp, #12]
; CHECK-SD-NEXT:    stur b0, [x0, #2]
; CHECK-SD-NEXT:    strh w8, [x0]
; CHECK-SD-NEXT:    add sp, sp, #16
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: v3i8:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    ldr w8, [x0]
; CHECK-GI-NEXT:    add x9, x0, #2
; CHECK-GI-NEXT:    fmov s0, w8
; CHECK-GI-NEXT:    add x8, x0, #1
; CHECK-GI-NEXT:    mov b1, v0.b[1]
; CHECK-GI-NEXT:    mov v2.b[0], v0.b[0]
; CHECK-GI-NEXT:    mov b0, v0.b[2]
; CHECK-GI-NEXT:    mov v2.b[1], v1.b[0]
; CHECK-GI-NEXT:    mov v2.b[2], v0.b[0]
; CHECK-GI-NEXT:    cnt v0.8b, v2.8b
; CHECK-GI-NEXT:    st1 { v0.b }[0], [x0]
; CHECK-GI-NEXT:    st1 { v0.b }[1], [x8]
; CHECK-GI-NEXT:    st1 { v0.b }[2], [x9]
; CHECK-GI-NEXT:    ret
entry:
  %d = load <3 x i8>, ptr %p1
  %s = call <3 x i8> @llvm.ctpop(<3 x i8> %d)
  store <3 x i8> %s, ptr %p1
  ret void
}

define void @v4i8(ptr %p1) {
; CHECK-SD-LABEL: v4i8:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    ldr s0, [x0]
; CHECK-SD-NEXT:    ushll v0.8h, v0.8b, #0
; CHECK-SD-NEXT:    cnt v0.8b, v0.8b
; CHECK-SD-NEXT:    uaddlp v0.4h, v0.8b
; CHECK-SD-NEXT:    uzp1 v0.8b, v0.8b, v0.8b
; CHECK-SD-NEXT:    str s0, [x0]
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: v4i8:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    ldr w8, [x0]
; CHECK-GI-NEXT:    fmov s0, w8
; CHECK-GI-NEXT:    mov b1, v0.b[1]
; CHECK-GI-NEXT:    mov v2.b[0], v0.b[0]
; CHECK-GI-NEXT:    mov b3, v0.b[2]
; CHECK-GI-NEXT:    mov b0, v0.b[3]
; CHECK-GI-NEXT:    mov v2.b[1], v1.b[0]
; CHECK-GI-NEXT:    mov v2.b[2], v3.b[0]
; CHECK-GI-NEXT:    mov v2.b[3], v0.b[0]
; CHECK-GI-NEXT:    cnt v0.8b, v2.8b
; CHECK-GI-NEXT:    fmov w8, s0
; CHECK-GI-NEXT:    str w8, [x0]
; CHECK-GI-NEXT:    ret
entry:
  %d = load <4 x i8>, ptr %p1
  %s = call <4 x i8> @llvm.ctpop(<4 x i8> %d)
  store <4 x i8> %s, ptr %p1
  ret void
}

define <8 x i8> @v8i8(<8 x i8> %d) {
; CHECK-LABEL: v8i8:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    cnt v0.8b, v0.8b
; CHECK-NEXT:    ret
entry:
  %s = call <8 x i8> @llvm.ctpop(<8 x i8> %d)
  ret <8 x i8> %s
}

define <16 x i8> @v16i8(<16 x i8> %d) {
; CHECK-LABEL: v16i8:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    cnt v0.16b, v0.16b
; CHECK-NEXT:    ret
entry:
  %s = call <16 x i8> @llvm.ctpop(<16 x i8> %d)
  ret <16 x i8> %s
}

define <32 x i8> @v32i8(<32 x i8> %d) {
; CHECK-LABEL: v32i8:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    cnt v0.16b, v0.16b
; CHECK-NEXT:    cnt v1.16b, v1.16b
; CHECK-NEXT:    ret
entry:
  %s = call <32 x i8> @llvm.ctpop(<32 x i8> %d)
  ret <32 x i8> %s
}

define void @v2i16(ptr %p1) {
; CHECK-SD-LABEL: v2i16:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    ldrh w8, [x0]
; CHECK-SD-NEXT:    ldrh w9, [x0, #2]
; CHECK-SD-NEXT:    fmov s0, w8
; CHECK-SD-NEXT:    mov v0.s[1], w9
; CHECK-SD-NEXT:    cnt v0.8b, v0.8b
; CHECK-SD-NEXT:    uaddlp v0.4h, v0.8b
; CHECK-SD-NEXT:    uaddlp v0.2s, v0.4h
; CHECK-SD-NEXT:    mov s1, v0.s[1]
; CHECK-SD-NEXT:    str h0, [x0]
; CHECK-SD-NEXT:    str h1, [x0, #2]
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: v2i16:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    ldr h0, [x0]
; CHECK-GI-NEXT:    add x8, x0, #2
; CHECK-GI-NEXT:    ld1 { v0.h }[1], [x8]
; CHECK-GI-NEXT:    cnt v0.8b, v0.8b
; CHECK-GI-NEXT:    uaddlp v0.4h, v0.8b
; CHECK-GI-NEXT:    str h0, [x0]
; CHECK-GI-NEXT:    st1 { v0.h }[1], [x8]
; CHECK-GI-NEXT:    ret
entry:
  %d = load <2 x i16>, ptr %p1
  %s = call <2 x i16> @llvm.ctpop(<2 x i16> %d)
  store <2 x i16> %s, ptr %p1
  ret void
}

define void @v3i16(ptr %p1) {
; CHECK-SD-LABEL: v3i16:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    ldr d0, [x0]
; CHECK-SD-NEXT:    cnt v0.8b, v0.8b
; CHECK-SD-NEXT:    uaddlp v0.4h, v0.8b
; CHECK-SD-NEXT:    mov h1, v0.h[2]
; CHECK-SD-NEXT:    str s0, [x0]
; CHECK-SD-NEXT:    str h1, [x0, #4]
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: v3i16:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    ldr d0, [x0]
; CHECK-GI-NEXT:    add x8, x0, #2
; CHECK-GI-NEXT:    add x9, x0, #4
; CHECK-GI-NEXT:    cnt v0.8b, v0.8b
; CHECK-GI-NEXT:    uaddlp v0.4h, v0.8b
; CHECK-GI-NEXT:    str h0, [x0]
; CHECK-GI-NEXT:    st1 { v0.h }[1], [x8]
; CHECK-GI-NEXT:    st1 { v0.h }[2], [x9]
; CHECK-GI-NEXT:    ret
entry:
  %d = load <3 x i16>, ptr %p1
  %s = call <3 x i16> @llvm.ctpop(<3 x i16> %d)
  store <3 x i16> %s, ptr %p1
  ret void
}

define <4 x i16> @v4i16(<4 x i16> %d) {
; CHECK-LABEL: v4i16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    cnt v0.8b, v0.8b
; CHECK-NEXT:    uaddlp v0.4h, v0.8b
; CHECK-NEXT:    ret
entry:
  %s = call <4 x i16> @llvm.ctpop(<4 x i16> %d)
  ret <4 x i16> %s
}

define <8 x i16> @v8i16(<8 x i16> %d) {
; CHECK-LABEL: v8i16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    cnt v0.16b, v0.16b
; CHECK-NEXT:    uaddlp v0.8h, v0.16b
; CHECK-NEXT:    ret
entry:
  %s = call <8 x i16> @llvm.ctpop(<8 x i16> %d)
  ret <8 x i16> %s
}

define <16 x i16> @v16i16(<16 x i16> %d) {
; CHECK-LABEL: v16i16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    cnt v0.16b, v0.16b
; CHECK-NEXT:    cnt v1.16b, v1.16b
; CHECK-NEXT:    uaddlp v0.8h, v0.16b
; CHECK-NEXT:    uaddlp v1.8h, v1.16b
; CHECK-NEXT:    ret
entry:
  %s = call <16 x i16> @llvm.ctpop(<16 x i16> %d)
  ret <16 x i16> %s
}

define <2 x i32> @v2i32(<2 x i32> %d) {
; CHECK-LABEL: v2i32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    cnt v0.8b, v0.8b
; CHECK-NEXT:    uaddlp v0.4h, v0.8b
; CHECK-NEXT:    uaddlp v0.2s, v0.4h
; CHECK-NEXT:    ret
entry:
  %s = call <2 x i32> @llvm.ctpop(<2 x i32> %d)
  ret <2 x i32> %s
}

define <3 x i32> @v3i32(<3 x i32> %d) {
; CHECK-LABEL: v3i32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    cnt v0.16b, v0.16b
; CHECK-NEXT:    uaddlp v0.8h, v0.16b
; CHECK-NEXT:    uaddlp v0.4s, v0.8h
; CHECK-NEXT:    ret
entry:
  %s = call <3 x i32> @llvm.ctpop(<3 x i32> %d)
  ret <3 x i32> %s
}

define <4 x i32> @v4i32(<4 x i32> %d) {
; CHECK-LABEL: v4i32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    cnt v0.16b, v0.16b
; CHECK-NEXT:    uaddlp v0.8h, v0.16b
; CHECK-NEXT:    uaddlp v0.4s, v0.8h
; CHECK-NEXT:    ret
entry:
  %s = call <4 x i32> @llvm.ctpop(<4 x i32> %d)
  ret <4 x i32> %s
}

define <8 x i32> @v8i32(<8 x i32> %d) {
; CHECK-LABEL: v8i32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    cnt v0.16b, v0.16b
; CHECK-NEXT:    cnt v1.16b, v1.16b
; CHECK-NEXT:    uaddlp v0.8h, v0.16b
; CHECK-NEXT:    uaddlp v1.8h, v1.16b
; CHECK-NEXT:    uaddlp v0.4s, v0.8h
; CHECK-NEXT:    uaddlp v1.4s, v1.8h
; CHECK-NEXT:    ret
entry:
  %s = call <8 x i32> @llvm.ctpop(<8 x i32> %d)
  ret <8 x i32> %s
}

define <2 x i64> @v2i64(<2 x i64> %d) {
; CHECK-LABEL: v2i64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    cnt v0.16b, v0.16b
; CHECK-NEXT:    uaddlp v0.8h, v0.16b
; CHECK-NEXT:    uaddlp v0.4s, v0.8h
; CHECK-NEXT:    uaddlp v0.2d, v0.4s
; CHECK-NEXT:    ret
entry:
  %s = call <2 x i64> @llvm.ctpop(<2 x i64> %d)
  ret <2 x i64> %s
}

define <3 x i64> @v3i64(<3 x i64> %d) {
; CHECK-SD-LABEL: v3i64:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-SD-NEXT:    // kill: def $d1 killed $d1 def $q1
; CHECK-SD-NEXT:    // kill: def $d2 killed $d2 def $q2
; CHECK-SD-NEXT:    mov v0.d[1], v1.d[0]
; CHECK-SD-NEXT:    cnt v1.16b, v2.16b
; CHECK-SD-NEXT:    cnt v0.16b, v0.16b
; CHECK-SD-NEXT:    uaddlp v1.8h, v1.16b
; CHECK-SD-NEXT:    uaddlp v2.4s, v1.8h
; CHECK-SD-NEXT:    uaddlp v0.8h, v0.16b
; CHECK-SD-NEXT:    uaddlp v2.2d, v2.4s
; CHECK-SD-NEXT:    uaddlp v0.4s, v0.8h
; CHECK-SD-NEXT:    // kill: def $d2 killed $d2 killed $q2
; CHECK-SD-NEXT:    uaddlp v0.2d, v0.4s
; CHECK-SD-NEXT:    ext v1.16b, v0.16b, v0.16b, #8
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-SD-NEXT:    // kill: def $d1 killed $d1 killed $q1
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: v3i64:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-GI-NEXT:    // kill: def $d1 killed $d1 def $q1
; CHECK-GI-NEXT:    mov v0.d[1], v1.d[0]
; CHECK-GI-NEXT:    cnt v1.8b, v2.8b
; CHECK-GI-NEXT:    cnt v0.16b, v0.16b
; CHECK-GI-NEXT:    uaddlv h1, v1.8b
; CHECK-GI-NEXT:    uaddlp v0.8h, v0.16b
; CHECK-GI-NEXT:    mov w8, v1.s[0]
; CHECK-GI-NEXT:    uaddlp v0.4s, v0.8h
; CHECK-GI-NEXT:    fmov d2, x8
; CHECK-GI-NEXT:    uaddlp v0.2d, v0.4s
; CHECK-GI-NEXT:    mov d1, v0.d[1]
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-GI-NEXT:    ret
entry:
  %s = call <3 x i64> @llvm.ctpop(<3 x i64> %d)
  ret <3 x i64> %s
}

define <4 x i64> @v4i64(<4 x i64> %d) {
; CHECK-LABEL: v4i64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    cnt v0.16b, v0.16b
; CHECK-NEXT:    cnt v1.16b, v1.16b
; CHECK-NEXT:    uaddlp v0.8h, v0.16b
; CHECK-NEXT:    uaddlp v1.8h, v1.16b
; CHECK-NEXT:    uaddlp v0.4s, v0.8h
; CHECK-NEXT:    uaddlp v1.4s, v1.8h
; CHECK-NEXT:    uaddlp v0.2d, v0.4s
; CHECK-NEXT:    uaddlp v1.2d, v1.4s
; CHECK-NEXT:    ret
entry:
  %s = call <4 x i64> @llvm.ctpop(<4 x i64> %d)
  ret <4 x i64> %s
}

define <2 x i128> @v2i128(<2 x i128> %d) {
; CHECK-SD-LABEL: v2i128:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    fmov d0, x2
; CHECK-SD-NEXT:    fmov d1, x0
; CHECK-SD-NEXT:    mov v1.d[1], x1
; CHECK-SD-NEXT:    mov v0.d[1], x3
; CHECK-SD-NEXT:    mov x1, xzr
; CHECK-SD-NEXT:    mov x3, xzr
; CHECK-SD-NEXT:    cnt v1.16b, v1.16b
; CHECK-SD-NEXT:    cnt v0.16b, v0.16b
; CHECK-SD-NEXT:    addv b1, v1.16b
; CHECK-SD-NEXT:    addv b0, v0.16b
; CHECK-SD-NEXT:    fmov x0, d1
; CHECK-SD-NEXT:    fmov x2, d0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: v2i128:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    mov v0.d[0], x0
; CHECK-GI-NEXT:    mov v1.d[0], x2
; CHECK-GI-NEXT:    mov v0.d[1], x1
; CHECK-GI-NEXT:    mov v1.d[1], x3
; CHECK-GI-NEXT:    mov x1, xzr
; CHECK-GI-NEXT:    mov x3, xzr
; CHECK-GI-NEXT:    cnt v0.16b, v0.16b
; CHECK-GI-NEXT:    cnt v1.16b, v1.16b
; CHECK-GI-NEXT:    uaddlv h0, v0.16b
; CHECK-GI-NEXT:    uaddlv h1, v1.16b
; CHECK-GI-NEXT:    mov w0, v0.s[0]
; CHECK-GI-NEXT:    mov w2, v1.s[0]
; CHECK-GI-NEXT:    ret
entry:
  %s = call <2 x i128> @llvm.ctpop(<2 x i128> %d)
  ret <2 x i128> %s
}

define <3 x i128> @v3i128(<3 x i128> %d) {
; CHECK-SD-LABEL: v3i128:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    fmov d0, x4
; CHECK-SD-NEXT:    fmov d1, x2
; CHECK-SD-NEXT:    fmov d2, x0
; CHECK-SD-NEXT:    mov v0.d[1], x5
; CHECK-SD-NEXT:    mov v1.d[1], x3
; CHECK-SD-NEXT:    mov v2.d[1], x1
; CHECK-SD-NEXT:    mov x1, xzr
; CHECK-SD-NEXT:    mov x3, xzr
; CHECK-SD-NEXT:    mov x5, xzr
; CHECK-SD-NEXT:    cnt v0.16b, v0.16b
; CHECK-SD-NEXT:    cnt v1.16b, v1.16b
; CHECK-SD-NEXT:    cnt v2.16b, v2.16b
; CHECK-SD-NEXT:    addv b0, v0.16b
; CHECK-SD-NEXT:    addv b1, v1.16b
; CHECK-SD-NEXT:    addv b2, v2.16b
; CHECK-SD-NEXT:    fmov x0, d2
; CHECK-SD-NEXT:    fmov x2, d1
; CHECK-SD-NEXT:    fmov x4, d0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: v3i128:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    mov v0.d[0], x0
; CHECK-GI-NEXT:    mov v1.d[0], x2
; CHECK-GI-NEXT:    mov v2.d[0], x4
; CHECK-GI-NEXT:    mov v0.d[1], x1
; CHECK-GI-NEXT:    mov v1.d[1], x3
; CHECK-GI-NEXT:    mov v2.d[1], x5
; CHECK-GI-NEXT:    mov x1, xzr
; CHECK-GI-NEXT:    mov x3, xzr
; CHECK-GI-NEXT:    mov x5, xzr
; CHECK-GI-NEXT:    cnt v0.16b, v0.16b
; CHECK-GI-NEXT:    cnt v1.16b, v1.16b
; CHECK-GI-NEXT:    cnt v2.16b, v2.16b
; CHECK-GI-NEXT:    uaddlv h0, v0.16b
; CHECK-GI-NEXT:    uaddlv h1, v1.16b
; CHECK-GI-NEXT:    uaddlv h2, v2.16b
; CHECK-GI-NEXT:    mov w0, v0.s[0]
; CHECK-GI-NEXT:    mov w2, v1.s[0]
; CHECK-GI-NEXT:    mov w4, v2.s[0]
; CHECK-GI-NEXT:    ret
entry:
  %s = call <3 x i128> @llvm.ctpop(<3 x i128> %d)
  ret <3 x i128> %s
}

define <4 x i128> @v4i128(<4 x i128> %d) {
; CHECK-SD-LABEL: v4i128:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    fmov d0, x6
; CHECK-SD-NEXT:    fmov d1, x4
; CHECK-SD-NEXT:    fmov d2, x2
; CHECK-SD-NEXT:    fmov d3, x0
; CHECK-SD-NEXT:    mov v1.d[1], x5
; CHECK-SD-NEXT:    mov v2.d[1], x3
; CHECK-SD-NEXT:    mov v0.d[1], x7
; CHECK-SD-NEXT:    mov v3.d[1], x1
; CHECK-SD-NEXT:    mov x1, xzr
; CHECK-SD-NEXT:    mov x3, xzr
; CHECK-SD-NEXT:    mov x5, xzr
; CHECK-SD-NEXT:    mov x7, xzr
; CHECK-SD-NEXT:    cnt v1.16b, v1.16b
; CHECK-SD-NEXT:    cnt v2.16b, v2.16b
; CHECK-SD-NEXT:    cnt v0.16b, v0.16b
; CHECK-SD-NEXT:    cnt v3.16b, v3.16b
; CHECK-SD-NEXT:    addv b1, v1.16b
; CHECK-SD-NEXT:    addv b2, v2.16b
; CHECK-SD-NEXT:    addv b0, v0.16b
; CHECK-SD-NEXT:    addv b3, v3.16b
; CHECK-SD-NEXT:    fmov x2, d2
; CHECK-SD-NEXT:    fmov x4, d1
; CHECK-SD-NEXT:    fmov x6, d0
; CHECK-SD-NEXT:    fmov x0, d3
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: v4i128:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    mov v0.d[0], x0
; CHECK-GI-NEXT:    mov v1.d[0], x2
; CHECK-GI-NEXT:    mov v2.d[0], x4
; CHECK-GI-NEXT:    mov v3.d[0], x6
; CHECK-GI-NEXT:    mov v0.d[1], x1
; CHECK-GI-NEXT:    mov v1.d[1], x3
; CHECK-GI-NEXT:    mov v2.d[1], x5
; CHECK-GI-NEXT:    mov v3.d[1], x7
; CHECK-GI-NEXT:    mov x1, xzr
; CHECK-GI-NEXT:    mov x3, xzr
; CHECK-GI-NEXT:    mov x5, xzr
; CHECK-GI-NEXT:    mov x7, xzr
; CHECK-GI-NEXT:    cnt v0.16b, v0.16b
; CHECK-GI-NEXT:    cnt v1.16b, v1.16b
; CHECK-GI-NEXT:    cnt v2.16b, v2.16b
; CHECK-GI-NEXT:    cnt v3.16b, v3.16b
; CHECK-GI-NEXT:    uaddlv h0, v0.16b
; CHECK-GI-NEXT:    uaddlv h1, v1.16b
; CHECK-GI-NEXT:    uaddlv h2, v2.16b
; CHECK-GI-NEXT:    uaddlv h3, v3.16b
; CHECK-GI-NEXT:    mov w0, v0.s[0]
; CHECK-GI-NEXT:    mov w2, v1.s[0]
; CHECK-GI-NEXT:    mov w4, v2.s[0]
; CHECK-GI-NEXT:    mov w6, v3.s[0]
; CHECK-GI-NEXT:    ret
entry:
  %s = call <4 x i128> @llvm.ctpop(<4 x i128> %d)
  ret <4 x i128> %s
}
