/*
 * Decompiled with CFR 0.152.
 */
package xni;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import org.apache.xerces.parsers.XMLDocumentParser;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.NamespaceContext;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLConfigurationException;
import org.apache.xerces.xni.parser.XMLErrorHandler;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.apache.xerces.xni.parser.XMLParseException;
import org.apache.xerces.xni.parser.XMLParserConfiguration;
import org.apache.xerces.xni.parser.XMLPullParserConfiguration;
import xni.ObjectFactory;

public class Writer
extends XMLDocumentParser
implements XMLErrorHandler {
    protected static final String NAMESPACES_FEATURE_ID = "http://xml.org/sax/features/namespaces";
    protected static final String VALIDATION_FEATURE_ID = "http://xml.org/sax/features/validation";
    protected static final String SCHEMA_VALIDATION_FEATURE_ID = "http://apache.org/xml/features/validation/schema";
    protected static final String SCHEMA_FULL_CHECKING_FEATURE_ID = "http://apache.org/xml/features/validation/schema-full-checking";
    protected static final String HONOUR_ALL_SCHEMA_LOCATIONS_ID = "http://apache.org/xml/features/honour-all-schemaLocations";
    protected static final String DEFAULT_PARSER_CONFIG = "org.apache.xerces.parsers.XIncludeAwareParserConfiguration";
    protected static final boolean DEFAULT_NAMESPACES = true;
    protected static final boolean DEFAULT_VALIDATION = false;
    protected static final boolean DEFAULT_SCHEMA_VALIDATION = false;
    protected static final boolean DEFAULT_SCHEMA_FULL_CHECKING = false;
    protected static final boolean DEFAULT_HONOUR_ALL_SCHEMA_LOCATIONS = false;
    protected static final boolean DEFAULT_CANONICAL = false;
    protected static final boolean DEFAULT_INCREMENTAL = false;
    protected PrintWriter fOut;
    protected boolean fCanonical;
    protected int fElementDepth;
    protected boolean fSeenRootElement;

    public Writer(XMLParserConfiguration xMLParserConfiguration) {
        super(xMLParserConfiguration);
        this.fConfiguration.setErrorHandler((XMLErrorHandler)this);
    }

    public void setCanonical(boolean bl) {
        this.fCanonical = bl;
    }

    public void setOutput(OutputStream outputStream, String string) throws UnsupportedEncodingException {
        if (string == null) {
            string = "UTF8";
        }
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, string);
        this.fOut = new PrintWriter(outputStreamWriter);
    }

    public void setOutput(java.io.Writer writer) {
        this.fOut = writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer);
    }

    public void startDocument(XMLLocator xMLLocator, String string, NamespaceContext namespaceContext, Augmentations augmentations) throws XNIException {
        this.fSeenRootElement = false;
        this.fElementDepth = 0;
        if (!this.fCanonical) {
            this.fOut.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            this.fOut.flush();
        }
    }

    public void startElement(QName qName, XMLAttributes xMLAttributes, Augmentations augmentations) throws XNIException {
        this.fSeenRootElement = true;
        ++this.fElementDepth;
        this.fOut.print('<');
        this.fOut.print(qName.rawname);
        if (xMLAttributes != null) {
            int n = xMLAttributes.getLength();
            for (int i = 0; i < n; ++i) {
                this.fOut.print(' ');
                this.fOut.print(xMLAttributes.getQName(i));
                this.fOut.print("=\"");
                this.normalizeAndPrint(xMLAttributes.getValue(i));
                this.fOut.print('\"');
            }
        }
        this.fOut.print('>');
        this.fOut.flush();
    }

    public void emptyElement(QName qName, XMLAttributes xMLAttributes, Augmentations augmentations) throws XNIException {
        this.fSeenRootElement = true;
        ++this.fElementDepth;
        this.fOut.print('<');
        this.fOut.print(qName.rawname);
        if (xMLAttributes != null) {
            int n = xMLAttributes.getLength();
            for (int i = 0; i < n; ++i) {
                this.fOut.print(' ');
                this.fOut.print(xMLAttributes.getQName(i));
                this.fOut.print("=\"");
                this.normalizeAndPrint(xMLAttributes.getValue(i));
                this.fOut.print('\"');
            }
        }
        this.fOut.print("/>");
        this.fOut.flush();
    }

    public void processingInstruction(String string, XMLString xMLString, Augmentations augmentations) throws XNIException {
        if (this.fSeenRootElement) {
            this.fOut.print('\n');
        }
        this.fOut.print("<?");
        this.fOut.print(string);
        if (xMLString != null && xMLString.length > 0) {
            this.fOut.print(' ');
            this.fOut.print(xMLString.toString());
        }
        this.fOut.print("?>");
        if (!this.fSeenRootElement) {
            this.fOut.print('\n');
        }
        this.fOut.flush();
    }

    public void comment(XMLString xMLString, Augmentations augmentations) throws XNIException {
        if (!this.fCanonical) {
            if (this.fSeenRootElement && this.fElementDepth == 0) {
                this.fOut.print('\n');
            }
            this.fOut.print("<!--");
            this.fOut.print(xMLString.toString());
            this.fOut.print("-->");
            if (!this.fSeenRootElement) {
                this.fOut.print('\n');
            }
            this.fOut.flush();
        }
    }

    public void characters(XMLString xMLString, Augmentations augmentations) throws XNIException {
        this.normalizeAndPrint(xMLString);
        this.fOut.flush();
    }

    public void ignorableWhitespace(XMLString xMLString, Augmentations augmentations) throws XNIException {
        this.characters(xMLString, augmentations);
        this.fOut.flush();
    }

    public void endElement(QName qName, Augmentations augmentations) throws XNIException {
        --this.fElementDepth;
        this.fOut.print("</");
        this.fOut.print(qName.rawname);
        this.fOut.print('>');
        this.fOut.flush();
    }

    public void startCDATA(Augmentations augmentations) throws XNIException {
    }

    public void endCDATA(Augmentations augmentations) throws XNIException {
    }

    public void warning(String string, String string2, XMLParseException xMLParseException) throws XNIException {
        this.printError("Warning", xMLParseException);
    }

    public void error(String string, String string2, XMLParseException xMLParseException) throws XNIException {
        this.printError("Error", xMLParseException);
    }

    public void fatalError(String string, String string2, XMLParseException xMLParseException) throws XNIException {
        this.printError("Fatal Error", xMLParseException);
        throw xMLParseException;
    }

    protected void normalizeAndPrint(String string) {
        int n = string != null ? string.length() : 0;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            this.normalizeAndPrint(c);
        }
    }

    protected void normalizeAndPrint(XMLString xMLString) {
        for (int i = 0; i < xMLString.length; ++i) {
            this.normalizeAndPrint(xMLString.ch[xMLString.offset + i]);
        }
    }

    protected void normalizeAndPrint(char c) {
        switch (c) {
            case '<': {
                this.fOut.print("&lt;");
                break;
            }
            case '>': {
                this.fOut.print("&gt;");
                break;
            }
            case '&': {
                this.fOut.print("&amp;");
                break;
            }
            case '\"': {
                this.fOut.print("&quot;");
                break;
            }
            case '\n': 
            case '\r': {
                if (this.fCanonical) {
                    this.fOut.print("&#");
                    this.fOut.print(Integer.toString(c));
                    this.fOut.print(';');
                    break;
                }
            }
            default: {
                this.fOut.print(c);
            }
        }
    }

    protected void printError(String string, XMLParseException xMLParseException) {
        System.err.print("[");
        System.err.print(string);
        System.err.print("] ");
        String string2 = xMLParseException.getExpandedSystemId();
        if (string2 != null) {
            int n = string2.lastIndexOf(47);
            if (n != -1) {
                string2 = string2.substring(n + 1);
            }
            System.err.print(string2);
        }
        System.err.print(':');
        System.err.print(xMLParseException.getLineNumber());
        System.err.print(':');
        System.err.print(xMLParseException.getColumnNumber());
        System.err.print(": ");
        System.err.print(xMLParseException.getMessage());
        System.err.println();
        System.err.flush();
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            Writer.printUsage();
            System.exit(1);
        }
        Writer writer = null;
        XMLParserConfiguration xMLParserConfiguration = null;
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        for (int i = 0; i < stringArray.length; ++i) {
            Object object;
            String string;
            block39: {
                block38: {
                    block37: {
                        string = stringArray[i];
                        if (string.startsWith("-")) {
                            object = string.substring(1);
                            if (((String)object).equals("p")) {
                                if (++i == stringArray.length) {
                                    System.err.println("error: Missing argument to -p option.");
                                }
                                String string2 = stringArray[i];
                                try {
                                    xMLParserConfiguration = (XMLParserConfiguration)ObjectFactory.newInstance(string2, ObjectFactory.findClassLoader(), true);
                                    writer = null;
                                }
                                catch (Exception exception) {
                                    xMLParserConfiguration = null;
                                    System.err.println("error: Unable to instantiate parser configuration (" + string2 + ")");
                                    exception.printStackTrace(System.err);
                                }
                                continue;
                            }
                            if (((String)object).equalsIgnoreCase("n")) {
                                bl = ((String)object).equals("n");
                                continue;
                            }
                            if (((String)object).equalsIgnoreCase("v")) {
                                bl2 = ((String)object).equals("v");
                                continue;
                            }
                            if (((String)object).equalsIgnoreCase("s")) {
                                bl3 = ((String)object).equals("s");
                                continue;
                            }
                            if (((String)object).equalsIgnoreCase("f")) {
                                bl4 = ((String)object).equals("f");
                                continue;
                            }
                            if (((String)object).equalsIgnoreCase("hs")) {
                                bl5 = ((String)object).equals("hs");
                                continue;
                            }
                            if (((String)object).equalsIgnoreCase("c")) {
                                bl6 = ((String)object).equals("c");
                                continue;
                            }
                            if (((String)object).equalsIgnoreCase("i")) {
                                bl7 = ((String)object).equals("i");
                                continue;
                            }
                            if (((String)object).equals("h")) {
                                Writer.printUsage();
                                continue;
                            }
                        }
                        if (xMLParserConfiguration == null) {
                            try {
                                xMLParserConfiguration = (XMLParserConfiguration)ObjectFactory.newInstance(DEFAULT_PARSER_CONFIG, ObjectFactory.findClassLoader(), true);
                            }
                            catch (Exception exception) {
                                System.err.println("error: Unable to instantiate parser configuration (org.apache.xerces.parsers.XIncludeAwareParserConfiguration)");
                                exception.printStackTrace(System.err);
                                continue;
                            }
                        }
                        if (writer == null) {
                            writer = new Writer(xMLParserConfiguration);
                        }
                        try {
                            xMLParserConfiguration.setFeature(NAMESPACES_FEATURE_ID, bl);
                        }
                        catch (XMLConfigurationException xMLConfigurationException) {
                            System.err.println("warning: Parser does not support feature (http://xml.org/sax/features/namespaces)");
                        }
                        try {
                            xMLParserConfiguration.setFeature(VALIDATION_FEATURE_ID, bl2);
                        }
                        catch (XMLConfigurationException xMLConfigurationException) {
                            System.err.println("warning: Parser does not support feature (http://xml.org/sax/features/validation)");
                        }
                        try {
                            xMLParserConfiguration.setFeature(SCHEMA_VALIDATION_FEATURE_ID, bl3);
                        }
                        catch (XMLConfigurationException xMLConfigurationException) {
                            if (xMLConfigurationException.getType() != 1) break block37;
                            System.err.println("warning: Parser does not support feature (http://apache.org/xml/features/validation/schema)");
                        }
                    }
                    try {
                        xMLParserConfiguration.setFeature(SCHEMA_FULL_CHECKING_FEATURE_ID, bl4);
                    }
                    catch (XMLConfigurationException xMLConfigurationException) {
                        if (xMLConfigurationException.getType() != 1) break block38;
                        System.err.println("warning: Parser does not support feature (http://apache.org/xml/features/validation/schema-full-checking)");
                    }
                }
                try {
                    xMLParserConfiguration.setFeature(HONOUR_ALL_SCHEMA_LOCATIONS_ID, bl5);
                }
                catch (XMLConfigurationException xMLConfigurationException) {
                    if (xMLConfigurationException.getType() != 1) break block39;
                    System.err.println("warning: Parser does not support feature (http://apache.org/xml/features/honour-all-schemaLocations)");
                }
            }
            try {
                writer.setOutput(System.out, "UTF8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                System.err.println("error: Unable to set output. Exiting.");
                System.exit(1);
            }
            writer.setCanonical(bl6);
            try {
                if (bl7 && xMLParserConfiguration instanceof XMLPullParserConfiguration) {
                    object = (XMLPullParserConfiguration)xMLParserConfiguration;
                    object.setInputSource(new XMLInputSource(null, string, null));
                    boolean bl8 = true;
                    while (object.parse(false)) {
                    }
                    continue;
                }
                writer.parse(new XMLInputSource(null, string, null));
                continue;
            }
            catch (XMLParseException xMLParseException) {
                continue;
            }
            catch (Exception exception) {
                System.err.println("error: Parse error occurred - " + exception.getMessage());
                if (exception instanceof XNIException) {
                    object = ((XNIException)exception).getException();
                }
                ((Throwable)object).printStackTrace(System.err);
            }
        }
    }

    private static void printUsage() {
        System.err.println("usage: java sax.Writer (options) uri ...");
        System.err.println();
        System.err.println("options:");
        System.err.println("  -p name     Select parser configuration by name.");
        System.err.println("  -n | -N     Turn on/off namespace processing.");
        System.err.println("  -v | -V     Turn on/off validation.");
        System.err.println("  -s | -S     Turn on/off Schema validation support.");
        System.err.println("              NOTE: Not supported by all parsers.");
        System.err.println("  -f  | -F    Turn on/off Schema full checking.");
        System.err.println("              NOTE: Requires use of -s and not supported by all parsers.");
        System.err.println("  -hs | -HS   Turn on/off honouring of all schema locations.");
        System.err.println("              NOTE: Requires use of -s and not supported by all parsers.");
        System.err.println("  -i | -I     Incremental mode.");
        System.err.println("              NOTE: This feature only works if the configuration used");
        System.err.println("                    implements XMLPullParserConfiguration.");
        System.err.println("  -h          This help screen.");
        System.err.println();
        System.err.println("defaults:");
        System.err.println("  Config:     org.apache.xerces.parsers.XIncludeAwareParserConfiguration");
        System.err.print("  Namespaces: ");
        System.err.println("on");
        System.err.print("  Validation: ");
        System.err.println("off");
        System.err.print("  Schema:     ");
        System.err.println("off");
        System.err.print("  Schema full checking:     ");
        System.err.println("off");
        System.err.print("  Honour all schema locations:     ");
        System.err.println("off");
        System.err.print("  Incremental:  ");
        System.err.println("off");
    }
}

