/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.coop;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.wicket.util.lang.Args;

public class CrossOriginOpenerPolicyConfiguration {
    private final Set<String> exemptions = new HashSet<String>();
    private final CoopMode mode;

    public CrossOriginOpenerPolicyConfiguration(CoopMode mode, String ... exemptions) {
        this.exemptions.addAll(Arrays.asList(exemptions));
        this.mode = Args.notNull(mode, "mode");
    }

    public CrossOriginOpenerPolicyConfiguration(CoopMode mode) {
        this.mode = Args.notNull(mode, "mode");
    }

    public CrossOriginOpenerPolicyConfiguration addExemptedPath(String path) {
        this.exemptions.add(path);
        return this;
    }

    public Set<String> getExemptions() {
        return this.exemptions;
    }

    public CoopMode getMode() {
        return this.mode;
    }

    public String getHeaderValue() {
        return this.mode.keyword;
    }

    public boolean isEnabled() {
        return this.mode != CoopMode.DISABLED;
    }

    public static enum CoopMode {
        UNSAFE_NONE("unsafe-none"),
        SAME_ORIGIN("same-origin"),
        SAME_ORIGIN_ALLOW_POPUPS("same-origin-allow-popups"),
        DISABLED("");

        final String keyword;

        private CoopMode(String keyword) {
            this.keyword = keyword;
        }
    }
}

