/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.breadcrumb;

import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.extensions.breadcrumb.IBreadCrumbModelListener;
import org.apache.wicket.extensions.breadcrumb.IBreadCrumbParticipant;
import org.apache.wicket.util.io.IClusterable;
import org.apache.wicket.util.lang.Args;

public final class BreadCrumbModelListenerSupport
implements IClusterable {
    private static final long serialVersionUID = 1L;
    private final List<IBreadCrumbModelListener> listeners = new ArrayList<IBreadCrumbModelListener>(1);

    public final void addListener(IBreadCrumbModelListener listener) {
        Args.notNull((Object)listener, (String)"listener");
        this.listeners.add(listener);
    }

    public final void fireBreadCrumbActivated(IBreadCrumbParticipant previousParticipant, IBreadCrumbParticipant breadCrumbParticipant) {
        for (IBreadCrumbModelListener listener : this.listeners) {
            listener.breadCrumbActivated(previousParticipant, breadCrumbParticipant);
        }
    }

    public final void fireBreadCrumbAdded(IBreadCrumbParticipant breadCrumbParticipant) {
        for (IBreadCrumbModelListener listener : this.listeners) {
            listener.breadCrumbAdded(breadCrumbParticipant);
        }
    }

    public final void fireBreadCrumbRemoved(IBreadCrumbParticipant breadCrumbParticipant) {
        for (IBreadCrumbModelListener listener : this.listeners) {
            listener.breadCrumbRemoved(breadCrumbParticipant);
        }
    }

    public final void removeListener(IBreadCrumbModelListener listener) {
        if (listener != null) {
            this.listeners.remove(listener);
        }
    }
}

