/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.guice;

import com.google.inject.BindingAnnotation;
import com.google.inject.Inject;
import jakarta.inject.Qualifier;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.concurrent.ConcurrentMap;
import org.apache.wicket.guice.GuiceProxyTargetLocator;
import org.apache.wicket.injection.IFieldValueFactory;
import org.apache.wicket.proxy.IProxyTargetLocator;
import org.apache.wicket.proxy.LazyInitProxyFactory;
import org.apache.wicket.util.lang.Generics;

public class GuiceFieldValueFactory
implements IFieldValueFactory {
    private final ConcurrentMap<GuiceProxyTargetLocator, Object> cache = Generics.newConcurrentHashMap();
    private static final Object NULL_SENTINEL = new Object();
    private final boolean wrapInProxies;

    GuiceFieldValueFactory(boolean wrapInProxies) {
        this.wrapInProxies = wrapInProxies;
    }

    public Object getFieldValue(Field field, Object fieldOwner) {
        Object target = null;
        if (this.supportsField(field)) {
            Inject injectAnnotation = field.getAnnotation(Inject.class);
            jakarta.inject.Inject jakartaInjectAnnotation = field.getAnnotation(jakarta.inject.Inject.class);
            if (!(Modifier.isStatic(field.getModifiers()) || injectAnnotation == null && jakartaInjectAnnotation == null)) {
                try {
                    Object tmpTarget;
                    boolean optional = injectAnnotation != null && injectAnnotation.optional();
                    Annotation bindingAnnotation = this.findBindingAnnotation(field.getAnnotations());
                    GuiceProxyTargetLocator locator = new GuiceProxyTargetLocator(field, bindingAnnotation, optional);
                    Object cachedValue = this.cache.get(locator);
                    if (cachedValue != null) {
                        return cachedValue == NULL_SENTINEL ? null : cachedValue;
                    }
                    target = locator.locateProxyTarget();
                    if (target != null && this.wrapInProxies) {
                        target = LazyInitProxyFactory.createProxy(field.getType(), (IProxyTargetLocator)locator);
                    }
                    if (locator.isSingletonScope() && (tmpTarget = this.cache.putIfAbsent(locator, target == null ? NULL_SENTINEL : target)) != null) {
                        target = tmpTarget;
                    }
                    if (!field.canAccess(fieldOwner)) {
                        field.setAccessible(true);
                    }
                }
                catch (MoreThanOneBindingException e) {
                    throw new RuntimeException("Can't have more than one BindingAnnotation on field " + field.getName() + " of class " + fieldOwner.getClass().getName());
                }
            }
        }
        return target == NULL_SENTINEL ? null : target;
    }

    public boolean supportsField(Field field) {
        return field.isAnnotationPresent(Inject.class) || field.isAnnotationPresent(jakarta.inject.Inject.class);
    }

    private Annotation findBindingAnnotation(Annotation[] annotations) throws MoreThanOneBindingException {
        Annotation bindingAnnotation = null;
        for (Annotation annotation : annotations) {
            if (annotation.annotationType().getAnnotation(BindingAnnotation.class) == null && annotation.annotationType().getAnnotation(Qualifier.class) == null) continue;
            if (bindingAnnotation != null) {
                throw new MoreThanOneBindingException();
            }
            bindingAnnotation = annotation;
        }
        return bindingAnnotation;
    }

    public static class MoreThanOneBindingException
    extends Exception {
        private static final long serialVersionUID = 1L;
    }
}

