/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.ajax.json;

import com.github.openjson.JSONArray;
import com.github.openjson.JSONException;
import com.github.openjson.JSONObject;
import java.util.List;
import java.util.Map;

public final class JsonUtils {
    private JsonUtils() {
    }

    public static JSONArray asArray(Map<String, Object> map) throws JSONException {
        JSONArray jsonArray = new JSONArray();
        if (map != null) {
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                String name = entry.getKey();
                Object value = entry.getValue();
                if (value instanceof List) {
                    List values = (List)value;
                    for (Object v : values) {
                        if (v == null) continue;
                        JSONObject object = new JSONObject();
                        object.put("name", (Object)name);
                        object.put("value", v);
                        jsonArray.put((Object)object);
                    }
                    continue;
                }
                if (value == null) continue;
                if (value.getClass().isArray()) {
                    Object[] array;
                    for (Object v : array = (Object[])value) {
                        if (v == null) continue;
                        JSONObject object = new JSONObject();
                        object.put("name", (Object)name);
                        object.put("value", v);
                        jsonArray.put((Object)object);
                    }
                    continue;
                }
                JSONObject object = new JSONObject();
                object.put("name", (Object)name);
                object.put("value", value);
                jsonArray.put((Object)object);
            }
        }
        return jsonArray;
    }
}

