/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.devutils.pagestore.browser;

import java.io.Serializable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Optional;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AbstractAjaxTimerBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.ajax.markup.html.AjaxFallbackLink;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.devutils.inspector.InspectorPage;
import org.apache.wicket.devutils.pagestore.browser.PersistedPagesProvider;
import org.apache.wicket.devutils.pagestore.browser.SessionIdentifiersModel;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.DataTable;
import org.apache.wicket.extensions.markup.html.repeater.data.table.DefaultDataTable;
import org.apache.wicket.extensions.markup.html.repeater.data.table.ISortableDataProvider;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.panel.GenericPanel;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.pageStore.DefaultPageContext;
import org.apache.wicket.pageStore.IPageContext;
import org.apache.wicket.pageStore.IPersistedPage;
import org.apache.wicket.pageStore.IPersistentPageStore;
import org.apache.wicket.request.component.IRequestablePage;

public class PersistedPanel
extends GenericPanel<IPersistentPageStore> {
    public PersistedPanel(String id, IModel<IPersistentPageStore> store) {
        super(id, store);
        final Label storeLabel = new Label("store", (IModel & Serializable)() -> {
            IPersistentPageStore s = (IPersistentPageStore)this.getModelObject();
            if (s == null) {
                return "N/A";
            }
            return String.format("%s - %s", s.getClass().getName(), s.getTotalSize());
        });
        storeLabel.setOutputMarkupId(true);
        this.add(new Component[]{storeLabel});
        final DropDownChoice<String> sessionsSelector = this.createSessionsSelector("sessions");
        sessionsSelector.setOutputMarkupId(true);
        this.add(new Component[]{sessionsSelector});
        final DataTable<IPersistedPage, String> table = this.createTable("table", (IModel<String>)sessionsSelector.getModel());
        table.setOutputMarkupId(true);
        this.add(new Component[]{table});
        AjaxFallbackLink<Void> refreshLink = new AjaxFallbackLink<Void>("refresh"){

            public void onClick(Optional<AjaxRequestTarget> targetOptional) {
                targetOptional.ifPresent(target -> target.add(new Component[]{table}));
            }
        };
        this.add(new Component[]{refreshLink});
        AjaxFallbackLink<Void> currentSessionLink = new AjaxFallbackLink<Void>("currentSessionLink"){

            public void onClick(Optional<AjaxRequestTarget> targetOptional) {
                sessionsSelector.setModelObject((Object)PersistedPanel.this.getCurrentSessionIdentifier());
                targetOptional.ifPresent(target -> target.add(new Component[]{sessionsSelector, table}));
            }

            public boolean isVisible() {
                return !PersistedPanel.this.getSession().isTemporary();
            }
        };
        currentSessionLink.setOutputMarkupPlaceholderTag(true);
        this.add(new Component[]{currentSessionLink});
        sessionsSelector.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("change"){

            protected void onUpdate(AjaxRequestTarget target) {
                target.add(new Component[]{storeLabel});
                target.add(new Component[]{sessionsSelector});
                target.add(new Component[]{table});
            }
        }});
        this.add(new Behavior[]{new AbstractAjaxTimerBehavior(Duration.ofSeconds(5L)){

            protected void onTimer(AjaxRequestTarget target) {
                target.add(new Component[]{storeLabel});
                target.add(new Component[]{table});
            }
        }});
    }

    private DropDownChoice<String> createSessionsSelector(String id) {
        DropDownChoice sessionsSelector = new DropDownChoice("sessions", (IModel)Model.of((Serializable)((Object)this.getCurrentSessionIdentifier())), (IModel)new SessionIdentifiersModel((IModel<IPersistentPageStore>)this.getModel()));
        return sessionsSelector;
    }

    private String getCurrentSessionIdentifier() {
        IPersistentPageStore store = (IPersistentPageStore)this.getModelObject();
        if (store == null) {
            return null;
        }
        DefaultPageContext context = new DefaultPageContext();
        return store.getSessionIdentifier((IPageContext)context);
    }

    private DataTable<IPersistedPage, String> createTable(String id, IModel<String> sessionId) {
        PersistedPagesProvider provider = new PersistedPagesProvider(sessionId, (IModel<IPersistentPageStore>)this.getModel());
        ArrayList<5> columns = new ArrayList<5>();
        columns.add(new AbstractColumn<IPersistedPage, String>((IModel)Model.of((Serializable)((Object)"Id")), "pageId"){

            public void populateItem(Item<ICellPopulator<IPersistedPage>> cellItem, String componentId, IModel<IPersistedPage> rowModel) {
                cellItem.add(new Component[]{new Link<IPersistedPage>(componentId, rowModel){

                    protected void onComponentTag(ComponentTag tag) {
                        tag.setName("a");
                        super.onComponentTag(tag);
                    }

                    public void onComponentTagBody(MarkupStream markupStream, ComponentTag openTag) {
                        this.replaceComponentTagBody(markupStream, openTag, "" + ((IPersistedPage)this.getModelObject()).getPageId());
                    }

                    public void onClick() {
                        this.setResponsePage((IRequestablePage)new InspectorPage(new PageReference(((IPersistedPage)this.getModelObject()).getPageId())));
                    }
                }});
            }
        });
        columns.add(new PropertyColumn((IModel)Model.of((Serializable)((Object)"Type")), (Object)"pageType", "pageType"));
        columns.add(new PropertyColumn((IModel)Model.of((Serializable)((Object)"Size")), (Object)"pageSize", "pageSize"));
        DefaultDataTable browserTable = new DefaultDataTable(id, columns, (ISortableDataProvider)provider, 20);
        browserTable.setOutputMarkupId(true);
        return browserTable;
    }
}

