/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.metrics.aspects.request;

import jakarta.servlet.http.HttpServletRequest;
import org.apache.wicket.metrics.WicketMetrics;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;

@Aspect
public class WicketFilterRequestCycleUrlAspect
extends WicketMetrics {
    @Around(value="execution(* org.apache.wicket.protocol.http.WicketFilter.processRequestCycle(..))")
    public Object aroundRequestProcessedWithURL(ProceedingJoinPoint joinPoint) throws Throwable {
        Object requestAsObject;
        Object[] args = joinPoint.getArgs();
        if (args.length >= 3 && (requestAsObject = args[2]) != null && requestAsObject instanceof HttpServletRequest) {
            HttpServletRequest httpServletRequest = (HttpServletRequest)requestAsObject;
            String requestUrl = httpServletRequest.getRequestURL().toString();
            String replacedUrl = requestUrl.replace('/', '_');
            replacedUrl = replacedUrl.replace('.', '_');
            replacedUrl = replacedUrl.replaceAll(";jsessionid=.*?(?=\\?|$)", "");
            return this.measureTime("core/application/request/" + replacedUrl, joinPoint, false);
        }
        return joinPoint.proceed();
    }
}

