/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.wicket.protocol.ws.api.registry;

import org.apache.wicket.util.io.IClusterable;

/**
 * A marker interface for keys that are used to find a web socket
 * connection in {@link IWebSocketConnectionRegistry}
 */
public interface IKey extends IClusterable
{
    /**
     * @return return a context for the key. This could be, for instance, a page class name or a resource class name.
     *    I.e. something that allow to discriminate keys along different pages.
     */
    String getContext();
}
