package de.averbis;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;

import org.apache.uima.UIMAException;
import org.apache.uima.UIMAFramework;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.fit.factory.JCasFactory;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.pear.tools.PackageBrowser;
import org.apache.uima.pear.tools.PackageInstaller;
import org.apache.uima.resource.PearSpecifier;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.InvalidXMLException;
import org.apache.uima.util.XMLInputSource;
import org.junit.Assert;
import org.junit.Test;

import de.averbis.types.Testannotation;

public class PearClassloaderSwitchTest {

	Path installationDirectoryPath = Paths.get("target/pearTest");
	Path pearPackageFilePath = Paths.get("target/annotatorone-1.0.0-SNAPSHOT.pear");


	@Test
	public void pearClassloaderSwitchTest() throws IOException, UIMAException {

		PackageBrowser packageBrowser = this.installPear();
		AnalysisEngine analysisEngine = this.produceAnalysisEngine(packageBrowser);

		JCas jCas = JCasFactory.createJCas();
		jCas.setDocumentText("Sampletext");
		analysisEngine.process(jCas);

		Collection<Testannotation> testannotations = JCasUtil.select(jCas, Testannotation.class);
		Assert.assertEquals(1, testannotations.size());
		for (Testannotation testannotation : testannotations) {

			Assert.assertEquals("test", testannotation.getTestfeature());
		}
	}


	private PackageBrowser installPear() {

		File installationDirectory = this.installationDirectoryPath.toFile();
		File pearPackageFile = this.pearPackageFilePath.toFile();
		boolean verify = true;
		boolean cleanInstallDirectory = true;

		return PackageInstaller.installPackage(installationDirectory, pearPackageFile, verify, cleanInstallDirectory);
	}


	private AnalysisEngine produceAnalysisEngine(PackageBrowser packageBrowser) throws IOException, InvalidXMLException, ResourceInitializationException {

		XMLInputSource xmlInputSource = new XMLInputSource(packageBrowser.getComponentPearDescPath());
		PearSpecifier parsePearSpecifier = UIMAFramework.getXMLParser().parsePearSpecifier(xmlInputSource);

		return UIMAFramework.produceAnalysisEngine(parsePearSpecifier);
	}
}